// Code generated by go-swagger; DO NOT EDIT.

package project_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-resource-manager/stable/2019-12-10/models"
	cloud "github.com/hashicorp/hcp-sdk-go/clients/cloud-shared/v1/models"
)

// ProjectServiceDeleteReader is a Reader for the ProjectServiceDelete structure.
type ProjectServiceDeleteReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *ProjectServiceDeleteReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewProjectServiceDeleteOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewProjectServiceDeleteDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewProjectServiceDeleteOK creates a ProjectServiceDeleteOK with default headers values
func NewProjectServiceDeleteOK() *ProjectServiceDeleteOK {
	return &ProjectServiceDeleteOK{}
}

/*
ProjectServiceDeleteOK describes a response with status code 200, with default header values.

A successful response.
*/
type ProjectServiceDeleteOK struct {
	Payload *models.HashicorpCloudResourcemanagerProjectDeleteResponse
}

// IsSuccess returns true when this project service delete o k response has a 2xx status code
func (o *ProjectServiceDeleteOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this project service delete o k response has a 3xx status code
func (o *ProjectServiceDeleteOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this project service delete o k response has a 4xx status code
func (o *ProjectServiceDeleteOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this project service delete o k response has a 5xx status code
func (o *ProjectServiceDeleteOK) IsServerError() bool {
	return false
}

// IsCode returns true when this project service delete o k response a status code equal to that given
func (o *ProjectServiceDeleteOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the project service delete o k response
func (o *ProjectServiceDeleteOK) Code() int {
	return 200
}

func (o *ProjectServiceDeleteOK) Error() string {
	return fmt.Sprintf("[DELETE /resource-manager/2019-12-10/projects/{id}][%d] projectServiceDeleteOK  %+v", 200, o.Payload)
}

func (o *ProjectServiceDeleteOK) String() string {
	return fmt.Sprintf("[DELETE /resource-manager/2019-12-10/projects/{id}][%d] projectServiceDeleteOK  %+v", 200, o.Payload)
}

func (o *ProjectServiceDeleteOK) GetPayload() *models.HashicorpCloudResourcemanagerProjectDeleteResponse {
	return o.Payload
}

func (o *ProjectServiceDeleteOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.HashicorpCloudResourcemanagerProjectDeleteResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewProjectServiceDeleteDefault creates a ProjectServiceDeleteDefault with default headers values
func NewProjectServiceDeleteDefault(code int) *ProjectServiceDeleteDefault {
	return &ProjectServiceDeleteDefault{
		_statusCode: code,
	}
}

/*
ProjectServiceDeleteDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type ProjectServiceDeleteDefault struct {
	_statusCode int

	Payload *cloud.GoogleRPCStatus
}

// IsSuccess returns true when this project service delete default response has a 2xx status code
func (o *ProjectServiceDeleteDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this project service delete default response has a 3xx status code
func (o *ProjectServiceDeleteDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this project service delete default response has a 4xx status code
func (o *ProjectServiceDeleteDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this project service delete default response has a 5xx status code
func (o *ProjectServiceDeleteDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this project service delete default response a status code equal to that given
func (o *ProjectServiceDeleteDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the project service delete default response
func (o *ProjectServiceDeleteDefault) Code() int {
	return o._statusCode
}

func (o *ProjectServiceDeleteDefault) Error() string {
	return fmt.Sprintf("[DELETE /resource-manager/2019-12-10/projects/{id}][%d] ProjectService_Delete default  %+v", o._statusCode, o.Payload)
}

func (o *ProjectServiceDeleteDefault) String() string {
	return fmt.Sprintf("[DELETE /resource-manager/2019-12-10/projects/{id}][%d] ProjectService_Delete default  %+v", o._statusCode, o.Payload)
}

func (o *ProjectServiceDeleteDefault) GetPayload() *cloud.GoogleRPCStatus {
	return o.Payload
}

func (o *ProjectServiceDeleteDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(cloud.GoogleRPCStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
