// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package apptest

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opCreateTestCase = "CreateTestCase"

// CreateTestCaseRequest generates a "aws/request.Request" representing the
// client's request for the CreateTestCase operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateTestCase for more information on using the CreateTestCase
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateTestCaseRequest method.
//	req, resp := client.CreateTestCaseRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apptest-2022-12-06/CreateTestCase
func (c *AppTest) CreateTestCaseRequest(input *CreateTestCaseInput) (req *request.Request, output *CreateTestCaseOutput) {
	op := &request.Operation{
		Name:       opCreateTestCase,
		HTTPMethod: "POST",
		HTTPPath:   "/testcase",
	}

	if input == nil {
		input = &CreateTestCaseInput{}
	}

	output = &CreateTestCaseOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateTestCase API operation for AWS Mainframe Modernization Application Testing.
//
// Creates a test case.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Mainframe Modernization Application Testing's
// API operation CreateTestCase for usage and error information.
//
// Returned Error Types:
//
//   - ServiceQuotaExceededException
//     One or more quotas for AWS Application Testing exceeds the limit.
//
//   - ThrottlingException
//     The number of requests made exceeds the limit.
//
//   - AccessDeniedException
//     The account or role doesn't have the right permissions to make the request.
//
//   - ValidationException
//     One or more parameter provided in the request is not valid.
//
//   - ConflictException
//     The parameters provided in the request conflict with existing resources.
//
//   - InternalServerException
//     An unexpected error occurred during the processing of the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apptest-2022-12-06/CreateTestCase
func (c *AppTest) CreateTestCase(input *CreateTestCaseInput) (*CreateTestCaseOutput, error) {
	req, out := c.CreateTestCaseRequest(input)
	return out, req.Send()
}

// CreateTestCaseWithContext is the same as CreateTestCase with the addition of
// the ability to pass a context and additional request options.
//
// See CreateTestCase for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppTest) CreateTestCaseWithContext(ctx aws.Context, input *CreateTestCaseInput, opts ...request.Option) (*CreateTestCaseOutput, error) {
	req, out := c.CreateTestCaseRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateTestConfiguration = "CreateTestConfiguration"

// CreateTestConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the CreateTestConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateTestConfiguration for more information on using the CreateTestConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateTestConfigurationRequest method.
//	req, resp := client.CreateTestConfigurationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apptest-2022-12-06/CreateTestConfiguration
func (c *AppTest) CreateTestConfigurationRequest(input *CreateTestConfigurationInput) (req *request.Request, output *CreateTestConfigurationOutput) {
	op := &request.Operation{
		Name:       opCreateTestConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/testconfiguration",
	}

	if input == nil {
		input = &CreateTestConfigurationInput{}
	}

	output = &CreateTestConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateTestConfiguration API operation for AWS Mainframe Modernization Application Testing.
//
// Creates a test configuration.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Mainframe Modernization Application Testing's
// API operation CreateTestConfiguration for usage and error information.
//
// Returned Error Types:
//
//   - ServiceQuotaExceededException
//     One or more quotas for AWS Application Testing exceeds the limit.
//
//   - ThrottlingException
//     The number of requests made exceeds the limit.
//
//   - AccessDeniedException
//     The account or role doesn't have the right permissions to make the request.
//
//   - ValidationException
//     One or more parameter provided in the request is not valid.
//
//   - ConflictException
//     The parameters provided in the request conflict with existing resources.
//
//   - InternalServerException
//     An unexpected error occurred during the processing of the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apptest-2022-12-06/CreateTestConfiguration
func (c *AppTest) CreateTestConfiguration(input *CreateTestConfigurationInput) (*CreateTestConfigurationOutput, error) {
	req, out := c.CreateTestConfigurationRequest(input)
	return out, req.Send()
}

// CreateTestConfigurationWithContext is the same as CreateTestConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See CreateTestConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppTest) CreateTestConfigurationWithContext(ctx aws.Context, input *CreateTestConfigurationInput, opts ...request.Option) (*CreateTestConfigurationOutput, error) {
	req, out := c.CreateTestConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateTestSuite = "CreateTestSuite"

// CreateTestSuiteRequest generates a "aws/request.Request" representing the
// client's request for the CreateTestSuite operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateTestSuite for more information on using the CreateTestSuite
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateTestSuiteRequest method.
//	req, resp := client.CreateTestSuiteRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apptest-2022-12-06/CreateTestSuite
func (c *AppTest) CreateTestSuiteRequest(input *CreateTestSuiteInput) (req *request.Request, output *CreateTestSuiteOutput) {
	op := &request.Operation{
		Name:       opCreateTestSuite,
		HTTPMethod: "POST",
		HTTPPath:   "/testsuite",
	}

	if input == nil {
		input = &CreateTestSuiteInput{}
	}

	output = &CreateTestSuiteOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateTestSuite API operation for AWS Mainframe Modernization Application Testing.
//
// Creates a test suite.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Mainframe Modernization Application Testing's
// API operation CreateTestSuite for usage and error information.
//
// Returned Error Types:
//
//   - ServiceQuotaExceededException
//     One or more quotas for AWS Application Testing exceeds the limit.
//
//   - ThrottlingException
//     The number of requests made exceeds the limit.
//
//   - AccessDeniedException
//     The account or role doesn't have the right permissions to make the request.
//
//   - ValidationException
//     One or more parameter provided in the request is not valid.
//
//   - ConflictException
//     The parameters provided in the request conflict with existing resources.
//
//   - InternalServerException
//     An unexpected error occurred during the processing of the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apptest-2022-12-06/CreateTestSuite
func (c *AppTest) CreateTestSuite(input *CreateTestSuiteInput) (*CreateTestSuiteOutput, error) {
	req, out := c.CreateTestSuiteRequest(input)
	return out, req.Send()
}

// CreateTestSuiteWithContext is the same as CreateTestSuite with the addition of
// the ability to pass a context and additional request options.
//
// See CreateTestSuite for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppTest) CreateTestSuiteWithContext(ctx aws.Context, input *CreateTestSuiteInput, opts ...request.Option) (*CreateTestSuiteOutput, error) {
	req, out := c.CreateTestSuiteRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteTestCase = "DeleteTestCase"

// DeleteTestCaseRequest generates a "aws/request.Request" representing the
// client's request for the DeleteTestCase operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteTestCase for more information on using the DeleteTestCase
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteTestCaseRequest method.
//	req, resp := client.DeleteTestCaseRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apptest-2022-12-06/DeleteTestCase
func (c *AppTest) DeleteTestCaseRequest(input *DeleteTestCaseInput) (req *request.Request, output *DeleteTestCaseOutput) {
	op := &request.Operation{
		Name:       opDeleteTestCase,
		HTTPMethod: "DELETE",
		HTTPPath:   "/testcases/{testCaseId}",
	}

	if input == nil {
		input = &DeleteTestCaseInput{}
	}

	output = &DeleteTestCaseOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteTestCase API operation for AWS Mainframe Modernization Application Testing.
//
// Deletes a test case.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Mainframe Modernization Application Testing's
// API operation DeleteTestCase for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The number of requests made exceeds the limit.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - AccessDeniedException
//     The account or role doesn't have the right permissions to make the request.
//
//   - ValidationException
//     One or more parameter provided in the request is not valid.
//
//   - ConflictException
//     The parameters provided in the request conflict with existing resources.
//
//   - InternalServerException
//     An unexpected error occurred during the processing of the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apptest-2022-12-06/DeleteTestCase
func (c *AppTest) DeleteTestCase(input *DeleteTestCaseInput) (*DeleteTestCaseOutput, error) {
	req, out := c.DeleteTestCaseRequest(input)
	return out, req.Send()
}

// DeleteTestCaseWithContext is the same as DeleteTestCase with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteTestCase for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppTest) DeleteTestCaseWithContext(ctx aws.Context, input *DeleteTestCaseInput, opts ...request.Option) (*DeleteTestCaseOutput, error) {
	req, out := c.DeleteTestCaseRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteTestConfiguration = "DeleteTestConfiguration"

// DeleteTestConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the DeleteTestConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteTestConfiguration for more information on using the DeleteTestConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteTestConfigurationRequest method.
//	req, resp := client.DeleteTestConfigurationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apptest-2022-12-06/DeleteTestConfiguration
func (c *AppTest) DeleteTestConfigurationRequest(input *DeleteTestConfigurationInput) (req *request.Request, output *DeleteTestConfigurationOutput) {
	op := &request.Operation{
		Name:       opDeleteTestConfiguration,
		HTTPMethod: "DELETE",
		HTTPPath:   "/testconfigurations/{testConfigurationId}",
	}

	if input == nil {
		input = &DeleteTestConfigurationInput{}
	}

	output = &DeleteTestConfigurationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteTestConfiguration API operation for AWS Mainframe Modernization Application Testing.
//
// Deletes a test configuration.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Mainframe Modernization Application Testing's
// API operation DeleteTestConfiguration for usage and error information.
//
// Returned Error Types:
//
//   - ServiceQuotaExceededException
//     One or more quotas for AWS Application Testing exceeds the limit.
//
//   - ThrottlingException
//     The number of requests made exceeds the limit.
//
//   - AccessDeniedException
//     The account or role doesn't have the right permissions to make the request.
//
//   - ValidationException
//     One or more parameter provided in the request is not valid.
//
//   - ConflictException
//     The parameters provided in the request conflict with existing resources.
//
//   - InternalServerException
//     An unexpected error occurred during the processing of the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apptest-2022-12-06/DeleteTestConfiguration
func (c *AppTest) DeleteTestConfiguration(input *DeleteTestConfigurationInput) (*DeleteTestConfigurationOutput, error) {
	req, out := c.DeleteTestConfigurationRequest(input)
	return out, req.Send()
}

// DeleteTestConfigurationWithContext is the same as DeleteTestConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteTestConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppTest) DeleteTestConfigurationWithContext(ctx aws.Context, input *DeleteTestConfigurationInput, opts ...request.Option) (*DeleteTestConfigurationOutput, error) {
	req, out := c.DeleteTestConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteTestRun = "DeleteTestRun"

// DeleteTestRunRequest generates a "aws/request.Request" representing the
// client's request for the DeleteTestRun operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteTestRun for more information on using the DeleteTestRun
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteTestRunRequest method.
//	req, resp := client.DeleteTestRunRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apptest-2022-12-06/DeleteTestRun
func (c *AppTest) DeleteTestRunRequest(input *DeleteTestRunInput) (req *request.Request, output *DeleteTestRunOutput) {
	op := &request.Operation{
		Name:       opDeleteTestRun,
		HTTPMethod: "DELETE",
		HTTPPath:   "/testruns/{testRunId}",
	}

	if input == nil {
		input = &DeleteTestRunInput{}
	}

	output = &DeleteTestRunOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteTestRun API operation for AWS Mainframe Modernization Application Testing.
//
// Deletes a test run.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Mainframe Modernization Application Testing's
// API operation DeleteTestRun for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The number of requests made exceeds the limit.
//
//   - AccessDeniedException
//     The account or role doesn't have the right permissions to make the request.
//
//   - ValidationException
//     One or more parameter provided in the request is not valid.
//
//   - ConflictException
//     The parameters provided in the request conflict with existing resources.
//
//   - InternalServerException
//     An unexpected error occurred during the processing of the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apptest-2022-12-06/DeleteTestRun
func (c *AppTest) DeleteTestRun(input *DeleteTestRunInput) (*DeleteTestRunOutput, error) {
	req, out := c.DeleteTestRunRequest(input)
	return out, req.Send()
}

// DeleteTestRunWithContext is the same as DeleteTestRun with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteTestRun for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppTest) DeleteTestRunWithContext(ctx aws.Context, input *DeleteTestRunInput, opts ...request.Option) (*DeleteTestRunOutput, error) {
	req, out := c.DeleteTestRunRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteTestSuite = "DeleteTestSuite"

// DeleteTestSuiteRequest generates a "aws/request.Request" representing the
// client's request for the DeleteTestSuite operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteTestSuite for more information on using the DeleteTestSuite
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteTestSuiteRequest method.
//	req, resp := client.DeleteTestSuiteRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apptest-2022-12-06/DeleteTestSuite
func (c *AppTest) DeleteTestSuiteRequest(input *DeleteTestSuiteInput) (req *request.Request, output *DeleteTestSuiteOutput) {
	op := &request.Operation{
		Name:       opDeleteTestSuite,
		HTTPMethod: "DELETE",
		HTTPPath:   "/testsuites/{testSuiteId}",
	}

	if input == nil {
		input = &DeleteTestSuiteInput{}
	}

	output = &DeleteTestSuiteOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteTestSuite API operation for AWS Mainframe Modernization Application Testing.
//
// Deletes a test suite.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Mainframe Modernization Application Testing's
// API operation DeleteTestSuite for usage and error information.
//
// Returned Error Types:
//
//   - ServiceQuotaExceededException
//     One or more quotas for AWS Application Testing exceeds the limit.
//
//   - ThrottlingException
//     The number of requests made exceeds the limit.
//
//   - AccessDeniedException
//     The account or role doesn't have the right permissions to make the request.
//
//   - ValidationException
//     One or more parameter provided in the request is not valid.
//
//   - ConflictException
//     The parameters provided in the request conflict with existing resources.
//
//   - InternalServerException
//     An unexpected error occurred during the processing of the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apptest-2022-12-06/DeleteTestSuite
func (c *AppTest) DeleteTestSuite(input *DeleteTestSuiteInput) (*DeleteTestSuiteOutput, error) {
	req, out := c.DeleteTestSuiteRequest(input)
	return out, req.Send()
}

// DeleteTestSuiteWithContext is the same as DeleteTestSuite with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteTestSuite for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppTest) DeleteTestSuiteWithContext(ctx aws.Context, input *DeleteTestSuiteInput, opts ...request.Option) (*DeleteTestSuiteOutput, error) {
	req, out := c.DeleteTestSuiteRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetTestCase = "GetTestCase"

// GetTestCaseRequest generates a "aws/request.Request" representing the
// client's request for the GetTestCase operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetTestCase for more information on using the GetTestCase
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetTestCaseRequest method.
//	req, resp := client.GetTestCaseRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apptest-2022-12-06/GetTestCase
func (c *AppTest) GetTestCaseRequest(input *GetTestCaseInput) (req *request.Request, output *GetTestCaseOutput) {
	op := &request.Operation{
		Name:       opGetTestCase,
		HTTPMethod: "GET",
		HTTPPath:   "/testcases/{testCaseId}",
	}

	if input == nil {
		input = &GetTestCaseInput{}
	}

	output = &GetTestCaseOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetTestCase API operation for AWS Mainframe Modernization Application Testing.
//
// Gets a test case.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Mainframe Modernization Application Testing's
// API operation GetTestCase for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The number of requests made exceeds the limit.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - AccessDeniedException
//     The account or role doesn't have the right permissions to make the request.
//
//   - ValidationException
//     One or more parameter provided in the request is not valid.
//
//   - InternalServerException
//     An unexpected error occurred during the processing of the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apptest-2022-12-06/GetTestCase
func (c *AppTest) GetTestCase(input *GetTestCaseInput) (*GetTestCaseOutput, error) {
	req, out := c.GetTestCaseRequest(input)
	return out, req.Send()
}

// GetTestCaseWithContext is the same as GetTestCase with the addition of
// the ability to pass a context and additional request options.
//
// See GetTestCase for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppTest) GetTestCaseWithContext(ctx aws.Context, input *GetTestCaseInput, opts ...request.Option) (*GetTestCaseOutput, error) {
	req, out := c.GetTestCaseRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetTestConfiguration = "GetTestConfiguration"

// GetTestConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the GetTestConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetTestConfiguration for more information on using the GetTestConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetTestConfigurationRequest method.
//	req, resp := client.GetTestConfigurationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apptest-2022-12-06/GetTestConfiguration
func (c *AppTest) GetTestConfigurationRequest(input *GetTestConfigurationInput) (req *request.Request, output *GetTestConfigurationOutput) {
	op := &request.Operation{
		Name:       opGetTestConfiguration,
		HTTPMethod: "GET",
		HTTPPath:   "/testconfigurations/{testConfigurationId}",
	}

	if input == nil {
		input = &GetTestConfigurationInput{}
	}

	output = &GetTestConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetTestConfiguration API operation for AWS Mainframe Modernization Application Testing.
//
// Gets a test configuration.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Mainframe Modernization Application Testing's
// API operation GetTestConfiguration for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The number of requests made exceeds the limit.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - AccessDeniedException
//     The account or role doesn't have the right permissions to make the request.
//
//   - ValidationException
//     One or more parameter provided in the request is not valid.
//
//   - InternalServerException
//     An unexpected error occurred during the processing of the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apptest-2022-12-06/GetTestConfiguration
func (c *AppTest) GetTestConfiguration(input *GetTestConfigurationInput) (*GetTestConfigurationOutput, error) {
	req, out := c.GetTestConfigurationRequest(input)
	return out, req.Send()
}

// GetTestConfigurationWithContext is the same as GetTestConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See GetTestConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppTest) GetTestConfigurationWithContext(ctx aws.Context, input *GetTestConfigurationInput, opts ...request.Option) (*GetTestConfigurationOutput, error) {
	req, out := c.GetTestConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetTestRunStep = "GetTestRunStep"

// GetTestRunStepRequest generates a "aws/request.Request" representing the
// client's request for the GetTestRunStep operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetTestRunStep for more information on using the GetTestRunStep
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetTestRunStepRequest method.
//	req, resp := client.GetTestRunStepRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apptest-2022-12-06/GetTestRunStep
func (c *AppTest) GetTestRunStepRequest(input *GetTestRunStepInput) (req *request.Request, output *GetTestRunStepOutput) {
	op := &request.Operation{
		Name:       opGetTestRunStep,
		HTTPMethod: "GET",
		HTTPPath:   "/testruns/{testRunId}/steps/{stepName}",
	}

	if input == nil {
		input = &GetTestRunStepInput{}
	}

	output = &GetTestRunStepOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetTestRunStep API operation for AWS Mainframe Modernization Application Testing.
//
// Gets a test run step.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Mainframe Modernization Application Testing's
// API operation GetTestRunStep for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The number of requests made exceeds the limit.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - AccessDeniedException
//     The account or role doesn't have the right permissions to make the request.
//
//   - ValidationException
//     One or more parameter provided in the request is not valid.
//
//   - InternalServerException
//     An unexpected error occurred during the processing of the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apptest-2022-12-06/GetTestRunStep
func (c *AppTest) GetTestRunStep(input *GetTestRunStepInput) (*GetTestRunStepOutput, error) {
	req, out := c.GetTestRunStepRequest(input)
	return out, req.Send()
}

// GetTestRunStepWithContext is the same as GetTestRunStep with the addition of
// the ability to pass a context and additional request options.
//
// See GetTestRunStep for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppTest) GetTestRunStepWithContext(ctx aws.Context, input *GetTestRunStepInput, opts ...request.Option) (*GetTestRunStepOutput, error) {
	req, out := c.GetTestRunStepRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetTestSuite = "GetTestSuite"

// GetTestSuiteRequest generates a "aws/request.Request" representing the
// client's request for the GetTestSuite operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetTestSuite for more information on using the GetTestSuite
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetTestSuiteRequest method.
//	req, resp := client.GetTestSuiteRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apptest-2022-12-06/GetTestSuite
func (c *AppTest) GetTestSuiteRequest(input *GetTestSuiteInput) (req *request.Request, output *GetTestSuiteOutput) {
	op := &request.Operation{
		Name:       opGetTestSuite,
		HTTPMethod: "GET",
		HTTPPath:   "/testsuites/{testSuiteId}",
	}

	if input == nil {
		input = &GetTestSuiteInput{}
	}

	output = &GetTestSuiteOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetTestSuite API operation for AWS Mainframe Modernization Application Testing.
//
// Gets a test suite.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Mainframe Modernization Application Testing's
// API operation GetTestSuite for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The number of requests made exceeds the limit.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - AccessDeniedException
//     The account or role doesn't have the right permissions to make the request.
//
//   - ValidationException
//     One or more parameter provided in the request is not valid.
//
//   - InternalServerException
//     An unexpected error occurred during the processing of the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apptest-2022-12-06/GetTestSuite
func (c *AppTest) GetTestSuite(input *GetTestSuiteInput) (*GetTestSuiteOutput, error) {
	req, out := c.GetTestSuiteRequest(input)
	return out, req.Send()
}

// GetTestSuiteWithContext is the same as GetTestSuite with the addition of
// the ability to pass a context and additional request options.
//
// See GetTestSuite for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppTest) GetTestSuiteWithContext(ctx aws.Context, input *GetTestSuiteInput, opts ...request.Option) (*GetTestSuiteOutput, error) {
	req, out := c.GetTestSuiteRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTagsForResourceRequest method.
//	req, resp := client.ListTagsForResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apptest-2022-12-06/ListTagsForResource
func (c *AppTest) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "GET",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for AWS Mainframe Modernization Application Testing.
//
// Lists tags for a resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Mainframe Modernization Application Testing's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The number of requests made exceeds the limit.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - AccessDeniedException
//     The account or role doesn't have the right permissions to make the request.
//
//   - ValidationException
//     One or more parameter provided in the request is not valid.
//
//   - InternalServerException
//     An unexpected error occurred during the processing of the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apptest-2022-12-06/ListTagsForResource
func (c *AppTest) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppTest) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListTestCases = "ListTestCases"

// ListTestCasesRequest generates a "aws/request.Request" representing the
// client's request for the ListTestCases operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTestCases for more information on using the ListTestCases
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTestCasesRequest method.
//	req, resp := client.ListTestCasesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apptest-2022-12-06/ListTestCases
func (c *AppTest) ListTestCasesRequest(input *ListTestCasesInput) (req *request.Request, output *ListTestCasesOutput) {
	op := &request.Operation{
		Name:       opListTestCases,
		HTTPMethod: "GET",
		HTTPPath:   "/testcases",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListTestCasesInput{}
	}

	output = &ListTestCasesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTestCases API operation for AWS Mainframe Modernization Application Testing.
//
// Lists test cases.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Mainframe Modernization Application Testing's
// API operation ListTestCases for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The number of requests made exceeds the limit.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - AccessDeniedException
//     The account or role doesn't have the right permissions to make the request.
//
//   - ValidationException
//     One or more parameter provided in the request is not valid.
//
//   - InternalServerException
//     An unexpected error occurred during the processing of the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apptest-2022-12-06/ListTestCases
func (c *AppTest) ListTestCases(input *ListTestCasesInput) (*ListTestCasesOutput, error) {
	req, out := c.ListTestCasesRequest(input)
	return out, req.Send()
}

// ListTestCasesWithContext is the same as ListTestCases with the addition of
// the ability to pass a context and additional request options.
//
// See ListTestCases for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppTest) ListTestCasesWithContext(ctx aws.Context, input *ListTestCasesInput, opts ...request.Option) (*ListTestCasesOutput, error) {
	req, out := c.ListTestCasesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListTestCasesPages iterates over the pages of a ListTestCases operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListTestCases method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListTestCases operation.
//	pageNum := 0
//	err := client.ListTestCasesPages(params,
//	    func(page *apptest.ListTestCasesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *AppTest) ListTestCasesPages(input *ListTestCasesInput, fn func(*ListTestCasesOutput, bool) bool) error {
	return c.ListTestCasesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListTestCasesPagesWithContext same as ListTestCasesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppTest) ListTestCasesPagesWithContext(ctx aws.Context, input *ListTestCasesInput, fn func(*ListTestCasesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListTestCasesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListTestCasesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListTestCasesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTestConfigurations = "ListTestConfigurations"

// ListTestConfigurationsRequest generates a "aws/request.Request" representing the
// client's request for the ListTestConfigurations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTestConfigurations for more information on using the ListTestConfigurations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTestConfigurationsRequest method.
//	req, resp := client.ListTestConfigurationsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apptest-2022-12-06/ListTestConfigurations
func (c *AppTest) ListTestConfigurationsRequest(input *ListTestConfigurationsInput) (req *request.Request, output *ListTestConfigurationsOutput) {
	op := &request.Operation{
		Name:       opListTestConfigurations,
		HTTPMethod: "GET",
		HTTPPath:   "/testconfigurations",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListTestConfigurationsInput{}
	}

	output = &ListTestConfigurationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTestConfigurations API operation for AWS Mainframe Modernization Application Testing.
//
// Lists test configurations.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Mainframe Modernization Application Testing's
// API operation ListTestConfigurations for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The number of requests made exceeds the limit.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - AccessDeniedException
//     The account or role doesn't have the right permissions to make the request.
//
//   - ValidationException
//     One or more parameter provided in the request is not valid.
//
//   - InternalServerException
//     An unexpected error occurred during the processing of the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apptest-2022-12-06/ListTestConfigurations
func (c *AppTest) ListTestConfigurations(input *ListTestConfigurationsInput) (*ListTestConfigurationsOutput, error) {
	req, out := c.ListTestConfigurationsRequest(input)
	return out, req.Send()
}

// ListTestConfigurationsWithContext is the same as ListTestConfigurations with the addition of
// the ability to pass a context and additional request options.
//
// See ListTestConfigurations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppTest) ListTestConfigurationsWithContext(ctx aws.Context, input *ListTestConfigurationsInput, opts ...request.Option) (*ListTestConfigurationsOutput, error) {
	req, out := c.ListTestConfigurationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListTestConfigurationsPages iterates over the pages of a ListTestConfigurations operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListTestConfigurations method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListTestConfigurations operation.
//	pageNum := 0
//	err := client.ListTestConfigurationsPages(params,
//	    func(page *apptest.ListTestConfigurationsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *AppTest) ListTestConfigurationsPages(input *ListTestConfigurationsInput, fn func(*ListTestConfigurationsOutput, bool) bool) error {
	return c.ListTestConfigurationsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListTestConfigurationsPagesWithContext same as ListTestConfigurationsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppTest) ListTestConfigurationsPagesWithContext(ctx aws.Context, input *ListTestConfigurationsInput, fn func(*ListTestConfigurationsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListTestConfigurationsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListTestConfigurationsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListTestConfigurationsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTestRunSteps = "ListTestRunSteps"

// ListTestRunStepsRequest generates a "aws/request.Request" representing the
// client's request for the ListTestRunSteps operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTestRunSteps for more information on using the ListTestRunSteps
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTestRunStepsRequest method.
//	req, resp := client.ListTestRunStepsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apptest-2022-12-06/ListTestRunSteps
func (c *AppTest) ListTestRunStepsRequest(input *ListTestRunStepsInput) (req *request.Request, output *ListTestRunStepsOutput) {
	op := &request.Operation{
		Name:       opListTestRunSteps,
		HTTPMethod: "GET",
		HTTPPath:   "/testruns/{testRunId}/steps",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListTestRunStepsInput{}
	}

	output = &ListTestRunStepsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTestRunSteps API operation for AWS Mainframe Modernization Application Testing.
//
// Lists test run steps.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Mainframe Modernization Application Testing's
// API operation ListTestRunSteps for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The number of requests made exceeds the limit.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - AccessDeniedException
//     The account or role doesn't have the right permissions to make the request.
//
//   - ValidationException
//     One or more parameter provided in the request is not valid.
//
//   - InternalServerException
//     An unexpected error occurred during the processing of the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apptest-2022-12-06/ListTestRunSteps
func (c *AppTest) ListTestRunSteps(input *ListTestRunStepsInput) (*ListTestRunStepsOutput, error) {
	req, out := c.ListTestRunStepsRequest(input)
	return out, req.Send()
}

// ListTestRunStepsWithContext is the same as ListTestRunSteps with the addition of
// the ability to pass a context and additional request options.
//
// See ListTestRunSteps for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppTest) ListTestRunStepsWithContext(ctx aws.Context, input *ListTestRunStepsInput, opts ...request.Option) (*ListTestRunStepsOutput, error) {
	req, out := c.ListTestRunStepsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListTestRunStepsPages iterates over the pages of a ListTestRunSteps operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListTestRunSteps method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListTestRunSteps operation.
//	pageNum := 0
//	err := client.ListTestRunStepsPages(params,
//	    func(page *apptest.ListTestRunStepsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *AppTest) ListTestRunStepsPages(input *ListTestRunStepsInput, fn func(*ListTestRunStepsOutput, bool) bool) error {
	return c.ListTestRunStepsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListTestRunStepsPagesWithContext same as ListTestRunStepsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppTest) ListTestRunStepsPagesWithContext(ctx aws.Context, input *ListTestRunStepsInput, fn func(*ListTestRunStepsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListTestRunStepsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListTestRunStepsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListTestRunStepsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTestRunTestCases = "ListTestRunTestCases"

// ListTestRunTestCasesRequest generates a "aws/request.Request" representing the
// client's request for the ListTestRunTestCases operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTestRunTestCases for more information on using the ListTestRunTestCases
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTestRunTestCasesRequest method.
//	req, resp := client.ListTestRunTestCasesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apptest-2022-12-06/ListTestRunTestCases
func (c *AppTest) ListTestRunTestCasesRequest(input *ListTestRunTestCasesInput) (req *request.Request, output *ListTestRunTestCasesOutput) {
	op := &request.Operation{
		Name:       opListTestRunTestCases,
		HTTPMethod: "GET",
		HTTPPath:   "/testruns/{testRunId}/testcases",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListTestRunTestCasesInput{}
	}

	output = &ListTestRunTestCasesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTestRunTestCases API operation for AWS Mainframe Modernization Application Testing.
//
// Lists test run test cases.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Mainframe Modernization Application Testing's
// API operation ListTestRunTestCases for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The number of requests made exceeds the limit.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - AccessDeniedException
//     The account or role doesn't have the right permissions to make the request.
//
//   - ValidationException
//     One or more parameter provided in the request is not valid.
//
//   - InternalServerException
//     An unexpected error occurred during the processing of the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apptest-2022-12-06/ListTestRunTestCases
func (c *AppTest) ListTestRunTestCases(input *ListTestRunTestCasesInput) (*ListTestRunTestCasesOutput, error) {
	req, out := c.ListTestRunTestCasesRequest(input)
	return out, req.Send()
}

// ListTestRunTestCasesWithContext is the same as ListTestRunTestCases with the addition of
// the ability to pass a context and additional request options.
//
// See ListTestRunTestCases for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppTest) ListTestRunTestCasesWithContext(ctx aws.Context, input *ListTestRunTestCasesInput, opts ...request.Option) (*ListTestRunTestCasesOutput, error) {
	req, out := c.ListTestRunTestCasesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListTestRunTestCasesPages iterates over the pages of a ListTestRunTestCases operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListTestRunTestCases method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListTestRunTestCases operation.
//	pageNum := 0
//	err := client.ListTestRunTestCasesPages(params,
//	    func(page *apptest.ListTestRunTestCasesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *AppTest) ListTestRunTestCasesPages(input *ListTestRunTestCasesInput, fn func(*ListTestRunTestCasesOutput, bool) bool) error {
	return c.ListTestRunTestCasesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListTestRunTestCasesPagesWithContext same as ListTestRunTestCasesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppTest) ListTestRunTestCasesPagesWithContext(ctx aws.Context, input *ListTestRunTestCasesInput, fn func(*ListTestRunTestCasesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListTestRunTestCasesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListTestRunTestCasesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListTestRunTestCasesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTestRuns = "ListTestRuns"

// ListTestRunsRequest generates a "aws/request.Request" representing the
// client's request for the ListTestRuns operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTestRuns for more information on using the ListTestRuns
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTestRunsRequest method.
//	req, resp := client.ListTestRunsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apptest-2022-12-06/ListTestRuns
func (c *AppTest) ListTestRunsRequest(input *ListTestRunsInput) (req *request.Request, output *ListTestRunsOutput) {
	op := &request.Operation{
		Name:       opListTestRuns,
		HTTPMethod: "GET",
		HTTPPath:   "/testruns",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListTestRunsInput{}
	}

	output = &ListTestRunsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTestRuns API operation for AWS Mainframe Modernization Application Testing.
//
// Lists test runs.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Mainframe Modernization Application Testing's
// API operation ListTestRuns for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The number of requests made exceeds the limit.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - AccessDeniedException
//     The account or role doesn't have the right permissions to make the request.
//
//   - ValidationException
//     One or more parameter provided in the request is not valid.
//
//   - InternalServerException
//     An unexpected error occurred during the processing of the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apptest-2022-12-06/ListTestRuns
func (c *AppTest) ListTestRuns(input *ListTestRunsInput) (*ListTestRunsOutput, error) {
	req, out := c.ListTestRunsRequest(input)
	return out, req.Send()
}

// ListTestRunsWithContext is the same as ListTestRuns with the addition of
// the ability to pass a context and additional request options.
//
// See ListTestRuns for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppTest) ListTestRunsWithContext(ctx aws.Context, input *ListTestRunsInput, opts ...request.Option) (*ListTestRunsOutput, error) {
	req, out := c.ListTestRunsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListTestRunsPages iterates over the pages of a ListTestRuns operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListTestRuns method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListTestRuns operation.
//	pageNum := 0
//	err := client.ListTestRunsPages(params,
//	    func(page *apptest.ListTestRunsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *AppTest) ListTestRunsPages(input *ListTestRunsInput, fn func(*ListTestRunsOutput, bool) bool) error {
	return c.ListTestRunsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListTestRunsPagesWithContext same as ListTestRunsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppTest) ListTestRunsPagesWithContext(ctx aws.Context, input *ListTestRunsInput, fn func(*ListTestRunsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListTestRunsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListTestRunsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListTestRunsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTestSuites = "ListTestSuites"

// ListTestSuitesRequest generates a "aws/request.Request" representing the
// client's request for the ListTestSuites operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTestSuites for more information on using the ListTestSuites
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTestSuitesRequest method.
//	req, resp := client.ListTestSuitesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apptest-2022-12-06/ListTestSuites
func (c *AppTest) ListTestSuitesRequest(input *ListTestSuitesInput) (req *request.Request, output *ListTestSuitesOutput) {
	op := &request.Operation{
		Name:       opListTestSuites,
		HTTPMethod: "GET",
		HTTPPath:   "/testsuites",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListTestSuitesInput{}
	}

	output = &ListTestSuitesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTestSuites API operation for AWS Mainframe Modernization Application Testing.
//
// Lists test suites.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Mainframe Modernization Application Testing's
// API operation ListTestSuites for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The number of requests made exceeds the limit.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - AccessDeniedException
//     The account or role doesn't have the right permissions to make the request.
//
//   - ValidationException
//     One or more parameter provided in the request is not valid.
//
//   - InternalServerException
//     An unexpected error occurred during the processing of the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apptest-2022-12-06/ListTestSuites
func (c *AppTest) ListTestSuites(input *ListTestSuitesInput) (*ListTestSuitesOutput, error) {
	req, out := c.ListTestSuitesRequest(input)
	return out, req.Send()
}

// ListTestSuitesWithContext is the same as ListTestSuites with the addition of
// the ability to pass a context and additional request options.
//
// See ListTestSuites for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppTest) ListTestSuitesWithContext(ctx aws.Context, input *ListTestSuitesInput, opts ...request.Option) (*ListTestSuitesOutput, error) {
	req, out := c.ListTestSuitesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListTestSuitesPages iterates over the pages of a ListTestSuites operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListTestSuites method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListTestSuites operation.
//	pageNum := 0
//	err := client.ListTestSuitesPages(params,
//	    func(page *apptest.ListTestSuitesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *AppTest) ListTestSuitesPages(input *ListTestSuitesInput, fn func(*ListTestSuitesOutput, bool) bool) error {
	return c.ListTestSuitesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListTestSuitesPagesWithContext same as ListTestSuitesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppTest) ListTestSuitesPagesWithContext(ctx aws.Context, input *ListTestSuitesInput, fn func(*ListTestSuitesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListTestSuitesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListTestSuitesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListTestSuitesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opStartTestRun = "StartTestRun"

// StartTestRunRequest generates a "aws/request.Request" representing the
// client's request for the StartTestRun operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartTestRun for more information on using the StartTestRun
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StartTestRunRequest method.
//	req, resp := client.StartTestRunRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apptest-2022-12-06/StartTestRun
func (c *AppTest) StartTestRunRequest(input *StartTestRunInput) (req *request.Request, output *StartTestRunOutput) {
	op := &request.Operation{
		Name:       opStartTestRun,
		HTTPMethod: "POST",
		HTTPPath:   "/testrun",
	}

	if input == nil {
		input = &StartTestRunInput{}
	}

	output = &StartTestRunOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartTestRun API operation for AWS Mainframe Modernization Application Testing.
//
// Starts a test run.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Mainframe Modernization Application Testing's
// API operation StartTestRun for usage and error information.
//
// Returned Error Types:
//
//   - ServiceQuotaExceededException
//     One or more quotas for AWS Application Testing exceeds the limit.
//
//   - ThrottlingException
//     The number of requests made exceeds the limit.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - AccessDeniedException
//     The account or role doesn't have the right permissions to make the request.
//
//   - ValidationException
//     One or more parameter provided in the request is not valid.
//
//   - ConflictException
//     The parameters provided in the request conflict with existing resources.
//
//   - InternalServerException
//     An unexpected error occurred during the processing of the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apptest-2022-12-06/StartTestRun
func (c *AppTest) StartTestRun(input *StartTestRunInput) (*StartTestRunOutput, error) {
	req, out := c.StartTestRunRequest(input)
	return out, req.Send()
}

// StartTestRunWithContext is the same as StartTestRun with the addition of
// the ability to pass a context and additional request options.
//
// See StartTestRun for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppTest) StartTestRunWithContext(ctx aws.Context, input *StartTestRunInput, opts ...request.Option) (*StartTestRunOutput, error) {
	req, out := c.StartTestRunRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the TagResourceRequest method.
//	req, resp := client.TagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apptest-2022-12-06/TagResource
func (c *AppTest) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for AWS Mainframe Modernization Application Testing.
//
// Specifies tags of a resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Mainframe Modernization Application Testing's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//
//   - ServiceQuotaExceededException
//     One or more quotas for AWS Application Testing exceeds the limit.
//
//   - ThrottlingException
//     The number of requests made exceeds the limit.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - AccessDeniedException
//     The account or role doesn't have the right permissions to make the request.
//
//   - ValidationException
//     One or more parameter provided in the request is not valid.
//
//   - InternalServerException
//     An unexpected error occurred during the processing of the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apptest-2022-12-06/TagResource
func (c *AppTest) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppTest) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UntagResourceRequest method.
//	req, resp := client.UntagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apptest-2022-12-06/UntagResource
func (c *AppTest) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "DELETE",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for AWS Mainframe Modernization Application Testing.
//
// Untags a resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Mainframe Modernization Application Testing's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The number of requests made exceeds the limit.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - AccessDeniedException
//     The account or role doesn't have the right permissions to make the request.
//
//   - ValidationException
//     One or more parameter provided in the request is not valid.
//
//   - InternalServerException
//     An unexpected error occurred during the processing of the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apptest-2022-12-06/UntagResource
func (c *AppTest) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppTest) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateTestCase = "UpdateTestCase"

// UpdateTestCaseRequest generates a "aws/request.Request" representing the
// client's request for the UpdateTestCase operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateTestCase for more information on using the UpdateTestCase
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateTestCaseRequest method.
//	req, resp := client.UpdateTestCaseRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apptest-2022-12-06/UpdateTestCase
func (c *AppTest) UpdateTestCaseRequest(input *UpdateTestCaseInput) (req *request.Request, output *UpdateTestCaseOutput) {
	op := &request.Operation{
		Name:       opUpdateTestCase,
		HTTPMethod: "PATCH",
		HTTPPath:   "/testcases/{testCaseId}",
	}

	if input == nil {
		input = &UpdateTestCaseInput{}
	}

	output = &UpdateTestCaseOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateTestCase API operation for AWS Mainframe Modernization Application Testing.
//
// Updates a test case.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Mainframe Modernization Application Testing's
// API operation UpdateTestCase for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The number of requests made exceeds the limit.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - AccessDeniedException
//     The account or role doesn't have the right permissions to make the request.
//
//   - ValidationException
//     One or more parameter provided in the request is not valid.
//
//   - ConflictException
//     The parameters provided in the request conflict with existing resources.
//
//   - InternalServerException
//     An unexpected error occurred during the processing of the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apptest-2022-12-06/UpdateTestCase
func (c *AppTest) UpdateTestCase(input *UpdateTestCaseInput) (*UpdateTestCaseOutput, error) {
	req, out := c.UpdateTestCaseRequest(input)
	return out, req.Send()
}

// UpdateTestCaseWithContext is the same as UpdateTestCase with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateTestCase for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppTest) UpdateTestCaseWithContext(ctx aws.Context, input *UpdateTestCaseInput, opts ...request.Option) (*UpdateTestCaseOutput, error) {
	req, out := c.UpdateTestCaseRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateTestConfiguration = "UpdateTestConfiguration"

// UpdateTestConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the UpdateTestConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateTestConfiguration for more information on using the UpdateTestConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateTestConfigurationRequest method.
//	req, resp := client.UpdateTestConfigurationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apptest-2022-12-06/UpdateTestConfiguration
func (c *AppTest) UpdateTestConfigurationRequest(input *UpdateTestConfigurationInput) (req *request.Request, output *UpdateTestConfigurationOutput) {
	op := &request.Operation{
		Name:       opUpdateTestConfiguration,
		HTTPMethod: "PATCH",
		HTTPPath:   "/testconfigurations/{testConfigurationId}",
	}

	if input == nil {
		input = &UpdateTestConfigurationInput{}
	}

	output = &UpdateTestConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateTestConfiguration API operation for AWS Mainframe Modernization Application Testing.
//
// Updates a test configuration.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Mainframe Modernization Application Testing's
// API operation UpdateTestConfiguration for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The number of requests made exceeds the limit.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - AccessDeniedException
//     The account or role doesn't have the right permissions to make the request.
//
//   - ValidationException
//     One or more parameter provided in the request is not valid.
//
//   - ConflictException
//     The parameters provided in the request conflict with existing resources.
//
//   - InternalServerException
//     An unexpected error occurred during the processing of the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apptest-2022-12-06/UpdateTestConfiguration
func (c *AppTest) UpdateTestConfiguration(input *UpdateTestConfigurationInput) (*UpdateTestConfigurationOutput, error) {
	req, out := c.UpdateTestConfigurationRequest(input)
	return out, req.Send()
}

// UpdateTestConfigurationWithContext is the same as UpdateTestConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateTestConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppTest) UpdateTestConfigurationWithContext(ctx aws.Context, input *UpdateTestConfigurationInput, opts ...request.Option) (*UpdateTestConfigurationOutput, error) {
	req, out := c.UpdateTestConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateTestSuite = "UpdateTestSuite"

// UpdateTestSuiteRequest generates a "aws/request.Request" representing the
// client's request for the UpdateTestSuite operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateTestSuite for more information on using the UpdateTestSuite
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateTestSuiteRequest method.
//	req, resp := client.UpdateTestSuiteRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apptest-2022-12-06/UpdateTestSuite
func (c *AppTest) UpdateTestSuiteRequest(input *UpdateTestSuiteInput) (req *request.Request, output *UpdateTestSuiteOutput) {
	op := &request.Operation{
		Name:       opUpdateTestSuite,
		HTTPMethod: "PATCH",
		HTTPPath:   "/testsuites/{testSuiteId}",
	}

	if input == nil {
		input = &UpdateTestSuiteInput{}
	}

	output = &UpdateTestSuiteOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateTestSuite API operation for AWS Mainframe Modernization Application Testing.
//
// Updates a test suite.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Mainframe Modernization Application Testing's
// API operation UpdateTestSuite for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The number of requests made exceeds the limit.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - AccessDeniedException
//     The account or role doesn't have the right permissions to make the request.
//
//   - ValidationException
//     One or more parameter provided in the request is not valid.
//
//   - ConflictException
//     The parameters provided in the request conflict with existing resources.
//
//   - InternalServerException
//     An unexpected error occurred during the processing of the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apptest-2022-12-06/UpdateTestSuite
func (c *AppTest) UpdateTestSuite(input *UpdateTestSuiteInput) (*UpdateTestSuiteOutput, error) {
	req, out := c.UpdateTestSuiteRequest(input)
	return out, req.Send()
}

// UpdateTestSuiteWithContext is the same as UpdateTestSuite with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateTestSuite for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppTest) UpdateTestSuiteWithContext(ctx aws.Context, input *UpdateTestSuiteInput, opts ...request.Option) (*UpdateTestSuiteOutput, error) {
	req, out := c.UpdateTestSuiteRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// The account or role doesn't have the right permissions to make the request.
type AccessDeniedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) GoString() string {
	return s.String()
}

func newErrorAccessDeniedException(v protocol.ResponseMetadata) error {
	return &AccessDeniedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AccessDeniedException) Code() string {
	return "AccessDeniedException"
}

// Message returns the exception's message.
func (s *AccessDeniedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AccessDeniedException) OrigErr() error {
	return nil
}

func (s *AccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AccessDeniedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AccessDeniedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Defines a batch.
type Batch struct {
	_ struct{} `type:"structure"`

	// The job name of the batch.
	//
	// BatchJobName is a required field
	BatchJobName *string `locationName:"batchJobName" type:"string" required:"true"`

	// The batch job parameters of the batch.
	BatchJobParameters map[string]*string `locationName:"batchJobParameters" type:"map"`

	// The export data set names of the batch.
	ExportDataSetNames []*string `locationName:"exportDataSetNames" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Batch) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Batch) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Batch) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Batch"}
	if s.BatchJobName == nil {
		invalidParams.Add(request.NewErrParamRequired("BatchJobName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBatchJobName sets the BatchJobName field's value.
func (s *Batch) SetBatchJobName(v string) *Batch {
	s.BatchJobName = &v
	return s
}

// SetBatchJobParameters sets the BatchJobParameters field's value.
func (s *Batch) SetBatchJobParameters(v map[string]*string) *Batch {
	s.BatchJobParameters = v
	return s
}

// SetExportDataSetNames sets the ExportDataSetNames field's value.
func (s *Batch) SetExportDataSetNames(v []*string) *Batch {
	s.ExportDataSetNames = v
	return s
}

// Defines a batch step input.
type BatchStepInput_ struct {
	_ struct{} `type:"structure"`

	// The batch job name of the batch step input.
	//
	// BatchJobName is a required field
	BatchJobName *string `locationName:"batchJobName" type:"string" required:"true"`

	// The batch job parameters of the batch step input.
	BatchJobParameters map[string]*string `locationName:"batchJobParameters" type:"map"`

	// The export data set names of the batch step input.
	ExportDataSetNames []*string `locationName:"exportDataSetNames" type:"list"`

	// The properties of the batch step input.
	Properties *MainframeActionProperties `locationName:"properties" type:"structure"`

	// The resource of the batch step input.
	//
	// Resource is a required field
	Resource *MainframeResourceSummary `locationName:"resource" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchStepInput_) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchStepInput_) GoString() string {
	return s.String()
}

// SetBatchJobName sets the BatchJobName field's value.
func (s *BatchStepInput_) SetBatchJobName(v string) *BatchStepInput_ {
	s.BatchJobName = &v
	return s
}

// SetBatchJobParameters sets the BatchJobParameters field's value.
func (s *BatchStepInput_) SetBatchJobParameters(v map[string]*string) *BatchStepInput_ {
	s.BatchJobParameters = v
	return s
}

// SetExportDataSetNames sets the ExportDataSetNames field's value.
func (s *BatchStepInput_) SetExportDataSetNames(v []*string) *BatchStepInput_ {
	s.ExportDataSetNames = v
	return s
}

// SetProperties sets the Properties field's value.
func (s *BatchStepInput_) SetProperties(v *MainframeActionProperties) *BatchStepInput_ {
	s.Properties = v
	return s
}

// SetResource sets the Resource field's value.
func (s *BatchStepInput_) SetResource(v *MainframeResourceSummary) *BatchStepInput_ {
	s.Resource = v
	return s
}

// Defines a batch step output.
type BatchStepOutput_ struct {
	_ struct{} `type:"structure"`

	// The data set details of the batch step output.
	DataSetDetails []*DataSet `locationName:"dataSetDetails" type:"list"`

	// The data set export location of the batch step output.
	DataSetExportLocation *string `locationName:"dataSetExportLocation" type:"string"`

	// The Database Migration Service (DMS) output location of the batch step output.
	DmsOutputLocation *string `locationName:"dmsOutputLocation" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchStepOutput_) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchStepOutput_) GoString() string {
	return s.String()
}

// SetDataSetDetails sets the DataSetDetails field's value.
func (s *BatchStepOutput_) SetDataSetDetails(v []*DataSet) *BatchStepOutput_ {
	s.DataSetDetails = v
	return s
}

// SetDataSetExportLocation sets the DataSetExportLocation field's value.
func (s *BatchStepOutput_) SetDataSetExportLocation(v string) *BatchStepOutput_ {
	s.DataSetExportLocation = &v
	return s
}

// SetDmsOutputLocation sets the DmsOutputLocation field's value.
func (s *BatchStepOutput_) SetDmsOutputLocation(v string) *BatchStepOutput_ {
	s.DmsOutputLocation = &v
	return s
}

// Summarizes a batch job.
type BatchSummary struct {
	_ struct{} `type:"structure"`

	// The step input of the batch summary.
	//
	// StepInput is a required field
	StepInput *BatchStepInput_ `locationName:"stepInput" type:"structure" required:"true"`

	// The step output of the batch summary.
	StepOutput *BatchStepOutput_ `locationName:"stepOutput" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchSummary) GoString() string {
	return s.String()
}

// SetStepInput sets the StepInput field's value.
func (s *BatchSummary) SetStepInput(v *BatchStepInput_) *BatchSummary {
	s.StepInput = v
	return s
}

// SetStepOutput sets the StepOutput field's value.
func (s *BatchSummary) SetStepOutput(v *BatchStepOutput_) *BatchSummary {
	s.StepOutput = v
	return s
}

// Specifies the CloudFormation template and its parameters.
type CloudFormation struct {
	_ struct{} `type:"structure"`

	// The CloudFormation properties in the CloudFormation template.
	Parameters map[string]*string `locationName:"parameters" type:"map"`

	// The template location of the CloudFormation template.
	//
	// TemplateLocation is a required field
	TemplateLocation *string `locationName:"templateLocation" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CloudFormation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CloudFormation) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CloudFormation) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CloudFormation"}
	if s.TemplateLocation == nil {
		invalidParams.Add(request.NewErrParamRequired("TemplateLocation"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetParameters sets the Parameters field's value.
func (s *CloudFormation) SetParameters(v map[string]*string) *CloudFormation {
	s.Parameters = v
	return s
}

// SetTemplateLocation sets the TemplateLocation field's value.
func (s *CloudFormation) SetTemplateLocation(v string) *CloudFormation {
	s.TemplateLocation = &v
	return s
}

// Specifies the CloudFormation action.
type CloudFormationAction struct {
	_ struct{} `type:"structure"`

	// The action type of the CloudFormation action.
	ActionType *string `locationName:"actionType" type:"string" enum:"CloudFormationActionType"`

	// The resource of the CloudFormation action.
	//
	// Resource is a required field
	Resource *string `locationName:"resource" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CloudFormationAction) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CloudFormationAction) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CloudFormationAction) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CloudFormationAction"}
	if s.Resource == nil {
		invalidParams.Add(request.NewErrParamRequired("Resource"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetActionType sets the ActionType field's value.
func (s *CloudFormationAction) SetActionType(v string) *CloudFormationAction {
	s.ActionType = &v
	return s
}

// SetResource sets the Resource field's value.
func (s *CloudFormationAction) SetResource(v string) *CloudFormationAction {
	s.Resource = &v
	return s
}

// Specifies the CloudFormation step summary.
type CloudFormationStepSummary struct {
	_ struct{} `type:"structure"`

	// Creates the CloudFormation summary of the step.
	CreateCloudformation *CreateCloudFormationSummary `locationName:"createCloudformation" type:"structure"`

	// Deletes the CloudFormation summary of the CloudFormation step summary.
	DeleteCloudformation *DeleteCloudFormationSummary `locationName:"deleteCloudformation" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CloudFormationStepSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CloudFormationStepSummary) GoString() string {
	return s.String()
}

// SetCreateCloudformation sets the CreateCloudformation field's value.
func (s *CloudFormationStepSummary) SetCreateCloudformation(v *CreateCloudFormationSummary) *CloudFormationStepSummary {
	s.CreateCloudformation = v
	return s
}

// SetDeleteCloudformation sets the DeleteCloudformation field's value.
func (s *CloudFormationStepSummary) SetDeleteCloudformation(v *DeleteCloudFormationSummary) *CloudFormationStepSummary {
	s.DeleteCloudformation = v
	return s
}

// Compares the action.
type CompareAction struct {
	_ struct{} `type:"structure"`

	// The input of the compare action.
	//
	// Input is a required field
	Input *Input_ `locationName:"input" type:"structure" required:"true"`

	// The output of the compare action.
	Output *Output_ `locationName:"output" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CompareAction) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CompareAction) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CompareAction) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CompareAction"}
	if s.Input == nil {
		invalidParams.Add(request.NewErrParamRequired("Input"))
	}
	if s.Input != nil {
		if err := s.Input.Validate(); err != nil {
			invalidParams.AddNested("Input", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInput sets the Input field's value.
func (s *CompareAction) SetInput(v *Input_) *CompareAction {
	s.Input = v
	return s
}

// SetOutput sets the Output field's value.
func (s *CompareAction) SetOutput(v *Output_) *CompareAction {
	s.Output = v
	return s
}

// Specifies the compare action summary.
type CompareActionSummary struct {
	_ struct{} `type:"structure"`

	// The type of the compare action summary.
	//
	// Type is a required field
	Type *File `locationName:"type" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CompareActionSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CompareActionSummary) GoString() string {
	return s.String()
}

// SetType sets the Type field's value.
func (s *CompareActionSummary) SetType(v *File) *CompareActionSummary {
	s.Type = v
	return s
}

// Specifies the compare data sets step input.
type CompareDataSetsStepInput_ struct {
	_ struct{} `type:"structure"`

	// The source data sets of the compare data sets step input location.
	//
	// SourceDataSets is a required field
	SourceDataSets []*DataSet `locationName:"sourceDataSets" type:"list" required:"true"`

	// The source location of the compare data sets step input location.
	//
	// SourceLocation is a required field
	SourceLocation *string `locationName:"sourceLocation" type:"string" required:"true"`

	// The target data sets of the compare data sets step input location.
	//
	// TargetDataSets is a required field
	TargetDataSets []*DataSet `locationName:"targetDataSets" type:"list" required:"true"`

	// The target location of the compare data sets step input location.
	//
	// TargetLocation is a required field
	TargetLocation *string `locationName:"targetLocation" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CompareDataSetsStepInput_) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CompareDataSetsStepInput_) GoString() string {
	return s.String()
}

// SetSourceDataSets sets the SourceDataSets field's value.
func (s *CompareDataSetsStepInput_) SetSourceDataSets(v []*DataSet) *CompareDataSetsStepInput_ {
	s.SourceDataSets = v
	return s
}

// SetSourceLocation sets the SourceLocation field's value.
func (s *CompareDataSetsStepInput_) SetSourceLocation(v string) *CompareDataSetsStepInput_ {
	s.SourceLocation = &v
	return s
}

// SetTargetDataSets sets the TargetDataSets field's value.
func (s *CompareDataSetsStepInput_) SetTargetDataSets(v []*DataSet) *CompareDataSetsStepInput_ {
	s.TargetDataSets = v
	return s
}

// SetTargetLocation sets the TargetLocation field's value.
func (s *CompareDataSetsStepInput_) SetTargetLocation(v string) *CompareDataSetsStepInput_ {
	s.TargetLocation = &v
	return s
}

// Specifies the compare data sets step output.
type CompareDataSetsStepOutput_ struct {
	_ struct{} `type:"structure"`

	// The comparison output location of the compare data sets step output.
	//
	// ComparisonOutputLocation is a required field
	ComparisonOutputLocation *string `locationName:"comparisonOutputLocation" type:"string" required:"true"`

	// The comparison status of the compare data sets step output.
	//
	// ComparisonStatus is a required field
	ComparisonStatus *string `locationName:"comparisonStatus" type:"string" required:"true" enum:"ComparisonStatusEnum"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CompareDataSetsStepOutput_) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CompareDataSetsStepOutput_) GoString() string {
	return s.String()
}

// SetComparisonOutputLocation sets the ComparisonOutputLocation field's value.
func (s *CompareDataSetsStepOutput_) SetComparisonOutputLocation(v string) *CompareDataSetsStepOutput_ {
	s.ComparisonOutputLocation = &v
	return s
}

// SetComparisonStatus sets the ComparisonStatus field's value.
func (s *CompareDataSetsStepOutput_) SetComparisonStatus(v string) *CompareDataSetsStepOutput_ {
	s.ComparisonStatus = &v
	return s
}

// Compares data sets summary.
type CompareDataSetsSummary struct {
	_ struct{} `type:"structure"`

	// The step input of the compare data sets summary.
	//
	// StepInput is a required field
	StepInput *CompareDataSetsStepInput_ `locationName:"stepInput" type:"structure" required:"true"`

	// The step output of the compare data sets summary.
	StepOutput *CompareDataSetsStepOutput_ `locationName:"stepOutput" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CompareDataSetsSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CompareDataSetsSummary) GoString() string {
	return s.String()
}

// SetStepInput sets the StepInput field's value.
func (s *CompareDataSetsSummary) SetStepInput(v *CompareDataSetsStepInput_) *CompareDataSetsSummary {
	s.StepInput = v
	return s
}

// SetStepOutput sets the StepOutput field's value.
func (s *CompareDataSetsSummary) SetStepOutput(v *CompareDataSetsStepOutput_) *CompareDataSetsSummary {
	s.StepOutput = v
	return s
}

// Compares the database Change Data Capture (CDC) step input.
type CompareDatabaseCDCStepInput_ struct {
	_ struct{} `type:"structure"`

	// The output location of the compare database CDC step input.
	OutputLocation *string `locationName:"outputLocation" type:"string"`

	// The source location of the compare database CDC step input.
	//
	// SourceLocation is a required field
	SourceLocation *string `locationName:"sourceLocation" type:"string" required:"true"`

	// The source metadata of the compare database CDC step input.
	//
	// SourceMetadata is a required field
	SourceMetadata *SourceDatabaseMetadata `locationName:"sourceMetadata" type:"structure" required:"true"`

	// The target location of the compare database CDC step input.
	//
	// TargetLocation is a required field
	TargetLocation *string `locationName:"targetLocation" type:"string" required:"true"`

	// The target metadata location of the compare database CDC step input.
	//
	// TargetMetadata is a required field
	TargetMetadata *TargetDatabaseMetadata `locationName:"targetMetadata" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CompareDatabaseCDCStepInput_) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CompareDatabaseCDCStepInput_) GoString() string {
	return s.String()
}

// SetOutputLocation sets the OutputLocation field's value.
func (s *CompareDatabaseCDCStepInput_) SetOutputLocation(v string) *CompareDatabaseCDCStepInput_ {
	s.OutputLocation = &v
	return s
}

// SetSourceLocation sets the SourceLocation field's value.
func (s *CompareDatabaseCDCStepInput_) SetSourceLocation(v string) *CompareDatabaseCDCStepInput_ {
	s.SourceLocation = &v
	return s
}

// SetSourceMetadata sets the SourceMetadata field's value.
func (s *CompareDatabaseCDCStepInput_) SetSourceMetadata(v *SourceDatabaseMetadata) *CompareDatabaseCDCStepInput_ {
	s.SourceMetadata = v
	return s
}

// SetTargetLocation sets the TargetLocation field's value.
func (s *CompareDatabaseCDCStepInput_) SetTargetLocation(v string) *CompareDatabaseCDCStepInput_ {
	s.TargetLocation = &v
	return s
}

// SetTargetMetadata sets the TargetMetadata field's value.
func (s *CompareDatabaseCDCStepInput_) SetTargetMetadata(v *TargetDatabaseMetadata) *CompareDatabaseCDCStepInput_ {
	s.TargetMetadata = v
	return s
}

// Compares the database CDC step output.
type CompareDatabaseCDCStepOutput_ struct {
	_ struct{} `type:"structure"`

	// The comparison output of the compare database CDC step output.
	//
	// ComparisonOutputLocation is a required field
	ComparisonOutputLocation *string `locationName:"comparisonOutputLocation" type:"string" required:"true"`

	// The comparison status of the compare database CDC step output.
	//
	// ComparisonStatus is a required field
	ComparisonStatus *string `locationName:"comparisonStatus" type:"string" required:"true" enum:"ComparisonStatusEnum"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CompareDatabaseCDCStepOutput_) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CompareDatabaseCDCStepOutput_) GoString() string {
	return s.String()
}

// SetComparisonOutputLocation sets the ComparisonOutputLocation field's value.
func (s *CompareDatabaseCDCStepOutput_) SetComparisonOutputLocation(v string) *CompareDatabaseCDCStepOutput_ {
	s.ComparisonOutputLocation = &v
	return s
}

// SetComparisonStatus sets the ComparisonStatus field's value.
func (s *CompareDatabaseCDCStepOutput_) SetComparisonStatus(v string) *CompareDatabaseCDCStepOutput_ {
	s.ComparisonStatus = &v
	return s
}

// Compares the database CDC summary.
type CompareDatabaseCDCSummary struct {
	_ struct{} `type:"structure"`

	// The step input of the compare database CDC summary.
	//
	// StepInput is a required field
	StepInput *CompareDatabaseCDCStepInput_ `locationName:"stepInput" type:"structure" required:"true"`

	// The step output of the compare database CDC summary.
	StepOutput *CompareDatabaseCDCStepOutput_ `locationName:"stepOutput" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CompareDatabaseCDCSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CompareDatabaseCDCSummary) GoString() string {
	return s.String()
}

// SetStepInput sets the StepInput field's value.
func (s *CompareDatabaseCDCSummary) SetStepInput(v *CompareDatabaseCDCStepInput_) *CompareDatabaseCDCSummary {
	s.StepInput = v
	return s
}

// SetStepOutput sets the StepOutput field's value.
func (s *CompareDatabaseCDCSummary) SetStepOutput(v *CompareDatabaseCDCStepOutput_) *CompareDatabaseCDCSummary {
	s.StepOutput = v
	return s
}

// Compares the file type.
type CompareFileType struct {
	_ struct{} `type:"structure"`

	// The database CDC of the compare file type.
	DatabaseCDC *CompareDatabaseCDCSummary `locationName:"databaseCDC" type:"structure"`

	// The data sets in the compare file type.
	Datasets *CompareDataSetsSummary `locationName:"datasets" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CompareFileType) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CompareFileType) GoString() string {
	return s.String()
}

// SetDatabaseCDC sets the DatabaseCDC field's value.
func (s *CompareFileType) SetDatabaseCDC(v *CompareDatabaseCDCSummary) *CompareFileType {
	s.DatabaseCDC = v
	return s
}

// SetDatasets sets the Datasets field's value.
func (s *CompareFileType) SetDatasets(v *CompareDataSetsSummary) *CompareFileType {
	s.Datasets = v
	return s
}

// The parameters provided in the request conflict with existing resources.
type ConflictException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`

	// The resource ID of the conflicts with existing resources.
	ResourceId *string `locationName:"resourceId" type:"string"`

	// The resource type of the conflicts with existing resources.
	ResourceType *string `locationName:"resourceType" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) GoString() string {
	return s.String()
}

func newErrorConflictException(v protocol.ResponseMetadata) error {
	return &ConflictException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConflictException) Code() string {
	return "ConflictException"
}

// Message returns the exception's message.
func (s *ConflictException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConflictException) OrigErr() error {
	return nil
}

func (s *ConflictException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConflictException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConflictException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Creates the CloudFormation step input.
type CreateCloudFormationStepInput_ struct {
	_ struct{} `type:"structure"`

	// The CloudFormation properties of the CloudFormation step input.
	Parameters map[string]*string `locationName:"parameters" type:"map"`

	// The template location of the CloudFormation step input.
	//
	// TemplateLocation is a required field
	TemplateLocation *string `locationName:"templateLocation" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateCloudFormationStepInput_) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateCloudFormationStepInput_) GoString() string {
	return s.String()
}

// SetParameters sets the Parameters field's value.
func (s *CreateCloudFormationStepInput_) SetParameters(v map[string]*string) *CreateCloudFormationStepInput_ {
	s.Parameters = v
	return s
}

// SetTemplateLocation sets the TemplateLocation field's value.
func (s *CreateCloudFormationStepInput_) SetTemplateLocation(v string) *CreateCloudFormationStepInput_ {
	s.TemplateLocation = &v
	return s
}

// Creates a CloudFormation step output.
type CreateCloudFormationStepOutput_ struct {
	_ struct{} `type:"structure"`

	// The exports of the CloudFormation step output.
	Exports map[string]*string `locationName:"exports" type:"map"`

	// The stack ID of the CloudFormation step output.
	//
	// StackId is a required field
	StackId *string `locationName:"stackId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateCloudFormationStepOutput_) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateCloudFormationStepOutput_) GoString() string {
	return s.String()
}

// SetExports sets the Exports field's value.
func (s *CreateCloudFormationStepOutput_) SetExports(v map[string]*string) *CreateCloudFormationStepOutput_ {
	s.Exports = v
	return s
}

// SetStackId sets the StackId field's value.
func (s *CreateCloudFormationStepOutput_) SetStackId(v string) *CreateCloudFormationStepOutput_ {
	s.StackId = &v
	return s
}

// Creates a CloudFormation summary.
type CreateCloudFormationSummary struct {
	_ struct{} `type:"structure"`

	// The step input of the CloudFormation summary.
	//
	// StepInput is a required field
	StepInput *CreateCloudFormationStepInput_ `locationName:"stepInput" type:"structure" required:"true"`

	// The step output of the CloudFormation summary.
	StepOutput *CreateCloudFormationStepOutput_ `locationName:"stepOutput" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateCloudFormationSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateCloudFormationSummary) GoString() string {
	return s.String()
}

// SetStepInput sets the StepInput field's value.
func (s *CreateCloudFormationSummary) SetStepInput(v *CreateCloudFormationStepInput_) *CreateCloudFormationSummary {
	s.StepInput = v
	return s
}

// SetStepOutput sets the StepOutput field's value.
func (s *CreateCloudFormationSummary) SetStepOutput(v *CreateCloudFormationStepOutput_) *CreateCloudFormationSummary {
	s.StepOutput = v
	return s
}

type CreateTestCaseInput struct {
	_ struct{} `type:"structure"`

	// The client token of the test case.
	ClientToken *string `locationName:"clientToken" type:"string" idempotencyToken:"true"`

	// The description of the test case.
	Description *string `locationName:"description" type:"string"`

	// The name of the test case.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// The steps in the test case.
	//
	// Steps is a required field
	Steps []*Step `locationName:"steps" min:"1" type:"list" required:"true"`

	// The specified tags of the test case.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateTestCaseInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateTestCaseInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateTestCaseInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateTestCaseInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Steps == nil {
		invalidParams.Add(request.NewErrParamRequired("Steps"))
	}
	if s.Steps != nil && len(s.Steps) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Steps", 1))
	}
	if s.Steps != nil {
		for i, v := range s.Steps {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Steps", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateTestCaseInput) SetClientToken(v string) *CreateTestCaseInput {
	s.ClientToken = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateTestCaseInput) SetDescription(v string) *CreateTestCaseInput {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateTestCaseInput) SetName(v string) *CreateTestCaseInput {
	s.Name = &v
	return s
}

// SetSteps sets the Steps field's value.
func (s *CreateTestCaseInput) SetSteps(v []*Step) *CreateTestCaseInput {
	s.Steps = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateTestCaseInput) SetTags(v map[string]*string) *CreateTestCaseInput {
	s.Tags = v
	return s
}

type CreateTestCaseOutput struct {
	_ struct{} `type:"structure"`

	// The test case ID of the test case.
	//
	// TestCaseId is a required field
	TestCaseId *string `locationName:"testCaseId" type:"string" required:"true"`

	// The test case version of the test case.
	//
	// TestCaseVersion is a required field
	TestCaseVersion *int64 `locationName:"testCaseVersion" type:"integer" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateTestCaseOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateTestCaseOutput) GoString() string {
	return s.String()
}

// SetTestCaseId sets the TestCaseId field's value.
func (s *CreateTestCaseOutput) SetTestCaseId(v string) *CreateTestCaseOutput {
	s.TestCaseId = &v
	return s
}

// SetTestCaseVersion sets the TestCaseVersion field's value.
func (s *CreateTestCaseOutput) SetTestCaseVersion(v int64) *CreateTestCaseOutput {
	s.TestCaseVersion = &v
	return s
}

type CreateTestConfigurationInput struct {
	_ struct{} `type:"structure"`

	// The client token of the test configuration.
	ClientToken *string `locationName:"clientToken" type:"string" idempotencyToken:"true"`

	// The description of the test configuration.
	Description *string `locationName:"description" type:"string"`

	// The name of the test configuration.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// The properties of the test configuration.
	Properties map[string]*string `locationName:"properties" type:"map"`

	// The defined resources of the test configuration.
	//
	// Resources is a required field
	Resources []*Resource `locationName:"resources" min:"1" type:"list" required:"true"`

	// The service settings of the test configuration.
	ServiceSettings *ServiceSettings `locationName:"serviceSettings" type:"structure"`

	// The tags of the test configuration.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateTestConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateTestConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateTestConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateTestConfigurationInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Resources == nil {
		invalidParams.Add(request.NewErrParamRequired("Resources"))
	}
	if s.Resources != nil && len(s.Resources) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Resources", 1))
	}
	if s.Resources != nil {
		for i, v := range s.Resources {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Resources", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateTestConfigurationInput) SetClientToken(v string) *CreateTestConfigurationInput {
	s.ClientToken = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateTestConfigurationInput) SetDescription(v string) *CreateTestConfigurationInput {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateTestConfigurationInput) SetName(v string) *CreateTestConfigurationInput {
	s.Name = &v
	return s
}

// SetProperties sets the Properties field's value.
func (s *CreateTestConfigurationInput) SetProperties(v map[string]*string) *CreateTestConfigurationInput {
	s.Properties = v
	return s
}

// SetResources sets the Resources field's value.
func (s *CreateTestConfigurationInput) SetResources(v []*Resource) *CreateTestConfigurationInput {
	s.Resources = v
	return s
}

// SetServiceSettings sets the ServiceSettings field's value.
func (s *CreateTestConfigurationInput) SetServiceSettings(v *ServiceSettings) *CreateTestConfigurationInput {
	s.ServiceSettings = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateTestConfigurationInput) SetTags(v map[string]*string) *CreateTestConfigurationInput {
	s.Tags = v
	return s
}

type CreateTestConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// The test configuration ID.
	//
	// TestConfigurationId is a required field
	TestConfigurationId *string `locationName:"testConfigurationId" type:"string" required:"true"`

	// The test configuration version.
	//
	// TestConfigurationVersion is a required field
	TestConfigurationVersion *int64 `locationName:"testConfigurationVersion" type:"integer" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateTestConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateTestConfigurationOutput) GoString() string {
	return s.String()
}

// SetTestConfigurationId sets the TestConfigurationId field's value.
func (s *CreateTestConfigurationOutput) SetTestConfigurationId(v string) *CreateTestConfigurationOutput {
	s.TestConfigurationId = &v
	return s
}

// SetTestConfigurationVersion sets the TestConfigurationVersion field's value.
func (s *CreateTestConfigurationOutput) SetTestConfigurationVersion(v int64) *CreateTestConfigurationOutput {
	s.TestConfigurationVersion = &v
	return s
}

type CreateTestSuiteInput struct {
	_ struct{} `type:"structure"`

	// The after steps of the test suite.
	AfterSteps []*Step `locationName:"afterSteps" min:"1" type:"list"`

	// The before steps of the test suite.
	BeforeSteps []*Step `locationName:"beforeSteps" min:"1" type:"list"`

	// The client token of the test suite.
	ClientToken *string `locationName:"clientToken" type:"string" idempotencyToken:"true"`

	// The description of the test suite.
	Description *string `locationName:"description" type:"string"`

	// The name of the test suite.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// The tags of the test suite.
	Tags map[string]*string `locationName:"tags" type:"map"`

	// The test cases in the test suite.
	//
	// TestCases is a required field
	TestCases *TestCases `locationName:"testCases" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateTestSuiteInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateTestSuiteInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateTestSuiteInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateTestSuiteInput"}
	if s.AfterSteps != nil && len(s.AfterSteps) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AfterSteps", 1))
	}
	if s.BeforeSteps != nil && len(s.BeforeSteps) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BeforeSteps", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.TestCases == nil {
		invalidParams.Add(request.NewErrParamRequired("TestCases"))
	}
	if s.AfterSteps != nil {
		for i, v := range s.AfterSteps {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "AfterSteps", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.BeforeSteps != nil {
		for i, v := range s.BeforeSteps {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "BeforeSteps", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAfterSteps sets the AfterSteps field's value.
func (s *CreateTestSuiteInput) SetAfterSteps(v []*Step) *CreateTestSuiteInput {
	s.AfterSteps = v
	return s
}

// SetBeforeSteps sets the BeforeSteps field's value.
func (s *CreateTestSuiteInput) SetBeforeSteps(v []*Step) *CreateTestSuiteInput {
	s.BeforeSteps = v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateTestSuiteInput) SetClientToken(v string) *CreateTestSuiteInput {
	s.ClientToken = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateTestSuiteInput) SetDescription(v string) *CreateTestSuiteInput {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateTestSuiteInput) SetName(v string) *CreateTestSuiteInput {
	s.Name = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateTestSuiteInput) SetTags(v map[string]*string) *CreateTestSuiteInput {
	s.Tags = v
	return s
}

// SetTestCases sets the TestCases field's value.
func (s *CreateTestSuiteInput) SetTestCases(v *TestCases) *CreateTestSuiteInput {
	s.TestCases = v
	return s
}

type CreateTestSuiteOutput struct {
	_ struct{} `type:"structure"`

	// The suite ID of the test suite.
	//
	// TestSuiteId is a required field
	TestSuiteId *string `locationName:"testSuiteId" type:"string" required:"true"`

	// The suite version of the test suite.
	//
	// TestSuiteVersion is a required field
	TestSuiteVersion *int64 `locationName:"testSuiteVersion" type:"integer" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateTestSuiteOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateTestSuiteOutput) GoString() string {
	return s.String()
}

// SetTestSuiteId sets the TestSuiteId field's value.
func (s *CreateTestSuiteOutput) SetTestSuiteId(v string) *CreateTestSuiteOutput {
	s.TestSuiteId = &v
	return s
}

// SetTestSuiteVersion sets the TestSuiteVersion field's value.
func (s *CreateTestSuiteOutput) SetTestSuiteVersion(v int64) *CreateTestSuiteOutput {
	s.TestSuiteVersion = &v
	return s
}

// Defines a data set.
type DataSet struct {
	_ struct{} `type:"structure"`

	// The CCSID of the data set.
	//
	// Ccsid is a required field
	Ccsid *string `locationName:"ccsid" type:"string" required:"true"`

	// The format of the data set.
	//
	// Format is a required field
	Format *string `locationName:"format" type:"string" required:"true" enum:"Format"`

	// The length of the data set.
	//
	// Length is a required field
	Length *int64 `locationName:"length" type:"integer" required:"true"`

	// The name of the data set.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// The type of the data set.
	//
	// Type is a required field
	Type *string `locationName:"type" type:"string" required:"true" enum:"DataSetType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataSet) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataSet) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DataSet) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DataSet"}
	if s.Ccsid == nil {
		invalidParams.Add(request.NewErrParamRequired("Ccsid"))
	}
	if s.Format == nil {
		invalidParams.Add(request.NewErrParamRequired("Format"))
	}
	if s.Length == nil {
		invalidParams.Add(request.NewErrParamRequired("Length"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCcsid sets the Ccsid field's value.
func (s *DataSet) SetCcsid(v string) *DataSet {
	s.Ccsid = &v
	return s
}

// SetFormat sets the Format field's value.
func (s *DataSet) SetFormat(v string) *DataSet {
	s.Format = &v
	return s
}

// SetLength sets the Length field's value.
func (s *DataSet) SetLength(v int64) *DataSet {
	s.Length = &v
	return s
}

// SetName sets the Name field's value.
func (s *DataSet) SetName(v string) *DataSet {
	s.Name = &v
	return s
}

// SetType sets the Type field's value.
func (s *DataSet) SetType(v string) *DataSet {
	s.Type = &v
	return s
}

// Defines the Change Data Capture (CDC) of the database.
type DatabaseCDC struct {
	_ struct{} `type:"structure"`

	// The source metadata of the database CDC.
	//
	// SourceMetadata is a required field
	SourceMetadata *SourceDatabaseMetadata `locationName:"sourceMetadata" type:"structure" required:"true"`

	// The target metadata of the database CDC.
	//
	// TargetMetadata is a required field
	TargetMetadata *TargetDatabaseMetadata `locationName:"targetMetadata" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DatabaseCDC) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DatabaseCDC) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DatabaseCDC) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DatabaseCDC"}
	if s.SourceMetadata == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceMetadata"))
	}
	if s.TargetMetadata == nil {
		invalidParams.Add(request.NewErrParamRequired("TargetMetadata"))
	}
	if s.SourceMetadata != nil {
		if err := s.SourceMetadata.Validate(); err != nil {
			invalidParams.AddNested("SourceMetadata", err.(request.ErrInvalidParams))
		}
	}
	if s.TargetMetadata != nil {
		if err := s.TargetMetadata.Validate(); err != nil {
			invalidParams.AddNested("TargetMetadata", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSourceMetadata sets the SourceMetadata field's value.
func (s *DatabaseCDC) SetSourceMetadata(v *SourceDatabaseMetadata) *DatabaseCDC {
	s.SourceMetadata = v
	return s
}

// SetTargetMetadata sets the TargetMetadata field's value.
func (s *DatabaseCDC) SetTargetMetadata(v *TargetDatabaseMetadata) *DatabaseCDC {
	s.TargetMetadata = v
	return s
}

// Deletes the CloudFormation step input.
type DeleteCloudFormationStepInput_ struct {
	_ struct{} `type:"structure"`

	// The stack ID of the deleted CloudFormation step input.
	//
	// StackId is a required field
	StackId *string `locationName:"stackId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteCloudFormationStepInput_) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteCloudFormationStepInput_) GoString() string {
	return s.String()
}

// SetStackId sets the StackId field's value.
func (s *DeleteCloudFormationStepInput_) SetStackId(v string) *DeleteCloudFormationStepInput_ {
	s.StackId = &v
	return s
}

// Deletes the CloudFormation summary step output.
type DeleteCloudFormationStepOutput_ struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteCloudFormationStepOutput_) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteCloudFormationStepOutput_) GoString() string {
	return s.String()
}

// Deletes the CloudFormation summary.
type DeleteCloudFormationSummary struct {
	_ struct{} `type:"structure"`

	// The step input of the deleted CloudFormation summary.
	//
	// StepInput is a required field
	StepInput *DeleteCloudFormationStepInput_ `locationName:"stepInput" type:"structure" required:"true"`

	// The step output of the deleted CloudFormation summary.
	StepOutput *DeleteCloudFormationStepOutput_ `locationName:"stepOutput" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteCloudFormationSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteCloudFormationSummary) GoString() string {
	return s.String()
}

// SetStepInput sets the StepInput field's value.
func (s *DeleteCloudFormationSummary) SetStepInput(v *DeleteCloudFormationStepInput_) *DeleteCloudFormationSummary {
	s.StepInput = v
	return s
}

// SetStepOutput sets the StepOutput field's value.
func (s *DeleteCloudFormationSummary) SetStepOutput(v *DeleteCloudFormationStepOutput_) *DeleteCloudFormationSummary {
	s.StepOutput = v
	return s
}

type DeleteTestCaseInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The test case ID of the test case.
	//
	// TestCaseId is a required field
	TestCaseId *string `location:"uri" locationName:"testCaseId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteTestCaseInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteTestCaseInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteTestCaseInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteTestCaseInput"}
	if s.TestCaseId == nil {
		invalidParams.Add(request.NewErrParamRequired("TestCaseId"))
	}
	if s.TestCaseId != nil && len(*s.TestCaseId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TestCaseId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTestCaseId sets the TestCaseId field's value.
func (s *DeleteTestCaseInput) SetTestCaseId(v string) *DeleteTestCaseInput {
	s.TestCaseId = &v
	return s
}

type DeleteTestCaseOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteTestCaseOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteTestCaseOutput) GoString() string {
	return s.String()
}

type DeleteTestConfigurationInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The test ID of the test configuration.
	//
	// TestConfigurationId is a required field
	TestConfigurationId *string `location:"uri" locationName:"testConfigurationId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteTestConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteTestConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteTestConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteTestConfigurationInput"}
	if s.TestConfigurationId == nil {
		invalidParams.Add(request.NewErrParamRequired("TestConfigurationId"))
	}
	if s.TestConfigurationId != nil && len(*s.TestConfigurationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TestConfigurationId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTestConfigurationId sets the TestConfigurationId field's value.
func (s *DeleteTestConfigurationInput) SetTestConfigurationId(v string) *DeleteTestConfigurationInput {
	s.TestConfigurationId = &v
	return s
}

type DeleteTestConfigurationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteTestConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteTestConfigurationOutput) GoString() string {
	return s.String()
}

type DeleteTestRunInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The run ID of the test run.
	//
	// TestRunId is a required field
	TestRunId *string `location:"uri" locationName:"testRunId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteTestRunInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteTestRunInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteTestRunInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteTestRunInput"}
	if s.TestRunId == nil {
		invalidParams.Add(request.NewErrParamRequired("TestRunId"))
	}
	if s.TestRunId != nil && len(*s.TestRunId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TestRunId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTestRunId sets the TestRunId field's value.
func (s *DeleteTestRunInput) SetTestRunId(v string) *DeleteTestRunInput {
	s.TestRunId = &v
	return s
}

type DeleteTestRunOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteTestRunOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteTestRunOutput) GoString() string {
	return s.String()
}

type DeleteTestSuiteInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The test ID of the test suite.
	//
	// TestSuiteId is a required field
	TestSuiteId *string `location:"uri" locationName:"testSuiteId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteTestSuiteInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteTestSuiteInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteTestSuiteInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteTestSuiteInput"}
	if s.TestSuiteId == nil {
		invalidParams.Add(request.NewErrParamRequired("TestSuiteId"))
	}
	if s.TestSuiteId != nil && len(*s.TestSuiteId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TestSuiteId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTestSuiteId sets the TestSuiteId field's value.
func (s *DeleteTestSuiteInput) SetTestSuiteId(v string) *DeleteTestSuiteInput {
	s.TestSuiteId = &v
	return s
}

type DeleteTestSuiteOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteTestSuiteOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteTestSuiteOutput) GoString() string {
	return s.String()
}

// Defines a file.
type File struct {
	_ struct{} `type:"structure"`

	// The file type of the file.
	FileType *CompareFileType `locationName:"fileType" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s File) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s File) GoString() string {
	return s.String()
}

// SetFileType sets the FileType field's value.
func (s *File) SetFileType(v *CompareFileType) *File {
	s.FileType = v
	return s
}

// Specifies a file metadata.
type FileMetadata struct {
	_ struct{} `type:"structure"`

	// The data sets of the file metadata.
	DataSets []*DataSet `locationName:"dataSets" type:"list"`

	// The database CDC of the file metadata.
	DatabaseCDC *DatabaseCDC `locationName:"databaseCDC" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FileMetadata) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FileMetadata) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *FileMetadata) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "FileMetadata"}
	if s.DataSets != nil {
		for i, v := range s.DataSets {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "DataSets", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.DatabaseCDC != nil {
		if err := s.DatabaseCDC.Validate(); err != nil {
			invalidParams.AddNested("DatabaseCDC", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDataSets sets the DataSets field's value.
func (s *FileMetadata) SetDataSets(v []*DataSet) *FileMetadata {
	s.DataSets = v
	return s
}

// SetDatabaseCDC sets the DatabaseCDC field's value.
func (s *FileMetadata) SetDatabaseCDC(v *DatabaseCDC) *FileMetadata {
	s.DatabaseCDC = v
	return s
}

type GetTestCaseInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The request test ID of the test case.
	//
	// TestCaseId is a required field
	TestCaseId *string `location:"uri" locationName:"testCaseId" type:"string" required:"true"`

	// The test case version of the test case.
	TestCaseVersion *int64 `location:"querystring" locationName:"testCaseVersion" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetTestCaseInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetTestCaseInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetTestCaseInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetTestCaseInput"}
	if s.TestCaseId == nil {
		invalidParams.Add(request.NewErrParamRequired("TestCaseId"))
	}
	if s.TestCaseId != nil && len(*s.TestCaseId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TestCaseId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTestCaseId sets the TestCaseId field's value.
func (s *GetTestCaseInput) SetTestCaseId(v string) *GetTestCaseInput {
	s.TestCaseId = &v
	return s
}

// SetTestCaseVersion sets the TestCaseVersion field's value.
func (s *GetTestCaseInput) SetTestCaseVersion(v int64) *GetTestCaseInput {
	s.TestCaseVersion = &v
	return s
}

type GetTestCaseOutput struct {
	_ struct{} `type:"structure"`

	// The creation time of the test case.
	//
	// CreationTime is a required field
	CreationTime *time.Time `locationName:"creationTime" type:"timestamp" required:"true"`

	// The description of the test case.
	Description *string `locationName:"description" type:"string"`

	// The last update time of the test case.
	//
	// LastUpdateTime is a required field
	LastUpdateTime *time.Time `locationName:"lastUpdateTime" type:"timestamp" required:"true"`

	// The latest version of the test case.
	//
	// LatestVersion is a required field
	LatestVersion *TestCaseLatestVersion `locationName:"latestVersion" type:"structure" required:"true"`

	// The name of the test case.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// The status of the test case.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"TestCaseLifecycle"`

	// The status reason of the test case.
	StatusReason *string `locationName:"statusReason" type:"string"`

	// The steps of the test case.
	//
	// Steps is a required field
	Steps []*Step `locationName:"steps" min:"1" type:"list" required:"true"`

	// The tags of the test case.
	Tags map[string]*string `locationName:"tags" type:"map"`

	// The Amazon Resource Name (ARN) of the test case.
	//
	// TestCaseArn is a required field
	TestCaseArn *string `locationName:"testCaseArn" type:"string" required:"true"`

	// The response test ID of the test case.
	//
	// TestCaseId is a required field
	TestCaseId *string `locationName:"testCaseId" type:"string" required:"true"`

	// The case version of the test case.
	//
	// TestCaseVersion is a required field
	TestCaseVersion *int64 `locationName:"testCaseVersion" type:"integer" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetTestCaseOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetTestCaseOutput) GoString() string {
	return s.String()
}

// SetCreationTime sets the CreationTime field's value.
func (s *GetTestCaseOutput) SetCreationTime(v time.Time) *GetTestCaseOutput {
	s.CreationTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *GetTestCaseOutput) SetDescription(v string) *GetTestCaseOutput {
	s.Description = &v
	return s
}

// SetLastUpdateTime sets the LastUpdateTime field's value.
func (s *GetTestCaseOutput) SetLastUpdateTime(v time.Time) *GetTestCaseOutput {
	s.LastUpdateTime = &v
	return s
}

// SetLatestVersion sets the LatestVersion field's value.
func (s *GetTestCaseOutput) SetLatestVersion(v *TestCaseLatestVersion) *GetTestCaseOutput {
	s.LatestVersion = v
	return s
}

// SetName sets the Name field's value.
func (s *GetTestCaseOutput) SetName(v string) *GetTestCaseOutput {
	s.Name = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *GetTestCaseOutput) SetStatus(v string) *GetTestCaseOutput {
	s.Status = &v
	return s
}

// SetStatusReason sets the StatusReason field's value.
func (s *GetTestCaseOutput) SetStatusReason(v string) *GetTestCaseOutput {
	s.StatusReason = &v
	return s
}

// SetSteps sets the Steps field's value.
func (s *GetTestCaseOutput) SetSteps(v []*Step) *GetTestCaseOutput {
	s.Steps = v
	return s
}

// SetTags sets the Tags field's value.
func (s *GetTestCaseOutput) SetTags(v map[string]*string) *GetTestCaseOutput {
	s.Tags = v
	return s
}

// SetTestCaseArn sets the TestCaseArn field's value.
func (s *GetTestCaseOutput) SetTestCaseArn(v string) *GetTestCaseOutput {
	s.TestCaseArn = &v
	return s
}

// SetTestCaseId sets the TestCaseId field's value.
func (s *GetTestCaseOutput) SetTestCaseId(v string) *GetTestCaseOutput {
	s.TestCaseId = &v
	return s
}

// SetTestCaseVersion sets the TestCaseVersion field's value.
func (s *GetTestCaseOutput) SetTestCaseVersion(v int64) *GetTestCaseOutput {
	s.TestCaseVersion = &v
	return s
}

type GetTestConfigurationInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The request test configuration ID.
	//
	// TestConfigurationId is a required field
	TestConfigurationId *string `location:"uri" locationName:"testConfigurationId" type:"string" required:"true"`

	// The test configuration version.
	TestConfigurationVersion *int64 `location:"querystring" locationName:"testConfigurationVersion" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetTestConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetTestConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetTestConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetTestConfigurationInput"}
	if s.TestConfigurationId == nil {
		invalidParams.Add(request.NewErrParamRequired("TestConfigurationId"))
	}
	if s.TestConfigurationId != nil && len(*s.TestConfigurationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TestConfigurationId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTestConfigurationId sets the TestConfigurationId field's value.
func (s *GetTestConfigurationInput) SetTestConfigurationId(v string) *GetTestConfigurationInput {
	s.TestConfigurationId = &v
	return s
}

// SetTestConfigurationVersion sets the TestConfigurationVersion field's value.
func (s *GetTestConfigurationInput) SetTestConfigurationVersion(v int64) *GetTestConfigurationInput {
	s.TestConfigurationVersion = &v
	return s
}

type GetTestConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// The creation time of the test configuration.
	//
	// CreationTime is a required field
	CreationTime *time.Time `locationName:"creationTime" type:"timestamp" required:"true"`

	// The description of the test configuration.
	Description *string `locationName:"description" type:"string"`

	// The last update time of the test configuration.
	//
	// LastUpdateTime is a required field
	LastUpdateTime *time.Time `locationName:"lastUpdateTime" type:"timestamp" required:"true"`

	// The latest version of the test configuration.
	//
	// LatestVersion is a required field
	LatestVersion *TestConfigurationLatestVersion `locationName:"latestVersion" type:"structure" required:"true"`

	// The test configuration name
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// The properties of the test configuration.
	//
	// Properties is a required field
	Properties map[string]*string `locationName:"properties" type:"map" required:"true"`

	// The resources of the test configuration.
	//
	// Resources is a required field
	Resources []*Resource `locationName:"resources" min:"1" type:"list" required:"true"`

	// The service settings of the test configuration.
	ServiceSettings *ServiceSettings `locationName:"serviceSettings" type:"structure"`

	// The status of the test configuration.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"TestConfigurationLifecycle"`

	// The status reason of the test configuration.
	StatusReason *string `locationName:"statusReason" type:"string"`

	// The tags of the test configuration.
	Tags map[string]*string `locationName:"tags" type:"map"`

	// The test configuration Amazon Resource Name (ARN).
	//
	// TestConfigurationArn is a required field
	TestConfigurationArn *string `locationName:"testConfigurationArn" type:"string" required:"true"`

	// The response test configuration ID.
	//
	// TestConfigurationId is a required field
	TestConfigurationId *string `locationName:"testConfigurationId" type:"string" required:"true"`

	// The test configuration version.
	//
	// TestConfigurationVersion is a required field
	TestConfigurationVersion *int64 `locationName:"testConfigurationVersion" type:"integer" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetTestConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetTestConfigurationOutput) GoString() string {
	return s.String()
}

// SetCreationTime sets the CreationTime field's value.
func (s *GetTestConfigurationOutput) SetCreationTime(v time.Time) *GetTestConfigurationOutput {
	s.CreationTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *GetTestConfigurationOutput) SetDescription(v string) *GetTestConfigurationOutput {
	s.Description = &v
	return s
}

// SetLastUpdateTime sets the LastUpdateTime field's value.
func (s *GetTestConfigurationOutput) SetLastUpdateTime(v time.Time) *GetTestConfigurationOutput {
	s.LastUpdateTime = &v
	return s
}

// SetLatestVersion sets the LatestVersion field's value.
func (s *GetTestConfigurationOutput) SetLatestVersion(v *TestConfigurationLatestVersion) *GetTestConfigurationOutput {
	s.LatestVersion = v
	return s
}

// SetName sets the Name field's value.
func (s *GetTestConfigurationOutput) SetName(v string) *GetTestConfigurationOutput {
	s.Name = &v
	return s
}

// SetProperties sets the Properties field's value.
func (s *GetTestConfigurationOutput) SetProperties(v map[string]*string) *GetTestConfigurationOutput {
	s.Properties = v
	return s
}

// SetResources sets the Resources field's value.
func (s *GetTestConfigurationOutput) SetResources(v []*Resource) *GetTestConfigurationOutput {
	s.Resources = v
	return s
}

// SetServiceSettings sets the ServiceSettings field's value.
func (s *GetTestConfigurationOutput) SetServiceSettings(v *ServiceSettings) *GetTestConfigurationOutput {
	s.ServiceSettings = v
	return s
}

// SetStatus sets the Status field's value.
func (s *GetTestConfigurationOutput) SetStatus(v string) *GetTestConfigurationOutput {
	s.Status = &v
	return s
}

// SetStatusReason sets the StatusReason field's value.
func (s *GetTestConfigurationOutput) SetStatusReason(v string) *GetTestConfigurationOutput {
	s.StatusReason = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *GetTestConfigurationOutput) SetTags(v map[string]*string) *GetTestConfigurationOutput {
	s.Tags = v
	return s
}

// SetTestConfigurationArn sets the TestConfigurationArn field's value.
func (s *GetTestConfigurationOutput) SetTestConfigurationArn(v string) *GetTestConfigurationOutput {
	s.TestConfigurationArn = &v
	return s
}

// SetTestConfigurationId sets the TestConfigurationId field's value.
func (s *GetTestConfigurationOutput) SetTestConfigurationId(v string) *GetTestConfigurationOutput {
	s.TestConfigurationId = &v
	return s
}

// SetTestConfigurationVersion sets the TestConfigurationVersion field's value.
func (s *GetTestConfigurationOutput) SetTestConfigurationVersion(v int64) *GetTestConfigurationOutput {
	s.TestConfigurationVersion = &v
	return s
}

type GetTestRunStepInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The step name of the test run step.
	//
	// StepName is a required field
	StepName *string `location:"uri" locationName:"stepName" type:"string" required:"true"`

	// The test case ID of a test run step.
	TestCaseId *string `location:"querystring" locationName:"testCaseId" type:"string"`

	// The test run ID of the test run step.
	//
	// TestRunId is a required field
	TestRunId *string `location:"uri" locationName:"testRunId" type:"string" required:"true"`

	// The test suite ID of a test run step.
	TestSuiteId *string `location:"querystring" locationName:"testSuiteId" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetTestRunStepInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetTestRunStepInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetTestRunStepInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetTestRunStepInput"}
	if s.StepName == nil {
		invalidParams.Add(request.NewErrParamRequired("StepName"))
	}
	if s.StepName != nil && len(*s.StepName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StepName", 1))
	}
	if s.TestRunId == nil {
		invalidParams.Add(request.NewErrParamRequired("TestRunId"))
	}
	if s.TestRunId != nil && len(*s.TestRunId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TestRunId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetStepName sets the StepName field's value.
func (s *GetTestRunStepInput) SetStepName(v string) *GetTestRunStepInput {
	s.StepName = &v
	return s
}

// SetTestCaseId sets the TestCaseId field's value.
func (s *GetTestRunStepInput) SetTestCaseId(v string) *GetTestRunStepInput {
	s.TestCaseId = &v
	return s
}

// SetTestRunId sets the TestRunId field's value.
func (s *GetTestRunStepInput) SetTestRunId(v string) *GetTestRunStepInput {
	s.TestRunId = &v
	return s
}

// SetTestSuiteId sets the TestSuiteId field's value.
func (s *GetTestRunStepInput) SetTestSuiteId(v string) *GetTestRunStepInput {
	s.TestSuiteId = &v
	return s
}

type GetTestRunStepOutput struct {
	_ struct{} `type:"structure"`

	// The after steps of the test run step.
	AfterStep *bool `locationName:"afterStep" type:"boolean"`

	// The before steps of the test run step.
	BeforeStep *bool `locationName:"beforeStep" type:"boolean"`

	// The run end time of the test run step.
	RunEndTime *time.Time `locationName:"runEndTime" type:"timestamp"`

	// The run start time of the test run step.
	//
	// RunStartTime is a required field
	RunStartTime *time.Time `locationName:"runStartTime" type:"timestamp" required:"true"`

	// The status of the test run step.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"StepRunStatus"`

	// The status reason of the test run step.
	StatusReason *string `locationName:"statusReason" type:"string"`

	// The step name of the test run step.
	//
	// StepName is a required field
	StepName *string `locationName:"stepName" type:"string" required:"true"`

	// The step run summary of the test run step.
	StepRunSummary *StepRunSummary `locationName:"stepRunSummary" type:"structure"`

	// The test case ID of the test run step.
	TestCaseId *string `locationName:"testCaseId" type:"string"`

	// The test case version of the test run step.
	TestCaseVersion *int64 `locationName:"testCaseVersion" type:"integer"`

	// The test run ID of the test run step.
	//
	// TestRunId is a required field
	TestRunId *string `locationName:"testRunId" type:"string" required:"true"`

	// The test suite ID of the test run step.
	TestSuiteId *string `locationName:"testSuiteId" type:"string"`

	// The test suite version of the test run step.
	TestSuiteVersion *int64 `locationName:"testSuiteVersion" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetTestRunStepOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetTestRunStepOutput) GoString() string {
	return s.String()
}

// SetAfterStep sets the AfterStep field's value.
func (s *GetTestRunStepOutput) SetAfterStep(v bool) *GetTestRunStepOutput {
	s.AfterStep = &v
	return s
}

// SetBeforeStep sets the BeforeStep field's value.
func (s *GetTestRunStepOutput) SetBeforeStep(v bool) *GetTestRunStepOutput {
	s.BeforeStep = &v
	return s
}

// SetRunEndTime sets the RunEndTime field's value.
func (s *GetTestRunStepOutput) SetRunEndTime(v time.Time) *GetTestRunStepOutput {
	s.RunEndTime = &v
	return s
}

// SetRunStartTime sets the RunStartTime field's value.
func (s *GetTestRunStepOutput) SetRunStartTime(v time.Time) *GetTestRunStepOutput {
	s.RunStartTime = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *GetTestRunStepOutput) SetStatus(v string) *GetTestRunStepOutput {
	s.Status = &v
	return s
}

// SetStatusReason sets the StatusReason field's value.
func (s *GetTestRunStepOutput) SetStatusReason(v string) *GetTestRunStepOutput {
	s.StatusReason = &v
	return s
}

// SetStepName sets the StepName field's value.
func (s *GetTestRunStepOutput) SetStepName(v string) *GetTestRunStepOutput {
	s.StepName = &v
	return s
}

// SetStepRunSummary sets the StepRunSummary field's value.
func (s *GetTestRunStepOutput) SetStepRunSummary(v *StepRunSummary) *GetTestRunStepOutput {
	s.StepRunSummary = v
	return s
}

// SetTestCaseId sets the TestCaseId field's value.
func (s *GetTestRunStepOutput) SetTestCaseId(v string) *GetTestRunStepOutput {
	s.TestCaseId = &v
	return s
}

// SetTestCaseVersion sets the TestCaseVersion field's value.
func (s *GetTestRunStepOutput) SetTestCaseVersion(v int64) *GetTestRunStepOutput {
	s.TestCaseVersion = &v
	return s
}

// SetTestRunId sets the TestRunId field's value.
func (s *GetTestRunStepOutput) SetTestRunId(v string) *GetTestRunStepOutput {
	s.TestRunId = &v
	return s
}

// SetTestSuiteId sets the TestSuiteId field's value.
func (s *GetTestRunStepOutput) SetTestSuiteId(v string) *GetTestRunStepOutput {
	s.TestSuiteId = &v
	return s
}

// SetTestSuiteVersion sets the TestSuiteVersion field's value.
func (s *GetTestRunStepOutput) SetTestSuiteVersion(v int64) *GetTestRunStepOutput {
	s.TestSuiteVersion = &v
	return s
}

type GetTestSuiteInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID of the test suite.
	//
	// TestSuiteId is a required field
	TestSuiteId *string `location:"uri" locationName:"testSuiteId" type:"string" required:"true"`

	// The version of the test suite.
	TestSuiteVersion *int64 `location:"querystring" locationName:"testSuiteVersion" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetTestSuiteInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetTestSuiteInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetTestSuiteInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetTestSuiteInput"}
	if s.TestSuiteId == nil {
		invalidParams.Add(request.NewErrParamRequired("TestSuiteId"))
	}
	if s.TestSuiteId != nil && len(*s.TestSuiteId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TestSuiteId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTestSuiteId sets the TestSuiteId field's value.
func (s *GetTestSuiteInput) SetTestSuiteId(v string) *GetTestSuiteInput {
	s.TestSuiteId = &v
	return s
}

// SetTestSuiteVersion sets the TestSuiteVersion field's value.
func (s *GetTestSuiteInput) SetTestSuiteVersion(v int64) *GetTestSuiteInput {
	s.TestSuiteVersion = &v
	return s
}

type GetTestSuiteOutput struct {
	_ struct{} `type:"structure"`

	// The after steps of the test suite.
	//
	// AfterSteps is a required field
	AfterSteps []*Step `locationName:"afterSteps" min:"1" type:"list" required:"true"`

	// The before steps of the test suite.
	//
	// BeforeSteps is a required field
	BeforeSteps []*Step `locationName:"beforeSteps" min:"1" type:"list" required:"true"`

	// The creation time of the test suite.
	//
	// CreationTime is a required field
	CreationTime *time.Time `locationName:"creationTime" type:"timestamp" required:"true"`

	// The description of the test suite.
	Description *string `locationName:"description" type:"string"`

	// The last update time of the test suite.
	//
	// LastUpdateTime is a required field
	LastUpdateTime *time.Time `locationName:"lastUpdateTime" type:"timestamp" required:"true"`

	// The latest version of the test suite.
	//
	// LatestVersion is a required field
	LatestVersion *TestSuiteLatestVersion `locationName:"latestVersion" type:"structure" required:"true"`

	// The name of the test suite.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// The status of the test suite.
	Status *string `locationName:"status" type:"string" enum:"TestSuiteLifecycle"`

	// The status reason of the test suite.
	StatusReason *string `locationName:"statusReason" type:"string"`

	// The tags of the test suite.
	Tags map[string]*string `locationName:"tags" type:"map"`

	// The test cases of the test suite.
	//
	// TestCases is a required field
	TestCases *TestCases `locationName:"testCases" type:"structure" required:"true"`

	// The test suite Amazon Resource Name (ARN).
	//
	// TestSuiteArn is a required field
	TestSuiteArn *string `locationName:"testSuiteArn" type:"string" required:"true"`

	// The response ID of the test suite.
	//
	// TestSuiteId is a required field
	TestSuiteId *string `locationName:"testSuiteId" type:"string" required:"true"`

	// The version of the test suite.
	//
	// TestSuiteVersion is a required field
	TestSuiteVersion *int64 `locationName:"testSuiteVersion" type:"integer" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetTestSuiteOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetTestSuiteOutput) GoString() string {
	return s.String()
}

// SetAfterSteps sets the AfterSteps field's value.
func (s *GetTestSuiteOutput) SetAfterSteps(v []*Step) *GetTestSuiteOutput {
	s.AfterSteps = v
	return s
}

// SetBeforeSteps sets the BeforeSteps field's value.
func (s *GetTestSuiteOutput) SetBeforeSteps(v []*Step) *GetTestSuiteOutput {
	s.BeforeSteps = v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *GetTestSuiteOutput) SetCreationTime(v time.Time) *GetTestSuiteOutput {
	s.CreationTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *GetTestSuiteOutput) SetDescription(v string) *GetTestSuiteOutput {
	s.Description = &v
	return s
}

// SetLastUpdateTime sets the LastUpdateTime field's value.
func (s *GetTestSuiteOutput) SetLastUpdateTime(v time.Time) *GetTestSuiteOutput {
	s.LastUpdateTime = &v
	return s
}

// SetLatestVersion sets the LatestVersion field's value.
func (s *GetTestSuiteOutput) SetLatestVersion(v *TestSuiteLatestVersion) *GetTestSuiteOutput {
	s.LatestVersion = v
	return s
}

// SetName sets the Name field's value.
func (s *GetTestSuiteOutput) SetName(v string) *GetTestSuiteOutput {
	s.Name = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *GetTestSuiteOutput) SetStatus(v string) *GetTestSuiteOutput {
	s.Status = &v
	return s
}

// SetStatusReason sets the StatusReason field's value.
func (s *GetTestSuiteOutput) SetStatusReason(v string) *GetTestSuiteOutput {
	s.StatusReason = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *GetTestSuiteOutput) SetTags(v map[string]*string) *GetTestSuiteOutput {
	s.Tags = v
	return s
}

// SetTestCases sets the TestCases field's value.
func (s *GetTestSuiteOutput) SetTestCases(v *TestCases) *GetTestSuiteOutput {
	s.TestCases = v
	return s
}

// SetTestSuiteArn sets the TestSuiteArn field's value.
func (s *GetTestSuiteOutput) SetTestSuiteArn(v string) *GetTestSuiteOutput {
	s.TestSuiteArn = &v
	return s
}

// SetTestSuiteId sets the TestSuiteId field's value.
func (s *GetTestSuiteOutput) SetTestSuiteId(v string) *GetTestSuiteOutput {
	s.TestSuiteId = &v
	return s
}

// SetTestSuiteVersion sets the TestSuiteVersion field's value.
func (s *GetTestSuiteOutput) SetTestSuiteVersion(v int64) *GetTestSuiteOutput {
	s.TestSuiteVersion = &v
	return s
}

// Specifies the input file.
type InputFile struct {
	_ struct{} `type:"structure"`

	// The file metadata of the input file.
	//
	// FileMetadata is a required field
	FileMetadata *FileMetadata `locationName:"fileMetadata" type:"structure" required:"true"`

	// The source location of the input file.
	//
	// SourceLocation is a required field
	SourceLocation *string `locationName:"sourceLocation" type:"string" required:"true"`

	// The target location of the input file.
	//
	// TargetLocation is a required field
	TargetLocation *string `locationName:"targetLocation" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InputFile) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InputFile) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InputFile) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "InputFile"}
	if s.FileMetadata == nil {
		invalidParams.Add(request.NewErrParamRequired("FileMetadata"))
	}
	if s.SourceLocation == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceLocation"))
	}
	if s.TargetLocation == nil {
		invalidParams.Add(request.NewErrParamRequired("TargetLocation"))
	}
	if s.FileMetadata != nil {
		if err := s.FileMetadata.Validate(); err != nil {
			invalidParams.AddNested("FileMetadata", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFileMetadata sets the FileMetadata field's value.
func (s *InputFile) SetFileMetadata(v *FileMetadata) *InputFile {
	s.FileMetadata = v
	return s
}

// SetSourceLocation sets the SourceLocation field's value.
func (s *InputFile) SetSourceLocation(v string) *InputFile {
	s.SourceLocation = &v
	return s
}

// SetTargetLocation sets the TargetLocation field's value.
func (s *InputFile) SetTargetLocation(v string) *InputFile {
	s.TargetLocation = &v
	return s
}

// Specifies the input.
type Input_ struct {
	_ struct{} `type:"structure"`

	// The file in the input.
	File *InputFile `locationName:"file" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Input_) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Input_) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Input_) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Input_"}
	if s.File != nil {
		if err := s.File.Validate(); err != nil {
			invalidParams.AddNested("File", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFile sets the File field's value.
func (s *Input_) SetFile(v *InputFile) *Input_ {
	s.File = v
	return s
}

// An unexpected error occurred during the processing of the request.
type InternalServerException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`

	// The number of seconds to retry the query.
	RetryAfterSeconds *int64 `location:"header" locationName:"Retry-After" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) GoString() string {
	return s.String()
}

func newErrorInternalServerException(v protocol.ResponseMetadata) error {
	return &InternalServerException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServerException) Code() string {
	return "InternalServerException"
}

// Message returns the exception's message.
func (s *InternalServerException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServerException) OrigErr() error {
	return nil
}

func (s *InternalServerException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServerException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServerException) RequestID() string {
	return s.RespMetadata.RequestID
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The Amazon Resource Name (ARN) of the resource.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ListTagsForResourceInput) SetResourceArn(v string) *ListTagsForResourceInput {
	s.ResourceArn = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// The tags of the resource.
	//
	// Tags is a required field
	Tags map[string]*string `locationName:"tags" type:"map" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v map[string]*string) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

type ListTestCasesInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The maximum results of the test case.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The next token of the test cases.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`

	// The IDs of the test cases.
	TestCaseIds []*string `location:"querystring" locationName:"testCaseIds" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTestCasesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTestCasesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTestCasesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTestCasesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListTestCasesInput) SetMaxResults(v int64) *ListTestCasesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListTestCasesInput) SetNextToken(v string) *ListTestCasesInput {
	s.NextToken = &v
	return s
}

// SetTestCaseIds sets the TestCaseIds field's value.
func (s *ListTestCasesInput) SetTestCaseIds(v []*string) *ListTestCasesInput {
	s.TestCaseIds = v
	return s
}

type ListTestCasesOutput struct {
	_ struct{} `type:"structure"`

	// The next token in test cases.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The test cases in an application.
	//
	// TestCases is a required field
	TestCases []*TestCaseSummary `locationName:"testCases" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTestCasesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTestCasesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListTestCasesOutput) SetNextToken(v string) *ListTestCasesOutput {
	s.NextToken = &v
	return s
}

// SetTestCases sets the TestCases field's value.
func (s *ListTestCasesOutput) SetTestCases(v []*TestCaseSummary) *ListTestCasesOutput {
	s.TestCases = v
	return s
}

type ListTestConfigurationsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The maximum results of the test configuration.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The next token for the test configurations.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`

	// The configuration IDs of the test configurations.
	TestConfigurationIds []*string `location:"querystring" locationName:"testConfigurationIds" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTestConfigurationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTestConfigurationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTestConfigurationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTestConfigurationsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListTestConfigurationsInput) SetMaxResults(v int64) *ListTestConfigurationsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListTestConfigurationsInput) SetNextToken(v string) *ListTestConfigurationsInput {
	s.NextToken = &v
	return s
}

// SetTestConfigurationIds sets the TestConfigurationIds field's value.
func (s *ListTestConfigurationsInput) SetTestConfigurationIds(v []*string) *ListTestConfigurationsInput {
	s.TestConfigurationIds = v
	return s
}

type ListTestConfigurationsOutput struct {
	_ struct{} `type:"structure"`

	// The next token in the test configurations.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The test configurations.
	//
	// TestConfigurations is a required field
	TestConfigurations []*TestConfigurationSummary `locationName:"testConfigurations" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTestConfigurationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTestConfigurationsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListTestConfigurationsOutput) SetNextToken(v string) *ListTestConfigurationsOutput {
	s.NextToken = &v
	return s
}

// SetTestConfigurations sets the TestConfigurations field's value.
func (s *ListTestConfigurationsOutput) SetTestConfigurations(v []*TestConfigurationSummary) *ListTestConfigurationsOutput {
	s.TestConfigurations = v
	return s
}

type ListTestRunStepsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The maximum number of test run steps to return in one page of results.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The token from a previous step to retrieve the next page of results.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`

	// The test case ID of the test run steps.
	TestCaseId *string `location:"querystring" locationName:"testCaseId" type:"string"`

	// The test run ID of the test run steps.
	//
	// TestRunId is a required field
	TestRunId *string `location:"uri" locationName:"testRunId" type:"string" required:"true"`

	// The test suite ID of the test run steps.
	TestSuiteId *string `location:"querystring" locationName:"testSuiteId" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTestRunStepsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTestRunStepsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTestRunStepsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTestRunStepsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.TestRunId == nil {
		invalidParams.Add(request.NewErrParamRequired("TestRunId"))
	}
	if s.TestRunId != nil && len(*s.TestRunId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TestRunId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListTestRunStepsInput) SetMaxResults(v int64) *ListTestRunStepsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListTestRunStepsInput) SetNextToken(v string) *ListTestRunStepsInput {
	s.NextToken = &v
	return s
}

// SetTestCaseId sets the TestCaseId field's value.
func (s *ListTestRunStepsInput) SetTestCaseId(v string) *ListTestRunStepsInput {
	s.TestCaseId = &v
	return s
}

// SetTestRunId sets the TestRunId field's value.
func (s *ListTestRunStepsInput) SetTestRunId(v string) *ListTestRunStepsInput {
	s.TestRunId = &v
	return s
}

// SetTestSuiteId sets the TestSuiteId field's value.
func (s *ListTestRunStepsInput) SetTestSuiteId(v string) *ListTestRunStepsInput {
	s.TestSuiteId = &v
	return s
}

type ListTestRunStepsOutput struct {
	_ struct{} `type:"structure"`

	// The token from a previous request to retrieve the next page of results.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The test run steps of the response query.
	//
	// TestRunSteps is a required field
	TestRunSteps []*TestRunStepSummary `locationName:"testRunSteps" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTestRunStepsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTestRunStepsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListTestRunStepsOutput) SetNextToken(v string) *ListTestRunStepsOutput {
	s.NextToken = &v
	return s
}

// SetTestRunSteps sets the TestRunSteps field's value.
func (s *ListTestRunStepsOutput) SetTestRunSteps(v []*TestRunStepSummary) *ListTestRunStepsOutput {
	s.TestRunSteps = v
	return s
}

type ListTestRunTestCasesInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The maximum number of test run test cases to return in one page of results.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The token from a previous request to retrieve the next page of results.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`

	// The test run ID of the test cases.
	//
	// TestRunId is a required field
	TestRunId *string `location:"uri" locationName:"testRunId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTestRunTestCasesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTestRunTestCasesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTestRunTestCasesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTestRunTestCasesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.TestRunId == nil {
		invalidParams.Add(request.NewErrParamRequired("TestRunId"))
	}
	if s.TestRunId != nil && len(*s.TestRunId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TestRunId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListTestRunTestCasesInput) SetMaxResults(v int64) *ListTestRunTestCasesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListTestRunTestCasesInput) SetNextToken(v string) *ListTestRunTestCasesInput {
	s.NextToken = &v
	return s
}

// SetTestRunId sets the TestRunId field's value.
func (s *ListTestRunTestCasesInput) SetTestRunId(v string) *ListTestRunTestCasesInput {
	s.TestRunId = &v
	return s
}

type ListTestRunTestCasesOutput struct {
	_ struct{} `type:"structure"`

	// The token from a previous request to retrieve the next page of results.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The test run of the test cases.
	//
	// TestRunTestCases is a required field
	TestRunTestCases []*TestCaseRunSummary `locationName:"testRunTestCases" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTestRunTestCasesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTestRunTestCasesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListTestRunTestCasesOutput) SetNextToken(v string) *ListTestRunTestCasesOutput {
	s.NextToken = &v
	return s
}

// SetTestRunTestCases sets the TestRunTestCases field's value.
func (s *ListTestRunTestCasesOutput) SetTestRunTestCases(v []*TestCaseRunSummary) *ListTestRunTestCasesOutput {
	s.TestRunTestCases = v
	return s
}

type ListTestRunsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The maximum number of test runs to return in one page of results.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The token from the previous request to retrieve the next page of test run
	// results.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`

	// The test run IDs of the test runs.
	TestRunIds []*string `location:"querystring" locationName:"testrunIds" type:"list"`

	// The test suite ID of the test runs.
	TestSuiteId *string `location:"querystring" locationName:"testSuiteId" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTestRunsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTestRunsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTestRunsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTestRunsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListTestRunsInput) SetMaxResults(v int64) *ListTestRunsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListTestRunsInput) SetNextToken(v string) *ListTestRunsInput {
	s.NextToken = &v
	return s
}

// SetTestRunIds sets the TestRunIds field's value.
func (s *ListTestRunsInput) SetTestRunIds(v []*string) *ListTestRunsInput {
	s.TestRunIds = v
	return s
}

// SetTestSuiteId sets the TestSuiteId field's value.
func (s *ListTestRunsInput) SetTestSuiteId(v string) *ListTestRunsInput {
	s.TestSuiteId = &v
	return s
}

type ListTestRunsOutput struct {
	_ struct{} `type:"structure"`

	// The token from the previous request to retrieve the next page of results.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The test runs of the response query.
	//
	// TestRuns is a required field
	TestRuns []*TestRunSummary `locationName:"testRuns" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTestRunsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTestRunsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListTestRunsOutput) SetNextToken(v string) *ListTestRunsOutput {
	s.NextToken = &v
	return s
}

// SetTestRuns sets the TestRuns field's value.
func (s *ListTestRunsOutput) SetTestRuns(v []*TestRunSummary) *ListTestRunsOutput {
	s.TestRuns = v
	return s
}

type ListTestSuitesInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The maximum number of test suites to return in one page of results.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The token from a previous request to retrieve the next page of results.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`

	// The suite ID of the test suites.
	TestSuiteIds []*string `location:"querystring" locationName:"testSuiteIds" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTestSuitesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTestSuitesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTestSuitesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTestSuitesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListTestSuitesInput) SetMaxResults(v int64) *ListTestSuitesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListTestSuitesInput) SetNextToken(v string) *ListTestSuitesInput {
	s.NextToken = &v
	return s
}

// SetTestSuiteIds sets the TestSuiteIds field's value.
func (s *ListTestSuitesInput) SetTestSuiteIds(v []*string) *ListTestSuitesInput {
	s.TestSuiteIds = v
	return s
}

type ListTestSuitesOutput struct {
	_ struct{} `type:"structure"`

	// The token from a previous request to retrieve the next page of test suites
	// results.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The test suites returned with the response query.
	//
	// TestSuites is a required field
	TestSuites []*TestSuiteSummary `locationName:"testSuites" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTestSuitesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTestSuitesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListTestSuitesOutput) SetNextToken(v string) *ListTestSuitesOutput {
	s.NextToken = &v
	return s
}

// SetTestSuites sets the TestSuites field's value.
func (s *ListTestSuitesOutput) SetTestSuites(v []*TestSuiteSummary) *ListTestSuitesOutput {
	s.TestSuites = v
	return s
}

// Specifies the AWS Mainframe Modernization managed action properties.
type M2ManagedActionProperties struct {
	_ struct{} `type:"structure"`

	// Force stops the AWS Mainframe Modernization managed action properties.
	ForceStop *bool `locationName:"forceStop" type:"boolean"`

	// The import data set location of the AWS Mainframe Modernization managed action
	// properties.
	ImportDataSetLocation *string `locationName:"importDataSetLocation" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s M2ManagedActionProperties) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s M2ManagedActionProperties) GoString() string {
	return s.String()
}

// SetForceStop sets the ForceStop field's value.
func (s *M2ManagedActionProperties) SetForceStop(v bool) *M2ManagedActionProperties {
	s.ForceStop = &v
	return s
}

// SetImportDataSetLocation sets the ImportDataSetLocation field's value.
func (s *M2ManagedActionProperties) SetImportDataSetLocation(v string) *M2ManagedActionProperties {
	s.ImportDataSetLocation = &v
	return s
}

// Specifies the AWS Mainframe Modernization managed application.
type M2ManagedApplication struct {
	_ struct{} `type:"structure"`

	// The application ID of the AWS Mainframe Modernization managed application.
	//
	// ApplicationId is a required field
	ApplicationId *string `locationName:"applicationId" type:"string" required:"true"`

	// The listener port of the AWS Mainframe Modernization managed application.
	ListenerPort *string `locationName:"listenerPort" type:"string"`

	// The runtime of the AWS Mainframe Modernization managed application.
	//
	// Runtime is a required field
	Runtime *string `locationName:"runtime" type:"string" required:"true" enum:"M2ManagedRuntime"`

	// The VPC endpoint service name of the AWS Mainframe Modernization managed
	// application.
	VpcEndpointServiceName *string `locationName:"vpcEndpointServiceName" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s M2ManagedApplication) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s M2ManagedApplication) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *M2ManagedApplication) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "M2ManagedApplication"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.Runtime == nil {
		invalidParams.Add(request.NewErrParamRequired("Runtime"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *M2ManagedApplication) SetApplicationId(v string) *M2ManagedApplication {
	s.ApplicationId = &v
	return s
}

// SetListenerPort sets the ListenerPort field's value.
func (s *M2ManagedApplication) SetListenerPort(v string) *M2ManagedApplication {
	s.ListenerPort = &v
	return s
}

// SetRuntime sets the Runtime field's value.
func (s *M2ManagedApplication) SetRuntime(v string) *M2ManagedApplication {
	s.Runtime = &v
	return s
}

// SetVpcEndpointServiceName sets the VpcEndpointServiceName field's value.
func (s *M2ManagedApplication) SetVpcEndpointServiceName(v string) *M2ManagedApplication {
	s.VpcEndpointServiceName = &v
	return s
}

// Specifies the AWS Mainframe Modernization managed application action.
type M2ManagedApplicationAction struct {
	_ struct{} `type:"structure"`

	// The action type of the AWS Mainframe Modernization managed application action.
	//
	// ActionType is a required field
	ActionType *string `locationName:"actionType" type:"string" required:"true" enum:"M2ManagedActionType"`

	// The properties of the AWS Mainframe Modernization managed application action.
	Properties *M2ManagedActionProperties `locationName:"properties" type:"structure"`

	// The resource of the AWS Mainframe Modernization managed application action.
	//
	// Resource is a required field
	Resource *string `locationName:"resource" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s M2ManagedApplicationAction) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s M2ManagedApplicationAction) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *M2ManagedApplicationAction) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "M2ManagedApplicationAction"}
	if s.ActionType == nil {
		invalidParams.Add(request.NewErrParamRequired("ActionType"))
	}
	if s.Resource == nil {
		invalidParams.Add(request.NewErrParamRequired("Resource"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetActionType sets the ActionType field's value.
func (s *M2ManagedApplicationAction) SetActionType(v string) *M2ManagedApplicationAction {
	s.ActionType = &v
	return s
}

// SetProperties sets the Properties field's value.
func (s *M2ManagedApplicationAction) SetProperties(v *M2ManagedActionProperties) *M2ManagedApplicationAction {
	s.Properties = v
	return s
}

// SetResource sets the Resource field's value.
func (s *M2ManagedApplicationAction) SetResource(v string) *M2ManagedApplicationAction {
	s.Resource = &v
	return s
}

// Specifies the AWS Mainframe Modernization managed application step input.
type M2ManagedApplicationStepInput_ struct {
	_ struct{} `type:"structure"`

	// The action type of the AWS Mainframe Modernization managed application step
	// input.
	//
	// ActionType is a required field
	ActionType *string `locationName:"actionType" type:"string" required:"true" enum:"M2ManagedActionType"`

	// The application ID of the AWS Mainframe Modernization managed application
	// step input.
	//
	// ApplicationId is a required field
	ApplicationId *string `locationName:"applicationId" type:"string" required:"true"`

	// The listener port of the AWS Mainframe Modernization managed application
	// step input.
	ListenerPort *int64 `locationName:"listenerPort" type:"integer"`

	// The properties of the AWS Mainframe Modernization managed application step
	// input.
	Properties *M2ManagedActionProperties `locationName:"properties" type:"structure"`

	// The runtime of the AWS Mainframe Modernization managed application step input.
	//
	// Runtime is a required field
	Runtime *string `locationName:"runtime" type:"string" required:"true"`

	// The VPC endpoint service name of the AWS Mainframe Modernization managed
	// application step input.
	VpcEndpointServiceName *string `locationName:"vpcEndpointServiceName" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s M2ManagedApplicationStepInput_) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s M2ManagedApplicationStepInput_) GoString() string {
	return s.String()
}

// SetActionType sets the ActionType field's value.
func (s *M2ManagedApplicationStepInput_) SetActionType(v string) *M2ManagedApplicationStepInput_ {
	s.ActionType = &v
	return s
}

// SetApplicationId sets the ApplicationId field's value.
func (s *M2ManagedApplicationStepInput_) SetApplicationId(v string) *M2ManagedApplicationStepInput_ {
	s.ApplicationId = &v
	return s
}

// SetListenerPort sets the ListenerPort field's value.
func (s *M2ManagedApplicationStepInput_) SetListenerPort(v int64) *M2ManagedApplicationStepInput_ {
	s.ListenerPort = &v
	return s
}

// SetProperties sets the Properties field's value.
func (s *M2ManagedApplicationStepInput_) SetProperties(v *M2ManagedActionProperties) *M2ManagedApplicationStepInput_ {
	s.Properties = v
	return s
}

// SetRuntime sets the Runtime field's value.
func (s *M2ManagedApplicationStepInput_) SetRuntime(v string) *M2ManagedApplicationStepInput_ {
	s.Runtime = &v
	return s
}

// SetVpcEndpointServiceName sets the VpcEndpointServiceName field's value.
func (s *M2ManagedApplicationStepInput_) SetVpcEndpointServiceName(v string) *M2ManagedApplicationStepInput_ {
	s.VpcEndpointServiceName = &v
	return s
}

// Specifies the AWS Mainframe Modernization managed application step output.
type M2ManagedApplicationStepOutput_ struct {
	_ struct{} `type:"structure"`

	// The import data set summary of the AWS Mainframe Modernization managed application
	// step output.
	ImportDataSetSummary map[string]*string `locationName:"importDataSetSummary" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s M2ManagedApplicationStepOutput_) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s M2ManagedApplicationStepOutput_) GoString() string {
	return s.String()
}

// SetImportDataSetSummary sets the ImportDataSetSummary field's value.
func (s *M2ManagedApplicationStepOutput_) SetImportDataSetSummary(v map[string]*string) *M2ManagedApplicationStepOutput_ {
	s.ImportDataSetSummary = v
	return s
}

// Specifies the AWS Mainframe Modernization managed application step summary.
type M2ManagedApplicationStepSummary struct {
	_ struct{} `type:"structure"`

	// The step input of the AWS Mainframe Modernization managed application step
	// summary.
	//
	// StepInput is a required field
	StepInput *M2ManagedApplicationStepInput_ `locationName:"stepInput" type:"structure" required:"true"`

	// The step output of the AWS Mainframe Modernization managed application step
	// summary.
	StepOutput *M2ManagedApplicationStepOutput_ `locationName:"stepOutput" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s M2ManagedApplicationStepSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s M2ManagedApplicationStepSummary) GoString() string {
	return s.String()
}

// SetStepInput sets the StepInput field's value.
func (s *M2ManagedApplicationStepSummary) SetStepInput(v *M2ManagedApplicationStepInput_) *M2ManagedApplicationStepSummary {
	s.StepInput = v
	return s
}

// SetStepOutput sets the StepOutput field's value.
func (s *M2ManagedApplicationStepSummary) SetStepOutput(v *M2ManagedApplicationStepOutput_) *M2ManagedApplicationStepSummary {
	s.StepOutput = v
	return s
}

// Specifies the AWS Mainframe Modernization managed application summary.
type M2ManagedApplicationSummary struct {
	_ struct{} `type:"structure"`

	// The application ID of the AWS Mainframe Modernization managed application
	// summary.
	//
	// ApplicationId is a required field
	ApplicationId *string `locationName:"applicationId" type:"string" required:"true"`

	// The listener port of the AWS Mainframe Modernization managed application
	// summary.
	ListenerPort *int64 `locationName:"listenerPort" type:"integer"`

	// The runtime of the AWS Mainframe Modernization managed application summary.
	//
	// Runtime is a required field
	Runtime *string `locationName:"runtime" type:"string" required:"true" enum:"M2ManagedRuntime"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s M2ManagedApplicationSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s M2ManagedApplicationSummary) GoString() string {
	return s.String()
}

// SetApplicationId sets the ApplicationId field's value.
func (s *M2ManagedApplicationSummary) SetApplicationId(v string) *M2ManagedApplicationSummary {
	s.ApplicationId = &v
	return s
}

// SetListenerPort sets the ListenerPort field's value.
func (s *M2ManagedApplicationSummary) SetListenerPort(v int64) *M2ManagedApplicationSummary {
	s.ListenerPort = &v
	return s
}

// SetRuntime sets the Runtime field's value.
func (s *M2ManagedApplicationSummary) SetRuntime(v string) *M2ManagedApplicationSummary {
	s.Runtime = &v
	return s
}

// Specifies the AWS Mainframe Modernization non-managed application.
type M2NonManagedApplication struct {
	_ struct{} `type:"structure"`

	// The listener port of the AWS Mainframe Modernization non-managed application.
	//
	// ListenerPort is a required field
	ListenerPort *string `locationName:"listenerPort" type:"string" required:"true"`

	// The runtime of the AWS Mainframe Modernization non-managed application.
	//
	// Runtime is a required field
	Runtime *string `locationName:"runtime" type:"string" required:"true" enum:"M2NonManagedRuntime"`

	// The VPC endpoint service name of the AWS Mainframe Modernization non-managed
	// application.
	//
	// VpcEndpointServiceName is a required field
	VpcEndpointServiceName *string `locationName:"vpcEndpointServiceName" type:"string" required:"true"`

	// The web application name of the AWS Mainframe Modernization non-managed application.
	WebAppName *string `locationName:"webAppName" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s M2NonManagedApplication) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s M2NonManagedApplication) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *M2NonManagedApplication) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "M2NonManagedApplication"}
	if s.ListenerPort == nil {
		invalidParams.Add(request.NewErrParamRequired("ListenerPort"))
	}
	if s.Runtime == nil {
		invalidParams.Add(request.NewErrParamRequired("Runtime"))
	}
	if s.VpcEndpointServiceName == nil {
		invalidParams.Add(request.NewErrParamRequired("VpcEndpointServiceName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetListenerPort sets the ListenerPort field's value.
func (s *M2NonManagedApplication) SetListenerPort(v string) *M2NonManagedApplication {
	s.ListenerPort = &v
	return s
}

// SetRuntime sets the Runtime field's value.
func (s *M2NonManagedApplication) SetRuntime(v string) *M2NonManagedApplication {
	s.Runtime = &v
	return s
}

// SetVpcEndpointServiceName sets the VpcEndpointServiceName field's value.
func (s *M2NonManagedApplication) SetVpcEndpointServiceName(v string) *M2NonManagedApplication {
	s.VpcEndpointServiceName = &v
	return s
}

// SetWebAppName sets the WebAppName field's value.
func (s *M2NonManagedApplication) SetWebAppName(v string) *M2NonManagedApplication {
	s.WebAppName = &v
	return s
}

// Specifies the AWS Mainframe Modernization non-managed application action.
type M2NonManagedApplicationAction struct {
	_ struct{} `type:"structure"`

	// The action type of the AWS Mainframe Modernization non-managed application
	// action.
	//
	// ActionType is a required field
	ActionType *string `locationName:"actionType" type:"string" required:"true" enum:"M2NonManagedActionType"`

	// The resource of the AWS Mainframe Modernization non-managed application action.
	//
	// Resource is a required field
	Resource *string `locationName:"resource" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s M2NonManagedApplicationAction) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s M2NonManagedApplicationAction) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *M2NonManagedApplicationAction) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "M2NonManagedApplicationAction"}
	if s.ActionType == nil {
		invalidParams.Add(request.NewErrParamRequired("ActionType"))
	}
	if s.Resource == nil {
		invalidParams.Add(request.NewErrParamRequired("Resource"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetActionType sets the ActionType field's value.
func (s *M2NonManagedApplicationAction) SetActionType(v string) *M2NonManagedApplicationAction {
	s.ActionType = &v
	return s
}

// SetResource sets the Resource field's value.
func (s *M2NonManagedApplicationAction) SetResource(v string) *M2NonManagedApplicationAction {
	s.Resource = &v
	return s
}

// Specifies the AWS Mainframe Modernization non-managed application step input.
type M2NonManagedApplicationStepInput_ struct {
	_ struct{} `type:"structure"`

	// The action type of the AWS Mainframe Modernization non-managed application
	// step input.
	//
	// ActionType is a required field
	ActionType *string `locationName:"actionType" type:"string" required:"true" enum:"M2NonManagedActionType"`

	// The listener port of the AWS Mainframe Modernization non-managed application
	// step input.
	//
	// ListenerPort is a required field
	ListenerPort *int64 `locationName:"listenerPort" type:"integer" required:"true"`

	// The runtime of the AWS Mainframe Modernization non-managed application step
	// input.
	//
	// Runtime is a required field
	Runtime *string `locationName:"runtime" type:"string" required:"true" enum:"M2NonManagedRuntime"`

	// The VPC endpoint service name of the AWS Mainframe Modernization non-managed
	// application step input.
	//
	// VpcEndpointServiceName is a required field
	VpcEndpointServiceName *string `locationName:"vpcEndpointServiceName" type:"string" required:"true"`

	// The web app name of the AWS Mainframe Modernization non-managed application
	// step input.
	WebAppName *string `locationName:"webAppName" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s M2NonManagedApplicationStepInput_) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s M2NonManagedApplicationStepInput_) GoString() string {
	return s.String()
}

// SetActionType sets the ActionType field's value.
func (s *M2NonManagedApplicationStepInput_) SetActionType(v string) *M2NonManagedApplicationStepInput_ {
	s.ActionType = &v
	return s
}

// SetListenerPort sets the ListenerPort field's value.
func (s *M2NonManagedApplicationStepInput_) SetListenerPort(v int64) *M2NonManagedApplicationStepInput_ {
	s.ListenerPort = &v
	return s
}

// SetRuntime sets the Runtime field's value.
func (s *M2NonManagedApplicationStepInput_) SetRuntime(v string) *M2NonManagedApplicationStepInput_ {
	s.Runtime = &v
	return s
}

// SetVpcEndpointServiceName sets the VpcEndpointServiceName field's value.
func (s *M2NonManagedApplicationStepInput_) SetVpcEndpointServiceName(v string) *M2NonManagedApplicationStepInput_ {
	s.VpcEndpointServiceName = &v
	return s
}

// SetWebAppName sets the WebAppName field's value.
func (s *M2NonManagedApplicationStepInput_) SetWebAppName(v string) *M2NonManagedApplicationStepInput_ {
	s.WebAppName = &v
	return s
}

// Specifies the AWS Mainframe Modernization non-managed application step output.
type M2NonManagedApplicationStepOutput_ struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s M2NonManagedApplicationStepOutput_) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s M2NonManagedApplicationStepOutput_) GoString() string {
	return s.String()
}

// Specifies the AWS Mainframe Modernization non-managed application step summary.
type M2NonManagedApplicationStepSummary struct {
	_ struct{} `type:"structure"`

	// The step input of the AWS Mainframe Modernization non-managed application
	// step summary.
	//
	// StepInput is a required field
	StepInput *M2NonManagedApplicationStepInput_ `locationName:"stepInput" type:"structure" required:"true"`

	// The step output of the AWS Mainframe Modernization non-managed application
	// step summary.
	StepOutput *M2NonManagedApplicationStepOutput_ `locationName:"stepOutput" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s M2NonManagedApplicationStepSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s M2NonManagedApplicationStepSummary) GoString() string {
	return s.String()
}

// SetStepInput sets the StepInput field's value.
func (s *M2NonManagedApplicationStepSummary) SetStepInput(v *M2NonManagedApplicationStepInput_) *M2NonManagedApplicationStepSummary {
	s.StepInput = v
	return s
}

// SetStepOutput sets the StepOutput field's value.
func (s *M2NonManagedApplicationStepSummary) SetStepOutput(v *M2NonManagedApplicationStepOutput_) *M2NonManagedApplicationStepSummary {
	s.StepOutput = v
	return s
}

// Specifies the AWS Mainframe Modernization non-managed application summary.
type M2NonManagedApplicationSummary struct {
	_ struct{} `type:"structure"`

	// The listener port of the AWS Mainframe Modernization non-managed application
	// summary.
	//
	// ListenerPort is a required field
	ListenerPort *int64 `locationName:"listenerPort" type:"integer" required:"true"`

	// The runtime of the AWS Mainframe Modernization non-managed application summary.
	//
	// Runtime is a required field
	Runtime *string `locationName:"runtime" type:"string" required:"true" enum:"M2NonManagedRuntime"`

	// The VPC endpoint service name of the AWS Mainframe Modernization non-managed
	// application summary.
	//
	// VpcEndpointServiceName is a required field
	VpcEndpointServiceName *string `locationName:"vpcEndpointServiceName" type:"string" required:"true"`

	// The web application name of the AWS Mainframe Modernization non-managed application
	// summary.
	WebAppName *string `locationName:"webAppName" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s M2NonManagedApplicationSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s M2NonManagedApplicationSummary) GoString() string {
	return s.String()
}

// SetListenerPort sets the ListenerPort field's value.
func (s *M2NonManagedApplicationSummary) SetListenerPort(v int64) *M2NonManagedApplicationSummary {
	s.ListenerPort = &v
	return s
}

// SetRuntime sets the Runtime field's value.
func (s *M2NonManagedApplicationSummary) SetRuntime(v string) *M2NonManagedApplicationSummary {
	s.Runtime = &v
	return s
}

// SetVpcEndpointServiceName sets the VpcEndpointServiceName field's value.
func (s *M2NonManagedApplicationSummary) SetVpcEndpointServiceName(v string) *M2NonManagedApplicationSummary {
	s.VpcEndpointServiceName = &v
	return s
}

// SetWebAppName sets the WebAppName field's value.
func (s *M2NonManagedApplicationSummary) SetWebAppName(v string) *M2NonManagedApplicationSummary {
	s.WebAppName = &v
	return s
}

// Specifies the mainframe action.
type MainframeAction struct {
	_ struct{} `type:"structure"`

	// The action type of the mainframe action.
	//
	// ActionType is a required field
	ActionType *MainframeActionType `locationName:"actionType" type:"structure" required:"true"`

	// The properties of the mainframe action.
	Properties *MainframeActionProperties `locationName:"properties" type:"structure"`

	// The resource of the mainframe action.
	//
	// Resource is a required field
	Resource *string `locationName:"resource" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MainframeAction) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MainframeAction) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MainframeAction) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "MainframeAction"}
	if s.ActionType == nil {
		invalidParams.Add(request.NewErrParamRequired("ActionType"))
	}
	if s.Resource == nil {
		invalidParams.Add(request.NewErrParamRequired("Resource"))
	}
	if s.ActionType != nil {
		if err := s.ActionType.Validate(); err != nil {
			invalidParams.AddNested("ActionType", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetActionType sets the ActionType field's value.
func (s *MainframeAction) SetActionType(v *MainframeActionType) *MainframeAction {
	s.ActionType = v
	return s
}

// SetProperties sets the Properties field's value.
func (s *MainframeAction) SetProperties(v *MainframeActionProperties) *MainframeAction {
	s.Properties = v
	return s
}

// SetResource sets the Resource field's value.
func (s *MainframeAction) SetResource(v string) *MainframeAction {
	s.Resource = &v
	return s
}

// Specifies the mainframe action properties.
type MainframeActionProperties struct {
	_ struct{} `type:"structure"`

	// The DMS task ARN of the mainframe action properties.
	DmsTaskArn *string `locationName:"dmsTaskArn" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MainframeActionProperties) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MainframeActionProperties) GoString() string {
	return s.String()
}

// SetDmsTaskArn sets the DmsTaskArn field's value.
func (s *MainframeActionProperties) SetDmsTaskArn(v string) *MainframeActionProperties {
	s.DmsTaskArn = &v
	return s
}

// Specifies the mainframe action summary.
type MainframeActionSummary struct {
	_ struct{} `type:"structure"`

	// The batch of the mainframe action summary.
	Batch *BatchSummary `locationName:"batch" type:"structure"`

	// The tn3270 port of the mainframe action summary.
	Tn3270 *TN3270Summary `locationName:"tn3270" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MainframeActionSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MainframeActionSummary) GoString() string {
	return s.String()
}

// SetBatch sets the Batch field's value.
func (s *MainframeActionSummary) SetBatch(v *BatchSummary) *MainframeActionSummary {
	s.Batch = v
	return s
}

// SetTn3270 sets the Tn3270 field's value.
func (s *MainframeActionSummary) SetTn3270(v *TN3270Summary) *MainframeActionSummary {
	s.Tn3270 = v
	return s
}

// Specifies the mainframe action type.
type MainframeActionType struct {
	_ struct{} `type:"structure"`

	// The batch of the mainframe action type.
	Batch *Batch `locationName:"batch" type:"structure"`

	// The tn3270 port of the mainframe action type.
	Tn3270 *TN3270 `locationName:"tn3270" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MainframeActionType) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MainframeActionType) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MainframeActionType) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "MainframeActionType"}
	if s.Batch != nil {
		if err := s.Batch.Validate(); err != nil {
			invalidParams.AddNested("Batch", err.(request.ErrInvalidParams))
		}
	}
	if s.Tn3270 != nil {
		if err := s.Tn3270.Validate(); err != nil {
			invalidParams.AddNested("Tn3270", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBatch sets the Batch field's value.
func (s *MainframeActionType) SetBatch(v *Batch) *MainframeActionType {
	s.Batch = v
	return s
}

// SetTn3270 sets the Tn3270 field's value.
func (s *MainframeActionType) SetTn3270(v *TN3270) *MainframeActionType {
	s.Tn3270 = v
	return s
}

// Specifies the mainframe resource summary.
type MainframeResourceSummary struct {
	_ struct{} `type:"structure"`

	// The AWS Mainframe Modernization managed application in the mainframe resource
	// summary.
	M2ManagedApplication *M2ManagedApplicationSummary `locationName:"m2ManagedApplication" type:"structure"`

	// The AWS Mainframe Modernization non-managed application in the mainframe
	// resource summary.
	M2NonManagedApplication *M2NonManagedApplicationSummary `locationName:"m2NonManagedApplication" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MainframeResourceSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MainframeResourceSummary) GoString() string {
	return s.String()
}

// SetM2ManagedApplication sets the M2ManagedApplication field's value.
func (s *MainframeResourceSummary) SetM2ManagedApplication(v *M2ManagedApplicationSummary) *MainframeResourceSummary {
	s.M2ManagedApplication = v
	return s
}

// SetM2NonManagedApplication sets the M2NonManagedApplication field's value.
func (s *MainframeResourceSummary) SetM2NonManagedApplication(v *M2NonManagedApplicationSummary) *MainframeResourceSummary {
	s.M2NonManagedApplication = v
	return s
}

// Specifies an output file.
type OutputFile struct {
	_ struct{} `type:"structure"`

	// The file location of the output file.
	FileLocation *string `locationName:"fileLocation" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OutputFile) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OutputFile) GoString() string {
	return s.String()
}

// SetFileLocation sets the FileLocation field's value.
func (s *OutputFile) SetFileLocation(v string) *OutputFile {
	s.FileLocation = &v
	return s
}

// Specifies an output.
type Output_ struct {
	_ struct{} `type:"structure"`

	// The file of the output.
	File *OutputFile `locationName:"file" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Output_) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Output_) GoString() string {
	return s.String()
}

// SetFile sets the File field's value.
func (s *Output_) SetFile(v *OutputFile) *Output_ {
	s.File = v
	return s
}

// Specifies a resource.
type Resource struct {
	_ struct{} `type:"structure"`

	// The name of the resource.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// The type of the resource.
	//
	// Type is a required field
	Type *ResourceType `locationName:"type" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Resource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Resource) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Resource) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Resource"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}
	if s.Type != nil {
		if err := s.Type.Validate(); err != nil {
			invalidParams.AddNested("Type", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *Resource) SetName(v string) *Resource {
	s.Name = &v
	return s
}

// SetType sets the Type field's value.
func (s *Resource) SetType(v *ResourceType) *Resource {
	s.Type = v
	return s
}

// Specifies a resource action.
type ResourceAction struct {
	_ struct{} `type:"structure"`

	// The CloudFormation action of the resource action.
	CloudFormationAction *CloudFormationAction `locationName:"cloudFormationAction" type:"structure"`

	// The AWS Mainframe Modernization managed application action of the resource
	// action.
	M2ManagedApplicationAction *M2ManagedApplicationAction `locationName:"m2ManagedApplicationAction" type:"structure"`

	// The AWS Mainframe Modernization non-managed application action of the resource
	// action.
	M2NonManagedApplicationAction *M2NonManagedApplicationAction `locationName:"m2NonManagedApplicationAction" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceAction) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceAction) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ResourceAction) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ResourceAction"}
	if s.CloudFormationAction != nil {
		if err := s.CloudFormationAction.Validate(); err != nil {
			invalidParams.AddNested("CloudFormationAction", err.(request.ErrInvalidParams))
		}
	}
	if s.M2ManagedApplicationAction != nil {
		if err := s.M2ManagedApplicationAction.Validate(); err != nil {
			invalidParams.AddNested("M2ManagedApplicationAction", err.(request.ErrInvalidParams))
		}
	}
	if s.M2NonManagedApplicationAction != nil {
		if err := s.M2NonManagedApplicationAction.Validate(); err != nil {
			invalidParams.AddNested("M2NonManagedApplicationAction", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCloudFormationAction sets the CloudFormationAction field's value.
func (s *ResourceAction) SetCloudFormationAction(v *CloudFormationAction) *ResourceAction {
	s.CloudFormationAction = v
	return s
}

// SetM2ManagedApplicationAction sets the M2ManagedApplicationAction field's value.
func (s *ResourceAction) SetM2ManagedApplicationAction(v *M2ManagedApplicationAction) *ResourceAction {
	s.M2ManagedApplicationAction = v
	return s
}

// SetM2NonManagedApplicationAction sets the M2NonManagedApplicationAction field's value.
func (s *ResourceAction) SetM2NonManagedApplicationAction(v *M2NonManagedApplicationAction) *ResourceAction {
	s.M2NonManagedApplicationAction = v
	return s
}

// Specifies the resource action summary.
type ResourceActionSummary struct {
	_ struct{} `type:"structure"`

	// The CloudFormation template of the resource action summary.
	CloudFormation *CloudFormationStepSummary `locationName:"cloudFormation" type:"structure"`

	// The AWS Mainframe Modernization managed application of the resource action
	// summary.
	M2ManagedApplication *M2ManagedApplicationStepSummary `locationName:"m2ManagedApplication" type:"structure"`

	// The AWS Mainframe Modernization non-managed application of the resource action
	// summary.
	M2NonManagedApplication *M2NonManagedApplicationStepSummary `locationName:"m2NonManagedApplication" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceActionSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceActionSummary) GoString() string {
	return s.String()
}

// SetCloudFormation sets the CloudFormation field's value.
func (s *ResourceActionSummary) SetCloudFormation(v *CloudFormationStepSummary) *ResourceActionSummary {
	s.CloudFormation = v
	return s
}

// SetM2ManagedApplication sets the M2ManagedApplication field's value.
func (s *ResourceActionSummary) SetM2ManagedApplication(v *M2ManagedApplicationStepSummary) *ResourceActionSummary {
	s.M2ManagedApplication = v
	return s
}

// SetM2NonManagedApplication sets the M2NonManagedApplication field's value.
func (s *ResourceActionSummary) SetM2NonManagedApplication(v *M2NonManagedApplicationStepSummary) *ResourceActionSummary {
	s.M2NonManagedApplication = v
	return s
}

// The specified resource was not found.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`

	// The resource ID of the resource not found.
	ResourceId *string `locationName:"resourceId" type:"string"`

	// The resource type of the resource not found.
	ResourceType *string `locationName:"resourceType" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Specifies the resource type.
type ResourceType struct {
	_ struct{} `type:"structure"`

	// The CloudFormation template of the resource type.
	CloudFormation *CloudFormation `locationName:"cloudFormation" type:"structure"`

	// The AWS Mainframe Modernization managed application of the resource type.
	M2ManagedApplication *M2ManagedApplication `locationName:"m2ManagedApplication" type:"structure"`

	// The AWS Mainframe Modernization non-managed application of the resource type.
	M2NonManagedApplication *M2NonManagedApplication `locationName:"m2NonManagedApplication" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceType) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceType) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ResourceType) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ResourceType"}
	if s.CloudFormation != nil {
		if err := s.CloudFormation.Validate(); err != nil {
			invalidParams.AddNested("CloudFormation", err.(request.ErrInvalidParams))
		}
	}
	if s.M2ManagedApplication != nil {
		if err := s.M2ManagedApplication.Validate(); err != nil {
			invalidParams.AddNested("M2ManagedApplication", err.(request.ErrInvalidParams))
		}
	}
	if s.M2NonManagedApplication != nil {
		if err := s.M2NonManagedApplication.Validate(); err != nil {
			invalidParams.AddNested("M2NonManagedApplication", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCloudFormation sets the CloudFormation field's value.
func (s *ResourceType) SetCloudFormation(v *CloudFormation) *ResourceType {
	s.CloudFormation = v
	return s
}

// SetM2ManagedApplication sets the M2ManagedApplication field's value.
func (s *ResourceType) SetM2ManagedApplication(v *M2ManagedApplication) *ResourceType {
	s.M2ManagedApplication = v
	return s
}

// SetM2NonManagedApplication sets the M2NonManagedApplication field's value.
func (s *ResourceType) SetM2NonManagedApplication(v *M2NonManagedApplication) *ResourceType {
	s.M2NonManagedApplication = v
	return s
}

// Specifies the script.
type Script struct {
	_ struct{} `type:"structure"`

	// The script location of the scripts.
	//
	// ScriptLocation is a required field
	ScriptLocation *string `locationName:"scriptLocation" type:"string" required:"true"`

	// The type of the scripts.
	//
	// Type is a required field
	Type *string `locationName:"type" type:"string" required:"true" enum:"ScriptType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Script) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Script) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Script) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Script"}
	if s.ScriptLocation == nil {
		invalidParams.Add(request.NewErrParamRequired("ScriptLocation"))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetScriptLocation sets the ScriptLocation field's value.
func (s *Script) SetScriptLocation(v string) *Script {
	s.ScriptLocation = &v
	return s
}

// SetType sets the Type field's value.
func (s *Script) SetType(v string) *Script {
	s.Type = &v
	return s
}

// Specifies the scripts summary.
type ScriptSummary struct {
	_ struct{} `type:"structure"`

	// The script location of the script summary.
	//
	// ScriptLocation is a required field
	ScriptLocation *string `locationName:"scriptLocation" type:"string" required:"true"`

	// The type of the script summary.
	//
	// Type is a required field
	Type *string `locationName:"type" type:"string" required:"true" enum:"ScriptType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ScriptSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ScriptSummary) GoString() string {
	return s.String()
}

// SetScriptLocation sets the ScriptLocation field's value.
func (s *ScriptSummary) SetScriptLocation(v string) *ScriptSummary {
	s.ScriptLocation = &v
	return s
}

// SetType sets the Type field's value.
func (s *ScriptSummary) SetType(v string) *ScriptSummary {
	s.Type = &v
	return s
}

// One or more quotas for AWS Application Testing exceeds the limit.
type ServiceQuotaExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`

	// The quote codes of AWS Application Testing that exceeded the limit.
	QuotaCode *string `locationName:"quotaCode" type:"string"`

	// The resource ID of AWS Application Testing that exceeded the limit.
	ResourceId *string `locationName:"resourceId" type:"string"`

	// The resource type of AWS Application Testing that exceeded the limit.
	ResourceType *string `locationName:"resourceType" type:"string"`

	// The service code of AWS Application Testing that exceeded the limit.
	ServiceCode *string `locationName:"serviceCode" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) GoString() string {
	return s.String()
}

func newErrorServiceQuotaExceededException(v protocol.ResponseMetadata) error {
	return &ServiceQuotaExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServiceQuotaExceededException) Code() string {
	return "ServiceQuotaExceededException"
}

// Message returns the exception's message.
func (s *ServiceQuotaExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServiceQuotaExceededException) OrigErr() error {
	return nil
}

func (s *ServiceQuotaExceededException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServiceQuotaExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServiceQuotaExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Specifies the service settings.
type ServiceSettings struct {
	_ struct{} `type:"structure"`

	// The KMS key ID of the service settings.
	KmsKeyId *string `locationName:"kmsKeyId" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceSettings) GoString() string {
	return s.String()
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *ServiceSettings) SetKmsKeyId(v string) *ServiceSettings {
	s.KmsKeyId = &v
	return s
}

// Specifies the source database metadata.
type SourceDatabaseMetadata struct {
	_ struct{} `type:"structure"`

	// The capture tool of the source database metadata.
	//
	// CaptureTool is a required field
	CaptureTool *string `locationName:"captureTool" type:"string" required:"true" enum:"CaptureTool"`

	// The type of the source database metadata.
	//
	// Type is a required field
	Type *string `locationName:"type" type:"string" required:"true" enum:"SourceDatabase"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SourceDatabaseMetadata) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SourceDatabaseMetadata) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SourceDatabaseMetadata) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SourceDatabaseMetadata"}
	if s.CaptureTool == nil {
		invalidParams.Add(request.NewErrParamRequired("CaptureTool"))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCaptureTool sets the CaptureTool field's value.
func (s *SourceDatabaseMetadata) SetCaptureTool(v string) *SourceDatabaseMetadata {
	s.CaptureTool = &v
	return s
}

// SetType sets the Type field's value.
func (s *SourceDatabaseMetadata) SetType(v string) *SourceDatabaseMetadata {
	s.Type = &v
	return s
}

type StartTestRunInput struct {
	_ struct{} `type:"structure"`

	// The client token of the test run.
	ClientToken *string `locationName:"clientToken" type:"string" idempotencyToken:"true"`

	// The tags of the test run.
	Tags map[string]*string `locationName:"tags" type:"map"`

	// The configuration ID of the test run.
	TestConfigurationId *string `locationName:"testConfigurationId" type:"string"`

	// The test suite ID of the test run.
	//
	// TestSuiteId is a required field
	TestSuiteId *string `locationName:"testSuiteId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartTestRunInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartTestRunInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartTestRunInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartTestRunInput"}
	if s.TestSuiteId == nil {
		invalidParams.Add(request.NewErrParamRequired("TestSuiteId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *StartTestRunInput) SetClientToken(v string) *StartTestRunInput {
	s.ClientToken = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *StartTestRunInput) SetTags(v map[string]*string) *StartTestRunInput {
	s.Tags = v
	return s
}

// SetTestConfigurationId sets the TestConfigurationId field's value.
func (s *StartTestRunInput) SetTestConfigurationId(v string) *StartTestRunInput {
	s.TestConfigurationId = &v
	return s
}

// SetTestSuiteId sets the TestSuiteId field's value.
func (s *StartTestRunInput) SetTestSuiteId(v string) *StartTestRunInput {
	s.TestSuiteId = &v
	return s
}

type StartTestRunOutput struct {
	_ struct{} `type:"structure"`

	// The test run ID of the test run.
	//
	// TestRunId is a required field
	TestRunId *string `locationName:"testRunId" type:"string" required:"true"`

	// The test run status of the test run.
	//
	// TestRunStatus is a required field
	TestRunStatus *string `locationName:"testRunStatus" type:"string" required:"true" enum:"TestRunStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartTestRunOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartTestRunOutput) GoString() string {
	return s.String()
}

// SetTestRunId sets the TestRunId field's value.
func (s *StartTestRunOutput) SetTestRunId(v string) *StartTestRunOutput {
	s.TestRunId = &v
	return s
}

// SetTestRunStatus sets the TestRunStatus field's value.
func (s *StartTestRunOutput) SetTestRunStatus(v string) *StartTestRunOutput {
	s.TestRunStatus = &v
	return s
}

// Defines a step.
type Step struct {
	_ struct{} `type:"structure"`

	// The action of the step.
	//
	// Action is a required field
	Action *StepAction `locationName:"action" type:"structure" required:"true"`

	// The description of the step.
	Description *string `locationName:"description" type:"string"`

	// The name of the step.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Step) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Step) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Step) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Step"}
	if s.Action == nil {
		invalidParams.Add(request.NewErrParamRequired("Action"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Action != nil {
		if err := s.Action.Validate(); err != nil {
			invalidParams.AddNested("Action", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAction sets the Action field's value.
func (s *Step) SetAction(v *StepAction) *Step {
	s.Action = v
	return s
}

// SetDescription sets the Description field's value.
func (s *Step) SetDescription(v string) *Step {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *Step) SetName(v string) *Step {
	s.Name = &v
	return s
}

// Specifies a step action.
type StepAction struct {
	_ struct{} `type:"structure"`

	// The compare action of the step action.
	CompareAction *CompareAction `locationName:"compareAction" type:"structure"`

	// The mainframe action of the step action.
	MainframeAction *MainframeAction `locationName:"mainframeAction" type:"structure"`

	// The resource action of the step action.
	ResourceAction *ResourceAction `locationName:"resourceAction" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StepAction) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StepAction) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StepAction) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StepAction"}
	if s.CompareAction != nil {
		if err := s.CompareAction.Validate(); err != nil {
			invalidParams.AddNested("CompareAction", err.(request.ErrInvalidParams))
		}
	}
	if s.MainframeAction != nil {
		if err := s.MainframeAction.Validate(); err != nil {
			invalidParams.AddNested("MainframeAction", err.(request.ErrInvalidParams))
		}
	}
	if s.ResourceAction != nil {
		if err := s.ResourceAction.Validate(); err != nil {
			invalidParams.AddNested("ResourceAction", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCompareAction sets the CompareAction field's value.
func (s *StepAction) SetCompareAction(v *CompareAction) *StepAction {
	s.CompareAction = v
	return s
}

// SetMainframeAction sets the MainframeAction field's value.
func (s *StepAction) SetMainframeAction(v *MainframeAction) *StepAction {
	s.MainframeAction = v
	return s
}

// SetResourceAction sets the ResourceAction field's value.
func (s *StepAction) SetResourceAction(v *ResourceAction) *StepAction {
	s.ResourceAction = v
	return s
}

// Defines the step run summary.
type StepRunSummary struct {
	_ struct{} `type:"structure"`

	// The compare action of the step run summary.
	CompareAction *CompareActionSummary `locationName:"compareAction" type:"structure"`

	// The mainframe action of the step run summary.
	MainframeAction *MainframeActionSummary `locationName:"mainframeAction" type:"structure"`

	// The resource action of the step run summary.
	ResourceAction *ResourceActionSummary `locationName:"resourceAction" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StepRunSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StepRunSummary) GoString() string {
	return s.String()
}

// SetCompareAction sets the CompareAction field's value.
func (s *StepRunSummary) SetCompareAction(v *CompareActionSummary) *StepRunSummary {
	s.CompareAction = v
	return s
}

// SetMainframeAction sets the MainframeAction field's value.
func (s *StepRunSummary) SetMainframeAction(v *MainframeActionSummary) *StepRunSummary {
	s.MainframeAction = v
	return s
}

// SetResourceAction sets the ResourceAction field's value.
func (s *StepRunSummary) SetResourceAction(v *ResourceActionSummary) *StepRunSummary {
	s.ResourceAction = v
	return s
}

// Specifies the TN3270 protocol.
type TN3270 struct {
	_ struct{} `type:"structure"`

	// The data set names of the TN3270 protocol.
	ExportDataSetNames []*string `locationName:"exportDataSetNames" type:"list"`

	// The script of the TN3270 protocol.
	//
	// Script is a required field
	Script *Script `locationName:"script" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TN3270) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TN3270) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TN3270) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TN3270"}
	if s.Script == nil {
		invalidParams.Add(request.NewErrParamRequired("Script"))
	}
	if s.Script != nil {
		if err := s.Script.Validate(); err != nil {
			invalidParams.AddNested("Script", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetExportDataSetNames sets the ExportDataSetNames field's value.
func (s *TN3270) SetExportDataSetNames(v []*string) *TN3270 {
	s.ExportDataSetNames = v
	return s
}

// SetScript sets the Script field's value.
func (s *TN3270) SetScript(v *Script) *TN3270 {
	s.Script = v
	return s
}

// Specifies a TN3270 step input.
type TN3270StepInput_ struct {
	_ struct{} `type:"structure"`

	// The export data set names of the TN3270 step input.
	ExportDataSetNames []*string `locationName:"exportDataSetNames" type:"list"`

	// The properties of the TN3270 step input.
	Properties *MainframeActionProperties `locationName:"properties" type:"structure"`

	// The resource of the TN3270 step input.
	//
	// Resource is a required field
	Resource *MainframeResourceSummary `locationName:"resource" type:"structure" required:"true"`

	// The script of the TN3270 step input.
	//
	// Script is a required field
	Script *ScriptSummary `locationName:"script" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TN3270StepInput_) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TN3270StepInput_) GoString() string {
	return s.String()
}

// SetExportDataSetNames sets the ExportDataSetNames field's value.
func (s *TN3270StepInput_) SetExportDataSetNames(v []*string) *TN3270StepInput_ {
	s.ExportDataSetNames = v
	return s
}

// SetProperties sets the Properties field's value.
func (s *TN3270StepInput_) SetProperties(v *MainframeActionProperties) *TN3270StepInput_ {
	s.Properties = v
	return s
}

// SetResource sets the Resource field's value.
func (s *TN3270StepInput_) SetResource(v *MainframeResourceSummary) *TN3270StepInput_ {
	s.Resource = v
	return s
}

// SetScript sets the Script field's value.
func (s *TN3270StepInput_) SetScript(v *ScriptSummary) *TN3270StepInput_ {
	s.Script = v
	return s
}

// Specifies a TN3270 step output.
type TN3270StepOutput_ struct {
	_ struct{} `type:"structure"`

	// The data set details of the TN3270 step output.
	DataSetDetails []*DataSet `locationName:"dataSetDetails" type:"list"`

	// The data set export location of the TN3270 step output.
	DataSetExportLocation *string `locationName:"dataSetExportLocation" type:"string"`

	// The output location of the TN3270 step output.
	DmsOutputLocation *string `locationName:"dmsOutputLocation" type:"string"`

	// The script output location of the TN3270 step output.
	//
	// ScriptOutputLocation is a required field
	ScriptOutputLocation *string `locationName:"scriptOutputLocation" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TN3270StepOutput_) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TN3270StepOutput_) GoString() string {
	return s.String()
}

// SetDataSetDetails sets the DataSetDetails field's value.
func (s *TN3270StepOutput_) SetDataSetDetails(v []*DataSet) *TN3270StepOutput_ {
	s.DataSetDetails = v
	return s
}

// SetDataSetExportLocation sets the DataSetExportLocation field's value.
func (s *TN3270StepOutput_) SetDataSetExportLocation(v string) *TN3270StepOutput_ {
	s.DataSetExportLocation = &v
	return s
}

// SetDmsOutputLocation sets the DmsOutputLocation field's value.
func (s *TN3270StepOutput_) SetDmsOutputLocation(v string) *TN3270StepOutput_ {
	s.DmsOutputLocation = &v
	return s
}

// SetScriptOutputLocation sets the ScriptOutputLocation field's value.
func (s *TN3270StepOutput_) SetScriptOutputLocation(v string) *TN3270StepOutput_ {
	s.ScriptOutputLocation = &v
	return s
}

// Specifies a TN3270 summary.
type TN3270Summary struct {
	_ struct{} `type:"structure"`

	// The step input of the TN3270 summary.
	//
	// StepInput is a required field
	StepInput *TN3270StepInput_ `locationName:"stepInput" type:"structure" required:"true"`

	// The step output of the TN3270 summary.
	StepOutput *TN3270StepOutput_ `locationName:"stepOutput" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TN3270Summary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TN3270Summary) GoString() string {
	return s.String()
}

// SetStepInput sets the StepInput field's value.
func (s *TN3270Summary) SetStepInput(v *TN3270StepInput_) *TN3270Summary {
	s.StepInput = v
	return s
}

// SetStepOutput sets the StepOutput field's value.
func (s *TN3270Summary) SetStepOutput(v *TN3270StepOutput_) *TN3270Summary {
	s.StepOutput = v
	return s
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the tag resource.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" type:"string" required:"true"`

	// The tags of the resource.
	//
	// Tags is a required field
	Tags map[string]*string `locationName:"tags" type:"map" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *TagResourceInput) SetResourceArn(v string) *TagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v map[string]*string) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) GoString() string {
	return s.String()
}

// Specifies a target database metadata.
type TargetDatabaseMetadata struct {
	_ struct{} `type:"structure"`

	// The capture tool of the target database metadata.
	//
	// CaptureTool is a required field
	CaptureTool *string `locationName:"captureTool" type:"string" required:"true" enum:"CaptureTool"`

	// The type of the target database metadata.
	//
	// Type is a required field
	Type *string `locationName:"type" type:"string" required:"true" enum:"TargetDatabase"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TargetDatabaseMetadata) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TargetDatabaseMetadata) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TargetDatabaseMetadata) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TargetDatabaseMetadata"}
	if s.CaptureTool == nil {
		invalidParams.Add(request.NewErrParamRequired("CaptureTool"))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCaptureTool sets the CaptureTool field's value.
func (s *TargetDatabaseMetadata) SetCaptureTool(v string) *TargetDatabaseMetadata {
	s.CaptureTool = &v
	return s
}

// SetType sets the Type field's value.
func (s *TargetDatabaseMetadata) SetType(v string) *TargetDatabaseMetadata {
	s.Type = &v
	return s
}

// Specifies the latest version of a test case.
type TestCaseLatestVersion struct {
	_ struct{} `type:"structure"`

	// The status of the test case latest version.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"TestCaseLifecycle"`

	// The status reason of the test case latest version.
	StatusReason *string `locationName:"statusReason" type:"string"`

	// The version of the test case latest version.
	//
	// Version is a required field
	Version *int64 `locationName:"version" type:"integer" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TestCaseLatestVersion) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TestCaseLatestVersion) GoString() string {
	return s.String()
}

// SetStatus sets the Status field's value.
func (s *TestCaseLatestVersion) SetStatus(v string) *TestCaseLatestVersion {
	s.Status = &v
	return s
}

// SetStatusReason sets the StatusReason field's value.
func (s *TestCaseLatestVersion) SetStatusReason(v string) *TestCaseLatestVersion {
	s.StatusReason = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *TestCaseLatestVersion) SetVersion(v int64) *TestCaseLatestVersion {
	s.Version = &v
	return s
}

// Specifies the test case run summary.
type TestCaseRunSummary struct {
	_ struct{} `type:"structure"`

	// The run end time of the test case run summary.
	RunEndTime *time.Time `locationName:"runEndTime" type:"timestamp"`

	// The run start time of the test case run summary.
	//
	// RunStartTime is a required field
	RunStartTime *time.Time `locationName:"runStartTime" type:"timestamp" required:"true"`

	// The status of the test case run summary.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"TestCaseRunStatus"`

	// The status reason of the test case run summary.
	StatusReason *string `locationName:"statusReason" type:"string"`

	// The test case id of the test case run summary.
	//
	// TestCaseId is a required field
	TestCaseId *string `locationName:"testCaseId" type:"string" required:"true"`

	// The test case version of the test case run summary.
	//
	// TestCaseVersion is a required field
	TestCaseVersion *int64 `locationName:"testCaseVersion" type:"integer" required:"true"`

	// The test run id of the test case run summary.
	//
	// TestRunId is a required field
	TestRunId *string `locationName:"testRunId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TestCaseRunSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TestCaseRunSummary) GoString() string {
	return s.String()
}

// SetRunEndTime sets the RunEndTime field's value.
func (s *TestCaseRunSummary) SetRunEndTime(v time.Time) *TestCaseRunSummary {
	s.RunEndTime = &v
	return s
}

// SetRunStartTime sets the RunStartTime field's value.
func (s *TestCaseRunSummary) SetRunStartTime(v time.Time) *TestCaseRunSummary {
	s.RunStartTime = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *TestCaseRunSummary) SetStatus(v string) *TestCaseRunSummary {
	s.Status = &v
	return s
}

// SetStatusReason sets the StatusReason field's value.
func (s *TestCaseRunSummary) SetStatusReason(v string) *TestCaseRunSummary {
	s.StatusReason = &v
	return s
}

// SetTestCaseId sets the TestCaseId field's value.
func (s *TestCaseRunSummary) SetTestCaseId(v string) *TestCaseRunSummary {
	s.TestCaseId = &v
	return s
}

// SetTestCaseVersion sets the TestCaseVersion field's value.
func (s *TestCaseRunSummary) SetTestCaseVersion(v int64) *TestCaseRunSummary {
	s.TestCaseVersion = &v
	return s
}

// SetTestRunId sets the TestRunId field's value.
func (s *TestCaseRunSummary) SetTestRunId(v string) *TestCaseRunSummary {
	s.TestRunId = &v
	return s
}

// Specifies a test case summary.
type TestCaseSummary struct {
	_ struct{} `type:"structure"`

	// The creation time of the test case summary.
	//
	// CreationTime is a required field
	CreationTime *time.Time `locationName:"creationTime" type:"timestamp" required:"true"`

	// The last update time of the test case summary.
	//
	// LastUpdateTime is a required field
	LastUpdateTime *time.Time `locationName:"lastUpdateTime" type:"timestamp" required:"true"`

	// The latest version of the test case summary.
	//
	// LatestVersion is a required field
	LatestVersion *int64 `locationName:"latestVersion" type:"integer" required:"true"`

	// The name of the test case summary.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// The status of the test case summary.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"TestCaseLifecycle"`

	// The status reason of the test case summary.
	StatusReason *string `locationName:"statusReason" type:"string"`

	// The test case Amazon Resource Name (ARN) of the test case summary.
	//
	// TestCaseArn is a required field
	TestCaseArn *string `locationName:"testCaseArn" type:"string" required:"true"`

	// The test case ID of the test case summary.
	//
	// TestCaseId is a required field
	TestCaseId *string `locationName:"testCaseId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TestCaseSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TestCaseSummary) GoString() string {
	return s.String()
}

// SetCreationTime sets the CreationTime field's value.
func (s *TestCaseSummary) SetCreationTime(v time.Time) *TestCaseSummary {
	s.CreationTime = &v
	return s
}

// SetLastUpdateTime sets the LastUpdateTime field's value.
func (s *TestCaseSummary) SetLastUpdateTime(v time.Time) *TestCaseSummary {
	s.LastUpdateTime = &v
	return s
}

// SetLatestVersion sets the LatestVersion field's value.
func (s *TestCaseSummary) SetLatestVersion(v int64) *TestCaseSummary {
	s.LatestVersion = &v
	return s
}

// SetName sets the Name field's value.
func (s *TestCaseSummary) SetName(v string) *TestCaseSummary {
	s.Name = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *TestCaseSummary) SetStatus(v string) *TestCaseSummary {
	s.Status = &v
	return s
}

// SetStatusReason sets the StatusReason field's value.
func (s *TestCaseSummary) SetStatusReason(v string) *TestCaseSummary {
	s.StatusReason = &v
	return s
}

// SetTestCaseArn sets the TestCaseArn field's value.
func (s *TestCaseSummary) SetTestCaseArn(v string) *TestCaseSummary {
	s.TestCaseArn = &v
	return s
}

// SetTestCaseId sets the TestCaseId field's value.
func (s *TestCaseSummary) SetTestCaseId(v string) *TestCaseSummary {
	s.TestCaseId = &v
	return s
}

// Specifies test cases.
type TestCases struct {
	_ struct{} `type:"structure"`

	// The sequential of the test case.
	Sequential []*string `locationName:"sequential" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TestCases) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TestCases) GoString() string {
	return s.String()
}

// SetSequential sets the Sequential field's value.
func (s *TestCases) SetSequential(v []*string) *TestCases {
	s.Sequential = v
	return s
}

// Specifies the latest version of the test configuration.
type TestConfigurationLatestVersion struct {
	_ struct{} `type:"structure"`

	// The status of the test configuration latest version.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"TestConfigurationLifecycle"`

	// The status reason of the test configuration latest version.
	StatusReason *string `locationName:"statusReason" type:"string"`

	// The version of the test configuration latest version.
	//
	// Version is a required field
	Version *int64 `locationName:"version" type:"integer" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TestConfigurationLatestVersion) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TestConfigurationLatestVersion) GoString() string {
	return s.String()
}

// SetStatus sets the Status field's value.
func (s *TestConfigurationLatestVersion) SetStatus(v string) *TestConfigurationLatestVersion {
	s.Status = &v
	return s
}

// SetStatusReason sets the StatusReason field's value.
func (s *TestConfigurationLatestVersion) SetStatusReason(v string) *TestConfigurationLatestVersion {
	s.StatusReason = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *TestConfigurationLatestVersion) SetVersion(v int64) *TestConfigurationLatestVersion {
	s.Version = &v
	return s
}

// Specifies a test configuration summary.
type TestConfigurationSummary struct {
	_ struct{} `type:"structure"`

	// The creation time of the test configuration summary.
	//
	// CreationTime is a required field
	CreationTime *time.Time `locationName:"creationTime" type:"timestamp" required:"true"`

	// The last update time of the test configuration summary.
	//
	// LastUpdateTime is a required field
	LastUpdateTime *time.Time `locationName:"lastUpdateTime" type:"timestamp" required:"true"`

	// The latest version of the test configuration summary.
	//
	// LatestVersion is a required field
	LatestVersion *int64 `locationName:"latestVersion" type:"integer" required:"true"`

	// The name of the test configuration summary.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// The status of the test configuration summary.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"TestConfigurationLifecycle"`

	// The status reason of the test configuration summary.
	StatusReason *string `locationName:"statusReason" type:"string"`

	// The test configuration ARN of the test configuration summary.
	//
	// TestConfigurationArn is a required field
	TestConfigurationArn *string `locationName:"testConfigurationArn" type:"string" required:"true"`

	// The test configuration ID of the test configuration summary.
	//
	// TestConfigurationId is a required field
	TestConfigurationId *string `locationName:"testConfigurationId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TestConfigurationSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TestConfigurationSummary) GoString() string {
	return s.String()
}

// SetCreationTime sets the CreationTime field's value.
func (s *TestConfigurationSummary) SetCreationTime(v time.Time) *TestConfigurationSummary {
	s.CreationTime = &v
	return s
}

// SetLastUpdateTime sets the LastUpdateTime field's value.
func (s *TestConfigurationSummary) SetLastUpdateTime(v time.Time) *TestConfigurationSummary {
	s.LastUpdateTime = &v
	return s
}

// SetLatestVersion sets the LatestVersion field's value.
func (s *TestConfigurationSummary) SetLatestVersion(v int64) *TestConfigurationSummary {
	s.LatestVersion = &v
	return s
}

// SetName sets the Name field's value.
func (s *TestConfigurationSummary) SetName(v string) *TestConfigurationSummary {
	s.Name = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *TestConfigurationSummary) SetStatus(v string) *TestConfigurationSummary {
	s.Status = &v
	return s
}

// SetStatusReason sets the StatusReason field's value.
func (s *TestConfigurationSummary) SetStatusReason(v string) *TestConfigurationSummary {
	s.StatusReason = &v
	return s
}

// SetTestConfigurationArn sets the TestConfigurationArn field's value.
func (s *TestConfigurationSummary) SetTestConfigurationArn(v string) *TestConfigurationSummary {
	s.TestConfigurationArn = &v
	return s
}

// SetTestConfigurationId sets the TestConfigurationId field's value.
func (s *TestConfigurationSummary) SetTestConfigurationId(v string) *TestConfigurationSummary {
	s.TestConfigurationId = &v
	return s
}

// Specifies a test run step summary.
type TestRunStepSummary struct {
	_ struct{} `type:"structure"`

	// The after step of the test run step summary.
	AfterStep *bool `locationName:"afterStep" type:"boolean"`

	// The before step of the test run step summary.
	BeforeStep *bool `locationName:"beforeStep" type:"boolean"`

	// The run end time of the test run step summary.
	RunEndTime *time.Time `locationName:"runEndTime" type:"timestamp"`

	// The run start time of the test run step summary.
	//
	// RunStartTime is a required field
	RunStartTime *time.Time `locationName:"runStartTime" type:"timestamp" required:"true"`

	// The status of the test run step summary.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"StepRunStatus"`

	// The status reason of the test run step summary.
	StatusReason *string `locationName:"statusReason" type:"string"`

	// The step name of the test run step summary.
	//
	// StepName is a required field
	StepName *string `locationName:"stepName" type:"string" required:"true"`

	// The test case ID of the test run step summary.
	TestCaseId *string `locationName:"testCaseId" type:"string"`

	// The test case version of the test run step summary.
	TestCaseVersion *int64 `locationName:"testCaseVersion" type:"integer"`

	// The test run ID of the test run step summary.
	//
	// TestRunId is a required field
	TestRunId *string `locationName:"testRunId" type:"string" required:"true"`

	// The test suite ID of the test run step summary.
	TestSuiteId *string `locationName:"testSuiteId" type:"string"`

	// The test suite version of the test run step summary.
	TestSuiteVersion *int64 `locationName:"testSuiteVersion" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TestRunStepSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TestRunStepSummary) GoString() string {
	return s.String()
}

// SetAfterStep sets the AfterStep field's value.
func (s *TestRunStepSummary) SetAfterStep(v bool) *TestRunStepSummary {
	s.AfterStep = &v
	return s
}

// SetBeforeStep sets the BeforeStep field's value.
func (s *TestRunStepSummary) SetBeforeStep(v bool) *TestRunStepSummary {
	s.BeforeStep = &v
	return s
}

// SetRunEndTime sets the RunEndTime field's value.
func (s *TestRunStepSummary) SetRunEndTime(v time.Time) *TestRunStepSummary {
	s.RunEndTime = &v
	return s
}

// SetRunStartTime sets the RunStartTime field's value.
func (s *TestRunStepSummary) SetRunStartTime(v time.Time) *TestRunStepSummary {
	s.RunStartTime = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *TestRunStepSummary) SetStatus(v string) *TestRunStepSummary {
	s.Status = &v
	return s
}

// SetStatusReason sets the StatusReason field's value.
func (s *TestRunStepSummary) SetStatusReason(v string) *TestRunStepSummary {
	s.StatusReason = &v
	return s
}

// SetStepName sets the StepName field's value.
func (s *TestRunStepSummary) SetStepName(v string) *TestRunStepSummary {
	s.StepName = &v
	return s
}

// SetTestCaseId sets the TestCaseId field's value.
func (s *TestRunStepSummary) SetTestCaseId(v string) *TestRunStepSummary {
	s.TestCaseId = &v
	return s
}

// SetTestCaseVersion sets the TestCaseVersion field's value.
func (s *TestRunStepSummary) SetTestCaseVersion(v int64) *TestRunStepSummary {
	s.TestCaseVersion = &v
	return s
}

// SetTestRunId sets the TestRunId field's value.
func (s *TestRunStepSummary) SetTestRunId(v string) *TestRunStepSummary {
	s.TestRunId = &v
	return s
}

// SetTestSuiteId sets the TestSuiteId field's value.
func (s *TestRunStepSummary) SetTestSuiteId(v string) *TestRunStepSummary {
	s.TestSuiteId = &v
	return s
}

// SetTestSuiteVersion sets the TestSuiteVersion field's value.
func (s *TestRunStepSummary) SetTestSuiteVersion(v int64) *TestRunStepSummary {
	s.TestSuiteVersion = &v
	return s
}

// Specifies a test run summary.
type TestRunSummary struct {
	_ struct{} `type:"structure"`

	// The run end time of the test run summary.
	RunEndTime *time.Time `locationName:"runEndTime" type:"timestamp"`

	// The run start time of the test run summary.
	//
	// RunStartTime is a required field
	RunStartTime *time.Time `locationName:"runStartTime" type:"timestamp" required:"true"`

	// The status of the test run summary.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"TestRunStatus"`

	// The status reason of the test run summary.
	StatusReason *string `locationName:"statusReason" type:"string"`

	// The test configuration ID of the test run summary.
	TestConfigurationId *string `locationName:"testConfigurationId" type:"string"`

	// The test configuration version of the test run summary.
	TestConfigurationVersion *int64 `locationName:"testConfigurationVersion" type:"integer"`

	// The test run ARN of the test run summary.
	//
	// TestRunArn is a required field
	TestRunArn *string `locationName:"testRunArn" type:"string" required:"true"`

	// The test run ID of the test run summary.
	//
	// TestRunId is a required field
	TestRunId *string `locationName:"testRunId" type:"string" required:"true"`

	// The test suite ID of the test run summary.
	//
	// TestSuiteId is a required field
	TestSuiteId *string `locationName:"testSuiteId" type:"string" required:"true"`

	// The test suite version of the test run summary.
	//
	// TestSuiteVersion is a required field
	TestSuiteVersion *int64 `locationName:"testSuiteVersion" type:"integer" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TestRunSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TestRunSummary) GoString() string {
	return s.String()
}

// SetRunEndTime sets the RunEndTime field's value.
func (s *TestRunSummary) SetRunEndTime(v time.Time) *TestRunSummary {
	s.RunEndTime = &v
	return s
}

// SetRunStartTime sets the RunStartTime field's value.
func (s *TestRunSummary) SetRunStartTime(v time.Time) *TestRunSummary {
	s.RunStartTime = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *TestRunSummary) SetStatus(v string) *TestRunSummary {
	s.Status = &v
	return s
}

// SetStatusReason sets the StatusReason field's value.
func (s *TestRunSummary) SetStatusReason(v string) *TestRunSummary {
	s.StatusReason = &v
	return s
}

// SetTestConfigurationId sets the TestConfigurationId field's value.
func (s *TestRunSummary) SetTestConfigurationId(v string) *TestRunSummary {
	s.TestConfigurationId = &v
	return s
}

// SetTestConfigurationVersion sets the TestConfigurationVersion field's value.
func (s *TestRunSummary) SetTestConfigurationVersion(v int64) *TestRunSummary {
	s.TestConfigurationVersion = &v
	return s
}

// SetTestRunArn sets the TestRunArn field's value.
func (s *TestRunSummary) SetTestRunArn(v string) *TestRunSummary {
	s.TestRunArn = &v
	return s
}

// SetTestRunId sets the TestRunId field's value.
func (s *TestRunSummary) SetTestRunId(v string) *TestRunSummary {
	s.TestRunId = &v
	return s
}

// SetTestSuiteId sets the TestSuiteId field's value.
func (s *TestRunSummary) SetTestSuiteId(v string) *TestRunSummary {
	s.TestSuiteId = &v
	return s
}

// SetTestSuiteVersion sets the TestSuiteVersion field's value.
func (s *TestRunSummary) SetTestSuiteVersion(v int64) *TestRunSummary {
	s.TestSuiteVersion = &v
	return s
}

// Specifies the latest version of a test suite.
type TestSuiteLatestVersion struct {
	_ struct{} `type:"structure"`

	// The status of the test suite latest version.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"TestSuiteLifecycle"`

	// The status reason of the test suite latest version.
	StatusReason *string `locationName:"statusReason" type:"string"`

	// The version of the test suite latest version.
	//
	// Version is a required field
	Version *int64 `locationName:"version" type:"integer" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TestSuiteLatestVersion) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TestSuiteLatestVersion) GoString() string {
	return s.String()
}

// SetStatus sets the Status field's value.
func (s *TestSuiteLatestVersion) SetStatus(v string) *TestSuiteLatestVersion {
	s.Status = &v
	return s
}

// SetStatusReason sets the StatusReason field's value.
func (s *TestSuiteLatestVersion) SetStatusReason(v string) *TestSuiteLatestVersion {
	s.StatusReason = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *TestSuiteLatestVersion) SetVersion(v int64) *TestSuiteLatestVersion {
	s.Version = &v
	return s
}

// Specifies the test suite summary.
type TestSuiteSummary struct {
	_ struct{} `type:"structure"`

	// The creation time of the test suite summary.
	//
	// CreationTime is a required field
	CreationTime *time.Time `locationName:"creationTime" type:"timestamp" required:"true"`

	// The last update time of the test suite summary.
	//
	// LastUpdateTime is a required field
	LastUpdateTime *time.Time `locationName:"lastUpdateTime" type:"timestamp" required:"true"`

	// The latest version of the test suite summary.
	//
	// LatestVersion is a required field
	LatestVersion *int64 `locationName:"latestVersion" type:"integer" required:"true"`

	// The name of the test suite summary.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// The status of the test suite summary.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"TestSuiteLifecycle"`

	// The status reason of the test suite summary.
	StatusReason *string `locationName:"statusReason" type:"string"`

	// The test suite Amazon Resource Name (ARN) of the test suite summary.
	//
	// TestSuiteArn is a required field
	TestSuiteArn *string `locationName:"testSuiteArn" type:"string" required:"true"`

	// The test suite ID of the test suite summary.
	//
	// TestSuiteId is a required field
	TestSuiteId *string `locationName:"testSuiteId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TestSuiteSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TestSuiteSummary) GoString() string {
	return s.String()
}

// SetCreationTime sets the CreationTime field's value.
func (s *TestSuiteSummary) SetCreationTime(v time.Time) *TestSuiteSummary {
	s.CreationTime = &v
	return s
}

// SetLastUpdateTime sets the LastUpdateTime field's value.
func (s *TestSuiteSummary) SetLastUpdateTime(v time.Time) *TestSuiteSummary {
	s.LastUpdateTime = &v
	return s
}

// SetLatestVersion sets the LatestVersion field's value.
func (s *TestSuiteSummary) SetLatestVersion(v int64) *TestSuiteSummary {
	s.LatestVersion = &v
	return s
}

// SetName sets the Name field's value.
func (s *TestSuiteSummary) SetName(v string) *TestSuiteSummary {
	s.Name = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *TestSuiteSummary) SetStatus(v string) *TestSuiteSummary {
	s.Status = &v
	return s
}

// SetStatusReason sets the StatusReason field's value.
func (s *TestSuiteSummary) SetStatusReason(v string) *TestSuiteSummary {
	s.StatusReason = &v
	return s
}

// SetTestSuiteArn sets the TestSuiteArn field's value.
func (s *TestSuiteSummary) SetTestSuiteArn(v string) *TestSuiteSummary {
	s.TestSuiteArn = &v
	return s
}

// SetTestSuiteId sets the TestSuiteId field's value.
func (s *TestSuiteSummary) SetTestSuiteId(v string) *TestSuiteSummary {
	s.TestSuiteId = &v
	return s
}

// The number of requests made exceeds the limit.
type ThrottlingException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`

	// The quota code of requests that exceed the limit.
	QuotaCode *string `locationName:"quotaCode" type:"string"`

	// The number of seconds to retry after for requests that exceed the limit.
	RetryAfterSeconds *int64 `location:"header" locationName:"Retry-After" type:"integer"`

	// The service code of requests that exceed the limit.
	ServiceCode *string `locationName:"serviceCode" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) GoString() string {
	return s.String()
}

func newErrorThrottlingException(v protocol.ResponseMetadata) error {
	return &ThrottlingException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ThrottlingException) Code() string {
	return "ThrottlingException"
}

// Message returns the exception's message.
func (s *ThrottlingException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ThrottlingException) OrigErr() error {
	return nil
}

func (s *ThrottlingException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ThrottlingException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ThrottlingException) RequestID() string {
	return s.RespMetadata.RequestID
}

type UntagResourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The Amazon Resource Name (ARN) of the resource.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" type:"string" required:"true"`

	// The tag keys of the resource.
	//
	// TagKeys is a required field
	TagKeys []*string `location:"querystring" locationName:"tagKeys" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *UntagResourceInput) SetResourceArn(v string) *UntagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

type UpdateTestCaseInput struct {
	_ struct{} `type:"structure"`

	// The description of the test case.
	Description *string `locationName:"description" type:"string"`

	// The steps of the test case.
	Steps []*Step `locationName:"steps" min:"1" type:"list"`

	// The test case ID of the test case.
	//
	// TestCaseId is a required field
	TestCaseId *string `location:"uri" locationName:"testCaseId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateTestCaseInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateTestCaseInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateTestCaseInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateTestCaseInput"}
	if s.Steps != nil && len(s.Steps) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Steps", 1))
	}
	if s.TestCaseId == nil {
		invalidParams.Add(request.NewErrParamRequired("TestCaseId"))
	}
	if s.TestCaseId != nil && len(*s.TestCaseId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TestCaseId", 1))
	}
	if s.Steps != nil {
		for i, v := range s.Steps {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Steps", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *UpdateTestCaseInput) SetDescription(v string) *UpdateTestCaseInput {
	s.Description = &v
	return s
}

// SetSteps sets the Steps field's value.
func (s *UpdateTestCaseInput) SetSteps(v []*Step) *UpdateTestCaseInput {
	s.Steps = v
	return s
}

// SetTestCaseId sets the TestCaseId field's value.
func (s *UpdateTestCaseInput) SetTestCaseId(v string) *UpdateTestCaseInput {
	s.TestCaseId = &v
	return s
}

type UpdateTestCaseOutput struct {
	_ struct{} `type:"structure"`

	// The test case ID of the test case.
	//
	// TestCaseId is a required field
	TestCaseId *string `locationName:"testCaseId" type:"string" required:"true"`

	// The test case version of the test case.
	//
	// TestCaseVersion is a required field
	TestCaseVersion *int64 `locationName:"testCaseVersion" type:"integer" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateTestCaseOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateTestCaseOutput) GoString() string {
	return s.String()
}

// SetTestCaseId sets the TestCaseId field's value.
func (s *UpdateTestCaseOutput) SetTestCaseId(v string) *UpdateTestCaseOutput {
	s.TestCaseId = &v
	return s
}

// SetTestCaseVersion sets the TestCaseVersion field's value.
func (s *UpdateTestCaseOutput) SetTestCaseVersion(v int64) *UpdateTestCaseOutput {
	s.TestCaseVersion = &v
	return s
}

type UpdateTestConfigurationInput struct {
	_ struct{} `type:"structure"`

	// The description of the test configuration.
	Description *string `locationName:"description" type:"string"`

	// The properties of the test configuration.
	Properties map[string]*string `locationName:"properties" type:"map"`

	// The resources of the test configuration.
	Resources []*Resource `locationName:"resources" min:"1" type:"list"`

	// The service settings of the test configuration.
	ServiceSettings *ServiceSettings `locationName:"serviceSettings" type:"structure"`

	// The test configuration ID of the test configuration.
	//
	// TestConfigurationId is a required field
	TestConfigurationId *string `location:"uri" locationName:"testConfigurationId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateTestConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateTestConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateTestConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateTestConfigurationInput"}
	if s.Resources != nil && len(s.Resources) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Resources", 1))
	}
	if s.TestConfigurationId == nil {
		invalidParams.Add(request.NewErrParamRequired("TestConfigurationId"))
	}
	if s.TestConfigurationId != nil && len(*s.TestConfigurationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TestConfigurationId", 1))
	}
	if s.Resources != nil {
		for i, v := range s.Resources {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Resources", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *UpdateTestConfigurationInput) SetDescription(v string) *UpdateTestConfigurationInput {
	s.Description = &v
	return s
}

// SetProperties sets the Properties field's value.
func (s *UpdateTestConfigurationInput) SetProperties(v map[string]*string) *UpdateTestConfigurationInput {
	s.Properties = v
	return s
}

// SetResources sets the Resources field's value.
func (s *UpdateTestConfigurationInput) SetResources(v []*Resource) *UpdateTestConfigurationInput {
	s.Resources = v
	return s
}

// SetServiceSettings sets the ServiceSettings field's value.
func (s *UpdateTestConfigurationInput) SetServiceSettings(v *ServiceSettings) *UpdateTestConfigurationInput {
	s.ServiceSettings = v
	return s
}

// SetTestConfigurationId sets the TestConfigurationId field's value.
func (s *UpdateTestConfigurationInput) SetTestConfigurationId(v string) *UpdateTestConfigurationInput {
	s.TestConfigurationId = &v
	return s
}

type UpdateTestConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// The configuration ID of the test configuration.
	//
	// TestConfigurationId is a required field
	TestConfigurationId *string `locationName:"testConfigurationId" type:"string" required:"true"`

	// The configuration version of the test configuration.
	//
	// TestConfigurationVersion is a required field
	TestConfigurationVersion *int64 `locationName:"testConfigurationVersion" type:"integer" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateTestConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateTestConfigurationOutput) GoString() string {
	return s.String()
}

// SetTestConfigurationId sets the TestConfigurationId field's value.
func (s *UpdateTestConfigurationOutput) SetTestConfigurationId(v string) *UpdateTestConfigurationOutput {
	s.TestConfigurationId = &v
	return s
}

// SetTestConfigurationVersion sets the TestConfigurationVersion field's value.
func (s *UpdateTestConfigurationOutput) SetTestConfigurationVersion(v int64) *UpdateTestConfigurationOutput {
	s.TestConfigurationVersion = &v
	return s
}

type UpdateTestSuiteInput struct {
	_ struct{} `type:"structure"`

	// The after steps of the test suite.
	AfterSteps []*Step `locationName:"afterSteps" min:"1" type:"list"`

	// The before steps for the test suite.
	BeforeSteps []*Step `locationName:"beforeSteps" min:"1" type:"list"`

	// The description of the test suite.
	Description *string `locationName:"description" type:"string"`

	// The test cases in the test suite.
	TestCases *TestCases `locationName:"testCases" type:"structure"`

	// The test suite ID of the test suite.
	//
	// TestSuiteId is a required field
	TestSuiteId *string `location:"uri" locationName:"testSuiteId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateTestSuiteInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateTestSuiteInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateTestSuiteInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateTestSuiteInput"}
	if s.AfterSteps != nil && len(s.AfterSteps) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AfterSteps", 1))
	}
	if s.BeforeSteps != nil && len(s.BeforeSteps) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BeforeSteps", 1))
	}
	if s.TestSuiteId == nil {
		invalidParams.Add(request.NewErrParamRequired("TestSuiteId"))
	}
	if s.TestSuiteId != nil && len(*s.TestSuiteId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TestSuiteId", 1))
	}
	if s.AfterSteps != nil {
		for i, v := range s.AfterSteps {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "AfterSteps", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.BeforeSteps != nil {
		for i, v := range s.BeforeSteps {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "BeforeSteps", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAfterSteps sets the AfterSteps field's value.
func (s *UpdateTestSuiteInput) SetAfterSteps(v []*Step) *UpdateTestSuiteInput {
	s.AfterSteps = v
	return s
}

// SetBeforeSteps sets the BeforeSteps field's value.
func (s *UpdateTestSuiteInput) SetBeforeSteps(v []*Step) *UpdateTestSuiteInput {
	s.BeforeSteps = v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpdateTestSuiteInput) SetDescription(v string) *UpdateTestSuiteInput {
	s.Description = &v
	return s
}

// SetTestCases sets the TestCases field's value.
func (s *UpdateTestSuiteInput) SetTestCases(v *TestCases) *UpdateTestSuiteInput {
	s.TestCases = v
	return s
}

// SetTestSuiteId sets the TestSuiteId field's value.
func (s *UpdateTestSuiteInput) SetTestSuiteId(v string) *UpdateTestSuiteInput {
	s.TestSuiteId = &v
	return s
}

type UpdateTestSuiteOutput struct {
	_ struct{} `type:"structure"`

	// The test suite ID of the test suite.
	//
	// TestSuiteId is a required field
	TestSuiteId *string `locationName:"testSuiteId" type:"string" required:"true"`

	// The test suite version of the test suite.
	TestSuiteVersion *int64 `locationName:"testSuiteVersion" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateTestSuiteOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateTestSuiteOutput) GoString() string {
	return s.String()
}

// SetTestSuiteId sets the TestSuiteId field's value.
func (s *UpdateTestSuiteOutput) SetTestSuiteId(v string) *UpdateTestSuiteOutput {
	s.TestSuiteId = &v
	return s
}

// SetTestSuiteVersion sets the TestSuiteVersion field's value.
func (s *UpdateTestSuiteOutput) SetTestSuiteVersion(v int64) *UpdateTestSuiteOutput {
	s.TestSuiteVersion = &v
	return s
}

// One or more parameter provided in the request is not valid.
type ValidationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The field list of the validation exception.
	FieldList []*ValidationExceptionField `locationName:"fieldList" type:"list"`

	Message_ *string `locationName:"message" type:"string"`

	// The reason for the validation exception.
	Reason *string `locationName:"reason" type:"string" enum:"ValidationExceptionReason"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) GoString() string {
	return s.String()
}

func newErrorValidationException(v protocol.ResponseMetadata) error {
	return &ValidationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ValidationException) Code() string {
	return "ValidationException"
}

// Message returns the exception's message.
func (s *ValidationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ValidationException) OrigErr() error {
	return nil
}

func (s *ValidationException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ValidationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ValidationException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Specifies a validation exception field.
type ValidationExceptionField struct {
	_ struct{} `type:"structure"`

	// The message stating reason for why service validation failed.
	//
	// Message is a required field
	Message *string `locationName:"message" type:"string" required:"true"`

	// The name of the validation exception field.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationExceptionField) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationExceptionField) GoString() string {
	return s.String()
}

// SetMessage sets the Message field's value.
func (s *ValidationExceptionField) SetMessage(v string) *ValidationExceptionField {
	s.Message = &v
	return s
}

// SetName sets the Name field's value.
func (s *ValidationExceptionField) SetName(v string) *ValidationExceptionField {
	s.Name = &v
	return s
}

const (
	// CaptureToolPrecisely is a CaptureTool enum value
	CaptureToolPrecisely = "Precisely"

	// CaptureToolAwsdms is a CaptureTool enum value
	CaptureToolAwsdms = "AWS DMS"
)

// CaptureTool_Values returns all elements of the CaptureTool enum
func CaptureTool_Values() []string {
	return []string{
		CaptureToolPrecisely,
		CaptureToolAwsdms,
	}
}

const (
	// CloudFormationActionTypeCreate is a CloudFormationActionType enum value
	CloudFormationActionTypeCreate = "Create"

	// CloudFormationActionTypeDelete is a CloudFormationActionType enum value
	CloudFormationActionTypeDelete = "Delete"
)

// CloudFormationActionType_Values returns all elements of the CloudFormationActionType enum
func CloudFormationActionType_Values() []string {
	return []string{
		CloudFormationActionTypeCreate,
		CloudFormationActionTypeDelete,
	}
}

const (
	// ComparisonStatusEnumDifferent is a ComparisonStatusEnum enum value
	ComparisonStatusEnumDifferent = "Different"

	// ComparisonStatusEnumEquivalent is a ComparisonStatusEnum enum value
	ComparisonStatusEnumEquivalent = "Equivalent"

	// ComparisonStatusEnumEqual is a ComparisonStatusEnum enum value
	ComparisonStatusEnumEqual = "Equal"
)

// ComparisonStatusEnum_Values returns all elements of the ComparisonStatusEnum enum
func ComparisonStatusEnum_Values() []string {
	return []string{
		ComparisonStatusEnumDifferent,
		ComparisonStatusEnumEquivalent,
		ComparisonStatusEnumEqual,
	}
}

const (
	// DataSetTypePs is a DataSetType enum value
	DataSetTypePs = "PS"
)

// DataSetType_Values returns all elements of the DataSetType enum
func DataSetType_Values() []string {
	return []string{
		DataSetTypePs,
	}
}

const (
	// FormatFixed is a Format enum value
	FormatFixed = "FIXED"

	// FormatVariable is a Format enum value
	FormatVariable = "VARIABLE"

	// FormatLineSequential is a Format enum value
	FormatLineSequential = "LINE_SEQUENTIAL"
)

// Format_Values returns all elements of the Format enum
func Format_Values() []string {
	return []string{
		FormatFixed,
		FormatVariable,
		FormatLineSequential,
	}
}

const (
	// M2ManagedActionTypeConfigure is a M2ManagedActionType enum value
	M2ManagedActionTypeConfigure = "Configure"

	// M2ManagedActionTypeDeconfigure is a M2ManagedActionType enum value
	M2ManagedActionTypeDeconfigure = "Deconfigure"
)

// M2ManagedActionType_Values returns all elements of the M2ManagedActionType enum
func M2ManagedActionType_Values() []string {
	return []string{
		M2ManagedActionTypeConfigure,
		M2ManagedActionTypeDeconfigure,
	}
}

const (
	// M2ManagedRuntimeMicroFocus is a M2ManagedRuntime enum value
	M2ManagedRuntimeMicroFocus = "MicroFocus"
)

// M2ManagedRuntime_Values returns all elements of the M2ManagedRuntime enum
func M2ManagedRuntime_Values() []string {
	return []string{
		M2ManagedRuntimeMicroFocus,
	}
}

const (
	// M2NonManagedActionTypeConfigure is a M2NonManagedActionType enum value
	M2NonManagedActionTypeConfigure = "Configure"

	// M2NonManagedActionTypeDeconfigure is a M2NonManagedActionType enum value
	M2NonManagedActionTypeDeconfigure = "Deconfigure"
)

// M2NonManagedActionType_Values returns all elements of the M2NonManagedActionType enum
func M2NonManagedActionType_Values() []string {
	return []string{
		M2NonManagedActionTypeConfigure,
		M2NonManagedActionTypeDeconfigure,
	}
}

const (
	// M2NonManagedRuntimeBluAge is a M2NonManagedRuntime enum value
	M2NonManagedRuntimeBluAge = "BluAge"
)

// M2NonManagedRuntime_Values returns all elements of the M2NonManagedRuntime enum
func M2NonManagedRuntime_Values() []string {
	return []string{
		M2NonManagedRuntimeBluAge,
	}
}

const (
	// ScriptTypeSelenium is a ScriptType enum value
	ScriptTypeSelenium = "Selenium"
)

// ScriptType_Values returns all elements of the ScriptType enum
func ScriptType_Values() []string {
	return []string{
		ScriptTypeSelenium,
	}
}

const (
	// SourceDatabaseZOsDb2 is a SourceDatabase enum value
	SourceDatabaseZOsDb2 = "z/OS-DB2"
)

// SourceDatabase_Values returns all elements of the SourceDatabase enum
func SourceDatabase_Values() []string {
	return []string{
		SourceDatabaseZOsDb2,
	}
}

const (
	// StepRunStatusSuccess is a StepRunStatus enum value
	StepRunStatusSuccess = "Success"

	// StepRunStatusFailed is a StepRunStatus enum value
	StepRunStatusFailed = "Failed"

	// StepRunStatusRunning is a StepRunStatus enum value
	StepRunStatusRunning = "Running"
)

// StepRunStatus_Values returns all elements of the StepRunStatus enum
func StepRunStatus_Values() []string {
	return []string{
		StepRunStatusSuccess,
		StepRunStatusFailed,
		StepRunStatusRunning,
	}
}

const (
	// TargetDatabasePostgreSql is a TargetDatabase enum value
	TargetDatabasePostgreSql = "PostgreSQL"
)

// TargetDatabase_Values returns all elements of the TargetDatabase enum
func TargetDatabase_Values() []string {
	return []string{
		TargetDatabasePostgreSql,
	}
}

const (
	// TestCaseLifecycleActive is a TestCaseLifecycle enum value
	TestCaseLifecycleActive = "Active"

	// TestCaseLifecycleDeleting is a TestCaseLifecycle enum value
	TestCaseLifecycleDeleting = "Deleting"
)

// TestCaseLifecycle_Values returns all elements of the TestCaseLifecycle enum
func TestCaseLifecycle_Values() []string {
	return []string{
		TestCaseLifecycleActive,
		TestCaseLifecycleDeleting,
	}
}

const (
	// TestCaseRunStatusSuccess is a TestCaseRunStatus enum value
	TestCaseRunStatusSuccess = "Success"

	// TestCaseRunStatusRunning is a TestCaseRunStatus enum value
	TestCaseRunStatusRunning = "Running"

	// TestCaseRunStatusFailed is a TestCaseRunStatus enum value
	TestCaseRunStatusFailed = "Failed"
)

// TestCaseRunStatus_Values returns all elements of the TestCaseRunStatus enum
func TestCaseRunStatus_Values() []string {
	return []string{
		TestCaseRunStatusSuccess,
		TestCaseRunStatusRunning,
		TestCaseRunStatusFailed,
	}
}

const (
	// TestConfigurationLifecycleActive is a TestConfigurationLifecycle enum value
	TestConfigurationLifecycleActive = "Active"

	// TestConfigurationLifecycleDeleting is a TestConfigurationLifecycle enum value
	TestConfigurationLifecycleDeleting = "Deleting"
)

// TestConfigurationLifecycle_Values returns all elements of the TestConfigurationLifecycle enum
func TestConfigurationLifecycle_Values() []string {
	return []string{
		TestConfigurationLifecycleActive,
		TestConfigurationLifecycleDeleting,
	}
}

const (
	// TestRunStatusSuccess is a TestRunStatus enum value
	TestRunStatusSuccess = "Success"

	// TestRunStatusRunning is a TestRunStatus enum value
	TestRunStatusRunning = "Running"

	// TestRunStatusFailed is a TestRunStatus enum value
	TestRunStatusFailed = "Failed"

	// TestRunStatusDeleting is a TestRunStatus enum value
	TestRunStatusDeleting = "Deleting"
)

// TestRunStatus_Values returns all elements of the TestRunStatus enum
func TestRunStatus_Values() []string {
	return []string{
		TestRunStatusSuccess,
		TestRunStatusRunning,
		TestRunStatusFailed,
		TestRunStatusDeleting,
	}
}

const (
	// TestSuiteLifecycleCreating is a TestSuiteLifecycle enum value
	TestSuiteLifecycleCreating = "Creating"

	// TestSuiteLifecycleUpdating is a TestSuiteLifecycle enum value
	TestSuiteLifecycleUpdating = "Updating"

	// TestSuiteLifecycleActive is a TestSuiteLifecycle enum value
	TestSuiteLifecycleActive = "Active"

	// TestSuiteLifecycleFailed is a TestSuiteLifecycle enum value
	TestSuiteLifecycleFailed = "Failed"

	// TestSuiteLifecycleDeleting is a TestSuiteLifecycle enum value
	TestSuiteLifecycleDeleting = "Deleting"
)

// TestSuiteLifecycle_Values returns all elements of the TestSuiteLifecycle enum
func TestSuiteLifecycle_Values() []string {
	return []string{
		TestSuiteLifecycleCreating,
		TestSuiteLifecycleUpdating,
		TestSuiteLifecycleActive,
		TestSuiteLifecycleFailed,
		TestSuiteLifecycleDeleting,
	}
}

const (
	// ValidationExceptionReasonUnknownOperation is a ValidationExceptionReason enum value
	ValidationExceptionReasonUnknownOperation = "unknownOperation"

	// ValidationExceptionReasonCannotParse is a ValidationExceptionReason enum value
	ValidationExceptionReasonCannotParse = "cannotParse"

	// ValidationExceptionReasonFieldValidationFailed is a ValidationExceptionReason enum value
	ValidationExceptionReasonFieldValidationFailed = "fieldValidationFailed"

	// ValidationExceptionReasonOther is a ValidationExceptionReason enum value
	ValidationExceptionReasonOther = "other"
)

// ValidationExceptionReason_Values returns all elements of the ValidationExceptionReason enum
func ValidationExceptionReason_Values() []string {
	return []string{
		ValidationExceptionReasonUnknownOperation,
		ValidationExceptionReasonCannotParse,
		ValidationExceptionReasonFieldValidationFailed,
		ValidationExceptionReasonOther,
	}
}
