.\" graveman.man
.\" Copyright (C) 2005 Sylvain Cresto <scresto@gmail.com>
.\"
.\" This file is part of graveman!
.\"
.\" graveman! is free software; you can redistribute it and/or modify
.\" it under the terms of the GNU General Public License as published by
.\" the Free Software Foundation; either version 2, or
.\" (at your option) any later version.
.\"
.\" graveman! is distributed in the hope that it will be useful,
.\" but WITHOUT ANY WARRANTY; without even the implied warranty of
.\" MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
.\" General Public License for more details.
.\"
.\" You should have received a copy of the GNU General Public License
.\" along with program; see the file COPYING. If not, write to the
.\" Free Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
.\ MA 02111-1307, USA.
.\"
.\" URL: http://www.nongnu.org/graveman/
.\"
.TH graveman 1 "02 April 2005" 0.3.10 "graveman's USER COMMANDS"

.SH NAME
graveman \- graphical frontend to create or copy CDs and DVDs.

.SH SYNOPSIS
graveman [ options ]

.SH DESCRIPTION
\fBgraveman!\fP is a GUI frontend for cdrtools (cdrecord, readcd, mkisofs), dvd+rw-tools, sox and flac.
It allows you to burn audio CDs (from WAV, Ogg, MP3 or Flac files) and data CDs / DVDs, and allows you to duplicate CDs.
You can also import M3U and PTS playlists.

.SH OPTIONS
Command line options will overwrite parameters stored in configuration files.
.TP
\fB-c\fR, \fB--config <file1[:file2:...]>\fR
To define the preference-ordered set of extra configuration files to use in priority. Configuration files should be separated with a colon ':'.
.TP
\fB-D\fR, \fB--data <directory1[:directory2:...]>\fR
To define the preference-ordered set of extra data directories to use in priority. Graveman will load data likes themes from those directories. Directories should be separated with a colon ':'.
.TP
\fB-t\fR, \fB--theme <theme1[:theme2:...]>\fR
To define the preference-ordered set of themes to use. First valid theme will be used. Themes should be separated with a colon ':'.
.TP
\fB-s\fR, \fB--scan_drives\fR
With this option graveman always perform drive autodetection on startup.
.TP
\fB-v\fR, \fB--version\fR
Print version informations and exit.
.TP
\fB-V\fR
Print compilation information and exit.

.SH BUGS
Please report any bugs to \fIhttp://graveman.tuxfamily.org/bugs-e.php\fR.
It's often better to attach your graveman.conf configuration file with bug report.
You can also compile graveman in debug mode and attach graveman output.

.SH FILES
\fBgraveman configuration file:\fR
.PP
\fIXDG_CONFIG_HOME\fR/graveman/graveman.conf
.br
\fIHOME\fR/graveman\fR/graveman.conf
.br
\fIXDG_CONFIG_DIRS\fR/graveman/graveman.conf
.PP
\fIXDG_CONFIG_HOME\fR, \fIHOME\fR and \fIXDG_CONFIG_DIRS\fR are environments variables.
First existing file will be used.
.PP
\fBgraveman data directory:\fR
.PP
\fIXDG_DATA_HOME\fR/graveman/
.br
\fIHOME\fR/.local/share/graveman/
.br
\fIXDG_DATA_DIRS\fR/graveman/
.PP
\fIXDF_DATA_HOME\fR, \fIHOME\fR et \fIXDG_DATA_DIRS\fR are environments variables.
First existing directory will be used.
.SH SEE ALSO
cdrecord(1), mkisofs(1), growisofs(1m), cdrdao(1), readcd(1), flac(1), sox(1)

.SH VERSION
This document was last revised for graveman! version 0.3.10.

.SH AUTHOR
Copyright (C) 2005 Sylvain Cresto \- scresto _at_ gmail.com \- Main coder
.br
Please download the latest graveman! versions on \fIhttp://www.nongnu.org/graveman\fR.

.SH CONTRIBUTORS
yeKcim \- yeknan _at_ yahoo.fr \- Graveman logo
.br
Peggy Kutyla \- peggy.kutyla _at_ laposte.net \- Some icons
.br
Olivier Rolland \- olivier.rolland _at_ gmail.com \- Original "graft points" patch
.br
Wouter van der Rijst \- wouter.van.der.rijst _at_ zonnet.nl \- Dutch translation, packages, many things
.br
Please read \fBTHANKS\fR file for others contributors.


