'use strict';

const node_worker_threads = require('node:worker_threads');
const debugWrap = require('debug');
const utils = require('./shared/vite-plugin-eslint2.5ee885a0.cjs');
require('tty');
require('@rollup/pluginutils');

function _interopDefaultCompat (e) { return e && typeof e === 'object' && 'default' in e ? e.default : e; }

const debugWrap__default = /*#__PURE__*/_interopDefaultCompat(debugWrap);

var _a;
const debug = debugWrap__default(`${utils.PLUGIN_NAME}:worker`);
const options = node_worker_threads.workerData.options;
const filter = utils.getFilter(options);
let eslintInstance;
let formatter;
let outputFixes;
(async () => {
  debug(`Initialize ESLint`);
  const result = await utils.initializeESLint(options);
  eslintInstance = result.eslintInstance;
  formatter = result.formatter;
  outputFixes = result.outputFixes;
  if (options.lintOnStart) {
    debug(`Lint on start`);
    utils.lintFiles({
      files: options.include,
      eslintInstance,
      formatter,
      outputFixes,
      options
    });
  }
})();
(_a = node_worker_threads.parentPort) == null ? void 0 : _a.on("message", async (files) => {
  debug(`==== message event ====`);
  debug(`message: ${files}`);
  const shouldIgnore = await utils.shouldIgnoreModule(files, filter, eslintInstance);
  debug(`should ignore: ${shouldIgnore}`);
  if (shouldIgnore)
    return;
  utils.lintFiles({
    files: options.lintDirtyOnly ? files : options.include,
    eslintInstance,
    formatter,
    outputFixes,
    options
  });
});
