/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.utilities.soql;

import java.util.HashMap;
import java.util.Map;
import sun.jvm.hotspot.oops.Field;
import sun.jvm.hotspot.utilities.soql.DefaultScriptObject;
import sun.jvm.hotspot.utilities.soql.JSJavaFactory;
import sun.jvm.hotspot.utilities.soql.JSJavaObject;

public class JSJavaField
extends DefaultScriptObject {
    private static final int FIELD_NAME = 0;
    private static final int FIELD_SIGNATURE = 1;
    private static final int FIELD_HOLDER = 2;
    private static final int FIELD_IS_PRIVATE = 3;
    private static final int FIELD_IS_PUBLIC = 4;
    private static final int FIELD_IS_PROTECTED = 5;
    private static final int FIELD_IS_PACKAGE_PRIVATE = 6;
    private static final int FIELD_IS_STATIC = 7;
    private static final int FIELD_IS_FINAL = 8;
    private static final int FIELD_IS_VOLATILE = 9;
    private static final int FIELD_IS_TRANSIENT = 10;
    private static final int FIELD_IS_SYNTHETIC = 11;
    private static final int FIELD_UNDEFINED = -1;
    private static Map fields = new HashMap();
    private final Field field;
    private final JSJavaFactory factory;

    public JSJavaField(Field f, JSJavaFactory fac) {
        this.field = f;
        this.factory = fac;
    }

    @Override
    public Object get(String name) {
        int fieldID = JSJavaField.getFieldID(name);
        switch (fieldID) {
            case 0: {
                return this.field.getID().getName();
            }
            case 1: {
                return this.field.getSignature().asString();
            }
            case 2: {
                return this.getFieldHolder();
            }
            case 3: {
                return this.field.isPrivate();
            }
            case 4: {
                return this.field.isPublic();
            }
            case 5: {
                return this.field.isProtected();
            }
            case 6: {
                return this.field.isPackagePrivate();
            }
            case 7: {
                return this.field.isStatic();
            }
            case 8: {
                return this.field.isFinal();
            }
            case 9: {
                return this.field.isVolatile();
            }
            case 10: {
                return this.field.isTransient();
            }
            case 11: {
                return this.field.isSynthetic();
            }
        }
        return super.get(name);
    }

    @Override
    public Object[] getIds() {
        Object[] fieldNames = fields.keySet().toArray();
        Object[] superFields = super.getIds();
        Object[] res = new Object[fieldNames.length + superFields.length];
        System.arraycopy(fieldNames, 0, res, 0, fieldNames.length);
        System.arraycopy(superFields, 0, res, fieldNames.length, superFields.length);
        return res;
    }

    @Override
    public boolean has(String name) {
        if (JSJavaField.getFieldID(name) != -1) {
            return true;
        }
        return super.has(name);
    }

    @Override
    public void put(String name, Object value) {
        if (JSJavaField.getFieldID(name) == -1) {
            super.put(name, value);
        }
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof JSJavaField)) {
            return false;
        }
        JSJavaField other = (JSJavaField)o;
        return this.field.equals(other.field);
    }

    public int hashCode() {
        return this.field.hashCode();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("Field ");
        buf.append(this.field.getFieldHolder().getName().asString().replace('/', '.'));
        buf.append('.');
        buf.append(this.field.getID().getName());
        return buf.toString();
    }

    private JSJavaObject getFieldHolder() {
        return this.factory.newJSJavaKlass(this.field.getFieldHolder()).getJSJavaClass();
    }

    private static void addField(String name, int fieldId) {
        fields.put(name, new Integer(fieldId));
    }

    private static int getFieldID(String name) {
        Integer res = (Integer)fields.get(name);
        return res != null ? res : -1;
    }

    static {
        JSJavaField.addField("name", 0);
        JSJavaField.addField("signature", 1);
        JSJavaField.addField("holder", 2);
        JSJavaField.addField("isPrivate", 3);
        JSJavaField.addField("isPublic", 4);
        JSJavaField.addField("isProtected", 5);
        JSJavaField.addField("isPackagePrivate", 6);
        JSJavaField.addField("isStatic", 7);
        JSJavaField.addField("isFinal", 8);
        JSJavaField.addField("isVolatile", 9);
        JSJavaField.addField("isTransient", 10);
        JSJavaField.addField("isSynthetic", 11);
    }
}

