/*
  gmorgan - a ryhthm station software

  gmorgan.MIDIExport.Song.C  -  Export MIDI file in sequencer functions.
  Copyright (C) 2003-2004 Josep Andreu (Holborn)
  Author: Josep Andreu

  This program is free software; you can redistribute it and/or modify
  it under the terms of version 2 of the GNU General Public License
  as published by the Free Software Foundation.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License (version 2) for more details.

  You should have received a copy of the GNU General Public License
(version2)
  along with this program; if not, write to the Free Software Foundation,
  Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA

*/

/* Alsa sequencer functions  by Matthias Nagorni 
   modifies by Josep Andreu

*/

#include "GMorgan.h"

void
GMO::saveMidiFile2 (char *filename)
{

  FILE *fs;
  char temp[128];
 
  generatracks2 ();
  bzero (temp, sizeof (temp));

  if ((fs = fopen (filename, "w")) != NULL)
    {
      int i = 0;
      sprintf (temp, "MThd%c%c%c%c%c%c%c%c%c%c", 0, 0, 0, 6, 0, 1, 0, 11, 0,
	       128);

      for (i = 0; i < 14; i++)
	fputc (temp[i], fs);

      bzero (temp, sizeof (temp));
      sprintf (temp, "MTrk%c%c%c%c", 0, 0, cdrums / 256, cdrums % 256);
      for (i = 0; i < 8; i++)
	fputc (temp[i], fs);
      for (i = 0; i < cdrums; i++)
	fputc (drums[i], fs);
      bzero (temp, sizeof (temp));
      sprintf (temp, "MTrk%c%c%c%c", 0, 0, cbass / 256, cbass % 256);
      for (i = 0; i < 8; i++)
	fputc (temp[i], fs);
      for (i = 0; i < cbass; i++)
	fputc (bass[i], fs);
      bzero (temp, sizeof (temp));
      sprintf (temp, "MTrk%c%c%c%c", 0, 0, cacc1 / 256, cacc1 % 256);

      for (i = 0; i < 8; i++)
	fputc (temp[i], fs);
      for (i = 0; i < cacc1; i++)
	fputc (acc1[i], fs);
      bzero (temp, sizeof (temp));
      sprintf (temp, "MTrk%c%c%c%c", 0, 0, cacc2 / 256, cacc2 % 256);
      for (i = 0; i < 8; i++)
	fputc (temp[i], fs);
      for (i = 0; i < cacc2; i++)
	fputc (acc2[i], fs);
      bzero (temp, sizeof (temp));
      sprintf (temp, "MTrk%c%c%c%c", 0, 0, cacc3 / 256, cacc3 % 256);
      for (i = 0; i < 8; i++)
	fputc (temp[i], fs);

      for (i = 0; i < cacc3; i++)
	fputc (acc3[i], fs);

      bzero (temp, sizeof (temp));
      sprintf (temp, "MTrk%c%c%c%c", 0, 0, cacc4 / 256, cacc4 % 256);
      for (i = 0; i < 8; i++)
	fputc (temp[i], fs);
      for (i = 0; i < cacc4; i++)
	fputc (acc4[i], fs);
      bzero (temp, sizeof (temp));
      sprintf (temp, "MTrk%c%c%c%c", 0, 0, cacc5 / 256, cacc5 % 256);
      for (i = 0; i < 8; i++)
	fputc (temp[i], fs);
      for (i = 0; i < cacc5; i++)
	fputc (acc5[i], fs);
      bzero (temp, sizeof (temp));
      sprintf (temp, "MTrk%c%c%c%c", 0, 0, cleke1 / 256, cleke1 % 256);
      for (i = 0; i < 8; i++)
	fputc (temp[i], fs);
      for (i = 0; i < cleke1; i++)
	fputc (leke1[i], fs);

      bzero (temp, sizeof (temp));
      sprintf (temp, "MTrk%c%c%c%c", 0, 0, cleke2 / 256, cleke2 % 256);
      for (i = 0; i < 8; i++)
	fputc (temp[i], fs);
      for (i = 0; i < cleke2; i++)
	fputc (leke2[i], fs);

      bzero (temp, sizeof (temp));
      sprintf (temp, "MTrk%c%c%c%c", 0, 0, crake1 / 256, crake1 % 256);
      for (i = 0; i < 8; i++)
	fputc (temp[i], fs);
      for (i = 0; i < crake1; i++)
	fputc (rake1[i], fs);
      bzero (temp, sizeof (temp));
      sprintf (temp, "MTrk%c%c%c%c", 0, 0, crake2 / 256, crake2 % 256);
      for (i = 0; i < 8; i++)
	fputc (temp[i], fs);
      for (i = 0; i < crake2; i++)
	fputc (rake2[i], fs);
      fclose (fs);
    }
};

void
GMO::generatracks2 ()
{
  int i, j;
  char temp[512];
  long longtempo;
  Pendientes = 0;
  deltad = 0;
  deltab = 0;
  deltacc1 = 0;
  deltacc2 = 0;
  deltacc3 = 0;
  deltacc4 = 0;
  deltacc5 = 0;
  deltaleke1 = 0;
  deltaleke2 = 0;
  deltarake1 = 0;
  deltarake2 = 0;
  delta = 0;
  int lt1;
  int lt2;
  int lt3;

  bzero (PO, sizeof (PO));
  bzero (drums, sizeof (drums));
  bzero (bass, sizeof (bass));
  bzero (acc1, sizeof (acc1));
  bzero (acc2, sizeof (acc2));
  bzero (acc3, sizeof (acc3));
  bzero (acc4, sizeof (acc4));
  bzero (acc5, sizeof (acc5));
  bzero (rake1, sizeof (rake1));
  bzero (rake2, sizeof (rake2));
  bzero (leke1, sizeof (leke1));
  bzero (leke2, sizeof (leke2));

  stdrums = 0;
  stbass = 0;
  stacc1 = 0;
  stacc2 = 0;
  stacc3 = 0;
  stacc4 = 0;
  stacc5 = 0;
  stleke1 = 0;
  stleke2 = 0;
  strake1 = 0;
  strake2 = 0;
  cdrums = 0;
  cbass = 0;
  cacc1 = 0;
  cacc2 = 0;
  cacc3 = 0;
  cacc4 = 0;
  cacc5 = 0;
  cleke1 = 0;
  cleke2 = 0;
  crake1 = 0;
  crake2 = 0;

  longtempo = 60000000 / bpm;
  lt1 = longtempo / 65536;
  lt2 = (longtempo % 65536) / 256;
  lt3 = (longtempo % 65536) % 256;

  bzero (temp, sizeof (temp));
  sprintf (temp, "%c%c%c%cDrums%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c", 0, 255, 3, 5,
	   0, 255, 81, 3, lt1, lt2, lt3, 0, 255, 88, 4, 4, 2, 16, 8);
  for (i = 0; i < 24; i++)
    drums[i] = temp[i];
  cdrums += 24;

  bzero (temp, sizeof (temp));
  sprintf (temp, "%c%c%c%cBass", 0, 255, 3, 4);
  for (i = 0; i < 8; i++)
    bass[i] = temp[i];
  cbass += 8;

  bzero (temp, sizeof (temp));
  sprintf (temp, "%c%c%c%cAcc1", 0, 255, 3, 4);
  for (i = 0; i < 8; i++)
    acc1[i] = temp[i];
  cacc1 += 8;

  bzero (temp, sizeof (temp));
  sprintf (temp, "%c%c%c%cAcc2", 0, 255, 3, 4);
  for (i = 0; i < 8; i++)
    acc2[i] = temp[i];
  cacc2 += 8;

  bzero (temp, sizeof (temp));
  sprintf (temp, "%c%c%c%cAcc3", 0, 255, 3, 4);
  for (i = 0; i < 8; i++)
    acc3[i] = temp[i];
  cacc3 += 8;

  bzero (temp, sizeof (temp));
  sprintf (temp, "%c%c%c%cAcc4", 0, 255, 3, 4);
  for (i = 0; i < 8; i++)
    acc4[i] = temp[i];
  cacc4 += 8;

  bzero (temp, sizeof (temp));
  sprintf (temp, "%c%c%c%cAcc5", 0, 255, 3, 4);
  for (i = 0; i < 8; i++)
    acc5[i] = temp[i];
  cacc5 += 8;

  bzero (temp, sizeof (temp));
  sprintf (temp, "%c%c%c%cLeftKeyb1", 0, 255, 3, 9);
  for (i = 0; i < 13; i++)
    leke1[i] = temp[i];
  cleke1 += 13;

  bzero (temp, sizeof (temp));
  sprintf (temp, "%c%c%c%cLeftKeyb2", 0, 255, 3, 9);
  for (i = 0; i < 13; i++)
    leke2[i] = temp[i];
  cleke2 += 13;

  bzero (temp, sizeof (temp));
  sprintf (temp, "%c%c%c%cRightKeyb1", 0, 255, 3, 10);
  for (i = 0; i < 14; i++)
    rake1[i] = temp[i];
  crake1 += 14;

  bzero (temp, sizeof (temp));
  sprintf (temp, "%c%c%c%cRightKeyb2", 0, 255, 3, 10);
  for (i = 0; i < 14; i++)
    rake2[i] = temp[i];
  crake2 += 14;

  PonNotesOff2 ();

  for (i = 1; i <= grabaconta2; i++)
    {
      unsigned long tempdelta = 0;
      switch (MEG[i].canal)
	{
	case 0:
	  tempdelta = calculadelta (MEG[i].tick - deltaleke1);
	  deltaleke1 = MEG[i].tick;
	  while (1)
	    {
	      bzero (temp, sizeof (temp));
	      sprintf (temp, "%c", (int) tempdelta);
	      for (j = cleke1; j < cleke1 + 1; j++)
		leke1[j] = temp[j - cleke1];
	      cleke1++;
	      if (tempdelta & 0x80)
		tempdelta >>= 8;
	      else
		break;
	    }
	  if ((MEG[i].tipo == 2) && (stleke1 != 144))
	    {
	      stleke1 = 144;
	      bzero (temp, sizeof (temp));
	      sprintf (temp, "%c", stleke1);
	      for (j = cleke1; j < cleke1 + 1; j++)
		leke1[j] = temp[j - cleke1];
	      cleke1++;
	    }
	  if ((MEG[i].tipo == 3) && (stleke1 != 176))
	    {
	      stleke1 = 176;
	      bzero (temp, sizeof (temp));
	      sprintf (temp, "%c", stleke1);
	      for (j = cleke1; j < cleke1 + 1; j++)
		leke1[j] = temp[j - cleke1];
	      cleke1++;
	    }
	  if ((MEG[i].tipo == 4) && (stleke1 != 192))
	    {
	      stleke1 = 192;
	      bzero (temp, sizeof (temp));
	      sprintf (temp, "%c", stleke1);
	      for (j = cleke1; j < cleke1 + 1; j++)
		leke1[j] = temp[j - cleke1];
	      cleke1++;
	    }
	  bzero (temp, sizeof (temp));
	  if (MEG[i].tipo == 2)
	    sprintf (temp, "%c%c", MEG[i].nota, MEG[i].velocity);
	  if (MEG[i].tipo == 3)
	    sprintf (temp, "%c%c", MEG[i].nota, MEG[i].velocity);
	  if ((MEG[i].tipo == 2) || (MEG[i].tipo == 3))
	    {
	      for (j = cleke1; j < cleke1 + 2; j++)
		leke1[j] = temp[j - cleke1];
	      cleke1 += 2;
	    }

	  if (MEG[i].tipo == 4)
	    {
	      sprintf (temp, "%c", MEG[i].nota);
	      for (j = cleke1; j < cleke1 + 1; j++)
		leke1[j] = temp[j - cleke1];
	      cleke1 += 1;
	    }
	  break;

	case 1:
	  tempdelta = calculadelta (MEG[i].tick - deltaleke2);
	  deltaleke2 = MEG[i].tick;
	  while (1)
	    {
	      bzero (temp, sizeof (temp));
	      sprintf (temp, "%c", (int) tempdelta);
	      for (j = cleke2; j < cleke2 + 1; j++)
		leke2[j] = temp[j - cleke2];
	      cleke2++;
	      if (tempdelta & 0x80)
		tempdelta >>= 8;
	      else
		break;
	    }

	  if ((MEG[i].tipo == 2) && (stleke2 != 145))
	    {
	      stleke2 = 145;
	      bzero (temp, sizeof (temp));
	      sprintf (temp, "%c", stleke2);
	      for (j = cleke2; j < cleke2 + 1; j++)
		leke2[j] = temp[j - cleke2];
	      cleke2++;
	    }

	  if ((MEG[i].tipo == 3) && (stleke2 != 177))
	    {
	      stleke2 = 177;
	      bzero (temp, sizeof (temp));
	      sprintf (temp, "%c", stleke2);
	      for (j = cleke2; j < cleke2 + 1; j++)
		leke2[j] = temp[j - cleke2];
	      cleke2++;
	    }

	  if ((MEG[i].tipo == 4) && (stleke2 != 193))
	    {
	      stleke2 = 193;
	      bzero (temp, sizeof (temp));
	      sprintf (temp, "%c", stleke2);
	      for (j = cleke2; j < cleke2 + 1; j++)
		leke2[j] = temp[j - cleke2];
	      cleke2++;
	    }

	  bzero (temp, sizeof (temp));
	  if (MEG[i].tipo == 2)
	    sprintf (temp, "%c%c", MEG[i].nota, MEG[i].velocity);
	  if (MEG[i].tipo == 3)
	    sprintf (temp, "%c%c", MEG[i].nota, MEG[i].velocity);
	  if ((MEG[i].tipo == 2) || (MEG[i].tipo == 3))
	    {
	      for (j = cleke2; j < cleke2 + 2; j++)
		leke2[j] = temp[j - cleke2];
	      cleke2 += 2;
	    }

	  if (MEG[i].tipo == 4)
	    {
	      sprintf (temp, "%c", MEG[i].nota);
	      for (j = cleke2; j < cleke2 + 1; j++)
		leke2[j] = temp[j - cleke2];
	      cleke2 += 1;
	    }
	  break;

	case 2:
	  tempdelta = calculadelta (MEG[i].tick - deltarake1);
	  deltarake1 = MEG[i].tick;
	  while (1)
	    {
	      bzero (temp, sizeof (temp));
	      sprintf (temp, "%c", (int) tempdelta);
	      for (j = crake1; j < crake1 + 1; j++)
		rake1[j] = temp[j - crake1];
	      crake1++;
	      if (tempdelta & 0x80)
		tempdelta >>= 8;
	      else
		break;
	    }

	  if ((MEG[i].tipo == 2) && (strake1 != 146))
	    {
	      strake1 = 146;
	      bzero (temp, sizeof (temp));
	      sprintf (temp, "%c", strake1);
	      for (j = crake1; j < crake1 + 1; j++)
		rake1[j] = temp[j - crake1];
	      crake1++;
	    }

	  if ((MEG[i].tipo == 3) && (strake1 != 178))
	    {
	      strake1 = 178;
	      bzero (temp, sizeof (temp));
	      sprintf (temp, "%c", strake1);
	      for (j = crake1; j < crake1 + 1; j++)
		rake1[j] = temp[j - crake1];
	      crake1++;
	    }

	  if ((MEG[i].tipo == 4) && (strake1 != 194))
	    {
	      strake1 = 194;
	      bzero (temp, sizeof (temp));
	      sprintf (temp, "%c", strake1);
	      for (j = crake1; j < crake1 + 1; j++)
		rake1[j] = temp[j - crake1];
	      crake1++;
	    }

	  bzero (temp, sizeof (temp));
	  if (MEG[i].tipo == 2)
	    sprintf (temp, "%c%c", MEG[i].nota, MEG[i].velocity);
	  if (MEG[i].tipo == 3)
	    sprintf (temp, "%c%c", MEG[i].nota, MEG[i].velocity);
	  if ((MEG[i].tipo == 2) || (MEG[i].tipo == 3))
	    {
	      for (j = crake1; j < crake1 + 2; j++)
		rake1[j] = temp[j - crake1];
	      crake1 += 2;
	    }

	  if (MEG[i].tipo == 4)
	    {
	      sprintf (temp, "%c", MEG[i].nota);
	      for (j = crake1; j < crake1 + 1; j++)
		rake1[j] = temp[j - crake1];
	      crake1 += 1;
	    }
	  break;

	case 3:
	  tempdelta = calculadelta (MEG[i].tick - deltarake2);
	  deltarake2 = MEG[i].tick;
	  while (1)
	    {
	      bzero (temp, sizeof (temp));
	      sprintf (temp, "%c", (int) tempdelta);
	      for (j = crake2; j < crake2 + 1; j++)
		rake2[j] = temp[j - crake2];
	      crake2++;
	      if (tempdelta & 0x80)
		tempdelta >>= 8;
	      else
		break;
	    }

	  if ((MEG[i].tipo == 2) && (strake2 != 147))
	    {
	      strake2 = 147;
	      bzero (temp, sizeof (temp));
	      sprintf (temp, "%c", strake2);
	      for (j = crake2; j < crake2 + 1; j++)
		rake2[j] = temp[j - crake2];
	      crake2++;
	    }

	  if ((MEG[i].tipo == 3) && (strake2 != 179))
	    {
	      strake2 = 179;
	      bzero (temp, sizeof (temp));
	      sprintf (temp, "%c", strake2);
	      for (j = crake2; j < crake2 + 1; j++)
		rake2[j] = temp[j - crake2];
	      crake2++;
	    }

	  if ((MEG[i].tipo == 4) && (strake2 != 195))
	    {
	      strake2 = 195;
	      bzero (temp, sizeof (temp));
	      sprintf (temp, "%c", strake2);
	      for (j = crake2; j < crake2 + 1; j++)
		rake2[j] = temp[j - crake2];
	      crake2++;
	    }

	  bzero (temp, sizeof (temp));
	  if (MEG[i].tipo == 2)
	    sprintf (temp, "%c%c", MEG[i].nota, MEG[i].velocity);
	  if (MEG[i].tipo == 3)
	    sprintf (temp, "%c%c", MEG[i].nota, MEG[i].velocity);
	  if ((MEG[i].tipo == 2) || (MEG[i].tipo == 3))
	    {
	      for (j = crake2; j < crake2 + 2; j++)
		rake2[j] = temp[j - crake2];
	      crake2 += 2;
	    }

	  if (MEG[i].tipo == 4)
	    {
	      sprintf (temp, "%c", MEG[i].nota);
	      for (j = crake2; j < crake2 + 1; j++)
		rake2[j] = temp[j - crake2];
	      crake2 += 1;
	    }
	  break;
	case 4:
	  tempdelta = calculadelta (MEG[i].tick - deltacc1);
	  deltacc1 = MEG[i].tick;
	  while (1)
	    {
	      bzero (temp, sizeof (temp));
	      sprintf (temp, "%c", (int) tempdelta);
	      for (j = cacc1; j < cacc1 + 1; j++)
		acc1[j] = temp[j - cacc1];
	      cacc1++;
	      if (tempdelta & 0x80)
		tempdelta >>= 8;
	      else
		break;
	    }

	  if ((MEG[i].tipo == 1) && (stacc1 != 148))
	    {
	      stacc1 = 148;
	      bzero (temp, sizeof (temp));
	      sprintf (temp, "%c", stacc1);
	      for (j = cacc1; j < cacc1 + 1; j++)
		acc1[j] = temp[j - cacc1];
	      cacc1++;
	    }

	  if ((MEG[i].tipo == 3) && (stacc1 != 180))
	    {
	      stacc1 = 180;
	      bzero (temp, sizeof (temp));
	      sprintf (temp, "%c", stacc1);
	      for (j = cacc1; j < cacc1 + 1; j++)
		acc1[j] = temp[j - cacc1];
	      cacc1++;
	    }

	  if ((MEG[i].tipo == 4) && (stacc1 != 196))
	    {
	      stacc1 = 196;
	      bzero (temp, sizeof (temp));
	      sprintf (temp, "%c", stacc1);
	      for (j = cacc1; j < cacc1 + 1; j++)
		acc1[j] = temp[j - cacc1];
	      cacc1++;
	    }

	  bzero (temp, sizeof (temp));
	  if (MEG[i].tipo == 1)
	    sprintf (temp, "%c%c", MEG[i].nota, MEG[i].velocity);
	  if (MEG[i].tipo == 3)
	    sprintf (temp, "%c%c", MEG[i].nota, MEG[i].velocity);
	  if ((MEG[i].tipo == 1) || (MEG[i].tipo == 3))
	    {
	      for (j = cacc1; j < cacc1 + 2; j++)
		acc1[j] = temp[j - cacc1];
	      cacc1 += 2;
	    }

	  if (MEG[i].tipo == 4)
	    {
	      sprintf (temp, "%c", MEG[i].nota);
	      for (j = cacc1; j < cacc1 + 1; j++)
		acc1[j] = temp[j - cacc1];
	      cacc1 += 1;
	    }
	  break;

	case 5:
	  tempdelta = calculadelta (MEG[i].tick - deltacc2);
	  deltacc2 = MEG[i].tick;
	  while (1)
	    {
	      bzero (temp, sizeof (temp));
	      sprintf (temp, "%c", (int) tempdelta);
	      for (j = cacc2; j < cacc2 + 1; j++)
		acc2[j] = temp[j - cacc2];
	      cacc2++;
	      if (tempdelta & 0x80)
		tempdelta >>= 8;
	      else
		break;
	    }

	  if ((MEG[i].tipo == 1) && (stacc2 != 149))
	    {
	      stacc2 = 149;
	      bzero (temp, sizeof (temp));
	      sprintf (temp, "%c", stacc2);
	      for (j = cacc2; j < cacc2 + 1; j++)
		acc2[j] = temp[j - cacc2];
	      cacc2++;
	    }

	  if ((MEG[i].tipo == 3) && (stacc2 != 181))
	    {
	      stacc2 = 181;
	      bzero (temp, sizeof (temp));
	      sprintf (temp, "%c", stacc2);
	      for (j = cacc2; j < cacc2 + 1; j++)
		acc2[j] = temp[j - cacc2];
	      cacc2++;
	    }

	  if ((MEG[i].tipo == 4) && (stacc2 != 197))
	    {
	      stacc2 = 197;
	      bzero (temp, sizeof (temp));
	      sprintf (temp, "%c", stacc2);
	      for (j = cacc2; j < cacc2 + 1; j++)
		acc2[j] = temp[j - cacc2];
	      cacc2++;
	    }

	  bzero (temp, sizeof (temp));
	  if (MEG[i].tipo == 1)
	    sprintf (temp, "%c%c", MEG[i].nota, MEG[i].velocity);
	  if (MEG[i].tipo == 3)
	    sprintf (temp, "%c%c", MEG[i].nota, MEG[i].velocity);
	  if ((MEG[i].tipo == 1) || (MEG[i].tipo == 3))
	    {
	      for (j = cacc2; j < cacc2 + 2; j++)
		acc2[j] = temp[j - cacc2];
	      cacc2 += 2;
	    }

	  if (MEG[i].tipo == 4)
	    {
	      sprintf (temp, "%c", MEG[i].nota);
	      for (j = cacc2; j < cacc2 + 1; j++)
		acc2[j] = temp[j - cacc2];
	      cacc2 += 1;
	    }
	  break;

	case 7:
	  tempdelta = calculadelta (MEG[i].tick - deltacc3);
	  deltacc3 = MEG[i].tick;
	  while (1)
	    {
	      bzero (temp, sizeof (temp));
	      sprintf (temp, "%c", (int) tempdelta);
	      for (j = cacc3; j < cacc3 + 1; j++)
		acc3[j] = temp[j - cacc3];
	      cacc3++;
	      if (tempdelta & 0x80)
		tempdelta >>= 8;
	      else
		break;
	    }

	  if ((MEG[i].tipo == 1) && (stacc3 != 151))
	    {
	      stacc3 = 151;
	      bzero (temp, sizeof (temp));
	      sprintf (temp, "%c", stacc3);
	      for (j = cacc3; j < cacc3 + 1; j++)
		acc3[j] = temp[j - cacc3];
	      cacc3++;
	    }

	  if ((MEG[i].tipo == 3) && (stacc3 != 183))
	    {
	      stacc3 = 183;
	      bzero (temp, sizeof (temp));
	      sprintf (temp, "%c", stacc3);
	      for (j = cacc3; j < cacc3 + 1; j++)
		acc3[j] = temp[j - cacc3];
	      cacc3++;
	    }

	  if ((MEG[i].tipo == 4) && (stacc3 != 199))
	    {
	      stacc3 = 199;
	      bzero (temp, sizeof (temp));
	      sprintf (temp, "%c", stacc3);
	      for (j = cacc3; j < cacc3 + 1; j++)
		acc3[j] = temp[j - cacc3];
	      cacc3++;
	    }

	  bzero (temp, sizeof (temp));
	  if (MEG[i].tipo == 1)
	    sprintf (temp, "%c%c", MEG[i].nota, MEG[i].velocity);
	  if (MEG[i].tipo == 3)
	    sprintf (temp, "%c%c", MEG[i].nota, MEG[i].velocity);
	  if ((MEG[i].tipo == 1) || (MEG[i].tipo == 3))
	    {
	      for (j = cacc3; j < cacc3 + 2; j++)
		acc3[j] = temp[j - cacc3];
	      cacc3 += 2;
	    }

	  if (MEG[i].tipo == 4)
	    {
	      sprintf (temp, "%c", MEG[i].nota);
	      for (j = cacc3; j < cacc3 + 1; j++)
		acc3[j] = temp[j - cacc3];
	      cacc3 += 1;
	    }
	  break;

	case 8:
	  tempdelta = calculadelta (MEG[i].tick - deltacc4);
	  deltacc4 = MEG[i].tick;
	  while (1)
	    {
	      bzero (temp, sizeof (temp));
	      sprintf (temp, "%c", (int) tempdelta);
	      for (j = cacc4; j < cacc4 + 1; j++)
		acc4[j] = temp[j - cacc4];
	      cacc4++;
	      if (tempdelta & 0x80)
		tempdelta >>= 8;
	      else
		break;
	    }

	  if ((MEG[i].tipo == 1) && (stacc4 != 152))
	    {
	      stacc4 = 152;
	      bzero (temp, sizeof (temp));
	      sprintf (temp, "%c", stacc4);
	      for (j = cacc4; j < cacc4 + 1; j++)
		acc4[j] = temp[j - cacc4];
	      cacc4++;
	    }

	  if ((MEG[i].tipo == 3) && (stacc4 != 184))
	    {
	      stacc4 = 184;
	      bzero (temp, sizeof (temp));
	      sprintf (temp, "%c", stacc4);
	      for (j = cacc4; j < cacc4 + 1; j++)
		acc4[j] = temp[j - cacc4];
	      cacc4++;
	    }

	  if ((MEG[i].tipo == 4) && (stacc4 != 200))
	    {
	      stacc4 = 200;
	      bzero (temp, sizeof (temp));
	      sprintf (temp, "%c", stacc4);
	      for (j = cacc4; j < cacc4 + 1; j++)
		acc4[j] = temp[j - cacc4];
	      cacc4++;
	    }

	  bzero (temp, sizeof (temp));
	  if (MEG[i].tipo == 1)
	    sprintf (temp, "%c%c", MEG[i].nota, MEG[i].velocity);
	  if (MEG[i].tipo == 3)
	    sprintf (temp, "%c%c", MEG[i].nota, MEG[i].velocity);
	  if ((MEG[i].tipo == 1) || (MEG[i].tipo == 3))
	    {
	      for (j = cacc4; j < cacc4 + 2; j++)
		acc4[j] = temp[j - cacc4];
	      cacc4 += 2;
	    }

	  if (MEG[i].tipo == 4)
	    {
	      sprintf (temp, "%c", MEG[i].nota);
	      for (j = cacc4; j < cacc4 + 1; j++)
		acc4[j] = temp[j - cacc4];
	      cacc4 += 1;
	    }
	  break;

	case 10:
	  tempdelta = calculadelta (MEG[i].tick - deltacc5);
	  deltacc5 = MEG[i].tick;
	  while (1)
	    {
	      bzero (temp, sizeof (temp));
	      sprintf (temp, "%c", (int) tempdelta);
	      for (j = cacc5; j < cacc5 + 1; j++)
		acc5[j] = temp[j - cacc5];
	      cacc5++;
	      if (tempdelta & 0x80)
		tempdelta >>= 8;
	      else
		break;
	    }

	  if ((MEG[i].tipo == 1) && (stacc5 != 154))
	    {
	      stacc5 = 154;
	      bzero (temp, sizeof (temp));
	      sprintf (temp, "%c", stacc5);
	      for (j = cacc5; j < cacc5 + 1; j++)
		acc5[j] = temp[j - cacc5];
	      cacc5++;
	    }

	  if ((MEG[i].tipo == 3) && (stacc5 != 186))
	    {
	      stacc5 = 186;
	      bzero (temp, sizeof (temp));
	      sprintf (temp, "%c", stacc5);
	      for (j = cacc5; j < cacc5 + 1; j++)
		acc5[j] = temp[j - cacc5];
	      cacc5++;
	    }

	  if ((MEG[i].tipo == 4) && (stacc5 != 202))
	    {
	      stacc5 = 202;
	      bzero (temp, sizeof (temp));
	      sprintf (temp, "%c", stacc5);
	      for (j = cacc5; j < cacc5 + 1; j++)
		acc5[j] = temp[j - cacc5];
	      cacc5++;
	    }

	  bzero (temp, sizeof (temp));
	  if (MEG[i].tipo == 1)
	    sprintf (temp, "%c%c", MEG[i].nota, MEG[i].velocity);
	  if (MEG[i].tipo == 3)
	    sprintf (temp, "%c%c", MEG[i].nota, MEG[i].velocity);
	  if ((MEG[i].tipo == 1) || (MEG[i].tipo == 3))
	    {
	      for (j = cacc5; j < cacc5 + 2; j++)
		acc5[j] = temp[j - cacc5];
	      cacc5 += 2;
	    }

	  if (MEG[i].tipo == 4)
	    {
	      sprintf (temp, "%c", MEG[i].nota);
	      for (j = cacc5; j < cacc5 + 1; j++)
		acc5[j] = temp[j - cacc5];
	      cacc5 += 1;
	    }
	  break;

	case 9:
	  tempdelta = calculadelta (MEG[i].tick - deltad);
	  deltad = MEG[i].tick;
	  while (1)
	    {
	      bzero (temp, sizeof (temp));
	      sprintf (temp, "%c", (int) tempdelta);
	      for (j = cdrums; j < cdrums + 1; j++)
		drums[j] = temp[j - cdrums];
	      cdrums++;
	      if (tempdelta & 0x80)
		tempdelta >>= 8;
	      else
		break;
	    }

	  if ((MEG[i].tipo == 1) && (stdrums != 153))
	    {
	      stdrums = 153;
	      bzero (temp, sizeof (temp));
	      sprintf (temp, "%c", stdrums);
	      for (j = cdrums; j < cdrums + 1; j++)
		drums[j] = temp[j - cdrums];
	      cdrums++;
	    }

	  if ((MEG[i].tipo == 3) && (stdrums != 185))
	    {
	      stdrums = 185;
	      bzero (temp, sizeof (temp));
	      sprintf (temp, "%c", stdrums);
	      for (j = cdrums; j < cdrums + 1; j++)
		drums[j] = temp[j - cdrums];
	      cdrums++;
	    }

	  if ((MEG[i].tipo == 4) && (stdrums != 201))
	    {
	      stdrums = 201;
	      bzero (temp, sizeof (temp));
	      sprintf (temp, "%c", stdrums);
	      for (j = cdrums; j < cdrums + 1; j++)
		drums[j] = temp[j - cdrums];
	      cdrums++;
	    }

	  bzero (temp, sizeof (temp));
	  if (MEG[i].tipo == 1)
	    sprintf (temp, "%c%c", MEG[i].nota, MEG[i].velocity);
	  if (MEG[i].tipo == 3)
	    sprintf (temp, "%c%c", MEG[i].nota, MEG[i].velocity);
	  if ((MEG[i].tipo == 1) || (MEG[i].tipo == 3))
	    {
	      for (j = cdrums; j < cdrums + 2; j++)
		drums[j] = temp[j - cdrums];
	      cdrums += 2;
	    }

	  if (MEG[i].tipo == 4)
	    {
	      sprintf (temp, "%c", MEG[i].nota);
	      for (j = cdrums; j < cdrums + 1; j++)
		drums[j] = temp[j - cdrums];
	      cdrums += 1;
	    }
	  break;


	case 6:
	  tempdelta = calculadelta (MEG[i].tick - deltab);
	  deltab = MEG[i].tick;
	  while (1)
	    {
	      bzero (temp, sizeof (temp));
	      sprintf (temp, "%c", (int) tempdelta);
	      for (j = cbass; j < cbass + 1; j++)
		bass[j] = temp[j - cbass];
	      cbass++;
	      if (tempdelta & 0x80)
		tempdelta >>= 8;
	      else
		break;
	    }

	  if ((MEG[i].tipo == 1) && (stbass != 150))
	    {
	      stbass = 150;
	      bzero (temp, sizeof (temp));
	      sprintf (temp, "%c", stbass);
	      for (j = cbass; j < cbass + 1; j++)
		bass[j] = temp[j - cbass];
	      cbass++;
	    }

	  if ((MEG[i].tipo == 3) && (stbass != 182))
	    {
	      stbass = 182;
	      bzero (temp, sizeof (temp));
	      sprintf (temp, "%c", stbass);
	      for (j = cbass; j < cbass + 1; j++)
		bass[j] = temp[j - cbass];
	      cbass++;
	    }

	  if ((MEG[i].tipo == 4) && (stbass != 198))
	    {
	      stbass = 198;
	      bzero (temp, sizeof (temp));
	      sprintf (temp, "%c", stbass);
	      for (j = cbass; j < cbass + 1; j++)
		bass[j] = temp[j - cbass];
	      cbass++;
	    }

	  bzero (temp, sizeof (temp));
	  if (MEG[i].tipo == 1)
	    sprintf (temp, "%c%c", MEG[i].nota, MEG[i].velocity);
	  if (MEG[i].tipo == 3)
	    sprintf (temp, "%c%c", MEG[i].nota, MEG[i].velocity);
	  if ((MEG[i].tipo == 1) || (MEG[i].tipo == 3))
	    {
	      for (j = cbass; j < cbass + 2; j++)
		bass[j] = temp[j - cbass];
	      cbass += 2;
	    }

	  if (MEG[i].tipo == 4)
	    {
	      sprintf (temp, "%c", MEG[i].nota);
	      for (j = cbass; j < cbass + 1; j++)
		bass[j] = temp[j - cbass];
	      cbass += 1;
	    }
	  break;
	}
    }

  bzero (temp, sizeof (temp));
  sprintf (temp, "%c%c%c%c", 0, 255, 47, 0);
  for (i = cdrums; i < cdrums + 4; i++)
    drums[i] = temp[i - cdrums];
  cdrums += 4;
  for (i = cbass; i < cbass + 4; i++)
    bass[i] = temp[i - cbass];
  cbass += 4;
  for (i = cacc1; i < cacc1 + 4; i++)
    acc1[i] = temp[i - cacc1];
  cacc1 += 4;
  for (i = cacc2; i < cacc2 + 4; i++)
    acc2[i] = temp[i - cacc2];
  cacc2 += 4;
  for (i = cacc3; i < cacc3 + 4; i++)
    acc3[i] = temp[i - cacc3];
  cacc3 += 4;
  for (i = cacc4; i < cacc4 + 4; i++)
    acc4[i] = temp[i - cacc4];
  cacc4 += 4;
  for (i = cacc5; i < cacc5 + 4; i++)
    acc5[i] = temp[i - cacc5];
  cacc5 += 4;
  for (i = cleke1; i < cleke1 + 4; i++)
    leke1[i] = temp[i - cleke1];
  cleke1 += 4;
  for (i = cleke2; i < cleke2 + 4; i++)
    leke2[i] = temp[i - cleke2];
  cleke2 += 4;
  for (i = crake1; i < crake1 + 4; i++)
    rake1[i] = temp[i - crake1];
  crake1 += 4;
  for (i = crake2; i < crake2 + 4; i++)
    rake2[i] = temp[i - crake2];
  crake2 += 4;
};

void
GMO::PonNotesOff2 ()
{
  int i, j, k;
  int eltick = 0;
  unsigned int maxtick = 0;

  grabaconta2 = grabaconta;
  memset (MEG1, 0, sizeof MEG1);
  for (i = 1; i <= grabaconta; i++)
    MEG1[i] = EG[i];
  for (i = 1; i <= grabaconta; i++)
    {
      if ((EG[i].tipo == 1) || (EG[i].tipo == 2))
	{
	  eltick = EG[i].tick + EG[i].length;

	  MEG1[grabaconta2] = EG[i];
	  MEG1[grabaconta2].tick = eltick;
	  MEG1[grabaconta2].velocity = 0;
	  MEG1[grabaconta2].length = 0;
	  grabaconta2++;
	}
    }
  grabaconta2--;
  memset (MEG, 0, sizeof MEG);
  for (i = 1; i <= grabaconta2; i++)
    {
      if (MEG1[i].tick > maxtick)
	maxtick = MEG1[i].tick;
    }
  k = 1;
  for (i = 0; i <= (int) maxtick; i++)
    {
      for (j = 1; j <= grabaconta2; j++)
	{
	  if ((int) MEG1[j].tick == i)
	    {
	      MEG[k] = MEG1[j];
	      k++;
	    }
	}
    }
  grabaconta2 = k - 1;
};
