// Copyright 2019 The Energi Core Authors
// Copyright 2018 The go-ethereum Authors
// This file is part of Energi Core.
//
// Energi Core is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Energi Core is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Energi Core. If not, see <http://www.gnu.org/licenses/>.

// Command bzzhash computes a swarm tree hash.
package main

import (
	"context"
	"fmt"
	"os"

	"energi.world/core/gen3/cmd/utils"
	"energi.world/core/gen3/swarm/storage"
	"gopkg.in/urfave/cli.v1"
)

var hashesCommand = cli.Command{
	Action:             hashes,
	CustomHelpTemplate: helpTemplate,
	Name:               "hashes",
	Usage:              "print all hashes of a file to STDOUT",
	ArgsUsage:          "<file>",
	Description:        "Prints all hashes of a file to STDOUT",
}

func hashes(ctx *cli.Context) {
	args := ctx.Args()
	if len(args) < 1 {
		utils.Fatalf("Usage: swarm hashes <file name>")
	}
	f, err := os.Open(args[0])
	if err != nil {
		utils.Fatalf("Error opening file " + args[1])
	}
	defer f.Close()

	fileStore := storage.NewFileStore(&storage.FakeChunkStore{}, storage.NewFileStoreParams())
	refs, err := fileStore.GetAllReferences(context.TODO(), f, false)
	if err != nil {
		utils.Fatalf("%v\n", err)
	} else {
		for _, r := range refs {
			fmt.Println(r.String())
		}
	}
}
