/*
    This file is part of the syndication library
    SPDX-FileCopyrightText: 2006 Frank Osterfeld <osterfeld@kde.org>

    SPDX-License-Identifier: LGPL-2.0-or-later
*/

#ifndef SYNDICATION_ATOM_ATOM_H
#define SYNDICATION_ATOM_ATOM_H

#include <syndication/atom/category.h>
#include <syndication/atom/constants.h>
#include <syndication/atom/content.h>
#include <syndication/atom/document.h>
#include <syndication/atom/entry.h>
#include <syndication/atom/generator.h>
#include <syndication/atom/link.h>
#include <syndication/atom/parser.h>
#include <syndication/atom/person.h>
#include <syndication/atom/source.h>

namespace Syndication
{
/*!
 * \namespace Syndication::Atom
 * \inmodule Syndication
 *
 * \brief Atom parser and model classes, representing
 * Atom 1.0 documents.
 *
 * (Atom 0.3 documents are
 * converted by the parser)
 */
namespace Atom
{
}
}

#endif // SYNDICATION_ATOM_ATOM_H
