/***************************************************************************
                       graphics.cpp  -  graphics surface class
                             -------------------
    begin                : Tue Oct 14 2003
    copyright            : (C) 2003 by Paul Robson
    email                : autismuk@autismuk.freeserve.co.uk
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "cob.hxx"

//	**************************************************************************************************************************
//
//							                    Repaint Sprite Objects
//
//	**************************************************************************************************************************

void Graphics::Repaint(void)
{
    for (int i = 0;i < 16;i++)                  // 16 possible grid combinations, 2 colours
        for (int r = 0;r < 2;r++)
        {
            SetOrigin(i*SPRITESIZE,r*SPRITESIZE);
            SetScale(SPRITESIZE,SPRITESIZE);
            PaintSquare(i+r*16);
        }
    for (int i = 0;i < 3;i++)                   // 3 Colours : Red, White (chasers alternate) and Cyan (Player)
    {
        int r = 255,g = 0,b = 0;
        SetOrigin(i*SPRITESIZE,2*SPRITESIZE);
        SetScale(SPRITESIZE,SPRITESIZE);
        if (i == 1) g = b = 255;
        if (i == 2) r = 0,g = b = 255;
        for (int w = 127;w > 0;w--)
        {
            int p = 100-w*6/10;
            SetColour(r*p/100,g*p/100,b*p/100);
            FillEllipse(128-w,128-w,128+w,128+w);
        }
        SetColour(0,0,0);FrameEllipse(0,0,255,255);
    }
}

//	**************************************************************************************************************************
//
//							                            Draw on grid square
//
//	**************************************************************************************************************************

void Graphics::PaintSquare(int Bits)
{
    int w = 32;
    int x1 = 0,x2 = 255,y1 = 0,y2 = 255;
    SetColour(0,0,0);
    FillRect(0,128-w,255,128+w);
    FillRect(128-w,0,128+w,255);
    if ((Bits & M_UP) == 0) y1 = 128-w;
    if ((Bits & M_DOWN) == 0) y2 = 128+w;
    if ((Bits & M_LEFT) == 0) x1 = 128-w;
    if ((Bits & M_RIGHT) == 0) x2 = 128+w;
    
    for (int i = -w;i <= w;i++)
    {
        int p = 255-(abs(i)*128/w);
        SetColour(p,p,p);
        if (Bits & M_COLOUR) SetColour(0,p,0);
        if (Bits & (M_LEFT|M_RIGHT)) Line(x1,128+i,x2,128+i);
        if (Bits & (M_UP|M_DOWN)) Line(128+i,y1,128+i,y2);
    }
}
