; C Library
;
; Copyright (C) 2024 Kestrel Institute (http://www.kestrel.edu)
; Copyright (C) 2024 Kestrel Technology LLC (http://kestreltechnology.com)
;
; License: A 3-clause BSD license. See the LICENSE file distributed with ACL2.
;
; Author: Alessandro Coglio (www.alessandrocoglio.info)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(in-package "C")

(include-book "std/util/defrule" :dir :system)
(include-book "xdoc/constructors" :dir :system)

(local (xdoc::set-default-parents atc-symbolic-execution-rules))

(local (include-book "kestrel/built-ins/disable" :dir :system))
(local (acl2::disable-most-builtin-logic-defuns))
(local (acl2::disable-builtin-rewrite-rules-for-defaults))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defsection atc-if*-rules
  :short "Rules about @(tsee if*)."
  :long
  (xdoc::topstring
   (xdoc::p
    "We just have a fairly ad hoc rule here;
     because it is so ad hoc, for now we prefer not to add it
     to @('[books]/std/basic/if-star.lisp').")
   (xdoc::p
    "The need for this rule arises in the modular theorems
     generated for the non-strict disjunctive operator @('||').
     Due to the fact that @('(or a b)') is @('(if a a b)'),
     with the condition repeated in the `then' branch,
     and the fact that @(tsee if) is turned into @(tsee if*)
     in the modular theorems generated by ATC,
     a subgoal @('(booleanp (if* t t ...))') comes up.
     This rule serves to resolve it."))

  (defruled if*-of-t-and-t
    (booleanp (if* t t x))
    :enable if*))
