// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// <p>The ABAC status of the general purpose bucket. When ABAC is enabled for the general purpose bucket, you can use tags to manage access to the general purpose buckets as well as for cost tracking purposes. When ABAC is disabled for the general purpose buckets, you can only use tags for cost tracking purposes. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/buckets-tagging.html">Using tags with S3 general purpose buckets</a>.</p>
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct AbacStatus {
    /// <p>The ABAC status of the general purpose bucket.</p>
    pub status: ::std::option::Option<crate::types::BucketAbacStatus>,
}
impl AbacStatus {
    /// <p>The ABAC status of the general purpose bucket.</p>
    pub fn status(&self) -> ::std::option::Option<&crate::types::BucketAbacStatus> {
        self.status.as_ref()
    }
}
impl AbacStatus {
    /// Creates a new builder-style object to manufacture [`AbacStatus`](crate::types::AbacStatus).
    pub fn builder() -> crate::types::builders::AbacStatusBuilder {
        crate::types::builders::AbacStatusBuilder::default()
    }
}

/// A builder for [`AbacStatus`](crate::types::AbacStatus).
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
#[non_exhaustive]
pub struct AbacStatusBuilder {
    pub(crate) status: ::std::option::Option<crate::types::BucketAbacStatus>,
}
impl AbacStatusBuilder {
    /// <p>The ABAC status of the general purpose bucket.</p>
    pub fn status(mut self, input: crate::types::BucketAbacStatus) -> Self {
        self.status = ::std::option::Option::Some(input);
        self
    }
    /// <p>The ABAC status of the general purpose bucket.</p>
    pub fn set_status(mut self, input: ::std::option::Option<crate::types::BucketAbacStatus>) -> Self {
        self.status = input;
        self
    }
    /// <p>The ABAC status of the general purpose bucket.</p>
    pub fn get_status(&self) -> &::std::option::Option<crate::types::BucketAbacStatus> {
        &self.status
    }
    /// Consumes the builder and constructs a [`AbacStatus`](crate::types::AbacStatus).
    pub fn build(self) -> crate::types::AbacStatus {
        crate::types::AbacStatus { status: self.status }
    }
}
