/* bind.c generated by valac 0.56.17, the Vala compiler
 * generated from bind.vala, do not modify */

/* Key bindings and extended commands

   Copyright (c) 1997-2021 Free Software Foundation, Inc.

   This file is part of GNU Zile.

   GNU Zile is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3, or (at your option)
   any later version.

   GNU Zile is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, see <https://www.gnu.org/licenses/>.  */

#include <glib.h>
#include <glib-object.h>
#include <gee.h>
#include <gobject/gvaluecollector.h>
#include <stdlib.h>
#include <string.h>

#define GETKEY_DEFAULT -1
#define KBD_NOKEY ((Keystroke) G_MAXUINT)
#define KBD_META ((Keystroke) 02000)
#define KBD_CTRL ((Keystroke) 01000)
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

typedef guint Keystroke;

#define TYPE_BINDING (binding_get_type ())
#define BINDING(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BINDING, Binding))
#define BINDING_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BINDING, BindingClass))
#define IS_BINDING(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BINDING))
#define IS_BINDING_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BINDING))
#define BINDING_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BINDING, BindingClass))

typedef struct _Binding Binding;
typedef struct _BindingClass BindingClass;
typedef struct _BindingPrivate BindingPrivate;

#define TYPE_LISP_FUNC (lisp_func_get_type ())
#define LISP_FUNC(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LISP_FUNC, LispFunc))
#define LISP_FUNC_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LISP_FUNC, LispFuncClass))
#define IS_LISP_FUNC(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LISP_FUNC))
#define IS_LISP_FUNC_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LISP_FUNC))
#define LISP_FUNC_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LISP_FUNC, LispFuncClass))

typedef struct _LispFunc LispFunc;
typedef struct _LispFuncClass LispFuncClass;
#define _lisp_func_unref0(var) ((var == NULL) ? NULL : (var = (lisp_func_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _binding_unref0(var) ((var == NULL) ? NULL : (var = (binding_unref (var), NULL)))
typedef struct _ParamSpecBinding ParamSpecBinding;
typedef enum  {
	FLAGS_NEED_RESYNC = 1 << 0,
	FLAGS_SET_UNIARG = 1 << 1,
	FLAGS_UNIARG_EMPTY = 1 << 2,
	FLAGS_DEFINING_MACRO = 1 << 3
} Flags;

#define TYPE_FLAGS (flags_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_BUFFER (buffer_get_type ())
#define BUFFER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BUFFER, Buffer))
#define BUFFER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BUFFER, BufferClass))
#define IS_BUFFER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BUFFER))
#define IS_BUFFER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BUFFER))
#define BUFFER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BUFFER, BufferClass))

typedef struct _Buffer Buffer;
typedef struct _BufferClass BufferClass;
typedef struct _BufferPrivate BufferPrivate;

#define TYPE_MARKER (marker_get_type ())
#define MARKER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MARKER, Marker))
#define MARKER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MARKER, MarkerClass))
#define IS_MARKER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MARKER))
#define IS_MARKER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MARKER))
#define MARKER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MARKER, MarkerClass))

typedef struct _Marker Marker;
typedef struct _MarkerClass MarkerClass;

#define TYPE_UNDO (undo_get_type ())
#define UNDO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_UNDO, Undo))
#define UNDO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_UNDO, UndoClass))
#define IS_UNDO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_UNDO))
#define IS_UNDO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_UNDO))
#define UNDO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_UNDO, UndoClass))

typedef struct _Undo Undo;
typedef struct _UndoClass UndoClass;

#define TYPE_VAR_ENTRY (var_entry_get_type ())
#define VAR_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VAR_ENTRY, VarEntry))
#define VAR_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VAR_ENTRY, VarEntryClass))
#define IS_VAR_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VAR_ENTRY))
#define IS_VAR_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VAR_ENTRY))
#define VAR_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VAR_ENTRY, VarEntryClass))

typedef struct _VarEntry VarEntry;
typedef struct _VarEntryClass VarEntryClass;
typedef struct _LispFuncPrivate LispFuncPrivate;
typedef gboolean (*Function) (glong uniarg, GeeQueue* args);
typedef void (*BindingsProcessor) (const gchar* key, Binding* p, gpointer user_data);
typedef void (*BindingsWalker) (Binding* tree, gchar** keys, gint keys_length1, gpointer user_data);
typedef struct _Block1Data Block1Data;
typedef gboolean (*MovementDelegate) (gpointer user_data);
typedef struct _Block2Data Block2Data;
typedef struct _Block3Data Block3Data;
typedef void (*BufferWriter) (gpointer user_data);
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _Binding {
	GTypeInstance parent_instance;
	volatile int ref_count;
	BindingPrivate * priv;
	LispFunc* func;
	GeeMap* map;
};

struct _BindingClass {
	GTypeClass parent_class;
	void (*finalize) (Binding *self);
};

struct _ParamSpecBinding {
	GParamSpec parent_instance;
};

struct _Buffer {
	GTypeInstance parent_instance;
	volatile int ref_count;
	BufferPrivate * priv;
	gchar* name;
	gchar* filename;
	Buffer* next;
	gsize goalc;
	Marker* mark;
	Marker* markers;
	GList* last_undop;
	GList* next_undop;
	GHashTable* vars;
	gboolean modified;
	gboolean nosave;
	gboolean needname;
	gboolean temporary;
	gboolean readonly;
	gboolean backup;
	gboolean noundo;
	gboolean autofill;
	gboolean isearch;
	gboolean mark_active;
	gchar* dir;
};

struct _BufferClass {
	GTypeClass parent_class;
	void (*finalize) (Buffer *self);
	gsize (*get_length) (Buffer* self);
	const gchar* (*get_eol) (Buffer* self);
};

struct _LispFunc {
	GTypeInstance parent_instance;
	volatile int ref_count;
	LispFuncPrivate * priv;
	gchar* name;
	Function func;
	gboolean interactive;
	gchar* doc;
};

struct _LispFuncClass {
	GTypeClass parent_class;
	void (*finalize) (LispFunc *self);
};

struct _Block1Data {
	int _ref_count_;
	BindingsWalker walker;
	gpointer walker_target;
	GDestroyNotify walker_target_destroy_notify;
	BindingsProcessor process;
	gpointer process_target;
};

struct _Block2Data {
	int _ref_count_;
	LispFunc* f;
};

struct _Block3Data {
	int _ref_count_;
	Block2Data * _data2_;
	gchar* bindings;
};

static gpointer binding_parent_class = NULL;
VALA_EXTERN Binding* root_bindings;
Binding* root_bindings = NULL;
VALA_EXTERN Flags lastflag;
VALA_EXTERN gint last_uniarg;
VALA_EXTERN Buffer* cur_bp;
VALA_EXTERN LispFunc* _last_command;
LispFunc* _last_command = NULL;
VALA_EXTERN LispFunc* _this_command;
LispFunc* _this_command = NULL;
VALA_EXTERN Flags thisflag;
VALA_EXTERN const gchar* default_bindings;

VALA_EXTERN gpointer binding_ref (gpointer instance);
VALA_EXTERN void binding_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_binding (const gchar* name,
                                const gchar* nick,
                                const gchar* blurb,
                                GType object_type,
                                GParamFlags flags);
VALA_EXTERN void value_set_binding (GValue* value,
                        gpointer v_object);
VALA_EXTERN void value_take_binding (GValue* value,
                         gpointer v_object);
VALA_EXTERN gpointer value_get_binding (const GValue* value);
VALA_EXTERN GType binding_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Binding, binding_unref)
VALA_EXTERN gpointer lisp_func_ref (gpointer instance);
VALA_EXTERN void lisp_func_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_lisp_func (const gchar* name,
                                  const gchar* nick,
                                  const gchar* blurb,
                                  GType object_type,
                                  GParamFlags flags);
VALA_EXTERN void value_set_lisp_func (GValue* value,
                          gpointer v_object);
VALA_EXTERN void value_take_lisp_func (GValue* value,
                           gpointer v_object);
VALA_EXTERN gpointer value_get_lisp_func (const GValue* value);
VALA_EXTERN GType lisp_func_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (LispFunc, lisp_func_unref)
VALA_EXTERN Binding* binding_new (void);
VALA_EXTERN Binding* binding_construct (GType object_type);
VALA_EXTERN Binding* binding_find (Binding* self,
                       GeeList* keys);
VALA_EXTERN void binding_bind (Binding* self,
                   GeeList* keys,
                   LispFunc* func);
static void binding_finalize (Binding * obj);
static GType binding_get_type_once (void);
VALA_EXTERN Keystroke binding_completion (const gchar* a);
VALA_EXTERN GType flags_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void minibuf_write (const gchar* fmt,
                    ...);
VALA_EXTERN Keystroke getkey (gint delay);
VALA_EXTERN void minibuf_clear (void);
VALA_EXTERN GeeList* get_key_sequence (void);
VALA_EXTERN gchar* keyvectodesc (GeeList* keys);
VALA_EXTERN LispFunc* get_function_by_keys (GeeList* keys);
VALA_EXTERN LispFunc* lisp_func_find (const gchar* name);
VALA_EXTERN gboolean self_insert_command (void);
VALA_EXTERN Keystroke lastkey (void);
VALA_EXTERN gpointer buffer_ref (gpointer instance);
VALA_EXTERN void buffer_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_buffer (const gchar* name,
                               const gchar* nick,
                               const gchar* blurb,
                               GType object_type,
                               GParamFlags flags);
VALA_EXTERN void value_set_buffer (GValue* value,
                       gpointer v_object);
VALA_EXTERN void value_take_buffer (GValue* value,
                        gpointer v_object);
VALA_EXTERN gpointer value_get_buffer (const GValue* value);
VALA_EXTERN GType buffer_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Buffer, buffer_unref)
VALA_EXTERN gpointer marker_ref (gpointer instance);
VALA_EXTERN void marker_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_marker (const gchar* name,
                               const gchar* nick,
                               const gchar* blurb,
                               GType object_type,
                               GParamFlags flags);
VALA_EXTERN void value_set_marker (GValue* value,
                       gpointer v_object);
VALA_EXTERN void value_take_marker (GValue* value,
                        gpointer v_object);
VALA_EXTERN gpointer value_get_marker (const GValue* value);
VALA_EXTERN GType marker_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Marker, marker_unref)
VALA_EXTERN gpointer undo_ref (gpointer instance);
VALA_EXTERN void undo_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_undo (const gchar* name,
                             const gchar* nick,
                             const gchar* blurb,
                             GType object_type,
                             GParamFlags flags);
VALA_EXTERN void value_set_undo (GValue* value,
                     gpointer v_object);
VALA_EXTERN void value_take_undo (GValue* value,
                      gpointer v_object);
VALA_EXTERN gpointer value_get_undo (const GValue* value);
VALA_EXTERN GType undo_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Undo, undo_unref)
VALA_EXTERN gpointer var_entry_ref (gpointer instance);
VALA_EXTERN void var_entry_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_var_entry (const gchar* name,
                                  const gchar* nick,
                                  const gchar* blurb,
                                  GType object_type,
                                  GParamFlags flags);
VALA_EXTERN void value_set_var_entry (GValue* value,
                          gpointer v_object);
VALA_EXTERN void value_take_var_entry (GValue* value,
                           gpointer v_object);
VALA_EXTERN gpointer value_get_var_entry (const GValue* value);
VALA_EXTERN GType var_entry_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (VarEntry, var_entry_unref)
VALA_EXTERN gboolean* fill_break_line (void);
VALA_EXTERN gboolean buffer_insert_char (Buffer* self,
                             gchar c);
VALA_EXTERN void ding (void);
VALA_EXTERN LispFunc* last_command (void);
VALA_EXTERN void set_this_command (LispFunc* cmd);
VALA_EXTERN gboolean call_command (LispFunc* f,
                       glong uniarg,
                       GeeQueue* args);
VALA_EXTERN void undo_start_sequence (void);
VALA_EXTERN void add_cmd_to_macro (void);
VALA_EXTERN void undo_end_sequence (void);
VALA_EXTERN void get_and_run_command (void);
VALA_EXTERN void minibuf_error (const gchar* fmt,
                    ...);
VALA_EXTERN void init_default_bindings (void);
VALA_EXTERN void lisp_loadstring (const gchar* a);
VALA_EXTERN void walk_bindings (BindingsProcessor process,
                    gpointer process_target);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static void __lambda23_ (Block1Data* _data1_,
                  Binding* tree,
                  gchar** keys,
                  gint keys_length1);
static gchar** _vala_array_dup1 (gchar** self,
                          gssize length);
VALA_EXTERN gchar* chordtodesc (Keystroke key);
static void _vala_array_add1 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void ___lambda23__bindings_walker (Binding* tree,
                                   gchar** keys,
                                   gint keys_length1,
                                   gpointer self);
VALA_EXTERN void bind_init (void);
static gboolean __lambda24_ (glong uniarg,
                      GeeQueue* args);
VALA_EXTERN GeeList* keystrtovec (const gchar* key);
VALA_EXTERN gchar* minibuf_read_function_name (const gchar* fmt,
                                   ...);
static gboolean ___lambda24__function (glong uniarg,
                                GeeQueue* args);
VALA_EXTERN LispFunc* lisp_func_new (const gchar* name,
                         Function func,
                         gboolean interactive,
                         const gchar* doc);
VALA_EXTERN LispFunc* lisp_func_construct (GType object_type,
                               const gchar* name,
                               Function func,
                               gboolean interactive,
                               const gchar* doc);
static gboolean __lambda26_ (glong uniarg,
                      GeeQueue* args);
VALA_EXTERN gboolean execute_with_uniarg (glong uniarg,
                              MovementDelegate forward,
                              gpointer forward_target,
                              MovementDelegate backward,
                              gpointer backward_target);
static gboolean _self_insert_command_movement_delegate (gpointer self);
static gboolean ___lambda26__function (glong uniarg,
                                GeeQueue* args);
static gboolean __lambda27_ (glong uniarg,
                      GeeQueue* args);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
static void ____lambda28_ (Block3Data* _data3_,
                    const gchar* key,
                    Binding* p);
static void _____lambda28__bindings_processor (const gchar* key,
                                        Binding* p,
                                        gpointer self);
static gboolean ___lambda27__function (glong uniarg,
                                GeeQueue* args);
static gboolean __lambda29_ (glong uniarg,
                      GeeQueue* args);
VALA_EXTERN void write_temp_buffer (const gchar* name,
                        gboolean show,
                        BufferWriter func,
                        gpointer func_target);
static void __lambda30_ (void);
VALA_EXTERN void bprintf (const gchar* fmt,
              ...);
static void __lambda31_ (const gchar* key,
                  Binding* p);
static void ___lambda31__bindings_processor (const gchar* key,
                                      Binding* p,
                                      gpointer self);
static void ___lambda30__buffer_writer (gpointer self);
static gboolean ___lambda29__function (glong uniarg,
                                GeeQueue* args);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

Binding*
binding_construct (GType object_type)
{
	Binding* self = NULL;
	GeeTreeMap* _tmp0_;
#line 33 "src/bind.vala"
	self = (Binding*) g_type_create_instance (object_type);
#line 34 "src/bind.vala"
	_tmp0_ = gee_tree_map_new (G_TYPE_UINT, NULL, NULL, TYPE_BINDING, (GBoxedCopyFunc) binding_ref, (GDestroyNotify) binding_unref, NULL, NULL, NULL, NULL, NULL, NULL);
#line 34 "src/bind.vala"
	_g_object_unref0 (self->map);
#line 34 "src/bind.vala"
	self->map = (GeeMap*) _tmp0_;
#line 33 "src/bind.vala"
	return self;
#line 462 "bind.c"
}

Binding*
binding_new (void)
{
#line 33 "src/bind.vala"
	return binding_construct (TYPE_BINDING);
#line 470 "bind.c"
}

static gpointer
_binding_ref0 (gpointer self)
{
#line 42 "src/bind.vala"
	return self ? binding_ref (self) : NULL;
#line 478 "bind.c"
}

Binding*
binding_find (Binding* self,
              GeeList* keys)
{
	gint _tmp0_;
	gint _tmp1_;
	Binding* result;
#line 37 "src/bind.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 37 "src/bind.vala"
	g_return_val_if_fail (keys != NULL, NULL);
#line 38 "src/bind.vala"
	_tmp0_ = gee_collection_get_size ((GeeCollection*) keys);
#line 38 "src/bind.vala"
	_tmp1_ = _tmp0_;
#line 38 "src/bind.vala"
	if (_tmp1_ == 0) {
#line 498 "bind.c"
		gboolean _tmp2_ = FALSE;
		LispFunc* _tmp3_;
		Binding* _tmp5_;
#line 41 "src/bind.vala"
		_tmp3_ = self->func;
#line 41 "src/bind.vala"
		if (_tmp3_ != NULL) {
#line 41 "src/bind.vala"
			_tmp2_ = TRUE;
#line 508 "bind.c"
		} else {
			GeeMap* _tmp4_;
#line 41 "src/bind.vala"
			_tmp4_ = self->map;
#line 41 "src/bind.vala"
			_tmp2_ = _tmp4_ != NULL;
#line 515 "bind.c"
		}
#line 41 "src/bind.vala"
		_vala_assert (_tmp2_, "func != null || map != null");
#line 42 "src/bind.vala"
		_tmp5_ = _binding_ref0 (self);
#line 42 "src/bind.vala"
		result = _tmp5_;
#line 42 "src/bind.vala"
		return result;
#line 525 "bind.c"
	} else {
		GeeMap* _tmp6_;
		Binding* p = NULL;
		GeeMap* _tmp7_;
		gpointer _tmp8_;
		gpointer _tmp9_;
		Binding* _tmp10_ = NULL;
		Binding* _tmp11_;
#line 44 "src/bind.vala"
		_tmp6_ = self->map;
#line 44 "src/bind.vala"
		_vala_assert (_tmp6_ != NULL, "map != null");
#line 45 "src/bind.vala"
		_tmp7_ = self->map;
#line 45 "src/bind.vala"
		_tmp8_ = gee_list_first (keys);
#line 45 "src/bind.vala"
		_tmp9_ = gee_map_get (_tmp7_, (gpointer) ((guintptr) _tmp8_));
#line 45 "src/bind.vala"
		p = (Binding*) _tmp9_;
#line 46 "src/bind.vala"
		_tmp11_ = p;
#line 46 "src/bind.vala"
		if (_tmp11_ == NULL) {
#line 46 "src/bind.vala"
			_binding_unref0 (_tmp10_);
#line 46 "src/bind.vala"
			_tmp10_ = NULL;
#line 554 "bind.c"
		} else {
			Binding* _tmp12_;
			gint _tmp13_;
			gint _tmp14_;
			GeeList* _tmp15_;
			GeeList* _tmp16_;
			Binding* _tmp17_;
#line 46 "src/bind.vala"
			_tmp12_ = p;
#line 46 "src/bind.vala"
			_tmp13_ = gee_collection_get_size ((GeeCollection*) keys);
#line 46 "src/bind.vala"
			_tmp14_ = _tmp13_;
#line 46 "src/bind.vala"
			_tmp15_ = gee_list_slice (keys, 1, _tmp14_);
#line 46 "src/bind.vala"
			_tmp16_ = _tmp15_;
#line 46 "src/bind.vala"
			_tmp17_ = binding_find (_tmp12_, _tmp16_);
#line 46 "src/bind.vala"
			_binding_unref0 (_tmp10_);
#line 46 "src/bind.vala"
			_tmp10_ = _tmp17_;
#line 46 "src/bind.vala"
			_g_object_unref0 (_tmp16_);
#line 580 "bind.c"
		}
#line 46 "src/bind.vala"
		result = _tmp10_;
#line 46 "src/bind.vala"
		_binding_unref0 (p);
#line 46 "src/bind.vala"
		return result;
#line 588 "bind.c"
	}
}

static gpointer
_lisp_func_ref0 (gpointer self)
{
#line 54 "src/bind.vala"
	return self ? lisp_func_ref (self) : NULL;
#line 597 "bind.c"
}

void
binding_bind (Binding* self,
              GeeList* keys,
              LispFunc* func)
{
	gint _tmp0_;
	gint _tmp1_;
	Binding* branch = NULL;
	GeeMap* _tmp3_;
	gpointer _tmp4_;
	gpointer _tmp5_;
	Binding* _tmp6_;
	Binding* _tmp12_;
	gint _tmp13_;
	gint _tmp14_;
	GeeList* _tmp15_;
	GeeList* _tmp16_;
#line 50 "src/bind.vala"
	g_return_if_fail (self != NULL);
#line 50 "src/bind.vala"
	g_return_if_fail (keys != NULL);
#line 50 "src/bind.vala"
	g_return_if_fail (func != NULL);
#line 52 "src/bind.vala"
	_tmp0_ = gee_collection_get_size ((GeeCollection*) keys);
#line 52 "src/bind.vala"
	_tmp1_ = _tmp0_;
#line 52 "src/bind.vala"
	if (_tmp1_ == 0) {
#line 629 "bind.c"
		LispFunc* _tmp2_;
#line 53 "src/bind.vala"
		_g_object_unref0 (self->map);
#line 53 "src/bind.vala"
		self->map = NULL;
#line 54 "src/bind.vala"
		_tmp2_ = _lisp_func_ref0 (func);
#line 54 "src/bind.vala"
		_lisp_func_unref0 (self->func);
#line 54 "src/bind.vala"
		self->func = _tmp2_;
#line 55 "src/bind.vala"
		return;
#line 643 "bind.c"
	}
#line 58 "src/bind.vala"
	_tmp3_ = self->map;
#line 58 "src/bind.vala"
	_tmp4_ = gee_list_first (keys);
#line 58 "src/bind.vala"
	_tmp5_ = gee_map_get (_tmp3_, (gpointer) ((guintptr) _tmp4_));
#line 58 "src/bind.vala"
	branch = (Binding*) _tmp5_;
#line 61 "src/bind.vala"
	_tmp6_ = branch;
#line 61 "src/bind.vala"
	if (_tmp6_ == NULL) {
#line 657 "bind.c"
		Binding* _tmp7_;
		GeeMap* _tmp8_;
		gpointer _tmp9_;
		Binding* _tmp10_;
#line 62 "src/bind.vala"
		_tmp7_ = binding_new ();
#line 62 "src/bind.vala"
		_binding_unref0 (branch);
#line 62 "src/bind.vala"
		branch = _tmp7_;
#line 63 "src/bind.vala"
		_tmp8_ = self->map;
#line 63 "src/bind.vala"
		_tmp9_ = gee_list_first (keys);
#line 63 "src/bind.vala"
		_tmp10_ = branch;
#line 63 "src/bind.vala"
		gee_map_set (_tmp8_, (gpointer) ((guintptr) _tmp9_), _tmp10_);
#line 676 "bind.c"
	} else {
		Binding* _tmp11_;
#line 66 "src/bind.vala"
		_tmp11_ = branch;
#line 66 "src/bind.vala"
		_lisp_func_unref0 (_tmp11_->func);
#line 66 "src/bind.vala"
		_tmp11_->func = NULL;
#line 685 "bind.c"
	}
#line 69 "src/bind.vala"
	_tmp12_ = branch;
#line 69 "src/bind.vala"
	_tmp13_ = gee_collection_get_size ((GeeCollection*) keys);
#line 69 "src/bind.vala"
	_tmp14_ = _tmp13_;
#line 69 "src/bind.vala"
	_tmp15_ = gee_list_slice (keys, 1, _tmp14_);
#line 69 "src/bind.vala"
	_tmp16_ = _tmp15_;
#line 69 "src/bind.vala"
	binding_bind (_tmp12_, _tmp16_, func);
#line 69 "src/bind.vala"
	_g_object_unref0 (_tmp16_);
#line 50 "src/bind.vala"
	_binding_unref0 (branch);
#line 703 "bind.c"
}

static void
value_binding_init (GValue* value)
{
#line 28 "src/bind.vala"
	value->data[0].v_pointer = NULL;
#line 711 "bind.c"
}

static void
value_binding_free_value (GValue* value)
{
#line 28 "src/bind.vala"
	if (value->data[0].v_pointer) {
#line 28 "src/bind.vala"
		binding_unref (value->data[0].v_pointer);
#line 721 "bind.c"
	}
}

static void
value_binding_copy_value (const GValue* src_value,
                          GValue* dest_value)
{
#line 28 "src/bind.vala"
	if (src_value->data[0].v_pointer) {
#line 28 "src/bind.vala"
		dest_value->data[0].v_pointer = binding_ref (src_value->data[0].v_pointer);
#line 733 "bind.c"
	} else {
#line 28 "src/bind.vala"
		dest_value->data[0].v_pointer = NULL;
#line 737 "bind.c"
	}
}

static gpointer
value_binding_peek_pointer (const GValue* value)
{
#line 28 "src/bind.vala"
	return value->data[0].v_pointer;
#line 746 "bind.c"
}

static gchar*
value_binding_collect_value (GValue* value,
                             guint n_collect_values,
                             GTypeCValue* collect_values,
                             guint collect_flags)
{
#line 28 "src/bind.vala"
	if (collect_values[0].v_pointer) {
#line 757 "bind.c"
		Binding * object;
		object = collect_values[0].v_pointer;
#line 28 "src/bind.vala"
		if (object->parent_instance.g_class == NULL) {
#line 28 "src/bind.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 764 "bind.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 28 "src/bind.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 768 "bind.c"
		}
#line 28 "src/bind.vala"
		value->data[0].v_pointer = binding_ref (object);
#line 772 "bind.c"
	} else {
#line 28 "src/bind.vala"
		value->data[0].v_pointer = NULL;
#line 776 "bind.c"
	}
#line 28 "src/bind.vala"
	return NULL;
#line 780 "bind.c"
}

static gchar*
value_binding_lcopy_value (const GValue* value,
                           guint n_collect_values,
                           GTypeCValue* collect_values,
                           guint collect_flags)
{
	Binding ** object_p;
	object_p = collect_values[0].v_pointer;
#line 28 "src/bind.vala"
	if (!object_p) {
#line 28 "src/bind.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 795 "bind.c"
	}
#line 28 "src/bind.vala"
	if (!value->data[0].v_pointer) {
#line 28 "src/bind.vala"
		*object_p = NULL;
#line 801 "bind.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 28 "src/bind.vala"
		*object_p = value->data[0].v_pointer;
#line 805 "bind.c"
	} else {
#line 28 "src/bind.vala"
		*object_p = binding_ref (value->data[0].v_pointer);
#line 809 "bind.c"
	}
#line 28 "src/bind.vala"
	return NULL;
#line 813 "bind.c"
}

GParamSpec*
param_spec_binding (const gchar* name,
                    const gchar* nick,
                    const gchar* blurb,
                    GType object_type,
                    GParamFlags flags)
{
	ParamSpecBinding* spec;
#line 28 "src/bind.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_BINDING), NULL);
#line 28 "src/bind.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 28 "src/bind.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 28 "src/bind.vala"
	return G_PARAM_SPEC (spec);
#line 832 "bind.c"
}

gpointer
value_get_binding (const GValue* value)
{
#line 28 "src/bind.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_BINDING), NULL);
#line 28 "src/bind.vala"
	return value->data[0].v_pointer;
#line 842 "bind.c"
}

void
value_set_binding (GValue* value,
                   gpointer v_object)
{
	Binding * old;
#line 28 "src/bind.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_BINDING));
#line 28 "src/bind.vala"
	old = value->data[0].v_pointer;
#line 28 "src/bind.vala"
	if (v_object) {
#line 28 "src/bind.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_BINDING));
#line 28 "src/bind.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 28 "src/bind.vala"
		value->data[0].v_pointer = v_object;
#line 28 "src/bind.vala"
		binding_ref (value->data[0].v_pointer);
#line 864 "bind.c"
	} else {
#line 28 "src/bind.vala"
		value->data[0].v_pointer = NULL;
#line 868 "bind.c"
	}
#line 28 "src/bind.vala"
	if (old) {
#line 28 "src/bind.vala"
		binding_unref (old);
#line 874 "bind.c"
	}
}

void
value_take_binding (GValue* value,
                    gpointer v_object)
{
	Binding * old;
#line 28 "src/bind.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_BINDING));
#line 28 "src/bind.vala"
	old = value->data[0].v_pointer;
#line 28 "src/bind.vala"
	if (v_object) {
#line 28 "src/bind.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_BINDING));
#line 28 "src/bind.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 28 "src/bind.vala"
		value->data[0].v_pointer = v_object;
#line 895 "bind.c"
	} else {
#line 28 "src/bind.vala"
		value->data[0].v_pointer = NULL;
#line 899 "bind.c"
	}
#line 28 "src/bind.vala"
	if (old) {
#line 28 "src/bind.vala"
		binding_unref (old);
#line 905 "bind.c"
	}
}

static void
binding_class_init (BindingClass * klass,
                    gpointer klass_data)
{
#line 28 "src/bind.vala"
	binding_parent_class = g_type_class_peek_parent (klass);
#line 28 "src/bind.vala"
	((BindingClass *) klass)->finalize = binding_finalize;
#line 917 "bind.c"
}

static void
binding_instance_init (Binding * self,
                       gpointer klass)
{
#line 28 "src/bind.vala"
	self->ref_count = 1;
#line 926 "bind.c"
}

static void
binding_finalize (Binding * obj)
{
	Binding * self;
#line 28 "src/bind.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_BINDING, Binding);
#line 28 "src/bind.vala"
	g_signal_handlers_destroy (self);
#line 29 "src/bind.vala"
	_lisp_func_unref0 (self->func);
#line 30 "src/bind.vala"
	_g_object_unref0 (self->map);
#line 941 "bind.c"
}

static GType
binding_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { value_binding_init, value_binding_free_value, value_binding_copy_value, value_binding_peek_pointer, "p", value_binding_collect_value, "p", value_binding_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (BindingClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) binding_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Binding), 0, (GInstanceInitFunc) binding_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType binding_type_id;
	binding_type_id = g_type_register_fundamental (g_type_fundamental_next (), "Binding", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return binding_type_id;
}

GType
binding_get_type (void)
{
	static volatile gsize binding_type_id__once = 0;
	if (g_once_init_enter (&binding_type_id__once)) {
		GType binding_type_id;
		binding_type_id = binding_get_type_once ();
		g_once_init_leave (&binding_type_id__once, binding_type_id);
	}
	return binding_type_id__once;
}

gpointer
binding_ref (gpointer instance)
{
	Binding * self;
	self = instance;
#line 28 "src/bind.vala"
	g_atomic_int_inc (&self->ref_count);
#line 28 "src/bind.vala"
	return instance;
#line 976 "bind.c"
}

void
binding_unref (gpointer instance)
{
	Binding * self;
	self = instance;
#line 28 "src/bind.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 28 "src/bind.vala"
		BINDING_GET_CLASS (self)->finalize (self);
#line 28 "src/bind.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 990 "bind.c"
	}
}

Keystroke
binding_completion (const gchar* a)
{
	gchar* b = NULL;
	gchar* _tmp0_;
	const gchar* _tmp6_ = NULL;
	const gchar* _tmp7_;
	Keystroke key = 0U;
	Keystroke result;
#line 75 "src/bind.vala"
	g_return_val_if_fail (a != NULL, 0U);
#line 76 "src/bind.vala"
	_tmp0_ = g_strdup ("");
#line 76 "src/bind.vala"
	b = _tmp0_;
#line 78 "src/bind.vala"
	if ((lastflag & FLAGS_SET_UNIARG) == FLAGS_SET_UNIARG) {
#line 1011 "bind.c"
		glong arg = 0L;
#line 79 "src/bind.vala"
		arg = (glong) abs (last_uniarg);
#line 1015 "bind.c"
		{
			gboolean _tmp1_ = FALSE;
#line 80 "src/bind.vala"
			_tmp1_ = TRUE;
#line 80 "src/bind.vala"
			while (TRUE) {
#line 1022 "bind.c"
				const gchar* _tmp2_;
				gchar* _tmp3_;
#line 80 "src/bind.vala"
				if (!_tmp1_) {
#line 83 "src/bind.vala"
					if (!(arg != ((glong) 0))) {
#line 83 "src/bind.vala"
						break;
#line 1031 "bind.c"
					}
				}
#line 80 "src/bind.vala"
				_tmp1_ = FALSE;
#line 81 "src/bind.vala"
				_tmp2_ = b;
#line 81 "src/bind.vala"
				_tmp3_ = g_strdup_printf ("%c %s", (gint) ((gchar) ((arg % 10) + '0')), _tmp2_);
#line 81 "src/bind.vala"
				_g_free0 (b);
#line 81 "src/bind.vala"
				b = _tmp3_;
#line 82 "src/bind.vala"
				arg /= (glong) 10;
#line 1046 "bind.c"
			}
		}
#line 85 "src/bind.vala"
		if (last_uniarg < 0) {
#line 1051 "bind.c"
			const gchar* _tmp4_;
			gchar* _tmp5_;
#line 86 "src/bind.vala"
			_tmp4_ = b;
#line 86 "src/bind.vala"
			_tmp5_ = g_strconcat ("- ", _tmp4_, NULL);
#line 86 "src/bind.vala"
			_g_free0 (b);
#line 86 "src/bind.vala"
			b = _tmp5_;
#line 1062 "bind.c"
		}
	}
#line 90 "src/bind.vala"
	if ((lastflag & (FLAGS_SET_UNIARG | FLAGS_UNIARG_EMPTY)) == (FLAGS_SET_UNIARG | FLAGS_UNIARG_EMPTY)) {
#line 90 "src/bind.vala"
		_tmp6_ = "C-u ";
#line 1069 "bind.c"
	} else {
#line 90 "src/bind.vala"
		_tmp6_ = "";
#line 1073 "bind.c"
	}
#line 89 "src/bind.vala"
	_tmp7_ = b;
#line 89 "src/bind.vala"
	minibuf_write ("%s%s%s-", _tmp6_, _tmp7_, a, NULL);
#line 92 "src/bind.vala"
	key = getkey (GETKEY_DEFAULT);
#line 93 "src/bind.vala"
	minibuf_clear ();
#line 95 "src/bind.vala"
	result = key;
#line 95 "src/bind.vala"
	_g_free0 (b);
#line 95 "src/bind.vala"
	return result;
#line 1089 "bind.c"
}

GeeList*
get_key_sequence (void)
{
	GeeArrayList* keys = NULL;
	GeeArrayList* _tmp0_;
	Keystroke key = 0U;
	GeeArrayList* _tmp2_;
	GeeList* result;
#line 101 "src/bind.vala"
	_tmp0_ = gee_array_list_new (G_TYPE_UINT, NULL, NULL, NULL, NULL, NULL);
#line 101 "src/bind.vala"
	keys = _tmp0_;
#line 102 "src/bind.vala"
	key = (Keystroke) 0;
#line 1106 "bind.c"
	{
		gboolean _tmp1_ = FALSE;
#line 104 "src/bind.vala"
		_tmp1_ = TRUE;
#line 104 "src/bind.vala"
		while (TRUE) {
#line 104 "src/bind.vala"
			if (!_tmp1_) {
#line 106 "src/bind.vala"
				if (!(key == KBD_NOKEY)) {
#line 106 "src/bind.vala"
					break;
#line 1119 "bind.c"
				}
			}
#line 104 "src/bind.vala"
			_tmp1_ = FALSE;
#line 105 "src/bind.vala"
			key = getkey (GETKEY_DEFAULT);
#line 1126 "bind.c"
		}
	}
#line 107 "src/bind.vala"
	_tmp2_ = keys;
#line 107 "src/bind.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp2_, (gpointer) ((guintptr) key));
#line 1133 "bind.c"
	{
		gboolean _tmp3_ = FALSE;
#line 108 "src/bind.vala"
		_tmp3_ = TRUE;
#line 108 "src/bind.vala"
		while (TRUE) {
#line 1140 "bind.c"
			Binding* p = NULL;
			Binding* _tmp4_;
			GeeArrayList* _tmp5_;
			Binding* _tmp6_;
			gboolean _tmp7_ = FALSE;
			Binding* _tmp8_;
			GeeArrayList* _tmp11_;
			GeeArrayList* _tmp12_;
			gchar* _tmp13_;
			gchar* _tmp14_;
#line 108 "src/bind.vala"
			if (!_tmp3_) {
#line 1153 "bind.c"
			}
#line 108 "src/bind.vala"
			_tmp3_ = FALSE;
#line 109 "src/bind.vala"
			_tmp4_ = root_bindings;
#line 109 "src/bind.vala"
			_tmp5_ = keys;
#line 109 "src/bind.vala"
			_tmp6_ = binding_find (_tmp4_, (GeeList*) _tmp5_);
#line 109 "src/bind.vala"
			p = _tmp6_;
#line 110 "src/bind.vala"
			_tmp8_ = p;
#line 110 "src/bind.vala"
			if (_tmp8_ == NULL) {
#line 110 "src/bind.vala"
				_tmp7_ = TRUE;
#line 1171 "bind.c"
			} else {
				Binding* _tmp9_;
				LispFunc* _tmp10_;
#line 110 "src/bind.vala"
				_tmp9_ = p;
#line 110 "src/bind.vala"
				_tmp10_ = _tmp9_->func;
#line 110 "src/bind.vala"
				_tmp7_ = _tmp10_ != NULL;
#line 1181 "bind.c"
			}
#line 110 "src/bind.vala"
			if (_tmp7_) {
#line 111 "src/bind.vala"
				_binding_unref0 (p);
#line 111 "src/bind.vala"
				break;
#line 1189 "bind.c"
			}
#line 112 "src/bind.vala"
			_tmp11_ = keys;
#line 112 "src/bind.vala"
			_tmp12_ = keys;
#line 112 "src/bind.vala"
			_tmp13_ = keyvectodesc ((GeeList*) _tmp12_);
#line 112 "src/bind.vala"
			_tmp14_ = _tmp13_;
#line 112 "src/bind.vala"
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp11_, (gpointer) ((guintptr) binding_completion (_tmp14_)));
#line 112 "src/bind.vala"
			_g_free0 (_tmp14_);
#line 108 "src/bind.vala"
			_binding_unref0 (p);
#line 1205 "bind.c"
		}
	}
#line 115 "src/bind.vala"
	result = (GeeList*) keys;
#line 115 "src/bind.vala"
	return result;
#line 1212 "bind.c"
}

LispFunc*
get_function_by_keys (GeeList* keys)
{
	gint _tmp0_;
	gint _tmp1_;
	Binding* p = NULL;
	Binding* _tmp6_;
	Binding* _tmp7_;
	LispFunc* _tmp8_ = NULL;
	Binding* _tmp9_;
	LispFunc* _tmp12_;
	LispFunc* result;
#line 118 "src/bind.vala"
	g_return_val_if_fail (keys != NULL, NULL);
#line 120 "src/bind.vala"
	_tmp0_ = gee_collection_get_size ((GeeCollection*) keys);
#line 120 "src/bind.vala"
	_tmp1_ = _tmp0_;
#line 120 "src/bind.vala"
	if (_tmp1_ == 1) {
#line 1235 "bind.c"
		Keystroke key = 0U;
		gpointer _tmp2_;
		gboolean _tmp3_ = FALSE;
#line 121 "src/bind.vala"
		_tmp2_ = gee_list_get (keys, 0);
#line 121 "src/bind.vala"
		key = (Keystroke) ((guintptr) _tmp2_);
#line 122 "src/bind.vala"
		if ((key & KBD_META) != ((Keystroke) 0)) {
#line 1245 "bind.c"
			gboolean _tmp4_ = FALSE;
#line 123 "src/bind.vala"
			if (g_ascii_isdigit ((gchar) (key & 0xff))) {
#line 123 "src/bind.vala"
				_tmp4_ = TRUE;
#line 1251 "bind.c"
			} else {
#line 123 "src/bind.vala"
				_tmp4_ = ((gchar) (key & 0xff)) == '-';
#line 1255 "bind.c"
			}
#line 123 "src/bind.vala"
			_tmp3_ = _tmp4_;
#line 1259 "bind.c"
		} else {
#line 122 "src/bind.vala"
			_tmp3_ = FALSE;
#line 1263 "bind.c"
		}
#line 122 "src/bind.vala"
		if (_tmp3_) {
#line 1267 "bind.c"
			LispFunc* _tmp5_;
#line 124 "src/bind.vala"
			_tmp5_ = lisp_func_find ("universal-argument");
#line 124 "src/bind.vala"
			result = _tmp5_;
#line 124 "src/bind.vala"
			return result;
#line 1275 "bind.c"
		}
	}
#line 128 "src/bind.vala"
	_tmp6_ = root_bindings;
#line 128 "src/bind.vala"
	_tmp7_ = binding_find (_tmp6_, keys);
#line 128 "src/bind.vala"
	p = _tmp7_;
#line 129 "src/bind.vala"
	_tmp9_ = p;
#line 129 "src/bind.vala"
	if (_tmp9_ != NULL) {
#line 1288 "bind.c"
		Binding* _tmp10_;
		LispFunc* _tmp11_;
#line 129 "src/bind.vala"
		_tmp10_ = p;
#line 129 "src/bind.vala"
		_tmp11_ = _tmp10_->func;
#line 129 "src/bind.vala"
		_tmp8_ = _tmp11_;
#line 1297 "bind.c"
	} else {
#line 129 "src/bind.vala"
		_tmp8_ = NULL;
#line 1301 "bind.c"
	}
#line 129 "src/bind.vala"
	_tmp12_ = _lisp_func_ref0 (_tmp8_);
#line 129 "src/bind.vala"
	result = _tmp12_;
#line 129 "src/bind.vala"
	_binding_unref0 (p);
#line 129 "src/bind.vala"
	return result;
#line 1311 "bind.c"
}

gboolean
self_insert_command (void)
{
	gboolean ret = FALSE;
	gint key = 0;
	Buffer* _tmp0_;
	gboolean result;
#line 133 "src/bind.vala"
	ret = TRUE;
#line 135 "src/bind.vala"
	key = (gint) (lastkey () & (~KBD_CTRL));
#line 136 "src/bind.vala"
	_tmp0_ = cur_bp;
#line 136 "src/bind.vala"
	_tmp0_->mark_active = FALSE;
#line 137 "src/bind.vala"
	if (key <= 0xff) {
#line 1331 "bind.c"
		gboolean _tmp1_ = FALSE;
		Buffer* _tmp5_;
#line 138 "src/bind.vala"
		if (g_ascii_isspace ((gchar) key)) {
#line 1336 "bind.c"
			Buffer* _tmp2_;
#line 138 "src/bind.vala"
			_tmp2_ = cur_bp;
#line 138 "src/bind.vala"
			_tmp1_ = _tmp2_->autofill;
#line 1342 "bind.c"
		} else {
#line 138 "src/bind.vala"
			_tmp1_ = FALSE;
#line 1346 "bind.c"
		}
#line 138 "src/bind.vala"
		if (_tmp1_) {
#line 1350 "bind.c"
			gboolean* _tmp3_;
			gboolean* _tmp4_;
#line 139 "src/bind.vala"
			_tmp3_ = fill_break_line ();
#line 139 "src/bind.vala"
			_tmp4_ = _tmp3_;
#line 139 "src/bind.vala"
			ret = _tmp4_ != NULL;
#line 139 "src/bind.vala"
			_g_free0 (_tmp4_);
#line 1361 "bind.c"
		}
#line 140 "src/bind.vala"
		_tmp5_ = cur_bp;
#line 140 "src/bind.vala"
		buffer_insert_char (_tmp5_, (gchar) key);
#line 1367 "bind.c"
	} else {
#line 142 "src/bind.vala"
		ding ();
#line 143 "src/bind.vala"
		ret = FALSE;
#line 1373 "bind.c"
	}
#line 146 "src/bind.vala"
	result = ret;
#line 146 "src/bind.vala"
	return result;
#line 1379 "bind.c"
}

LispFunc*
last_command (void)
{
	LispFunc* _tmp0_;
	LispFunc* _tmp1_;
	LispFunc* result;
#line 153 "src/bind.vala"
	_tmp0_ = _last_command;
#line 153 "src/bind.vala"
	_tmp1_ = _lisp_func_ref0 (_tmp0_);
#line 153 "src/bind.vala"
	result = _tmp1_;
#line 153 "src/bind.vala"
	return result;
#line 1396 "bind.c"
}

void
set_this_command (LispFunc* cmd)
{
	LispFunc* _tmp0_;
#line 156 "src/bind.vala"
	g_return_if_fail (cmd != NULL);
#line 157 "src/bind.vala"
	_tmp0_ = _lisp_func_ref0 (cmd);
#line 157 "src/bind.vala"
	_lisp_func_unref0 (_this_command);
#line 157 "src/bind.vala"
	_this_command = _tmp0_;
#line 1411 "bind.c"
}

gboolean
call_command (LispFunc* f,
              glong uniarg,
              GeeQueue* args)
{
	LispFunc* _tmp0_;
	gboolean ok = FALSE;
	Function _tmp1_;
	LispFunc* _tmp2_;
	LispFunc* _tmp3_;
	gboolean result;
#line 160 "src/bind.vala"
	g_return_val_if_fail (f != NULL, FALSE);
#line 161 "src/bind.vala"
	thisflag = lastflag & FLAGS_DEFINING_MACRO;
#line 162 "src/bind.vala"
	undo_start_sequence ();
#line 166 "src/bind.vala"
	if (!((thisflag & FLAGS_SET_UNIARG) == FLAGS_SET_UNIARG)) {
#line 167 "src/bind.vala"
		last_uniarg = 1;
#line 1435 "bind.c"
	}
#line 170 "src/bind.vala"
	_tmp0_ = _lisp_func_ref0 (f);
#line 170 "src/bind.vala"
	_lisp_func_unref0 (_this_command);
#line 170 "src/bind.vala"
	_this_command = _tmp0_;
#line 171 "src/bind.vala"
	_tmp1_ = f->func;
#line 171 "src/bind.vala"
	ok = _tmp1_ (uniarg, args);
#line 172 "src/bind.vala"
	_tmp2_ = _this_command;
#line 172 "src/bind.vala"
	_tmp3_ = _lisp_func_ref0 (_tmp2_);
#line 172 "src/bind.vala"
	_lisp_func_unref0 (_last_command);
#line 172 "src/bind.vala"
	_last_command = _tmp3_;
#line 176 "src/bind.vala"
	if (((lastflag & thisflag) & FLAGS_DEFINING_MACRO) == FLAGS_DEFINING_MACRO) {
#line 177 "src/bind.vala"
		add_cmd_to_macro ();
#line 1459 "bind.c"
	}
#line 179 "src/bind.vala"
	undo_end_sequence ();
#line 180 "src/bind.vala"
	lastflag = thisflag;
#line 182 "src/bind.vala"
	result = ok;
#line 182 "src/bind.vala"
	return result;
#line 1469 "bind.c"
}

void
get_and_run_command (void)
{
	GeeList* keys = NULL;
	GeeList* _tmp0_;
	LispFunc* f = NULL;
	GeeList* _tmp1_;
	LispFunc* _tmp2_;
	LispFunc* _tmp3_;
#line 186 "src/bind.vala"
	_tmp0_ = get_key_sequence ();
#line 186 "src/bind.vala"
	keys = _tmp0_;
#line 187 "src/bind.vala"
	_tmp1_ = keys;
#line 187 "src/bind.vala"
	_tmp2_ = get_function_by_keys (_tmp1_);
#line 187 "src/bind.vala"
	f = _tmp2_;
#line 189 "src/bind.vala"
	minibuf_clear ();
#line 190 "src/bind.vala"
	_tmp3_ = f;
#line 190 "src/bind.vala"
	if (_tmp3_ != NULL) {
#line 1497 "bind.c"
		GeeArrayQueue* _tmp4_ = NULL;
		LispFunc* _tmp6_;
#line 191 "src/bind.vala"
		if ((lastflag & FLAGS_SET_UNIARG) == FLAGS_SET_UNIARG) {
#line 191 "src/bind.vala"
			_g_object_unref0 (_tmp4_);
#line 191 "src/bind.vala"
			_tmp4_ = NULL;
#line 1506 "bind.c"
		} else {
			GeeArrayQueue* _tmp5_;
#line 191 "src/bind.vala"
			_tmp5_ = gee_array_queue_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
#line 191 "src/bind.vala"
			_g_object_unref0 (_tmp4_);
#line 191 "src/bind.vala"
			_tmp4_ = _tmp5_;
#line 1515 "bind.c"
		}
#line 191 "src/bind.vala"
		_tmp6_ = f;
#line 191 "src/bind.vala"
		call_command (_tmp6_, (glong) last_uniarg, (GeeQueue*) _tmp4_);
#line 190 "src/bind.vala"
		_g_object_unref0 (_tmp4_);
#line 1523 "bind.c"
	} else {
		GeeList* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
#line 193 "src/bind.vala"
		_tmp7_ = keys;
#line 193 "src/bind.vala"
		_tmp8_ = keyvectodesc (_tmp7_);
#line 193 "src/bind.vala"
		_tmp9_ = _tmp8_;
#line 193 "src/bind.vala"
		minibuf_error ("%s is undefined", _tmp9_, NULL);
#line 193 "src/bind.vala"
		_g_free0 (_tmp9_);
#line 1538 "bind.c"
	}
#line 185 "src/bind.vala"
	_lisp_func_unref0 (f);
#line 185 "src/bind.vala"
	_g_object_unref0 (keys);
#line 1544 "bind.c"
}

void
init_default_bindings (void)
{
	Binding* _tmp0_;
	const gchar* _tmp9_;
#line 197 "src/bind.vala"
	_tmp0_ = binding_new ();
#line 197 "src/bind.vala"
	_binding_unref0 (root_bindings);
#line 197 "src/bind.vala"
	root_bindings = _tmp0_;
#line 1558 "bind.c"
	{
		guint i = 0U;
#line 200 "src/bind.vala"
		i = (guint) 0;
#line 1563 "bind.c"
		{
			gboolean _tmp1_ = FALSE;
#line 200 "src/bind.vala"
			_tmp1_ = TRUE;
#line 200 "src/bind.vala"
			while (TRUE) {
#line 200 "src/bind.vala"
				if (!_tmp1_) {
#line 1572 "bind.c"
					guint _tmp2_;
#line 200 "src/bind.vala"
					_tmp2_ = i;
#line 200 "src/bind.vala"
					i = _tmp2_ + 1;
#line 1578 "bind.c"
				}
#line 200 "src/bind.vala"
				_tmp1_ = FALSE;
#line 200 "src/bind.vala"
				if (!(i <= ((guint) 0xff))) {
#line 200 "src/bind.vala"
					break;
#line 1586 "bind.c"
				}
#line 201 "src/bind.vala"
				if (g_ascii_isprint ((gchar) i)) {
#line 1590 "bind.c"
					GeeArrayList* keys = NULL;
					GeeArrayList* _tmp3_;
					GeeArrayList* _tmp4_;
					Binding* _tmp5_;
					GeeArrayList* _tmp6_;
					LispFunc* _tmp7_;
					LispFunc* _tmp8_;
#line 202 "src/bind.vala"
					_tmp3_ = gee_array_list_new (G_TYPE_UINT, NULL, NULL, NULL, NULL, NULL);
#line 202 "src/bind.vala"
					keys = _tmp3_;
#line 203 "src/bind.vala"
					_tmp4_ = keys;
#line 203 "src/bind.vala"
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp4_, (gpointer) ((guintptr) i));
#line 204 "src/bind.vala"
					_tmp5_ = root_bindings;
#line 204 "src/bind.vala"
					_tmp6_ = keys;
#line 204 "src/bind.vala"
					_tmp7_ = lisp_func_find ("self-insert-command");
#line 204 "src/bind.vala"
					_tmp8_ = _tmp7_;
#line 204 "src/bind.vala"
					binding_bind (_tmp5_, (GeeList*) _tmp6_, _tmp8_);
#line 204 "src/bind.vala"
					_lisp_func_unref0 (_tmp8_);
#line 201 "src/bind.vala"
					_g_object_unref0 (keys);
#line 1620 "bind.c"
				}
			}
		}
	}
#line 208 "src/bind.vala"
	_tmp9_ = default_bindings;
#line 208 "src/bind.vala"
	lisp_loadstring (_tmp9_);
#line 1629 "bind.c"
}

static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
#line 213 "src/bind.vala"
	g_atomic_int_inc (&_data1_->_ref_count_);
#line 213 "src/bind.vala"
	return _data1_;
#line 1639 "bind.c"
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
#line 213 "src/bind.vala"
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
#line 213 "src/bind.vala"
		(_data1_->walker_target_destroy_notify == NULL) ? NULL : (_data1_->walker_target_destroy_notify (_data1_->walker_target), NULL);
#line 213 "src/bind.vala"
		_data1_->walker = NULL;
#line 213 "src/bind.vala"
		_data1_->walker_target = NULL;
#line 213 "src/bind.vala"
		_data1_->walker_target_destroy_notify = NULL;
#line 213 "src/bind.vala"
		g_slice_free (Block1Data, _data1_);
#line 1659 "bind.c"
	}
}

static gchar**
_vala_array_dup1 (gchar** self,
                  gssize length)
{
#line 221 "src/bind.vala"
	if (length >= 0) {
#line 1669 "bind.c"
		gchar** result;
		gssize i;
#line 221 "src/bind.vala"
		result = g_new0 (gchar*, length + 1);
#line 221 "src/bind.vala"
		for (i = 0; i < length; i++) {
#line 1676 "bind.c"
			gchar* _tmp0_;
#line 221 "src/bind.vala"
			_tmp0_ = g_strdup (self[i]);
#line 221 "src/bind.vala"
			result[i] = _tmp0_;
#line 1682 "bind.c"
		}
#line 221 "src/bind.vala"
		return result;
#line 1686 "bind.c"
	}
#line 221 "src/bind.vala"
	return NULL;
#line 1690 "bind.c"
}

static void
_vala_array_add1 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
#line 222 "src/bind.vala"
	if ((*length) == (*size)) {
#line 222 "src/bind.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 222 "src/bind.vala"
		*array = g_renew (gchar*, *array, (*size) + 1);
#line 1705 "bind.c"
	}
#line 222 "src/bind.vala"
	(*array)[(*length)++] = value;
#line 222 "src/bind.vala"
	(*array)[*length] = NULL;
#line 1711 "bind.c"
}

static gchar*
_vala_g_strjoinv (const gchar* separator,
                  gchar** str_array,
                  gint str_array_length1)
{
	gboolean _tmp0_ = FALSE;
	gchar* result;
#line 1251 "glib-2.0.vapi"
	if (separator == NULL) {
#line 1252 "glib-2.0.vapi"
		separator = "";
#line 1725 "bind.c"
	}
#line 1254 "glib-2.0.vapi"
	if (str_array != NULL) {
#line 1729 "bind.c"
		gboolean _tmp1_ = FALSE;
#line 1254 "glib-2.0.vapi"
		if (str_array_length1 > 0) {
#line 1254 "glib-2.0.vapi"
			_tmp1_ = TRUE;
#line 1735 "bind.c"
		} else {
			gboolean _tmp2_ = FALSE;
#line 1254 "glib-2.0.vapi"
			if (str_array_length1 == -1) {
#line 1740 "bind.c"
				const gchar* _tmp3_;
#line 1254 "glib-2.0.vapi"
				_tmp3_ = str_array[0];
#line 1254 "glib-2.0.vapi"
				_tmp2_ = _tmp3_ != NULL;
#line 1746 "bind.c"
			} else {
#line 1254 "glib-2.0.vapi"
				_tmp2_ = FALSE;
#line 1750 "bind.c"
			}
#line 1254 "glib-2.0.vapi"
			_tmp1_ = _tmp2_;
#line 1754 "bind.c"
		}
#line 1254 "glib-2.0.vapi"
		_tmp0_ = _tmp1_;
#line 1758 "bind.c"
	} else {
#line 1254 "glib-2.0.vapi"
		_tmp0_ = FALSE;
#line 1762 "bind.c"
	}
#line 1254 "glib-2.0.vapi"
	if (_tmp0_) {
#line 1766 "bind.c"
		gint i = 0;
		gsize len = 0UL;
		gint _tmp16_;
		gint _tmp17_;
		const gchar* res = NULL;
		void* _tmp18_;
		const gchar* _tmp19_ = NULL;
		const gchar* _tmp20_;
		void* ptr = NULL;
		const gchar* _tmp22_;
		void* _tmp23_;
		const gchar* _tmp33_;
#line 1256 "glib-2.0.vapi"
		len = (gsize) 1;
#line 1781 "bind.c"
		{
			gboolean _tmp4_ = FALSE;
#line 1257 "glib-2.0.vapi"
			i = 0;
#line 1257 "glib-2.0.vapi"
			_tmp4_ = TRUE;
#line 1257 "glib-2.0.vapi"
			while (TRUE) {
#line 1790 "bind.c"
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_ = FALSE;
				gint _tmp10_ = 0;
				const gchar* _tmp11_;
#line 1257 "glib-2.0.vapi"
				if (!_tmp4_) {
#line 1797 "bind.c"
					gint _tmp5_;
#line 1257 "glib-2.0.vapi"
					_tmp5_ = i;
#line 1257 "glib-2.0.vapi"
					i = _tmp5_ + 1;
#line 1803 "bind.c"
				}
#line 1257 "glib-2.0.vapi"
				_tmp4_ = FALSE;
#line 1257 "glib-2.0.vapi"
				if (str_array_length1 != -1) {
#line 1257 "glib-2.0.vapi"
					_tmp7_ = i < str_array_length1;
#line 1811 "bind.c"
				} else {
#line 1257 "glib-2.0.vapi"
					_tmp7_ = FALSE;
#line 1815 "bind.c"
				}
#line 1257 "glib-2.0.vapi"
				if (_tmp7_) {
#line 1257 "glib-2.0.vapi"
					_tmp6_ = TRUE;
#line 1821 "bind.c"
				} else {
					gboolean _tmp8_ = FALSE;
#line 1257 "glib-2.0.vapi"
					if (str_array_length1 == -1) {
#line 1826 "bind.c"
						const gchar* _tmp9_;
#line 1257 "glib-2.0.vapi"
						_tmp9_ = str_array[i];
#line 1257 "glib-2.0.vapi"
						_tmp8_ = _tmp9_ != NULL;
#line 1832 "bind.c"
					} else {
#line 1257 "glib-2.0.vapi"
						_tmp8_ = FALSE;
#line 1836 "bind.c"
					}
#line 1257 "glib-2.0.vapi"
					_tmp6_ = _tmp8_;
#line 1840 "bind.c"
				}
#line 1257 "glib-2.0.vapi"
				if (!_tmp6_) {
#line 1257 "glib-2.0.vapi"
					break;
#line 1846 "bind.c"
				}
#line 1258 "glib-2.0.vapi"
				_tmp11_ = str_array[i];
#line 1258 "glib-2.0.vapi"
				if (_tmp11_ != NULL) {
#line 1852 "bind.c"
					const gchar* _tmp12_;
					gint _tmp13_;
					gint _tmp14_;
#line 1258 "glib-2.0.vapi"
					_tmp12_ = str_array[i];
#line 1258 "glib-2.0.vapi"
					_tmp13_ = strlen ((const gchar*) _tmp12_);
#line 1258 "glib-2.0.vapi"
					_tmp14_ = _tmp13_;
#line 1258 "glib-2.0.vapi"
					_tmp10_ = _tmp14_;
#line 1864 "bind.c"
				} else {
#line 1258 "glib-2.0.vapi"
					_tmp10_ = 0;
#line 1868 "bind.c"
				}
#line 1258 "glib-2.0.vapi"
				len += (gsize) _tmp10_;
#line 1872 "bind.c"
			}
		}
#line 1260 "glib-2.0.vapi"
		if (i == 0) {
#line 1877 "bind.c"
			gchar* _tmp15_;
#line 1261 "glib-2.0.vapi"
			_tmp15_ = g_strdup ("");
#line 1261 "glib-2.0.vapi"
			result = _tmp15_;
#line 1261 "glib-2.0.vapi"
			return result;
#line 1885 "bind.c"
		}
#line 1263 "glib-2.0.vapi"
		str_array_length1 = i;
#line 1264 "glib-2.0.vapi"
		_tmp16_ = strlen ((const gchar*) separator);
#line 1264 "glib-2.0.vapi"
		_tmp17_ = _tmp16_;
#line 1264 "glib-2.0.vapi"
		len += (gsize) (_tmp17_ * (i - 1));
#line 1266 "glib-2.0.vapi"
		_tmp18_ = g_malloc (len);
#line 1266 "glib-2.0.vapi"
		res = _tmp18_;
#line 1267 "glib-2.0.vapi"
		_tmp20_ = str_array[0];
#line 1267 "glib-2.0.vapi"
		if (_tmp20_ != NULL) {
#line 1903 "bind.c"
			const gchar* _tmp21_;
#line 1267 "glib-2.0.vapi"
			_tmp21_ = str_array[0];
#line 1267 "glib-2.0.vapi"
			_tmp19_ = (const gchar*) _tmp21_;
#line 1909 "bind.c"
		} else {
#line 1267 "glib-2.0.vapi"
			_tmp19_ = "";
#line 1913 "bind.c"
		}
#line 1267 "glib-2.0.vapi"
		_tmp22_ = res;
#line 1267 "glib-2.0.vapi"
		_tmp23_ = g_stpcpy ((void*) _tmp22_, _tmp19_);
#line 1267 "glib-2.0.vapi"
		ptr = _tmp23_;
#line 1921 "bind.c"
		{
			gboolean _tmp24_ = FALSE;
#line 1268 "glib-2.0.vapi"
			i = 1;
#line 1268 "glib-2.0.vapi"
			_tmp24_ = TRUE;
#line 1268 "glib-2.0.vapi"
			while (TRUE) {
#line 1930 "bind.c"
				void* _tmp26_;
				void* _tmp27_;
				const gchar* _tmp28_ = NULL;
				const gchar* _tmp29_;
				void* _tmp31_;
				void* _tmp32_;
#line 1268 "glib-2.0.vapi"
				if (!_tmp24_) {
#line 1939 "bind.c"
					gint _tmp25_;
#line 1268 "glib-2.0.vapi"
					_tmp25_ = i;
#line 1268 "glib-2.0.vapi"
					i = _tmp25_ + 1;
#line 1945 "bind.c"
				}
#line 1268 "glib-2.0.vapi"
				_tmp24_ = FALSE;
#line 1268 "glib-2.0.vapi"
				if (!(i < str_array_length1)) {
#line 1268 "glib-2.0.vapi"
					break;
#line 1953 "bind.c"
				}
#line 1269 "glib-2.0.vapi"
				_tmp26_ = ptr;
#line 1269 "glib-2.0.vapi"
				_tmp27_ = g_stpcpy (_tmp26_, (const gchar*) separator);
#line 1269 "glib-2.0.vapi"
				ptr = _tmp27_;
#line 1270 "glib-2.0.vapi"
				_tmp29_ = str_array[i];
#line 1270 "glib-2.0.vapi"
				if (_tmp29_ != NULL) {
#line 1965 "bind.c"
					const gchar* _tmp30_;
#line 1270 "glib-2.0.vapi"
					_tmp30_ = str_array[i];
#line 1270 "glib-2.0.vapi"
					_tmp28_ = (const gchar*) _tmp30_;
#line 1971 "bind.c"
				} else {
#line 1270 "glib-2.0.vapi"
					_tmp28_ = "";
#line 1975 "bind.c"
				}
#line 1270 "glib-2.0.vapi"
				_tmp31_ = ptr;
#line 1270 "glib-2.0.vapi"
				_tmp32_ = g_stpcpy (_tmp31_, _tmp28_);
#line 1270 "glib-2.0.vapi"
				ptr = _tmp32_;
#line 1983 "bind.c"
			}
		}
#line 1273 "glib-2.0.vapi"
		_tmp33_ = res;
#line 1273 "glib-2.0.vapi"
		res = NULL;
#line 1273 "glib-2.0.vapi"
		result = (gchar*) _tmp33_;
#line 1273 "glib-2.0.vapi"
		return result;
#line 1994 "bind.c"
	} else {
		gchar* _tmp34_;
#line 1275 "glib-2.0.vapi"
		_tmp34_ = g_strdup ("");
#line 1275 "glib-2.0.vapi"
		result = _tmp34_;
#line 1275 "glib-2.0.vapi"
		return result;
#line 2003 "bind.c"
	}
}

static void
__lambda23_ (Block1Data* _data1_,
             Binding* tree,
             gchar** keys,
             gint keys_length1)
{
	GeeMap* _tmp0_;
#line 215 "src/bind.vala"
	g_return_if_fail (tree != NULL);
#line 216 "src/bind.vala"
	_tmp0_ = tree->map;
#line 216 "src/bind.vala"
	_vala_assert (_tmp0_ != NULL, "tree.map != null");
#line 2020 "bind.c"
	{
		GeeIterator* _key_it = NULL;
		GeeMap* _tmp1_;
		GeeSet* _tmp2_;
		GeeSet* _tmp3_;
		GeeSet* _tmp4_;
		GeeIterator* _tmp5_;
		GeeIterator* _tmp6_;
#line 217 "src/bind.vala"
		_tmp1_ = tree->map;
#line 217 "src/bind.vala"
		_tmp2_ = gee_map_get_keys (_tmp1_);
#line 217 "src/bind.vala"
		_tmp3_ = _tmp2_;
#line 217 "src/bind.vala"
		_tmp4_ = _tmp3_;
#line 217 "src/bind.vala"
		_tmp5_ = gee_iterable_iterator ((GeeIterable*) _tmp4_);
#line 217 "src/bind.vala"
		_tmp6_ = _tmp5_;
#line 217 "src/bind.vala"
		_g_object_unref0 (_tmp4_);
#line 217 "src/bind.vala"
		_key_it = _tmp6_;
#line 217 "src/bind.vala"
		while (TRUE) {
#line 2047 "bind.c"
			GeeIterator* _tmp7_;
			Keystroke key = 0U;
			GeeIterator* _tmp8_;
			gpointer _tmp9_;
			Binding* p = NULL;
			GeeMap* _tmp10_;
			gpointer _tmp11_;
			Binding* _tmp12_;
			gchar** keys_ = NULL;
			gchar** _tmp13_;
			gint _tmp13__length1;
			gint keys__length1;
			gint _keys__size_;
			gchar* _tmp14_;
			Binding* _tmp15_;
			LispFunc* _tmp16_;
#line 217 "src/bind.vala"
			_tmp7_ = _key_it;
#line 217 "src/bind.vala"
			if (!gee_iterator_next (_tmp7_)) {
#line 217 "src/bind.vala"
				break;
#line 2070 "bind.c"
			}
#line 217 "src/bind.vala"
			_tmp8_ = _key_it;
#line 217 "src/bind.vala"
			_tmp9_ = gee_iterator_get (_tmp8_);
#line 217 "src/bind.vala"
			key = (Keystroke) ((guintptr) _tmp9_);
#line 218 "src/bind.vala"
			_tmp10_ = tree->map;
#line 218 "src/bind.vala"
			_tmp11_ = gee_map_get (_tmp10_, (gpointer) ((guintptr) key));
#line 218 "src/bind.vala"
			p = (Binding*) _tmp11_;
#line 219 "src/bind.vala"
			_tmp12_ = p;
#line 219 "src/bind.vala"
			_vala_assert (_tmp12_ != NULL, "p != null");
#line 221 "src/bind.vala"
			_tmp13_ = (keys != NULL) ? _vala_array_dup1 (keys, keys_length1) : keys;
#line 221 "src/bind.vala"
			_tmp13__length1 = keys_length1;
#line 221 "src/bind.vala"
			keys_ = _tmp13_;
#line 221 "src/bind.vala"
			keys__length1 = _tmp13__length1;
#line 221 "src/bind.vala"
			_keys__size_ = keys__length1;
#line 222 "src/bind.vala"
			_tmp14_ = chordtodesc (key);
#line 222 "src/bind.vala"
			_vala_array_add1 (&keys_, &keys__length1, &_keys__size_, _tmp14_);
#line 223 "src/bind.vala"
			_tmp15_ = p;
#line 223 "src/bind.vala"
			_tmp16_ = _tmp15_->func;
#line 223 "src/bind.vala"
			if (_tmp16_ != NULL) {
#line 2108 "bind.c"
				gchar** _tmp17_;
				gint _tmp17__length1;
				gchar* _tmp18_;
				gchar* _tmp19_;
				Binding* _tmp20_;
#line 224 "src/bind.vala"
				_tmp17_ = keys_;
#line 224 "src/bind.vala"
				_tmp17__length1 = keys__length1;
#line 224 "src/bind.vala"
				_tmp18_ = _vala_g_strjoinv (" ", _tmp17_, (gint) _tmp17__length1);
#line 224 "src/bind.vala"
				_tmp19_ = _tmp18_;
#line 224 "src/bind.vala"
				_tmp20_ = p;
#line 224 "src/bind.vala"
				_data1_->process (_tmp19_, _tmp20_, _data1_->process_target);
#line 224 "src/bind.vala"
				_g_free0 (_tmp19_);
#line 2128 "bind.c"
			} else {
				BindingsWalker _tmp21_;
				gpointer _tmp21__target;
				Binding* _tmp22_;
				gchar** _tmp23_;
				gint _tmp23__length1;
#line 226 "src/bind.vala"
				_tmp21_ = _data1_->walker;
#line 226 "src/bind.vala"
				_tmp21__target = _data1_->walker_target;
#line 226 "src/bind.vala"
				_tmp22_ = p;
#line 226 "src/bind.vala"
				_tmp23_ = keys_;
#line 226 "src/bind.vala"
				_tmp23__length1 = keys__length1;
#line 226 "src/bind.vala"
				_tmp21_ (_tmp22_, _tmp23_, (gint) _tmp23__length1, _tmp21__target);
#line 2147 "bind.c"
			}
#line 217 "src/bind.vala"
			keys_ = (_vala_array_free (keys_, keys__length1, (GDestroyNotify) g_free), NULL);
#line 217 "src/bind.vala"
			_binding_unref0 (p);
#line 2153 "bind.c"
		}
#line 217 "src/bind.vala"
		_g_object_unref0 (_key_it);
#line 2157 "bind.c"
	}
}

static void
___lambda23__bindings_walker (Binding* tree,
                              gchar** keys,
                              gint keys_length1,
                              gpointer self)
{
#line 215 "src/bind.vala"
	__lambda23_ (self, tree, keys, keys_length1);
#line 2169 "bind.c"
}

void
walk_bindings (BindingsProcessor process,
               gpointer process_target)
{
	Block1Data* _data1_;
	BindingsWalker _tmp0_;
	gpointer _tmp0__target;
	Binding* _tmp1_;
	gchar** _tmp2_;
	gchar** _tmp3_;
	gint _tmp3__length1;
#line 213 "src/bind.vala"
	_data1_ = g_slice_new0 (Block1Data);
#line 213 "src/bind.vala"
	_data1_->_ref_count_ = 1;
#line 213 "src/bind.vala"
	_data1_->process = process;
#line 213 "src/bind.vala"
	_data1_->process_target = process_target;
#line 214 "src/bind.vala"
	_data1_->walker = NULL;
#line 214 "src/bind.vala"
	_data1_->walker_target = NULL;
#line 214 "src/bind.vala"
	_data1_->walker_target_destroy_notify = NULL;
#line 215 "src/bind.vala"
	(_data1_->walker_target_destroy_notify == NULL) ? NULL : (_data1_->walker_target_destroy_notify (_data1_->walker_target), NULL);
#line 215 "src/bind.vala"
	_data1_->walker = NULL;
#line 215 "src/bind.vala"
	_data1_->walker_target = NULL;
#line 215 "src/bind.vala"
	_data1_->walker_target_destroy_notify = NULL;
#line 215 "src/bind.vala"
	_data1_->walker = ___lambda23__bindings_walker;
#line 215 "src/bind.vala"
	_data1_->walker_target = block1_data_ref (_data1_);
#line 215 "src/bind.vala"
	_data1_->walker_target_destroy_notify = block1_data_unref;
#line 230 "src/bind.vala"
	_tmp0_ = _data1_->walker;
#line 230 "src/bind.vala"
	_tmp0__target = _data1_->walker_target;
#line 230 "src/bind.vala"
	_tmp1_ = root_bindings;
#line 230 "src/bind.vala"
	_tmp2_ = g_new0 (gchar*, 0 + 1);
#line 230 "src/bind.vala"
	_tmp3_ = _tmp2_;
#line 230 "src/bind.vala"
	_tmp3__length1 = 0;
#line 230 "src/bind.vala"
	_tmp0_ (_tmp1_, _tmp3_, (gint) 0, _tmp0__target);
#line 230 "src/bind.vala"
	_tmp3_ = (_vala_array_free (_tmp3_, _tmp3__length1, (GDestroyNotify) g_free), NULL);
#line 213 "src/bind.vala"
	block1_data_unref (_data1_);
#line 213 "src/bind.vala"
	_data1_ = NULL;
#line 2231 "bind.c"
}

static gboolean
__lambda24_ (glong uniarg,
             GeeQueue* args)
{
	GeeList* keys = NULL;
	gchar* keystr = NULL;
	gpointer _tmp0_;
	const gchar* _tmp1_;
	gchar* name = NULL;
	gpointer _tmp9_;
	const gchar* _tmp10_;
	const gchar* _tmp13_;
	LispFunc* func = NULL;
	const gchar* _tmp14_;
	LispFunc* _tmp15_;
	LispFunc* _tmp16_;
	Binding* _tmp18_;
	GeeList* _tmp19_;
	LispFunc* _tmp20_;
	gboolean result;
#line 239 "src/bind.vala"
	_tmp0_ = gee_queue_poll (args);
#line 239 "src/bind.vala"
	keystr = (gchar*) _tmp0_;
#line 240 "src/bind.vala"
	_tmp1_ = keystr;
#line 240 "src/bind.vala"
	if (_tmp1_ != NULL) {
#line 2262 "bind.c"
		const gchar* _tmp2_;
		GeeList* _tmp3_;
		GeeList* _tmp4_;
#line 241 "src/bind.vala"
		_tmp2_ = keystr;
#line 241 "src/bind.vala"
		_tmp3_ = keystrtovec (_tmp2_);
#line 241 "src/bind.vala"
		_g_object_unref0 (keys);
#line 241 "src/bind.vala"
		keys = _tmp3_;
#line 242 "src/bind.vala"
		_tmp4_ = keys;
#line 242 "src/bind.vala"
		if (_tmp4_ == NULL) {
#line 2278 "bind.c"
			const gchar* _tmp5_;
#line 243 "src/bind.vala"
			_tmp5_ = keystr;
#line 243 "src/bind.vala"
			minibuf_error ("Key sequence %s is invalid", _tmp5_, NULL);
#line 244 "src/bind.vala"
			result = FALSE;
#line 244 "src/bind.vala"
			_g_free0 (keystr);
#line 244 "src/bind.vala"
			_g_object_unref0 (keys);
#line 244 "src/bind.vala"
			return result;
#line 2292 "bind.c"
		}
	} else {
		GeeList* _tmp6_;
		GeeList* _tmp7_;
		gchar* _tmp8_;
#line 247 "src/bind.vala"
		minibuf_write ("Set key globally: ", NULL);
#line 248 "src/bind.vala"
		_tmp6_ = get_key_sequence ();
#line 248 "src/bind.vala"
		_g_object_unref0 (keys);
#line 248 "src/bind.vala"
		keys = _tmp6_;
#line 249 "src/bind.vala"
		_tmp7_ = keys;
#line 249 "src/bind.vala"
		_tmp8_ = keyvectodesc (_tmp7_);
#line 249 "src/bind.vala"
		_g_free0 (keystr);
#line 249 "src/bind.vala"
		keystr = _tmp8_;
#line 2314 "bind.c"
	}
#line 252 "src/bind.vala"
	_tmp9_ = gee_queue_poll (args);
#line 252 "src/bind.vala"
	name = (gchar*) _tmp9_;
#line 253 "src/bind.vala"
	_tmp10_ = name;
#line 253 "src/bind.vala"
	if (_tmp10_ == NULL) {
#line 2324 "bind.c"
		const gchar* _tmp11_;
		gchar* _tmp12_;
#line 254 "src/bind.vala"
		_tmp11_ = keystr;
#line 254 "src/bind.vala"
		_tmp12_ = minibuf_read_function_name ("Set key %s to command: ", _tmp11_, NULL);
#line 254 "src/bind.vala"
		_g_free0 (name);
#line 254 "src/bind.vala"
		name = _tmp12_;
#line 2335 "bind.c"
	}
#line 255 "src/bind.vala"
	_tmp13_ = name;
#line 255 "src/bind.vala"
	if (_tmp13_ == NULL) {
#line 256 "src/bind.vala"
		result = FALSE;
#line 256 "src/bind.vala"
		_g_free0 (name);
#line 256 "src/bind.vala"
		_g_free0 (keystr);
#line 256 "src/bind.vala"
		_g_object_unref0 (keys);
#line 256 "src/bind.vala"
		return result;
#line 2351 "bind.c"
	}
#line 258 "src/bind.vala"
	_tmp14_ = name;
#line 258 "src/bind.vala"
	_tmp15_ = lisp_func_find (_tmp14_);
#line 258 "src/bind.vala"
	func = _tmp15_;
#line 259 "src/bind.vala"
	_tmp16_ = func;
#line 259 "src/bind.vala"
	if (_tmp16_ == NULL) {
#line 2363 "bind.c"
		const gchar* _tmp17_;
#line 260 "src/bind.vala"
		_tmp17_ = name;
#line 260 "src/bind.vala"
		minibuf_error ("No such function `%s'", _tmp17_, NULL);
#line 261 "src/bind.vala"
		result = FALSE;
#line 261 "src/bind.vala"
		_lisp_func_unref0 (func);
#line 261 "src/bind.vala"
		_g_free0 (name);
#line 261 "src/bind.vala"
		_g_free0 (keystr);
#line 261 "src/bind.vala"
		_g_object_unref0 (keys);
#line 261 "src/bind.vala"
		return result;
#line 2381 "bind.c"
	}
#line 263 "src/bind.vala"
	_tmp18_ = root_bindings;
#line 263 "src/bind.vala"
	_tmp19_ = keys;
#line 263 "src/bind.vala"
	_tmp20_ = func;
#line 263 "src/bind.vala"
	binding_bind (_tmp18_, _tmp19_, _tmp20_);
#line 264 "src/bind.vala"
	result = TRUE;
#line 264 "src/bind.vala"
	_lisp_func_unref0 (func);
#line 264 "src/bind.vala"
	_g_free0 (name);
#line 264 "src/bind.vala"
	_g_free0 (keystr);
#line 264 "src/bind.vala"
	_g_object_unref0 (keys);
#line 264 "src/bind.vala"
	return result;
#line 2403 "bind.c"
}

static gboolean
___lambda24__function (glong uniarg,
                       GeeQueue* args)
{
	gboolean result;
	result = __lambda24_ (uniarg, args);
#line 235 "src/bind.vala"
	return result;
#line 2414 "bind.c"
}

static gboolean
_self_insert_command_movement_delegate (gpointer self)
{
	gboolean result;
	result = self_insert_command ();
#line 275 "src/bind.vala"
	return result;
#line 2424 "bind.c"
}

static gboolean
__lambda26_ (glong uniarg,
             GeeQueue* args)
{
	gboolean result;
#line 275 "src/bind.vala"
	result = execute_with_uniarg (uniarg, _self_insert_command_movement_delegate, NULL, NULL, NULL);
#line 275 "src/bind.vala"
	return result;
#line 2436 "bind.c"
}

static gboolean
___lambda26__function (glong uniarg,
                       GeeQueue* args)
{
	gboolean result;
	result = __lambda26_ (uniarg, args);
#line 272 "src/bind.vala"
	return result;
#line 2447 "bind.c"
}

static Block2Data*
block2_data_ref (Block2Data* _data2_)
{
#line 288 "src/bind.vala"
	g_atomic_int_inc (&_data2_->_ref_count_);
#line 288 "src/bind.vala"
	return _data2_;
#line 2457 "bind.c"
}

static void
block2_data_unref (void * _userdata_)
{
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
#line 288 "src/bind.vala"
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
#line 288 "src/bind.vala"
		_lisp_func_unref0 (_data2_->f);
#line 288 "src/bind.vala"
		g_slice_free (Block2Data, _data2_);
#line 2471 "bind.c"
	}
}

static Block3Data*
block3_data_ref (Block3Data* _data3_)
{
#line 290 "src/bind.vala"
	g_atomic_int_inc (&_data3_->_ref_count_);
#line 290 "src/bind.vala"
	return _data3_;
#line 2482 "bind.c"
}

static void
block3_data_unref (void * _userdata_)
{
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
#line 290 "src/bind.vala"
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
#line 290 "src/bind.vala"
		_g_free0 (_data3_->bindings);
#line 290 "src/bind.vala"
		block2_data_unref (_data3_->_data2_);
#line 290 "src/bind.vala"
		_data3_->_data2_ = NULL;
#line 290 "src/bind.vala"
		g_slice_free (Block3Data, _data3_);
#line 2500 "bind.c"
	}
}

static void
____lambda28_ (Block3Data* _data3_,
               const gchar* key,
               Binding* p)
{
	Block2Data* _data2_;
	LispFunc* _tmp0_;
	LispFunc* _tmp1_;
#line 292 "src/bind.vala"
	_data2_ = _data3_->_data2_;
#line 292 "src/bind.vala"
	g_return_if_fail (key != NULL);
#line 292 "src/bind.vala"
	g_return_if_fail (p != NULL);
#line 293 "src/bind.vala"
	_tmp0_ = p->func;
#line 293 "src/bind.vala"
	_tmp1_ = _data2_->f;
#line 293 "src/bind.vala"
	if (_tmp0_ == _tmp1_) {
#line 2524 "bind.c"
		const gchar* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		const gchar* _tmp7_;
		gchar* _tmp8_;
#line 294 "src/bind.vala"
		_tmp2_ = _data3_->bindings;
#line 294 "src/bind.vala"
		_tmp3_ = strlen (_tmp2_);
#line 294 "src/bind.vala"
		_tmp4_ = _tmp3_;
#line 294 "src/bind.vala"
		if (_tmp4_ > 0) {
#line 2538 "bind.c"
			const gchar* _tmp5_;
			gchar* _tmp6_;
#line 295 "src/bind.vala"
			_tmp5_ = _data3_->bindings;
#line 295 "src/bind.vala"
			_tmp6_ = g_strconcat (_tmp5_, ", ", NULL);
#line 295 "src/bind.vala"
			_g_free0 (_data3_->bindings);
#line 295 "src/bind.vala"
			_data3_->bindings = _tmp6_;
#line 2549 "bind.c"
		}
#line 296 "src/bind.vala"
		_tmp7_ = _data3_->bindings;
#line 296 "src/bind.vala"
		_tmp8_ = g_strconcat (_tmp7_, key, NULL);
#line 296 "src/bind.vala"
		_g_free0 (_data3_->bindings);
#line 296 "src/bind.vala"
		_data3_->bindings = _tmp8_;
#line 2559 "bind.c"
	}
}

static void
_____lambda28__bindings_processor (const gchar* key,
                                   Binding* p,
                                   gpointer self)
{
#line 292 "src/bind.vala"
	____lambda28_ (self, key, p);
#line 2570 "bind.c"
}

static gboolean
__lambda27_ (glong uniarg,
             GeeQueue* args)
{
	gchar* name = NULL;
	gchar* _tmp0_;
	gboolean ok = FALSE;
	const gchar* _tmp1_;
	gboolean result;
#line 285 "src/bind.vala"
	_tmp0_ = minibuf_read_function_name ("Where is command: ", NULL);
#line 285 "src/bind.vala"
	name = _tmp0_;
#line 286 "src/bind.vala"
	ok = FALSE;
#line 288 "src/bind.vala"
	_tmp1_ = name;
#line 288 "src/bind.vala"
	if (_tmp1_ != NULL) {
#line 2592 "bind.c"
		Block2Data* _data2_;
		const gchar* _tmp2_;
		LispFunc* _tmp3_;
		LispFunc* _tmp4_;
#line 288 "src/bind.vala"
		_data2_ = g_slice_new0 (Block2Data);
#line 288 "src/bind.vala"
		_data2_->_ref_count_ = 1;
#line 289 "src/bind.vala"
		_tmp2_ = name;
#line 289 "src/bind.vala"
		_tmp3_ = lisp_func_find (_tmp2_);
#line 289 "src/bind.vala"
		_data2_->f = _tmp3_;
#line 290 "src/bind.vala"
		_tmp4_ = _data2_->f;
#line 290 "src/bind.vala"
		if (_tmp4_ != NULL) {
#line 2611 "bind.c"
			Block3Data* _data3_;
			gchar* _tmp5_;
			const gchar* _tmp6_;
			gint _tmp7_;
			gint _tmp8_;
#line 290 "src/bind.vala"
			_data3_ = g_slice_new0 (Block3Data);
#line 290 "src/bind.vala"
			_data3_->_ref_count_ = 1;
#line 290 "src/bind.vala"
			_data3_->_data2_ = block2_data_ref (_data2_);
#line 291 "src/bind.vala"
			_tmp5_ = g_strdup ("");
#line 291 "src/bind.vala"
			_data3_->bindings = _tmp5_;
#line 292 "src/bind.vala"
			walk_bindings (_____lambda28__bindings_processor, _data3_);
#line 300 "src/bind.vala"
			_tmp6_ = _data3_->bindings;
#line 300 "src/bind.vala"
			_tmp7_ = strlen (_tmp6_);
#line 300 "src/bind.vala"
			_tmp8_ = _tmp7_;
#line 300 "src/bind.vala"
			if (_tmp8_ == 0) {
#line 2637 "bind.c"
				const gchar* _tmp9_;
#line 301 "src/bind.vala"
				_tmp9_ = name;
#line 301 "src/bind.vala"
				minibuf_write ("%s is not on any key", _tmp9_, NULL);
#line 2643 "bind.c"
			} else {
				const gchar* _tmp10_;
				const gchar* _tmp11_;
#line 303 "src/bind.vala"
				_tmp10_ = name;
#line 303 "src/bind.vala"
				_tmp11_ = _data3_->bindings;
#line 303 "src/bind.vala"
				minibuf_write ("%s is on %s", _tmp10_, _tmp11_, NULL);
#line 2653 "bind.c"
			}
#line 304 "src/bind.vala"
			ok = TRUE;
#line 290 "src/bind.vala"
			block3_data_unref (_data3_);
#line 290 "src/bind.vala"
			_data3_ = NULL;
#line 2661 "bind.c"
		}
#line 288 "src/bind.vala"
		block2_data_unref (_data2_);
#line 288 "src/bind.vala"
		_data2_ = NULL;
#line 2667 "bind.c"
	}
#line 307 "src/bind.vala"
	result = ok;
#line 307 "src/bind.vala"
	_g_free0 (name);
#line 307 "src/bind.vala"
	return result;
#line 2675 "bind.c"
}

static gboolean
___lambda27__function (glong uniarg,
                       GeeQueue* args)
{
	gboolean result;
	result = __lambda27_ (uniarg, args);
#line 282 "src/bind.vala"
	return result;
#line 2686 "bind.c"
}

static void
__lambda31_ (const gchar* key,
             Binding* p)
{
	LispFunc* _tmp0_;
	const gchar* _tmp1_;
#line 325 "src/bind.vala"
	g_return_if_fail (key != NULL);
#line 325 "src/bind.vala"
	g_return_if_fail (p != NULL);
#line 326 "src/bind.vala"
	_tmp0_ = p->func;
#line 326 "src/bind.vala"
	_tmp1_ = _tmp0_->name;
#line 326 "src/bind.vala"
	bprintf ("%-15s %s\n", key, _tmp1_, NULL);
#line 2705 "bind.c"
}

static void
___lambda31__bindings_processor (const gchar* key,
                                 Binding* p,
                                 gpointer self)
{
#line 325 "src/bind.vala"
	__lambda31_ (key, p);
#line 2715 "bind.c"
}

static void
__lambda30_ (void)
{
#line 321 "src/bind.vala"
	bprintf ("Key translations:\n", NULL);
#line 322 "src/bind.vala"
	bprintf ("%-15s %s\n", "key", "binding", NULL);
#line 323 "src/bind.vala"
	bprintf ("%-15s %s\n", "---", "-------", NULL);
#line 325 "src/bind.vala"
	walk_bindings (___lambda31__bindings_processor, NULL);
#line 2729 "bind.c"
}

static void
___lambda30__buffer_writer (gpointer self)
{
#line 317 "src/bind.vala"
	__lambda30_ ();
#line 2737 "bind.c"
}

static gboolean
__lambda29_ (glong uniarg,
             GeeQueue* args)
{
	gboolean result;
#line 317 "src/bind.vala"
	write_temp_buffer ("*Help*", TRUE, ___lambda30__buffer_writer, NULL);
#line 329 "src/bind.vala"
	result = TRUE;
#line 329 "src/bind.vala"
	return result;
#line 2751 "bind.c"
}

static gboolean
___lambda29__function (glong uniarg,
                       GeeQueue* args)
{
	gboolean result;
	result = __lambda29_ (uniarg, args);
#line 314 "src/bind.vala"
	return result;
#line 2762 "bind.c"
}

void
bind_init (void)
{
	LispFunc* _tmp0_;
	LispFunc* _tmp1_;
	LispFunc* _tmp2_;
	LispFunc* _tmp3_;
	LispFunc* _tmp4_;
	LispFunc* _tmp5_;
	LispFunc* _tmp6_;
	LispFunc* _tmp7_;
#line 235 "src/bind.vala"
	_tmp0_ = lisp_func_new ("global-set-key", ___lambda24__function, TRUE, "Bind a command to a key sequence.\n" \
"Read key sequence and function name, and bind the function to the key\n" \
"sequence.");
#line 235 "src/bind.vala"
	_tmp1_ = _tmp0_;
#line 235 "src/bind.vala"
	_lisp_func_unref0 (_tmp1_);
#line 272 "src/bind.vala"
	_tmp2_ = lisp_func_new ("self-insert-command", ___lambda26__function, TRUE, "Insert the character you type.\n" \
"Whichever character you type to run this command is inserted.");
#line 272 "src/bind.vala"
	_tmp3_ = _tmp2_;
#line 272 "src/bind.vala"
	_lisp_func_unref0 (_tmp3_);
#line 282 "src/bind.vala"
	_tmp4_ = lisp_func_new ("where-is", ___lambda27__function, TRUE, "Print message listing key sequences that invoke the command DEFINITION" \
".\n" \
"Argument is a command name.");
#line 282 "src/bind.vala"
	_tmp5_ = _tmp4_;
#line 282 "src/bind.vala"
	_lisp_func_unref0 (_tmp5_);
#line 314 "src/bind.vala"
	_tmp6_ = lisp_func_new ("describe-bindings", ___lambda29__function, TRUE, "Show a list of all defined keys, and their definitions.");
#line 314 "src/bind.vala"
	_tmp7_ = _tmp6_;
#line 314 "src/bind.vala"
	_lisp_func_unref0 (_tmp7_);
#line 2800 "bind.c"
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

