/**************************************************************************
 *  This file is part of QXmlEdit                                         *
 *  Copyright (C) 2016-2018 by Luca Bellonda and individual contributors  *
 *    as indicated in the AUTHORS file                                    *
 *  lbellonda _at_ gmail.com                                              *
 *                                                                        *
 * This library is free software; you can redistribute it and/or          *
 * modify it under the terms of the GNU Library General Public            *
 * License as published by the Free Software Foundation; either           *
 * version 2 of the License, or (at your option) any later version.       *
 *                                                                        *
 * This library is distributed in the hope that it will be useful,        *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of         *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU      *
 * Library General Public License for more details.                       *
 *                                                                        *
 * You should have received a copy of the GNU Library General Public      *
 * License along with this library; if not, write to the                  *
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,       *
 * Boston, MA  02110-1301  USA                                            *
 **************************************************************************/

#ifndef SCXMLINFO_H
#define SCXMLINFO_H

#include "xmlEdit.h"

class Element ;

class SCXMLState
{
    QList<SCXMLState*> _children;
    Element *_element;
    QString _id;
    bool _parallel;
public:
    SCXMLState();
    virtual ~SCXMLState();

    void allStates(QStringList &result);

    void addChild(SCXMLState *state);
    bool isParallel() const;
    Element *element() const;
    void setElement(Element *element);
    QString id() const;
    void setId(const QString &id);
    void setParallel(bool parallel);

    QList<SCXMLState *> children() const;
};

class Regola;
class NSContext ;

class SCXMLInfo
{
    QList<SCXMLState *> _children;
public:
    SCXMLInfo();
    virtual ~SCXMLInfo();

    QStringList allStates();
    void addChild(SCXMLState *state);
    QList<SCXMLState *> children() const;
    //---------------------------------------------------
    static bool findInfoStates(Regola *regola, SCXMLInfo *info);
    static SCXMLState *addStateForInfo(SCXMLInfo *info, SCXMLState *currentState, SCXMLState *state);
    static bool findInfoStates(Element *element, SCXMLInfo *info, NSContext *parent, const bool rootFound, SCXMLState *currentState);

};

#endif // SCXMLINFO_H
