package ros

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DoActions invokes the ros.DoActions API synchronously
// api document: https://help.aliyun.com/api/ros/doactions.html
func (client *Client) DoActions(request *DoActionsRequest) (response *DoActionsResponse, err error) {
	response = CreateDoActionsResponse()
	err = client.DoAction(request, response)
	return
}

// DoActionsWithChan invokes the ros.DoActions API asynchronously
// api document: https://help.aliyun.com/api/ros/doactions.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DoActionsWithChan(request *DoActionsRequest) (<-chan *DoActionsResponse, <-chan error) {
	responseChan := make(chan *DoActionsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DoActions(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DoActionsWithCallback invokes the ros.DoActions API asynchronously
// api document: https://help.aliyun.com/api/ros/doactions.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DoActionsWithCallback(request *DoActionsRequest, callback func(response *DoActionsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DoActionsResponse
		var err error
		defer close(result)
		response, err = client.DoActions(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DoActionsRequest is the request struct for api DoActions
type DoActionsRequest struct {
	*requests.RoaRequest
	StackId   string `position:"Path" name:"StackId"`
	StackName string `position:"Path" name:"StackName"`
}

// DoActionsResponse is the response struct for api DoActions
type DoActionsResponse struct {
	*responses.BaseResponse
}

// CreateDoActionsRequest creates a request to invoke DoActions API
func CreateDoActionsRequest() (request *DoActionsRequest) {
	request = &DoActionsRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("ROS", "2015-09-01", "DoActions", "/stacks/[StackName]/[StackId]/actions", "ROS", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDoActionsResponse creates a response to parse from DoActions response
func CreateDoActionsResponse() (response *DoActionsResponse) {
	response = &DoActionsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
