package alidns

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeGtmMonitorConfig invokes the alidns.DescribeGtmMonitorConfig API synchronously
func (client *Client) DescribeGtmMonitorConfig(request *DescribeGtmMonitorConfigRequest) (response *DescribeGtmMonitorConfigResponse, err error) {
	response = CreateDescribeGtmMonitorConfigResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeGtmMonitorConfigWithChan invokes the alidns.DescribeGtmMonitorConfig API asynchronously
func (client *Client) DescribeGtmMonitorConfigWithChan(request *DescribeGtmMonitorConfigRequest) (<-chan *DescribeGtmMonitorConfigResponse, <-chan error) {
	responseChan := make(chan *DescribeGtmMonitorConfigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeGtmMonitorConfig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeGtmMonitorConfigWithCallback invokes the alidns.DescribeGtmMonitorConfig API asynchronously
func (client *Client) DescribeGtmMonitorConfigWithCallback(request *DescribeGtmMonitorConfigRequest, callback func(response *DescribeGtmMonitorConfigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeGtmMonitorConfigResponse
		var err error
		defer close(result)
		response, err = client.DescribeGtmMonitorConfig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeGtmMonitorConfigRequest is the request struct for api DescribeGtmMonitorConfig
type DescribeGtmMonitorConfigRequest struct {
	*requests.RpcRequest
	MonitorConfigId string `position:"Query" name:"MonitorConfigId"`
	UserClientIp    string `position:"Query" name:"UserClientIp"`
	Lang            string `position:"Query" name:"Lang"`
}

// DescribeGtmMonitorConfigResponse is the response struct for api DescribeGtmMonitorConfig
type DescribeGtmMonitorConfigResponse struct {
	*responses.BaseResponse
	RequestId         string                                 `json:"RequestId" xml:"RequestId"`
	MonitorConfigId   string                                 `json:"MonitorConfigId" xml:"MonitorConfigId"`
	CreateTime        string                                 `json:"CreateTime" xml:"CreateTime"`
	CreateTimestamp   int64                                  `json:"CreateTimestamp" xml:"CreateTimestamp"`
	UpdateTime        string                                 `json:"UpdateTime" xml:"UpdateTime"`
	UpdateTimestamp   int64                                  `json:"UpdateTimestamp" xml:"UpdateTimestamp"`
	ProtocolType      string                                 `json:"ProtocolType" xml:"ProtocolType"`
	Interval          int                                    `json:"Interval" xml:"Interval"`
	EvaluationCount   int                                    `json:"EvaluationCount" xml:"EvaluationCount"`
	Timeout           int                                    `json:"Timeout" xml:"Timeout"`
	MonitorExtendInfo string                                 `json:"MonitorExtendInfo" xml:"MonitorExtendInfo"`
	IspCityNodes      IspCityNodesInDescribeGtmMonitorConfig `json:"IspCityNodes" xml:"IspCityNodes"`
}

// CreateDescribeGtmMonitorConfigRequest creates a request to invoke DescribeGtmMonitorConfig API
func CreateDescribeGtmMonitorConfigRequest() (request *DescribeGtmMonitorConfigRequest) {
	request = &DescribeGtmMonitorConfigRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Alidns", "2015-01-09", "DescribeGtmMonitorConfig", "alidns", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeGtmMonitorConfigResponse creates a response to parse from DescribeGtmMonitorConfig response
func CreateDescribeGtmMonitorConfigResponse() (response *DescribeGtmMonitorConfigResponse) {
	response = &DescribeGtmMonitorConfigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
