/***********************************************************************************/
/*                                                                                 */
/* Copyright (C) 2020-2022 Advanced Micro Devices, Inc. All rights reserved.       */
/*                                                                                 */
/* Permission is hereby granted, free of charge, to any person obtaining a copy    */
/* of this software and associated documentation files (the "Software"), to deal   */
/* in the Software without restriction, including without limitation the rights    */
/* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell       */
/* copies of the Software, and to permit persons to whom the Software is           */
/* furnished to do so, subject to the following conditions:                        */
/*                                                                                 */
/* The above copyright notice and this permission notice shall be included in      */
/* all copies or substantial portions of the Software.                             */
/*                                                                                 */
/* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR      */
/* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,        */
/* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE     */
/* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER          */
/* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,   */
/* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE   */
/* SOFTWARE.                                                                       */
/*                                                                                 */
/***********************************************************************************/

/******************************************/
/* Function Prefix                        */
/******************************************/



/******************************************/
/* Begin Kernel                           */
/******************************************/

.amdgcn_target "amdgcn-amd-amdhsa--gfx940"
.text
.protected DGEMM_Aquavanjaram_PKFixedAtomic512Latest
.globl DGEMM_Aquavanjaram_PKFixedAtomic512Latest
.p2align 8
.type DGEMM_Aquavanjaram_PKFixedAtomic512Latest,@function
.section .rodata,#alloc
.p2align 6
.amdhsa_kernel DGEMM_Aquavanjaram_PKFixedAtomic512Latest
  .amdhsa_user_sgpr_kernarg_segment_ptr 1
  .amdhsa_next_free_vgpr 512 // vgprs
  .amdhsa_next_free_sgpr 80 // sgprs
  .amdhsa_accum_offset 256 // accumulate vgpr offset
  .amdhsa_group_segment_fixed_size 60000 // lds bytes
  .amdhsa_private_segment_fixed_size 0
  .amdhsa_system_sgpr_workgroup_id_x 1
  .amdhsa_system_sgpr_workgroup_id_y 1
  .amdhsa_system_sgpr_workgroup_id_z 1
  .amdhsa_system_vgpr_workitem_id 0
.end_amdhsa_kernel
.text

/******************************************/
/* Optimizations and Config:              */
/******************************************/
/* ThreadTile= 4 x 4 */
/* SubGroup= 16 x 16 */
/* VectorWidth=2 */
/* GlobalLoadVectorWidthA=2, GlobalLoadVectorWidthB=2 */
/* DirectToLdsA=False */
/* DirectToLdsB=False */
/* UseSgprForGRO=False */
.amdgpu_metadata
---
custom.config:
  ProblemType:
    OperationType: GEMM
    DataType: D
    TransposeA: False
    TransposeB: True
    UseBeta: True
    Batched: True
    LdcEqualsLdd: True
  MatrixInstruction: [16, 16, 4, 1]
  ThreadTile: [ 8, 32 ]
  WorkGroup: [  16, 16,  1 ]
  AssertSizeEqual: {3: 512}
  AssertSizeMultiple: {0: 128, 1: 128}
  PersistentKernel: 1
  StoreVectorWidth: 1
  DepthU: 8
  AssertAlphaValue: -1
  AssertBetaValue: 1
  AssertCEqualsD: True
amdhsa.version:
  - 1
  - 1
amdhsa.kernels:
  - .name: DGEMM_Aquavanjaram_PKFixedAtomic512Latest
    .symbol: 'DGEMM_Aquavanjaram_PKFixedAtomic512Latest.kd'
    .language:                   OpenCL C
    .language_version:
      - 2
      - 0
    .args:
      - .name:            sizeC
        .size:            8
        .offset:          0
        .value_kind:      by_value
        .value_type:      u64
      - .name:            sizeA
        .size:            8
        .offset:          8
        .value_kind:      by_value
        .value_type:      u64
      - .name:            sizeB
        .size:            8
        .offset:          16
        .value_kind:      by_value
        .value_type:      u64
      - .name:            D
        .size:            8
        .offset:          24
        .value_kind:      global_buffer
        .value_type:      f64
        .address_space:   generic
      - .name:            C
        .size:            8
        .offset:          32
        .value_kind:      global_buffer
        .value_type:      f64
        .address_space:   generic
      - .name:            A
        .size:            8
        .offset:          40
        .value_kind:      global_buffer
        .value_type:      f64
        .address_space:   generic
      - .name:            B
        .size:            8
        .offset:          48
        .value_kind:      global_buffer
        .value_type:      f64
        .address_space:   generic
      - .name:            OffsetD
        .size:            8
        .offset:          56
        .value_kind:      by_value
        .value_type:      u64
      - .name:            OffsetC
        .size:            8
        .offset:          64
        .value_kind:      by_value
        .value_type:      u64
      - .name:            OffsetA
        .size:            8
        .offset:          72
        .value_kind:      by_value
        .value_type:      u64
      - .name:            OffsetB
        .size:            8
        .offset:          80
        .value_kind:      by_value
        .value_type:      u64
      - .name:            alpha
        .size:            8
        .offset:          88
        .value_kind:      by_value
        .value_type:      f64
      - .name:            beta
        .size:            8
        .offset:          96
        .value_kind:      by_value
        .value_type:      f64
      - .name:            strideD0
        .size:            4
        .offset:          104
        .value_kind:      by_value
        .value_type:      u32
      - .name:            strideD1
        .size:            4
        .offset:          108
        .value_kind:      by_value
        .value_type:      u32
      - .name:            strideC0
        .size:            4
        .offset:          112
        .value_kind:      by_value
        .value_type:      u32
      - .name:            strideC1
        .size:            4
        .offset:          116
        .value_kind:      by_value
        .value_type:      u32
      - .name:            strideA0
        .size:            4
        .offset:          120
        .value_kind:      by_value
        .value_type:      u32
      - .name:            strideA1
        .size:            4
        .offset:          124
        .value_kind:      by_value
        .value_type:      u32
      - .name:            strideB0
        .size:            4
        .offset:          128
        .value_kind:      by_value
        .value_type:      u32
      - .name:            strideB1
        .size:            4
        .offset:          132
        .value_kind:      by_value
        .value_type:      u32
      - .name:            SizesFree0
        .size:            4
        .offset:          136
        .value_kind:      by_value
        .value_type:      u32
      - .name:            SizesFree1
        .size:            4
        .offset:          140
        .value_kind:      by_value
        .value_type:      u32
      - .name:            SizesFree2
        .size:            4
        .offset:          144
        .value_kind:      by_value
        .value_type:      u32
      - .name:            SizesSum0
        .size:            4
        .offset:          148
        .value_kind:      by_value
        .value_type:      u32
      - .name:            OrigStaggerUIter
        .size:            4
        .offset:          152
        .value_kind:      by_value
        .value_type:      i32
      - .name:            NumWorkGroups0
        .size:            4
        .offset:          156
        .value_kind:      by_value
        .value_type:      u32
      - .name:            NumWorkGroups1
        .size:            4
        .offset:          160
        .value_kind:      by_value
        .value_type:      u32
      - .name:            MagicNumberProblemNumGroupTiles0
        .size:            4
        .offset:          164
        .value_kind:      by_value
        .value_type:      u32
      - .name:            MagicShiftProblemNumGroupTiles0
        .size:            4
        .offset:          168
        .value_kind:      by_value
        .value_type:      u32
      - .name:            GridNumWorkGroups0
        .size:            4
        .offset:          172
        .value_kind:      by_value
        .value_type:      u32
      - .name:            NumFullBlocks
        .size:            4
        .offset:          176
        .value_kind:      by_value
        .value_type:      u32
      - .name:            WgmRemainder1
        .size:            4
        .offset:          180
        .value_kind:      by_value
        .value_type:      u32
      - .name:            MagicNumberWgmRemainder1
        .size:            4
        .offset:          184
        .value_kind:      by_value
        .value_type:      u32
      - .name:            padding
        .size:            4
        .offset:          188
        .value_kind:      by_value
        .value_type:      u32
    .group_segment_fixed_size:   60000
    .kernarg_segment_align:      8
    .kernarg_segment_size:       192
    .max_flat_workgroup_size:    256
    .private_segment_fixed_size: 0
    .sgpr_count:                 68
    .sgpr_spill_count:           0
    .vgpr_count:                 208
    .vgpr_spill_count:           0
    .wavefront_size:             64
...
.end_amdgpu_metadata

DGEMM_Aquavanjaram_PKFixedAtomic512Latest:

.long 0x8601FF01, 0x0000FFFF
.long 0xC00207C0, 0x00000088
.long 0xC0020800, 0x0000008C
.long 0xC0020840, 0x00000078
.long 0xC0020880, 0x00000080
.long 0xC00208C0, 0x00000070
.long 0xC0060A80, 0x00000000
.long 0xC0060B00, 0x00000008
.long 0xC0060B80, 0x00000010
.long 0xC0060100, 0x00000028
.long 0xC0060200, 0x00000030
.long 0xC0060400, 0x00000020
.long 0xC0061200, 0x00000048
.long 0xC0061280, 0x00000050
.long 0xC0061300, 0x00000040
.long 0xC0020D00, 0x0000009C
.long 0xC0020D40, 0x000000A0
.long 0xC0020D80, 0x000000A4
.long 0xC0020DC0, 0x000000A8
.long 0xC0020E00, 0x000000AC
.long 0x20040086
.long 0x260000BF
.long 0x7E600502
.long 0xBEB10002
.long 0xBF8CC07F
.long 0x8EC88348
.long 0x80044804
.long 0x82054905
.long 0x8ECA834A
.long 0x80084A08
.long 0x82094B09
.long 0x8ECC834C
.long 0x80104C10
.long 0x82114D11
.long 0xBE8700FF, 0x00020000
.long 0xBE8B00FF, 0x00020000
.long 0xBE9300FF, 0x00020000
.long 0x8605FF05, 0x0000FFFF
.long 0x8609FF09, 0x0000FFFF
.long 0x8611FF11, 0x0000FFFF
.long 0x92173534
.long 0xBF031731
.long 0xBF85331E
.long 0xBF033534
.long 0x85493534
.long 0x85483435
.long 0xBECA008C
.long 0xBECB00FF, 0x0AAAAAAB
.long 0xBF033534
.long 0xBECA028A
.long 0xBECB02FF, 0x0CCCCCCD
.long 0xBE8C0090
.long 0xBE8D00FF, 0x08000001
.long 0xBF033534
.long 0xBE8C028A
.long 0xBE8D02FF, 0x0CCCCCCD
.long 0xBF03FF17, 0x00007530
.long 0xBECA020C
.long 0xBECB020D
.long 0xBE8C0090
.long 0xBE8D00FF, 0x08000001
.long 0xBF033534
.long 0xBE8C0282
.long 0xBE8D02FF, 0x40000001
.long 0xBF03FF17, 0x00013880
.long 0xBECA020C
.long 0xBECB020D
.long 0xBE8F004B
.long 0x960D0F48
.long 0x920C0F48
.long 0x8F8C9F0C
.long 0xBEB9000C
.long 0x920C4A39
.long 0x80BA0C48
.long 0xB13A0000
.long 0xBEBA024A
.long 0xBEBB00FF, 0x05555556
.long 0xB13A0017
.long 0xBEBB02FF, 0x0590B217
.long 0xB13A0016
.long 0xBEBB02FF, 0x05D1745E
.long 0xB13A0015
.long 0xBEBB02FF, 0x06186187
.long 0xB13A0014
.long 0xBEBB02FF, 0x06666667
.long 0xB13A0013
.long 0xBEBB02FF, 0x06BCA1B0
.long 0xB13A0012
.long 0xBEBB02FF, 0x071C71C8
.long 0xB13A0011
.long 0xBEBB02FF, 0x07878788
.long 0xB13A0010
.long 0xBEBB02FF, 0x08000001
.long 0xB13A000F
.long 0xBEBB02FF, 0x08888889
.long 0xB13A000E
.long 0xBEBB02FF, 0x0924924A
.long 0xB13A000D
.long 0xBEBB02FF, 0x09D89D8A
.long 0xB13A000C
.long 0xBEBB02FF, 0x0AAAAAAB
.long 0xB13A000B
.long 0xBEBB02FF, 0x0BA2E8BB
.long 0xB13A000A
.long 0xBEBB02FF, 0x0CCCCCCD
.long 0xB13A0009
.long 0xBEBB02FF, 0x0E38E38F
.long 0xB13A0008
.long 0xBEBB02FF, 0x10000001
.long 0xB13A0007
.long 0xBEBB02FF, 0x12492493
.long 0xB13A0006
.long 0xBEBB02FF, 0x15555556
.long 0xB13A0005
.long 0xBEBB02FF, 0x1999999A
.long 0xB13A0004
.long 0xBEBB02FF, 0x20000001
.long 0xB13A0003
.long 0xBEBB02FF, 0x2AAAAAAB
.long 0xB13A0002
.long 0xBEBB02FF, 0x40000001
.long 0xB13A0001
.long 0xBEBB02FF, 0x80000001
.long 0xBECC0031
.long 0xB04D0000
.long 0x960D3631
.long 0x8F0E9F37
.long 0x920C0E31
.long 0x800C0D0C
.long 0x860EFF37, 0x7FFFFFFF
.long 0x8F330E0C
.long 0x92323433
.long 0x80B23231
.long 0xBF033534
.long 0x85463332
.long 0x85473233
.long 0xBF033849
.long 0xBEC6024C
.long 0xBEC7024D
.long 0xBE8F004B
.long 0x960D0F47
.long 0x920C0F47
.long 0x8F8C9F0C
.long 0x920D4A0C
.long 0x808D0D47
.long 0x920D490D
.long 0x800D460D
.long 0xBF09390C
.long 0xBE8F023B
.long 0x850E4A3A
.long 0x96470F0D
.long 0x92460F0D
.long 0x8FC69F46
.long 0x92470E46
.long 0x80C7470D
.long 0x920C4A0C
.long 0x80470C47
.long 0xBF033534
.long 0x85324746
.long 0x85334647
.long 0xBEC20108
.long 0x8E0D8322
.long 0x921B0D30
.long 0x8E0C8A33
.long 0x800C1B0C
.long 0x80080C08
.long 0x82098009
.long 0x8EAE832E
.long 0x8028422E
.long 0x8229432F
.long 0x240E0082
.long 0xB00C0400
.long 0x920D0C30
.long 0xBE96000D
.long 0xBEFC0016
.long 0xD1130010, 0x00011F00
.long 0x241E2083
.long 0x20200084
.long 0xD1060010, 0x00001910
.long 0x681E210F
.long 0x8E158522
.long 0xBE8A00FF, 0x80000000
.long 0xBEC00104
.long 0x8E0C8A32
.long 0x921AFF30, 0x00000100
.long 0x810C1A0C
.long 0x80040C04
.long 0x82058005
.long 0x8EAC832C
.long 0x8026402C
.long 0x8227412D
.long 0x8E0D8121
.long 0xD1130006, 0x00011F00
.long 0x240C0C82
.long 0x20200084
.long 0xD1060010, 0x00001B10
.long 0x680C2106
.long 0x240C0C82
.long 0x8E148521
.long 0xBE8600FF, 0x80000000
.long 0xE0511000, 0x80020707
.long 0xE0511100, 0x80020707
.long 0xE0511200, 0x80020707
.long 0xE0511300, 0x80020707
.long 0xE05C1000, 0x80013406
.long 0xB77C1020
.long 0x80041404
.long 0x82058005
.long 0x80081508
.long 0x82098009
.long 0xE0511000, 0x80020707
.long 0xE0511100, 0x80020707
.long 0xE0511200, 0x80020707
.long 0xE0511300, 0x80020707
.long 0xE05C1000, 0x80013806
.long 0xB77C1020
.long 0x80041404
.long 0x82058005
.long 0x80081508
.long 0x82098009
.long 0xE0511000, 0x80020707
.long 0xE0511100, 0x80020707
.long 0xE0511200, 0x80020707
.long 0xE0511300, 0x80020707
.long 0xE05C1000, 0x80013C06
.long 0xB77C1020
.long 0x80041404
.long 0x82058005
.long 0x80081508
.long 0x82098009
.long 0xE0511000, 0x80020707
.long 0xE0511100, 0x80020707
.long 0xE0511200, 0x80020707
.long 0xE0511300, 0x80020707
.long 0xE05C1000, 0x80014006
.long 0xB77C1020
.long 0x80041404
.long 0x82058005
.long 0x80081508
.long 0x82098009
.long 0xD3D94000, 0x18000080
.long 0xD3D94001, 0x18000080
.long 0xD3D94002, 0x18000080
.long 0xD3D94003, 0x18000080
.long 0xD3D94004, 0x18000080
.long 0xD3D94005, 0x18000080
.long 0xD3D94006, 0x18000080
.long 0xD3D94007, 0x18000080
.long 0xD3D94008, 0x18000080
.long 0xD3D94009, 0x18000080
.long 0xD3D9400A, 0x18000080
.long 0xD3D9400B, 0x18000080
.long 0xD3D9400C, 0x18000080
.long 0xD3D9400D, 0x18000080
.long 0xD3D9400E, 0x18000080
.long 0xD3D9400F, 0x18000080
.long 0xD3D94010, 0x18000080
.long 0xD3D94011, 0x18000080
.long 0xD3D94012, 0x18000080
.long 0xD3D94013, 0x18000080
.long 0xD3D94014, 0x18000080
.long 0xD3D94015, 0x18000080
.long 0xD3D94016, 0x18000080
.long 0xD3D94017, 0x18000080
.long 0xD3D94018, 0x18000080
.long 0xD3D94019, 0x18000080
.long 0xD3D9401A, 0x18000080
.long 0xD3D9401B, 0x18000080
.long 0xD3D9401C, 0x18000080
.long 0xD3D9401D, 0x18000080
.long 0xD3D9401E, 0x18000080
.long 0xD3D9401F, 0x18000080
.long 0xD3D94020, 0x18000080
.long 0xD3D94021, 0x18000080
.long 0xD3D94022, 0x18000080
.long 0xD3D94023, 0x18000080
.long 0xD3D94024, 0x18000080
.long 0xD3D94025, 0x18000080
.long 0xD3D94026, 0x18000080
.long 0xD3D94027, 0x18000080
.long 0xD3D94028, 0x18000080
.long 0xD3D94029, 0x18000080
.long 0xD3D9402A, 0x18000080
.long 0xD3D9402B, 0x18000080
.long 0xD3D9402C, 0x18000080
.long 0xD3D9402D, 0x18000080
.long 0xD3D9402E, 0x18000080
.long 0xD3D9402F, 0x18000080
.long 0xD3D94030, 0x18000080
.long 0xD3D94031, 0x18000080
.long 0xD3D94032, 0x18000080
.long 0xD3D94033, 0x18000080
.long 0xD3D94034, 0x18000080
.long 0xD3D94035, 0x18000080
.long 0xD3D94036, 0x18000080
.long 0xD3D94037, 0x18000080
.long 0xD3D94038, 0x18000080
.long 0xD3D94039, 0x18000080
.long 0xD3D9403A, 0x18000080
.long 0xD3D9403B, 0x18000080
.long 0xD3D9403C, 0x18000080
.long 0xD3D9403D, 0x18000080
.long 0xD3D9403E, 0x18000080
.long 0xD3D9403F, 0x18000080
.long 0xD3D94040, 0x18000080
.long 0xD3D94041, 0x18000080
.long 0xD3D94042, 0x18000080
.long 0xD3D94043, 0x18000080
.long 0xD3D94044, 0x18000080
.long 0xD3D94045, 0x18000080
.long 0xD3D94046, 0x18000080
.long 0xD3D94047, 0x18000080
.long 0xD3D94048, 0x18000080
.long 0xD3D94049, 0x18000080
.long 0xD3D9404A, 0x18000080
.long 0xD3D9404B, 0x18000080
.long 0xD3D9404C, 0x18000080
.long 0xD3D9404D, 0x18000080
.long 0xD3D9404E, 0x18000080
.long 0xD3D9404F, 0x18000080
.long 0xD3D94050, 0x18000080
.long 0xD3D94051, 0x18000080
.long 0xD3D94052, 0x18000080
.long 0xD3D94053, 0x18000080
.long 0xD3D94054, 0x18000080
.long 0xD3D94055, 0x18000080
.long 0xD3D94056, 0x18000080
.long 0xD3D94057, 0x18000080
.long 0xD3D94058, 0x18000080
.long 0xD3D94059, 0x18000080
.long 0xD3D9405A, 0x18000080
.long 0xD3D9405B, 0x18000080
.long 0xD3D9405C, 0x18000080
.long 0xD3D9405D, 0x18000080
.long 0xD3D9405E, 0x18000080
.long 0xD3D9405F, 0x18000080
.long 0xD3D94060, 0x18000080
.long 0xD3D94061, 0x18000080
.long 0xD3D94062, 0x18000080
.long 0xD3D94063, 0x18000080
.long 0xD3D94064, 0x18000080
.long 0xD3D94065, 0x18000080
.long 0xD3D94066, 0x18000080
.long 0xD3D94067, 0x18000080
.long 0xD3D94068, 0x18000080
.long 0xD3D94069, 0x18000080
.long 0xD3D9406A, 0x18000080
.long 0xD3D9406B, 0x18000080
.long 0xD3D9406C, 0x18000080
.long 0xD3D9406D, 0x18000080
.long 0xD3D9406E, 0x18000080
.long 0xD3D9406F, 0x18000080
.long 0xD3D94070, 0x18000080
.long 0xD3D94071, 0x18000080
.long 0xD3D94072, 0x18000080
.long 0xD3D94073, 0x18000080
.long 0xD3D94074, 0x18000080
.long 0xD3D94075, 0x18000080
.long 0xD3D94076, 0x18000080
.long 0xD3D94077, 0x18000080
.long 0xD3D94078, 0x18000080
.long 0xD3D94079, 0x18000080
.long 0xD3D9407A, 0x18000080
.long 0xD3D9407B, 0x18000080
.long 0xD3D9407C, 0x18000080
.long 0xD3D9407D, 0x18000080
.long 0xD3D9407E, 0x18000080
.long 0xD3D9407F, 0x18000080
.long 0xD3D94080, 0x18000080
.long 0xD3D94081, 0x18000080
.long 0xD3D94082, 0x18000080
.long 0xD3D94083, 0x18000080
.long 0xD3D94084, 0x18000080
.long 0xD3D94085, 0x18000080
.long 0xD3D94086, 0x18000080
.long 0xD3D94087, 0x18000080
.long 0xD3D94088, 0x18000080
.long 0xD3D94089, 0x18000080
.long 0xD3D9408A, 0x18000080
.long 0xD3D9408B, 0x18000080
.long 0xD3D9408C, 0x18000080
.long 0xD3D9408D, 0x18000080
.long 0xD3D9408E, 0x18000080
.long 0xD3D9408F, 0x18000080
.long 0xD3D94090, 0x18000080
.long 0xD3D94091, 0x18000080
.long 0xD3D94092, 0x18000080
.long 0xD3D94093, 0x18000080
.long 0xD3D94094, 0x18000080
.long 0xD3D94095, 0x18000080
.long 0xD3D94096, 0x18000080
.long 0xD3D94097, 0x18000080
.long 0xD3D94098, 0x18000080
.long 0xD3D94099, 0x18000080
.long 0xD3D9409A, 0x18000080
.long 0xD3D9409B, 0x18000080
.long 0xD3D9409C, 0x18000080
.long 0xD3D9409D, 0x18000080
.long 0xD3D9409E, 0x18000080
.long 0xD3D9409F, 0x18000080
.long 0xD3D940A0, 0x18000080
.long 0xD3D940A1, 0x18000080
.long 0xD3D940A2, 0x18000080
.long 0xD3D940A3, 0x18000080
.long 0xD3D940A4, 0x18000080
.long 0xD3D940A5, 0x18000080
.long 0xD3D940A6, 0x18000080
.long 0xD3D940A7, 0x18000080
.long 0xD3D940A8, 0x18000080
.long 0xD3D940A9, 0x18000080
.long 0xD3D940AA, 0x18000080
.long 0xD3D940AB, 0x18000080
.long 0xD3D940AC, 0x18000080
.long 0xD3D940AD, 0x18000080
.long 0xD3D940AE, 0x18000080
.long 0xD3D940AF, 0x18000080
.long 0xD3D940B0, 0x18000080
.long 0xD3D940B1, 0x18000080
.long 0xD3D940B2, 0x18000080
.long 0xD3D940B3, 0x18000080
.long 0xD3D940B4, 0x18000080
.long 0xD3D940B5, 0x18000080
.long 0xD3D940B6, 0x18000080
.long 0xD3D940B7, 0x18000080
.long 0xD3D940B8, 0x18000080
.long 0xD3D940B9, 0x18000080
.long 0xD3D940BA, 0x18000080
.long 0xD3D940BB, 0x18000080
.long 0xD3D940BC, 0x18000080
.long 0xD3D940BD, 0x18000080
.long 0xD3D940BE, 0x18000080
.long 0xD3D940BF, 0x18000080
.long 0xD3D940C0, 0x18000080
.long 0xD3D940C1, 0x18000080
.long 0xD3D940C2, 0x18000080
.long 0xD3D940C3, 0x18000080
.long 0xD3D940C4, 0x18000080
.long 0xD3D940C5, 0x18000080
.long 0xD3D940C6, 0x18000080
.long 0xD3D940C7, 0x18000080
.long 0xD3D940C8, 0x18000080
.long 0xD3D940C9, 0x18000080
.long 0xD3D940CA, 0x18000080
.long 0xD3D940CB, 0x18000080
.long 0xD3D940CC, 0x18000080
.long 0xD3D940CD, 0x18000080
.long 0xD3D940CE, 0x18000080
.long 0xD3D940CF, 0x18000080
.long 0xD3D940D0, 0x18000080
.long 0xD3D940D1, 0x18000080
.long 0xD3D940D2, 0x18000080
.long 0xD3D940D3, 0x18000080
.long 0xD3D940D4, 0x18000080
.long 0xD3D940D5, 0x18000080
.long 0xD3D940D6, 0x18000080
.long 0xD3D940D7, 0x18000080
.long 0xD3D940D8, 0x18000080
.long 0xD3D940D9, 0x18000080
.long 0xD3D940DA, 0x18000080
.long 0xD3D940DB, 0x18000080
.long 0xD3D940DC, 0x18000080
.long 0xD3D940DD, 0x18000080
.long 0xD3D940DE, 0x18000080
.long 0xD3D940DF, 0x18000080
.long 0xD3D940E0, 0x18000080
.long 0xD3D940E1, 0x18000080
.long 0xD3D940E2, 0x18000080
.long 0xD3D940E3, 0x18000080
.long 0xD3D940E4, 0x18000080
.long 0xD3D940E5, 0x18000080
.long 0xD3D940E6, 0x18000080
.long 0xD3D940E7, 0x18000080
.long 0xD3D940E8, 0x18000080
.long 0xD3D940E9, 0x18000080
.long 0xD3D940EA, 0x18000080
.long 0xD3D940EB, 0x18000080
.long 0xD3D940EC, 0x18000080
.long 0xD3D940ED, 0x18000080
.long 0xD3D940EE, 0x18000080
.long 0xD3D940EF, 0x18000080
.long 0xD3D940F0, 0x18000080
.long 0xD3D940F1, 0x18000080
.long 0xD3D940F2, 0x18000080
.long 0xD3D940F3, 0x18000080
.long 0xD3D940F4, 0x18000080
.long 0xD3D940F5, 0x18000080
.long 0xD3D940F6, 0x18000080
.long 0xD3D940F7, 0x18000080
.long 0xD3D940F8, 0x18000080
.long 0xD3D940F9, 0x18000080
.long 0xD3D940FA, 0x18000080
.long 0xD3D940FB, 0x18000080
.long 0xD3D940FC, 0x18000080
.long 0xD3D940FD, 0x18000080
.long 0xD3D940FE, 0x18000080
.long 0xD3D940FF, 0x18000080
.long 0xBF8C4F70
.long 0xBF8A0000
.long 0xD8EC0000, 0x1400000F
.long 0xD8EC0080, 0x1600000F
.long 0xD8EC0100, 0x1800000F
.long 0xD8EC0180, 0x1A00000F
.long 0xD8EC0200, 0x1C00000F
.long 0xD8EC0280, 0x1E00000F
.long 0xD8EC0300, 0x2000000F
.long 0xD8EC0380, 0x2200000F
.long 0xBEC40110
.long 0x8E188123
.long 0x8E198418
.long 0xB00C0100
.long 0x920F320C
.long 0x920EFF18, 0x00000080
.long 0x920C330E
.long 0x960D330E
.long 0x800C0F0C
.long 0x820D800D
.long 0x8E8C820C
.long 0x920E30FF, 0x00000100
.long 0x803E0E0C
.long 0x823F800D
.long 0x8EAA832A
.long 0x80A40C2A
.long 0x82A50D2B
.long 0xBE9200FF, 0x80000000
.long 0xBF091224
.long 0x850C2412
.long 0xBF068025
.long 0xBE92020C
.long 0xD1130010, 0x00011F00
.long 0x24182082
.long 0x20200084
.long 0x0C202018
.long 0x6818210C
.long 0x24181882
.long 0xD134000D, 0x0001110C
.long 0x924EFF32, 0x00000080
.long 0x80CE4E1F
.long 0xD1130010, 0x00011F00
.long 0x24202081
.long 0x8E0C8530
.long 0xD134000A, 0x00001910
.long 0xD134000B, 0x0001030A
.long 0x7E1C02FF, 0x80000000
.long 0xD0C9000C, 0x00009D0A
.long 0xD1000008, 0x0032190E
.long 0xD0C9000C, 0x00009D0B
.long 0xD1000009, 0x00321B0E
.long 0xBE9D0080
.long 0xBF8C0F7B
.long 0xBF8A0000
.long 0xBF8CC67F
.long 0xD3EE8000, 0x04026914
.long 0xE0511000, 0x80020707
.long 0xD8EC1020, 0x2400000F
.long 0xD8EC10A0, 0x2600000F
.long 0xD3EE8008, 0x04226916
.long 0xBF8CC67F
.long 0xD3EE8010, 0x04426918
.long 0xE0511100, 0x80020707
.long 0xD8EC1120, 0x2800000F
.long 0xD8EC11A0, 0x2A00000F
.long 0xD3EE8018, 0x0462691A
.long 0xBF8CC67F
.long 0xD3EE8020, 0x0482691C
.long 0xE0511200, 0x80020707
.long 0xD8EC1220, 0x2C00000F
.long 0xD8EC12A0, 0x2E00000F
.long 0xD3EE8028, 0x04A2691E
.long 0xBF8CC67F
.long 0xD3EE8030, 0x04C26920
.long 0xE0511300, 0x80020707
.long 0xD8EC1320, 0x3000000F
.long 0xD8EC13A0, 0x3200000F
.long 0xD3EE8038, 0x04E26922
.long 0xB77C1020
.long 0x80081508
.long 0x82098009
.long 0xD3EE8040, 0x05026D14
.long 0xE05C1000, 0x80014406
.long 0xD3EE8048, 0x05226D16
.long 0xD3EE8050, 0x05426D18
.long 0x80041404
.long 0x82058005
.long 0xD3EE8058, 0x05626D1A
.long 0xD3EE8060, 0x05826D1C
.long 0xD3EE8068, 0x05A26D1E
.long 0xD3EE8070, 0x05C26D20
.long 0xD3EE8078, 0x05E26D22
.long 0xBF8C0F7B
.long 0xBF8A0000
.long 0xBF8CC67F
.long 0xD3EE8000, 0x04027124
.long 0xE0511000, 0x80020707
.long 0xD8EC2040, 0x1400000F
.long 0xD8EC20C0, 0x1600000F
.long 0xD3EE8008, 0x04227126
.long 0xBF8CC67F
.long 0xD3EE8010, 0x04427128
.long 0xE0511100, 0x80020707
.long 0xD8EC2140, 0x1800000F
.long 0xD8EC21C0, 0x1A00000F
.long 0xD3EE8018, 0x0462712A
.long 0xBF8CC67F
.long 0xD3EE8020, 0x0482712C
.long 0xE0511200, 0x80020707
.long 0xD8EC2240, 0x1C00000F
.long 0xD8EC22C0, 0x1E00000F
.long 0xD3EE8028, 0x04A2712E
.long 0xBF8CC67F
.long 0xD3EE8030, 0x04C27130
.long 0xE0511300, 0x80020707
.long 0xD8EC2340, 0x2000000F
.long 0xD8EC23C0, 0x2200000F
.long 0xD3EE8038, 0x04E27132
.long 0xB77C1020
.long 0x80081508
.long 0x82098009
.long 0xD3EE8040, 0x05027524
.long 0xE05C1000, 0x80014806
.long 0xD3EE8048, 0x05227526
.long 0xD3EE8050, 0x05427528
.long 0x80041404
.long 0x82058005
.long 0xD3EE8058, 0x0562752A
.long 0xD3EE8060, 0x0582752C
.long 0xD3EE8068, 0x05A2752E
.long 0xD3EE8070, 0x05C27530
.long 0xD3EE8078, 0x05E27532
.long 0xBF8C0F7B
.long 0xBF8A0000
.long 0xBF8CC67F
.long 0xD3EE8000, 0x04027914
.long 0xE0511000, 0x80020707
.long 0xD8EC3060, 0x2400000F
.long 0xD8EC30E0, 0x2600000F
.long 0xD3EE8008, 0x04227916
.long 0xBF8CC67F
.long 0xD3EE8010, 0x04427918
.long 0xE0511100, 0x80020707
.long 0xD8EC3160, 0x2800000F
.long 0xD8EC31E0, 0x2A00000F
.long 0xD3EE8018, 0x0462791A
.long 0xBF8CC67F
.long 0xD3EE8020, 0x0482791C
.long 0xE0511200, 0x80020707
.long 0xD8EC3260, 0x2C00000F
.long 0xD8EC32E0, 0x2E00000F
.long 0xD3EE8028, 0x04A2791E
.long 0xBF8CC67F
.long 0xD3EE8030, 0x04C27920
.long 0xE0511300, 0x80020707
.long 0xD8EC3360, 0x3000000F
.long 0xD8EC33E0, 0x3200000F
.long 0xD3EE8038, 0x04E27922
.long 0xB77C1020
.long 0x80081508
.long 0x82098009
.long 0xD3EE8040, 0x05027D14
.long 0xE05C1000, 0x80014C06
.long 0xD3EE8048, 0x05227D16
.long 0xD3EE8050, 0x05427D18
.long 0x80041404
.long 0x82058005
.long 0xD3EE8058, 0x05627D1A
.long 0xD3EE8060, 0x05827D1C
.long 0xD3EE8068, 0x05A27D1E
.long 0xD3EE8070, 0x05C27D20
.long 0xD3EE8078, 0x05E27D22
.long 0xBF8C0F7B
.long 0xBF8A0000
.long 0xBF8CC67F
.long 0xD3EE8000, 0x04028124
.long 0xE0511000, 0x80020707
.long 0xD8EC4080, 0x1400000F
.long 0xD8EC4100, 0x1600000F
.long 0xD3EE8008, 0x04228126
.long 0xBF8CC67F
.long 0xD3EE8010, 0x04428128
.long 0xE0511100, 0x80020707
.long 0xD8EC4180, 0x1800000F
.long 0xD8EC4200, 0x1A00000F
.long 0xD3EE8018, 0x0462812A
.long 0xBF8CC67F
.long 0xD3EE8020, 0x0482812C
.long 0xE0511200, 0x80020707
.long 0xD8EC4280, 0x1C00000F
.long 0xD8EC4300, 0x1E00000F
.long 0xD3EE8028, 0x04A2812E
.long 0xBF8CC67F
.long 0xD3EE8030, 0x04C28130
.long 0xE0511300, 0x80020707
.long 0xD8EC4380, 0x2000000F
.long 0xD8EC4400, 0x2200000F
.long 0xD3EE8038, 0x04E28132
.long 0xBEFC0016
.long 0x80081508
.long 0x82098009
.long 0xD3EE8040, 0x05028524
.long 0xE05C1000, 0x80015006
.long 0xD3EE8048, 0x05228526
.long 0xD3EE8050, 0x05428528
.long 0x80041404
.long 0x82058005
.long 0xD3EE8058, 0x0562852A
.long 0xD3EE8060, 0x0582852C
.long 0xD3EE8068, 0x05A2852E
.long 0xD3EE8070, 0x05C28530
.long 0xD3EE8078, 0x05E28532
.long 0xBF8C0F7B
.long 0xBF8A0000
.long 0xBF8CC67F
.long 0xD3EE8000, 0x04028914
.long 0xE0511000, 0x80020707
.long 0xD8EC50A0, 0x2400000F
.long 0xD8EC5120, 0x2600000F
.long 0xD3EE8008, 0x04228916
.long 0xBF8CC67F
.long 0xD3EE8010, 0x04428918
.long 0xE0511100, 0x80020707
.long 0xD8EC51A0, 0x2800000F
.long 0xD8EC5220, 0x2A00000F
.long 0xD3EE8018, 0x0462891A
.long 0xBF8CC67F
.long 0xD3EE8020, 0x0482891C
.long 0xE0511200, 0x80020707
.long 0xD8EC52A0, 0x2C00000F
.long 0xD8EC5320, 0x2E00000F
.long 0xD3EE8028, 0x04A2891E
.long 0xBF8CC67F
.long 0xD3EE8030, 0x04C28920
.long 0xE0511300, 0x80020707
.long 0xD8EC53A0, 0x3000000F
.long 0xD8EC5420, 0x3200000F
.long 0xD3EE8038, 0x04E28922
.long 0xB77C1020
.long 0x80081508
.long 0x82098009
.long 0xD3EE8040, 0x05028D14
.long 0xE05C1000, 0x80013406
.long 0xD3EE8048, 0x05228D16
.long 0xD3EE8050, 0x05428D18
.long 0x80041404
.long 0x82058005
.long 0xD3EE8058, 0x05628D1A
.long 0xD3EE8060, 0x05828D1C
.long 0xD3EE8068, 0x05A28D1E
.long 0xD3EE8070, 0x05C28D20
.long 0xD3EE8078, 0x05E28D22
.long 0xBF8C0F7B
.long 0xBF8A0000
.long 0xBF8CC67F
.long 0xD3EE8000, 0x04029124
.long 0xE0511000, 0x80020707
.long 0xD8EC60C0, 0x1400000F
.long 0xD8EC6140, 0x1600000F
.long 0xD3EE8008, 0x04229126
.long 0xBF8CC67F
.long 0xD3EE8010, 0x04429128
.long 0xE0511100, 0x80020707
.long 0xD8EC61C0, 0x1800000F
.long 0xD8EC6240, 0x1A00000F
.long 0xD3EE8018, 0x0462912A
.long 0xBF8CC67F
.long 0xD3EE8020, 0x0482912C
.long 0xE0511200, 0x80020707
.long 0xD8EC62C0, 0x1C00000F
.long 0xD8EC6340, 0x1E00000F
.long 0xD3EE8028, 0x04A2912E
.long 0xBF8CC67F
.long 0xD3EE8030, 0x04C29130
.long 0xE0511300, 0x80020707
.long 0xD8EC63C0, 0x2000000F
.long 0xD8EC6440, 0x2200000F
.long 0xD3EE8038, 0x04E29132
.long 0xB77C1020
.long 0x80081508
.long 0x82098009
.long 0xD3EE8040, 0x05029524
.long 0xE05C1000, 0x80013806
.long 0xD3EE8048, 0x05229526
.long 0xD3EE8050, 0x05429528
.long 0x80041404
.long 0x82058005
.long 0xD3EE8058, 0x0562952A
.long 0xD3EE8060, 0x0582952C
.long 0xD3EE8068, 0x05A2952E
.long 0xD3EE8070, 0x05C29530
.long 0xD3EE8078, 0x05E29532
.long 0xBF8C0F7B
.long 0xBF8A0000
.long 0xBF8CC67F
.long 0xD3EE8000, 0x04029914
.long 0xE0511000, 0x80020707
.long 0xD8EC70E0, 0x2400000F
.long 0xD8EC7160, 0x2600000F
.long 0xD3EE8008, 0x04229916
.long 0xBF8CC67F
.long 0xD3EE8010, 0x04429918
.long 0xE0511100, 0x80020707
.long 0xD8EC71E0, 0x2800000F
.long 0xD8EC7260, 0x2A00000F
.long 0xD3EE8018, 0x0462991A
.long 0xBF8CC67F
.long 0xD3EE8020, 0x0482991C
.long 0xE0511200, 0x80020707
.long 0xD8EC72E0, 0x2C00000F
.long 0xD8EC7360, 0x2E00000F
.long 0xD3EE8028, 0x04A2991E
.long 0xBF8CC67F
.long 0xD3EE8030, 0x04C29920
.long 0xE0511300, 0x80020707
.long 0xD8EC73E0, 0x3000000F
.long 0xD8EC7460, 0x3200000F
.long 0xD3EE8038, 0x04E29922
.long 0xB77C1020
.long 0x80081508
.long 0x82098009
.long 0xD3EE8040, 0x05029D14
.long 0xE05C1000, 0x80013C06
.long 0xD3EE8048, 0x05229D16
.long 0xD3EE8050, 0x05429D18
.long 0x80041404
.long 0x82058005
.long 0xD3EE8058, 0x05629D1A
.long 0xD3EE8060, 0x05829D1C
.long 0xD3EE8068, 0x05A29D1E
.long 0xD3EE8070, 0x05C29D20
.long 0xD3EE8078, 0x05E29D22
.long 0xBF8C0F7B
.long 0xBF8A0000
.long 0xBF8CC67F
.long 0xD3EE8000, 0x0402A124
.long 0xE0511000, 0x80020707
.long 0xD8EC0000, 0x1400000F
.long 0xD8EC0080, 0x1600000F
.long 0xD3EE8008, 0x0422A126
.long 0xBF8CC67F
.long 0xD3EE8010, 0x0442A128
.long 0xE0511100, 0x80020707
.long 0xD8EC0100, 0x1800000F
.long 0xD8EC0180, 0x1A00000F
.long 0xD3EE8018, 0x0462A12A
.long 0xBF8CC67F
.long 0xD3EE8020, 0x0482A12C
.long 0xE0511200, 0x80020707
.long 0xD8EC0200, 0x1C00000F
.long 0xD8EC0280, 0x1E00000F
.long 0xD3EE8028, 0x04A2A12E
.long 0xBF8CC67F
.long 0xD3EE8030, 0x04C2A130
.long 0xE0511300, 0x80020707
.long 0xD8EC0300, 0x2000000F
.long 0xD8EC0380, 0x2200000F
.long 0xD3EE8038, 0x04E2A132
.long 0xB77C1020
.long 0x80081508
.long 0x82098009
.long 0xD3EE8040, 0x0502A524
.long 0xE05C1000, 0x80014006
.long 0xD3EE8048, 0x0522A526
.long 0xD3EE8050, 0x0542A528
.long 0x80041404
.long 0x82058005
.long 0xD3EE8058, 0x0562A52A
.long 0xD3EE8060, 0x0582A52C
.long 0xD3EE8068, 0x05A2A52E
.long 0xD3EE8070, 0x05C2A530
.long 0xD3EE8078, 0x05E2A532
.long 0xB71D0008
.long 0xB31D0078
.long 0xBF85FDD5
.long 0xBF8C0F7B
.long 0xBF8A0000
.long 0xBF8CC67F
.long 0xD3EE8000, 0x04026914
.long 0xE0511000, 0x80020707
.long 0xD8EC1020, 0x2400000F
.long 0xD8EC10A0, 0x2600000F
.long 0xD3EE8008, 0x04226916
.long 0xBF8CC67F
.long 0xD3EE8010, 0x04426918
.long 0xE0511100, 0x80020707
.long 0xD8EC1120, 0x2800000F
.long 0xD8EC11A0, 0x2A00000F
.long 0xD3EE8018, 0x0462691A
.long 0xBF8CC67F
.long 0xD3EE8020, 0x0482691C
.long 0xE0511200, 0x80020707
.long 0xD8EC1220, 0x2C00000F
.long 0xD8EC12A0, 0x2E00000F
.long 0xD3EE8028, 0x04A2691E
.long 0xBF8CC67F
.long 0xD3EE8030, 0x04C26920
.long 0xE0511300, 0x80020707
.long 0xD8EC1320, 0x3000000F
.long 0xD8EC13A0, 0x3200000F
.long 0xD3EE8038, 0x04E26922
.long 0xB77C1020
.long 0x80081508
.long 0x82098009
.long 0xD3EE8040, 0x05026D14
.long 0xE05C1000, 0x80014406
.long 0xD3EE8048, 0x05226D16
.long 0xD3EE8050, 0x05426D18
.long 0x80041404
.long 0x82058005
.long 0xD3EE8058, 0x05626D1A
.long 0xD3EE8060, 0x05826D1C
.long 0xD3EE8068, 0x05A26D1E
.long 0xD3EE8070, 0x05C26D20
.long 0xD3EE8078, 0x05E26D22
.long 0xBF8C0F7B
.long 0xBF8A0000
.long 0xBF8CC67F
.long 0xD3EE8000, 0x04027124
.long 0xE0511000, 0x80020707
.long 0xD8EC2040, 0x1400000F
.long 0xD8EC20C0, 0x1600000F
.long 0xD3EE8008, 0x04227126
.long 0xBF8CC67F
.long 0xD3EE8010, 0x04427128
.long 0xE0511100, 0x80020707
.long 0xD8EC2140, 0x1800000F
.long 0xD8EC21C0, 0x1A00000F
.long 0xD3EE8018, 0x0462712A
.long 0xBF8CC67F
.long 0xD3EE8020, 0x0482712C
.long 0xE0511200, 0x80020707
.long 0xD8EC2240, 0x1C00000F
.long 0xD8EC22C0, 0x1E00000F
.long 0xD3EE8028, 0x04A2712E
.long 0xBF8CC67F
.long 0xD3EE8030, 0x04C27130
.long 0xE0511300, 0x80020707
.long 0xD8EC2340, 0x2000000F
.long 0xD8EC23C0, 0x2200000F
.long 0xD3EE8038, 0x04E27132
.long 0xB77C1020
.long 0x80081508
.long 0x82098009
.long 0xD3EE8040, 0x05027524
.long 0xE05C1000, 0x80014806
.long 0xD3EE8048, 0x05227526
.long 0xD3EE8050, 0x05427528
.long 0x80041404
.long 0x82058005
.long 0xD3EE8058, 0x0562752A
.long 0xD3EE8060, 0x0582752C
.long 0xD3EE8068, 0x05A2752E
.long 0xD3EE8070, 0x05C27530
.long 0xD3EE8078, 0x05E27532
.long 0xBF8C0F7B
.long 0xBF8A0000
.long 0xBF8CC67F
.long 0xD3EE8000, 0x04027914
.long 0xE0511000, 0x80020707
.long 0xD8EC3060, 0x2400000F
.long 0xD8EC30E0, 0x2600000F
.long 0xD3EE8008, 0x04227916
.long 0xBF8CC67F
.long 0xD3EE8010, 0x04427918
.long 0xE0511100, 0x80020707
.long 0xD8EC3160, 0x2800000F
.long 0xD8EC31E0, 0x2A00000F
.long 0xD3EE8018, 0x0462791A
.long 0xBF8CC67F
.long 0xD3EE8020, 0x0482791C
.long 0xE0511200, 0x80020707
.long 0xD8EC3260, 0x2C00000F
.long 0xD8EC32E0, 0x2E00000F
.long 0xD3EE8028, 0x04A2791E
.long 0xBF8CC67F
.long 0xD3EE8030, 0x04C27920
.long 0xE0511300, 0x80020707
.long 0xD8EC3360, 0x3000000F
.long 0xD8EC33E0, 0x3200000F
.long 0xD3EE8038, 0x04E27922
.long 0xB77C1020
.long 0x80081508
.long 0x82098009
.long 0xD3EE8040, 0x05027D14
.long 0xE05C1000, 0x80014C06
.long 0xD3EE8048, 0x05227D16
.long 0xD3EE8050, 0x05427D18
.long 0x80041404
.long 0x82058005
.long 0xD3EE8058, 0x05627D1A
.long 0xD3EE8060, 0x05827D1C
.long 0xD3EE8068, 0x05A27D1E
.long 0xD3EE8070, 0x05C27D20
.long 0xD3EE8078, 0x05E27D22
.long 0x808C0426
.long 0x828D0527
.long 0xBE86000C
.long 0x808C0828
.long 0x828D0929
.long 0xBE8A000C
.long 0xBF8C0F7B
.long 0xBF8A0000
.long 0xBF8CC67F
.long 0xD3EE8000, 0x04028124
.long 0xE0511000, 0x80020707
.long 0xD8EC4080, 0x1400000F
.long 0xD8EC4100, 0x1600000F
.long 0xD3EE8008, 0x04228126
.long 0xBF8CC67F
.long 0xD3EE8010, 0x04428128
.long 0xE0511100, 0x80020707
.long 0xD8EC4180, 0x1800000F
.long 0xD8EC4200, 0x1A00000F
.long 0xD3EE8018, 0x0462812A
.long 0xBF8CC67F
.long 0xD3EE8020, 0x0482812C
.long 0xE0511200, 0x80020707
.long 0xD8EC4280, 0x1C00000F
.long 0xD8EC4300, 0x1E00000F
.long 0xD3EE8028, 0x04A2812E
.long 0xBF8CC67F
.long 0xD3EE8030, 0x04C28130
.long 0xE0511300, 0x80020707
.long 0xD8EC4380, 0x2000000F
.long 0xD8EC4400, 0x2200000F
.long 0xD3EE8038, 0x04E28132
.long 0xBEFC0016
.long 0x80081508
.long 0x82098009
.long 0xD3EE8040, 0x05028524
.long 0xE05C1000, 0x80015006
.long 0xD3EE8048, 0x05228526
.long 0xD3EE8050, 0x05428528
.long 0x80041404
.long 0x82058005
.long 0xD3EE8058, 0x0562852A
.long 0xD3EE8060, 0x0582852C
.long 0xD3EE8068, 0x05A2852E
.long 0xD3EE8070, 0x05C28530
.long 0xD3EE8078, 0x05E28532
.long 0x81313831
.long 0xBF031731
.long 0xBF85014B
.long 0x814C384C
.long 0x818C494C
.long 0x810D814D
.long 0xBF03494C
.long 0xBECC020C
.long 0xBECD020D
.long 0x960D3631
.long 0x8F0E9F37
.long 0x920C0E31
.long 0x800C0D0C
.long 0x860EFF37, 0x7FFFFFFF
.long 0x8F330E0C
.long 0x92323433
.long 0x80B23231
.long 0xBF033534
.long 0x85463332
.long 0x85473233
.long 0xBF033849
.long 0xBEC6024C
.long 0xBEC7024D
.long 0xBE8F004B
.long 0x960D0F47
.long 0x920C0F47
.long 0x8F8C9F0C
.long 0x920D4A0C
.long 0x808D0D47
.long 0x920D490D
.long 0x800D460D
.long 0xBF09390C
.long 0xBE8F023B
.long 0x850E4A3A
.long 0x96470F0D
.long 0x92460F0D
.long 0x8FC69F46
.long 0x92470E46
.long 0x80C7470D
.long 0x920C4A0C
.long 0x80470C47
.long 0xBF033534
.long 0x85324746
.long 0x85334647
.long 0x8E0C8A32
.long 0x810C1A0C
.long 0x80040C40
.long 0x82058041
.long 0xBE8600FF, 0x80000000
.long 0x8E0C8A33
.long 0x800C1B0C
.long 0x80080C42
.long 0x82098043
.long 0xBE8A00FF, 0x80000000
.long 0xBF8C0F7B
.long 0xBF8A0000
.long 0xBF8CC67F
.long 0xD3EE8000, 0x04028914
.long 0xE0511000, 0x80020707
.long 0xD8EC50A0, 0x2400000F
.long 0xD8EC5120, 0x2600000F
.long 0xD3EE8008, 0x04228916
.long 0xBF8CC67F
.long 0xD3EE8010, 0x04428918
.long 0xE0511100, 0x80020707
.long 0xD8EC51A0, 0x2800000F
.long 0xD8EC5220, 0x2A00000F
.long 0xD3EE8018, 0x0462891A
.long 0xBF8CC67F
.long 0xD3EE8020, 0x0482891C
.long 0xE0511200, 0x80020707
.long 0xD8EC52A0, 0x2C00000F
.long 0xD8EC5320, 0x2E00000F
.long 0xD3EE8028, 0x04A2891E
.long 0xBF8CC67F
.long 0xD3EE8030, 0x04C28920
.long 0xE0511300, 0x80020707
.long 0xD8EC53A0, 0x3000000F
.long 0xD8EC5420, 0x3200000F
.long 0xD3EE8038, 0x04E28922
.long 0xB77C1020
.long 0x80081508
.long 0x82098009
.long 0xD3EE8040, 0x05028D14
.long 0xE05C1000, 0x80013406
.long 0xD3EE8048, 0x05228D16
.long 0xD3EE8050, 0x05428D18
.long 0x80041404
.long 0x82058005
.long 0xD3EE8058, 0x05628D1A
.long 0xD3EE8060, 0x05828D1C
.long 0xD3EE8068, 0x05A28D1E
.long 0xD3EE8070, 0x05C28D20
.long 0xD3EE8078, 0x05E28D22
.long 0xBF8C0F7B
.long 0xBF8A0000
.long 0xBF8CC67F
.long 0xD3EE8000, 0x04029124
.long 0xE0511000, 0x80020707
.long 0xD8EC60C0, 0x1400000F
.long 0xD8EC6140, 0x1600000F
.long 0xD3EE8008, 0x04229126
.long 0xBF8CC67F
.long 0xD3EE8010, 0x04429128
.long 0xE0511100, 0x80020707
.long 0xD8EC61C0, 0x1800000F
.long 0xD8EC6240, 0x1A00000F
.long 0xD3EE8018, 0x0462912A
.long 0xBF8CC67F
.long 0xD3EE8020, 0x0482912C
.long 0xE0511200, 0x80020707
.long 0xD8EC62C0, 0x1C00000F
.long 0xD8EC6340, 0x1E00000F
.long 0xD3EE8028, 0x04A2912E
.long 0xBF8CC67F
.long 0xD3EE8030, 0x04C29130
.long 0xE0511300, 0x80020707
.long 0xD8EC63C0, 0x2000000F
.long 0xD8EC6440, 0x2200000F
.long 0xD3EE8038, 0x04E29132
.long 0xB77C1020
.long 0x80081508
.long 0x82098009
.long 0xD3EE8040, 0x05029524
.long 0xE05C1000, 0x80013806
.long 0xD3EE8048, 0x05229526
.long 0xD3EE8050, 0x05429528
.long 0x80041404
.long 0x82058005
.long 0xD3EE8058, 0x0562952A
.long 0xD3EE8060, 0x0582952C
.long 0xD3EE8068, 0x05A2952E
.long 0xD3EE8070, 0x05C29530
.long 0xD3EE8078, 0x05E29532
.long 0xBF8C0F7B
.long 0xBF8A0000
.long 0xBF8CC67F
.long 0xD3EE8000, 0x04029914
.long 0xE0511000, 0x80020707
.long 0xD8EC70E0, 0x2400000F
.long 0xD8EC7160, 0x2600000F
.long 0xD3EE8008, 0x04229916
.long 0xBF8CC67F
.long 0xD3EE8010, 0x04429918
.long 0xE0511100, 0x80020707
.long 0xD8EC71E0, 0x2800000F
.long 0xD8EC7260, 0x2A00000F
.long 0xD3EE8018, 0x0462991A
.long 0xBF8CC67F
.long 0xD3EE8020, 0x0482991C
.long 0xE0511200, 0x80020707
.long 0xD8EC72E0, 0x2C00000F
.long 0xD8EC7360, 0x2E00000F
.long 0xD3EE8028, 0x04A2991E
.long 0xBF8CC67F
.long 0xD3EE8030, 0x04C29920
.long 0xE0511300, 0x80020707
.long 0xD8EC73E0, 0x3000000F
.long 0xD8EC7460, 0x3200000F
.long 0xD3EE8038, 0x04E29922
.long 0xB77C1020
.long 0x80081508
.long 0x82098009
.long 0xD3EE8040, 0x05029D14
.long 0xE05C1000, 0x80013C06
.long 0xD3EE8048, 0x05229D16
.long 0xD3EE8050, 0x05429D18
.long 0x80041404
.long 0x82058005
.long 0xD3EE8058, 0x05629D1A
.long 0xD3EE8060, 0x05829D1C
.long 0xD3EE8068, 0x05A29D1E
.long 0xD3EE8070, 0x05C29D20
.long 0xD3EE8078, 0x05E29D22
.long 0xBF8C0F7B
.long 0xBF8A0000
.long 0xBF8CC67F
.long 0xD3EE8000, 0x0402A124
.long 0xE0511000, 0x80020707
.long 0xD8EC0000, 0x1400000F
.long 0xD8EC0080, 0x1600000F
.long 0xD3EE8008, 0x0422A126
.long 0xBF8CC67F
.long 0xD3EE8010, 0x0442A128
.long 0xE0511100, 0x80020707
.long 0xD8EC0100, 0x1800000F
.long 0xD8EC0180, 0x1A00000F
.long 0xD3EE8018, 0x0462A12A
.long 0xBF8CC67F
.long 0xD3EE8020, 0x0482A12C
.long 0xE0511200, 0x80020707
.long 0xD8EC0200, 0x1C00000F
.long 0xD8EC0280, 0x1E00000F
.long 0xD3EE8028, 0x04A2A12E
.long 0xBF8CC67F
.long 0xD3EE8030, 0x04C2A130
.long 0xE0511300, 0x80020707
.long 0xD8EC0300, 0x2000000F
.long 0xD8EC0380, 0x2200000F
.long 0xD3EE8038, 0x04E2A132
.long 0xB77C1020
.long 0x80081508
.long 0x82098009
.long 0xD3EE8040, 0x0502A524
.long 0xE05C1000, 0x80014006
.long 0xD3EE8048, 0x0522A526
.long 0xD3EE8050, 0x0542A528
.long 0x80041404
.long 0x82058005
.long 0xD3EE8058, 0x0562A52A
.long 0xD3EE8060, 0x0582A52C
.long 0xD3EE8068, 0x05A2A52E
.long 0xD3EE8070, 0x05C2A530
.long 0xD3EE8078, 0x05E2A532
.long 0xBF8200C9
.long 0xBF8C0F7B
.long 0xBF8A0000
.long 0xBF8CC67F
.long 0xD3EE8000, 0x04028914
.long 0xD8EC50A0, 0x2400000F
.long 0xD8EC5120, 0x2600000F
.long 0xD3EE8008, 0x04228916
.long 0xBF8CC67F
.long 0xD3EE8010, 0x04428918
.long 0xD8EC51A0, 0x2800000F
.long 0xD8EC5220, 0x2A00000F
.long 0xD3EE8018, 0x0462891A
.long 0xBF8CC67F
.long 0xD3EE8020, 0x0482891C
.long 0xD8EC52A0, 0x2C00000F
.long 0xD8EC5320, 0x2E00000F
.long 0xD3EE8028, 0x04A2891E
.long 0xBF8CC67F
.long 0xD3EE8030, 0x04C28920
.long 0xD8EC53A0, 0x3000000F
.long 0xD8EC5420, 0x3200000F
.long 0xD3EE8038, 0x04E28922
.long 0xD3EE8040, 0x05028D14
.long 0xD3EE8048, 0x05228D16
.long 0xD3EE8050, 0x05428D18
.long 0xD3EE8058, 0x05628D1A
.long 0xD3EE8060, 0x05828D1C
.long 0xD3EE8068, 0x05A28D1E
.long 0xD3EE8070, 0x05C28D20
.long 0xD3EE8078, 0x05E28D22
.long 0xBF8C0F76
.long 0xBF8A0000
.long 0xBF8CC67F
.long 0xD3EE8000, 0x04029124
.long 0xD8EC60C0, 0x1400000F
.long 0xD8EC6140, 0x1600000F
.long 0xD3EE8008, 0x04229126
.long 0xBF8CC67F
.long 0xD3EE8010, 0x04429128
.long 0xD8EC61C0, 0x1800000F
.long 0xD8EC6240, 0x1A00000F
.long 0xD3EE8018, 0x0462912A
.long 0xBF8CC67F
.long 0xD3EE8020, 0x0482912C
.long 0xD8EC62C0, 0x1C00000F
.long 0xD8EC6340, 0x1E00000F
.long 0xD3EE8028, 0x04A2912E
.long 0xBF8CC67F
.long 0xD3EE8030, 0x04C29130
.long 0xD8EC63C0, 0x2000000F
.long 0xD8EC6440, 0x2200000F
.long 0xD3EE8038, 0x04E29132
.long 0xD3EE8040, 0x05029524
.long 0xD3EE8048, 0x05229526
.long 0xD3EE8050, 0x05429528
.long 0xD3EE8058, 0x0562952A
.long 0xD3EE8060, 0x0582952C
.long 0xD3EE8068, 0x05A2952E
.long 0xD3EE8070, 0x05C29530
.long 0xD3EE8078, 0x05E29532
.long 0xBF8C0F71
.long 0xBF8A0000
.long 0xBF8CC67F
.long 0xD3EE8000, 0x04029914
.long 0xD8EC70E0, 0x2400000F
.long 0xD8EC7160, 0x2600000F
.long 0xD3EE8008, 0x04229916
.long 0xBF8CC67F
.long 0xD3EE8010, 0x04429918
.long 0xD8EC71E0, 0x2800000F
.long 0xD8EC7260, 0x2A00000F
.long 0xD3EE8018, 0x0462991A
.long 0xBF8CC67F
.long 0xD3EE8020, 0x0482991C
.long 0xD8EC72E0, 0x2C00000F
.long 0xD8EC7360, 0x2E00000F
.long 0xD3EE8028, 0x04A2991E
.long 0xBF8CC67F
.long 0xD3EE8030, 0x04C29920
.long 0xD8EC73E0, 0x3000000F
.long 0xD8EC7460, 0x3200000F
.long 0xD3EE8038, 0x04E29922
.long 0xD3EE8040, 0x05029D14
.long 0xD3EE8048, 0x05229D16
.long 0xD3EE8050, 0x05429D18
.long 0xD3EE8058, 0x05629D1A
.long 0xD3EE8060, 0x05829D1C
.long 0xD3EE8068, 0x05A29D1E
.long 0xD3EE8070, 0x05C29D20
.long 0xD3EE8078, 0x05E29D22
.long 0xBF8C0F70
.long 0xBF8A0000
.long 0xBF8CC67F
.long 0xD3EE8000, 0x0402A124
.long 0xD3EE8008, 0x0422A126
.long 0xBF8CC47F
.long 0xD3EE8010, 0x0442A128
.long 0xD3EE8018, 0x0462A12A
.long 0xBF8CC27F
.long 0xD3EE8020, 0x0482A12C
.long 0xD3EE8028, 0x04A2A12E
.long 0xBF8CC07F
.long 0xD3EE8030, 0x04C2A130
.long 0xD3EE8038, 0x04E2A132
.long 0xD3EE8040, 0x0502A524
.long 0xD3EE8048, 0x0522A526
.long 0xD3EE8050, 0x0542A528
.long 0xD3EE8058, 0x0562A52A
.long 0xD3EE8060, 0x0582A52C
.long 0xD3EE8068, 0x05A2A52E
.long 0xD3EE8070, 0x05C2A530
.long 0xD3EE8078, 0x05E2A532
.long 0xBF8222AA
.long 0xBE9C007C
.long 0x860C811F
.long 0xB10C0001
.long 0xBF851476
.long 0xBE9D0080
.long 0xBE9E0080
.long 0x8010443E
.long 0x8211453F
.long 0xBEFC001C
.long 0xBF8C0F7B
.long 0xBF8A0000
.long 0xBF8CC67F
.long 0xD3EE8080, 0x06026914
.long 0xD8EC1020, 0x2400000F
.long 0xD8EC10A0, 0x2600000F
.long 0xE0511000, 0x80020707
.long 0xD3EE8088, 0x06226916
.long 0xBF8CC67F
.long 0xD3EE8090, 0x06426918
.long 0xD8EC1120, 0x2800000F
.long 0xD8EC11A0, 0x2A00000F
.long 0xE0511100, 0x80020707
.long 0xD3EE8098, 0x0662691A
.long 0xBF8CC67F
.long 0xD3EE80A0, 0x0682691C
.long 0xD8EC1220, 0x2C00000F
.long 0xD8EC12A0, 0x2E00000F
.long 0xE0511200, 0x80020707
.long 0xD3EE80A8, 0x06A2691E
.long 0xBF8CC67F
.long 0xD3EE80B0, 0x06C26920
.long 0xD8EC1320, 0x3000000F
.long 0xD8EC13A0, 0x3200000F
.long 0xE0511300, 0x80020707
.long 0xD3EE80B8, 0x06E26922
.long 0xD3EE80C0, 0x07026D14
.long 0xE05C1000, 0x80014406
.long 0xD3EE80C8, 0x07226D16
.long 0xB71C1020
.long 0x80081508
.long 0x82098009
.long 0xD3EE80D0, 0x07426D18
.long 0x80041404
.long 0x82058005
.long 0xD3EE80D8, 0x07626D1A
.long 0xD3EE80E0, 0x07826D1C
.long 0xE05C1000, 0x80045408
.long 0xD3EE80E8, 0x07A26D1E
.long 0xD3EE80F0, 0x07C26D20
.long 0xD3EE80F8, 0x07E26D22
.long 0xBEFC001C
.long 0xBF8C0F7C
.long 0xBF8A0000
.long 0xBF8CC67F
.long 0xD3EE8080, 0x06027124
.long 0xD8EC2040, 0x1400000F
.long 0xD8EC20C0, 0x1600000F
.long 0xE0511000, 0x80020707
.long 0xD3EE8088, 0x06227126
.long 0xBF8CC67F
.long 0xD3EE8090, 0x06427128
.long 0xD8EC2140, 0x1800000F
.long 0xD8EC21C0, 0x1A00000F
.long 0xE0511100, 0x80020707
.long 0xD3EE8098, 0x0662712A
.long 0xBF8CC67F
.long 0xD3EE80A0, 0x0682712C
.long 0xD8EC2240, 0x1C00000F
.long 0xD8EC22C0, 0x1E00000F
.long 0xE0511200, 0x80020707
.long 0xD3EE80A8, 0x06A2712E
.long 0xBF8CC67F
.long 0xD3EE80B0, 0x06C27130
.long 0xD8EC2340, 0x2000000F
.long 0xD8EC23C0, 0x2200000F
.long 0xE0511300, 0x80020707
.long 0xD3EE80B8, 0x06E27132
.long 0xD3EE80C0, 0x07027524
.long 0xE05C1000, 0x80014806
.long 0xD3EE80C8, 0x07227526
.long 0xB71C1020
.long 0x80081508
.long 0x82098009
.long 0xD3EE80D0, 0x07427528
.long 0x80041404
.long 0x82058005
.long 0xD3EE80D8, 0x0762752A
.long 0xD3EE80E0, 0x0782752C
.long 0xD3EE80E8, 0x07A2752E
.long 0xD3EE80F0, 0x07C27530
.long 0xD3EE80F8, 0x07E27532
.long 0xBEFC001C
.long 0xBF8C0F7C
.long 0xBF8A0000
.long 0xBF8CC67F
.long 0xD3EE8080, 0x06027914
.long 0xD8EC3060, 0x2400000F
.long 0xD8EC30E0, 0x2600000F
.long 0xE0511000, 0x80020707
.long 0xD3EE8088, 0x06227916
.long 0xBF8CC67F
.long 0xD3EE8090, 0x06427918
.long 0xD8EC3160, 0x2800000F
.long 0xD8EC31E0, 0x2A00000F
.long 0xE0511100, 0x80020707
.long 0xD3EE8098, 0x0662791A
.long 0xBF8CC67F
.long 0xD3EE80A0, 0x0682791C
.long 0xD8EC3260, 0x2C00000F
.long 0xD8EC32E0, 0x2E00000F
.long 0xE0511200, 0x80020707
.long 0xD3EE80A8, 0x06A2791E
.long 0xBF8CC67F
.long 0xD3EE80B0, 0x06C27920
.long 0xD8EC3360, 0x3000000F
.long 0xD8EC33E0, 0x3200000F
.long 0xE0511300, 0x80020707
.long 0xD3EE80B8, 0x06E27922
.long 0xD3EE80C0, 0x07027D14
.long 0xE05C1000, 0x80014C06
.long 0xD3EE80C8, 0x07227D16
.long 0xB71C1020
.long 0x80081508
.long 0x82098009
.long 0xD3EE80D0, 0x07427D18
.long 0x80041404
.long 0x82058005
.long 0xD3EE80D8, 0x07627D1A
.long 0xBF11011E
.long 0xD3D84010, 0x18000100
.long 0xD3D84011, 0x18000101
.long 0xD3D84012, 0x18000140
.long 0xD3D84013, 0x18000141
.long 0xBF800001
.long 0xBF9C0000
.long 0xBF8C0F7A
.long 0xD2800010, 0x2002A910
.long 0xD2800012, 0x2002AD12
.long 0xD3EE80E0, 0x07827D1C
.long 0xE07C1000, 0x80041008
.long 0xD3EE80E8, 0x07A27D1E
.long 0x80101910
.long 0x82118011
.long 0xD3EE80F0, 0x07C27D20
.long 0x80921912
.long 0xBE920280
.long 0xD3EE80F8, 0x07E27D22
.long 0xBEFC001C
.long 0xBF8C0F7D
.long 0xBF8A0000
.long 0xBF8CC67F
.long 0xD3EE8080, 0x06028124
.long 0xD8EC4080, 0x1400000F
.long 0xD8EC4100, 0x1600000F
.long 0xE0511000, 0x80020707
.long 0xD3EE8088, 0x06228126
.long 0xBF8CC67F
.long 0xD3EE8090, 0x06428128
.long 0xD8EC4180, 0x1800000F
.long 0xD8EC4200, 0x1A00000F
.long 0xE0511100, 0x80020707
.long 0xD3EE8098, 0x0662812A
.long 0xBF8CC67F
.long 0xD3EE80A0, 0x0682812C
.long 0xD8EC4280, 0x1C00000F
.long 0xD8EC4300, 0x1E00000F
.long 0xE0511200, 0x80020707
.long 0xD3EE80A8, 0x06A2812E
.long 0xBF8CC67F
.long 0xD3EE80B0, 0x06C28130
.long 0xD8EC4380, 0x2000000F
.long 0xD8EC4400, 0x2200000F
.long 0xE0511300, 0x80020707
.long 0xD3EE80B8, 0x06E28132
.long 0xD3EE80C0, 0x07028524
.long 0xE05C1000, 0x80015006
.long 0xD3EE80C8, 0x07228526
.long 0xBE9C0016
.long 0x80081508
.long 0x82098009
.long 0xD3EE80D0, 0x07428528
.long 0x80041404
.long 0x82058005
.long 0xD3EE80D8, 0x0762852A
.long 0xD3EE80E0, 0x0782852C
.long 0xD3EE80E8, 0x07A2852E
.long 0xD3EE80F0, 0x07C28530
.long 0xD3EE80F8, 0x07E28532
.long 0xBEFC001C
.long 0xBF8C0F7C
.long 0xBF8A0000
.long 0xBF8CC67F
.long 0xD3EE8080, 0x06028914
.long 0xD8EC50A0, 0x2400000F
.long 0xD8EC5120, 0x2600000F
.long 0xE0511000, 0x80020707
.long 0xD3EE8088, 0x06228916
.long 0xBF8CC67F
.long 0xD3EE8090, 0x06428918
.long 0xD8EC51A0, 0x2800000F
.long 0xD8EC5220, 0x2A00000F
.long 0xE0511100, 0x80020707
.long 0xD3EE8098, 0x0662891A
.long 0xBF8CC67F
.long 0xD3EE80A0, 0x0682891C
.long 0xD8EC52A0, 0x2C00000F
.long 0xD8EC5320, 0x2E00000F
.long 0xE0511200, 0x80020707
.long 0xD3EE80A8, 0x06A2891E
.long 0xBF8CC67F
.long 0xD3EE80B0, 0x06C28920
.long 0xD8EC53A0, 0x3000000F
.long 0xD8EC5420, 0x3200000F
.long 0xE0511300, 0x80020707
.long 0xD3EE80B8, 0x06E28922
.long 0xD3EE80C0, 0x07028D14
.long 0xE05C1000, 0x80013406
.long 0xD3EE80C8, 0x07228D16
.long 0xB71C1020
.long 0x80081508
.long 0x82098009
.long 0xD3EE80D0, 0x07428D18
.long 0x80041404
.long 0x82058005
.long 0xD3EE80D8, 0x07628D1A
.long 0xD3EE80E0, 0x07828D1C
.long 0xE05C1000, 0x80045808
.long 0xD3EE80E8, 0x07A28D1E
.long 0xD3EE80F0, 0x07C28D20
.long 0xD3EE80F8, 0x07E28D22
.long 0xBEFC001C
.long 0xBF8C0F7D
.long 0xBF8A0000
.long 0xBF8CC67F
.long 0xD3EE8080, 0x06029124
.long 0xD8EC60C0, 0x1400000F
.long 0xD8EC6140, 0x1600000F
.long 0xE0511000, 0x80020707
.long 0xD3EE8088, 0x06229126
.long 0xBF8CC67F
.long 0xD3EE8090, 0x06429128
.long 0xD8EC61C0, 0x1800000F
.long 0xD8EC6240, 0x1A00000F
.long 0xE0511100, 0x80020707
.long 0xD3EE8098, 0x0662912A
.long 0xBF8CC67F
.long 0xD3EE80A0, 0x0682912C
.long 0xD8EC62C0, 0x1C00000F
.long 0xD8EC6340, 0x1E00000F
.long 0xE0511200, 0x80020707
.long 0xD3EE80A8, 0x06A2912E
.long 0xBF8CC67F
.long 0xD3EE80B0, 0x06C29130
.long 0xD8EC63C0, 0x2000000F
.long 0xD8EC6440, 0x2200000F
.long 0xE0511300, 0x80020707
.long 0xD3EE80B8, 0x06E29132
.long 0xD3EE80C0, 0x07029524
.long 0xE05C1000, 0x80013806
.long 0xD3EE80C8, 0x07229526
.long 0xB71C1020
.long 0x80081508
.long 0x82098009
.long 0xD3EE80D0, 0x07429528
.long 0x80041404
.long 0x82058005
.long 0xD3EE80D8, 0x0762952A
.long 0xD3EE80E0, 0x0782952C
.long 0xD3EE80E8, 0x07A2952E
.long 0xD3EE80F0, 0x07C29530
.long 0xD3EE80F8, 0x07E29532
.long 0xBEFC001C
.long 0xBF8C0F7C
.long 0xBF8A0000
.long 0xBF8CC67F
.long 0xD3EE8080, 0x06029914
.long 0xD8EC70E0, 0x2400000F
.long 0xD8EC7160, 0x2600000F
.long 0xE0511000, 0x80020707
.long 0xD3EE8088, 0x06229916
.long 0xBF8CC67F
.long 0xD3EE8090, 0x06429918
.long 0xD8EC71E0, 0x2800000F
.long 0xD8EC7260, 0x2A00000F
.long 0xE0511100, 0x80020707
.long 0xD3EE8098, 0x0662991A
.long 0xBF8CC67F
.long 0xD3EE80A0, 0x0682991C
.long 0xD8EC72E0, 0x2C00000F
.long 0xD8EC7360, 0x2E00000F
.long 0xE0511200, 0x80020707
.long 0xD3EE80A8, 0x06A2991E
.long 0xBF8CC67F
.long 0xD3EE80B0, 0x06C29920
.long 0xD8EC73E0, 0x3000000F
.long 0xD8EC7460, 0x3200000F
.long 0xE0511300, 0x80020707
.long 0xD3EE80B8, 0x06E29922
.long 0xD3EE80C0, 0x07029D14
.long 0xE05C1000, 0x80013C06
.long 0xD3EE80C8, 0x07229D16
.long 0xB71C1020
.long 0x80081508
.long 0x82098009
.long 0xD3EE80D0, 0x07429D18
.long 0x80041404
.long 0x82058005
.long 0xD3EE80D8, 0x07629D1A
.long 0xBF11011E
.long 0xD3D84010, 0x18000102
.long 0xD3D84011, 0x18000103
.long 0xD3D84012, 0x18000142
.long 0xD3D84013, 0x18000143
.long 0xBF800001
.long 0xBF9C0000
.long 0xBF8C0F7A
.long 0xD2800010, 0x2002B110
.long 0xD2800012, 0x2002B512
.long 0xD3EE80E0, 0x07829D1C
.long 0xE07C1000, 0x80041008
.long 0xD3EE80E8, 0x07A29D1E
.long 0x80101910
.long 0x82118011
.long 0xD3EE80F0, 0x07C29D20
.long 0x80921912
.long 0xBE920280
.long 0xD3EE80F8, 0x07E29D22
.long 0xBEFC001C
.long 0xBF8C0F7D
.long 0xBF8A0000
.long 0xBF8CC67F
.long 0xD3EE8080, 0x0602A124
.long 0xD8EC0000, 0x1400000F
.long 0xD8EC0080, 0x1600000F
.long 0xE0511000, 0x80020707
.long 0xD3EE8088, 0x0622A126
.long 0xBF8CC67F
.long 0xD3EE8090, 0x0642A128
.long 0xD8EC0100, 0x1800000F
.long 0xD8EC0180, 0x1A00000F
.long 0xE0511100, 0x80020707
.long 0xD3EE8098, 0x0662A12A
.long 0xBF8CC67F
.long 0xD3EE80A0, 0x0682A12C
.long 0xD8EC0200, 0x1C00000F
.long 0xD8EC0280, 0x1E00000F
.long 0xE0511200, 0x80020707
.long 0xD3EE80A8, 0x06A2A12E
.long 0xBF8CC67F
.long 0xD3EE80B0, 0x06C2A130
.long 0xD8EC0300, 0x2000000F
.long 0xD8EC0380, 0x2200000F
.long 0xE0511300, 0x80020707
.long 0xD3EE80B8, 0x06E2A132
.long 0xD3EE80C0, 0x0702A524
.long 0xE05C1000, 0x80014006
.long 0xD3EE80C8, 0x0722A526
.long 0xB71C1020
.long 0x80081508
.long 0x82098009
.long 0xD3EE80D0, 0x0742A528
.long 0x80041404
.long 0x82058005
.long 0xD3EE80D8, 0x0762A52A
.long 0xD3EE80E0, 0x0782A52C
.long 0xD3EE80E8, 0x07A2A52E
.long 0xD3EE80F0, 0x07C2A530
.long 0xD3EE80F8, 0x07E2A532
.long 0xB71E0004
.long 0xB71D0008
.long 0xB31D0078
.long 0xBF85FD9C
.long 0xBEFC001C
.long 0xBF8C0F7C
.long 0xBF8A0000
.long 0xBF8CC67F
.long 0xD3EE8080, 0x06026914
.long 0xD8EC1020, 0x2400000F
.long 0xD8EC10A0, 0x2600000F
.long 0xE0511000, 0x80020707
.long 0xD3EE8088, 0x06226916
.long 0xBF8CC67F
.long 0xD3EE8090, 0x06426918
.long 0xD8EC1120, 0x2800000F
.long 0xD8EC11A0, 0x2A00000F
.long 0xE0511100, 0x80020707
.long 0xD3EE8098, 0x0662691A
.long 0xBF8CC67F
.long 0xD3EE80A0, 0x0682691C
.long 0xD8EC1220, 0x2C00000F
.long 0xD8EC12A0, 0x2E00000F
.long 0xE0511200, 0x80020707
.long 0xD3EE80A8, 0x06A2691E
.long 0xBF8CC67F
.long 0xD3EE80B0, 0x06C26920
.long 0xD8EC1320, 0x3000000F
.long 0xD8EC13A0, 0x3200000F
.long 0xE0511300, 0x80020707
.long 0xD3EE80B8, 0x06E26922
.long 0xB71C1020
.long 0xD3EE80C0, 0x07026D14
.long 0xE05C1000, 0x80014406
.long 0xD3EE80C8, 0x07226D16
.long 0x80081508
.long 0x82098009
.long 0xD3EE80D0, 0x07426D18
.long 0x80041404
.long 0x82058005
.long 0xD3EE80D8, 0x07626D1A
.long 0xD3EE80E0, 0x07826D1C
.long 0xE05C1000, 0x80045408
.long 0xD3EE80E8, 0x07A26D1E
.long 0xD3EE80F0, 0x07C26D20
.long 0xD3EE80F8, 0x07E26D22
.long 0xBEFC001C
.long 0xBF8C0F7D
.long 0xBF8A0000
.long 0xBF8CC67F
.long 0xD3EE8080, 0x06027124
.long 0xD8EC2040, 0x1400000F
.long 0xD8EC20C0, 0x1600000F
.long 0xE0511000, 0x80020707
.long 0xD3EE8088, 0x06227126
.long 0xBF8CC67F
.long 0xD3EE8090, 0x06427128
.long 0xD8EC2140, 0x1800000F
.long 0xD8EC21C0, 0x1A00000F
.long 0xE0511100, 0x80020707
.long 0xD3EE8098, 0x0662712A
.long 0xBF8CC67F
.long 0xD3EE80A0, 0x0682712C
.long 0xD8EC2240, 0x1C00000F
.long 0xD8EC22C0, 0x1E00000F
.long 0xE0511200, 0x80020707
.long 0xD3EE80A8, 0x06A2712E
.long 0xBF8CC67F
.long 0xD3EE80B0, 0x06C27130
.long 0xD8EC2340, 0x2000000F
.long 0xD8EC23C0, 0x2200000F
.long 0xE0511300, 0x80020707
.long 0xD3EE80B8, 0x06E27132
.long 0xB71C1020
.long 0xD3EE80C0, 0x07027524
.long 0xE05C1000, 0x80014806
.long 0xD3EE80C8, 0x07227526
.long 0x80081508
.long 0x82098009
.long 0xD3EE80D0, 0x07427528
.long 0x80041404
.long 0x82058005
.long 0xD3EE80D8, 0x0762752A
.long 0xD3EE80E0, 0x0782752C
.long 0xD3EE80E8, 0x07A2752E
.long 0xD3EE80F0, 0x07C27530
.long 0xD3EE80F8, 0x07E27532
.long 0xBEFC001C
.long 0xBF8C0F7C
.long 0xBF8A0000
.long 0xBF8CC67F
.long 0xD3EE8080, 0x06027914
.long 0xD8EC3060, 0x2400000F
.long 0xD8EC30E0, 0x2600000F
.long 0xE0511000, 0x80020707
.long 0xD3EE8088, 0x06227916
.long 0xBF8CC67F
.long 0xD3EE8090, 0x06427918
.long 0xD8EC3160, 0x2800000F
.long 0xD8EC31E0, 0x2A00000F
.long 0xE0511100, 0x80020707
.long 0xD3EE8098, 0x0662791A
.long 0xBF8CC67F
.long 0xD3EE80A0, 0x0682791C
.long 0xD8EC3260, 0x2C00000F
.long 0xD8EC32E0, 0x2E00000F
.long 0xE0511200, 0x80020707
.long 0xD3EE80A8, 0x06A2791E
.long 0xBF8CC67F
.long 0xD3EE80B0, 0x06C27920
.long 0xD8EC3360, 0x3000000F
.long 0xD8EC33E0, 0x3200000F
.long 0xE0511300, 0x80020707
.long 0xD3EE80B8, 0x06E27922
.long 0xB71C1020
.long 0xD3EE80C0, 0x07027D14
.long 0xE05C1000, 0x80014C06
.long 0xD3EE80C8, 0x07227D16
.long 0x80081508
.long 0x82098009
.long 0xD3EE80D0, 0x07427D18
.long 0x80041404
.long 0x82058005
.long 0xD3EE80D8, 0x07627D1A
.long 0xD3D84010, 0x1800013C
.long 0xD3D84011, 0x1800013D
.long 0xD3D84012, 0x1800017C
.long 0xD3D84013, 0x1800017D
.long 0xBF800001
.long 0xBF8C0F7A
.long 0xD2800010, 0x2002A910
.long 0xD2800012, 0x2002AD12
.long 0xD3EE80E0, 0x07827D1C
.long 0xE07C1000, 0x80041008
.long 0xD3EE80E8, 0x07A27D1E
.long 0x80101910
.long 0x82118011
.long 0xD3EE80F0, 0x07C27D20
.long 0x80921912
.long 0xBE920280
.long 0xD3EE80F8, 0x07E27D22
.long 0x808C0426
.long 0x828D0527
.long 0xBE86000C
.long 0x808C0828
.long 0x828D0929
.long 0xBE8A000C
.long 0xBEFC001C
.long 0xBF8C0F7D
.long 0xBF8A0000
.long 0xBF8CC67F
.long 0xD3EE8080, 0x06028124
.long 0xD8EC4080, 0x1400000F
.long 0xD8EC4100, 0x1600000F
.long 0xE0511000, 0x80020707
.long 0xD3EE8088, 0x06228126
.long 0xBF8CC67F
.long 0xD3EE8090, 0x06428128
.long 0xD8EC4180, 0x1800000F
.long 0xD8EC4200, 0x1A00000F
.long 0xE0511100, 0x80020707
.long 0xD3EE8098, 0x0662812A
.long 0xBF8CC67F
.long 0xD3EE80A0, 0x0682812C
.long 0xD8EC4280, 0x1C00000F
.long 0xD8EC4300, 0x1E00000F
.long 0xE0511200, 0x80020707
.long 0xD3EE80A8, 0x06A2812E
.long 0xBF8CC67F
.long 0xD3EE80B0, 0x06C28130
.long 0xD8EC4380, 0x2000000F
.long 0xD8EC4400, 0x2200000F
.long 0xE0511300, 0x80020707
.long 0xD3EE80B8, 0x06E28132
.long 0xBE9C0016
.long 0xD3EE80C0, 0x07028524
.long 0xE05C1000, 0x80015006
.long 0xD3EE80C8, 0x07228526
.long 0xD3EE80D0, 0x07428528
.long 0xD3EE80D8, 0x0762852A
.long 0xD3EE80E0, 0x0782852C
.long 0xD3EE80E8, 0x07A2852E
.long 0xD3EE80F0, 0x07C28530
.long 0xD3EE80F8, 0x07E28532
.long 0xB00C0100
.long 0x920F320C
.long 0x920EFF18, 0x00000080
.long 0x920C330E
.long 0x960D330E
.long 0x800C0F0C
.long 0x820D800D
.long 0x8E8C820C
.long 0x920E30FF, 0x00000100
.long 0x803E0E0C
.long 0x823F800D
.long 0x80A40C2A
.long 0x82A50D2B
.long 0x924EFF32, 0x00000080
.long 0x80CE4E1F
.long 0x81313831
.long 0xBF031731
.long 0xBF850882
.long 0x814C384C
.long 0x818C494C
.long 0x810D814D
.long 0xBF03494C
.long 0xBECC020C
.long 0xBECD020D
.long 0x960D3631
.long 0x8F0E9F37
.long 0x920C0E31
.long 0x800C0D0C
.long 0x860EFF37, 0x7FFFFFFF
.long 0x8F330E0C
.long 0x92323433
.long 0x80B23231
.long 0xBF033534
.long 0x85463332
.long 0x85473233
.long 0xBF033849
.long 0xBEC6024C
.long 0xBEC7024D
.long 0xBE8F004B
.long 0x960D0F47
.long 0x920C0F47
.long 0x8F8C9F0C
.long 0x920D4A0C
.long 0x808D0D47
.long 0x920D490D
.long 0x800D460D
.long 0xBF09390C
.long 0xBE8F023B
.long 0x850E4A3A
.long 0x96470F0D
.long 0x92460F0D
.long 0x8FC69F46
.long 0x92470E46
.long 0x80C7470D
.long 0x920C4A0C
.long 0x80470C47
.long 0xBF033534
.long 0x85324746
.long 0x85334647
.long 0x8E0C8A32
.long 0x810C1A0C
.long 0x80040C40
.long 0x82058041
.long 0xBE8600FF, 0x80000000
.long 0x8E0C8A33
.long 0x800C1B0C
.long 0x80080C42
.long 0x82098043
.long 0xBE8A00FF, 0x80000000
.long 0xBEFC001C
.long 0xBF8C0F7C
.long 0xBF8A0000
.long 0xBF8CC67F
.long 0xD3EE8080, 0x06028914
.long 0xD8EC50A0, 0x2400000F
.long 0xD8EC5120, 0x2600000F
.long 0xE0511000, 0x80020707
.long 0xD3EE8088, 0x06228916
.long 0xBF8CC67F
.long 0xD3EE8090, 0x06428918
.long 0xD8EC51A0, 0x2800000F
.long 0xD8EC5220, 0x2A00000F
.long 0xE0511100, 0x80020707
.long 0xD3EE8098, 0x0662891A
.long 0xBF8CC67F
.long 0xD3EE80A0, 0x0682891C
.long 0xD8EC52A0, 0x2C00000F
.long 0xD8EC5320, 0x2E00000F
.long 0xE0511200, 0x80020707
.long 0xD3EE80A8, 0x06A2891E
.long 0xBF8CC67F
.long 0xD3EE80B0, 0x06C28920
.long 0xD8EC53A0, 0x3000000F
.long 0xD8EC5420, 0x3200000F
.long 0xE0511300, 0x80020707
.long 0xD3EE80B8, 0x06E28922
.long 0xB71C1020
.long 0xD3EE80C0, 0x07028D14
.long 0xE05C1000, 0x80013406
.long 0xD3EE80C8, 0x07228D16
.long 0x80081508
.long 0x82098009
.long 0xD3EE80D0, 0x07428D18
.long 0x80041404
.long 0x82058005
.long 0xD3EE80D8, 0x07628D1A
.long 0xD3EE80E0, 0x07828D1C
.long 0xE05C1000, 0x80045808
.long 0xD3EE80E8, 0x07A28D1E
.long 0xD3EE80F0, 0x07C28D20
.long 0xD3EE80F8, 0x07E28D22
.long 0xBEFC001C
.long 0xBF8C0F7D
.long 0xBF8A0000
.long 0xBF8CC67F
.long 0xD3EE8080, 0x06029124
.long 0xD8EC60C0, 0x1400000F
.long 0xD8EC6140, 0x1600000F
.long 0xE0511000, 0x80020707
.long 0xD3EE8088, 0x06229126
.long 0xBF8CC67F
.long 0xD3EE8090, 0x06429128
.long 0xD8EC61C0, 0x1800000F
.long 0xD8EC6240, 0x1A00000F
.long 0xE0511100, 0x80020707
.long 0xD3EE8098, 0x0662912A
.long 0xBF8CC67F
.long 0xD3EE80A0, 0x0682912C
.long 0xD8EC62C0, 0x1C00000F
.long 0xD8EC6340, 0x1E00000F
.long 0xE0511200, 0x80020707
.long 0xD3EE80A8, 0x06A2912E
.long 0xBF8CC67F
.long 0xD3EE80B0, 0x06C29130
.long 0xD8EC63C0, 0x2000000F
.long 0xD8EC6440, 0x2200000F
.long 0xE0511300, 0x80020707
.long 0xD3EE80B8, 0x06E29132
.long 0xB71C1020
.long 0xD3EE80C0, 0x07029524
.long 0xE05C1000, 0x80013806
.long 0xD3EE80C8, 0x07229526
.long 0x80081508
.long 0x82098009
.long 0xD3EE80D0, 0x07429528
.long 0x80041404
.long 0x82058005
.long 0xD3EE80D8, 0x0762952A
.long 0xD3EE80E0, 0x0782952C
.long 0xD3EE80E8, 0x07A2952E
.long 0xD3EE80F0, 0x07C29530
.long 0xD3EE80F8, 0x07E29532
.long 0xBEFC001C
.long 0xBF8C0F7C
.long 0xBF8A0000
.long 0xBF8CC67F
.long 0xD3EE8080, 0x06029914
.long 0xD8EC70E0, 0x2400000F
.long 0xD8EC7160, 0x2600000F
.long 0xE0511000, 0x80020707
.long 0xD3EE8088, 0x06229916
.long 0xBF8CC67F
.long 0xD3EE8090, 0x06429918
.long 0xD8EC71E0, 0x2800000F
.long 0xD8EC7260, 0x2A00000F
.long 0xE0511100, 0x80020707
.long 0xD3EE8098, 0x0662991A
.long 0xBF8CC67F
.long 0xD3EE80A0, 0x0682991C
.long 0xD8EC72E0, 0x2C00000F
.long 0xD8EC7360, 0x2E00000F
.long 0xE0511200, 0x80020707
.long 0xD3EE80A8, 0x06A2991E
.long 0xBF8CC67F
.long 0xD3EE80B0, 0x06C29920
.long 0xD8EC73E0, 0x3000000F
.long 0xD8EC7460, 0x3200000F
.long 0xE0511300, 0x80020707
.long 0xD3EE80B8, 0x06E29922
.long 0xB71C1020
.long 0xD3EE80C0, 0x07029D14
.long 0xE05C1000, 0x80013C06
.long 0xD3EE80C8, 0x07229D16
.long 0x80081508
.long 0x82098009
.long 0xD3EE80D0, 0x07429D18
.long 0x80041404
.long 0x82058005
.long 0xD3EE80D8, 0x07629D1A
.long 0xD3D84010, 0x1800013E
.long 0xD3D84011, 0x1800013F
.long 0xD3D84012, 0x1800017E
.long 0xD3D84013, 0x1800017F
.long 0xBF800001
.long 0xBF8C0F7A
.long 0xD2800010, 0x2002B110
.long 0xD2800012, 0x2002B512
.long 0xD3EE80E0, 0x07829D1C
.long 0xE07C1000, 0x80041008
.long 0xD3EE80E8, 0x07A29D1E
.long 0xD3EE80F0, 0x07C29D20
.long 0xD3EE80F8, 0x07E29D22
.long 0xBEFC001C
.long 0xBF8C0F7D
.long 0xBF8A0000
.long 0xBF8CC67F
.long 0xD3EE8080, 0x0602A124
.long 0xD8EC0000, 0x1400000F
.long 0xD8EC0080, 0x1600000F
.long 0xE0511000, 0x80020707
.long 0xD3EE8088, 0x0622A126
.long 0xBF8CC67F
.long 0xD3EE8090, 0x0642A128
.long 0xD8EC0100, 0x1800000F
.long 0xD8EC0180, 0x1A00000F
.long 0xE0511100, 0x80020707
.long 0xD3EE8098, 0x0662A12A
.long 0xBF8CC67F
.long 0xD3EE80A0, 0x0682A12C
.long 0xD8EC0200, 0x1C00000F
.long 0xD8EC0280, 0x1E00000F
.long 0xE0511200, 0x80020707
.long 0xD3EE80A8, 0x06A2A12E
.long 0xBF8CC67F
.long 0xD3EE80B0, 0x06C2A130
.long 0xD8EC0300, 0x2000000F
.long 0xD8EC0380, 0x2200000F
.long 0xE0511300, 0x80020707
.long 0xD3EE80B8, 0x06E2A132
.long 0xB71C1020
.long 0xD3EE80C0, 0x0702A524
.long 0xE05C1000, 0x80014006
.long 0xD3EE80C8, 0x0722A526
.long 0x80081508
.long 0x82098009
.long 0xD3EE80D0, 0x0742A528
.long 0x80041404
.long 0x82058005
.long 0xD3EE80D8, 0x0762A52A
.long 0xD3EE80E0, 0x0782A52C
.long 0xD3EE80E8, 0x07A2A52E
.long 0xD3EE80F0, 0x07C2A530
.long 0xD3EE80F8, 0x07E2A532
.long 0xBE9200FF, 0x80000000
.long 0xBF091224
.long 0x850C2412
.long 0xBF068025
.long 0xBE92020C
.long 0xD0C9000C, 0x00009D0A
.long 0xD1000008, 0x0032190E
.long 0xD3D94000, 0x18000080
.long 0xD3D94001, 0x18000080
.long 0xD3D94002, 0x18000080
.long 0xD3D94003, 0x18000080
.long 0xD3D94004, 0x18000080
.long 0xD3D94005, 0x18000080
.long 0xD3D94006, 0x18000080
.long 0xD3D94007, 0x18000080
.long 0xD3D94008, 0x18000080
.long 0xD3D94009, 0x18000080
.long 0xD3D9400A, 0x18000080
.long 0xD3D9400B, 0x18000080
.long 0xD3D9400C, 0x18000080
.long 0xD3D9400D, 0x18000080
.long 0xD3D9400E, 0x18000080
.long 0xD3D9400F, 0x18000080
.long 0xD3D94010, 0x18000080
.long 0xD3D94011, 0x18000080
.long 0xD3D94012, 0x18000080
.long 0xD3D94013, 0x18000080
.long 0xD3D94014, 0x18000080
.long 0xD3D94015, 0x18000080
.long 0xD3D94016, 0x18000080
.long 0xD3D94017, 0x18000080
.long 0xD3D94018, 0x18000080
.long 0xD3D94019, 0x18000080
.long 0xD3D9401A, 0x18000080
.long 0xD3D9401B, 0x18000080
.long 0xD3D9401C, 0x18000080
.long 0xD3D9401D, 0x18000080
.long 0xD3D9401E, 0x18000080
.long 0xD3D9401F, 0x18000080
.long 0xD3D94020, 0x18000080
.long 0xD3D94021, 0x18000080
.long 0xD3D94022, 0x18000080
.long 0xD3D94023, 0x18000080
.long 0xD3D94024, 0x18000080
.long 0xD3D94025, 0x18000080
.long 0xD3D94026, 0x18000080
.long 0xD3D94027, 0x18000080
.long 0xD3D94028, 0x18000080
.long 0xD3D94029, 0x18000080
.long 0xD3D9402A, 0x18000080
.long 0xD3D9402B, 0x18000080
.long 0xD3D9402C, 0x18000080
.long 0xD3D9402D, 0x18000080
.long 0xD3D9402E, 0x18000080
.long 0xD3D9402F, 0x18000080
.long 0xD3D94030, 0x18000080
.long 0xD3D94031, 0x18000080
.long 0xD3D94032, 0x18000080
.long 0xD3D94033, 0x18000080
.long 0xD3D94034, 0x18000080
.long 0xD3D94035, 0x18000080
.long 0xD3D94036, 0x18000080
.long 0xD3D94037, 0x18000080
.long 0xD3D94038, 0x18000080
.long 0xD3D94039, 0x18000080
.long 0xD3D9403A, 0x18000080
.long 0xD3D9403B, 0x18000080
.long 0xD3D9403C, 0x18000080
.long 0xD3D9403D, 0x18000080
.long 0xD3D9403E, 0x18000080
.long 0xD3D9403F, 0x18000080
.long 0xD3D94040, 0x18000080
.long 0xD3D94041, 0x18000080
.long 0xD3D94042, 0x18000080
.long 0xD3D94043, 0x18000080
.long 0xD3D94044, 0x18000080
.long 0xD3D94045, 0x18000080
.long 0xD3D94046, 0x18000080
.long 0xD3D94047, 0x18000080
.long 0xD3D94048, 0x18000080
.long 0xD3D94049, 0x18000080
.long 0xD3D9404A, 0x18000080
.long 0xD3D9404B, 0x18000080
.long 0xD3D9404C, 0x18000080
.long 0xD3D9404D, 0x18000080
.long 0xD3D9404E, 0x18000080
.long 0xD3D9404F, 0x18000080
.long 0xD3D94050, 0x18000080
.long 0xD3D94051, 0x18000080
.long 0xD3D94052, 0x18000080
.long 0xD3D94053, 0x18000080
.long 0xD3D94054, 0x18000080
.long 0xD3D94055, 0x18000080
.long 0xD3D94056, 0x18000080
.long 0xD3D94057, 0x18000080
.long 0xD3D94058, 0x18000080
.long 0xD3D94059, 0x18000080
.long 0xD3D9405A, 0x18000080
.long 0xD3D9405B, 0x18000080
.long 0xD3D9405C, 0x18000080
.long 0xD3D9405D, 0x18000080
.long 0xD3D9405E, 0x18000080
.long 0xD3D9405F, 0x18000080
.long 0xD3D94060, 0x18000080
.long 0xD3D94061, 0x18000080
.long 0xD3D94062, 0x18000080
.long 0xD3D94063, 0x18000080
.long 0xD3D94064, 0x18000080
.long 0xD3D94065, 0x18000080
.long 0xD3D94066, 0x18000080
.long 0xD3D94067, 0x18000080
.long 0xD3D94068, 0x18000080
.long 0xD3D94069, 0x18000080
.long 0xD3D9406A, 0x18000080
.long 0xD3D9406B, 0x18000080
.long 0xD3D9406C, 0x18000080
.long 0xD3D9406D, 0x18000080
.long 0xD3D9406E, 0x18000080
.long 0xD3D9406F, 0x18000080
.long 0xD3D94070, 0x18000080
.long 0xD3D94071, 0x18000080
.long 0xD3D94072, 0x18000080
.long 0xD3D94073, 0x18000080
.long 0xD3D94074, 0x18000080
.long 0xD3D94075, 0x18000080
.long 0xD3D94076, 0x18000080
.long 0xD3D94077, 0x18000080
.long 0xD3D94078, 0x18000080
.long 0xD3D94079, 0x18000080
.long 0xD3D9407A, 0x18000080
.long 0xD3D9407B, 0x18000080
.long 0xD3D9407C, 0x18000080
.long 0xD3D9407D, 0x18000080
.long 0xD3D9407E, 0x18000080
.long 0xD3D9407F, 0x18000080
.long 0xBE9D0080
.long 0xBE9E0080
.long 0x8010443E
.long 0x8211453F
.long 0xBEFC001C
.long 0xBF8C0F7C
.long 0xBF8A0000
.long 0xBF8CC67F
.long 0xD3EE8000, 0x04026914
.long 0xD8EC1020, 0x2400000F
.long 0xD8EC10A0, 0x2600000F
.long 0xE0511000, 0x80020707
.long 0xD3EE8008, 0x04226916
.long 0xBF8CC67F
.long 0xD3EE8010, 0x04426918
.long 0xD8EC1120, 0x2800000F
.long 0xD8EC11A0, 0x2A00000F
.long 0xE0511100, 0x80020707
.long 0xD3EE8018, 0x0462691A
.long 0xBF8CC67F
.long 0xD3EE8020, 0x0482691C
.long 0xD8EC1220, 0x2C00000F
.long 0xD8EC12A0, 0x2E00000F
.long 0xE0511200, 0x80020707
.long 0xD3EE8028, 0x04A2691E
.long 0xBF8CC67F
.long 0xD3EE8030, 0x04C26920
.long 0xD8EC1320, 0x3000000F
.long 0xD8EC13A0, 0x3200000F
.long 0xE0511300, 0x80020707
.long 0xD3EE8038, 0x04E26922
.long 0xD3EE8040, 0x05026D14
.long 0xE05C1000, 0x80014406
.long 0xD3EE8048, 0x05226D16
.long 0xB71C1020
.long 0x80081508
.long 0x82098009
.long 0xD3EE8050, 0x05426D18
.long 0x80041404
.long 0x82058005
.long 0xD3EE8058, 0x05626D1A
.long 0xD3EE8060, 0x05826D1C
.long 0xE05C1000, 0x80045408
.long 0xD3EE8068, 0x05A26D1E
.long 0xD3EE8070, 0x05C26D20
.long 0xD3EE8078, 0x05E26D22
.long 0xBEFC001C
.long 0xBF8C0F7D
.long 0xBF8A0000
.long 0xBF8CC67F
.long 0xD3EE8000, 0x04027124
.long 0xD8EC2040, 0x1400000F
.long 0xD8EC20C0, 0x1600000F
.long 0xE0511000, 0x80020707
.long 0xD3EE8008, 0x04227126
.long 0xBF8CC67F
.long 0xD3EE8010, 0x04427128
.long 0xD8EC2140, 0x1800000F
.long 0xD8EC21C0, 0x1A00000F
.long 0xE0511100, 0x80020707
.long 0xD3EE8018, 0x0462712A
.long 0xBF8CC67F
.long 0xD3EE8020, 0x0482712C
.long 0xD8EC2240, 0x1C00000F
.long 0xD8EC22C0, 0x1E00000F
.long 0xE0511200, 0x80020707
.long 0xD3EE8028, 0x04A2712E
.long 0xBF8CC67F
.long 0xD3EE8030, 0x04C27130
.long 0xD8EC2340, 0x2000000F
.long 0xD8EC23C0, 0x2200000F
.long 0xE0511300, 0x80020707
.long 0xD3EE8038, 0x04E27132
.long 0xD3EE8040, 0x05027524
.long 0xE05C1000, 0x80014806
.long 0xD3EE8048, 0x05227526
.long 0xB71C1020
.long 0x80081508
.long 0x82098009
.long 0xD3EE8050, 0x05427528
.long 0x80041404
.long 0x82058005
.long 0xD3EE8058, 0x0562752A
.long 0xD3EE8060, 0x0582752C
.long 0xD3EE8068, 0x05A2752E
.long 0xD3EE8070, 0x05C27530
.long 0xD3EE8078, 0x05E27532
.long 0xBEFC001C
.long 0xBF8C0F7C
.long 0xBF8A0000
.long 0xBF8CC67F
.long 0xD3EE8000, 0x04027914
.long 0xD8EC3060, 0x2400000F
.long 0xD8EC30E0, 0x2600000F
.long 0xE0511000, 0x80020707
.long 0xD3EE8008, 0x04227916
.long 0xBF8CC67F
.long 0xD3EE8010, 0x04427918
.long 0xD8EC3160, 0x2800000F
.long 0xD8EC31E0, 0x2A00000F
.long 0xE0511100, 0x80020707
.long 0xD3EE8018, 0x0462791A
.long 0xBF8CC67F
.long 0xD3EE8020, 0x0482791C
.long 0xD8EC3260, 0x2C00000F
.long 0xD8EC32E0, 0x2E00000F
.long 0xE0511200, 0x80020707
.long 0xD3EE8028, 0x04A2791E
.long 0xBF8CC67F
.long 0xD3EE8030, 0x04C27920
.long 0xD8EC3360, 0x3000000F
.long 0xD8EC33E0, 0x3200000F
.long 0xE0511300, 0x80020707
.long 0xD3EE8038, 0x04E27922
.long 0xD3EE8040, 0x05027D14
.long 0xE05C1000, 0x80014C06
.long 0xD3EE8048, 0x05227D16
.long 0xB71C1020
.long 0x80081508
.long 0x82098009
.long 0xD3EE8050, 0x05427D18
.long 0x80041404
.long 0x82058005
.long 0xD3EE8058, 0x05627D1A
.long 0xBF11011E
.long 0xD3D84010, 0x18000180
.long 0xD3D84011, 0x18000181
.long 0xD3D84012, 0x180001C0
.long 0xD3D84013, 0x180001C1
.long 0xBF800001
.long 0xBF9C0000
.long 0xBF8C0F7A
.long 0xD2800010, 0x2002A910
.long 0xD2800012, 0x2002AD12
.long 0xD3EE8060, 0x05827D1C
.long 0xE07C1000, 0x80041008
.long 0xD3EE8068, 0x05A27D1E
.long 0x80101910
.long 0x82118011
.long 0xD3EE8070, 0x05C27D20
.long 0x80921912
.long 0xBE920280
.long 0xD3EE8078, 0x05E27D22
.long 0xBEFC001C
.long 0xBF8C0F7D
.long 0xBF8A0000
.long 0xBF8CC67F
.long 0xD3EE8000, 0x04028124
.long 0xD8EC4080, 0x1400000F
.long 0xD8EC4100, 0x1600000F
.long 0xE0511000, 0x80020707
.long 0xD3EE8008, 0x04228126
.long 0xBF8CC67F
.long 0xD3EE8010, 0x04428128
.long 0xD8EC4180, 0x1800000F
.long 0xD8EC4200, 0x1A00000F
.long 0xE0511100, 0x80020707
.long 0xD3EE8018, 0x0462812A
.long 0xBF8CC67F
.long 0xD3EE8020, 0x0482812C
.long 0xD8EC4280, 0x1C00000F
.long 0xD8EC4300, 0x1E00000F
.long 0xE0511200, 0x80020707
.long 0xD3EE8028, 0x04A2812E
.long 0xBF8CC67F
.long 0xD3EE8030, 0x04C28130
.long 0xD8EC4380, 0x2000000F
.long 0xD8EC4400, 0x2200000F
.long 0xE0511300, 0x80020707
.long 0xD3EE8038, 0x04E28132
.long 0xD3EE8040, 0x05028524
.long 0xE05C1000, 0x80015006
.long 0xD3EE8048, 0x05228526
.long 0xBE9C0016
.long 0x80081508
.long 0x82098009
.long 0xD3EE8050, 0x05428528
.long 0x80041404
.long 0x82058005
.long 0xD3EE8058, 0x0562852A
.long 0xD3EE8060, 0x0582852C
.long 0xD3EE8068, 0x05A2852E
.long 0xD3EE8070, 0x05C28530
.long 0xD3EE8078, 0x05E28532
.long 0xBEFC001C
.long 0xBF8C0F7C
.long 0xBF8A0000
.long 0xBF8CC67F
.long 0xD3EE8000, 0x04028914
.long 0xD8EC50A0, 0x2400000F
.long 0xD8EC5120, 0x2600000F
.long 0xE0511000, 0x80020707
.long 0xD3EE8008, 0x04228916
.long 0xBF8CC67F
.long 0xD3EE8010, 0x04428918
.long 0xD8EC51A0, 0x2800000F
.long 0xD8EC5220, 0x2A00000F
.long 0xE0511100, 0x80020707
.long 0xD3EE8018, 0x0462891A
.long 0xBF8CC67F
.long 0xD3EE8020, 0x0482891C
.long 0xD8EC52A0, 0x2C00000F
.long 0xD8EC5320, 0x2E00000F
.long 0xE0511200, 0x80020707
.long 0xD3EE8028, 0x04A2891E
.long 0xBF8CC67F
.long 0xD3EE8030, 0x04C28920
.long 0xD8EC53A0, 0x3000000F
.long 0xD8EC5420, 0x3200000F
.long 0xE0511300, 0x80020707
.long 0xD3EE8038, 0x04E28922
.long 0xD3EE8040, 0x05028D14
.long 0xE05C1000, 0x80013406
.long 0xD3EE8048, 0x05228D16
.long 0xB71C1020
.long 0x80081508
.long 0x82098009
.long 0xD3EE8050, 0x05428D18
.long 0x80041404
.long 0x82058005
.long 0xD3EE8058, 0x05628D1A
.long 0xD3EE8060, 0x05828D1C
.long 0xE05C1000, 0x80045808
.long 0xD3EE8068, 0x05A28D1E
.long 0xD3EE8070, 0x05C28D20
.long 0xD3EE8078, 0x05E28D22
.long 0xBEFC001C
.long 0xBF8C0F7D
.long 0xBF8A0000
.long 0xBF8CC67F
.long 0xD3EE8000, 0x04029124
.long 0xD8EC60C0, 0x1400000F
.long 0xD8EC6140, 0x1600000F
.long 0xE0511000, 0x80020707
.long 0xD3EE8008, 0x04229126
.long 0xBF8CC67F
.long 0xD3EE8010, 0x04429128
.long 0xD8EC61C0, 0x1800000F
.long 0xD8EC6240, 0x1A00000F
.long 0xE0511100, 0x80020707
.long 0xD3EE8018, 0x0462912A
.long 0xBF8CC67F
.long 0xD3EE8020, 0x0482912C
.long 0xD8EC62C0, 0x1C00000F
.long 0xD8EC6340, 0x1E00000F
.long 0xE0511200, 0x80020707
.long 0xD3EE8028, 0x04A2912E
.long 0xBF8CC67F
.long 0xD3EE8030, 0x04C29130
.long 0xD8EC63C0, 0x2000000F
.long 0xD8EC6440, 0x2200000F
.long 0xE0511300, 0x80020707
.long 0xD3EE8038, 0x04E29132
.long 0xD3EE8040, 0x05029524
.long 0xE05C1000, 0x80013806
.long 0xD3EE8048, 0x05229526
.long 0xB71C1020
.long 0x80081508
.long 0x82098009
.long 0xD3EE8050, 0x05429528
.long 0x80041404
.long 0x82058005
.long 0xD3EE8058, 0x0562952A
.long 0xD3EE8060, 0x0582952C
.long 0xD3EE8068, 0x05A2952E
.long 0xD3EE8070, 0x05C29530
.long 0xD3EE8078, 0x05E29532
.long 0xBEFC001C
.long 0xBF8C0F7C
.long 0xBF8A0000
.long 0xBF8CC67F
.long 0xD3EE8000, 0x04029914
.long 0xD8EC70E0, 0x2400000F
.long 0xD8EC7160, 0x2600000F
.long 0xE0511000, 0x80020707
.long 0xD3EE8008, 0x04229916
.long 0xBF8CC67F
.long 0xD3EE8010, 0x04429918
.long 0xD8EC71E0, 0x2800000F
.long 0xD8EC7260, 0x2A00000F
.long 0xE0511100, 0x80020707
.long 0xD3EE8018, 0x0462991A
.long 0xBF8CC67F
.long 0xD3EE8020, 0x0482991C
.long 0xD8EC72E0, 0x2C00000F
.long 0xD8EC7360, 0x2E00000F
.long 0xE0511200, 0x80020707
.long 0xD3EE8028, 0x04A2991E
.long 0xBF8CC67F
.long 0xD3EE8030, 0x04C29920
.long 0xD8EC73E0, 0x3000000F
.long 0xD8EC7460, 0x3200000F
.long 0xE0511300, 0x80020707
.long 0xD3EE8038, 0x04E29922
.long 0xD3EE8040, 0x05029D14
.long 0xE05C1000, 0x80013C06
.long 0xD3EE8048, 0x05229D16
.long 0xB71C1020
.long 0x80081508
.long 0x82098009
.long 0xD3EE8050, 0x05429D18
.long 0x80041404
.long 0x82058005
.long 0xD3EE8058, 0x05629D1A
.long 0xBF11011E
.long 0xD3D84010, 0x18000182
.long 0xD3D84011, 0x18000183
.long 0xD3D84012, 0x180001C2
.long 0xD3D84013, 0x180001C3
.long 0xBF800001
.long 0xBF9C0000
.long 0xBF8C0F7A
.long 0xD2800010, 0x2002B110
.long 0xD2800012, 0x2002B512
.long 0xD3EE8060, 0x05829D1C
.long 0xE07C1000, 0x80041008
.long 0xD3EE8068, 0x05A29D1E
.long 0x80101910
.long 0x82118011
.long 0xD3EE8070, 0x05C29D20
.long 0x80921912
.long 0xBE920280
.long 0xD3EE8078, 0x05E29D22
.long 0xBEFC001C
.long 0xBF8C0F7D
.long 0xBF8A0000
.long 0xBF8CC67F
.long 0xD3EE8000, 0x0402A124
.long 0xD8EC0000, 0x1400000F
.long 0xD8EC0080, 0x1600000F
.long 0xE0511000, 0x80020707
.long 0xD3EE8008, 0x0422A126
.long 0xBF8CC67F
.long 0xD3EE8010, 0x0442A128
.long 0xD8EC0100, 0x1800000F
.long 0xD8EC0180, 0x1A00000F
.long 0xE0511100, 0x80020707
.long 0xD3EE8018, 0x0462A12A
.long 0xBF8CC67F
.long 0xD3EE8020, 0x0482A12C
.long 0xD8EC0200, 0x1C00000F
.long 0xD8EC0280, 0x1E00000F
.long 0xE0511200, 0x80020707
.long 0xD3EE8028, 0x04A2A12E
.long 0xBF8CC67F
.long 0xD3EE8030, 0x04C2A130
.long 0xD8EC0300, 0x2000000F
.long 0xD8EC0380, 0x2200000F
.long 0xE0511300, 0x80020707
.long 0xD3EE8038, 0x04E2A132
.long 0xD3EE8040, 0x0502A524
.long 0xE05C1000, 0x80014006
.long 0xD3EE8048, 0x0522A526
.long 0xB71C1020
.long 0x80081508
.long 0x82098009
.long 0xD3EE8050, 0x0542A528
.long 0x80041404
.long 0x82058005
.long 0xD3EE8058, 0x0562A52A
.long 0xD3EE8060, 0x0582A52C
.long 0xD3EE8068, 0x05A2A52E
.long 0xD3EE8070, 0x05C2A530
.long 0xD3EE8078, 0x05E2A532
.long 0xB71E0004
.long 0xB71D0008
.long 0xB31D0078
.long 0xBF85FD9C
.long 0xBEFC001C
.long 0xBF8C0F7C
.long 0xBF8A0000
.long 0xBF8CC67F
.long 0xD3EE8000, 0x04026914
.long 0xD8EC1020, 0x2400000F
.long 0xD8EC10A0, 0x2600000F
.long 0xE0511000, 0x80020707
.long 0xD3EE8008, 0x04226916
.long 0xBF8CC67F
.long 0xD3EE8010, 0x04426918
.long 0xD8EC1120, 0x2800000F
.long 0xD8EC11A0, 0x2A00000F
.long 0xE0511100, 0x80020707
.long 0xD3EE8018, 0x0462691A
.long 0xBF8CC67F
.long 0xD3EE8020, 0x0482691C
.long 0xD8EC1220, 0x2C00000F
.long 0xD8EC12A0, 0x2E00000F
.long 0xE0511200, 0x80020707
.long 0xD3EE8028, 0x04A2691E
.long 0xBF8CC67F
.long 0xD3EE8030, 0x04C26920
.long 0xD8EC1320, 0x3000000F
.long 0xD8EC13A0, 0x3200000F
.long 0xE0511300, 0x80020707
.long 0xD3EE8038, 0x04E26922
.long 0xB71C1020
.long 0xD3EE8040, 0x05026D14
.long 0xE05C1000, 0x80014406
.long 0xD3EE8048, 0x05226D16
.long 0x80081508
.long 0x82098009
.long 0xD3EE8050, 0x05426D18
.long 0x80041404
.long 0x82058005
.long 0xD3EE8058, 0x05626D1A
.long 0xD3EE8060, 0x05826D1C
.long 0xE05C1000, 0x80045408
.long 0xD3EE8068, 0x05A26D1E
.long 0xD3EE8070, 0x05C26D20
.long 0xD3EE8078, 0x05E26D22
.long 0xBEFC001C
.long 0xBF8C0F7D
.long 0xBF8A0000
.long 0xBF8CC67F
.long 0xD3EE8000, 0x04027124
.long 0xD8EC2040, 0x1400000F
.long 0xD8EC20C0, 0x1600000F
.long 0xE0511000, 0x80020707
.long 0xD3EE8008, 0x04227126
.long 0xBF8CC67F
.long 0xD3EE8010, 0x04427128
.long 0xD8EC2140, 0x1800000F
.long 0xD8EC21C0, 0x1A00000F
.long 0xE0511100, 0x80020707
.long 0xD3EE8018, 0x0462712A
.long 0xBF8CC67F
.long 0xD3EE8020, 0x0482712C
.long 0xD8EC2240, 0x1C00000F
.long 0xD8EC22C0, 0x1E00000F
.long 0xE0511200, 0x80020707
.long 0xD3EE8028, 0x04A2712E
.long 0xBF8CC67F
.long 0xD3EE8030, 0x04C27130
.long 0xD8EC2340, 0x2000000F
.long 0xD8EC23C0, 0x2200000F
.long 0xE0511300, 0x80020707
.long 0xD3EE8038, 0x04E27132
.long 0xB71C1020
.long 0xD3EE8040, 0x05027524
.long 0xE05C1000, 0x80014806
.long 0xD3EE8048, 0x05227526
.long 0x80081508
.long 0x82098009
.long 0xD3EE8050, 0x05427528
.long 0x80041404
.long 0x82058005
.long 0xD3EE8058, 0x0562752A
.long 0xD3EE8060, 0x0582752C
.long 0xD3EE8068, 0x05A2752E
.long 0xD3EE8070, 0x05C27530
.long 0xD3EE8078, 0x05E27532
.long 0xBEFC001C
.long 0xBF8C0F7C
.long 0xBF8A0000
.long 0xBF8CC67F
.long 0xD3EE8000, 0x04027914
.long 0xD8EC3060, 0x2400000F
.long 0xD8EC30E0, 0x2600000F
.long 0xE0511000, 0x80020707
.long 0xD3EE8008, 0x04227916
.long 0xBF8CC67F
.long 0xD3EE8010, 0x04427918
.long 0xD8EC3160, 0x2800000F
.long 0xD8EC31E0, 0x2A00000F
.long 0xE0511100, 0x80020707
.long 0xD3EE8018, 0x0462791A
.long 0xBF8CC67F
.long 0xD3EE8020, 0x0482791C
.long 0xD8EC3260, 0x2C00000F
.long 0xD8EC32E0, 0x2E00000F
.long 0xE0511200, 0x80020707
.long 0xD3EE8028, 0x04A2791E
.long 0xBF8CC67F
.long 0xD3EE8030, 0x04C27920
.long 0xD8EC3360, 0x3000000F
.long 0xD8EC33E0, 0x3200000F
.long 0xE0511300, 0x80020707
.long 0xD3EE8038, 0x04E27922
.long 0xB71C1020
.long 0xD3EE8040, 0x05027D14
.long 0xE05C1000, 0x80014C06
.long 0xD3EE8048, 0x05227D16
.long 0x80081508
.long 0x82098009
.long 0xD3EE8050, 0x05427D18
.long 0x80041404
.long 0x82058005
.long 0xD3EE8058, 0x05627D1A
.long 0xD3D84010, 0x180001BC
.long 0xD3D84011, 0x180001BD
.long 0xD3D84012, 0x180001FC
.long 0xD3D84013, 0x180001FD
.long 0xBF800001
.long 0xBF8C0F7A
.long 0xD2800010, 0x2002A910
.long 0xD2800012, 0x2002AD12
.long 0xD3EE8060, 0x05827D1C
.long 0xE07C1000, 0x80041008
.long 0xD3EE8068, 0x05A27D1E
.long 0x80101910
.long 0x82118011
.long 0xD3EE8070, 0x05C27D20
.long 0x80921912
.long 0xBE920280
.long 0xD3EE8078, 0x05E27D22
.long 0x808C0426
.long 0x828D0527
.long 0xBE86000C
.long 0x808C0828
.long 0x828D0929
.long 0xBE8A000C
.long 0xBEFC001C
.long 0xBF8C0F7D
.long 0xBF8A0000
.long 0xBF8CC67F
.long 0xD3EE8000, 0x04028124
.long 0xD8EC4080, 0x1400000F
.long 0xD8EC4100, 0x1600000F
.long 0xE0511000, 0x80020707
.long 0xD3EE8008, 0x04228126
.long 0xBF8CC67F
.long 0xD3EE8010, 0x04428128
.long 0xD8EC4180, 0x1800000F
.long 0xD8EC4200, 0x1A00000F
.long 0xE0511100, 0x80020707
.long 0xD3EE8018, 0x0462812A
.long 0xBF8CC67F
.long 0xD3EE8020, 0x0482812C
.long 0xD8EC4280, 0x1C00000F
.long 0xD8EC4300, 0x1E00000F
.long 0xE0511200, 0x80020707
.long 0xD3EE8028, 0x04A2812E
.long 0xBF8CC67F
.long 0xD3EE8030, 0x04C28130
.long 0xD8EC4380, 0x2000000F
.long 0xD8EC4400, 0x2200000F
.long 0xE0511300, 0x80020707
.long 0xD3EE8038, 0x04E28132
.long 0xBE9C0016
.long 0xD3EE8040, 0x05028524
.long 0xE05C1000, 0x80015006
.long 0xD3EE8048, 0x05228526
.long 0xD3EE8050, 0x05428528
.long 0xD3EE8058, 0x0562852A
.long 0xD3EE8060, 0x0582852C
.long 0xD3EE8068, 0x05A2852E
.long 0xD3EE8070, 0x05C28530
.long 0xD3EE8078, 0x05E28532
.long 0xB00C0100
.long 0x920F320C
.long 0x920EFF18, 0x00000080
.long 0x920C330E
.long 0x960D330E
.long 0x800C0F0C
.long 0x820D800D
.long 0x8E8C820C
.long 0x920E30FF, 0x00000100
.long 0x803E0E0C
.long 0x823F800D
.long 0x80A40C2A
.long 0x82A50D2B
.long 0x924EFF32, 0x00000080
.long 0x80CE4E1F
.long 0x81313831
.long 0xBF031731
.long 0xBF850350
.long 0x814C384C
.long 0x818C494C
.long 0x810D814D
.long 0xBF03494C
.long 0xBECC020C
.long 0xBECD020D
.long 0x960D3631
.long 0x8F0E9F37
.long 0x920C0E31
.long 0x800C0D0C
.long 0x860EFF37, 0x7FFFFFFF
.long 0x8F330E0C
.long 0x92323433
.long 0x80B23231
.long 0xBF033534
.long 0x85463332
.long 0x85473233
.long 0xBF033849
.long 0xBEC6024C
.long 0xBEC7024D
.long 0xBE8F004B
.long 0x960D0F47
.long 0x920C0F47
.long 0x8F8C9F0C
.long 0x920D4A0C
.long 0x808D0D47
.long 0x920D490D
.long 0x800D460D
.long 0xBF09390C
.long 0xBE8F023B
.long 0x850E4A3A
.long 0x96470F0D
.long 0x92460F0D
.long 0x8FC69F46
.long 0x92470E46
.long 0x80C7470D
.long 0x920C4A0C
.long 0x80470C47
.long 0xBF033534
.long 0x85324746
.long 0x85334647
.long 0x8E0C8A32
.long 0x810C1A0C
.long 0x80040C40
.long 0x82058041
.long 0xBE8600FF, 0x80000000
.long 0x8E0C8A33
.long 0x800C1B0C
.long 0x80080C42
.long 0x82098043
.long 0xBE8A00FF, 0x80000000
.long 0xBEFC001C
.long 0xBF8C0F7C
.long 0xBF8A0000
.long 0xBF8CC67F
.long 0xD3EE8000, 0x04028914
.long 0xD8EC50A0, 0x2400000F
.long 0xD8EC5120, 0x2600000F
.long 0xE0511000, 0x80020707
.long 0xD3EE8008, 0x04228916
.long 0xBF8CC67F
.long 0xD3EE8010, 0x04428918
.long 0xD8EC51A0, 0x2800000F
.long 0xD8EC5220, 0x2A00000F
.long 0xE0511100, 0x80020707
.long 0xD3EE8018, 0x0462891A
.long 0xBF8CC67F
.long 0xD3EE8020, 0x0482891C
.long 0xD8EC52A0, 0x2C00000F
.long 0xD8EC5320, 0x2E00000F
.long 0xE0511200, 0x80020707
.long 0xD3EE8028, 0x04A2891E
.long 0xBF8CC67F
.long 0xD3EE8030, 0x04C28920
.long 0xD8EC53A0, 0x3000000F
.long 0xD8EC5420, 0x3200000F
.long 0xE0511300, 0x80020707
.long 0xD3EE8038, 0x04E28922
.long 0xB71C1020
.long 0xD3EE8040, 0x05028D14
.long 0xE05C1000, 0x80013406
.long 0xD3EE8048, 0x05228D16
.long 0x80081508
.long 0x82098009
.long 0xD3EE8050, 0x05428D18
.long 0x80041404
.long 0x82058005
.long 0xD3EE8058, 0x05628D1A
.long 0xD3EE8060, 0x05828D1C
.long 0xE05C1000, 0x80045808
.long 0xD3EE8068, 0x05A28D1E
.long 0xD3EE8070, 0x05C28D20
.long 0xD3EE8078, 0x05E28D22
.long 0xBEFC001C
.long 0xBF8C0F7D
.long 0xBF8A0000
.long 0xBF8CC67F
.long 0xD3EE8000, 0x04029124
.long 0xD8EC60C0, 0x1400000F
.long 0xD8EC6140, 0x1600000F
.long 0xE0511000, 0x80020707
.long 0xD3EE8008, 0x04229126
.long 0xBF8CC67F
.long 0xD3EE8010, 0x04429128
.long 0xD8EC61C0, 0x1800000F
.long 0xD8EC6240, 0x1A00000F
.long 0xE0511100, 0x80020707
.long 0xD3EE8018, 0x0462912A
.long 0xBF8CC67F
.long 0xD3EE8020, 0x0482912C
.long 0xD8EC62C0, 0x1C00000F
.long 0xD8EC6340, 0x1E00000F
.long 0xE0511200, 0x80020707
.long 0xD3EE8028, 0x04A2912E
.long 0xBF8CC67F
.long 0xD3EE8030, 0x04C29130
.long 0xD8EC63C0, 0x2000000F
.long 0xD8EC6440, 0x2200000F
.long 0xE0511300, 0x80020707
.long 0xD3EE8038, 0x04E29132
.long 0xB71C1020
.long 0xD3EE8040, 0x05029524
.long 0xE05C1000, 0x80013806
.long 0xD3EE8048, 0x05229526
.long 0x80081508
.long 0x82098009
.long 0xD3EE8050, 0x05429528
.long 0x80041404
.long 0x82058005
.long 0xD3EE8058, 0x0562952A
.long 0xD3EE8060, 0x0582952C
.long 0xD3EE8068, 0x05A2952E
.long 0xD3EE8070, 0x05C29530
.long 0xD3EE8078, 0x05E29532
.long 0xBEFC001C
.long 0xBF8C0F7C
.long 0xBF8A0000
.long 0xBF8CC67F
.long 0xD3EE8000, 0x04029914
.long 0xD8EC70E0, 0x2400000F
.long 0xD8EC7160, 0x2600000F
.long 0xE0511000, 0x80020707
.long 0xD3EE8008, 0x04229916
.long 0xBF8CC67F
.long 0xD3EE8010, 0x04429918
.long 0xD8EC71E0, 0x2800000F
.long 0xD8EC7260, 0x2A00000F
.long 0xE0511100, 0x80020707
.long 0xD3EE8018, 0x0462991A
.long 0xBF8CC67F
.long 0xD3EE8020, 0x0482991C
.long 0xD8EC72E0, 0x2C00000F
.long 0xD8EC7360, 0x2E00000F
.long 0xE0511200, 0x80020707
.long 0xD3EE8028, 0x04A2991E
.long 0xBF8CC67F
.long 0xD3EE8030, 0x04C29920
.long 0xD8EC73E0, 0x3000000F
.long 0xD8EC7460, 0x3200000F
.long 0xE0511300, 0x80020707
.long 0xD3EE8038, 0x04E29922
.long 0xB71C1020
.long 0xD3EE8040, 0x05029D14
.long 0xE05C1000, 0x80013C06
.long 0xD3EE8048, 0x05229D16
.long 0x80081508
.long 0x82098009
.long 0xD3EE8050, 0x05429D18
.long 0x80041404
.long 0x82058005
.long 0xD3EE8058, 0x05629D1A
.long 0xD3D84010, 0x180001BE
.long 0xD3D84011, 0x180001BF
.long 0xD3D84012, 0x180001FE
.long 0xD3D84013, 0x180001FF
.long 0xBF800001
.long 0xBF8C0F7A
.long 0xD2800010, 0x2002B110
.long 0xD2800012, 0x2002B512
.long 0xD3EE8060, 0x05829D1C
.long 0xE07C1000, 0x80041008
.long 0xD3EE8068, 0x05A29D1E
.long 0xD3EE8070, 0x05C29D20
.long 0xD3EE8078, 0x05E29D22
.long 0xBEFC001C
.long 0xBF8C0F7D
.long 0xBF8A0000
.long 0xBF8CC67F
.long 0xD3EE8000, 0x0402A124
.long 0xD8EC0000, 0x1400000F
.long 0xD8EC0080, 0x1600000F
.long 0xE0511000, 0x80020707
.long 0xD3EE8008, 0x0422A126
.long 0xBF8CC67F
.long 0xD3EE8010, 0x0442A128
.long 0xD8EC0100, 0x1800000F
.long 0xD8EC0180, 0x1A00000F
.long 0xE0511100, 0x80020707
.long 0xD3EE8018, 0x0462A12A
.long 0xBF8CC67F
.long 0xD3EE8020, 0x0482A12C
.long 0xD8EC0200, 0x1C00000F
.long 0xD8EC0280, 0x1E00000F
.long 0xE0511200, 0x80020707
.long 0xD3EE8028, 0x04A2A12E
.long 0xBF8CC67F
.long 0xD3EE8030, 0x04C2A130
.long 0xD8EC0300, 0x2000000F
.long 0xD8EC0380, 0x2200000F
.long 0xE0511300, 0x80020707
.long 0xD3EE8038, 0x04E2A132
.long 0xB71C1020
.long 0xD3EE8040, 0x0502A524
.long 0xE05C1000, 0x80014006
.long 0xD3EE8048, 0x0522A526
.long 0x80081508
.long 0x82098009
.long 0xD3EE8050, 0x0542A528
.long 0x80041404
.long 0x82058005
.long 0xD3EE8058, 0x0562A52A
.long 0xD3EE8060, 0x0582A52C
.long 0xD3EE8068, 0x05A2A52E
.long 0xD3EE8070, 0x05C2A530
.long 0xD3EE8078, 0x05E2A532
.long 0xBE9200FF, 0x80000000
.long 0xBF091224
.long 0x850C2412
.long 0xBF068025
.long 0xBE92020C
.long 0xD0C9000C, 0x00009D0A
.long 0xD1000008, 0x0032190E
.long 0xD3D94080, 0x18000080
.long 0xD3D94081, 0x18000080
.long 0xD3D94082, 0x18000080
.long 0xD3D94083, 0x18000080
.long 0xD3D94084, 0x18000080
.long 0xD3D94085, 0x18000080
.long 0xD3D94086, 0x18000080
.long 0xD3D94087, 0x18000080
.long 0xD3D94088, 0x18000080
.long 0xD3D94089, 0x18000080
.long 0xD3D9408A, 0x18000080
.long 0xD3D9408B, 0x18000080
.long 0xD3D9408C, 0x18000080
.long 0xD3D9408D, 0x18000080
.long 0xD3D9408E, 0x18000080
.long 0xD3D9408F, 0x18000080
.long 0xD3D94090, 0x18000080
.long 0xD3D94091, 0x18000080
.long 0xD3D94092, 0x18000080
.long 0xD3D94093, 0x18000080
.long 0xD3D94094, 0x18000080
.long 0xD3D94095, 0x18000080
.long 0xD3D94096, 0x18000080
.long 0xD3D94097, 0x18000080
.long 0xD3D94098, 0x18000080
.long 0xD3D94099, 0x18000080
.long 0xD3D9409A, 0x18000080
.long 0xD3D9409B, 0x18000080
.long 0xD3D9409C, 0x18000080
.long 0xD3D9409D, 0x18000080
.long 0xD3D9409E, 0x18000080
.long 0xD3D9409F, 0x18000080
.long 0xD3D940A0, 0x18000080
.long 0xD3D940A1, 0x18000080
.long 0xD3D940A2, 0x18000080
.long 0xD3D940A3, 0x18000080
.long 0xD3D940A4, 0x18000080
.long 0xD3D940A5, 0x18000080
.long 0xD3D940A6, 0x18000080
.long 0xD3D940A7, 0x18000080
.long 0xD3D940A8, 0x18000080
.long 0xD3D940A9, 0x18000080
.long 0xD3D940AA, 0x18000080
.long 0xD3D940AB, 0x18000080
.long 0xD3D940AC, 0x18000080
.long 0xD3D940AD, 0x18000080
.long 0xD3D940AE, 0x18000080
.long 0xD3D940AF, 0x18000080
.long 0xD3D940B0, 0x18000080
.long 0xD3D940B1, 0x18000080
.long 0xD3D940B2, 0x18000080
.long 0xD3D940B3, 0x18000080
.long 0xD3D940B4, 0x18000080
.long 0xD3D940B5, 0x18000080
.long 0xD3D940B6, 0x18000080
.long 0xD3D940B7, 0x18000080
.long 0xD3D940B8, 0x18000080
.long 0xD3D940B9, 0x18000080
.long 0xD3D940BA, 0x18000080
.long 0xD3D940BB, 0x18000080
.long 0xD3D940BC, 0x18000080
.long 0xD3D940BD, 0x18000080
.long 0xD3D940BE, 0x18000080
.long 0xD3D940BF, 0x18000080
.long 0xD3D940C0, 0x18000080
.long 0xD3D940C1, 0x18000080
.long 0xD3D940C2, 0x18000080
.long 0xD3D940C3, 0x18000080
.long 0xD3D940C4, 0x18000080
.long 0xD3D940C5, 0x18000080
.long 0xD3D940C6, 0x18000080
.long 0xD3D940C7, 0x18000080
.long 0xD3D940C8, 0x18000080
.long 0xD3D940C9, 0x18000080
.long 0xD3D940CA, 0x18000080
.long 0xD3D940CB, 0x18000080
.long 0xD3D940CC, 0x18000080
.long 0xD3D940CD, 0x18000080
.long 0xD3D940CE, 0x18000080
.long 0xD3D940CF, 0x18000080
.long 0xD3D940D0, 0x18000080
.long 0xD3D940D1, 0x18000080
.long 0xD3D940D2, 0x18000080
.long 0xD3D940D3, 0x18000080
.long 0xD3D940D4, 0x18000080
.long 0xD3D940D5, 0x18000080
.long 0xD3D940D6, 0x18000080
.long 0xD3D940D7, 0x18000080
.long 0xD3D940D8, 0x18000080
.long 0xD3D940D9, 0x18000080
.long 0xD3D940DA, 0x18000080
.long 0xD3D940DB, 0x18000080
.long 0xD3D940DC, 0x18000080
.long 0xD3D940DD, 0x18000080
.long 0xD3D940DE, 0x18000080
.long 0xD3D940DF, 0x18000080
.long 0xD3D940E0, 0x18000080
.long 0xD3D940E1, 0x18000080
.long 0xD3D940E2, 0x18000080
.long 0xD3D940E3, 0x18000080
.long 0xD3D940E4, 0x18000080
.long 0xD3D940E5, 0x18000080
.long 0xD3D940E6, 0x18000080
.long 0xD3D940E7, 0x18000080
.long 0xD3D940E8, 0x18000080
.long 0xD3D940E9, 0x18000080
.long 0xD3D940EA, 0x18000080
.long 0xD3D940EB, 0x18000080
.long 0xD3D940EC, 0x18000080
.long 0xD3D940ED, 0x18000080
.long 0xD3D940EE, 0x18000080
.long 0xD3D940EF, 0x18000080
.long 0xD3D940F0, 0x18000080
.long 0xD3D940F1, 0x18000080
.long 0xD3D940F2, 0x18000080
.long 0xD3D940F3, 0x18000080
.long 0xD3D940F4, 0x18000080
.long 0xD3D940F5, 0x18000080
.long 0xD3D940F6, 0x18000080
.long 0xD3D940F7, 0x18000080
.long 0xD3D940F8, 0x18000080
.long 0xD3D940F9, 0x18000080
.long 0xD3D940FA, 0x18000080
.long 0xD3D940FB, 0x18000080
.long 0xD3D940FC, 0x18000080
.long 0xD3D940FD, 0x18000080
.long 0xD3D940FE, 0x18000080
.long 0xD3D940FF, 0x18000080
.long 0xBF82F3D1
.long 0xBF8C0F7C
.long 0xBF8A0000
.long 0xBF8CC67F
.long 0xD3EE8080, 0x06028914
.long 0xD8EC50A0, 0x2400000F
.long 0xD8EC5120, 0x2600000F
.long 0xD3EE8088, 0x06228916
.long 0xBF8CC67F
.long 0xD3EE8090, 0x06428918
.long 0xD8EC51A0, 0x2800000F
.long 0xD8EC5220, 0x2A00000F
.long 0xD3EE8098, 0x0662891A
.long 0xBF8CC67F
.long 0xD3EE80A0, 0x0682891C
.long 0xD8EC52A0, 0x2C00000F
.long 0xD8EC5320, 0x2E00000F
.long 0xD3EE80A8, 0x06A2891E
.long 0xBF8CC67F
.long 0xD3EE80B0, 0x06C28920
.long 0xD8EC53A0, 0x3000000F
.long 0xD8EC5420, 0x3200000F
.long 0xD3EE80B8, 0x06E28922
.long 0xD3EE80C0, 0x07028D14
.long 0xD3EE80C8, 0x07228D16
.long 0xD3EE80D0, 0x07428D18
.long 0xD3EE80D8, 0x07628D1A
.long 0xD3EE80E0, 0x07828D1C
.long 0xE05C1000, 0x80045808
.long 0xD3EE80E8, 0x07A28D1E
.long 0xD3EE80F0, 0x07C28D20
.long 0xD3EE80F8, 0x07E28D22
.long 0xBF8C0F78
.long 0xBF8A0000
.long 0xBF8CC67F
.long 0xD3EE8080, 0x06029124
.long 0xD8EC60C0, 0x1400000F
.long 0xD8EC6140, 0x1600000F
.long 0xD3EE8088, 0x06229126
.long 0xBF8CC67F
.long 0xD3EE8090, 0x06429128
.long 0xD8EC61C0, 0x1800000F
.long 0xD8EC6240, 0x1A00000F
.long 0xD3EE8098, 0x0662912A
.long 0xBF8CC67F
.long 0xD3EE80A0, 0x0682912C
.long 0xD8EC62C0, 0x1C00000F
.long 0xD8EC6340, 0x1E00000F
.long 0xD3EE80A8, 0x06A2912E
.long 0xBF8CC67F
.long 0xD3EE80B0, 0x06C29130
.long 0xD8EC63C0, 0x2000000F
.long 0xD8EC6440, 0x2200000F
.long 0xD3EE80B8, 0x06E29132
.long 0xD3EE80C0, 0x07029524
.long 0xD3EE80C8, 0x07229526
.long 0xD3EE80D0, 0x07429528
.long 0xD3EE80D8, 0x0762952A
.long 0xD3EE80E0, 0x0782952C
.long 0xD3EE80E8, 0x07A2952E
.long 0xD3EE80F0, 0x07C29530
.long 0xD3EE80F8, 0x07E29532
.long 0xBF8C0F72
.long 0xBF8A0000
.long 0xBF8CC67F
.long 0xD3EE8080, 0x06029914
.long 0xD8EC70E0, 0x2400000F
.long 0xD8EC7160, 0x2600000F
.long 0xD3EE8088, 0x06229916
.long 0xBF8CC67F
.long 0xD3EE8090, 0x06429918
.long 0xD8EC71E0, 0x2800000F
.long 0xD8EC7260, 0x2A00000F
.long 0xD3EE8098, 0x0662991A
.long 0xBF8CC67F
.long 0xD3EE80A0, 0x0682991C
.long 0xD8EC72E0, 0x2C00000F
.long 0xD8EC7360, 0x2E00000F
.long 0xD3EE80A8, 0x06A2991E
.long 0xBF8CC67F
.long 0xD3EE80B0, 0x06C29920
.long 0xD8EC73E0, 0x3000000F
.long 0xD8EC7460, 0x3200000F
.long 0xD3EE80B8, 0x06E29922
.long 0xD3EE80C0, 0x07029D14
.long 0xD3EE80C8, 0x07229D16
.long 0xD3EE80D0, 0x07429D18
.long 0xD3EE80D8, 0x07629D1A
.long 0xD3D84010, 0x1800013E
.long 0xD3D84011, 0x1800013F
.long 0xD3D84012, 0x1800017E
.long 0xD3D84013, 0x1800017F
.long 0xBF800001
.long 0xBF8C0F70
.long 0xD2800010, 0x2002B110
.long 0xD2800012, 0x2002B512
.long 0xD3EE80E0, 0x07829D1C
.long 0xE07C1000, 0x80041008
.long 0xD3EE80E8, 0x07A29D1E
.long 0xD3EE80F0, 0x07C29D20
.long 0xD3EE80F8, 0x07E29D22
.long 0xBF8C0F72
.long 0xBF8A0000
.long 0xBF8CC67F
.long 0xD3EE8080, 0x0602A124
.long 0xD3EE8088, 0x0622A126
.long 0xBF8CC47F
.long 0xD3EE8090, 0x0642A128
.long 0xD3EE8098, 0x0662A12A
.long 0xBF8CC27F
.long 0xD3EE80A0, 0x0682A12C
.long 0xD3EE80A8, 0x06A2A12E
.long 0xBF8CC07F
.long 0xD3EE80B0, 0x06C2A130
.long 0xD3EE80B8, 0x06E2A132
.long 0xD3EE80C0, 0x0702A524
.long 0xD3EE80C8, 0x0722A526
.long 0xD3EE80D0, 0x0742A528
.long 0xD3EE80D8, 0x0762A52A
.long 0xD3EE80E0, 0x0782A52C
.long 0xD3EE80E8, 0x07A2A52E
.long 0xD3EE80F0, 0x07C2A530
.long 0xD3EE80F8, 0x07E2A532
.long 0xBE9200FF, 0x80000000
.long 0xBF091224
.long 0x850C2412
.long 0xBF068025
.long 0xBE92020C
.long 0xD0C9000C, 0x00009D0A
.long 0xD1000008, 0x0032190E
.long 0xBF820423
.long 0xBF8C0F7C
.long 0xBF8A0000
.long 0xBF8CC67F
.long 0xD3EE8000, 0x04028914
.long 0xD8EC50A0, 0x2400000F
.long 0xD8EC5120, 0x2600000F
.long 0xD3EE8008, 0x04228916
.long 0xBF8CC67F
.long 0xD3EE8010, 0x04428918
.long 0xD8EC51A0, 0x2800000F
.long 0xD8EC5220, 0x2A00000F
.long 0xD3EE8018, 0x0462891A
.long 0xBF8CC67F
.long 0xD3EE8020, 0x0482891C
.long 0xD8EC52A0, 0x2C00000F
.long 0xD8EC5320, 0x2E00000F
.long 0xD3EE8028, 0x04A2891E
.long 0xBF8CC67F
.long 0xD3EE8030, 0x04C28920
.long 0xD8EC53A0, 0x3000000F
.long 0xD8EC5420, 0x3200000F
.long 0xD3EE8038, 0x04E28922
.long 0xD3EE8040, 0x05028D14
.long 0xD3EE8048, 0x05228D16
.long 0xD3EE8050, 0x05428D18
.long 0xD3EE8058, 0x05628D1A
.long 0xD3EE8060, 0x05828D1C
.long 0xE05C1000, 0x80045808
.long 0xD3EE8068, 0x05A28D1E
.long 0xD3EE8070, 0x05C28D20
.long 0xD3EE8078, 0x05E28D22
.long 0xBF8C0F78
.long 0xBF8A0000
.long 0xBF8CC67F
.long 0xD3EE8000, 0x04029124
.long 0xD8EC60C0, 0x1400000F
.long 0xD8EC6140, 0x1600000F
.long 0xD3EE8008, 0x04229126
.long 0xBF8CC67F
.long 0xD3EE8010, 0x04429128
.long 0xD8EC61C0, 0x1800000F
.long 0xD8EC6240, 0x1A00000F
.long 0xD3EE8018, 0x0462912A
.long 0xBF8CC67F
.long 0xD3EE8020, 0x0482912C
.long 0xD8EC62C0, 0x1C00000F
.long 0xD8EC6340, 0x1E00000F
.long 0xD3EE8028, 0x04A2912E
.long 0xBF8CC67F
.long 0xD3EE8030, 0x04C29130
.long 0xD8EC63C0, 0x2000000F
.long 0xD8EC6440, 0x2200000F
.long 0xD3EE8038, 0x04E29132
.long 0xD3EE8040, 0x05029524
.long 0xD3EE8048, 0x05229526
.long 0xD3EE8050, 0x05429528
.long 0xD3EE8058, 0x0562952A
.long 0xD3EE8060, 0x0582952C
.long 0xD3EE8068, 0x05A2952E
.long 0xD3EE8070, 0x05C29530
.long 0xD3EE8078, 0x05E29532
.long 0xBF8C0F72
.long 0xBF8A0000
.long 0xBF8CC67F
.long 0xD3EE8000, 0x04029914
.long 0xD8EC70E0, 0x2400000F
.long 0xD8EC7160, 0x2600000F
.long 0xD3EE8008, 0x04229916
.long 0xBF8CC67F
.long 0xD3EE8010, 0x04429918
.long 0xD8EC71E0, 0x2800000F
.long 0xD8EC7260, 0x2A00000F
.long 0xD3EE8018, 0x0462991A
.long 0xBF8CC67F
.long 0xD3EE8020, 0x0482991C
.long 0xD8EC72E0, 0x2C00000F
.long 0xD8EC7360, 0x2E00000F
.long 0xD3EE8028, 0x04A2991E
.long 0xBF8CC67F
.long 0xD3EE8030, 0x04C29920
.long 0xD8EC73E0, 0x3000000F
.long 0xD8EC7460, 0x3200000F
.long 0xD3EE8038, 0x04E29922
.long 0xD3EE8040, 0x05029D14
.long 0xD3EE8048, 0x05229D16
.long 0xD3EE8050, 0x05429D18
.long 0xD3EE8058, 0x05629D1A
.long 0xD3D84010, 0x180001BE
.long 0xD3D84011, 0x180001BF
.long 0xD3D84012, 0x180001FE
.long 0xD3D84013, 0x180001FF
.long 0xBF800001
.long 0xBF8C0F70
.long 0xD2800010, 0x2002B110
.long 0xD2800012, 0x2002B512
.long 0xD3EE8060, 0x05829D1C
.long 0xE07C1000, 0x80041008
.long 0xD3EE8068, 0x05A29D1E
.long 0xD3EE8070, 0x05C29D20
.long 0xD3EE8078, 0x05E29D22
.long 0xBF8C0F72
.long 0xBF8A0000
.long 0xBF8CC67F
.long 0xD3EE8000, 0x0402A124
.long 0xD3EE8008, 0x0422A126
.long 0xBF8CC47F
.long 0xD3EE8010, 0x0442A128
.long 0xD3EE8018, 0x0462A12A
.long 0xBF8CC27F
.long 0xD3EE8020, 0x0482A12C
.long 0xD3EE8028, 0x04A2A12E
.long 0xBF8CC07F
.long 0xD3EE8030, 0x04C2A130
.long 0xD3EE8038, 0x04E2A132
.long 0xD3EE8040, 0x0502A524
.long 0xD3EE8048, 0x0522A526
.long 0xD3EE8050, 0x0542A528
.long 0xD3EE8058, 0x0562A52A
.long 0xD3EE8060, 0x0582A52C
.long 0xD3EE8068, 0x05A2A52E
.long 0xD3EE8070, 0x05C2A530
.long 0xD3EE8078, 0x05E2A532
.long 0xBE9200FF, 0x80000000
.long 0xBF091224
.long 0x850C2412
.long 0xBF068025
.long 0xBE92020C
.long 0xD0C9000C, 0x00009D0A
.long 0xD1000008, 0x0032190E
.long 0x8010443E
.long 0x8211453F
.long 0xBE8C0110
.long 0xBE8E0012
.long 0xE05C1000, 0x80045408
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xE05C1000, 0x80045808
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xE05C1000, 0x80045C08
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xE05C1000, 0x80046008
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xE05C1000, 0x80046408
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xE05C1000, 0x80046808
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xE05C1000, 0x80046C08
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xE05C1000, 0x80047008
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xE05C1000, 0x80047408
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xE05C1000, 0x80047808
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xE05C1000, 0x80047C08
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xE05C1000, 0x80048008
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xE05C1000, 0x80048408
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xE05C1000, 0x80048808
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xE05C1000, 0x80048C08
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xE05C1000, 0x80049008
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xE05C1000, 0x80049408
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xE05C1000, 0x80049808
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xE05C1000, 0x80049C08
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xE05C1000, 0x8004A008
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xE05C1000, 0x8004A408
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xE05C1000, 0x8004A808
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xE05C1000, 0x8004AC08
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xE05C1000, 0x8004B008
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xE05C1000, 0x8004B408
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xE05C1000, 0x8004B808
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xE05C1000, 0x8004BC08
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xE05C1000, 0x8004C008
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xE05C1000, 0x8004C408
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xE05C1000, 0x8004C808
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xE05C1000, 0x8004CC08
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xE05C1000, 0x8004D008
.long 0xBE90010C
.long 0xBE92000E
.long 0xD3D84010, 0x18000100
.long 0xD3D84011, 0x18000101
.long 0xD3D84012, 0x18000140
.long 0xD3D84013, 0x18000141
.long 0xBF800001
.long 0xBF8C4F7F
.long 0xD2800010, 0x2002A910
.long 0xD2800012, 0x2002AD12
.long 0xE07C1000, 0x80041008
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xD3D84010, 0x18000102
.long 0xD3D84011, 0x18000103
.long 0xD3D84012, 0x18000142
.long 0xD3D84013, 0x18000143
.long 0xBF800001
.long 0xBF8C4F7F
.long 0xD2800010, 0x2002B110
.long 0xD2800012, 0x2002B512
.long 0xE07C1000, 0x80041008
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xD3D84010, 0x18000104
.long 0xD3D84011, 0x18000105
.long 0xD3D84012, 0x18000144
.long 0xD3D84013, 0x18000145
.long 0xBF800001
.long 0xBF8C4F7F
.long 0xD2800010, 0x2002B910
.long 0xD2800012, 0x2002BD12
.long 0xE07C1000, 0x80041008
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xD3D84010, 0x18000106
.long 0xD3D84011, 0x18000107
.long 0xD3D84012, 0x18000146
.long 0xD3D84013, 0x18000147
.long 0xBF800001
.long 0xBF8C4F7F
.long 0xD2800010, 0x2002C110
.long 0xD2800012, 0x2002C512
.long 0xE07C1000, 0x80041008
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xD3D84010, 0x18000108
.long 0xD3D84011, 0x18000109
.long 0xD3D84012, 0x18000148
.long 0xD3D84013, 0x18000149
.long 0xBF800001
.long 0xBF8C4F7F
.long 0xD2800010, 0x2002C910
.long 0xD2800012, 0x2002CD12
.long 0xE07C1000, 0x80041008
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xD3D84010, 0x1800010A
.long 0xD3D84011, 0x1800010B
.long 0xD3D84012, 0x1800014A
.long 0xD3D84013, 0x1800014B
.long 0xBF800001
.long 0xBF8C4F7F
.long 0xD2800010, 0x2002D110
.long 0xD2800012, 0x2002D512
.long 0xE07C1000, 0x80041008
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xD3D84010, 0x1800010C
.long 0xD3D84011, 0x1800010D
.long 0xD3D84012, 0x1800014C
.long 0xD3D84013, 0x1800014D
.long 0xBF800001
.long 0xBF8C4F7F
.long 0xD2800010, 0x2002D910
.long 0xD2800012, 0x2002DD12
.long 0xE07C1000, 0x80041008
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xD3D84010, 0x1800010E
.long 0xD3D84011, 0x1800010F
.long 0xD3D84012, 0x1800014E
.long 0xD3D84013, 0x1800014F
.long 0xBF800001
.long 0xBF8C4F7F
.long 0xD2800010, 0x2002E110
.long 0xD2800012, 0x2002E512
.long 0xE07C1000, 0x80041008
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xD3D84010, 0x18000110
.long 0xD3D84011, 0x18000111
.long 0xD3D84012, 0x18000150
.long 0xD3D84013, 0x18000151
.long 0xBF800001
.long 0xBF8C4F7F
.long 0xD2800010, 0x2002E910
.long 0xD2800012, 0x2002ED12
.long 0xE07C1000, 0x80041008
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xD3D84010, 0x18000112
.long 0xD3D84011, 0x18000113
.long 0xD3D84012, 0x18000152
.long 0xD3D84013, 0x18000153
.long 0xBF800001
.long 0xBF8C4F7F
.long 0xD2800010, 0x2002F110
.long 0xD2800012, 0x2002F512
.long 0xE07C1000, 0x80041008
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xD3D84010, 0x18000114
.long 0xD3D84011, 0x18000115
.long 0xD3D84012, 0x18000154
.long 0xD3D84013, 0x18000155
.long 0xBF800001
.long 0xBF8C4F7F
.long 0xD2800010, 0x2002F910
.long 0xD2800012, 0x2002FD12
.long 0xE07C1000, 0x80041008
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xD3D84010, 0x18000116
.long 0xD3D84011, 0x18000117
.long 0xD3D84012, 0x18000156
.long 0xD3D84013, 0x18000157
.long 0xBF800001
.long 0xBF8C4F7F
.long 0xD2800010, 0x20030110
.long 0xD2800012, 0x20030512
.long 0xE07C1000, 0x80041008
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xD3D84010, 0x18000118
.long 0xD3D84011, 0x18000119
.long 0xD3D84012, 0x18000158
.long 0xD3D84013, 0x18000159
.long 0xBF800001
.long 0xBF8C4F7F
.long 0xD2800010, 0x20030910
.long 0xD2800012, 0x20030D12
.long 0xE07C1000, 0x80041008
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xD3D84010, 0x1800011A
.long 0xD3D84011, 0x1800011B
.long 0xD3D84012, 0x1800015A
.long 0xD3D84013, 0x1800015B
.long 0xBF800001
.long 0xBF8C4F7F
.long 0xD2800010, 0x20031110
.long 0xD2800012, 0x20031512
.long 0xE07C1000, 0x80041008
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xD3D84010, 0x1800011C
.long 0xD3D84011, 0x1800011D
.long 0xD3D84012, 0x1800015C
.long 0xD3D84013, 0x1800015D
.long 0xBF800001
.long 0xBF8C4F7F
.long 0xD2800010, 0x20031910
.long 0xD2800012, 0x20031D12
.long 0xE07C1000, 0x80041008
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xD3D84010, 0x1800011E
.long 0xD3D84011, 0x1800011F
.long 0xD3D84012, 0x1800015E
.long 0xD3D84013, 0x1800015F
.long 0xBF800001
.long 0xBF8C4F7F
.long 0xD2800010, 0x20032110
.long 0xD2800012, 0x20032512
.long 0xE07C1000, 0x80041008
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xD3D84010, 0x18000120
.long 0xD3D84011, 0x18000121
.long 0xD3D84012, 0x18000160
.long 0xD3D84013, 0x18000161
.long 0xBF800001
.long 0xBF8C4F7F
.long 0xD2800010, 0x20032910
.long 0xD2800012, 0x20032D12
.long 0xE07C1000, 0x80041008
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xD3D84010, 0x18000122
.long 0xD3D84011, 0x18000123
.long 0xD3D84012, 0x18000162
.long 0xD3D84013, 0x18000163
.long 0xBF800001
.long 0xBF8C4F7F
.long 0xD2800010, 0x20033110
.long 0xD2800012, 0x20033512
.long 0xE07C1000, 0x80041008
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xD3D84010, 0x18000124
.long 0xD3D84011, 0x18000125
.long 0xD3D84012, 0x18000164
.long 0xD3D84013, 0x18000165
.long 0xBF800001
.long 0xBF8C4F7F
.long 0xD2800010, 0x20033910
.long 0xD2800012, 0x20033D12
.long 0xE07C1000, 0x80041008
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xD3D84010, 0x18000126
.long 0xD3D84011, 0x18000127
.long 0xD3D84012, 0x18000166
.long 0xD3D84013, 0x18000167
.long 0xBF800001
.long 0xBF8C4F7F
.long 0xD2800010, 0x20034110
.long 0xD2800012, 0x20034512
.long 0xE07C1000, 0x80041008
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xD3D84010, 0x18000128
.long 0xD3D84011, 0x18000129
.long 0xD3D84012, 0x18000168
.long 0xD3D84013, 0x18000169
.long 0xBF800001
.long 0xBF8C4F7F
.long 0xD2800010, 0x20034910
.long 0xD2800012, 0x20034D12
.long 0xE07C1000, 0x80041008
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xD3D84010, 0x1800012A
.long 0xD3D84011, 0x1800012B
.long 0xD3D84012, 0x1800016A
.long 0xD3D84013, 0x1800016B
.long 0xBF800001
.long 0xBF8C4F7F
.long 0xD2800010, 0x20035110
.long 0xD2800012, 0x20035512
.long 0xE07C1000, 0x80041008
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xD3D84010, 0x1800012C
.long 0xD3D84011, 0x1800012D
.long 0xD3D84012, 0x1800016C
.long 0xD3D84013, 0x1800016D
.long 0xBF800001
.long 0xBF8C4F7F
.long 0xD2800010, 0x20035910
.long 0xD2800012, 0x20035D12
.long 0xE07C1000, 0x80041008
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xD3D84010, 0x1800012E
.long 0xD3D84011, 0x1800012F
.long 0xD3D84012, 0x1800016E
.long 0xD3D84013, 0x1800016F
.long 0xBF800001
.long 0xBF8C4F7F
.long 0xD2800010, 0x20036110
.long 0xD2800012, 0x20036512
.long 0xE07C1000, 0x80041008
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xD3D84010, 0x18000130
.long 0xD3D84011, 0x18000131
.long 0xD3D84012, 0x18000170
.long 0xD3D84013, 0x18000171
.long 0xBF800001
.long 0xBF8C4F7F
.long 0xD2800010, 0x20036910
.long 0xD2800012, 0x20036D12
.long 0xE07C1000, 0x80041008
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xD3D84010, 0x18000132
.long 0xD3D84011, 0x18000133
.long 0xD3D84012, 0x18000172
.long 0xD3D84013, 0x18000173
.long 0xBF800001
.long 0xBF8C4F7F
.long 0xD2800010, 0x20037110
.long 0xD2800012, 0x20037512
.long 0xE07C1000, 0x80041008
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xD3D84010, 0x18000134
.long 0xD3D84011, 0x18000135
.long 0xD3D84012, 0x18000174
.long 0xD3D84013, 0x18000175
.long 0xBF800001
.long 0xBF8C4F7F
.long 0xD2800010, 0x20037910
.long 0xD2800012, 0x20037D12
.long 0xE07C1000, 0x80041008
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xD3D84010, 0x18000136
.long 0xD3D84011, 0x18000137
.long 0xD3D84012, 0x18000176
.long 0xD3D84013, 0x18000177
.long 0xBF800001
.long 0xBF8C4F7F
.long 0xD2800010, 0x20038110
.long 0xD2800012, 0x20038512
.long 0xE07C1000, 0x80041008
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xD3D84010, 0x18000138
.long 0xD3D84011, 0x18000139
.long 0xD3D84012, 0x18000178
.long 0xD3D84013, 0x18000179
.long 0xBF800001
.long 0xBF8C4F7F
.long 0xD2800010, 0x20038910
.long 0xD2800012, 0x20038D12
.long 0xE07C1000, 0x80041008
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xD3D84010, 0x1800013A
.long 0xD3D84011, 0x1800013B
.long 0xD3D84012, 0x1800017A
.long 0xD3D84013, 0x1800017B
.long 0xBF800001
.long 0xBF8C4F7F
.long 0xD2800010, 0x20039110
.long 0xD2800012, 0x20039512
.long 0xE07C1000, 0x80041008
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xD3D84010, 0x1800013C
.long 0xD3D84011, 0x1800013D
.long 0xD3D84012, 0x1800017C
.long 0xD3D84013, 0x1800017D
.long 0xBF800001
.long 0xBF8C4F7F
.long 0xD2800010, 0x20039910
.long 0xD2800012, 0x20039D12
.long 0xE07C1000, 0x80041008
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xD3D84010, 0x1800013E
.long 0xD3D84011, 0x1800013F
.long 0xD3D84012, 0x1800017E
.long 0xD3D84013, 0x1800017F
.long 0xBF800001
.long 0xBF8C4F7F
.long 0xD2800010, 0x2003A110
.long 0xD2800012, 0x2003A512
.long 0xE07C1000, 0x80041008
.long 0xBF82193C
.long 0x8010443E
.long 0x8211453F
.long 0xBE8C0110
.long 0xBE8E0012
.long 0xE05C1000, 0x80045408
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xE05C1000, 0x80045808
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xE05C1000, 0x80045C08
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xE05C1000, 0x80046008
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xE05C1000, 0x80046408
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xE05C1000, 0x80046808
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xE05C1000, 0x80046C08
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xE05C1000, 0x80047008
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xE05C1000, 0x80047408
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xE05C1000, 0x80047808
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xE05C1000, 0x80047C08
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xE05C1000, 0x80048008
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xE05C1000, 0x80048408
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xE05C1000, 0x80048808
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xE05C1000, 0x80048C08
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xE05C1000, 0x80049008
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xE05C1000, 0x80049408
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xE05C1000, 0x80049808
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xE05C1000, 0x80049C08
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xE05C1000, 0x8004A008
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xE05C1000, 0x8004A408
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xE05C1000, 0x8004A808
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xE05C1000, 0x8004AC08
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xE05C1000, 0x8004B008
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xE05C1000, 0x8004B408
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xE05C1000, 0x8004B808
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xE05C1000, 0x8004BC08
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xE05C1000, 0x8004C008
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xE05C1000, 0x8004C408
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xE05C1000, 0x8004C808
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xE05C1000, 0x8004CC08
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xE05C1000, 0x8004D008
.long 0xBE90010C
.long 0xBE92000E
.long 0xD3D84010, 0x18000180
.long 0xD3D84011, 0x18000181
.long 0xD3D84012, 0x180001C0
.long 0xD3D84013, 0x180001C1
.long 0xBF800001
.long 0xBF8C4F7F
.long 0xD2800010, 0x2002A910
.long 0xD2800012, 0x2002AD12
.long 0xE07C1000, 0x80041008
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xD3D84010, 0x18000182
.long 0xD3D84011, 0x18000183
.long 0xD3D84012, 0x180001C2
.long 0xD3D84013, 0x180001C3
.long 0xBF800001
.long 0xBF8C4F7F
.long 0xD2800010, 0x2002B110
.long 0xD2800012, 0x2002B512
.long 0xE07C1000, 0x80041008
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xD3D84010, 0x18000184
.long 0xD3D84011, 0x18000185
.long 0xD3D84012, 0x180001C4
.long 0xD3D84013, 0x180001C5
.long 0xBF800001
.long 0xBF8C4F7F
.long 0xD2800010, 0x2002B910
.long 0xD2800012, 0x2002BD12
.long 0xE07C1000, 0x80041008
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xD3D84010, 0x18000186
.long 0xD3D84011, 0x18000187
.long 0xD3D84012, 0x180001C6
.long 0xD3D84013, 0x180001C7
.long 0xBF800001
.long 0xBF8C4F7F
.long 0xD2800010, 0x2002C110
.long 0xD2800012, 0x2002C512
.long 0xE07C1000, 0x80041008
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xD3D84010, 0x18000188
.long 0xD3D84011, 0x18000189
.long 0xD3D84012, 0x180001C8
.long 0xD3D84013, 0x180001C9
.long 0xBF800001
.long 0xBF8C4F7F
.long 0xD2800010, 0x2002C910
.long 0xD2800012, 0x2002CD12
.long 0xE07C1000, 0x80041008
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xD3D84010, 0x1800018A
.long 0xD3D84011, 0x1800018B
.long 0xD3D84012, 0x180001CA
.long 0xD3D84013, 0x180001CB
.long 0xBF800001
.long 0xBF8C4F7F
.long 0xD2800010, 0x2002D110
.long 0xD2800012, 0x2002D512
.long 0xE07C1000, 0x80041008
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xD3D84010, 0x1800018C
.long 0xD3D84011, 0x1800018D
.long 0xD3D84012, 0x180001CC
.long 0xD3D84013, 0x180001CD
.long 0xBF800001
.long 0xBF8C4F7F
.long 0xD2800010, 0x2002D910
.long 0xD2800012, 0x2002DD12
.long 0xE07C1000, 0x80041008
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xD3D84010, 0x1800018E
.long 0xD3D84011, 0x1800018F
.long 0xD3D84012, 0x180001CE
.long 0xD3D84013, 0x180001CF
.long 0xBF800001
.long 0xBF8C4F7F
.long 0xD2800010, 0x2002E110
.long 0xD2800012, 0x2002E512
.long 0xE07C1000, 0x80041008
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xD3D84010, 0x18000190
.long 0xD3D84011, 0x18000191
.long 0xD3D84012, 0x180001D0
.long 0xD3D84013, 0x180001D1
.long 0xBF800001
.long 0xBF8C4F7F
.long 0xD2800010, 0x2002E910
.long 0xD2800012, 0x2002ED12
.long 0xE07C1000, 0x80041008
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xD3D84010, 0x18000192
.long 0xD3D84011, 0x18000193
.long 0xD3D84012, 0x180001D2
.long 0xD3D84013, 0x180001D3
.long 0xBF800001
.long 0xBF8C4F7F
.long 0xD2800010, 0x2002F110
.long 0xD2800012, 0x2002F512
.long 0xE07C1000, 0x80041008
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xD3D84010, 0x18000194
.long 0xD3D84011, 0x18000195
.long 0xD3D84012, 0x180001D4
.long 0xD3D84013, 0x180001D5
.long 0xBF800001
.long 0xBF8C4F7F
.long 0xD2800010, 0x2002F910
.long 0xD2800012, 0x2002FD12
.long 0xE07C1000, 0x80041008
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xD3D84010, 0x18000196
.long 0xD3D84011, 0x18000197
.long 0xD3D84012, 0x180001D6
.long 0xD3D84013, 0x180001D7
.long 0xBF800001
.long 0xBF8C4F7F
.long 0xD2800010, 0x20030110
.long 0xD2800012, 0x20030512
.long 0xE07C1000, 0x80041008
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xD3D84010, 0x18000198
.long 0xD3D84011, 0x18000199
.long 0xD3D84012, 0x180001D8
.long 0xD3D84013, 0x180001D9
.long 0xBF800001
.long 0xBF8C4F7F
.long 0xD2800010, 0x20030910
.long 0xD2800012, 0x20030D12
.long 0xE07C1000, 0x80041008
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xD3D84010, 0x1800019A
.long 0xD3D84011, 0x1800019B
.long 0xD3D84012, 0x180001DA
.long 0xD3D84013, 0x180001DB
.long 0xBF800001
.long 0xBF8C4F7F
.long 0xD2800010, 0x20031110
.long 0xD2800012, 0x20031512
.long 0xE07C1000, 0x80041008
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xD3D84010, 0x1800019C
.long 0xD3D84011, 0x1800019D
.long 0xD3D84012, 0x180001DC
.long 0xD3D84013, 0x180001DD
.long 0xBF800001
.long 0xBF8C4F7F
.long 0xD2800010, 0x20031910
.long 0xD2800012, 0x20031D12
.long 0xE07C1000, 0x80041008
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xD3D84010, 0x1800019E
.long 0xD3D84011, 0x1800019F
.long 0xD3D84012, 0x180001DE
.long 0xD3D84013, 0x180001DF
.long 0xBF800001
.long 0xBF8C4F7F
.long 0xD2800010, 0x20032110
.long 0xD2800012, 0x20032512
.long 0xE07C1000, 0x80041008
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xD3D84010, 0x180001A0
.long 0xD3D84011, 0x180001A1
.long 0xD3D84012, 0x180001E0
.long 0xD3D84013, 0x180001E1
.long 0xBF800001
.long 0xBF8C4F7F
.long 0xD2800010, 0x20032910
.long 0xD2800012, 0x20032D12
.long 0xE07C1000, 0x80041008
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xD3D84010, 0x180001A2
.long 0xD3D84011, 0x180001A3
.long 0xD3D84012, 0x180001E2
.long 0xD3D84013, 0x180001E3
.long 0xBF800001
.long 0xBF8C4F7F
.long 0xD2800010, 0x20033110
.long 0xD2800012, 0x20033512
.long 0xE07C1000, 0x80041008
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xD3D84010, 0x180001A4
.long 0xD3D84011, 0x180001A5
.long 0xD3D84012, 0x180001E4
.long 0xD3D84013, 0x180001E5
.long 0xBF800001
.long 0xBF8C4F7F
.long 0xD2800010, 0x20033910
.long 0xD2800012, 0x20033D12
.long 0xE07C1000, 0x80041008
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xD3D84010, 0x180001A6
.long 0xD3D84011, 0x180001A7
.long 0xD3D84012, 0x180001E6
.long 0xD3D84013, 0x180001E7
.long 0xBF800001
.long 0xBF8C4F7F
.long 0xD2800010, 0x20034110
.long 0xD2800012, 0x20034512
.long 0xE07C1000, 0x80041008
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xD3D84010, 0x180001A8
.long 0xD3D84011, 0x180001A9
.long 0xD3D84012, 0x180001E8
.long 0xD3D84013, 0x180001E9
.long 0xBF800001
.long 0xBF8C4F7F
.long 0xD2800010, 0x20034910
.long 0xD2800012, 0x20034D12
.long 0xE07C1000, 0x80041008
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xD3D84010, 0x180001AA
.long 0xD3D84011, 0x180001AB
.long 0xD3D84012, 0x180001EA
.long 0xD3D84013, 0x180001EB
.long 0xBF800001
.long 0xBF8C4F7F
.long 0xD2800010, 0x20035110
.long 0xD2800012, 0x20035512
.long 0xE07C1000, 0x80041008
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xD3D84010, 0x180001AC
.long 0xD3D84011, 0x180001AD
.long 0xD3D84012, 0x180001EC
.long 0xD3D84013, 0x180001ED
.long 0xBF800001
.long 0xBF8C4F7F
.long 0xD2800010, 0x20035910
.long 0xD2800012, 0x20035D12
.long 0xE07C1000, 0x80041008
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xD3D84010, 0x180001AE
.long 0xD3D84011, 0x180001AF
.long 0xD3D84012, 0x180001EE
.long 0xD3D84013, 0x180001EF
.long 0xBF800001
.long 0xBF8C4F7F
.long 0xD2800010, 0x20036110
.long 0xD2800012, 0x20036512
.long 0xE07C1000, 0x80041008
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xD3D84010, 0x180001B0
.long 0xD3D84011, 0x180001B1
.long 0xD3D84012, 0x180001F0
.long 0xD3D84013, 0x180001F1
.long 0xBF800001
.long 0xBF8C4F7F
.long 0xD2800010, 0x20036910
.long 0xD2800012, 0x20036D12
.long 0xE07C1000, 0x80041008
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xD3D84010, 0x180001B2
.long 0xD3D84011, 0x180001B3
.long 0xD3D84012, 0x180001F2
.long 0xD3D84013, 0x180001F3
.long 0xBF800001
.long 0xBF8C4F7F
.long 0xD2800010, 0x20037110
.long 0xD2800012, 0x20037512
.long 0xE07C1000, 0x80041008
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xD3D84010, 0x180001B4
.long 0xD3D84011, 0x180001B5
.long 0xD3D84012, 0x180001F4
.long 0xD3D84013, 0x180001F5
.long 0xBF800001
.long 0xBF8C4F7F
.long 0xD2800010, 0x20037910
.long 0xD2800012, 0x20037D12
.long 0xE07C1000, 0x80041008
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xD3D84010, 0x180001B6
.long 0xD3D84011, 0x180001B7
.long 0xD3D84012, 0x180001F6
.long 0xD3D84013, 0x180001F7
.long 0xBF800001
.long 0xBF8C4F7F
.long 0xD2800010, 0x20038110
.long 0xD2800012, 0x20038512
.long 0xE07C1000, 0x80041008
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xD3D84010, 0x180001B8
.long 0xD3D84011, 0x180001B9
.long 0xD3D84012, 0x180001F8
.long 0xD3D84013, 0x180001F9
.long 0xBF800001
.long 0xBF8C4F7F
.long 0xD2800010, 0x20038910
.long 0xD2800012, 0x20038D12
.long 0xE07C1000, 0x80041008
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xD3D84010, 0x180001BA
.long 0xD3D84011, 0x180001BB
.long 0xD3D84012, 0x180001FA
.long 0xD3D84013, 0x180001FB
.long 0xBF800001
.long 0xBF8C4F7F
.long 0xD2800010, 0x20039110
.long 0xD2800012, 0x20039512
.long 0xE07C1000, 0x80041008
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xD3D84010, 0x180001BC
.long 0xD3D84011, 0x180001BD
.long 0xD3D84012, 0x180001FC
.long 0xD3D84013, 0x180001FD
.long 0xBF800001
.long 0xBF8C4F7F
.long 0xD2800010, 0x20039910
.long 0xD2800012, 0x20039D12
.long 0xE07C1000, 0x80041008
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xD3D84010, 0x180001BE
.long 0xD3D84011, 0x180001BF
.long 0xD3D84012, 0x180001FE
.long 0xD3D84013, 0x180001FF
.long 0xBF800001
.long 0xBF8C4F7F
.long 0xD2800010, 0x2003A110
.long 0xD2800012, 0x2003A512
.long 0xE07C1000, 0x80041008
.long 0xBF8215FD
.long 0xBE9D0080
.long 0xBE9E0080
.long 0x8010443E
.long 0x8211453F
.long 0xBEFC001C
.long 0xBF8C0F7B
.long 0xBF8A0000
.long 0xBF8CC67F
.long 0xD3EE8080, 0x06026914
.long 0xD8EC1020, 0x2400000F
.long 0xD8EC10A0, 0x2600000F
.long 0xE0511000, 0x80020707
.long 0xD3EE8088, 0x06226916
.long 0xBF8CC67F
.long 0xD3EE8090, 0x06426918
.long 0xD8EC1120, 0x2800000F
.long 0xD8EC11A0, 0x2A00000F
.long 0xE0511100, 0x80020707
.long 0xD3EE8098, 0x0662691A
.long 0xBF8CC67F
.long 0xD3EE80A0, 0x0682691C
.long 0xD8EC1220, 0x2C00000F
.long 0xD8EC12A0, 0x2E00000F
.long 0xE0511200, 0x80020707
.long 0xD3EE80A8, 0x06A2691E
.long 0xBF8CC67F
.long 0xD3EE80B0, 0x06C26920
.long 0xD8EC1320, 0x3000000F
.long 0xD8EC13A0, 0x3200000F
.long 0xE0511300, 0x80020707
.long 0xD3EE80B8, 0x06E26922
.long 0xD3EE80C0, 0x07026D14
.long 0xE05C1000, 0x80014406
.long 0xD3EE80C8, 0x07226D16
.long 0xB71C1020
.long 0x80081508
.long 0x82098009
.long 0xD3EE80D0, 0x07426D18
.long 0x80041404
.long 0x82058005
.long 0xD3EE80D8, 0x07626D1A
.long 0xD3EE80E0, 0x07826D1C
.long 0xE0541000, 0x80045408
.long 0xE0541000, 0x80045609
.long 0xD3EE80E8, 0x07A26D1E
.long 0xD3EE80F0, 0x07C26D20
.long 0xD3EE80F8, 0x07E26D22
.long 0xBEFC001C
.long 0xBF8C0F7D
.long 0xBF8A0000
.long 0xBF8CC67F
.long 0xD3EE8080, 0x06027124
.long 0xD8EC2040, 0x1400000F
.long 0xD8EC20C0, 0x1600000F
.long 0xE0511000, 0x80020707
.long 0xD3EE8088, 0x06227126
.long 0xBF8CC67F
.long 0xD3EE8090, 0x06427128
.long 0xD8EC2140, 0x1800000F
.long 0xD8EC21C0, 0x1A00000F
.long 0xE0511100, 0x80020707
.long 0xD3EE8098, 0x0662712A
.long 0xBF8CC67F
.long 0xD3EE80A0, 0x0682712C
.long 0xD8EC2240, 0x1C00000F
.long 0xD8EC22C0, 0x1E00000F
.long 0xE0511200, 0x80020707
.long 0xD3EE80A8, 0x06A2712E
.long 0xBF8CC67F
.long 0xD3EE80B0, 0x06C27130
.long 0xD8EC2340, 0x2000000F
.long 0xD8EC23C0, 0x2200000F
.long 0xE0511300, 0x80020707
.long 0xD3EE80B8, 0x06E27132
.long 0xD3EE80C0, 0x07027524
.long 0xE05C1000, 0x80014806
.long 0xD3EE80C8, 0x07227526
.long 0xB71C1020
.long 0x80081508
.long 0x82098009
.long 0xD3EE80D0, 0x07427528
.long 0x80041404
.long 0x82058005
.long 0xD3EE80D8, 0x0762752A
.long 0xD3EE80E0, 0x0782752C
.long 0xD3EE80E8, 0x07A2752E
.long 0xD3EE80F0, 0x07C27530
.long 0xD3EE80F8, 0x07E27532
.long 0xBEFC001C
.long 0xBF8C0F7D
.long 0xBF8A0000
.long 0xBF8CC67F
.long 0xD3EE8080, 0x06027914
.long 0xD8EC3060, 0x2400000F
.long 0xD8EC30E0, 0x2600000F
.long 0xE0511000, 0x80020707
.long 0xD3EE8088, 0x06227916
.long 0xBF8CC67F
.long 0xD3EE8090, 0x06427918
.long 0xD8EC3160, 0x2800000F
.long 0xD8EC31E0, 0x2A00000F
.long 0xE0511100, 0x80020707
.long 0xD3EE8098, 0x0662791A
.long 0xBF8CC67F
.long 0xD3EE80A0, 0x0682791C
.long 0xD8EC3260, 0x2C00000F
.long 0xD8EC32E0, 0x2E00000F
.long 0xE0511200, 0x80020707
.long 0xD3EE80A8, 0x06A2791E
.long 0xBF8CC67F
.long 0xD3EE80B0, 0x06C27920
.long 0xD8EC3360, 0x3000000F
.long 0xD8EC33E0, 0x3200000F
.long 0xE0511300, 0x80020707
.long 0xD3EE80B8, 0x06E27922
.long 0xD3EE80C0, 0x07027D14
.long 0xE05C1000, 0x80014C06
.long 0xD3EE80C8, 0x07227D16
.long 0xB71C1020
.long 0x80081508
.long 0x82098009
.long 0xD3EE80D0, 0x07427D18
.long 0x80041404
.long 0x82058005
.long 0xD3EE80D8, 0x07627D1A
.long 0xBF11011E
.long 0xD3D84010, 0x18000100
.long 0xD3D84011, 0x18000101
.long 0xD3D84012, 0x18000140
.long 0xD3D84013, 0x18000141
.long 0xBF800001
.long 0xBF9C0000
.long 0xBF8C0F7A
.long 0xD2800010, 0x2002A910
.long 0xD2800012, 0x2002AD12
.long 0xD3EE80E0, 0x07827D1C
.long 0xE0741000, 0x80041008
.long 0xE0741000, 0x80041209
.long 0xD3EE80E8, 0x07A27D1E
.long 0x80101910
.long 0x82118011
.long 0xD3EE80F0, 0x07C27D20
.long 0x80921912
.long 0xBE920280
.long 0xD3EE80F8, 0x07E27D22
.long 0xBEFC001C
.long 0xBF8C0F7F
.long 0xBF8A0000
.long 0xBF8CC67F
.long 0xD3EE8080, 0x06028124
.long 0xD8EC4080, 0x1400000F
.long 0xD8EC4100, 0x1600000F
.long 0xE0511000, 0x80020707
.long 0xD3EE8088, 0x06228126
.long 0xBF8CC67F
.long 0xD3EE8090, 0x06428128
.long 0xD8EC4180, 0x1800000F
.long 0xD8EC4200, 0x1A00000F
.long 0xE0511100, 0x80020707
.long 0xD3EE8098, 0x0662812A
.long 0xBF8CC67F
.long 0xD3EE80A0, 0x0682812C
.long 0xD8EC4280, 0x1C00000F
.long 0xD8EC4300, 0x1E00000F
.long 0xE0511200, 0x80020707
.long 0xD3EE80A8, 0x06A2812E
.long 0xBF8CC67F
.long 0xD3EE80B0, 0x06C28130
.long 0xD8EC4380, 0x2000000F
.long 0xD8EC4400, 0x2200000F
.long 0xE0511300, 0x80020707
.long 0xD3EE80B8, 0x06E28132
.long 0xD3EE80C0, 0x07028524
.long 0xE05C1000, 0x80015006
.long 0xD3EE80C8, 0x07228526
.long 0xBE9C0016
.long 0x80081508
.long 0x82098009
.long 0xD3EE80D0, 0x07428528
.long 0x80041404
.long 0x82058005
.long 0xD3EE80D8, 0x0762852A
.long 0xD3EE80E0, 0x0782852C
.long 0xD3EE80E8, 0x07A2852E
.long 0xD3EE80F0, 0x07C28530
.long 0xD3EE80F8, 0x07E28532
.long 0xBEFC001C
.long 0xBF8C0F7D
.long 0xBF8A0000
.long 0xBF8CC67F
.long 0xD3EE8080, 0x06028914
.long 0xD8EC50A0, 0x2400000F
.long 0xD8EC5120, 0x2600000F
.long 0xE0511000, 0x80020707
.long 0xD3EE8088, 0x06228916
.long 0xBF8CC67F
.long 0xD3EE8090, 0x06428918
.long 0xD8EC51A0, 0x2800000F
.long 0xD8EC5220, 0x2A00000F
.long 0xE0511100, 0x80020707
.long 0xD3EE8098, 0x0662891A
.long 0xBF8CC67F
.long 0xD3EE80A0, 0x0682891C
.long 0xD8EC52A0, 0x2C00000F
.long 0xD8EC5320, 0x2E00000F
.long 0xE0511200, 0x80020707
.long 0xD3EE80A8, 0x06A2891E
.long 0xBF8CC67F
.long 0xD3EE80B0, 0x06C28920
.long 0xD8EC53A0, 0x3000000F
.long 0xD8EC5420, 0x3200000F
.long 0xE0511300, 0x80020707
.long 0xD3EE80B8, 0x06E28922
.long 0xD3EE80C0, 0x07028D14
.long 0xE05C1000, 0x80013406
.long 0xD3EE80C8, 0x07228D16
.long 0xB71C1020
.long 0x80081508
.long 0x82098009
.long 0xD3EE80D0, 0x07428D18
.long 0x80041404
.long 0x82058005
.long 0xD3EE80D8, 0x07628D1A
.long 0xD3EE80E0, 0x07828D1C
.long 0xE0541000, 0x80045808
.long 0xE0541000, 0x80045A09
.long 0xD3EE80E8, 0x07A28D1E
.long 0xD3EE80F0, 0x07C28D20
.long 0xD3EE80F8, 0x07E28D22
.long 0xBEFC001C
.long 0xBF8C0F7F
.long 0xBF8A0000
.long 0xBF8CC67F
.long 0xD3EE8080, 0x06029124
.long 0xD8EC60C0, 0x1400000F
.long 0xD8EC6140, 0x1600000F
.long 0xE0511000, 0x80020707
.long 0xD3EE8088, 0x06229126
.long 0xBF8CC67F
.long 0xD3EE8090, 0x06429128
.long 0xD8EC61C0, 0x1800000F
.long 0xD8EC6240, 0x1A00000F
.long 0xE0511100, 0x80020707
.long 0xD3EE8098, 0x0662912A
.long 0xBF8CC67F
.long 0xD3EE80A0, 0x0682912C
.long 0xD8EC62C0, 0x1C00000F
.long 0xD8EC6340, 0x1E00000F
.long 0xE0511200, 0x80020707
.long 0xD3EE80A8, 0x06A2912E
.long 0xBF8CC67F
.long 0xD3EE80B0, 0x06C29130
.long 0xD8EC63C0, 0x2000000F
.long 0xD8EC6440, 0x2200000F
.long 0xE0511300, 0x80020707
.long 0xD3EE80B8, 0x06E29132
.long 0xD3EE80C0, 0x07029524
.long 0xE05C1000, 0x80013806
.long 0xD3EE80C8, 0x07229526
.long 0xB71C1020
.long 0x80081508
.long 0x82098009
.long 0xD3EE80D0, 0x07429528
.long 0x80041404
.long 0x82058005
.long 0xD3EE80D8, 0x0762952A
.long 0xD3EE80E0, 0x0782952C
.long 0xD3EE80E8, 0x07A2952E
.long 0xD3EE80F0, 0x07C29530
.long 0xD3EE80F8, 0x07E29532
.long 0xBEFC001C
.long 0xBF8C0F7D
.long 0xBF8A0000
.long 0xBF8CC67F
.long 0xD3EE8080, 0x06029914
.long 0xD8EC70E0, 0x2400000F
.long 0xD8EC7160, 0x2600000F
.long 0xE0511000, 0x80020707
.long 0xD3EE8088, 0x06229916
.long 0xBF8CC67F
.long 0xD3EE8090, 0x06429918
.long 0xD8EC71E0, 0x2800000F
.long 0xD8EC7260, 0x2A00000F
.long 0xE0511100, 0x80020707
.long 0xD3EE8098, 0x0662991A
.long 0xBF8CC67F
.long 0xD3EE80A0, 0x0682991C
.long 0xD8EC72E0, 0x2C00000F
.long 0xD8EC7360, 0x2E00000F
.long 0xE0511200, 0x80020707
.long 0xD3EE80A8, 0x06A2991E
.long 0xBF8CC67F
.long 0xD3EE80B0, 0x06C29920
.long 0xD8EC73E0, 0x3000000F
.long 0xD8EC7460, 0x3200000F
.long 0xE0511300, 0x80020707
.long 0xD3EE80B8, 0x06E29922
.long 0xD3EE80C0, 0x07029D14
.long 0xE05C1000, 0x80013C06
.long 0xD3EE80C8, 0x07229D16
.long 0xB71C1020
.long 0x80081508
.long 0x82098009
.long 0xD3EE80D0, 0x07429D18
.long 0x80041404
.long 0x82058005
.long 0xD3EE80D8, 0x07629D1A
.long 0xBF11011E
.long 0xD3D84010, 0x18000102
.long 0xD3D84011, 0x18000103
.long 0xD3D84012, 0x18000142
.long 0xD3D84013, 0x18000143
.long 0xBF800001
.long 0xBF9C0000
.long 0xBF8C0F7A
.long 0xD2800010, 0x2002B110
.long 0xD2800012, 0x2002B512
.long 0xD3EE80E0, 0x07829D1C
.long 0xE0741000, 0x80041008
.long 0xE0741000, 0x80041209
.long 0xD3EE80E8, 0x07A29D1E
.long 0x80101910
.long 0x82118011
.long 0xD3EE80F0, 0x07C29D20
.long 0x80921912
.long 0xBE920280
.long 0xD3EE80F8, 0x07E29D22
.long 0xBEFC001C
.long 0xBF8C0F7F
.long 0xBF8A0000
.long 0xBF8CC67F
.long 0xD3EE8080, 0x0602A124
.long 0xD8EC0000, 0x1400000F
.long 0xD8EC0080, 0x1600000F
.long 0xE0511000, 0x80020707
.long 0xD3EE8088, 0x0622A126
.long 0xBF8CC67F
.long 0xD3EE8090, 0x0642A128
.long 0xD8EC0100, 0x1800000F
.long 0xD8EC0180, 0x1A00000F
.long 0xE0511100, 0x80020707
.long 0xD3EE8098, 0x0662A12A
.long 0xBF8CC67F
.long 0xD3EE80A0, 0x0682A12C
.long 0xD8EC0200, 0x1C00000F
.long 0xD8EC0280, 0x1E00000F
.long 0xE0511200, 0x80020707
.long 0xD3EE80A8, 0x06A2A12E
.long 0xBF8CC67F
.long 0xD3EE80B0, 0x06C2A130
.long 0xD8EC0300, 0x2000000F
.long 0xD8EC0380, 0x2200000F
.long 0xE0511300, 0x80020707
.long 0xD3EE80B8, 0x06E2A132
.long 0xD3EE80C0, 0x0702A524
.long 0xE05C1000, 0x80014006
.long 0xD3EE80C8, 0x0722A526
.long 0xB71C1020
.long 0x80081508
.long 0x82098009
.long 0xD3EE80D0, 0x0742A528
.long 0x80041404
.long 0x82058005
.long 0xD3EE80D8, 0x0762A52A
.long 0xD3EE80E0, 0x0782A52C
.long 0xD3EE80E8, 0x07A2A52E
.long 0xD3EE80F0, 0x07C2A530
.long 0xD3EE80F8, 0x07E2A532
.long 0xB71E0004
.long 0xB71D0008
.long 0xB31D0078
.long 0xBF85FD94
.long 0xBEFC001C
.long 0xBF8C0F7D
.long 0xBF8A0000
.long 0xBF8CC67F
.long 0xD3EE8080, 0x06026914
.long 0xD8EC1020, 0x2400000F
.long 0xD8EC10A0, 0x2600000F
.long 0xE0511000, 0x80020707
.long 0xD3EE8088, 0x06226916
.long 0xBF8CC67F
.long 0xD3EE8090, 0x06426918
.long 0xD8EC1120, 0x2800000F
.long 0xD8EC11A0, 0x2A00000F
.long 0xE0511100, 0x80020707
.long 0xD3EE8098, 0x0662691A
.long 0xBF8CC67F
.long 0xD3EE80A0, 0x0682691C
.long 0xD8EC1220, 0x2C00000F
.long 0xD8EC12A0, 0x2E00000F
.long 0xE0511200, 0x80020707
.long 0xD3EE80A8, 0x06A2691E
.long 0xBF8CC67F
.long 0xD3EE80B0, 0x06C26920
.long 0xD8EC1320, 0x3000000F
.long 0xD8EC13A0, 0x3200000F
.long 0xE0511300, 0x80020707
.long 0xD3EE80B8, 0x06E26922
.long 0xB71C1020
.long 0xD3EE80C0, 0x07026D14
.long 0xE05C1000, 0x80014406
.long 0xD3EE80C8, 0x07226D16
.long 0x80081508
.long 0x82098009
.long 0xD3EE80D0, 0x07426D18
.long 0x80041404
.long 0x82058005
.long 0xD3EE80D8, 0x07626D1A
.long 0xD3EE80E0, 0x07826D1C
.long 0xE0541000, 0x80045408
.long 0xE0541000, 0x80045609
.long 0xD3EE80E8, 0x07A26D1E
.long 0xD3EE80F0, 0x07C26D20
.long 0xD3EE80F8, 0x07E26D22
.long 0xBEFC001C
.long 0xBF8C0F7F
.long 0xBF8A0000
.long 0xBF8CC67F
.long 0xD3EE8080, 0x06027124
.long 0xD8EC2040, 0x1400000F
.long 0xD8EC20C0, 0x1600000F
.long 0xE0511000, 0x80020707
.long 0xD3EE8088, 0x06227126
.long 0xBF8CC67F
.long 0xD3EE8090, 0x06427128
.long 0xD8EC2140, 0x1800000F
.long 0xD8EC21C0, 0x1A00000F
.long 0xE0511100, 0x80020707
.long 0xD3EE8098, 0x0662712A
.long 0xBF8CC67F
.long 0xD3EE80A0, 0x0682712C
.long 0xD8EC2240, 0x1C00000F
.long 0xD8EC22C0, 0x1E00000F
.long 0xE0511200, 0x80020707
.long 0xD3EE80A8, 0x06A2712E
.long 0xBF8CC67F
.long 0xD3EE80B0, 0x06C27130
.long 0xD8EC2340, 0x2000000F
.long 0xD8EC23C0, 0x2200000F
.long 0xE0511300, 0x80020707
.long 0xD3EE80B8, 0x06E27132
.long 0xB71C1020
.long 0xD3EE80C0, 0x07027524
.long 0xE05C1000, 0x80014806
.long 0xD3EE80C8, 0x07227526
.long 0x80081508
.long 0x82098009
.long 0xD3EE80D0, 0x07427528
.long 0x80041404
.long 0x82058005
.long 0xD3EE80D8, 0x0762752A
.long 0xD3EE80E0, 0x0782752C
.long 0xD3EE80E8, 0x07A2752E
.long 0xD3EE80F0, 0x07C27530
.long 0xD3EE80F8, 0x07E27532
.long 0xBEFC001C
.long 0xBF8C0F7D
.long 0xBF8A0000
.long 0xBF8CC67F
.long 0xD3EE8080, 0x06027914
.long 0xD8EC3060, 0x2400000F
.long 0xD8EC30E0, 0x2600000F
.long 0xE0511000, 0x80020707
.long 0xD3EE8088, 0x06227916
.long 0xBF8CC67F
.long 0xD3EE8090, 0x06427918
.long 0xD8EC3160, 0x2800000F
.long 0xD8EC31E0, 0x2A00000F
.long 0xE0511100, 0x80020707
.long 0xD3EE8098, 0x0662791A
.long 0xBF8CC67F
.long 0xD3EE80A0, 0x0682791C
.long 0xD8EC3260, 0x2C00000F
.long 0xD8EC32E0, 0x2E00000F
.long 0xE0511200, 0x80020707
.long 0xD3EE80A8, 0x06A2791E
.long 0xBF8CC67F
.long 0xD3EE80B0, 0x06C27920
.long 0xD8EC3360, 0x3000000F
.long 0xD8EC33E0, 0x3200000F
.long 0xE0511300, 0x80020707
.long 0xD3EE80B8, 0x06E27922
.long 0xB71C1020
.long 0xD3EE80C0, 0x07027D14
.long 0xE05C1000, 0x80014C06
.long 0xD3EE80C8, 0x07227D16
.long 0x80081508
.long 0x82098009
.long 0xD3EE80D0, 0x07427D18
.long 0x80041404
.long 0x82058005
.long 0xD3EE80D8, 0x07627D1A
.long 0xD3D84010, 0x1800013C
.long 0xD3D84011, 0x1800013D
.long 0xD3D84012, 0x1800017C
.long 0xD3D84013, 0x1800017D
.long 0xBF800001
.long 0xBF8C0F7A
.long 0xD2800010, 0x2002A910
.long 0xD2800012, 0x2002AD12
.long 0xD3EE80E0, 0x07827D1C
.long 0xE0741000, 0x80041008
.long 0xE0741000, 0x80041209
.long 0xD3EE80E8, 0x07A27D1E
.long 0x80101910
.long 0x82118011
.long 0xD3EE80F0, 0x07C27D20
.long 0x80921912
.long 0xBE920280
.long 0xD3EE80F8, 0x07E27D22
.long 0x808C0426
.long 0x828D0527
.long 0xBE86000C
.long 0x808C0828
.long 0x828D0929
.long 0xBE8A000C
.long 0xBEFC001C
.long 0xBF8C0F7F
.long 0xBF8A0000
.long 0xBF8CC67F
.long 0xD3EE8080, 0x06028124
.long 0xD8EC4080, 0x1400000F
.long 0xD8EC4100, 0x1600000F
.long 0xE0511000, 0x80020707
.long 0xD3EE8088, 0x06228126
.long 0xBF8CC67F
.long 0xD3EE8090, 0x06428128
.long 0xD8EC4180, 0x1800000F
.long 0xD8EC4200, 0x1A00000F
.long 0xE0511100, 0x80020707
.long 0xD3EE8098, 0x0662812A
.long 0xBF8CC67F
.long 0xD3EE80A0, 0x0682812C
.long 0xD8EC4280, 0x1C00000F
.long 0xD8EC4300, 0x1E00000F
.long 0xE0511200, 0x80020707
.long 0xD3EE80A8, 0x06A2812E
.long 0xBF8CC67F
.long 0xD3EE80B0, 0x06C28130
.long 0xD8EC4380, 0x2000000F
.long 0xD8EC4400, 0x2200000F
.long 0xE0511300, 0x80020707
.long 0xD3EE80B8, 0x06E28132
.long 0xBE9C0016
.long 0xD3EE80C0, 0x07028524
.long 0xE05C1000, 0x80015006
.long 0xD3EE80C8, 0x07228526
.long 0xD3EE80D0, 0x07428528
.long 0xD3EE80D8, 0x0762852A
.long 0xD3EE80E0, 0x0782852C
.long 0xD3EE80E8, 0x07A2852E
.long 0xD3EE80F0, 0x07C28530
.long 0xD3EE80F8, 0x07E28532
.long 0xB00C0100
.long 0x920F320C
.long 0x920EFF18, 0x00000080
.long 0x920C330E
.long 0x960D330E
.long 0x800C0F0C
.long 0x820D800D
.long 0x8E8C820C
.long 0x920E30FF, 0x00000100
.long 0x803E0E0C
.long 0x823F800D
.long 0x80A40C2A
.long 0x82A50D2B
.long 0x924EFF32, 0x00000080
.long 0x80CE4E1F
.long 0x81313831
.long 0xBF031731
.long 0xBF85089E
.long 0x814C384C
.long 0x818C494C
.long 0x810D814D
.long 0xBF03494C
.long 0xBECC020C
.long 0xBECD020D
.long 0x960D3631
.long 0x8F0E9F37
.long 0x920C0E31
.long 0x800C0D0C
.long 0x860EFF37, 0x7FFFFFFF
.long 0x8F330E0C
.long 0x92323433
.long 0x80B23231
.long 0xBF033534
.long 0x85463332
.long 0x85473233
.long 0xBF033849
.long 0xBEC6024C
.long 0xBEC7024D
.long 0xBE8F004B
.long 0x960D0F47
.long 0x920C0F47
.long 0x8F8C9F0C
.long 0x920D4A0C
.long 0x808D0D47
.long 0x920D490D
.long 0x800D460D
.long 0xBF09390C
.long 0xBE8F023B
.long 0x850E4A3A
.long 0x96470F0D
.long 0x92460F0D
.long 0x8FC69F46
.long 0x92470E46
.long 0x80C7470D
.long 0x920C4A0C
.long 0x80470C47
.long 0xBF033534
.long 0x85324746
.long 0x85334647
.long 0x8E0C8A32
.long 0x810C1A0C
.long 0x80040C40
.long 0x82058041
.long 0xBE8600FF, 0x80000000
.long 0x8E0C8A33
.long 0x800C1B0C
.long 0x80080C42
.long 0x82098043
.long 0xBE8A00FF, 0x80000000
.long 0xBEFC001C
.long 0xBF8C0F7D
.long 0xBF8A0000
.long 0xBF8CC67F
.long 0xD3EE8080, 0x06028914
.long 0xD8EC50A0, 0x2400000F
.long 0xD8EC5120, 0x2600000F
.long 0xE0511000, 0x80020707
.long 0xD3EE8088, 0x06228916
.long 0xBF8CC67F
.long 0xD3EE8090, 0x06428918
.long 0xD8EC51A0, 0x2800000F
.long 0xD8EC5220, 0x2A00000F
.long 0xE0511100, 0x80020707
.long 0xD3EE8098, 0x0662891A
.long 0xBF8CC67F
.long 0xD3EE80A0, 0x0682891C
.long 0xD8EC52A0, 0x2C00000F
.long 0xD8EC5320, 0x2E00000F
.long 0xE0511200, 0x80020707
.long 0xD3EE80A8, 0x06A2891E
.long 0xBF8CC67F
.long 0xD3EE80B0, 0x06C28920
.long 0xD8EC53A0, 0x3000000F
.long 0xD8EC5420, 0x3200000F
.long 0xE0511300, 0x80020707
.long 0xD3EE80B8, 0x06E28922
.long 0xB71C1020
.long 0xD3EE80C0, 0x07028D14
.long 0xE05C1000, 0x80013406
.long 0xD3EE80C8, 0x07228D16
.long 0x80081508
.long 0x82098009
.long 0xD3EE80D0, 0x07428D18
.long 0x80041404
.long 0x82058005
.long 0xD3EE80D8, 0x07628D1A
.long 0xD3EE80E0, 0x07828D1C
.long 0xE0541000, 0x80045808
.long 0xE0541000, 0x80045A09
.long 0xD3EE80E8, 0x07A28D1E
.long 0xD3EE80F0, 0x07C28D20
.long 0xD3EE80F8, 0x07E28D22
.long 0xBEFC001C
.long 0xBF8C0F7F
.long 0xBF8A0000
.long 0xBF8CC67F
.long 0xD3EE8080, 0x06029124
.long 0xD8EC60C0, 0x1400000F
.long 0xD8EC6140, 0x1600000F
.long 0xE0511000, 0x80020707
.long 0xD3EE8088, 0x06229126
.long 0xBF8CC67F
.long 0xD3EE8090, 0x06429128
.long 0xD8EC61C0, 0x1800000F
.long 0xD8EC6240, 0x1A00000F
.long 0xE0511100, 0x80020707
.long 0xD3EE8098, 0x0662912A
.long 0xBF8CC67F
.long 0xD3EE80A0, 0x0682912C
.long 0xD8EC62C0, 0x1C00000F
.long 0xD8EC6340, 0x1E00000F
.long 0xE0511200, 0x80020707
.long 0xD3EE80A8, 0x06A2912E
.long 0xBF8CC67F
.long 0xD3EE80B0, 0x06C29130
.long 0xD8EC63C0, 0x2000000F
.long 0xD8EC6440, 0x2200000F
.long 0xE0511300, 0x80020707
.long 0xD3EE80B8, 0x06E29132
.long 0xB71C1020
.long 0xD3EE80C0, 0x07029524
.long 0xE05C1000, 0x80013806
.long 0xD3EE80C8, 0x07229526
.long 0x80081508
.long 0x82098009
.long 0xD3EE80D0, 0x07429528
.long 0x80041404
.long 0x82058005
.long 0xD3EE80D8, 0x0762952A
.long 0xD3EE80E0, 0x0782952C
.long 0xD3EE80E8, 0x07A2952E
.long 0xD3EE80F0, 0x07C29530
.long 0xD3EE80F8, 0x07E29532
.long 0xBEFC001C
.long 0xBF8C0F7D
.long 0xBF8A0000
.long 0xBF8CC67F
.long 0xD3EE8080, 0x06029914
.long 0xD8EC70E0, 0x2400000F
.long 0xD8EC7160, 0x2600000F
.long 0xE0511000, 0x80020707
.long 0xD3EE8088, 0x06229916
.long 0xBF8CC67F
.long 0xD3EE8090, 0x06429918
.long 0xD8EC71E0, 0x2800000F
.long 0xD8EC7260, 0x2A00000F
.long 0xE0511100, 0x80020707
.long 0xD3EE8098, 0x0662991A
.long 0xBF8CC67F
.long 0xD3EE80A0, 0x0682991C
.long 0xD8EC72E0, 0x2C00000F
.long 0xD8EC7360, 0x2E00000F
.long 0xE0511200, 0x80020707
.long 0xD3EE80A8, 0x06A2991E
.long 0xBF8CC67F
.long 0xD3EE80B0, 0x06C29920
.long 0xD8EC73E0, 0x3000000F
.long 0xD8EC7460, 0x3200000F
.long 0xE0511300, 0x80020707
.long 0xD3EE80B8, 0x06E29922
.long 0xB71C1020
.long 0xD3EE80C0, 0x07029D14
.long 0xE05C1000, 0x80013C06
.long 0xD3EE80C8, 0x07229D16
.long 0x80081508
.long 0x82098009
.long 0xD3EE80D0, 0x07429D18
.long 0x80041404
.long 0x82058005
.long 0xD3EE80D8, 0x07629D1A
.long 0xD3D84010, 0x1800013E
.long 0xD3D84011, 0x1800013F
.long 0xD3D84012, 0x1800017E
.long 0xD3D84013, 0x1800017F
.long 0xBF800001
.long 0xBF8C0F7A
.long 0xD2800010, 0x2002B110
.long 0xD2800012, 0x2002B512
.long 0xD3EE80E0, 0x07829D1C
.long 0xE0741000, 0x80041008
.long 0xE0741000, 0x80041209
.long 0xD3EE80E8, 0x07A29D1E
.long 0xD3EE80F0, 0x07C29D20
.long 0xD3EE80F8, 0x07E29D22
.long 0xBEFC001C
.long 0xBF8C0F7F
.long 0xBF8A0000
.long 0xBF8CC67F
.long 0xD3EE8080, 0x0602A124
.long 0xD8EC0000, 0x1400000F
.long 0xD8EC0080, 0x1600000F
.long 0xE0511000, 0x80020707
.long 0xD3EE8088, 0x0622A126
.long 0xBF8CC67F
.long 0xD3EE8090, 0x0642A128
.long 0xD8EC0100, 0x1800000F
.long 0xD8EC0180, 0x1A00000F
.long 0xE0511100, 0x80020707
.long 0xD3EE8098, 0x0662A12A
.long 0xBF8CC67F
.long 0xD3EE80A0, 0x0682A12C
.long 0xD8EC0200, 0x1C00000F
.long 0xD8EC0280, 0x1E00000F
.long 0xE0511200, 0x80020707
.long 0xD3EE80A8, 0x06A2A12E
.long 0xBF8CC67F
.long 0xD3EE80B0, 0x06C2A130
.long 0xD8EC0300, 0x2000000F
.long 0xD8EC0380, 0x2200000F
.long 0xE0511300, 0x80020707
.long 0xD3EE80B8, 0x06E2A132
.long 0xB71C1020
.long 0xD3EE80C0, 0x0702A524
.long 0xE05C1000, 0x80014006
.long 0xD3EE80C8, 0x0722A526
.long 0x80081508
.long 0x82098009
.long 0xD3EE80D0, 0x0742A528
.long 0x80041404
.long 0x82058005
.long 0xD3EE80D8, 0x0762A52A
.long 0xD3EE80E0, 0x0782A52C
.long 0xD3EE80E8, 0x07A2A52E
.long 0xD3EE80F0, 0x07C2A530
.long 0xD3EE80F8, 0x07E2A532
.long 0xBE9200FF, 0x80000000
.long 0xBF091224
.long 0x850C2412
.long 0xBF068025
.long 0xBE92020C
.long 0xD0C9000C, 0x00009D0A
.long 0xD1000008, 0x0032190E
.long 0xD0C9000C, 0x00009D0B
.long 0xD1000009, 0x00321B0E
.long 0xD3D94000, 0x18000080
.long 0xD3D94001, 0x18000080
.long 0xD3D94002, 0x18000080
.long 0xD3D94003, 0x18000080
.long 0xD3D94004, 0x18000080
.long 0xD3D94005, 0x18000080
.long 0xD3D94006, 0x18000080
.long 0xD3D94007, 0x18000080
.long 0xD3D94008, 0x18000080
.long 0xD3D94009, 0x18000080
.long 0xD3D9400A, 0x18000080
.long 0xD3D9400B, 0x18000080
.long 0xD3D9400C, 0x18000080
.long 0xD3D9400D, 0x18000080
.long 0xD3D9400E, 0x18000080
.long 0xD3D9400F, 0x18000080
.long 0xD3D94010, 0x18000080
.long 0xD3D94011, 0x18000080
.long 0xD3D94012, 0x18000080
.long 0xD3D94013, 0x18000080
.long 0xD3D94014, 0x18000080
.long 0xD3D94015, 0x18000080
.long 0xD3D94016, 0x18000080
.long 0xD3D94017, 0x18000080
.long 0xD3D94018, 0x18000080
.long 0xD3D94019, 0x18000080
.long 0xD3D9401A, 0x18000080
.long 0xD3D9401B, 0x18000080
.long 0xD3D9401C, 0x18000080
.long 0xD3D9401D, 0x18000080
.long 0xD3D9401E, 0x18000080
.long 0xD3D9401F, 0x18000080
.long 0xD3D94020, 0x18000080
.long 0xD3D94021, 0x18000080
.long 0xD3D94022, 0x18000080
.long 0xD3D94023, 0x18000080
.long 0xD3D94024, 0x18000080
.long 0xD3D94025, 0x18000080
.long 0xD3D94026, 0x18000080
.long 0xD3D94027, 0x18000080
.long 0xD3D94028, 0x18000080
.long 0xD3D94029, 0x18000080
.long 0xD3D9402A, 0x18000080
.long 0xD3D9402B, 0x18000080
.long 0xD3D9402C, 0x18000080
.long 0xD3D9402D, 0x18000080
.long 0xD3D9402E, 0x18000080
.long 0xD3D9402F, 0x18000080
.long 0xD3D94030, 0x18000080
.long 0xD3D94031, 0x18000080
.long 0xD3D94032, 0x18000080
.long 0xD3D94033, 0x18000080
.long 0xD3D94034, 0x18000080
.long 0xD3D94035, 0x18000080
.long 0xD3D94036, 0x18000080
.long 0xD3D94037, 0x18000080
.long 0xD3D94038, 0x18000080
.long 0xD3D94039, 0x18000080
.long 0xD3D9403A, 0x18000080
.long 0xD3D9403B, 0x18000080
.long 0xD3D9403C, 0x18000080
.long 0xD3D9403D, 0x18000080
.long 0xD3D9403E, 0x18000080
.long 0xD3D9403F, 0x18000080
.long 0xD3D94040, 0x18000080
.long 0xD3D94041, 0x18000080
.long 0xD3D94042, 0x18000080
.long 0xD3D94043, 0x18000080
.long 0xD3D94044, 0x18000080
.long 0xD3D94045, 0x18000080
.long 0xD3D94046, 0x18000080
.long 0xD3D94047, 0x18000080
.long 0xD3D94048, 0x18000080
.long 0xD3D94049, 0x18000080
.long 0xD3D9404A, 0x18000080
.long 0xD3D9404B, 0x18000080
.long 0xD3D9404C, 0x18000080
.long 0xD3D9404D, 0x18000080
.long 0xD3D9404E, 0x18000080
.long 0xD3D9404F, 0x18000080
.long 0xD3D94050, 0x18000080
.long 0xD3D94051, 0x18000080
.long 0xD3D94052, 0x18000080
.long 0xD3D94053, 0x18000080
.long 0xD3D94054, 0x18000080
.long 0xD3D94055, 0x18000080
.long 0xD3D94056, 0x18000080
.long 0xD3D94057, 0x18000080
.long 0xD3D94058, 0x18000080
.long 0xD3D94059, 0x18000080
.long 0xD3D9405A, 0x18000080
.long 0xD3D9405B, 0x18000080
.long 0xD3D9405C, 0x18000080
.long 0xD3D9405D, 0x18000080
.long 0xD3D9405E, 0x18000080
.long 0xD3D9405F, 0x18000080
.long 0xD3D94060, 0x18000080
.long 0xD3D94061, 0x18000080
.long 0xD3D94062, 0x18000080
.long 0xD3D94063, 0x18000080
.long 0xD3D94064, 0x18000080
.long 0xD3D94065, 0x18000080
.long 0xD3D94066, 0x18000080
.long 0xD3D94067, 0x18000080
.long 0xD3D94068, 0x18000080
.long 0xD3D94069, 0x18000080
.long 0xD3D9406A, 0x18000080
.long 0xD3D9406B, 0x18000080
.long 0xD3D9406C, 0x18000080
.long 0xD3D9406D, 0x18000080
.long 0xD3D9406E, 0x18000080
.long 0xD3D9406F, 0x18000080
.long 0xD3D94070, 0x18000080
.long 0xD3D94071, 0x18000080
.long 0xD3D94072, 0x18000080
.long 0xD3D94073, 0x18000080
.long 0xD3D94074, 0x18000080
.long 0xD3D94075, 0x18000080
.long 0xD3D94076, 0x18000080
.long 0xD3D94077, 0x18000080
.long 0xD3D94078, 0x18000080
.long 0xD3D94079, 0x18000080
.long 0xD3D9407A, 0x18000080
.long 0xD3D9407B, 0x18000080
.long 0xD3D9407C, 0x18000080
.long 0xD3D9407D, 0x18000080
.long 0xD3D9407E, 0x18000080
.long 0xD3D9407F, 0x18000080
.long 0xBE9D0080
.long 0xBE9E0080
.long 0x8010443E
.long 0x8211453F
.long 0xBEFC001C
.long 0xBF8C0F7D
.long 0xBF8A0000
.long 0xBF8CC67F
.long 0xD3EE8000, 0x04026914
.long 0xD8EC1020, 0x2400000F
.long 0xD8EC10A0, 0x2600000F
.long 0xE0511000, 0x80020707
.long 0xD3EE8008, 0x04226916
.long 0xBF8CC67F
.long 0xD3EE8010, 0x04426918
.long 0xD8EC1120, 0x2800000F
.long 0xD8EC11A0, 0x2A00000F
.long 0xE0511100, 0x80020707
.long 0xD3EE8018, 0x0462691A
.long 0xBF8CC67F
.long 0xD3EE8020, 0x0482691C
.long 0xD8EC1220, 0x2C00000F
.long 0xD8EC12A0, 0x2E00000F
.long 0xE0511200, 0x80020707
.long 0xD3EE8028, 0x04A2691E
.long 0xBF8CC67F
.long 0xD3EE8030, 0x04C26920
.long 0xD8EC1320, 0x3000000F
.long 0xD8EC13A0, 0x3200000F
.long 0xE0511300, 0x80020707
.long 0xD3EE8038, 0x04E26922
.long 0xD3EE8040, 0x05026D14
.long 0xE05C1000, 0x80014406
.long 0xD3EE8048, 0x05226D16
.long 0xB71C1020
.long 0x80081508
.long 0x82098009
.long 0xD3EE8050, 0x05426D18
.long 0x80041404
.long 0x82058005
.long 0xD3EE8058, 0x05626D1A
.long 0xD3EE8060, 0x05826D1C
.long 0xE0541000, 0x80045408
.long 0xE0541000, 0x80045609
.long 0xD3EE8068, 0x05A26D1E
.long 0xD3EE8070, 0x05C26D20
.long 0xD3EE8078, 0x05E26D22
.long 0xBEFC001C
.long 0xBF8C0F7F
.long 0xBF8A0000
.long 0xBF8CC67F
.long 0xD3EE8000, 0x04027124
.long 0xD8EC2040, 0x1400000F
.long 0xD8EC20C0, 0x1600000F
.long 0xE0511000, 0x80020707
.long 0xD3EE8008, 0x04227126
.long 0xBF8CC67F
.long 0xD3EE8010, 0x04427128
.long 0xD8EC2140, 0x1800000F
.long 0xD8EC21C0, 0x1A00000F
.long 0xE0511100, 0x80020707
.long 0xD3EE8018, 0x0462712A
.long 0xBF8CC67F
.long 0xD3EE8020, 0x0482712C
.long 0xD8EC2240, 0x1C00000F
.long 0xD8EC22C0, 0x1E00000F
.long 0xE0511200, 0x80020707
.long 0xD3EE8028, 0x04A2712E
.long 0xBF8CC67F
.long 0xD3EE8030, 0x04C27130
.long 0xD8EC2340, 0x2000000F
.long 0xD8EC23C0, 0x2200000F
.long 0xE0511300, 0x80020707
.long 0xD3EE8038, 0x04E27132
.long 0xD3EE8040, 0x05027524
.long 0xE05C1000, 0x80014806
.long 0xD3EE8048, 0x05227526
.long 0xB71C1020
.long 0x80081508
.long 0x82098009
.long 0xD3EE8050, 0x05427528
.long 0x80041404
.long 0x82058005
.long 0xD3EE8058, 0x0562752A
.long 0xD3EE8060, 0x0582752C
.long 0xD3EE8068, 0x05A2752E
.long 0xD3EE8070, 0x05C27530
.long 0xD3EE8078, 0x05E27532
.long 0xBEFC001C
.long 0xBF8C0F7D
.long 0xBF8A0000
.long 0xBF8CC67F
.long 0xD3EE8000, 0x04027914
.long 0xD8EC3060, 0x2400000F
.long 0xD8EC30E0, 0x2600000F
.long 0xE0511000, 0x80020707
.long 0xD3EE8008, 0x04227916
.long 0xBF8CC67F
.long 0xD3EE8010, 0x04427918
.long 0xD8EC3160, 0x2800000F
.long 0xD8EC31E0, 0x2A00000F
.long 0xE0511100, 0x80020707
.long 0xD3EE8018, 0x0462791A
.long 0xBF8CC67F
.long 0xD3EE8020, 0x0482791C
.long 0xD8EC3260, 0x2C00000F
.long 0xD8EC32E0, 0x2E00000F
.long 0xE0511200, 0x80020707
.long 0xD3EE8028, 0x04A2791E
.long 0xBF8CC67F
.long 0xD3EE8030, 0x04C27920
.long 0xD8EC3360, 0x3000000F
.long 0xD8EC33E0, 0x3200000F
.long 0xE0511300, 0x80020707
.long 0xD3EE8038, 0x04E27922
.long 0xD3EE8040, 0x05027D14
.long 0xE05C1000, 0x80014C06
.long 0xD3EE8048, 0x05227D16
.long 0xB71C1020
.long 0x80081508
.long 0x82098009
.long 0xD3EE8050, 0x05427D18
.long 0x80041404
.long 0x82058005
.long 0xD3EE8058, 0x05627D1A
.long 0xBF11011E
.long 0xD3D84010, 0x18000180
.long 0xD3D84011, 0x18000181
.long 0xD3D84012, 0x180001C0
.long 0xD3D84013, 0x180001C1
.long 0xBF800001
.long 0xBF9C0000
.long 0xBF8C0F7A
.long 0xD2800010, 0x2002A910
.long 0xD2800012, 0x2002AD12
.long 0xD3EE8060, 0x05827D1C
.long 0xE0741000, 0x80041008
.long 0xE0741000, 0x80041209
.long 0xD3EE8068, 0x05A27D1E
.long 0x80101910
.long 0x82118011
.long 0xD3EE8070, 0x05C27D20
.long 0x80921912
.long 0xBE920280
.long 0xD3EE8078, 0x05E27D22
.long 0xBEFC001C
.long 0xBF8C0F7F
.long 0xBF8A0000
.long 0xBF8CC67F
.long 0xD3EE8000, 0x04028124
.long 0xD8EC4080, 0x1400000F
.long 0xD8EC4100, 0x1600000F
.long 0xE0511000, 0x80020707
.long 0xD3EE8008, 0x04228126
.long 0xBF8CC67F
.long 0xD3EE8010, 0x04428128
.long 0xD8EC4180, 0x1800000F
.long 0xD8EC4200, 0x1A00000F
.long 0xE0511100, 0x80020707
.long 0xD3EE8018, 0x0462812A
.long 0xBF8CC67F
.long 0xD3EE8020, 0x0482812C
.long 0xD8EC4280, 0x1C00000F
.long 0xD8EC4300, 0x1E00000F
.long 0xE0511200, 0x80020707
.long 0xD3EE8028, 0x04A2812E
.long 0xBF8CC67F
.long 0xD3EE8030, 0x04C28130
.long 0xD8EC4380, 0x2000000F
.long 0xD8EC4400, 0x2200000F
.long 0xE0511300, 0x80020707
.long 0xD3EE8038, 0x04E28132
.long 0xD3EE8040, 0x05028524
.long 0xE05C1000, 0x80015006
.long 0xD3EE8048, 0x05228526
.long 0xBE9C0016
.long 0x80081508
.long 0x82098009
.long 0xD3EE8050, 0x05428528
.long 0x80041404
.long 0x82058005
.long 0xD3EE8058, 0x0562852A
.long 0xD3EE8060, 0x0582852C
.long 0xD3EE8068, 0x05A2852E
.long 0xD3EE8070, 0x05C28530
.long 0xD3EE8078, 0x05E28532
.long 0xBEFC001C
.long 0xBF8C0F7D
.long 0xBF8A0000
.long 0xBF8CC67F
.long 0xD3EE8000, 0x04028914
.long 0xD8EC50A0, 0x2400000F
.long 0xD8EC5120, 0x2600000F
.long 0xE0511000, 0x80020707
.long 0xD3EE8008, 0x04228916
.long 0xBF8CC67F
.long 0xD3EE8010, 0x04428918
.long 0xD8EC51A0, 0x2800000F
.long 0xD8EC5220, 0x2A00000F
.long 0xE0511100, 0x80020707
.long 0xD3EE8018, 0x0462891A
.long 0xBF8CC67F
.long 0xD3EE8020, 0x0482891C
.long 0xD8EC52A0, 0x2C00000F
.long 0xD8EC5320, 0x2E00000F
.long 0xE0511200, 0x80020707
.long 0xD3EE8028, 0x04A2891E
.long 0xBF8CC67F
.long 0xD3EE8030, 0x04C28920
.long 0xD8EC53A0, 0x3000000F
.long 0xD8EC5420, 0x3200000F
.long 0xE0511300, 0x80020707
.long 0xD3EE8038, 0x04E28922
.long 0xD3EE8040, 0x05028D14
.long 0xE05C1000, 0x80013406
.long 0xD3EE8048, 0x05228D16
.long 0xB71C1020
.long 0x80081508
.long 0x82098009
.long 0xD3EE8050, 0x05428D18
.long 0x80041404
.long 0x82058005
.long 0xD3EE8058, 0x05628D1A
.long 0xD3EE8060, 0x05828D1C
.long 0xE0541000, 0x80045808
.long 0xE0541000, 0x80045A09
.long 0xD3EE8068, 0x05A28D1E
.long 0xD3EE8070, 0x05C28D20
.long 0xD3EE8078, 0x05E28D22
.long 0xBEFC001C
.long 0xBF8C0F7F
.long 0xBF8A0000
.long 0xBF8CC67F
.long 0xD3EE8000, 0x04029124
.long 0xD8EC60C0, 0x1400000F
.long 0xD8EC6140, 0x1600000F
.long 0xE0511000, 0x80020707
.long 0xD3EE8008, 0x04229126
.long 0xBF8CC67F
.long 0xD3EE8010, 0x04429128
.long 0xD8EC61C0, 0x1800000F
.long 0xD8EC6240, 0x1A00000F
.long 0xE0511100, 0x80020707
.long 0xD3EE8018, 0x0462912A
.long 0xBF8CC67F
.long 0xD3EE8020, 0x0482912C
.long 0xD8EC62C0, 0x1C00000F
.long 0xD8EC6340, 0x1E00000F
.long 0xE0511200, 0x80020707
.long 0xD3EE8028, 0x04A2912E
.long 0xBF8CC67F
.long 0xD3EE8030, 0x04C29130
.long 0xD8EC63C0, 0x2000000F
.long 0xD8EC6440, 0x2200000F
.long 0xE0511300, 0x80020707
.long 0xD3EE8038, 0x04E29132
.long 0xD3EE8040, 0x05029524
.long 0xE05C1000, 0x80013806
.long 0xD3EE8048, 0x05229526
.long 0xB71C1020
.long 0x80081508
.long 0x82098009
.long 0xD3EE8050, 0x05429528
.long 0x80041404
.long 0x82058005
.long 0xD3EE8058, 0x0562952A
.long 0xD3EE8060, 0x0582952C
.long 0xD3EE8068, 0x05A2952E
.long 0xD3EE8070, 0x05C29530
.long 0xD3EE8078, 0x05E29532
.long 0xBEFC001C
.long 0xBF8C0F7D
.long 0xBF8A0000
.long 0xBF8CC67F
.long 0xD3EE8000, 0x04029914
.long 0xD8EC70E0, 0x2400000F
.long 0xD8EC7160, 0x2600000F
.long 0xE0511000, 0x80020707
.long 0xD3EE8008, 0x04229916
.long 0xBF8CC67F
.long 0xD3EE8010, 0x04429918
.long 0xD8EC71E0, 0x2800000F
.long 0xD8EC7260, 0x2A00000F
.long 0xE0511100, 0x80020707
.long 0xD3EE8018, 0x0462991A
.long 0xBF8CC67F
.long 0xD3EE8020, 0x0482991C
.long 0xD8EC72E0, 0x2C00000F
.long 0xD8EC7360, 0x2E00000F
.long 0xE0511200, 0x80020707
.long 0xD3EE8028, 0x04A2991E
.long 0xBF8CC67F
.long 0xD3EE8030, 0x04C29920
.long 0xD8EC73E0, 0x3000000F
.long 0xD8EC7460, 0x3200000F
.long 0xE0511300, 0x80020707
.long 0xD3EE8038, 0x04E29922
.long 0xD3EE8040, 0x05029D14
.long 0xE05C1000, 0x80013C06
.long 0xD3EE8048, 0x05229D16
.long 0xB71C1020
.long 0x80081508
.long 0x82098009
.long 0xD3EE8050, 0x05429D18
.long 0x80041404
.long 0x82058005
.long 0xD3EE8058, 0x05629D1A
.long 0xBF11011E
.long 0xD3D84010, 0x18000182
.long 0xD3D84011, 0x18000183
.long 0xD3D84012, 0x180001C2
.long 0xD3D84013, 0x180001C3
.long 0xBF800001
.long 0xBF9C0000
.long 0xBF8C0F7A
.long 0xD2800010, 0x2002B110
.long 0xD2800012, 0x2002B512
.long 0xD3EE8060, 0x05829D1C
.long 0xE0741000, 0x80041008
.long 0xE0741000, 0x80041209
.long 0xD3EE8068, 0x05A29D1E
.long 0x80101910
.long 0x82118011
.long 0xD3EE8070, 0x05C29D20
.long 0x80921912
.long 0xBE920280
.long 0xD3EE8078, 0x05E29D22
.long 0xBEFC001C
.long 0xBF8C0F7F
.long 0xBF8A0000
.long 0xBF8CC67F
.long 0xD3EE8000, 0x0402A124
.long 0xD8EC0000, 0x1400000F
.long 0xD8EC0080, 0x1600000F
.long 0xE0511000, 0x80020707
.long 0xD3EE8008, 0x0422A126
.long 0xBF8CC67F
.long 0xD3EE8010, 0x0442A128
.long 0xD8EC0100, 0x1800000F
.long 0xD8EC0180, 0x1A00000F
.long 0xE0511100, 0x80020707
.long 0xD3EE8018, 0x0462A12A
.long 0xBF8CC67F
.long 0xD3EE8020, 0x0482A12C
.long 0xD8EC0200, 0x1C00000F
.long 0xD8EC0280, 0x1E00000F
.long 0xE0511200, 0x80020707
.long 0xD3EE8028, 0x04A2A12E
.long 0xBF8CC67F
.long 0xD3EE8030, 0x04C2A130
.long 0xD8EC0300, 0x2000000F
.long 0xD8EC0380, 0x2200000F
.long 0xE0511300, 0x80020707
.long 0xD3EE8038, 0x04E2A132
.long 0xD3EE8040, 0x0502A524
.long 0xE05C1000, 0x80014006
.long 0xD3EE8048, 0x0522A526
.long 0xB71C1020
.long 0x80081508
.long 0x82098009
.long 0xD3EE8050, 0x0542A528
.long 0x80041404
.long 0x82058005
.long 0xD3EE8058, 0x0562A52A
.long 0xD3EE8060, 0x0582A52C
.long 0xD3EE8068, 0x05A2A52E
.long 0xD3EE8070, 0x05C2A530
.long 0xD3EE8078, 0x05E2A532
.long 0xB71E0004
.long 0xB71D0008
.long 0xB31D0078
.long 0xBF85FD94
.long 0xBEFC001C
.long 0xBF8C0F7D
.long 0xBF8A0000
.long 0xBF8CC67F
.long 0xD3EE8000, 0x04026914
.long 0xD8EC1020, 0x2400000F
.long 0xD8EC10A0, 0x2600000F
.long 0xE0511000, 0x80020707
.long 0xD3EE8008, 0x04226916
.long 0xBF8CC67F
.long 0xD3EE8010, 0x04426918
.long 0xD8EC1120, 0x2800000F
.long 0xD8EC11A0, 0x2A00000F
.long 0xE0511100, 0x80020707
.long 0xD3EE8018, 0x0462691A
.long 0xBF8CC67F
.long 0xD3EE8020, 0x0482691C
.long 0xD8EC1220, 0x2C00000F
.long 0xD8EC12A0, 0x2E00000F
.long 0xE0511200, 0x80020707
.long 0xD3EE8028, 0x04A2691E
.long 0xBF8CC67F
.long 0xD3EE8030, 0x04C26920
.long 0xD8EC1320, 0x3000000F
.long 0xD8EC13A0, 0x3200000F
.long 0xE0511300, 0x80020707
.long 0xD3EE8038, 0x04E26922
.long 0xB71C1020
.long 0xD3EE8040, 0x05026D14
.long 0xE05C1000, 0x80014406
.long 0xD3EE8048, 0x05226D16
.long 0x80081508
.long 0x82098009
.long 0xD3EE8050, 0x05426D18
.long 0x80041404
.long 0x82058005
.long 0xD3EE8058, 0x05626D1A
.long 0xD3EE8060, 0x05826D1C
.long 0xE0541000, 0x80045408
.long 0xE0541000, 0x80045609
.long 0xD3EE8068, 0x05A26D1E
.long 0xD3EE8070, 0x05C26D20
.long 0xD3EE8078, 0x05E26D22
.long 0xBEFC001C
.long 0xBF8C0F7F
.long 0xBF8A0000
.long 0xBF8CC67F
.long 0xD3EE8000, 0x04027124
.long 0xD8EC2040, 0x1400000F
.long 0xD8EC20C0, 0x1600000F
.long 0xE0511000, 0x80020707
.long 0xD3EE8008, 0x04227126
.long 0xBF8CC67F
.long 0xD3EE8010, 0x04427128
.long 0xD8EC2140, 0x1800000F
.long 0xD8EC21C0, 0x1A00000F
.long 0xE0511100, 0x80020707
.long 0xD3EE8018, 0x0462712A
.long 0xBF8CC67F
.long 0xD3EE8020, 0x0482712C
.long 0xD8EC2240, 0x1C00000F
.long 0xD8EC22C0, 0x1E00000F
.long 0xE0511200, 0x80020707
.long 0xD3EE8028, 0x04A2712E
.long 0xBF8CC67F
.long 0xD3EE8030, 0x04C27130
.long 0xD8EC2340, 0x2000000F
.long 0xD8EC23C0, 0x2200000F
.long 0xE0511300, 0x80020707
.long 0xD3EE8038, 0x04E27132
.long 0xB71C1020
.long 0xD3EE8040, 0x05027524
.long 0xE05C1000, 0x80014806
.long 0xD3EE8048, 0x05227526
.long 0x80081508
.long 0x82098009
.long 0xD3EE8050, 0x05427528
.long 0x80041404
.long 0x82058005
.long 0xD3EE8058, 0x0562752A
.long 0xD3EE8060, 0x0582752C
.long 0xD3EE8068, 0x05A2752E
.long 0xD3EE8070, 0x05C27530
.long 0xD3EE8078, 0x05E27532
.long 0xBEFC001C
.long 0xBF8C0F7D
.long 0xBF8A0000
.long 0xBF8CC67F
.long 0xD3EE8000, 0x04027914
.long 0xD8EC3060, 0x2400000F
.long 0xD8EC30E0, 0x2600000F
.long 0xE0511000, 0x80020707
.long 0xD3EE8008, 0x04227916
.long 0xBF8CC67F
.long 0xD3EE8010, 0x04427918
.long 0xD8EC3160, 0x2800000F
.long 0xD8EC31E0, 0x2A00000F
.long 0xE0511100, 0x80020707
.long 0xD3EE8018, 0x0462791A
.long 0xBF8CC67F
.long 0xD3EE8020, 0x0482791C
.long 0xD8EC3260, 0x2C00000F
.long 0xD8EC32E0, 0x2E00000F
.long 0xE0511200, 0x80020707
.long 0xD3EE8028, 0x04A2791E
.long 0xBF8CC67F
.long 0xD3EE8030, 0x04C27920
.long 0xD8EC3360, 0x3000000F
.long 0xD8EC33E0, 0x3200000F
.long 0xE0511300, 0x80020707
.long 0xD3EE8038, 0x04E27922
.long 0xB71C1020
.long 0xD3EE8040, 0x05027D14
.long 0xE05C1000, 0x80014C06
.long 0xD3EE8048, 0x05227D16
.long 0x80081508
.long 0x82098009
.long 0xD3EE8050, 0x05427D18
.long 0x80041404
.long 0x82058005
.long 0xD3EE8058, 0x05627D1A
.long 0xD3D84010, 0x180001BC
.long 0xD3D84011, 0x180001BD
.long 0xD3D84012, 0x180001FC
.long 0xD3D84013, 0x180001FD
.long 0xBF800001
.long 0xBF8C0F7A
.long 0xD2800010, 0x2002A910
.long 0xD2800012, 0x2002AD12
.long 0xD3EE8060, 0x05827D1C
.long 0xE0741000, 0x80041008
.long 0xE0741000, 0x80041209
.long 0xD3EE8068, 0x05A27D1E
.long 0x80101910
.long 0x82118011
.long 0xD3EE8070, 0x05C27D20
.long 0x80921912
.long 0xBE920280
.long 0xD3EE8078, 0x05E27D22
.long 0x808C0426
.long 0x828D0527
.long 0xBE86000C
.long 0x808C0828
.long 0x828D0929
.long 0xBE8A000C
.long 0xBEFC001C
.long 0xBF8C0F7F
.long 0xBF8A0000
.long 0xBF8CC67F
.long 0xD3EE8000, 0x04028124
.long 0xD8EC4080, 0x1400000F
.long 0xD8EC4100, 0x1600000F
.long 0xE0511000, 0x80020707
.long 0xD3EE8008, 0x04228126
.long 0xBF8CC67F
.long 0xD3EE8010, 0x04428128
.long 0xD8EC4180, 0x1800000F
.long 0xD8EC4200, 0x1A00000F
.long 0xE0511100, 0x80020707
.long 0xD3EE8018, 0x0462812A
.long 0xBF8CC67F
.long 0xD3EE8020, 0x0482812C
.long 0xD8EC4280, 0x1C00000F
.long 0xD8EC4300, 0x1E00000F
.long 0xE0511200, 0x80020707
.long 0xD3EE8028, 0x04A2812E
.long 0xBF8CC67F
.long 0xD3EE8030, 0x04C28130
.long 0xD8EC4380, 0x2000000F
.long 0xD8EC4400, 0x2200000F
.long 0xE0511300, 0x80020707
.long 0xD3EE8038, 0x04E28132
.long 0xBE9C0016
.long 0xD3EE8040, 0x05028524
.long 0xE05C1000, 0x80015006
.long 0xD3EE8048, 0x05228526
.long 0xD3EE8050, 0x05428528
.long 0xD3EE8058, 0x0562852A
.long 0xD3EE8060, 0x0582852C
.long 0xD3EE8068, 0x05A2852E
.long 0xD3EE8070, 0x05C28530
.long 0xD3EE8078, 0x05E28532
.long 0xB00C0100
.long 0x920F320C
.long 0x920EFF18, 0x00000080
.long 0x920C330E
.long 0x960D330E
.long 0x800C0F0C
.long 0x820D800D
.long 0x8E8C820C
.long 0x920E30FF, 0x00000100
.long 0x803E0E0C
.long 0x823F800D
.long 0x80A40C2A
.long 0x82A50D2B
.long 0x924EFF32, 0x00000080
.long 0x80CE4E1F
.long 0x81313831
.long 0xBF031731
.long 0xBF850360
.long 0x814C384C
.long 0x818C494C
.long 0x810D814D
.long 0xBF03494C
.long 0xBECC020C
.long 0xBECD020D
.long 0x960D3631
.long 0x8F0E9F37
.long 0x920C0E31
.long 0x800C0D0C
.long 0x860EFF37, 0x7FFFFFFF
.long 0x8F330E0C
.long 0x92323433
.long 0x80B23231
.long 0xBF033534
.long 0x85463332
.long 0x85473233
.long 0xBF033849
.long 0xBEC6024C
.long 0xBEC7024D
.long 0xBE8F004B
.long 0x960D0F47
.long 0x920C0F47
.long 0x8F8C9F0C
.long 0x920D4A0C
.long 0x808D0D47
.long 0x920D490D
.long 0x800D460D
.long 0xBF09390C
.long 0xBE8F023B
.long 0x850E4A3A
.long 0x96470F0D
.long 0x92460F0D
.long 0x8FC69F46
.long 0x92470E46
.long 0x80C7470D
.long 0x920C4A0C
.long 0x80470C47
.long 0xBF033534
.long 0x85324746
.long 0x85334647
.long 0x8E0C8A32
.long 0x810C1A0C
.long 0x80040C40
.long 0x82058041
.long 0xBE8600FF, 0x80000000
.long 0x8E0C8A33
.long 0x800C1B0C
.long 0x80080C42
.long 0x82098043
.long 0xBE8A00FF, 0x80000000
.long 0xBEFC001C
.long 0xBF8C0F7D
.long 0xBF8A0000
.long 0xBF8CC67F
.long 0xD3EE8000, 0x04028914
.long 0xD8EC50A0, 0x2400000F
.long 0xD8EC5120, 0x2600000F
.long 0xE0511000, 0x80020707
.long 0xD3EE8008, 0x04228916
.long 0xBF8CC67F
.long 0xD3EE8010, 0x04428918
.long 0xD8EC51A0, 0x2800000F
.long 0xD8EC5220, 0x2A00000F
.long 0xE0511100, 0x80020707
.long 0xD3EE8018, 0x0462891A
.long 0xBF8CC67F
.long 0xD3EE8020, 0x0482891C
.long 0xD8EC52A0, 0x2C00000F
.long 0xD8EC5320, 0x2E00000F
.long 0xE0511200, 0x80020707
.long 0xD3EE8028, 0x04A2891E
.long 0xBF8CC67F
.long 0xD3EE8030, 0x04C28920
.long 0xD8EC53A0, 0x3000000F
.long 0xD8EC5420, 0x3200000F
.long 0xE0511300, 0x80020707
.long 0xD3EE8038, 0x04E28922
.long 0xB71C1020
.long 0xD3EE8040, 0x05028D14
.long 0xE05C1000, 0x80013406
.long 0xD3EE8048, 0x05228D16
.long 0x80081508
.long 0x82098009
.long 0xD3EE8050, 0x05428D18
.long 0x80041404
.long 0x82058005
.long 0xD3EE8058, 0x05628D1A
.long 0xD3EE8060, 0x05828D1C
.long 0xE0541000, 0x80045808
.long 0xE0541000, 0x80045A09
.long 0xD3EE8068, 0x05A28D1E
.long 0xD3EE8070, 0x05C28D20
.long 0xD3EE8078, 0x05E28D22
.long 0xBEFC001C
.long 0xBF8C0F7F
.long 0xBF8A0000
.long 0xBF8CC67F
.long 0xD3EE8000, 0x04029124
.long 0xD8EC60C0, 0x1400000F
.long 0xD8EC6140, 0x1600000F
.long 0xE0511000, 0x80020707
.long 0xD3EE8008, 0x04229126
.long 0xBF8CC67F
.long 0xD3EE8010, 0x04429128
.long 0xD8EC61C0, 0x1800000F
.long 0xD8EC6240, 0x1A00000F
.long 0xE0511100, 0x80020707
.long 0xD3EE8018, 0x0462912A
.long 0xBF8CC67F
.long 0xD3EE8020, 0x0482912C
.long 0xD8EC62C0, 0x1C00000F
.long 0xD8EC6340, 0x1E00000F
.long 0xE0511200, 0x80020707
.long 0xD3EE8028, 0x04A2912E
.long 0xBF8CC67F
.long 0xD3EE8030, 0x04C29130
.long 0xD8EC63C0, 0x2000000F
.long 0xD8EC6440, 0x2200000F
.long 0xE0511300, 0x80020707
.long 0xD3EE8038, 0x04E29132
.long 0xB71C1020
.long 0xD3EE8040, 0x05029524
.long 0xE05C1000, 0x80013806
.long 0xD3EE8048, 0x05229526
.long 0x80081508
.long 0x82098009
.long 0xD3EE8050, 0x05429528
.long 0x80041404
.long 0x82058005
.long 0xD3EE8058, 0x0562952A
.long 0xD3EE8060, 0x0582952C
.long 0xD3EE8068, 0x05A2952E
.long 0xD3EE8070, 0x05C29530
.long 0xD3EE8078, 0x05E29532
.long 0xBEFC001C
.long 0xBF8C0F7D
.long 0xBF8A0000
.long 0xBF8CC67F
.long 0xD3EE8000, 0x04029914
.long 0xD8EC70E0, 0x2400000F
.long 0xD8EC7160, 0x2600000F
.long 0xE0511000, 0x80020707
.long 0xD3EE8008, 0x04229916
.long 0xBF8CC67F
.long 0xD3EE8010, 0x04429918
.long 0xD8EC71E0, 0x2800000F
.long 0xD8EC7260, 0x2A00000F
.long 0xE0511100, 0x80020707
.long 0xD3EE8018, 0x0462991A
.long 0xBF8CC67F
.long 0xD3EE8020, 0x0482991C
.long 0xD8EC72E0, 0x2C00000F
.long 0xD8EC7360, 0x2E00000F
.long 0xE0511200, 0x80020707
.long 0xD3EE8028, 0x04A2991E
.long 0xBF8CC67F
.long 0xD3EE8030, 0x04C29920
.long 0xD8EC73E0, 0x3000000F
.long 0xD8EC7460, 0x3200000F
.long 0xE0511300, 0x80020707
.long 0xD3EE8038, 0x04E29922
.long 0xB71C1020
.long 0xD3EE8040, 0x05029D14
.long 0xE05C1000, 0x80013C06
.long 0xD3EE8048, 0x05229D16
.long 0x80081508
.long 0x82098009
.long 0xD3EE8050, 0x05429D18
.long 0x80041404
.long 0x82058005
.long 0xD3EE8058, 0x05629D1A
.long 0xD3D84010, 0x180001BE
.long 0xD3D84011, 0x180001BF
.long 0xD3D84012, 0x180001FE
.long 0xD3D84013, 0x180001FF
.long 0xBF800001
.long 0xBF8C0F7A
.long 0xD2800010, 0x2002B110
.long 0xD2800012, 0x2002B512
.long 0xD3EE8060, 0x05829D1C
.long 0xE0741000, 0x80041008
.long 0xE0741000, 0x80041209
.long 0xD3EE8068, 0x05A29D1E
.long 0xD3EE8070, 0x05C29D20
.long 0xD3EE8078, 0x05E29D22
.long 0xBEFC001C
.long 0xBF8C0F7F
.long 0xBF8A0000
.long 0xBF8CC67F
.long 0xD3EE8000, 0x0402A124
.long 0xD8EC0000, 0x1400000F
.long 0xD8EC0080, 0x1600000F
.long 0xE0511000, 0x80020707
.long 0xD3EE8008, 0x0422A126
.long 0xBF8CC67F
.long 0xD3EE8010, 0x0442A128
.long 0xD8EC0100, 0x1800000F
.long 0xD8EC0180, 0x1A00000F
.long 0xE0511100, 0x80020707
.long 0xD3EE8018, 0x0462A12A
.long 0xBF8CC67F
.long 0xD3EE8020, 0x0482A12C
.long 0xD8EC0200, 0x1C00000F
.long 0xD8EC0280, 0x1E00000F
.long 0xE0511200, 0x80020707
.long 0xD3EE8028, 0x04A2A12E
.long 0xBF8CC67F
.long 0xD3EE8030, 0x04C2A130
.long 0xD8EC0300, 0x2000000F
.long 0xD8EC0380, 0x2200000F
.long 0xE0511300, 0x80020707
.long 0xD3EE8038, 0x04E2A132
.long 0xB71C1020
.long 0xD3EE8040, 0x0502A524
.long 0xE05C1000, 0x80014006
.long 0xD3EE8048, 0x0522A526
.long 0x80081508
.long 0x82098009
.long 0xD3EE8050, 0x0542A528
.long 0x80041404
.long 0x82058005
.long 0xD3EE8058, 0x0562A52A
.long 0xD3EE8060, 0x0582A52C
.long 0xD3EE8068, 0x05A2A52E
.long 0xD3EE8070, 0x05C2A530
.long 0xD3EE8078, 0x05E2A532
.long 0xBE9200FF, 0x80000000
.long 0xBF091224
.long 0x850C2412
.long 0xBF068025
.long 0xBE92020C
.long 0xD0C9000C, 0x00009D0A
.long 0xD1000008, 0x0032190E
.long 0xD0C9000C, 0x00009D0B
.long 0xD1000009, 0x00321B0E
.long 0xD3D94080, 0x18000080
.long 0xD3D94081, 0x18000080
.long 0xD3D94082, 0x18000080
.long 0xD3D94083, 0x18000080
.long 0xD3D94084, 0x18000080
.long 0xD3D94085, 0x18000080
.long 0xD3D94086, 0x18000080
.long 0xD3D94087, 0x18000080
.long 0xD3D94088, 0x18000080
.long 0xD3D94089, 0x18000080
.long 0xD3D9408A, 0x18000080
.long 0xD3D9408B, 0x18000080
.long 0xD3D9408C, 0x18000080
.long 0xD3D9408D, 0x18000080
.long 0xD3D9408E, 0x18000080
.long 0xD3D9408F, 0x18000080
.long 0xD3D94090, 0x18000080
.long 0xD3D94091, 0x18000080
.long 0xD3D94092, 0x18000080
.long 0xD3D94093, 0x18000080
.long 0xD3D94094, 0x18000080
.long 0xD3D94095, 0x18000080
.long 0xD3D94096, 0x18000080
.long 0xD3D94097, 0x18000080
.long 0xD3D94098, 0x18000080
.long 0xD3D94099, 0x18000080
.long 0xD3D9409A, 0x18000080
.long 0xD3D9409B, 0x18000080
.long 0xD3D9409C, 0x18000080
.long 0xD3D9409D, 0x18000080
.long 0xD3D9409E, 0x18000080
.long 0xD3D9409F, 0x18000080
.long 0xD3D940A0, 0x18000080
.long 0xD3D940A1, 0x18000080
.long 0xD3D940A2, 0x18000080
.long 0xD3D940A3, 0x18000080
.long 0xD3D940A4, 0x18000080
.long 0xD3D940A5, 0x18000080
.long 0xD3D940A6, 0x18000080
.long 0xD3D940A7, 0x18000080
.long 0xD3D940A8, 0x18000080
.long 0xD3D940A9, 0x18000080
.long 0xD3D940AA, 0x18000080
.long 0xD3D940AB, 0x18000080
.long 0xD3D940AC, 0x18000080
.long 0xD3D940AD, 0x18000080
.long 0xD3D940AE, 0x18000080
.long 0xD3D940AF, 0x18000080
.long 0xD3D940B0, 0x18000080
.long 0xD3D940B1, 0x18000080
.long 0xD3D940B2, 0x18000080
.long 0xD3D940B3, 0x18000080
.long 0xD3D940B4, 0x18000080
.long 0xD3D940B5, 0x18000080
.long 0xD3D940B6, 0x18000080
.long 0xD3D940B7, 0x18000080
.long 0xD3D940B8, 0x18000080
.long 0xD3D940B9, 0x18000080
.long 0xD3D940BA, 0x18000080
.long 0xD3D940BB, 0x18000080
.long 0xD3D940BC, 0x18000080
.long 0xD3D940BD, 0x18000080
.long 0xD3D940BE, 0x18000080
.long 0xD3D940BF, 0x18000080
.long 0xD3D940C0, 0x18000080
.long 0xD3D940C1, 0x18000080
.long 0xD3D940C2, 0x18000080
.long 0xD3D940C3, 0x18000080
.long 0xD3D940C4, 0x18000080
.long 0xD3D940C5, 0x18000080
.long 0xD3D940C6, 0x18000080
.long 0xD3D940C7, 0x18000080
.long 0xD3D940C8, 0x18000080
.long 0xD3D940C9, 0x18000080
.long 0xD3D940CA, 0x18000080
.long 0xD3D940CB, 0x18000080
.long 0xD3D940CC, 0x18000080
.long 0xD3D940CD, 0x18000080
.long 0xD3D940CE, 0x18000080
.long 0xD3D940CF, 0x18000080
.long 0xD3D940D0, 0x18000080
.long 0xD3D940D1, 0x18000080
.long 0xD3D940D2, 0x18000080
.long 0xD3D940D3, 0x18000080
.long 0xD3D940D4, 0x18000080
.long 0xD3D940D5, 0x18000080
.long 0xD3D940D6, 0x18000080
.long 0xD3D940D7, 0x18000080
.long 0xD3D940D8, 0x18000080
.long 0xD3D940D9, 0x18000080
.long 0xD3D940DA, 0x18000080
.long 0xD3D940DB, 0x18000080
.long 0xD3D940DC, 0x18000080
.long 0xD3D940DD, 0x18000080
.long 0xD3D940DE, 0x18000080
.long 0xD3D940DF, 0x18000080
.long 0xD3D940E0, 0x18000080
.long 0xD3D940E1, 0x18000080
.long 0xD3D940E2, 0x18000080
.long 0xD3D940E3, 0x18000080
.long 0xD3D940E4, 0x18000080
.long 0xD3D940E5, 0x18000080
.long 0xD3D940E6, 0x18000080
.long 0xD3D940E7, 0x18000080
.long 0xD3D940E8, 0x18000080
.long 0xD3D940E9, 0x18000080
.long 0xD3D940EA, 0x18000080
.long 0xD3D940EB, 0x18000080
.long 0xD3D940EC, 0x18000080
.long 0xD3D940ED, 0x18000080
.long 0xD3D940EE, 0x18000080
.long 0xD3D940EF, 0x18000080
.long 0xD3D940F0, 0x18000080
.long 0xD3D940F1, 0x18000080
.long 0xD3D940F2, 0x18000080
.long 0xD3D940F3, 0x18000080
.long 0xD3D940F4, 0x18000080
.long 0xD3D940F5, 0x18000080
.long 0xD3D940F6, 0x18000080
.long 0xD3D940F7, 0x18000080
.long 0xD3D940F8, 0x18000080
.long 0xD3D940F9, 0x18000080
.long 0xD3D940FA, 0x18000080
.long 0xD3D940FB, 0x18000080
.long 0xD3D940FC, 0x18000080
.long 0xD3D940FD, 0x18000080
.long 0xD3D940FE, 0x18000080
.long 0xD3D940FF, 0x18000080
.long 0xBF82F3A9
.long 0xBF8C0F7D
.long 0xBF8A0000
.long 0xBF8CC67F
.long 0xD3EE8080, 0x06028914
.long 0xD8EC50A0, 0x2400000F
.long 0xD8EC5120, 0x2600000F
.long 0xD3EE8088, 0x06228916
.long 0xBF8CC67F
.long 0xD3EE8090, 0x06428918
.long 0xD8EC51A0, 0x2800000F
.long 0xD8EC5220, 0x2A00000F
.long 0xD3EE8098, 0x0662891A
.long 0xBF8CC67F
.long 0xD3EE80A0, 0x0682891C
.long 0xD8EC52A0, 0x2C00000F
.long 0xD8EC5320, 0x2E00000F
.long 0xD3EE80A8, 0x06A2891E
.long 0xBF8CC67F
.long 0xD3EE80B0, 0x06C28920
.long 0xD8EC53A0, 0x3000000F
.long 0xD8EC5420, 0x3200000F
.long 0xD3EE80B8, 0x06E28922
.long 0xD3EE80C0, 0x07028D14
.long 0xD3EE80C8, 0x07228D16
.long 0xD3EE80D0, 0x07428D18
.long 0xD3EE80D8, 0x07628D1A
.long 0xD3EE80E0, 0x07828D1C
.long 0xE0541000, 0x80045808
.long 0xE0541000, 0x80045A09
.long 0xD3EE80E8, 0x07A28D1E
.long 0xD3EE80F0, 0x07C28D20
.long 0xD3EE80F8, 0x07E28D22
.long 0xBF8C0F7A
.long 0xBF8A0000
.long 0xBF8CC67F
.long 0xD3EE8080, 0x06029124
.long 0xD8EC60C0, 0x1400000F
.long 0xD8EC6140, 0x1600000F
.long 0xD3EE8088, 0x06229126
.long 0xBF8CC67F
.long 0xD3EE8090, 0x06429128
.long 0xD8EC61C0, 0x1800000F
.long 0xD8EC6240, 0x1A00000F
.long 0xD3EE8098, 0x0662912A
.long 0xBF8CC67F
.long 0xD3EE80A0, 0x0682912C
.long 0xD8EC62C0, 0x1C00000F
.long 0xD8EC6340, 0x1E00000F
.long 0xD3EE80A8, 0x06A2912E
.long 0xBF8CC67F
.long 0xD3EE80B0, 0x06C29130
.long 0xD8EC63C0, 0x2000000F
.long 0xD8EC6440, 0x2200000F
.long 0xD3EE80B8, 0x06E29132
.long 0xD3EE80C0, 0x07029524
.long 0xD3EE80C8, 0x07229526
.long 0xD3EE80D0, 0x07429528
.long 0xD3EE80D8, 0x0762952A
.long 0xD3EE80E0, 0x0782952C
.long 0xD3EE80E8, 0x07A2952E
.long 0xD3EE80F0, 0x07C29530
.long 0xD3EE80F8, 0x07E29532
.long 0xBF8C0F73
.long 0xBF8A0000
.long 0xBF8CC67F
.long 0xD3EE8080, 0x06029914
.long 0xD8EC70E0, 0x2400000F
.long 0xD8EC7160, 0x2600000F
.long 0xD3EE8088, 0x06229916
.long 0xBF8CC67F
.long 0xD3EE8090, 0x06429918
.long 0xD8EC71E0, 0x2800000F
.long 0xD8EC7260, 0x2A00000F
.long 0xD3EE8098, 0x0662991A
.long 0xBF8CC67F
.long 0xD3EE80A0, 0x0682991C
.long 0xD8EC72E0, 0x2C00000F
.long 0xD8EC7360, 0x2E00000F
.long 0xD3EE80A8, 0x06A2991E
.long 0xBF8CC67F
.long 0xD3EE80B0, 0x06C29920
.long 0xD8EC73E0, 0x3000000F
.long 0xD8EC7460, 0x3200000F
.long 0xD3EE80B8, 0x06E29922
.long 0xD3EE80C0, 0x07029D14
.long 0xD3EE80C8, 0x07229D16
.long 0xD3EE80D0, 0x07429D18
.long 0xD3EE80D8, 0x07629D1A
.long 0xD3D84010, 0x1800013E
.long 0xD3D84011, 0x1800013F
.long 0xD3D84012, 0x1800017E
.long 0xD3D84013, 0x1800017F
.long 0xBF800001
.long 0xBF8C0F70
.long 0xD2800010, 0x2002B110
.long 0xD2800012, 0x2002B512
.long 0xD3EE80E0, 0x07829D1C
.long 0xE0741000, 0x80041008
.long 0xE0741000, 0x80041209
.long 0xD3EE80E8, 0x07A29D1E
.long 0xD3EE80F0, 0x07C29D20
.long 0xD3EE80F8, 0x07E29D22
.long 0xBF8C0F74
.long 0xBF8A0000
.long 0xBF8CC67F
.long 0xD3EE8080, 0x0602A124
.long 0xD3EE8088, 0x0622A126
.long 0xBF8CC47F
.long 0xD3EE8090, 0x0642A128
.long 0xD3EE8098, 0x0662A12A
.long 0xBF8CC27F
.long 0xD3EE80A0, 0x0682A12C
.long 0xD3EE80A8, 0x06A2A12E
.long 0xBF8CC07F
.long 0xD3EE80B0, 0x06C2A130
.long 0xD3EE80B8, 0x06E2A132
.long 0xD3EE80C0, 0x0702A524
.long 0xD3EE80C8, 0x0722A526
.long 0xD3EE80D0, 0x0742A528
.long 0xD3EE80D8, 0x0762A52A
.long 0xD3EE80E0, 0x0782A52C
.long 0xD3EE80E8, 0x07A2A52E
.long 0xD3EE80F0, 0x07C2A530
.long 0xD3EE80F8, 0x07E2A532
.long 0xBE9200FF, 0x80000000
.long 0xBF091224
.long 0x850C2412
.long 0xBF068025
.long 0xBE92020C
.long 0xD0C9000C, 0x00009D0A
.long 0xD1000008, 0x0032190E
.long 0xD0C9000C, 0x00009D0B
.long 0xD1000009, 0x00321B0E
.long 0xBF8204D3
.long 0xBF8C0F7D
.long 0xBF8A0000
.long 0xBF8CC67F
.long 0xD3EE8000, 0x04028914
.long 0xD8EC50A0, 0x2400000F
.long 0xD8EC5120, 0x2600000F
.long 0xD3EE8008, 0x04228916
.long 0xBF8CC67F
.long 0xD3EE8010, 0x04428918
.long 0xD8EC51A0, 0x2800000F
.long 0xD8EC5220, 0x2A00000F
.long 0xD3EE8018, 0x0462891A
.long 0xBF8CC67F
.long 0xD3EE8020, 0x0482891C
.long 0xD8EC52A0, 0x2C00000F
.long 0xD8EC5320, 0x2E00000F
.long 0xD3EE8028, 0x04A2891E
.long 0xBF8CC67F
.long 0xD3EE8030, 0x04C28920
.long 0xD8EC53A0, 0x3000000F
.long 0xD8EC5420, 0x3200000F
.long 0xD3EE8038, 0x04E28922
.long 0xD3EE8040, 0x05028D14
.long 0xD3EE8048, 0x05228D16
.long 0xD3EE8050, 0x05428D18
.long 0xD3EE8058, 0x05628D1A
.long 0xD3EE8060, 0x05828D1C
.long 0xE0541000, 0x80045808
.long 0xE0541000, 0x80045A09
.long 0xD3EE8068, 0x05A28D1E
.long 0xD3EE8070, 0x05C28D20
.long 0xD3EE8078, 0x05E28D22
.long 0xBF8C0F7A
.long 0xBF8A0000
.long 0xBF8CC67F
.long 0xD3EE8000, 0x04029124
.long 0xD8EC60C0, 0x1400000F
.long 0xD8EC6140, 0x1600000F
.long 0xD3EE8008, 0x04229126
.long 0xBF8CC67F
.long 0xD3EE8010, 0x04429128
.long 0xD8EC61C0, 0x1800000F
.long 0xD8EC6240, 0x1A00000F
.long 0xD3EE8018, 0x0462912A
.long 0xBF8CC67F
.long 0xD3EE8020, 0x0482912C
.long 0xD8EC62C0, 0x1C00000F
.long 0xD8EC6340, 0x1E00000F
.long 0xD3EE8028, 0x04A2912E
.long 0xBF8CC67F
.long 0xD3EE8030, 0x04C29130
.long 0xD8EC63C0, 0x2000000F
.long 0xD8EC6440, 0x2200000F
.long 0xD3EE8038, 0x04E29132
.long 0xD3EE8040, 0x05029524
.long 0xD3EE8048, 0x05229526
.long 0xD3EE8050, 0x05429528
.long 0xD3EE8058, 0x0562952A
.long 0xD3EE8060, 0x0582952C
.long 0xD3EE8068, 0x05A2952E
.long 0xD3EE8070, 0x05C29530
.long 0xD3EE8078, 0x05E29532
.long 0xBF8C0F73
.long 0xBF8A0000
.long 0xBF8CC67F
.long 0xD3EE8000, 0x04029914
.long 0xD8EC70E0, 0x2400000F
.long 0xD8EC7160, 0x2600000F
.long 0xD3EE8008, 0x04229916
.long 0xBF8CC67F
.long 0xD3EE8010, 0x04429918
.long 0xD8EC71E0, 0x2800000F
.long 0xD8EC7260, 0x2A00000F
.long 0xD3EE8018, 0x0462991A
.long 0xBF8CC67F
.long 0xD3EE8020, 0x0482991C
.long 0xD8EC72E0, 0x2C00000F
.long 0xD8EC7360, 0x2E00000F
.long 0xD3EE8028, 0x04A2991E
.long 0xBF8CC67F
.long 0xD3EE8030, 0x04C29920
.long 0xD8EC73E0, 0x3000000F
.long 0xD8EC7460, 0x3200000F
.long 0xD3EE8038, 0x04E29922
.long 0xD3EE8040, 0x05029D14
.long 0xD3EE8048, 0x05229D16
.long 0xD3EE8050, 0x05429D18
.long 0xD3EE8058, 0x05629D1A
.long 0xD3D84010, 0x180001BE
.long 0xD3D84011, 0x180001BF
.long 0xD3D84012, 0x180001FE
.long 0xD3D84013, 0x180001FF
.long 0xBF800001
.long 0xBF8C0F70
.long 0xD2800010, 0x2002B110
.long 0xD2800012, 0x2002B512
.long 0xD3EE8060, 0x05829D1C
.long 0xE0741000, 0x80041008
.long 0xE0741000, 0x80041209
.long 0xD3EE8068, 0x05A29D1E
.long 0xD3EE8070, 0x05C29D20
.long 0xD3EE8078, 0x05E29D22
.long 0xBF8C0F74
.long 0xBF8A0000
.long 0xBF8CC67F
.long 0xD3EE8000, 0x0402A124
.long 0xD3EE8008, 0x0422A126
.long 0xBF8CC47F
.long 0xD3EE8010, 0x0442A128
.long 0xD3EE8018, 0x0462A12A
.long 0xBF8CC27F
.long 0xD3EE8020, 0x0482A12C
.long 0xD3EE8028, 0x04A2A12E
.long 0xBF8CC07F
.long 0xD3EE8030, 0x04C2A130
.long 0xD3EE8038, 0x04E2A132
.long 0xD3EE8040, 0x0502A524
.long 0xD3EE8048, 0x0522A526
.long 0xD3EE8050, 0x0542A528
.long 0xD3EE8058, 0x0562A52A
.long 0xD3EE8060, 0x0582A52C
.long 0xD3EE8068, 0x05A2A52E
.long 0xD3EE8070, 0x05C2A530
.long 0xD3EE8078, 0x05E2A532
.long 0xBE9200FF, 0x80000000
.long 0xBF091224
.long 0x850C2412
.long 0xBF068025
.long 0xBE92020C
.long 0xD0C9000C, 0x00009D0A
.long 0xD1000008, 0x0032190E
.long 0xD0C9000C, 0x00009D0B
.long 0xD1000009, 0x00321B0E
.long 0x8010443E
.long 0x8211453F
.long 0xBE9200FF, 0x80000000
.long 0xBF091224
.long 0x850C2412
.long 0xBF068025
.long 0xBE92020C
.long 0xE0541000, 0x80045408
.long 0xE0541000, 0x80045609
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xE0541000, 0x80045808
.long 0xE0541000, 0x80045A09
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xE0541000, 0x80045C08
.long 0xE0541000, 0x80045E09
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xE0541000, 0x80046008
.long 0xE0541000, 0x80046209
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xE0541000, 0x80046408
.long 0xE0541000, 0x80046609
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xE0541000, 0x80046808
.long 0xE0541000, 0x80046A09
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xE0541000, 0x80046C08
.long 0xE0541000, 0x80046E09
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xE0541000, 0x80047008
.long 0xE0541000, 0x80047209
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xE0541000, 0x80047408
.long 0xE0541000, 0x80047609
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xE0541000, 0x80047808
.long 0xE0541000, 0x80047A09
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xE0541000, 0x80047C08
.long 0xE0541000, 0x80047E09
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xE0541000, 0x80048008
.long 0xE0541000, 0x80048209
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xE0541000, 0x80048408
.long 0xE0541000, 0x80048609
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xE0541000, 0x80048808
.long 0xE0541000, 0x80048A09
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xE0541000, 0x80048C08
.long 0xE0541000, 0x80048E09
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xE0541000, 0x80049008
.long 0xE0541000, 0x80049209
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xE0541000, 0x80049408
.long 0xE0541000, 0x80049609
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xE0541000, 0x80049808
.long 0xE0541000, 0x80049A09
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xE0541000, 0x80049C08
.long 0xE0541000, 0x80049E09
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xE0541000, 0x8004A008
.long 0xE0541000, 0x8004A209
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xE0541000, 0x8004A408
.long 0xE0541000, 0x8004A609
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xE0541000, 0x8004A808
.long 0xE0541000, 0x8004AA09
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xE0541000, 0x8004AC08
.long 0xE0541000, 0x8004AE09
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xE0541000, 0x8004B008
.long 0xE0541000, 0x8004B209
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xE0541000, 0x8004B408
.long 0xE0541000, 0x8004B609
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xE0541000, 0x8004B808
.long 0xE0541000, 0x8004BA09
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xE0541000, 0x8004BC08
.long 0xE0541000, 0x8004BE09
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xE0541000, 0x8004C008
.long 0xE0541000, 0x8004C209
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xE0541000, 0x8004C408
.long 0xE0541000, 0x8004C609
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xE0541000, 0x8004C808
.long 0xE0541000, 0x8004CA09
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xE0541000, 0x8004CC08
.long 0xE0541000, 0x8004CE09
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xE0541000, 0x8004D008
.long 0xE0541000, 0x8004D209
.long 0x8010443E
.long 0x8211453F
.long 0xBE9200FF, 0x80000000
.long 0xBF068025
.long 0xBE920224
.long 0xD3D84010, 0x18000100
.long 0xD3D84011, 0x18000101
.long 0xD3D84012, 0x18000140
.long 0xD3D84013, 0x18000141
.long 0xBF800001
.long 0xBF8C4F7E
.long 0xD2800010, 0x2002A910
.long 0xD2800012, 0x2002AD12
.long 0xE0741000, 0x80041008
.long 0xE0741000, 0x80041209
.long 0xBF800000
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xD3D84010, 0x18000102
.long 0xD3D84011, 0x18000103
.long 0xD3D84012, 0x18000142
.long 0xD3D84013, 0x18000143
.long 0xBF800001
.long 0xBF8C4F7E
.long 0xD2800010, 0x2002B110
.long 0xD2800012, 0x2002B512
.long 0xE0741000, 0x80041008
.long 0xE0741000, 0x80041209
.long 0xBF800000
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xD3D84010, 0x18000104
.long 0xD3D84011, 0x18000105
.long 0xD3D84012, 0x18000144
.long 0xD3D84013, 0x18000145
.long 0xBF800001
.long 0xBF8C4F7E
.long 0xD2800010, 0x2002B910
.long 0xD2800012, 0x2002BD12
.long 0xE0741000, 0x80041008
.long 0xE0741000, 0x80041209
.long 0xBF800000
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xD3D84010, 0x18000106
.long 0xD3D84011, 0x18000107
.long 0xD3D84012, 0x18000146
.long 0xD3D84013, 0x18000147
.long 0xBF800001
.long 0xBF8C4F7E
.long 0xD2800010, 0x2002C110
.long 0xD2800012, 0x2002C512
.long 0xE0741000, 0x80041008
.long 0xE0741000, 0x80041209
.long 0xBF800000
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xD3D84010, 0x18000108
.long 0xD3D84011, 0x18000109
.long 0xD3D84012, 0x18000148
.long 0xD3D84013, 0x18000149
.long 0xBF800001
.long 0xBF8C4F7E
.long 0xD2800010, 0x2002C910
.long 0xD2800012, 0x2002CD12
.long 0xE0741000, 0x80041008
.long 0xE0741000, 0x80041209
.long 0xBF800000
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xD3D84010, 0x1800010A
.long 0xD3D84011, 0x1800010B
.long 0xD3D84012, 0x1800014A
.long 0xD3D84013, 0x1800014B
.long 0xBF800001
.long 0xBF8C4F7E
.long 0xD2800010, 0x2002D110
.long 0xD2800012, 0x2002D512
.long 0xE0741000, 0x80041008
.long 0xE0741000, 0x80041209
.long 0xBF800000
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xD3D84010, 0x1800010C
.long 0xD3D84011, 0x1800010D
.long 0xD3D84012, 0x1800014C
.long 0xD3D84013, 0x1800014D
.long 0xBF800001
.long 0xBF8C4F7E
.long 0xD2800010, 0x2002D910
.long 0xD2800012, 0x2002DD12
.long 0xE0741000, 0x80041008
.long 0xE0741000, 0x80041209
.long 0xBF800000
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xD3D84010, 0x1800010E
.long 0xD3D84011, 0x1800010F
.long 0xD3D84012, 0x1800014E
.long 0xD3D84013, 0x1800014F
.long 0xBF800001
.long 0xBF8C4F7E
.long 0xD2800010, 0x2002E110
.long 0xD2800012, 0x2002E512
.long 0xE0741000, 0x80041008
.long 0xE0741000, 0x80041209
.long 0xBF800000
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xD3D84010, 0x18000110
.long 0xD3D84011, 0x18000111
.long 0xD3D84012, 0x18000150
.long 0xD3D84013, 0x18000151
.long 0xBF800001
.long 0xBF8C4F7E
.long 0xD2800010, 0x2002E910
.long 0xD2800012, 0x2002ED12
.long 0xE0741000, 0x80041008
.long 0xE0741000, 0x80041209
.long 0xBF800000
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xD3D84010, 0x18000112
.long 0xD3D84011, 0x18000113
.long 0xD3D84012, 0x18000152
.long 0xD3D84013, 0x18000153
.long 0xBF800001
.long 0xBF8C4F7E
.long 0xD2800010, 0x2002F110
.long 0xD2800012, 0x2002F512
.long 0xE0741000, 0x80041008
.long 0xE0741000, 0x80041209
.long 0xBF800000
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xD3D84010, 0x18000114
.long 0xD3D84011, 0x18000115
.long 0xD3D84012, 0x18000154
.long 0xD3D84013, 0x18000155
.long 0xBF800001
.long 0xBF8C4F7E
.long 0xD2800010, 0x2002F910
.long 0xD2800012, 0x2002FD12
.long 0xE0741000, 0x80041008
.long 0xE0741000, 0x80041209
.long 0xBF800000
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xD3D84010, 0x18000116
.long 0xD3D84011, 0x18000117
.long 0xD3D84012, 0x18000156
.long 0xD3D84013, 0x18000157
.long 0xBF800001
.long 0xBF8C4F7E
.long 0xD2800010, 0x20030110
.long 0xD2800012, 0x20030512
.long 0xE0741000, 0x80041008
.long 0xE0741000, 0x80041209
.long 0xBF800000
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xD3D84010, 0x18000118
.long 0xD3D84011, 0x18000119
.long 0xD3D84012, 0x18000158
.long 0xD3D84013, 0x18000159
.long 0xBF800001
.long 0xBF8C4F7E
.long 0xD2800010, 0x20030910
.long 0xD2800012, 0x20030D12
.long 0xE0741000, 0x80041008
.long 0xE0741000, 0x80041209
.long 0xBF800000
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xD3D84010, 0x1800011A
.long 0xD3D84011, 0x1800011B
.long 0xD3D84012, 0x1800015A
.long 0xD3D84013, 0x1800015B
.long 0xBF800001
.long 0xBF8C4F7E
.long 0xD2800010, 0x20031110
.long 0xD2800012, 0x20031512
.long 0xE0741000, 0x80041008
.long 0xE0741000, 0x80041209
.long 0xBF800000
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xD3D84010, 0x1800011C
.long 0xD3D84011, 0x1800011D
.long 0xD3D84012, 0x1800015C
.long 0xD3D84013, 0x1800015D
.long 0xBF800001
.long 0xBF8C4F7E
.long 0xD2800010, 0x20031910
.long 0xD2800012, 0x20031D12
.long 0xE0741000, 0x80041008
.long 0xE0741000, 0x80041209
.long 0xBF800000
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xD3D84010, 0x1800011E
.long 0xD3D84011, 0x1800011F
.long 0xD3D84012, 0x1800015E
.long 0xD3D84013, 0x1800015F
.long 0xBF800001
.long 0xBF8C4F7E
.long 0xD2800010, 0x20032110
.long 0xD2800012, 0x20032512
.long 0xE0741000, 0x80041008
.long 0xE0741000, 0x80041209
.long 0xBF800000
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xD3D84010, 0x18000120
.long 0xD3D84011, 0x18000121
.long 0xD3D84012, 0x18000160
.long 0xD3D84013, 0x18000161
.long 0xBF800001
.long 0xBF8C4F7E
.long 0xD2800010, 0x20032910
.long 0xD2800012, 0x20032D12
.long 0xE0741000, 0x80041008
.long 0xE0741000, 0x80041209
.long 0xBF800000
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xD3D84010, 0x18000122
.long 0xD3D84011, 0x18000123
.long 0xD3D84012, 0x18000162
.long 0xD3D84013, 0x18000163
.long 0xBF800001
.long 0xBF8C4F7E
.long 0xD2800010, 0x20033110
.long 0xD2800012, 0x20033512
.long 0xE0741000, 0x80041008
.long 0xE0741000, 0x80041209
.long 0xBF800000
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xD3D84010, 0x18000124
.long 0xD3D84011, 0x18000125
.long 0xD3D84012, 0x18000164
.long 0xD3D84013, 0x18000165
.long 0xBF800001
.long 0xBF8C4F7E
.long 0xD2800010, 0x20033910
.long 0xD2800012, 0x20033D12
.long 0xE0741000, 0x80041008
.long 0xE0741000, 0x80041209
.long 0xBF800000
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xD3D84010, 0x18000126
.long 0xD3D84011, 0x18000127
.long 0xD3D84012, 0x18000166
.long 0xD3D84013, 0x18000167
.long 0xBF800001
.long 0xBF8C4F7E
.long 0xD2800010, 0x20034110
.long 0xD2800012, 0x20034512
.long 0xE0741000, 0x80041008
.long 0xE0741000, 0x80041209
.long 0xBF800000
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xD3D84010, 0x18000128
.long 0xD3D84011, 0x18000129
.long 0xD3D84012, 0x18000168
.long 0xD3D84013, 0x18000169
.long 0xBF800001
.long 0xBF8C4F7E
.long 0xD2800010, 0x20034910
.long 0xD2800012, 0x20034D12
.long 0xE0741000, 0x80041008
.long 0xE0741000, 0x80041209
.long 0xBF800000
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xD3D84010, 0x1800012A
.long 0xD3D84011, 0x1800012B
.long 0xD3D84012, 0x1800016A
.long 0xD3D84013, 0x1800016B
.long 0xBF800001
.long 0xBF8C4F7E
.long 0xD2800010, 0x20035110
.long 0xD2800012, 0x20035512
.long 0xE0741000, 0x80041008
.long 0xE0741000, 0x80041209
.long 0xBF800000
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xD3D84010, 0x1800012C
.long 0xD3D84011, 0x1800012D
.long 0xD3D84012, 0x1800016C
.long 0xD3D84013, 0x1800016D
.long 0xBF800001
.long 0xBF8C4F7E
.long 0xD2800010, 0x20035910
.long 0xD2800012, 0x20035D12
.long 0xE0741000, 0x80041008
.long 0xE0741000, 0x80041209
.long 0xBF800000
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xD3D84010, 0x1800012E
.long 0xD3D84011, 0x1800012F
.long 0xD3D84012, 0x1800016E
.long 0xD3D84013, 0x1800016F
.long 0xBF800001
.long 0xBF8C4F7E
.long 0xD2800010, 0x20036110
.long 0xD2800012, 0x20036512
.long 0xE0741000, 0x80041008
.long 0xE0741000, 0x80041209
.long 0xBF800000
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xD3D84010, 0x18000130
.long 0xD3D84011, 0x18000131
.long 0xD3D84012, 0x18000170
.long 0xD3D84013, 0x18000171
.long 0xBF800001
.long 0xBF8C4F7E
.long 0xD2800010, 0x20036910
.long 0xD2800012, 0x20036D12
.long 0xE0741000, 0x80041008
.long 0xE0741000, 0x80041209
.long 0xBF800000
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xD3D84010, 0x18000132
.long 0xD3D84011, 0x18000133
.long 0xD3D84012, 0x18000172
.long 0xD3D84013, 0x18000173
.long 0xBF800001
.long 0xBF8C4F7E
.long 0xD2800010, 0x20037110
.long 0xD2800012, 0x20037512
.long 0xE0741000, 0x80041008
.long 0xE0741000, 0x80041209
.long 0xBF800000
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xD3D84010, 0x18000134
.long 0xD3D84011, 0x18000135
.long 0xD3D84012, 0x18000174
.long 0xD3D84013, 0x18000175
.long 0xBF800001
.long 0xBF8C4F7E
.long 0xD2800010, 0x20037910
.long 0xD2800012, 0x20037D12
.long 0xE0741000, 0x80041008
.long 0xE0741000, 0x80041209
.long 0xBF800000
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xD3D84010, 0x18000136
.long 0xD3D84011, 0x18000137
.long 0xD3D84012, 0x18000176
.long 0xD3D84013, 0x18000177
.long 0xBF800001
.long 0xBF8C4F7E
.long 0xD2800010, 0x20038110
.long 0xD2800012, 0x20038512
.long 0xE0741000, 0x80041008
.long 0xE0741000, 0x80041209
.long 0xBF800000
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xD3D84010, 0x18000138
.long 0xD3D84011, 0x18000139
.long 0xD3D84012, 0x18000178
.long 0xD3D84013, 0x18000179
.long 0xBF800001
.long 0xBF8C4F7E
.long 0xD2800010, 0x20038910
.long 0xD2800012, 0x20038D12
.long 0xE0741000, 0x80041008
.long 0xE0741000, 0x80041209
.long 0xBF800000
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xD3D84010, 0x1800013A
.long 0xD3D84011, 0x1800013B
.long 0xD3D84012, 0x1800017A
.long 0xD3D84013, 0x1800017B
.long 0xBF800001
.long 0xBF8C4F7E
.long 0xD2800010, 0x20039110
.long 0xD2800012, 0x20039512
.long 0xE0741000, 0x80041008
.long 0xE0741000, 0x80041209
.long 0xBF800000
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xD3D84010, 0x1800013C
.long 0xD3D84011, 0x1800013D
.long 0xD3D84012, 0x1800017C
.long 0xD3D84013, 0x1800017D
.long 0xBF800001
.long 0xBF8C4F7E
.long 0xD2800010, 0x20039910
.long 0xD2800012, 0x20039D12
.long 0xE0741000, 0x80041008
.long 0xE0741000, 0x80041209
.long 0xBF800000
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xD3D84010, 0x1800013E
.long 0xD3D84011, 0x1800013F
.long 0xD3D84012, 0x1800017E
.long 0xD3D84013, 0x1800017F
.long 0xBF800001
.long 0xBF8C4F7E
.long 0xD2800010, 0x2003A110
.long 0xD2800012, 0x2003A512
.long 0xE0741000, 0x80041008
.long 0xE0741000, 0x80041209
.long 0xBF800000
.long 0xBF8203E6
.long 0x8010443E
.long 0x8211453F
.long 0xBE9200FF, 0x80000000
.long 0xBF091224
.long 0x850C2412
.long 0xBF068025
.long 0xBE92020C
.long 0xE0541000, 0x80045408
.long 0xE0541000, 0x80045609
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xE0541000, 0x80045808
.long 0xE0541000, 0x80045A09
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xE0541000, 0x80045C08
.long 0xE0541000, 0x80045E09
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xE0541000, 0x80046008
.long 0xE0541000, 0x80046209
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xE0541000, 0x80046408
.long 0xE0541000, 0x80046609
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xE0541000, 0x80046808
.long 0xE0541000, 0x80046A09
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xE0541000, 0x80046C08
.long 0xE0541000, 0x80046E09
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xE0541000, 0x80047008
.long 0xE0541000, 0x80047209
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xE0541000, 0x80047408
.long 0xE0541000, 0x80047609
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xE0541000, 0x80047808
.long 0xE0541000, 0x80047A09
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xE0541000, 0x80047C08
.long 0xE0541000, 0x80047E09
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xE0541000, 0x80048008
.long 0xE0541000, 0x80048209
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xE0541000, 0x80048408
.long 0xE0541000, 0x80048609
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xE0541000, 0x80048808
.long 0xE0541000, 0x80048A09
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xE0541000, 0x80048C08
.long 0xE0541000, 0x80048E09
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xE0541000, 0x80049008
.long 0xE0541000, 0x80049209
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xE0541000, 0x80049408
.long 0xE0541000, 0x80049609
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xE0541000, 0x80049808
.long 0xE0541000, 0x80049A09
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xE0541000, 0x80049C08
.long 0xE0541000, 0x80049E09
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xE0541000, 0x8004A008
.long 0xE0541000, 0x8004A209
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xE0541000, 0x8004A408
.long 0xE0541000, 0x8004A609
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xE0541000, 0x8004A808
.long 0xE0541000, 0x8004AA09
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xE0541000, 0x8004AC08
.long 0xE0541000, 0x8004AE09
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xE0541000, 0x8004B008
.long 0xE0541000, 0x8004B209
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xE0541000, 0x8004B408
.long 0xE0541000, 0x8004B609
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xE0541000, 0x8004B808
.long 0xE0541000, 0x8004BA09
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xE0541000, 0x8004BC08
.long 0xE0541000, 0x8004BE09
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xE0541000, 0x8004C008
.long 0xE0541000, 0x8004C209
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xE0541000, 0x8004C408
.long 0xE0541000, 0x8004C609
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xE0541000, 0x8004C808
.long 0xE0541000, 0x8004CA09
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xE0541000, 0x8004CC08
.long 0xE0541000, 0x8004CE09
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xE0541000, 0x8004D008
.long 0xE0541000, 0x8004D209
.long 0x8010443E
.long 0x8211453F
.long 0xBE9200FF, 0x80000000
.long 0xBF068025
.long 0xBE920224
.long 0xD3D84010, 0x18000180
.long 0xD3D84011, 0x18000181
.long 0xD3D84012, 0x180001C0
.long 0xD3D84013, 0x180001C1
.long 0xBF800001
.long 0xBF8C4F7E
.long 0xD2800010, 0x2002A910
.long 0xD2800012, 0x2002AD12
.long 0xE0741000, 0x80041008
.long 0xE0741000, 0x80041209
.long 0xBF800000
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xD3D84010, 0x18000182
.long 0xD3D84011, 0x18000183
.long 0xD3D84012, 0x180001C2
.long 0xD3D84013, 0x180001C3
.long 0xBF800001
.long 0xBF8C4F7E
.long 0xD2800010, 0x2002B110
.long 0xD2800012, 0x2002B512
.long 0xE0741000, 0x80041008
.long 0xE0741000, 0x80041209
.long 0xBF800000
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xD3D84010, 0x18000184
.long 0xD3D84011, 0x18000185
.long 0xD3D84012, 0x180001C4
.long 0xD3D84013, 0x180001C5
.long 0xBF800001
.long 0xBF8C4F7E
.long 0xD2800010, 0x2002B910
.long 0xD2800012, 0x2002BD12
.long 0xE0741000, 0x80041008
.long 0xE0741000, 0x80041209
.long 0xBF800000
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xD3D84010, 0x18000186
.long 0xD3D84011, 0x18000187
.long 0xD3D84012, 0x180001C6
.long 0xD3D84013, 0x180001C7
.long 0xBF800001
.long 0xBF8C4F7E
.long 0xD2800010, 0x2002C110
.long 0xD2800012, 0x2002C512
.long 0xE0741000, 0x80041008
.long 0xE0741000, 0x80041209
.long 0xBF800000
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xD3D84010, 0x18000188
.long 0xD3D84011, 0x18000189
.long 0xD3D84012, 0x180001C8
.long 0xD3D84013, 0x180001C9
.long 0xBF800001
.long 0xBF8C4F7E
.long 0xD2800010, 0x2002C910
.long 0xD2800012, 0x2002CD12
.long 0xE0741000, 0x80041008
.long 0xE0741000, 0x80041209
.long 0xBF800000
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xD3D84010, 0x1800018A
.long 0xD3D84011, 0x1800018B
.long 0xD3D84012, 0x180001CA
.long 0xD3D84013, 0x180001CB
.long 0xBF800001
.long 0xBF8C4F7E
.long 0xD2800010, 0x2002D110
.long 0xD2800012, 0x2002D512
.long 0xE0741000, 0x80041008
.long 0xE0741000, 0x80041209
.long 0xBF800000
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xD3D84010, 0x1800018C
.long 0xD3D84011, 0x1800018D
.long 0xD3D84012, 0x180001CC
.long 0xD3D84013, 0x180001CD
.long 0xBF800001
.long 0xBF8C4F7E
.long 0xD2800010, 0x2002D910
.long 0xD2800012, 0x2002DD12
.long 0xE0741000, 0x80041008
.long 0xE0741000, 0x80041209
.long 0xBF800000
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xD3D84010, 0x1800018E
.long 0xD3D84011, 0x1800018F
.long 0xD3D84012, 0x180001CE
.long 0xD3D84013, 0x180001CF
.long 0xBF800001
.long 0xBF8C4F7E
.long 0xD2800010, 0x2002E110
.long 0xD2800012, 0x2002E512
.long 0xE0741000, 0x80041008
.long 0xE0741000, 0x80041209
.long 0xBF800000
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xD3D84010, 0x18000190
.long 0xD3D84011, 0x18000191
.long 0xD3D84012, 0x180001D0
.long 0xD3D84013, 0x180001D1
.long 0xBF800001
.long 0xBF8C4F7E
.long 0xD2800010, 0x2002E910
.long 0xD2800012, 0x2002ED12
.long 0xE0741000, 0x80041008
.long 0xE0741000, 0x80041209
.long 0xBF800000
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xD3D84010, 0x18000192
.long 0xD3D84011, 0x18000193
.long 0xD3D84012, 0x180001D2
.long 0xD3D84013, 0x180001D3
.long 0xBF800001
.long 0xBF8C4F7E
.long 0xD2800010, 0x2002F110
.long 0xD2800012, 0x2002F512
.long 0xE0741000, 0x80041008
.long 0xE0741000, 0x80041209
.long 0xBF800000
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xD3D84010, 0x18000194
.long 0xD3D84011, 0x18000195
.long 0xD3D84012, 0x180001D4
.long 0xD3D84013, 0x180001D5
.long 0xBF800001
.long 0xBF8C4F7E
.long 0xD2800010, 0x2002F910
.long 0xD2800012, 0x2002FD12
.long 0xE0741000, 0x80041008
.long 0xE0741000, 0x80041209
.long 0xBF800000
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xD3D84010, 0x18000196
.long 0xD3D84011, 0x18000197
.long 0xD3D84012, 0x180001D6
.long 0xD3D84013, 0x180001D7
.long 0xBF800001
.long 0xBF8C4F7E
.long 0xD2800010, 0x20030110
.long 0xD2800012, 0x20030512
.long 0xE0741000, 0x80041008
.long 0xE0741000, 0x80041209
.long 0xBF800000
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xD3D84010, 0x18000198
.long 0xD3D84011, 0x18000199
.long 0xD3D84012, 0x180001D8
.long 0xD3D84013, 0x180001D9
.long 0xBF800001
.long 0xBF8C4F7E
.long 0xD2800010, 0x20030910
.long 0xD2800012, 0x20030D12
.long 0xE0741000, 0x80041008
.long 0xE0741000, 0x80041209
.long 0xBF800000
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xD3D84010, 0x1800019A
.long 0xD3D84011, 0x1800019B
.long 0xD3D84012, 0x180001DA
.long 0xD3D84013, 0x180001DB
.long 0xBF800001
.long 0xBF8C4F7E
.long 0xD2800010, 0x20031110
.long 0xD2800012, 0x20031512
.long 0xE0741000, 0x80041008
.long 0xE0741000, 0x80041209
.long 0xBF800000
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xD3D84010, 0x1800019C
.long 0xD3D84011, 0x1800019D
.long 0xD3D84012, 0x180001DC
.long 0xD3D84013, 0x180001DD
.long 0xBF800001
.long 0xBF8C4F7E
.long 0xD2800010, 0x20031910
.long 0xD2800012, 0x20031D12
.long 0xE0741000, 0x80041008
.long 0xE0741000, 0x80041209
.long 0xBF800000
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xD3D84010, 0x1800019E
.long 0xD3D84011, 0x1800019F
.long 0xD3D84012, 0x180001DE
.long 0xD3D84013, 0x180001DF
.long 0xBF800001
.long 0xBF8C4F7E
.long 0xD2800010, 0x20032110
.long 0xD2800012, 0x20032512
.long 0xE0741000, 0x80041008
.long 0xE0741000, 0x80041209
.long 0xBF800000
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xD3D84010, 0x180001A0
.long 0xD3D84011, 0x180001A1
.long 0xD3D84012, 0x180001E0
.long 0xD3D84013, 0x180001E1
.long 0xBF800001
.long 0xBF8C4F7E
.long 0xD2800010, 0x20032910
.long 0xD2800012, 0x20032D12
.long 0xE0741000, 0x80041008
.long 0xE0741000, 0x80041209
.long 0xBF800000
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xD3D84010, 0x180001A2
.long 0xD3D84011, 0x180001A3
.long 0xD3D84012, 0x180001E2
.long 0xD3D84013, 0x180001E3
.long 0xBF800001
.long 0xBF8C4F7E
.long 0xD2800010, 0x20033110
.long 0xD2800012, 0x20033512
.long 0xE0741000, 0x80041008
.long 0xE0741000, 0x80041209
.long 0xBF800000
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xD3D84010, 0x180001A4
.long 0xD3D84011, 0x180001A5
.long 0xD3D84012, 0x180001E4
.long 0xD3D84013, 0x180001E5
.long 0xBF800001
.long 0xBF8C4F7E
.long 0xD2800010, 0x20033910
.long 0xD2800012, 0x20033D12
.long 0xE0741000, 0x80041008
.long 0xE0741000, 0x80041209
.long 0xBF800000
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xD3D84010, 0x180001A6
.long 0xD3D84011, 0x180001A7
.long 0xD3D84012, 0x180001E6
.long 0xD3D84013, 0x180001E7
.long 0xBF800001
.long 0xBF8C4F7E
.long 0xD2800010, 0x20034110
.long 0xD2800012, 0x20034512
.long 0xE0741000, 0x80041008
.long 0xE0741000, 0x80041209
.long 0xBF800000
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xD3D84010, 0x180001A8
.long 0xD3D84011, 0x180001A9
.long 0xD3D84012, 0x180001E8
.long 0xD3D84013, 0x180001E9
.long 0xBF800001
.long 0xBF8C4F7E
.long 0xD2800010, 0x20034910
.long 0xD2800012, 0x20034D12
.long 0xE0741000, 0x80041008
.long 0xE0741000, 0x80041209
.long 0xBF800000
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xD3D84010, 0x180001AA
.long 0xD3D84011, 0x180001AB
.long 0xD3D84012, 0x180001EA
.long 0xD3D84013, 0x180001EB
.long 0xBF800001
.long 0xBF8C4F7E
.long 0xD2800010, 0x20035110
.long 0xD2800012, 0x20035512
.long 0xE0741000, 0x80041008
.long 0xE0741000, 0x80041209
.long 0xBF800000
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xD3D84010, 0x180001AC
.long 0xD3D84011, 0x180001AD
.long 0xD3D84012, 0x180001EC
.long 0xD3D84013, 0x180001ED
.long 0xBF800001
.long 0xBF8C4F7E
.long 0xD2800010, 0x20035910
.long 0xD2800012, 0x20035D12
.long 0xE0741000, 0x80041008
.long 0xE0741000, 0x80041209
.long 0xBF800000
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xD3D84010, 0x180001AE
.long 0xD3D84011, 0x180001AF
.long 0xD3D84012, 0x180001EE
.long 0xD3D84013, 0x180001EF
.long 0xBF800001
.long 0xBF8C4F7E
.long 0xD2800010, 0x20036110
.long 0xD2800012, 0x20036512
.long 0xE0741000, 0x80041008
.long 0xE0741000, 0x80041209
.long 0xBF800000
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xD3D84010, 0x180001B0
.long 0xD3D84011, 0x180001B1
.long 0xD3D84012, 0x180001F0
.long 0xD3D84013, 0x180001F1
.long 0xBF800001
.long 0xBF8C4F7E
.long 0xD2800010, 0x20036910
.long 0xD2800012, 0x20036D12
.long 0xE0741000, 0x80041008
.long 0xE0741000, 0x80041209
.long 0xBF800000
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xD3D84010, 0x180001B2
.long 0xD3D84011, 0x180001B3
.long 0xD3D84012, 0x180001F2
.long 0xD3D84013, 0x180001F3
.long 0xBF800001
.long 0xBF8C4F7E
.long 0xD2800010, 0x20037110
.long 0xD2800012, 0x20037512
.long 0xE0741000, 0x80041008
.long 0xE0741000, 0x80041209
.long 0xBF800000
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xD3D84010, 0x180001B4
.long 0xD3D84011, 0x180001B5
.long 0xD3D84012, 0x180001F4
.long 0xD3D84013, 0x180001F5
.long 0xBF800001
.long 0xBF8C4F7E
.long 0xD2800010, 0x20037910
.long 0xD2800012, 0x20037D12
.long 0xE0741000, 0x80041008
.long 0xE0741000, 0x80041209
.long 0xBF800000
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xD3D84010, 0x180001B6
.long 0xD3D84011, 0x180001B7
.long 0xD3D84012, 0x180001F6
.long 0xD3D84013, 0x180001F7
.long 0xBF800001
.long 0xBF8C4F7E
.long 0xD2800010, 0x20038110
.long 0xD2800012, 0x20038512
.long 0xE0741000, 0x80041008
.long 0xE0741000, 0x80041209
.long 0xBF800000
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xD3D84010, 0x180001B8
.long 0xD3D84011, 0x180001B9
.long 0xD3D84012, 0x180001F8
.long 0xD3D84013, 0x180001F9
.long 0xBF800001
.long 0xBF8C4F7E
.long 0xD2800010, 0x20038910
.long 0xD2800012, 0x20038D12
.long 0xE0741000, 0x80041008
.long 0xE0741000, 0x80041209
.long 0xBF800000
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xD3D84010, 0x180001BA
.long 0xD3D84011, 0x180001BB
.long 0xD3D84012, 0x180001FA
.long 0xD3D84013, 0x180001FB
.long 0xBF800001
.long 0xBF8C4F7E
.long 0xD2800010, 0x20039110
.long 0xD2800012, 0x20039512
.long 0xE0741000, 0x80041008
.long 0xE0741000, 0x80041209
.long 0xBF800000
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xD3D84010, 0x180001BC
.long 0xD3D84011, 0x180001BD
.long 0xD3D84012, 0x180001FC
.long 0xD3D84013, 0x180001FD
.long 0xBF800001
.long 0xBF8C4F7E
.long 0xD2800010, 0x20039910
.long 0xD2800012, 0x20039D12
.long 0xE0741000, 0x80041008
.long 0xE0741000, 0x80041209
.long 0xBF800000
.long 0x80101910
.long 0x82118011
.long 0x80921912
.long 0xBE920280
.long 0xD3D84010, 0x180001BE
.long 0xD3D84011, 0x180001BF
.long 0xD3D84012, 0x180001FE
.long 0xD3D84013, 0x180001FF
.long 0xBF800001
.long 0xBF8C4F7E
.long 0xD2800010, 0x2003A110
.long 0xD2800012, 0x2003A512
.long 0xE0741000, 0x80041008
.long 0xE0741000, 0x80041209
.long 0xBF800000
.long 0xBF8C0000
.long 0xBF810000
