/*
 * Decompiled with CFR 0.152.
 */
package sun.font;

import java.util.HashMap;
import sun.font.CFont;
import sun.font.CharToGlyphMapper;
import sun.font.FontUtilities;

public class CCharToGlyphMapper
extends CharToGlyphMapper {
    private Cache cache = new Cache();
    CFont fFont;
    int numGlyphs = -1;

    private static native int countGlyphs(long var0);

    public CCharToGlyphMapper(CFont cFont) {
        this.fFont = cFont;
        this.missingGlyph = 0;
    }

    @Override
    public int getNumGlyphs() {
        if (this.numGlyphs == -1) {
            this.numGlyphs = CCharToGlyphMapper.countGlyphs(this.fFont.getNativeFontPtr());
        }
        return this.numGlyphs;
    }

    @Override
    public boolean canDisplay(char c) {
        int n = this.charToGlyph(c);
        return n != this.missingGlyph;
    }

    @Override
    public boolean canDisplay(int n) {
        int n2 = this.charToGlyph(n);
        return n2 != this.missingGlyph;
    }

    @Override
    public synchronized boolean charsToGlyphsNS(int n, char[] cArray, int[] nArray) {
        this.charsToGlyphs(n, cArray, nArray);
        for (int i = 0; i < n; ++i) {
            char c;
            int n2 = cArray[i];
            if (n2 >= 55296 && n2 <= 56319 && i < n - 1 && (c = cArray[i + 1]) >= '\udc00' && c <= '\udfff') {
                n2 = (n2 - 55296) * 1024 + c - 56320 + 65536;
                nArray[i + 1] = 65535;
            }
            if (n2 < 768) continue;
            if (FontUtilities.isComplexCharCode(n2)) {
                return true;
            }
            if (n2 < 65536) continue;
            ++i;
        }
        return false;
    }

    @Override
    public synchronized int charToGlyph(char c) {
        int n = this.cache.get(c);
        if (n != 0) {
            return n;
        }
        char[] cArray = new char[]{c};
        int[] nArray = new int[1];
        CCharToGlyphMapper.nativeCharsToGlyphs(this.fFont.getNativeFontPtr(), 1, cArray, nArray);
        this.cache.put(c, nArray[0]);
        return nArray[0];
    }

    @Override
    public synchronized int charToGlyph(int n) {
        if (n >= 65536) {
            int[] nArray = new int[2];
            char[] cArray = new char[2];
            int n2 = n - 65536;
            cArray[0] = (char)((n2 >>> 10) + 55296);
            cArray[1] = (char)(n2 % 1024 + 56320);
            this.charsToGlyphs(2, cArray, nArray);
            return nArray[0];
        }
        return this.charToGlyph((char)n);
    }

    @Override
    public synchronized void charsToGlyphs(int n, char[] cArray, int[] nArray) {
        this.cache.get(n, cArray, nArray);
    }

    @Override
    public synchronized void charsToGlyphs(int n, int[] nArray, int[] nArray2) {
        for (int i = 0; i < n; ++i) {
            nArray2[i] = this.charToGlyph(nArray[i]);
        }
    }

    private static native void nativeCharsToGlyphs(long var0, int var2, char[] var3, int[] var4);

    private class Cache {
        private static final int FIRST_LAYER_SIZE = 256;
        private static final int SECOND_LAYER_SIZE = 16384;
        private final int[] firstLayerCache = new int[256];
        private SparseBitShiftingTwoLayerArray secondLayerCache;
        private HashMap<Integer, Integer> generalCache;

        Cache() {
            this.firstLayerCache[1] = 1;
        }

        public synchronized int get(int n) {
            if (n < 256) {
                return this.firstLayerCache[n];
            }
            if (n < 16384) {
                if (this.secondLayerCache == null) {
                    return 0;
                }
                return this.secondLayerCache.get(n);
            }
            if (this.generalCache == null) {
                return 0;
            }
            Integer n2 = this.generalCache.get(n);
            if (n2 == null) {
                return 0;
            }
            return n2;
        }

        public synchronized void put(int n, int n2) {
            if (n < 256) {
                this.firstLayerCache[n] = n2;
                return;
            }
            if (n < 16384) {
                if (this.secondLayerCache == null) {
                    this.secondLayerCache = new SparseBitShiftingTwoLayerArray(16384, 7);
                }
                this.secondLayerCache.put(n, n2);
                return;
            }
            if (this.generalCache == null) {
                this.generalCache = new HashMap();
            }
            this.generalCache.put(n, n2);
        }

        public synchronized void get(int n, char[] cArray, int[] nArray) {
            int n2;
            int n3;
            int n4 = 0;
            char[] cArray2 = null;
            int[] nArray2 = null;
            for (int i = 0; i < n; ++i) {
                n3 = cArray[i];
                if (n3 >= 55296 && n3 <= 56319 && i < n - 1 && (n2 = cArray[i + 1]) >= 56320 && n2 <= 57343) {
                    n3 = (n3 - 55296) * 1024 + n2 - 56320 + 65536;
                }
                if ((n2 = this.get(n3)) != 0 && n2 != -1) {
                    nArray[i] = n2;
                    if (n3 < 65536) continue;
                    nArray[i + 1] = 65535;
                    ++i;
                    continue;
                }
                nArray[i] = 0;
                this.put(n3, -1);
                if (cArray2 == null) {
                    cArray2 = new char[cArray.length];
                    nArray2 = new int[cArray.length];
                }
                cArray2[n4] = cArray[i];
                nArray2[n4] = i++;
                if (n3 >= 65536) {
                    cArray2[++n4] = cArray[i];
                }
                ++n4;
            }
            if (n4 == 0) {
                return;
            }
            int[] nArray3 = new int[n4];
            CCharToGlyphMapper.nativeCharsToGlyphs(CCharToGlyphMapper.this.fFont.getNativeFontPtr(), n4, cArray2, nArray3);
            for (n3 = 0; n3 < n4; ++n3) {
                char c;
                n2 = nArray2[n3];
                void var10_11 = cArray2[n3];
                if (var10_11 >= 55296 && var10_11 <= 56319 && n3 < n4 - '\u0001' && (c = cArray[n3 + 1]) >= '\udc00' && c <= '\udfff') {
                    var10_11 = (var10_11 - 55296) * 1024 + c - 56320 + 65536;
                }
                nArray[n2] = nArray3[n3];
                this.put((int)var10_11, nArray[n2]);
                if (var10_11 < 65536) continue;
                ++n3;
                nArray[n2 + 1] = 65535;
            }
        }

        private class SparseBitShiftingTwoLayerArray {
            final int[][] cache;
            final int shift;
            final int secondLayerLength;

            public SparseBitShiftingTwoLayerArray(int n, int n2) {
                this.shift = n2;
                this.cache = new int[1 << n2][];
                this.secondLayerLength = n >> n2;
            }

            public int get(int n) {
                int n2 = n >> this.shift;
                int[] nArray = this.cache[n2];
                if (nArray == null) {
                    return 0;
                }
                return nArray[n - n2 * (1 << this.shift)];
            }

            public void put(int n, int n2) {
                int n3 = n >> this.shift;
                int[] nArray = this.cache[n3];
                if (nArray == null) {
                    nArray = new int[this.secondLayerLength];
                    this.cache[n3] = nArray;
                }
                nArray[n - n3 * (1 << this.shift)] = n2;
            }
        }
    }
}

