/***************************************************************************
 *                                                                         *
 *                  (begin: Feb 20 2003)                                   *
 *                                                                         *
 *   Parallel IQPNNI - Important Quartet Puzzle with NNI                   *
 *                                                                         *
 *   Copyright (C) 2005 by Le Sy Vinh, Bui Quang Minh, Arndt von Haeseler  *
 *   Copyright (C) 2003-2004 by Le Sy Vinh, Arndt von Haeseler             *
 *   {vinh,minh}@cs.uni-duesseldorf.de                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef TREELS_H
#define TREELS_H

#include "vec.h"
#include "urtree.h"

class TreeLs {
public :

	//the constructor function
	TreeLs ();


	//clean all content of this quartet puzzle tree list
	void clean ();

	/*it return 0, if there is not any the same Tree before
	            1, otherwise */
	int find (UrTree &tree);

	int getSize ();
	//the number of quartet puzzle trees
	int nTree_;

	//the list of all quartet puzzle trees up to now
	typedef UrTree DUrTree;
	Vec<DUrTree> items_;

	int findRank (UrTree &tree);

	//add the input tree into this list
	void operator += (UrTree &tree);


	//return items_[index]
	UrTree & operator [] (const int index);

	//set the limit for this list
	void setLimit (int limit);

	//release all memory of this class
	void release ();

	//the destructor function
	virtual ~TreeLs ();
};

#endif
