//
// C++ Implementation: rtrev
//
// Description: 
//
//
// Author: Le Sy Vinh, Bui Quang Minh <minh@cs.uni-duesseldorf.de>, (C) 2006
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "constant.h"
#include "rtrev.h"
#include "dvec20.h"
#include "dmat20.h"

/*
 * rtREV model of amino acid evolution
 * Dimmic et al. (2001)
 */
void RtREV::getData (DMat20 &q, DVec20 &f) {
	if (isMasterProc())
		std::cout <<"Using rtREV model" << std::endl;
	/* rtRev */
	q[ 0][ 0] =   0; q[ 1][ 0] =  34; q[ 2][ 0] =  51; q[ 3][ 0] =  10; q[ 4][ 0] = 439;
	q[ 5][ 0] =  32; q[ 6][ 0] =  81; q[ 7][ 0] = 135; q[ 8][ 0] =  30; q[ 9][ 0] =   1;
	q[10][ 0] =  45; q[11][ 0] =  38; q[12][ 0] = 235; q[13][ 0] =   1; q[14][ 0] =  97;
	q[15][ 0] = 460; q[16][ 0] = 258; q[17][ 0] =   5; q[18][ 0] =  55; q[19][ 0] = 197;

	q[ 0][ 1] =  34; q[ 1][ 1] =   0; q[ 2][ 1] =  35; q[ 3][ 1] =  30; q[ 4][ 1] =  92;
	q[ 5][ 1] = 221; q[ 6][ 1] =  10; q[ 7][ 1] =  41; q[ 8][ 1] =  90; q[ 9][ 1] =  24;
	q[10][ 1] =  18; q[11][ 1] = 593; q[12][ 1] =  57; q[13][ 1] =   7; q[14][ 1] =  24;
	q[15][ 1] = 102; q[16][ 1] =  64; q[17][ 1] =  13; q[18][ 1] =  47; q[19][ 1] =  29;

	q[ 0][ 2] =  51; q[ 1][ 2] =  35; q[ 2][ 2] =   0; q[ 3][ 2] = 384; q[ 4][ 2] = 128;
	q[ 5][ 2] = 236; q[ 6][ 2] =  79; q[ 7][ 2] =  94; q[ 8][ 2] = 320; q[ 9][ 2] =  35;
	q[10][ 2] =  15; q[11][ 2] = 123; q[12][ 2] =   1; q[13][ 2] =  49; q[14][ 2] =  33;
	q[15][ 2] = 294; q[16][ 2] = 148; q[17][ 2] =  16; q[18][ 2] =  28; q[19][ 2] =  21;

	q[ 0][ 3] =  10; q[ 1][ 3] =  30; q[ 2][ 3] = 384; q[ 3][ 3] =   0; q[ 4][ 3] =   1;
	q[ 5][ 3] =  78; q[ 6][ 3] = 542; q[ 7][ 3] =  61; q[ 8][ 3] =  91; q[ 9][ 3] =   1;
	q[10][ 3] =   5; q[11][ 3] =  20; q[12][ 3] =   1; q[13][ 3] =   1; q[14][ 3] =  55;
	q[15][ 3] = 136; q[16][ 3] =  55; q[17][ 3] =   1; q[18][ 3] =   1; q[19][ 3] =   6;

	q[ 0][ 4] = 439; q[ 1][ 4] =  92; q[ 2][ 4] = 128; q[ 3][ 4] =   1; q[ 4][ 4] =   0;
	q[ 5][ 4] =  70; q[ 6][ 4] =   1; q[ 7][ 4] =  48; q[ 8][ 4] = 124; q[ 9][ 4] = 104;
	q[10][ 4] = 110; q[11][ 4] =  16; q[12][ 4] = 156; q[13][ 4] =  70; q[14][ 4] =   1;
	q[15][ 4] =  75; q[16][ 4] = 117; q[17][ 4] =  55; q[18][ 4] = 131; q[19][ 4] = 295;

	q[ 0][ 5] =  32; q[ 1][ 5] = 221; q[ 2][ 5] = 236; q[ 3][ 5] =  78; q[ 4][ 5] =  70;
	q[ 5][ 5] =   0; q[ 6][ 5] = 372; q[ 7][ 5] =  18; q[ 8][ 5] = 387; q[ 9][ 5] =  33;
	q[10][ 5] =  54; q[11][ 5] = 309; q[12][ 5] = 158; q[13][ 5] =   1; q[14][ 5] =  68;
	q[15][ 5] = 225; q[16][ 5] = 146; q[17][ 5] =  10; q[18][ 5] =  45; q[19][ 5] =  36;

	q[ 0][ 6] =  81; q[ 1][ 6] =  10; q[ 2][ 6] =  79; q[ 3][ 6] = 542; q[ 4][ 6] =   1;
	q[ 5][ 6] = 372; q[ 6][ 6] =   0; q[ 7][ 6] =  70; q[ 8][ 6] =  34; q[ 9][ 6] =   1;
	q[10][ 6] =  21; q[11][ 6] = 141; q[12][ 6] =   1; q[13][ 6] =   1; q[14][ 6] =  52;
	q[15][ 6] =  95; q[16][ 6] =  82; q[17][ 6] =  17; q[18][ 6] =   1; q[19][ 6] =  35;

	q[ 0][ 7] = 135; q[ 1][ 7] =  41; q[ 2][ 7] =  94; q[ 3][ 7] =  61; q[ 4][ 7] =  48;
	q[ 5][ 7] =  18; q[ 6][ 7] =  70; q[ 7][ 7] =   0; q[ 8][ 7] =  68; q[ 9][ 7] =   1;
	q[10][ 7] =   3; q[11][ 7] =  30; q[12][ 7] =  37; q[13][ 7] =   7; q[14][ 7] =  17;
	q[15][ 7] = 152; q[16][ 7] =   7; q[17][ 7] =  23; q[18][ 7] =  21; q[19][ 7] =   3;

	q[ 0][ 8] =  30; q[ 1][ 8] =  90; q[ 2][ 8] = 320; q[ 3][ 8] =  91; q[ 4][ 8] = 124;
	q[ 5][ 8] = 387; q[ 6][ 8] =  34; q[ 7][ 8] =  68; q[ 8][ 8] =   0; q[ 9][ 8] =  34;
	q[10][ 8] =  51; q[11][ 8] =  76; q[12][ 8] = 116; q[13][ 8] = 141; q[14][ 8] =  44;
	q[15][ 8] = 183; q[16][ 8] =  49; q[17][ 8] =  48; q[18][ 8] = 307; q[19][ 8] =   1;

	q[ 0][ 9] =   1; q[ 1][ 9] =  24; q[ 2][ 9] =  35; q[ 3][ 9] =   1; q[ 4][ 9] = 104;
	q[ 5][ 9] =  33; q[ 6][ 9] =   1; q[ 7][ 9] =   1; q[ 8][ 9] =  34; q[ 9][ 9] =   0;
	q[10][ 9] = 385; q[11][ 9] =  34; q[12][ 9] = 375; q[13][ 9] =  64; q[14][ 9] =  10;
	q[15][ 9] =   4; q[16][ 9] =  72; q[17][ 9] =  39; q[18][ 9] =  26; q[19][ 9] =1048;

	q[ 0][10] =  45; q[ 1][10] =  18; q[ 2][10] =  15; q[ 3][10] =   5; q[ 4][10] = 110;
	q[ 5][10] =  54; q[ 6][10] =  21; q[ 7][10] =   3; q[ 8][10] =  51; q[ 9][10] = 385;
	q[10][10] =   0; q[11][10] =  23; q[12][10] = 581; q[13][10] = 179; q[14][10] =  22;
	q[15][10] =  24; q[16][10] =  25; q[17][10] =  47; q[18][10] =  64; q[19][10] = 112;

	q[ 0][11] =  38; q[ 1][11] = 593; q[ 2][11] = 123; q[ 3][11] =  20; q[ 4][11] =  16;
	q[ 5][11] = 309; q[ 6][11] = 141; q[ 7][11] =  30; q[ 8][11] =  76; q[ 9][11] =  34;
	q[10][11] =  23; q[11][11] =   0; q[12][11] = 134; q[13][11] =  14; q[14][11] =  43;
	q[15][11] =  77; q[16][11] = 110; q[17][11] =   6; q[18][11] =   1; q[19][11] =  19;

	q[ 0][12] = 235; q[ 1][12] =  57; q[ 2][12] =   1; q[ 3][12] =   1; q[ 4][12] = 156;
	q[ 5][12] = 158; q[ 6][12] =   1; q[ 7][12] =  37; q[ 8][12] = 116; q[ 9][12] = 375;
	q[10][12] = 581; q[11][12] = 134; q[12][12] =   0; q[13][12] = 247; q[14][12] =   1;
	q[15][12] =   1; q[16][12] = 131; q[17][12] = 111; q[18][12] =  74; q[19][12] = 236;

	q[ 0][13] =   1; q[ 1][13] =   7; q[ 2][13] =  49; q[ 3][13] =   1; q[ 4][13] =  70;
	q[ 5][13] =   1; q[ 6][13] =   1; q[ 7][13] =   7; q[ 8][13] = 141; q[ 9][13] =  64;
	q[10][13] = 179; q[11][13] =  14; q[12][13] = 247; q[13][13] =   0; q[14][13] =  11;
	q[15][13] =  20; q[16][13] =  69; q[17][13] = 182; q[18][13] =1017; q[19][13] =  92;

	q[ 0][14] =  97; q[ 1][14] =  24; q[ 2][14] =  33; q[ 3][14] =  55; q[ 4][14] =   1;
	q[ 5][14] =  68; q[ 6][14] =  52; q[ 7][14] =  17; q[ 8][14] =  44; q[ 9][14] =  10;
	q[10][14] =  22; q[11][14] =  43; q[12][14] =   1; q[13][14] =  11; q[14][14] =   0;
	q[15][14] = 134; q[16][14] =  62; q[17][14] =   9; q[18][14] =  14; q[19][14] =  25;

	q[ 0][15] = 460; q[ 1][15] = 102; q[ 2][15] = 294; q[ 3][15] = 136; q[ 4][15] =  75;
	q[ 5][15] = 225; q[ 6][15] =  95; q[ 7][15] = 152; q[ 8][15] = 183; q[ 9][15] =   4;
	q[10][15] =  24; q[11][15] =  77; q[12][15] =   1; q[13][15] =  20; q[14][15] = 134;
	q[15][15] =   0; q[16][15] = 671; q[17][15] =  14; q[18][15] =  31; q[19][15] =  39;

	q[ 0][16] = 258; q[ 1][16] =  64; q[ 2][16] = 148; q[ 3][16] =  55; q[ 4][16] = 117;
	q[ 5][16] = 146; q[ 6][16] =  82; q[ 7][16] =   7; q[ 8][16] =  49; q[ 9][16] =  72;
	q[10][16] =  25; q[11][16] = 110; q[12][16] = 131; q[13][16] =  69; q[14][16] =  62;
	q[15][16] = 671; q[16][16] =   0; q[17][16] =   1; q[18][16] =  34; q[19][16] = 196;

	q[ 0][17] =   5; q[ 1][17] =  13; q[ 2][17] =  16; q[ 3][17] =   1; q[ 4][17] =  55;
	q[ 5][17] =  10; q[ 6][17] =  17; q[ 7][17] =  23; q[ 8][17] =  48; q[ 9][17] =  39;
	q[10][17] =  47; q[11][17] =   6; q[12][17] = 111; q[13][17] = 182; q[14][17] =   9;
	q[15][17] =  14; q[16][17] =   1; q[17][17] =   0; q[18][17] = 176; q[19][17] =  26;

	q[ 0][18] =  55; q[ 1][18] =  47; q[ 2][18] =  28; q[ 3][18] =   1; q[ 4][18] = 131;
	q[ 5][18] =  45; q[ 6][18] =   1; q[ 7][18] =  21; q[ 8][18] = 307; q[ 9][18] =  26;
	q[10][18] =  64; q[11][18] =   1; q[12][18] =  74; q[13][18] =1017; q[14][18] =  14;
	q[15][18] =  31; q[16][18] =  34; q[17][18] = 176; q[18][18] =   0; q[19][18] =  59;

	q[ 0][19] = 197; q[ 1][19] =  29; q[ 2][19] =  21; q[ 3][19] =   6; q[ 4][19] = 295;
	q[ 5][19] =  36; q[ 6][19] =  35; q[ 7][19] =   3; q[ 8][19] =   1; q[ 9][19] =1048;
	q[10][19] = 112; q[11][19] =  19; q[12][19] = 236; q[13][19] =  92; q[14][19] =  25;
	q[15][19] =  39; q[16][19] = 196; q[17][19] =  26; q[18][19] =  59; q[19][19] =   0;

	f[ 0] = 0.0646;
	f[ 1] = 0.0453;
	f[ 2] = 0.0376;
	f[ 3] = 0.0422;
	f[ 4] = 0.0114;
	f[ 5] = 0.0606;
	f[ 6] = 0.0607;
	f[ 7] = 0.0639;
	f[ 8] = 0.0273;
	f[ 9] = 0.0679;
	f[10] = 0.1018;
	f[11] = 0.0751;
	f[12] = 0.0150;
	f[13] = 0.0287;
	f[14] = 0.0681;
	f[15] = 0.0488;
	f[16] = 0.0622;
	f[17] = 0.0251;
	f[18] = 0.0318;
	f[19] = 0.0619;

}
