/***************************************************************************
 *                                                                         *
 *                  (begin: Feb 20 2003)                                   *
 *                                                                         *
 *   Parallel IQPNNI - Important Quartet Puzzle with NNI                   *
 *                                                                         *
 *   Copyright (C) 2005 by Le Sy Vinh, Bui Quang Minh, Arndt von Haeseler  *
 *   Copyright (C) 2003-2004 by Le Sy Vinh, Arndt von Haeseler             *
 *   {vinh,minh}@cs.uni-duesseldorf.de                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef PTN_H
#define PTN_H

/*the discription of this ptn class. The content of the ptn class is to get from the Alingment class */
#include "vec.h"

class Ptn {
public:
	//the constructor
	Ptn ();

	//set limit for this ptn. Thus, set the maximum number of nucleotides or amino acids of this pattern
	void setLimit (const int limit);

	//set the exact number of nucleotides or amino acids of this pattern
	void setSize (const int limit);

	//set siteNo for this ptn
	void setSite (const int siteNo);

	//get the siteNo of this ptn
	int getSite ();

	//set the number of sites which have the same ptn to this one
	void setWeight (const int weight);

	//get the number of sites which have the same ptn to this one
	int getWeight ();

	//some ways to get the content of this ptn. Return the content of this ptn
	Vec<char> &getItem ();

	//return items_[index]
	char getItem(const int index);

	//set the content of this ptn
	void set (Vec<char> &items);

	//overload == operator, check whether or not the input ptn is identical to this ptn
	int operator == (Ptn &ptn);

	//overload +=
	void operator += (char base);

	//weight_ = weight_ + increment
	void addWeight (const int incWeight);

	//overload operator =
	void operator = (Ptn &ptn);

	//overload operator []
	char &operator [] (const int index);

	/** 
		determine if the pattern is constant. update the is_const variable.
	*/
	void computeConst();

	//--------------------------------------------------------------------
	//write all information of this ptn
	template <class Tout>
	Tout &write(Tout &out) {
		items_.writeItem (out) << " : " << weight_ << endl;
		return out;
	}

	//clean all remember flags of this class
	void clean ();

	//release all memmory for this class
	void release ();

	//the destructor
	virtual ~Ptn ();

	//the identification of this ptns
	int siteNo_;

	//the content of ptn
	Vec<char> items_;

	//the number of sites in the alignment having the same ptn
	int weight_;

	bool is_const;
};
#endif
