/***************************************************************************
 *                                                                         *
 *                  (begin: Feb 20 2003)                                   *
 *                                                                         *
 *   Parallel IQPNNI - Important Quartet Puzzle with NNI                   *
 *                                                                         *
 *   Copyright (C) 2005 by Le Sy Vinh, Bui Quang Minh, Arndt von Haeseler  *
 *   Copyright (C) 2003-2004 by Le Sy Vinh, Arndt von Haeseler             *
 *   {vinh,minh}@cs.uni-duesseldorf.de                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef MAT_H
#define MAT_H

#include "vec.h"
#include "utl.h"
#include "constant.h"

using namespace std;

//this class is a description for matrix
template <class T>
class Mat {
public:

	typedef Vec<T> TVec;

	//the constructor
	Mat () {
		nRow_ = 0;
		nCol_ = 0;
	}

	//--------------------------------------------------------------------
	//the constructor
	Mat (int nRow, int nCol) {
		setLimit(nRow, nCol);
	}

	//--------------------------------------------------------------------
	/*set the limit of rows and cols for this matrix. Delete all
	old information of this matrix of the new size is not the same the old size
	*/
	void setLimit (int nRow, int nCol) {
		//do not need reSetLimit again
		if ( (nRow_ == nRow) && (nCol_ == nCol) )
			return;

		release ();

		nRow_ = nRow;
		nCol_ = nCol;
		items_.set (nRow_, nRow_);

		for (int row_ = 0; row_ < nRow_; row_ ++)
			items_[row_].set (nCol_, nCol_);
	}

	//--------------------------------------------------------------------
	//return the number of rows and number of columns of this matrix
	void get (int &nRow, int &nCol) {
		nRow = nRow_;
		nCol = nCol_;
	}


	//--------------------------------------------------------------------
	//return the number of rows of this matrix
	int getNRow () {
		return nRow_;
	}

	//--------------------------------------------------------------------
	//return the number of columns of this matrix
	int getNCol () {
		return nCol_;
	}

	//--------------------------------------------------------------------
	/*
	copy all data from mat into this matrix, mat is passed by reference
	*/
	void copyRef (Mat<T> &mat) {
		if ( nRow_ != mat.getNRow () || nCol_ != mat.getNCol () )
			Utl::announceError (BAD_ASSIGNMENT);

		for (int row_ = 0; row_ < nRow_; row_ ++)
			items_[row_] = mat[row_];
	}

	//--------------------------------------------------------------------
	/*
	copy all data from mat into this matrix, mat is passed by value
	*/
	void copyVal (Mat<T> mat) {
		copyRef (mat);
	}

	//--------------------------------------------------------------------
	//overload operator =
	void operator = (Mat<T> &mat) {
		copyRef (mat);
	}

	//--------------------------------------------------------------------
	//return the row index of this matrix
	Vec<T> &operator [] (int index) {
		return items_[index];
	}


	//--------------------------------------------------------------------
	//release the memory of this class
	void release () {
		if (nRow_ > 0) {
			nMat_ --;
			for (int count_ = 0; count_ < items_.getLimit (); count_ ++)
				items_[count_].release ();
			items_.release ();
			nRow_ = 0;
		}
	}

	//--------------------------------------------------------------------
	//destructor
	virtual ~Mat () {
		//  std::cout << "destructor of mat class " << endl;
		release ();
	}

	//the total number mats in the memory
	static int nMat_;

	/***********************************************************************
	***********************************************************************
	***********************************************************************
	***********************************************************************/
private :
	//declare memory for this matrix
	Vec<TVec> items_;

	//the number of rows of this matrix
	int nRow_;
	//the number of columns of this matrix
	int nCol_;

}
; //end of matrix class

template <class T>
int Mat<T>::nMat_ = 0;
#endif
