/***************************************************************************
 *                                                                         *
 *                                                                         *
 *                                                                         *
 *   Parallel IQPNNI - Important Quartet Puzzle with NNI                   *
 *                                                                         *
 *   Copyright (C) 2005 by Le Sy Vinh, Bui Quang Minh, Arndt von Haeseler  *
 *   Copyright (C) 2003-2004 by Le Sy Vinh, Arndt von Haeseler             *
 *   {vinh,minh}@cs.uni-duesseldorf.de                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef CODONYN98_H
#define CODONYN98_H

#include "codonmodel.h"

/**
@author Le Sy Vinh, Bui Quang Minh
*/
class CodonYN98 : public CodonModel
{
public:
    CodonYN98();

	/**
		calculate the rate parameters (not rate matrix)
	*/
	virtual void calcRateParameters();

	/**
		compute negative log likelihood
	*/
	virtual double cmpNegLogLi (double value);
	
	/**
		check of range of parameters
	*/
	//virtual bool checkRange(double x[]);
	
	/**
		the target function which needs to be optimized
		@param x the input vector x
		@return the function value at x
	*/
	virtual double targetFunk(double x[]);


	/**
		return the number of dimensions
	*/
	virtual int getNDim();
	
	/**
		pack the data to the vector x
	*/
	virtual void packData( double x[], double lower[], double upper[], bool bound_check[]);
	
	/**
		unpack data from vector x
	*/
	virtual void unpackData(double x[]);
	
	/**
		optimize parameters
	*/
	virtual bool optPam ();	

	/**
		@return Nonsynonymous/Synonymous Ratio
	*/
	double getNsSyRatio();
			
	/**
		set Nonsynonymous/Synonymous Ratio
	*/
	void setNsSyRatio(double ratio);
	
    ~CodonYN98();

protected:
	/**
		Nonsynonymous/Synonymous Ratio
	*/
	double nsSyRatio; 
	
};

#endif
