/*
 * Decompiled with CFR 0.152.
 */
package com.ca.directory.jxplorer;

import com.ca.commons.cbutil.CBSystemProperties;
import com.ca.commons.cbutil.CBUtility;
import com.ca.commons.naming.DXAttribute;
import com.ca.commons.naming.LdifUtility;
import com.ca.commons.security.cert.CertViewer;
import com.ca.directory.BuildNumber;
import com.ca.directory.jxplorer.JXplorer;
import com.ca.directory.jxplorer.broker.JNDIDataBroker;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import javax.swing.UIManager;

public class JXConfig {
    public static Properties myProperties;
    public static String propertyFile;
    public static String localDir;
    public static final String CLIENT_TYPE_PROPERTY = "keystoreType.clientcerts";
    public static final String CA_TYPE_PROPERTY = "keystoreType.cacerts";
    public static final String CLIENT_PATH_PROPERTY = "option.ssl.clientcerts";
    public static final String CA_PATH_PROPERTY = "option.ssl.cacerts";
    public static final String ALLOW_CONNECTION_CERT_IMPORT = "option.ssl.import.cert.during.connection";
    public static final String LANGUAGE_OVERRIDE = "force.locale";
    public static final String LANGUAGE_OVERRIDE_DEFAULT = "default";
    private static Logger log;
    public static String version;
    public static boolean debug;
    public static int debugLevel;
    public static boolean debugSSL;

    public static String getProperty(String key) {
        if (System.getProperty(key) != null) {
            return System.getProperty(key);
        }
        if (myProperties != null && myProperties.containsKey(key)) {
            return myProperties.getProperty(key);
        }
        return null;
    }

    public static int getIntProperty(String key) {
        return JXConfig.getIntProperty(key, -1);
    }

    public static int getIntProperty(String key, int defaultValue) {
        try {
            String val = JXConfig.getProperty(key);
            return val == null ? defaultValue : Integer.parseInt(val);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static String getProperty(String key, String defaultValue) {
        if (myProperties == null) {
            return defaultValue;
        }
        return myProperties.getProperty(key, defaultValue);
    }

    public static Properties getMyProperties() {
        return myProperties;
    }

    public static void setProperty(String key, String value) {
        if (key != null) {
            myProperties.setProperty(key, value);
        }
    }

    public static void setProperty(String key, String value, String comment) {
        if (key != null) {
            myProperties.setProperty(key, value);
        }
        if (comment != null && comment.length() > 0) {
            myProperties.put(key + ".comment", comment);
        }
    }

    public static String setDefaultProperty(String key, String value) {
        if (System.getProperty(key) != null) {
            return System.getProperty(key);
        }
        if (myProperties.containsKey(key)) {
            return myProperties.getProperty(key);
        }
        myProperties.setProperty(key, value);
        return value;
    }

    public static String setDefaultProperty(String key, String value, String comment) {
        if (comment != null && comment.length() > 0) {
            myProperties.put(key + ".comment", comment);
        }
        return JXConfig.setDefaultProperty(key, value);
    }

    public static void setupProperties() {
        JXConfig.setupProperties(null);
    }

    public static String getLocalDirectory() {
        return System.getProperty("user.dir") + File.separator;
    }

    public static String getConfigDirectory() {
        String configDir = CBUtility.getConfigDirectory(JXplorer.APPLICATION_NAME);
        log.info("JX using configDirectory: " + configDir);
        return configDir;
    }

    public static void setupProperties(Properties suppliedProperties) {
        localDir = JXConfig.getLocalDirectory();
        String configDir = JXConfig.getConfigDirectory();
        if (suppliedProperties == null) {
            String configFileName = "jxconfig.txt";
            propertyFile = CBUtility.getPropertyConfigPath(JXplorer.APPLICATION_NAME, configFileName);
            myProperties = CBUtility.readPropertyFile(propertyFile);
        } else {
            myProperties = suppliedProperties;
        }
        JXConfig.setDefaultProperty("url.defaultdirectory", "localhost", "default for empty connection screen GUI - rarely used");
        JXConfig.setDefaultProperty("url.defaultdirectory.port", "389", "default for empty connection screen GUI - rarely used");
        JXConfig.setDefaultProperty("url.defaultadmin", "localhost", "default value for a specific 3rd party plug in; rarely used");
        JXConfig.setDefaultProperty("url.defaultadminport", "3389", "default value for a specific 3rd party plug in; rarely used");
        JXConfig.setDefaultProperty("baseAdminDN", "cn=Management System", "default value for a specific 3rd party plug in; rarely used");
        JXConfig.setProperty("dir.comment", "this sets the directories that JXplorer reads its static resources from.");
        JXConfig.setDefaultLocationProperty("dir.local", localDir);
        JXConfig.setDefaultLocationProperty("dir.help", localDir + "help" + File.separator);
        JXConfig.setDefaultLocationProperty("dir.plugins", localDir + "plugins" + File.separator);
        JXConfig.setDefaultProperty("width", "1000", "set by client GUI - don't change");
        JXConfig.setDefaultProperty("height", "700", "set by client GUI - don't change");
        JXConfig.setDefaultProperty("baseDN", "c=au", "the default base DN for an empty connection - rarely used");
        JXConfig.setDefaultProperty("ldapversion", "3", "set by client GUI - don't change");
        JXConfig.setDefaultProperty(".level", "WARNING", "(java loggin variable) - allowable values are 'OFF', 'SEVERE', 'WARNING', 'INFO', 'FINE', 'FINER', 'FINEST' and 'ALL'");
        JXConfig.setDefaultProperty("com.ca.level", "WARNING", " (java loggin variable) partial logging is also available.  Be warned that the Sun logging system is a very buggy partial reimplementation of log4j, and doesn't seem to do inheritance well.");
        JXConfig.setDefaultProperty(LANGUAGE_OVERRIDE, LANGUAGE_OVERRIDE_DEFAULT, "use this to set local language detection ('default') or force the use of a particular language. (e.g. 'en' / 'en.US' / 'de' / 'zh.CN' / 'zh.TW'");
        JXConfig.setDefaultProperty("handlers", "java.util.logging.ConsoleHandler", "(java logging variable) This sets the log level for console reporting");
        JXConfig.setDefaultProperty("java.util.logging.ConsoleHandler.level", "ALL", "(java logging variable) This sets the log level for console reporting");
        JXConfig.setDefaultProperty("java.util.logging.ConsoleHandler.formatter", "java.util.logging.SimpleFormatter", "(java logging variable) This sets the built in formatter to use for console reporting");
        JXConfig.setDefaultProperty("java.util.logging.FileHandler.level", "ALL", "(java loggin variable) This sets the log level for log file reporting");
        JXConfig.setDefaultProperty("java.util.logging.FileHandler.pattern", "JX%u.log", "(java loggin variable) The name of the log file (see java.util.logging.FileHandler java doc)");
        JXConfig.setDefaultProperty("java.util.logging.FileHandler.formatter", "java.util.logging.SimpleFormatter", "(java loggin variable) This sets the built in formatter to use for file reporting");
        JXConfig.setDefaultProperty("null.entry.editor", "defaulteditor", "the editor displayed for null entries is pluggable and can be set to a custom java class");
        JXConfig.setDefaultProperty("plugins.ignoreUniqueness", "false", "whether to allow multiple plugins for the same object class: 'true' or 'false");
        JXConfig.setDefaultProperty("option.ignoreSchemaOnSubmission", "false", "Skip client side schema checks; useful if JXplorer is getting confused or the schema is inconsistent");
        JXConfig.setDefaultProperty("option.ldap.timeout", "0", "the maximum time to allow a query to run before cancelling - '0' = 'as long as the server allows'");
        JXConfig.setDefaultProperty("option.ldap.limit", "0", "The maximum number of entries to return - '0' = 'all the server allows'");
        JXConfig.setDefaultProperty("option.ldap.referral", "ignore", "this is a jdni variable determining how referrals are handled: 'ignore','follow' or 'throw'");
        JXConfig.setDefaultProperty("option.ldap.pagedResults", "false", "set this to true to use paged results for large data sets, if your directory supports it (e.g AD)");
        JXConfig.setDefaultProperty("option.ldap.pageSize", "-1", "Sets the page size for paged results, if paged results are used.  (Generally 1000 is a good size)");
        JXConfig.setDefaultProperty("option.ldap.browseAliasBehaviour", "finding", "jndi variable setting how aliases are handled while browsing: 'always','never','finding','searching'");
        JXConfig.setDefaultProperty("option.ldap.searchAliasBehaviour", "searching", "jndi variable setting how aliases are handled while searching: 'always','never','finding','searching'");
        JXConfig.setDefaultProperty("option.confirmTableEditorUpdates", "false", "whether the user is prompted before updates; usually set by GUI");
        JXConfig.setDefaultProperty("option.url.handling", "JXplorer", "override URL handling to launch JXplorer rather than default browser");
        JXConfig.setDefaultProperty("option.ldap.sendVerboseBinarySuffix", "false", "some directories require ';binary' to be explicitly appended to binary attribute names: 'true' or 'false' (default)");
        JXConfig.setDefaultProperty("option.ldap.useRFC4523BinarySuffix", "true", "append ';binary' to certificate attributes as per RFC 4453: 'true' (default) or 'false'");
        JXConfig.setDefaultProperty("option.drag.and.drop", "true", "set to 'false' to disable drag and drop in the left hand tree view");
        JXConfig.setDefaultProperty("jxplorer.cache.passwords", "true", "whether JX should keep a (run time only) cache of passwords for reuse and reconnection");
        JXConfig.setDefaultProperty("mask.raw.passwords", "true", "whether to mask userPassword in the entry password editor");
        JXConfig.setDefaultProperty("sort.by.naming.attribute", "false", "if true, this sorts entries in the tree editor by naming attribute first, then by attribute value");
        if ("true".equals(JXConfig.getProperty("option.ldap.sendVerboseBinarySuffix"))) {
            log.fine("using verbose binary suffix ';binary'");
            DXAttribute.setVerboseBinary(true);
        }
        if ("false".equals(JXConfig.getProperty("option.ldap.useRFC4523BinarySuffix"))) {
            log.fine("using binary suffix ';binary'");
            DXAttribute.setRFC4523BinaryHandling(false);
        }
        JXConfig.setDefaultProperty(CA_PATH_PROPERTY, configDir + "security" + File.separator + "cacerts");
        JXConfig.setDefaultProperty(CLIENT_PATH_PROPERTY, configDir + "security" + File.separator + "clientcerts");
        JXConfig.setDefaultProperty(CLIENT_TYPE_PROPERTY, "JKS");
        JXConfig.setDefaultProperty(CA_TYPE_PROPERTY, "JKS");
        JXConfig.setDefaultProperty(ALLOW_CONNECTION_CERT_IMPORT, "true");
        System.setProperty(ALLOW_CONNECTION_CERT_IMPORT, JXConfig.getProperty(ALLOW_CONNECTION_CERT_IMPORT));
        JXConfig.setDefaultProperty("securityProvider", "com.sun.net.ssl.internal.ssl.Provider");
        JXConfig.setProperty("securityProvider.comment", "the security provider can be changed, and three more can be added by creating 'securityProperty0', 'securityProperty1' and 'securityProperty2'.");
        JXConfig.setDefaultProperty("ldap.sslsocketfactory", "com.ca.commons.jndi.JndiSocketFactory");
        JXConfig.setProperty("ldap.sslsocketfactory.comment", "This is the built in ssl factory - it can be changed if required.");
        JXConfig.setDefaultProperty("option.ssl.protocol", "any", "Force JXplorer to only use some specific SSL protocols, rather than negotiating a normal SSL connection. e.g. just 'TLS' or 'TLSv1' or 'TLSv1,TLSv1.1' (or 'any' to negotiate)");
        String ssl = myProperties.getProperty("option.ssl.protocol");
        if (ssl != null) {
            System.setProperty("option.ssl.protocol", ssl);
        }
        JXConfig.setDefaultProperty("option.ssl.debug", "true", "print out SSL debug messages");
        JXConfig.setDefaultProperty("gui.lookandfeel", UIManager.getSystemLookAndFeelClassName());
        JXConfig.setDefaultProperty("gui.lookandfeel.comment", "Can set to com.sun.java.swing.plaf.mac.MacLookAndFeel for OSX");
        JXConfig.setDefaultProperty("last.search.filter", LANGUAGE_OVERRIDE_DEFAULT);
        JXConfig.setDefaultProperty("getSystemEnvironment.comment", "Set this to true if you wish to add the system environment properties to the JX list (e.g. if you are setting JX properties via system variables)");
        JXConfig.setDefaultProperty("getSystemEnvironment", "false");
        if (JXConfig.getProperty("getSystemEnvironment").equalsIgnoreCase("true")) {
            CBSystemProperties.loadSystemProperties();
        }
        CertViewer.setProperties(myProperties);
        CertViewer.setupHelpLink("ssl.view");
        JXConfig.setDefaultProperty("xml.ldif.rfc", "false");
        JXConfig.setDefaultProperty("xml.ldif.rfc.comment", "Experimental support for saving XML in LDIF files in editable form (e.g. not base64 encoded)");
        if ("true".equals(JXConfig.getProperty("xml.ldif.rfc"))) {
            LdifUtility.setSupportXML_LDIF_RFC(true);
        }
        JXConfig.setDefaultProperty("lock.read.only", "false", "if true, this locks the browser into read only mode and no directory modifications can be made");
        if ("true".equals(JXConfig.getProperty("lock.read.only"))) {
            JNDIDataBroker.lockToReadOnlyMode();
        }
        if (propertyFile != null && !new File(propertyFile).exists()) {
            JXConfig.writePropertyFile();
        }
    }

    protected static void setDefaultLocationProperty(String propName, String defaultLocation) {
        File test;
        JXConfig.setDefaultProperty(propName, defaultLocation);
        String newLocation = JXConfig.getProperty(propName);
        if (!newLocation.equals(defaultLocation) && !(test = new File(newLocation)).exists()) {
            log.warning("Uunable to find location '" + newLocation + "' -> reverting to '" + defaultLocation + "'");
            JXConfig.setProperty(propName, defaultLocation);
        }
    }

    public static void writePropertyFile() {
        CBUtility.writePropertyFile(propertyFile, myProperties, new String("# The property file location defaults to where JXplorer is installed\n# - this can be over-ridden with the system property 'jxplorer.config'\n#   with a config directory location, or set to user home using the\n#   flag 'user.home' (e.g. -Djxplorer.config='user.home' on the command line).\n"));
    }

    protected static void setupLogger() {
        log.info("setting up logger");
        try {
            Logger.getLogger("com");
            Logger.getLogger("com.ca");
            Logger.getLogger("com.ca.directory");
            Logger.getLogger("com.ca.directory.jxplorer");
            log = Logger.getLogger(JXplorer.class.getName());
            LogManager logManager = LogManager.getLogManager();
            logManager.reset();
            logManager.readConfiguration(new FileInputStream(propertyFile));
            System.out.println("logging level set from config to: " + CBUtility.getTrueLogLevel(log) + " with " + log.getHandlers().length + " parents=" + log.getUseParentHandlers());
            log.info("Using configuration file: " + propertyFile);
            log.info("logging initialised to global level " + CBUtility.getTrueLogLevel(log));
            Logger swinglog = Logger.getLogger("javax.swing");
            swinglog.setLevel(Level.SEVERE);
            debugSSL = JXConfig.getProperty("option.ssl.debug").equalsIgnoreCase("true");
        }
        catch (IOException e) {
            log.log(Level.SEVERE, "Unable to load log configuration from config file: " + propertyFile, e);
            System.err.println("Unable to load log configuration from config file: " + propertyFile);
            e.printStackTrace();
            JXConfig.setupBackupLogger();
        }
        int currentLogLevel = CBUtility.getTrueLogLevel(log).intValue();
        if (currentLogLevel <= Level.FINE.intValue()) {
            Vector<String> sortedKeys = new Vector<String>();
            Enumeration<Object> baseKeys = myProperties.keys();
            while (baseKeys.hasMoreElements()) {
                String key = (String)baseKeys.nextElement();
                sortedKeys.addElement(key);
            }
            Collections.sort(sortedKeys);
            Enumeration propNames = sortedKeys.elements();
            StringBuffer propertyData = new StringBuffer();
            while (propNames.hasMoreElements()) {
                String propName = (String)propNames.nextElement();
                propertyData.append("property: ").append(propName).append(" = ").append(myProperties.getProperty(propName)).append("\n");
            }
            log.fine("property:\n" + propertyData.toString());
        }
    }

    protected static void setupBackupLogger() {
        Logger mainLogger = LogManager.getLogManager().getLogger("com.ca");
        mainLogger.setLevel(Level.parse(JXConfig.getProperty("java.util.logging.ConsoleHandler.level")));
        ConsoleHandler handler = new ConsoleHandler();
        handler.setLevel(Level.ALL);
        mainLogger.addHandler(handler);
        Logger swinglog = Logger.getLogger("javax.swing");
        swinglog.setLevel(Level.SEVERE);
    }

    static {
        log = Logger.getLogger(JXConfig.class.getName());
        version = BuildNumber.value;
        debug = false;
        debugLevel = 0;
        debugSSL = false;
    }
}

