/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsqlparser.util.deparser;

import net.sf.jsqlparser.expression.ExpressionVisitor;
import net.sf.jsqlparser.statement.select.Limit;
import net.sf.jsqlparser.util.deparser.AbstractDeParser;

public class LimitDeparser
extends AbstractDeParser<Limit> {
    private ExpressionVisitor<StringBuilder> expressionVisitor;

    public LimitDeparser(ExpressionVisitor<StringBuilder> expressionVisitor, StringBuilder buffer) {
        super(buffer);
        this.expressionVisitor = expressionVisitor;
    }

    @Override
    public void deParse(Limit limit) {
        this.builder.append(" LIMIT ");
        if (limit.isLimitNull()) {
            this.builder.append("NULL");
        } else if (limit.isLimitAll()) {
            this.builder.append("ALL");
        } else {
            if (null != limit.getOffset()) {
                limit.getOffset().accept(this.expressionVisitor, null);
                this.builder.append(", ");
            }
            if (null != limit.getRowCount()) {
                limit.getRowCount().accept(this.expressionVisitor, null);
            }
        }
        if (limit.getByExpressions() != null) {
            this.builder.append(" BY ");
            limit.getByExpressions().accept(this.expressionVisitor, null);
        }
    }

    public ExpressionVisitor<StringBuilder> getExpressionVisitor() {
        return this.expressionVisitor;
    }

    public void setExpressionVisitor(ExpressionVisitor<StringBuilder> expressionVisitor) {
        this.expressionVisitor = expressionVisitor;
    }
}

