//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::cell::UnsafeCell;
use core::ffi::*;
use core::marker::{PhantomData, PhantomPinned};
use core::ptr::NonNull;
#[cfg(feature = "objc2")]
use objc2::__framework_prelude::*;

use crate::*;

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cfbinaryheapcomparecontext?language=objc)
#[cfg(feature = "CFBase")]
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct CFBinaryHeapCompareContext {
    pub version: CFIndex,
    pub info: *mut c_void,
    pub retain: Option<unsafe extern "C-unwind" fn(*const c_void) -> *const c_void>,
    pub release: Option<unsafe extern "C-unwind" fn(*const c_void)>,
    pub copyDescription: Option<unsafe extern "C-unwind" fn(*const c_void) -> *const CFString>,
}

#[cfg(all(feature = "CFBase", feature = "objc2"))]
unsafe impl Encode for CFBinaryHeapCompareContext {
    const ENCODING: Encoding = Encoding::Struct(
        "?",
        &[
            <CFIndex>::ENCODING,
            <*mut c_void>::ENCODING,
            <Option<unsafe extern "C-unwind" fn(*const c_void) -> *const c_void>>::ENCODING,
            <Option<unsafe extern "C-unwind" fn(*const c_void)>>::ENCODING,
            <Option<unsafe extern "C-unwind" fn(*const c_void) -> *const CFString>>::ENCODING,
        ],
    );
}

#[cfg(all(feature = "CFBase", feature = "objc2"))]
unsafe impl RefEncode for CFBinaryHeapCompareContext {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// Structure containing the callbacks for values of a CFBinaryHeap.
/// Field: version The version number of the structure type being passed
/// in as a parameter to the CFBinaryHeap creation functions.
/// This structure is version 0.
/// Field: retain The callback used to add a retain for the binary heap
/// on values as they are put into the binary heap.
/// This callback returns the value to use as the value in the
/// binary heap, which is usually the value parameter passed to
/// this callback, but may be a different value if a different
/// value should be added to the binary heap. The binary heap's
/// allocator is passed as the first argument.
/// Field: release The callback used to remove a retain previously added
/// for the binary heap from values as they are removed from
/// the binary heap. The binary heap's allocator is passed as the
/// first argument.
/// Field: copyDescription The callback used to create a descriptive
/// string representation of each value in the binary heap. This
/// is used by the CFCopyDescription() function.
/// Field: compare The callback used to compare values in the binary heap for
/// equality in some operations.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cfbinaryheapcallbacks?language=objc)
#[cfg(feature = "CFBase")]
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct CFBinaryHeapCallBacks {
    pub version: CFIndex,
    pub retain:
        Option<unsafe extern "C-unwind" fn(*const CFAllocator, *const c_void) -> *const c_void>,
    pub release: Option<unsafe extern "C-unwind" fn(*const CFAllocator, *const c_void)>,
    pub copyDescription: Option<unsafe extern "C-unwind" fn(*const c_void) -> *const CFString>,
    pub compare: Option<
        unsafe extern "C-unwind" fn(
            *const c_void,
            *const c_void,
            *mut c_void,
        ) -> CFComparisonResult,
    >,
}

#[cfg(all(feature = "CFBase", feature = "objc2"))]
unsafe impl Encode for CFBinaryHeapCallBacks {
    const ENCODING: Encoding =
        Encoding::Struct(
            "?",
            &[
                <CFIndex>::ENCODING,
                <Option<
                    unsafe extern "C-unwind" fn(*const CFAllocator, *const c_void) -> *const c_void,
                >>::ENCODING,
                <Option<unsafe extern "C-unwind" fn(*const CFAllocator, *const c_void)>>::ENCODING,
                <Option<unsafe extern "C-unwind" fn(*const c_void) -> *const CFString>>::ENCODING,
                <Option<
                    unsafe extern "C-unwind" fn(
                        *const c_void,
                        *const c_void,
                        *mut c_void,
                    ) -> CFComparisonResult,
                >>::ENCODING,
            ],
        );
}

#[cfg(all(feature = "CFBase", feature = "objc2"))]
unsafe impl RefEncode for CFBinaryHeapCallBacks {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

extern "C" {
    /// Predefined CFBinaryHeapCallBacks structure containing a set
    /// of callbacks appropriate for use when the values in a CFBinaryHeap
    /// are all CFString types.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfstringbinaryheapcallbacks?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFStringBinaryHeapCallBacks: CFBinaryHeapCallBacks;
}

/// Type of the callback function used by the apply functions of
/// CFBinaryHeap.
///
/// Parameter `val`: The current value from the binary heap.
///
/// Parameter `context`: The user-defined context parameter given to the apply
/// function.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cfbinaryheapapplierfunction?language=objc)
pub type CFBinaryHeapApplierFunction =
    Option<unsafe extern "C-unwind" fn(*const c_void, *mut c_void)>;

/// This is the type of a reference to CFBinaryHeaps.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cfbinaryheap?language=objc)
#[repr(C)]
pub struct CFBinaryHeap {
    inner: [u8; 0],
    _p: UnsafeCell<PhantomData<(*const UnsafeCell<()>, PhantomPinned)>>,
}

cf_type!(
    #[encoding_name = "__CFBinaryHeap"]
    unsafe impl CFBinaryHeap {}
);

#[cfg(feature = "CFBase")]
unsafe impl ConcreteType for CFBinaryHeap {
    /// Returns the type identifier of all CFBinaryHeap instances.
    #[doc(alias = "CFBinaryHeapGetTypeID")]
    #[inline]
    fn type_id() -> CFTypeID {
        extern "C-unwind" {
            fn CFBinaryHeapGetTypeID() -> CFTypeID;
        }
        unsafe { CFBinaryHeapGetTypeID() }
    }
}

/// Creates a new mutable binary heap with the given values.
///
/// Parameter `allocator`: The CFAllocator which should be used to allocate
/// memory for the binary heap and its storage for values. This
/// parameter may be NULL in which case the current default
/// CFAllocator is used. If this reference is not a valid
/// CFAllocator, the behavior is undefined.
///
/// Parameter `capacity`: A hint about the number of values that will be held
/// by the CFBinaryHeap. Pass 0 for no hint. The implementation may
/// ignore this hint, or may use it to optimize various
/// operations. A heap's actual capacity is only limited by
/// address space and available memory constraints). If this
/// parameter is negative, the behavior is undefined.
///
/// Parameter `callBacks`: A pointer to a CFBinaryHeapCallBacks structure
/// initialized with the callbacks for the binary heap to use on
/// each value in the binary heap. A copy of the contents of the
/// callbacks structure is made, so that a pointer to a structure
/// on the stack can be passed in, or can be reused for multiple
/// binary heap creations. If the version field of this callbacks
/// structure is not one of the defined ones for CFBinaryHeap, the
/// behavior is undefined. The retain field may be NULL, in which
/// case the CFBinaryHeap will do nothing to add a retain to values
/// as they are put into the binary heap. The release field may be
/// NULL, in which case the CFBinaryHeap will do nothing to remove
/// the binary heap's retain (if any) on the values when the
/// heap is destroyed or a key-value pair is removed. If the
/// copyDescription field is NULL, the binary heap will create a
/// simple description for a value. If the equal field is NULL, the
/// binary heap will use pointer equality to test for equality of
/// values. This callbacks parameter itself may be NULL, which is
/// treated as if a valid structure of version 0 with all fields
/// NULL had been passed in. Otherwise,
/// if any of the fields are not valid pointers to functions
/// of the correct type, or this parameter is not a valid
/// pointer to a CFBinaryHeapCallBacks callbacks structure,
/// the behavior is undefined. If any of the values put into the
/// binary heap is not one understood by one of the callback functions
/// the behavior when that callback function is used is undefined.
///
/// Parameter `compareContext`: A pointer to a CFBinaryHeapCompareContext structure.
///
/// Returns: A reference to the new CFBinaryHeap.
#[cfg(feature = "CFBase")]
#[inline]
pub unsafe extern "C-unwind" fn CFBinaryHeapCreate(
    allocator: Option<&CFAllocator>,
    capacity: CFIndex,
    call_backs: *const CFBinaryHeapCallBacks,
    compare_context: *const CFBinaryHeapCompareContext,
) -> Option<CFRetained<CFBinaryHeap>> {
    extern "C-unwind" {
        fn CFBinaryHeapCreate(
            allocator: Option<&CFAllocator>,
            capacity: CFIndex,
            call_backs: *const CFBinaryHeapCallBacks,
            compare_context: *const CFBinaryHeapCompareContext,
        ) -> Option<NonNull<CFBinaryHeap>>;
    }
    let ret = unsafe { CFBinaryHeapCreate(allocator, capacity, call_backs, compare_context) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

/// Creates a new mutable binary heap with the values from the given binary heap.
///
/// Parameter `allocator`: The CFAllocator which should be used to allocate
/// memory for the binary heap and its storage for values. This
/// parameter may be NULL in which case the current default
/// CFAllocator is used. If this reference is not a valid
/// CFAllocator, the behavior is undefined.
///
/// Parameter `capacity`: A hint about the number of values that will be held
/// by the CFBinaryHeap. Pass 0 for no hint. The implementation may
/// ignore this hint, or may use it to optimize various
/// operations. A heap's actual capacity is only limited by
/// address space and available memory constraints).
/// This parameter must be greater than or equal
/// to the count of the heap which is to be copied, or the
/// behavior is undefined. If this parameter is negative, the
/// behavior is undefined.
///
/// Parameter `heap`: The binary heap which is to be copied. The values from the
/// binary heap are copied as pointers into the new binary heap (that is,
/// the values themselves are copied, not that which the values
/// point to, if anything). However, the values are also
/// retained by the new binary heap. The count of the new binary will
/// be the same as the given binary heap. The new binary heap uses the same
/// callbacks as the binary heap to be copied. If this parameter is
/// not a valid CFBinaryHeap, the behavior is undefined.
///
/// Returns: A reference to the new mutable binary heap.
#[cfg(feature = "CFBase")]
#[inline]
pub unsafe extern "C-unwind" fn CFBinaryHeapCreateCopy(
    allocator: Option<&CFAllocator>,
    capacity: CFIndex,
    heap: Option<&CFBinaryHeap>,
) -> Option<CFRetained<CFBinaryHeap>> {
    extern "C-unwind" {
        fn CFBinaryHeapCreateCopy(
            allocator: Option<&CFAllocator>,
            capacity: CFIndex,
            heap: Option<&CFBinaryHeap>,
        ) -> Option<NonNull<CFBinaryHeap>>;
    }
    let ret = unsafe { CFBinaryHeapCreateCopy(allocator, capacity, heap) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

extern "C-unwind" {
    /// Returns the number of values currently in the binary heap.
    ///
    /// Parameter `heap`: The binary heap to be queried. If this parameter is not a valid
    /// CFBinaryHeap, the behavior is undefined.
    ///
    /// Returns: The number of values in the binary heap.
    #[cfg(feature = "CFBase")]
    pub fn CFBinaryHeapGetCount(heap: &CFBinaryHeap) -> CFIndex;
}

extern "C-unwind" {
    /// Counts the number of times the given value occurs in the binary heap.
    ///
    /// Parameter `heap`: The binary heap to be searched. If this parameter is not a
    /// valid CFBinaryHeap, the behavior is undefined.
    ///
    /// Parameter `value`: The value for which to find matches in the binary heap. The
    /// compare() callback provided when the binary heap was created is
    /// used to compare. If the compare() callback was NULL, pointer
    /// equality (in C, ==) is used. If value, or any of the values
    /// in the binary heap, are not understood by the compare() callback,
    /// the behavior is undefined.
    ///
    /// Returns: The number of times the given value occurs in the binary heap.
    #[cfg(feature = "CFBase")]
    pub fn CFBinaryHeapGetCountOfValue(heap: &CFBinaryHeap, value: *const c_void) -> CFIndex;
}

/// Reports whether or not the value is in the binary heap.
///
/// Parameter `heap`: The binary heap to be searched. If this parameter is not a
/// valid CFBinaryHeap, the behavior is undefined.
///
/// Parameter `value`: The value for which to find matches in the binary heap. The
/// compare() callback provided when the binary heap was created is
/// used to compare. If the compare() callback was NULL, pointer
/// equality (in C, ==) is used. If value, or any of the values
/// in the binary heap, are not understood by the compare() callback,
/// the behavior is undefined.
///
/// Returns: true, if the value is in the specified binary heap, otherwise false.
#[inline]
pub unsafe extern "C-unwind" fn CFBinaryHeapContainsValue(
    heap: &CFBinaryHeap,
    value: *const c_void,
) -> bool {
    extern "C-unwind" {
        fn CFBinaryHeapContainsValue(heap: &CFBinaryHeap, value: *const c_void) -> Boolean;
    }
    let ret = unsafe { CFBinaryHeapContainsValue(heap, value) };
    ret != 0
}

extern "C-unwind" {
    /// Returns the minimum value is in the binary heap.  If the heap contains several equal
    /// minimum values, any one may be returned.
    ///
    /// Parameter `heap`: The binary heap to be searched. If this parameter is not a
    /// valid CFBinaryHeap, the behavior is undefined.
    ///
    /// Returns: A reference to the minimum value in the binary heap, or NULL if the
    /// binary heap contains no values.
    pub fn CFBinaryHeapGetMinimum(heap: &CFBinaryHeap) -> *const c_void;
}

/// Returns the minimum value is in the binary heap, if present.  If the heap contains several equal
/// minimum values, any one may be returned.
///
/// Parameter `heap`: The binary heap to be searched. If this parameter is not a
/// valid CFBinaryHeap, the behavior is undefined.
///
/// Parameter `value`: A C pointer to pointer-sized storage to be filled with the minimum value in
/// the binary heap.  If this value is not a valid C pointer to a pointer-sized block
/// of storage, the result is undefined.  If the result of the function is false, the value
/// stored at this address is undefined.
///
/// Returns: true, if a minimum value was found in the specified binary heap, otherwise false.
#[inline]
pub unsafe extern "C-unwind" fn CFBinaryHeapGetMinimumIfPresent(
    heap: &CFBinaryHeap,
    value: *mut *const c_void,
) -> bool {
    extern "C-unwind" {
        fn CFBinaryHeapGetMinimumIfPresent(
            heap: &CFBinaryHeap,
            value: *mut *const c_void,
        ) -> Boolean;
    }
    let ret = unsafe { CFBinaryHeapGetMinimumIfPresent(heap, value) };
    ret != 0
}

extern "C-unwind" {
    /// Fills the buffer with values from the binary heap.
    ///
    /// Parameter `heap`: The binary heap to be queried. If this parameter is not a
    /// valid CFBinaryHeap, the behavior is undefined.
    ///
    /// Parameter `values`: A C array of pointer-sized values to be filled with
    /// values from the binary heap. The values in the C array are ordered
    /// from least to greatest. If this parameter is not a valid pointer to a
    /// C array of at least CFBinaryHeapGetCount() pointers, the behavior is undefined.
    pub fn CFBinaryHeapGetValues(heap: &CFBinaryHeap, values: *mut *const c_void);
}

extern "C-unwind" {
    /// Calls a function once for each value in the binary heap.
    ///
    /// Parameter `heap`: The binary heap to be operated upon. If this parameter is not a
    /// valid CFBinaryHeap, the behavior is undefined.
    ///
    /// Parameter `applier`: The callback function to call once for each value in
    /// the given binary heap. If this parameter is not a
    /// pointer to a function of the correct prototype, the behavior
    /// is undefined. If there are values in the binary heap which the
    /// applier function does not expect or cannot properly apply
    /// to, the behavior is undefined.
    ///
    /// Parameter `context`: A pointer-sized user-defined value, which is passed
    /// as the second parameter to the applier function, but is
    /// otherwise unused by this function. If the context is not
    /// what is expected by the applier function, the behavior is
    /// undefined.
    pub fn CFBinaryHeapApplyFunction(
        heap: &CFBinaryHeap,
        applier: CFBinaryHeapApplierFunction,
        context: *mut c_void,
    );
}

extern "C-unwind" {
    /// Adds the value to the binary heap.
    ///
    /// Parameter `heap`: The binary heap to which the value is to be added. If this parameter is not a
    /// valid mutable CFBinaryHeap, the behavior is undefined.
    ///
    /// Parameter `value`: The value to add to the binary heap. The value is retained by
    /// the binary heap using the retain callback provided when the binary heap
    /// was created. If the value is not of the sort expected by the
    /// retain callback, the behavior is undefined.
    pub fn CFBinaryHeapAddValue(heap: &CFBinaryHeap, value: *const c_void);
}

extern "C-unwind" {
    /// Removes the minimum value from the binary heap.
    ///
    /// Parameter `heap`: The binary heap from which the minimum value is to be removed. If this
    /// parameter is not a valid mutable CFBinaryHeap, the behavior is undefined.
    pub fn CFBinaryHeapRemoveMinimumValue(heap: &CFBinaryHeap);
}

extern "C-unwind" {
    /// Removes all the values from the binary heap, making it empty.
    ///
    /// Parameter `heap`: The binary heap from which all of the values are to be
    /// removed. If this parameter is not a valid mutable CFBinaryHeap,
    /// the behavior is undefined.
    pub fn CFBinaryHeapRemoveAllValues(heap: &CFBinaryHeap);
}
