/**
 *  beep plugin for the Video Disk Recorder 
 *
 *  status.c  -  status monitor class
 *
 *  (c) 2004 - 2008 Andreas Brachold <vdr07 AT deltab de>
 *
 * This code is distributed under the terms and conditions of the
 * GNU GENERAL PUBLIC LICENSE. See the file COPYING for details.
 *
 */

#include <unistd.h>
#include <sys/ioctl.h>
#include <fcntl.h>
#include <linux/kd.h>

#include "status.h"
#include "setup.h"

void cStatusNotifyBeep::beep(unsigned int nFreq, unsigned int nDuration) const
{
    if(NULL == NotifyBeepSetup.console)
    {
        esyslog("NotifyBeep plugin: NULL is a wrong Console");
        return;
    }

    if(0 >= NotifyBeepSetup.freq)
    {
        esyslog("NotifyBeep plugin: Zero is a wrong frequency");
        return;
    }

    if(0 >= NotifyBeepSetup.duration)
    {
        esyslog("NotifyBeep plugin: Zero is a wrong duration");
        return;
    }
    
    
    int fd = open(NotifyBeepSetup.console, O_WRONLY);
    if (fd == -1) 
    { 
        char szErr[128];
        int nErr = errno;
        szErr[sizeof(szErr)-1] = '\0';
        if(0 != strerror_r(nErr,szErr,sizeof(szErr)-1)) {
            szErr[0] = '\0';
        }
        esyslog("NotifyBeep plugin: Can't open %s : %s(%d) ",NotifyBeepSetup.console, szErr, nErr);
        return;
    }

    char szBuf[64]; 
    snprintf(szBuf,sizeof(szBuf),"\033[10;%d]\033[11;%d]\07\033[10]\033[11]",nFreq,nDuration);
    int iRet = write(fd,szBuf,strlen(szBuf));
    if (iRet != 0) 
    { 
        char szErr[128];
        int nErr = errno;
        szErr[sizeof(szErr)-1] = '\0';
        if(0 != strerror_r(nErr,szErr,sizeof(szErr)-1)) {
            szErr[0] = '\0';
        } 
        esyslog("NotifyBeep plugin: Can't write to %s : %s(%d) ",NotifyBeepSetup.console, szErr , nErr);
    }
    else 
    {
        usleep(nDuration*1000);
    }
    close(fd);
}

cStatusNotifyBeep::cStatusNotifyBeep()
{
} 

cStatusNotifyBeep::~cStatusNotifyBeep()
{
    
}

void cStatusNotifyBeep::notify() const {
  beep(NotifyBeepSetup.freq,NotifyBeepSetup.duration);
}
        
void cStatusNotifyBeep::OsdStatusMessage(const char * Message)
{
  if (Message && NotifyBeepSetup.active)
  {
    // dsyslog("NotifyBeep plugin: cStatusNotifyBeep::OsdStatusMessage '%s'", Message);
    struct 
    {
    int* active;
    const char* szMessage;    
    } messagetable[] = 
    {
        { &NotifyBeepSetup.onshutdown,          "Press any key to cancel shutdown" },
        { &NotifyBeepSetup.oneditprocess,       "Editing process finished"         },
        { &NotifyBeepSetup.oneditprocess,       "Editing process failed!"          }
    };
    
    unsigned int n;
    for(n = 0; n < (sizeof(messagetable)/sizeof(*messagetable));++n)
    {
      if(NotifyBeepSetup.onanymessage || *messagetable[n].active)
      {
        const char* szCmp = trVDR(messagetable[n].szMessage);
        if(NotifyBeepSetup.onanymessage ||  
            0 == strncmp(Message,szCmp,strlen(szCmp)))    
        {
            beep(NotifyBeepSetup.freq,NotifyBeepSetup.duration);
            return;
        }
      }
    }
  }
}


void cStatusNotifyBeep::ChannelSwitch(const cDevice * Device, int ChannelNumber)
{
  if (NotifyBeepSetup.active)
  {
//    dsyslog("NotifyBeep plugin: cStatusNotifyBeep::ChannelSwitch  %d %d", Device->CardIndex(), ChannelNumber);
  }
}


void cStatusNotifyBeep::Recording(const cDevice *Device, const char *Name, const char *FileName, bool On)
{
  if (NotifyBeepSetup.active)
  {
//    dsyslog("NotifyBeep plugin: cStatusNotifyBeep::Recording  %d %s", Device->CardIndex(), Name);
  }
}


void cStatusNotifyBeep::Replaying(const cControl *Control, const char *Name, const char *FileName, bool On)
{
  if (NotifyBeepSetup.active)
  {
//    dsyslog("NotifyBeep plugin: cStatusNotifyBeep::Replaying  %s", Name);
  }
}


void cStatusNotifyBeep::SetVolume(int Volume, bool Absolute)
{
  if (NotifyBeepSetup.active)
  {
//    dsyslog("NotifyBeep plugin: cStatusNotifyBeep::SetVolume  %d %d", Volume, Absolute);
  }
}


void cStatusNotifyBeep::OsdClear()
{
  if (NotifyBeepSetup.active)
  {
//    dsyslog("NotifyBeep plugin: cStatusNotifyBeep::OsdClear");
  }
}


void cStatusNotifyBeep::OsdTitle(const char * Title)
{
  if (NotifyBeepSetup.active)
  {
//    dsyslog("NotifyBeep plugin: cStatusNotifyBeep::OsdTitle '%s'", Title);
  }
}




void cStatusNotifyBeep::OsdHelpKeys(const char * Red, const char * Green, const char * Yellow, const char * Blue)
{
  if (NotifyBeepSetup.active)
  {
//    dsyslog("NotifyBeep plugin: cStatusNotifyBeep::OsdHelpKeys %s - %s - %s - %s", Red, Green, Yellow, Blue);
  }
}


void cStatusNotifyBeep::OsdItem(const char * Text, int Index)
{
  if (NotifyBeepSetup.active)
  {
//    dsyslog("NotifyBeep plugin: cStatusNotifyBeep::OsdItem %s, %d", Text, Index);
  }
}


void cStatusNotifyBeep::OsdCurrentItem(const char * Text)
{
  if (NotifyBeepSetup.active)
  {
//    dsyslog("NotifyBeep plugin: cStatusNotifyBeep::OsdCurrentItem %s", Text);
  }
}


void cStatusNotifyBeep::OsdTextItem(const char * Text, bool Scroll)
{
  if (NotifyBeepSetup.active)
  {
//    dsyslog("NotifyBeep plugin: cStatusNotifyBeep::OsdTextItem %s %d", Text, Scroll);
  }
}


void cStatusNotifyBeep::OsdChannel(const char * Text)
{
  if (NotifyBeepSetup.active)
  {
//    dsyslog("NotifyBeep plugin: cStatusNotifyBeep::OsdChannel >%s<", Text);
  }
}


void cStatusNotifyBeep::OsdProgramme(time_t PresentTime, const char * PresentTitle, const char * PresentSubtitle, time_t FollowingTime, const char * FollowingTitle, const char * FollowingSubtitle)
{
  if (NotifyBeepSetup.active)
  {
//    dsyslog("NotifyBeep plugin: cStatusNotifyBeep::OsdProgramme PT  : %s", PresentTitle);
//    dsyslog("NotifyBeep plugin: cStatusNotifyBeep::OsdProgramme PST : %s", PresentSubtitle);
//    dsyslog("NotifyBeep plugin: cStatusNotifyBeep::OsdProgramme FT  : %s", FollowingTitle);
//    dsyslog("NotifyBeep plugin: cStatusNotifyBeep::OsdProgramme FST : %s", FollowingSubtitle);
  }
}
