// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package supplychainiface provides an interface to enable mocking the AWS Supply Chain service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package supplychainiface

import (
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/service/supplychain"
)

// SupplyChainAPI provides an interface to enable mocking the
// supplychain.SupplyChain service client's API operation,
// paginators, and waiters. This make unit testing your code that calls out
// to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the SDK's request pipeline.
//
//	// myFunc uses an SDK service client to make a request to
//	// AWS Supply Chain.
//	func myFunc(svc supplychainiface.SupplyChainAPI) bool {
//	    // Make svc.CreateBillOfMaterialsImportJob request
//	}
//
//	func main() {
//	    sess := session.New()
//	    svc := supplychain.New(sess)
//
//	    myFunc(svc)
//	}
//
// In your _test.go file:
//
//	// Define a mock struct to be used in your unit tests of myFunc.
//	type mockSupplyChainClient struct {
//	    supplychainiface.SupplyChainAPI
//	}
//	func (m *mockSupplyChainClient) CreateBillOfMaterialsImportJob(input *supplychain.CreateBillOfMaterialsImportJobInput) (*supplychain.CreateBillOfMaterialsImportJobOutput, error) {
//	    // mock response/functionality
//	}
//
//	func TestMyFunc(t *testing.T) {
//	    // Setup Test
//	    mockSvc := &mockSupplyChainClient{}
//
//	    myfunc(mockSvc)
//
//	    // Verify myFunc's functionality
//	}
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type SupplyChainAPI interface {
	CreateBillOfMaterialsImportJob(*supplychain.CreateBillOfMaterialsImportJobInput) (*supplychain.CreateBillOfMaterialsImportJobOutput, error)
	CreateBillOfMaterialsImportJobWithContext(aws.Context, *supplychain.CreateBillOfMaterialsImportJobInput, ...request.Option) (*supplychain.CreateBillOfMaterialsImportJobOutput, error)
	CreateBillOfMaterialsImportJobRequest(*supplychain.CreateBillOfMaterialsImportJobInput) (*request.Request, *supplychain.CreateBillOfMaterialsImportJobOutput)

	GetBillOfMaterialsImportJob(*supplychain.GetBillOfMaterialsImportJobInput) (*supplychain.GetBillOfMaterialsImportJobOutput, error)
	GetBillOfMaterialsImportJobWithContext(aws.Context, *supplychain.GetBillOfMaterialsImportJobInput, ...request.Option) (*supplychain.GetBillOfMaterialsImportJobOutput, error)
	GetBillOfMaterialsImportJobRequest(*supplychain.GetBillOfMaterialsImportJobInput) (*request.Request, *supplychain.GetBillOfMaterialsImportJobOutput)
}

var _ SupplyChainAPI = (*supplychain.SupplyChain)(nil)
