/*
 * Decompiled with CFR 0.152.
 */
package charm.debug.fmt;

import charm.debug.fmt.PDisplayStyle;
import charm.debug.fmt.PList;
import charm.debug.fmt.PNative;
import charm.debug.fmt.PString;
import java.awt.Canvas;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;

public abstract class PAbstract {
    private String name = null;
    private PAbstract next = null;

    public String getDeepName() {
        PString s = (PString)((PList)this).elementNamed("name");
        return s.getString();
    }

    public String toString() {
        if (this.getName() != null) {
            return this.getName() + "=";
        }
        return "";
    }

    public void setName(String n) {
        this.name = n;
    }

    public final String getName() {
        return this.name;
    }

    public void setNext(PAbstract n) {
        this.next = n;
    }

    public final PAbstract getNext() {
        return this.next;
    }

    public boolean draw(PDisplayStyle p) {
        int drawStyle = p.getDrawStyle(this);
        return this.draw(p, drawStyle);
    }

    public boolean draw(PDisplayStyle p, int drawStyle) {
        if (this.getName() != null) {
            p.drawString(this.getName() + "=");
        }
        return true;
    }

    public static void main(String[] args) {
        Canvas c = new Canvas(){

            @Override
            public void paint(Graphics g) {
                PDisplayStyle pd = new PDisplayStyle(g, 500);
                int[] iarr = new int[]{1, 2, 3, 4};
                PNative n1 = new PNative(iarr);
                n1.setName("Foo");
                PNative n2 = new PNative(iarr);
                n2.setName("Bar");
                PNative n3 = new PNative(iarr);
                n3.setName("Baz");
                PList o = new PList();
                o.setName("Big");
                o.add(n1);
                o.add(n2);
                PList sub = new PList();
                sub.setName("Sub");
                int[] sarr = new int[]{23};
                sub.add(new PNative(sarr));
                sub.add(new PNative(sarr));
                sub.add(new PList());
                sub.add(new PNative(sarr));
                o.add(sub);
                o.add(n3);
                o.draw(pd);
            }

            @Override
            public Dimension getPreferredSize() {
                return new Dimension(500, 400);
            }
        };
        Frame f = new Frame("Test PAbstract");
        f.add(c);
        f.pack();
        f.setVisible(true);
    }
}

