/*
 * Decompiled with CFR 0.152.
 */
package charm.debug;

import charm.debug.MemoryLog;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.List;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JToolTip;
import javax.swing.Scrollable;

public class ScrollableAllocationGraph
extends JLabel
implements Scrollable,
ActionListener {
    private int maxUnitIncrement = 1;
    private int height;
    private int width;
    private int barWidth;
    private int eventsPerBar;
    private int numBars;
    private Vector logs;
    private int[] rgbnormal;
    private int[] rgbselected;
    private int maximumSize;
    private int selectedPosition;
    private MemoryBar[] bars;
    JPopupMenu popup;
    int popupOverBarIndex;
    public int viewX;
    public int viewY;
    private int markedBar;
    private int lastMarkedBar;

    public ScrollableAllocationGraph(Vector logs, int eventsPerBar, int barWidth, int height) {
        this.logs = logs;
        this.eventsPerBar = eventsPerBar;
        this.barWidth = barWidth;
        this.height = height;
        this.numBars = (int)Math.ceil((double)logs.size() / (double)eventsPerBar);
        this.width = this.numBars * barWidth;
        this.markedBar = -1;
        this.lastMarkedBar = -1;
        this.selectedPosition = -1;
        this.maximumSize = 0;
        for (int i = 0; i < logs.size(); ++i) {
            int size = ((MemoryLog)logs.elementAt(i)).getSizeAfter();
            if (size <= this.maximumSize) continue;
            this.maximumSize = size;
        }
        System.out.println("maximumSize = " + this.maximumSize);
        this.resize();
        this.setHorizontalAlignment(0);
        this.setOpaque(true);
        this.setBackground(Color.black);
        this.setAutoscrolls(true);
        this.popup = new JPopupMenu();
        JMenuItem menuItem = new JMenuItem("Set Mark");
        menuItem.setActionCommand("setmark");
        menuItem.addActionListener(this);
        this.popup.add(menuItem);
        menuItem = new JMenuItem("Remove Mark");
        menuItem.setActionCommand("removemark");
        menuItem.addActionListener(this);
        this.popup.add(menuItem);
        this.addMouseListener(new PopupListener(this));
    }

    private void resize() {
        int i;
        BufferedImage tmp = new BufferedImage(this.width, this.height, 2);
        this.rgbnormal = new int[this.height * this.barWidth];
        int color = -45747;
        for (i = 0; i < this.height * this.barWidth; ++i) {
            this.rgbnormal[i] = color;
        }
        this.rgbselected = new int[this.height * this.barWidth];
        color = -101;
        for (i = 0; i < this.height * this.barWidth; ++i) {
            this.rgbselected[i] = color;
        }
        this.bars = new MemoryBar[this.numBars];
        for (i = 0; i < this.numBars; ++i) {
            int barHeight = 0;
            int lastLog = (i + 1) * this.eventsPerBar;
            if (this.logs.size() <= lastLog) {
                lastLog = this.logs.size() - 1;
            }
            for (int j = i * this.eventsPerBar + 1; j <= lastLog; ++j) {
                int logHeight = ((MemoryLog)this.logs.elementAt(j)).getSizeAfter();
                if (logHeight <= barHeight) continue;
                barHeight = logHeight;
            }
            int barPixels = (int)((long)this.height * (long)barHeight / (long)this.maximumSize);
            this.bars[i] = new MemoryBar(this.logs.subList(i * this.eventsPerBar + 1, lastLog + 1), barHeight, i, barPixels);
            tmp.setRGB(i * this.barWidth, this.height - barPixels, this.barWidth, barPixels, this.rgbnormal, 0, 1);
        }
        this.setIcon(new ImageIcon(tmp));
        this.maxUnitIncrement = 10;
    }

    public JLabel getRowHeader() {
        BufferedImage tmp = new BufferedImage(40, this.height, 2);
        Graphics2D g = tmp.createGraphics();
        g.setBackground(Color.BLACK);
        g.clearRect(0, 0, 40, this.height);
        double maxNumTicks = (double)this.height / 50.0;
        double bytePerTickD = (double)this.maximumSize / maxNumTicks;
        System.out.print("Byte/Tick = " + bytePerTickD);
        int bytePerTick = bytePerTickD < 1.0E7 ? (int)(1000000.0 * Math.ceil(bytePerTickD / 1000000.0)) : (bytePerTickD < 1.0E8 ? (int)(1.0E7 * Math.ceil(bytePerTickD / 1.0E7)) : (int)(1.0E8 * Math.ceil(bytePerTickD / 1.0E8)));
        System.out.println(" -> " + bytePerTick);
        g.drawLine(30, 0, 30, this.height);
        for (int mb = 0; mb < this.maximumSize; mb += bytePerTick) {
            int y = (int)((long)this.height * (long)mb / (long)this.maximumSize) + 1;
            g.drawLine(25, this.height - y, 35, this.height - y);
            g.drawString("" + mb / 1000000, 5, this.height - y);
        }
        JLabel label = new JLabel();
        label.setIcon(new ImageIcon(tmp));
        label.setVerticalAlignment(1);
        return label;
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        int currentPosition = 0;
        currentPosition = orientation == 0 ? visibleRect.x : visibleRect.y;
        if (direction < 0) {
            int newPosition = currentPosition - currentPosition / this.maxUnitIncrement * this.maxUnitIncrement;
            return newPosition == 0 ? this.maxUnitIncrement : newPosition;
        }
        return (currentPosition / this.maxUnitIncrement + 1) * this.maxUnitIncrement - currentPosition;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return false;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        if (orientation == 0) {
            return visibleRect.width - this.maxUnitIncrement;
        }
        return visibleRect.height - this.maxUnitIncrement;
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    public void selectPosition(MouseEvent e) {
        int i;
        int startPosition;
        int endPosition;
        int bar = this.getMemoryBarIndex(e);
        BufferedImage image = (BufferedImage)((ImageIcon)this.getIcon()).getImage();
        if (this.selectedPosition != -1) {
            startPosition = endPosition = this.selectedPosition;
            if (this.lastMarkedBar != -1) {
                if (this.lastMarkedBar > this.selectedPosition) {
                    endPosition = this.lastMarkedBar;
                } else {
                    startPosition = this.lastMarkedBar;
                }
            }
            for (i = startPosition; i <= endPosition; ++i) {
                image.setRGB(this.bars[i].position * this.barWidth, this.height - this.bars[i].pixels, this.barWidth, this.bars[i].pixels, this.rgbnormal, 0, 1);
            }
        }
        this.lastMarkedBar = this.markedBar;
        this.selectedPosition = bar;
        if (this.selectedPosition != -1) {
            startPosition = endPosition = this.selectedPosition;
            if (this.markedBar != -1) {
                if (this.markedBar > this.selectedPosition) {
                    endPosition = this.markedBar;
                } else {
                    startPosition = this.markedBar;
                }
            }
            for (i = startPosition; i <= endPosition; ++i) {
                image.setRGB(this.bars[i].position * this.barWidth, this.height - this.bars[i].pixels, this.barWidth, this.bars[i].pixels, this.rgbselected, 0, 1);
            }
        }
        this.repaint();
        this.createToolTip().repaint();
    }

    public List getSelectedLogs() {
        if (this.selectedPosition == -1) {
            return null;
        }
        if (this.markedBar >= 0) {
            int firstBar = this.markedBar < this.selectedPosition ? this.markedBar : this.selectedPosition;
            int lastBar = this.markedBar < this.selectedPosition ? this.selectedPosition : this.markedBar;
            int lastLog = (lastBar + 1) * this.eventsPerBar;
            if (this.logs.size() <= lastLog) {
                lastLog = this.logs.size() - 1;
            }
            return this.logs.subList(firstBar * this.eventsPerBar + 1, lastLog + 1);
        }
        return this.bars[this.selectedPosition].logs;
    }

    public List getLogsFromBeginning() {
        if (this.selectedPosition == -1) {
            return null;
        }
        int lastLog = (this.selectedPosition + 1) * this.eventsPerBar;
        if (this.logs.size() <= lastLog) {
            lastLog = this.logs.size() - 1;
        }
        return this.logs.subList(0, lastLog + 1);
    }

    int getMemoryBarIndex(int position) {
        if (position == -1) {
            return -1;
        }
        int i = position / this.barWidth;
        return i;
    }

    int getMemoryBarIndex(MouseEvent e) {
        if (e == null) {
            return -1;
        }
        return this.getMemoryBarIndex(e.getX());
    }

    MemoryBar getMemoryBar(MouseEvent e) {
        int index = this.getMemoryBarIndex(e);
        if (index == -1) {
            return null;
        }
        return this.bars[index];
    }

    @Override
    public Point getToolTipLocation(MouseEvent e) {
        JToolTip tip = this.createToolTip();
        tip.setTipText(this.getToolTipText(e));
        return new Point(e.getX() - tip.getPreferredSize().width, e.getY() - tip.getPreferredSize().height);
    }

    @Override
    public String getToolTipText(MouseEvent e) {
        MemoryBar bar = this.getMemoryBar(e);
        return "<html>Total memory: " + bar.maximum + "<br>Biggest allocation: " + bar.maxMalloc + "<br>Biggest free: " + bar.maxFree + "</html>";
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        System.out.println("ScrollableAllocationGraph action: " + e);
        if (e.getActionCommand().equals("setmark")) {
            this.markedBar = this.popupOverBarIndex;
        } else if (e.getActionCommand().equals("removemark")) {
            this.markedBar = -1;
        }
    }

    class PopupListener
    extends MouseAdapter {
        ScrollableAllocationGraph parent;

        PopupListener(ScrollableAllocationGraph p) {
            this.parent = p;
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.checkForTriggerEvent(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.checkForTriggerEvent(e);
        }

        private void checkForTriggerEvent(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.parent.popupOverBarIndex = this.parent.getMemoryBarIndex(e.getX());
                this.parent.popup.show(e.getComponent(), e.getX(), e.getY());
            }
        }
    }

    class MemoryBar {
        List logs;
        int position;
        int pixels;
        int maximum;
        int maxMalloc;
        int maxFree;

        public MemoryBar(List l, int m, int pos, int p) {
            this.logs = l;
            this.maximum = m;
            this.position = pos;
            this.pixels = p;
            this.maxFree = 0;
            this.maxMalloc = 0;
            for (MemoryLog log : this.logs) {
                int size = log.getSize();
                if (size > this.maxMalloc) {
                    this.maxMalloc = size;
                    continue;
                }
                if (-size <= this.maxFree) continue;
                this.maxFree = -size;
            }
        }
    }
}

