/*
 * Decompiled with CFR 0.152.
 */
package charm.debug;

import charm.debug.PeSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class Processor
implements Comparable {
    public static final int RUNNING = 1;
    public static final int FROZEN = 2;
    public static final int REQUESTED_FREEZE = 3;
    public static final int DEAD = 4;
    public static final int CONDITIONAL = 5;
    public static final int CONDITIONAL_DEAD = 6;
    private static final char[] codes = new char[]{' ', 'R', 'F', 'f', 'D', 'C', 'd'};
    int status;
    int id;
    Set sets;

    public Processor(int i) {
        this.id = i;
        this.status = 3;
        this.sets = new HashSet();
    }

    public void addToSet(PeSet p) {
        this.sets.add(p);
    }

    public int compareTo(Object o) {
        Processor p = (Processor)o;
        return this.id - p.id;
    }

    public int getId() {
        return this.id;
    }

    public boolean isFrozen() {
        return this.status == 2;
    }

    public boolean isRunning() {
        return this.status == 1;
    }

    public boolean isFreezing() {
        return this.status == 3;
    }

    public boolean isDead() {
        return this.status == 4 || this.status == 6;
    }

    public boolean isConditional() {
        return this.status == 5 || this.status == 6;
    }

    public void setFrozen() {
        block7: {
            if (this.status == 4) break block7;
            System.out.println("Processor " + this.id + " frozen");
            int oldstatus = this.status;
            this.status = 2;
            if (oldstatus == 5) {
                Iterator iter = this.sets.iterator();
                while (iter.hasNext()) {
                    ((PeSet)iter.next()).unsetConditional();
                }
            } else if (oldstatus == 6) {
                for (PeSet pe : this.sets) {
                    pe.unsetConditional();
                    pe.unsetDead();
                }
            } else {
                Iterator iter = this.sets.iterator();
                while (iter.hasNext()) {
                    ((PeSet)iter.next()).setFrozen();
                }
            }
        }
    }

    public void setRunning() {
        this.status = 1;
        Iterator iter = this.sets.iterator();
        while (iter.hasNext()) {
            ((PeSet)iter.next()).setRunning();
        }
    }

    public void setFreezing() {
        System.out.println("Processor " + this.id + " freezing");
        this.status = 3;
    }

    public void setDead() {
        for (PeSet p : this.sets) {
            if (!this.isFrozen()) {
                p.setFrozen();
            }
            p.setDead();
        }
        this.status = this.status == 5 ? 6 : 4;
    }

    public void setConditional() {
        System.out.println("Processor " + this.id + " conditional");
        this.status = 5;
        Iterator iter = this.sets.iterator();
        while (iter.hasNext()) {
            ((PeSet)iter.next()).setConditional();
        }
    }

    public String toString() {
        return "" + this.id + "(" + codes[this.status] + ")";
    }
}

