/*
 * Decompiled with CFR 0.152.
 */
package charm.debug;

import charm.util.JSelectField;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.SortedSet;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class PeSetDialog
extends JDialog
implements ActionListener {
    private JTextField name;
    private JSelectField pes;
    private SortedSet pesList;
    private JButton ok;
    private JButton cancel;
    private boolean confirmed = false;
    private int numPes;

    public PeSetDialog(Frame parent, boolean modal, int npes) {
        super(parent, "New Pe Subset", modal);
        this.numPes = npes;
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        JPanel topPane = new JPanel();
        topPane.setLayout(new GridLayout(2, 2));
        JLabel textName = new JLabel("Name (optional): ");
        topPane.add(textName);
        this.name = new JTextField("");
        this.name.addActionListener(this);
        topPane.add(this.name);
        JLabel textPes = new JLabel("List of processors: ");
        topPane.add(textPes);
        this.pes = new JSelectField("", 30);
        this.pes.addActionListener(this);
        topPane.add(this.pes);
        JPanel bottomPane = new JPanel();
        this.ok = new JButton("Ok");
        this.ok.setActionCommand("ok");
        this.ok.addActionListener(this);
        bottomPane.add(this.ok);
        this.cancel = new JButton("Cancel");
        this.cancel.setActionCommand("cancel");
        this.cancel.addActionListener(this);
        bottomPane.add(this.cancel);
        this.getContentPane().add(topPane);
        this.getContentPane().add(bottomPane);
        this.pack();
        this.setResizable(false);
        this.setVisible(true);
    }

    public boolean confirmed() {
        return this.confirmed;
    }

    @Override
    public String getName() {
        return this.name.getText();
    }

    public SortedSet getPes() {
        return this.pesList;
    }

    private boolean parsePes() {
        if (this.pes.getText().length() <= 0) {
            return false;
        }
        this.pesList = this.pes.getValue(this.numPes);
        return this.pesList != null;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("ok") || e.getSource() == this.name || e.getSource() == this.pes) {
            try {
                if (this.parsePes()) {
                    if (this.name.getText().length() <= 0) {
                        this.name.setText(this.pes.getText());
                    }
                    this.confirmed = true;
                    this.setVisible(false);
                } else {
                    JOptionPane.showMessageDialog(this, "Invalid specification of processors", "Error", 0);
                    this.pes.requestFocus();
                }
            }
            catch (NumberFormatException ne) {
                JOptionPane.showMessageDialog(this, "All values must be positive integers", "Error", 0);
            }
        }
        if (e.getActionCommand().equals("cancel")) {
            this.setVisible(false);
        }
    }
}

