 /*
 * Licensed to the Apache Software Foundation (ASF) under one   *
 * or more contributor license agreements.  See the NOTICE file *
 * distributed with this work for additional information        *
 * regarding copyright ownership.  The ASF licenses this file   *
 * to you under the Apache License, Version 2.0 (the            *
 * "License"); you may not use this file except in compliance   *
 * with the License.  You may obtain a copy of the License at   *
 *                                                              *
 *   http://www.apache.org/licenses/LICENSE-2.0                 *
 *                                                              *
 * Unless required by applicable law or agreed to in writing,   *
 * software distributed under the License is distributed on an  *
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY       *
 * KIND, either express or implied.  See the License for the    *
 * specific language governing permissions and limitations      *
 * under the License.                                           *
 */ 
package org.apache.rat.anttasks;

import org.apache.rat.analysis.RatHeaderAnalysisException;
import org.apache.rat.analysis.license.FullTextMatchingLicense;
import org.apache.rat.api.Document;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;

/**
 * Adapts {@link FullTextMatchingLicense FullTextMatchingLicense}
 * to Ant's method naming conventions so it becomes easy to write
 * text matching based license matchers inside an Ant build file.
 * @since Rat Antlib 0.9
 */
public class FullTextLicenseMatcher extends FullTextMatchingLicense {
    private boolean validated = false;
    private String fullText = "";
    private Project project;

    public void setProject(Project project) {
        this.project = project;
    }

    public void addText(String text) {
        if (text != null && text.trim().length() > 0) {
            setFullText(fullText += project.replaceProperties(text));
        }
    }

    @Override
    public boolean match(Document subject, String line) throws RatHeaderAnalysisException {
        validate();
        return super.match(subject, line);
    }

    private void validate() {
        if (!validated) {
            validated  = true;
            if (!hasFullText()) {
                throw new BuildException("You must specify the text to match.");
            }
            if (getLicenseFamilyCategory() == null) {
                throw new BuildException("The licenseFamilyCategory attribute"
                                         + " is required.");
            }
            if (getLicenseFamilyName() == null) {
                throw new BuildException("The licenseFamilyName attribute"
                                         + " is required.");
            }
        }
    }

}
