/* $Id: gcplight.c,v 1.3 2004/09/18 12:00:30 cegger Exp $
******************************************************************************

   Demo of the GCP extension.

   Authors:	2000 Christoph Egger	[Christoph_Egger@t-online.de]
  
   This code is placed in the public domain and may be used freely for any
   purpose.

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
   THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
   IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
   CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************************
*/

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <math.h>

#include <ggi/ggi.h>
#include <ggi/gcp.h>


#define MIN(x,y)	(((x) < (y)) ? (x) : (y))
#define MAX(x,y)	(((x) > (y)) ? (x) : (y))
#define MID(x,y,z)	MAX((x), MIN((y), (z)))


static void do_demo(ggi_visual_t vis)
{
	int x,y;
	int dx,dy;
	ggi_float dist, dir;


	gcp_HSVcolor hsv_light;


	gcp_RGBAcolor rgba;
	gcp_HSVcolor hsv;
	gcp_YUVcolor yuv;
	gcp_CMYKcolor cmyk;


	gcp_pixel rgba_pixel;
	gcp_pixel hsv_pixel;
	gcp_pixel yuv_pixel;
	gcp_pixel cmyk_pixel;




	gcp_pixel col1_pixel;
	gcp_pixel col2_pixel;
	gcp_pixel col3_pixel;


	gcpSetColorfulPalette(vis);


	/* Change this, if you want to test color-blending
	 * with different color-values.
	 */
	rgba.r = 0x0000;
	rgba.g = 0x0000;
	rgba.b = 0xFFFF;
	rgba.a = 0xFFFF;

	hsv.h = 1.0f;
	hsv.s = 1.0f;
	hsv.v = 1.0f;

	yuv.y = 1.0f;
	yuv.u = 1.0f;
	yuv.v = 1.0f;

	cmyk.c = 0x7777;
	cmyk.m = 0xFFFF;
	cmyk.y = 0x7777;
	cmyk.k = 0x6666;


	printf("rgba (0x%X,0x%X,0x%X,0x%X)\n",
		rgba.r, rgba.g, rgba.b, rgba.a);

	printf("hsv (%.02f,%.02f,%.02f)\n",
		hsv.h, hsv.s, hsv.v);

	printf("yuv (%.02f,%.02f,%.02f)\n",
		yuv.y, yuv.u, yuv.v);

	printf("cmyk (0x%X,0x%X,0x%X,0x%X)\n",
		cmyk.c, cmyk.m, cmyk.y, cmyk.k);


	rgba_pixel = gcpMapRGBAColor(vis, &rgba);
	hsv_pixel = gcpMapHSVColor(vis, &hsv);
	yuv_pixel = gcpMapYUVColor(vis, &yuv);
	cmyk_pixel = gcpMapCMYKColor(vis, &cmyk);


	/* Change this, if you want to test color-blending
	 * with different colorspaces.
	 */
	col1_pixel = rgba_pixel;
	col2_pixel = hsv_pixel;
	col3_pixel = cmyk_pixel;


	printf("color1 pixel: %i\n", col1_pixel);
	printf("color2 pixel: %i\n", col2_pixel);
	printf("color3 pixel: %i\n", col3_pixel);



	ggiSetGCForeground(vis, col1_pixel);
	ggiDrawBox(vis, 0,110, 200,100);

	ggiFlush(vis);


	hsv_light.h = 1.0f;
	hsv_light.s = 0.0f;
	hsv_light.v = 1.0f;

	x = y = 0;


	for (;;) {
		gcp_pixel tmp_pixel;
		gcp_pixel light_pixel;

		light_pixel = gcpMapHSVColor(vis, &hsv_light);


		/* light box */
		ggiSetGCForeground(vis, light_pixel);
		ggiDrawBox(vis, 0,0, 100,100);



		/* lighted box */
		tmp_pixel = gcpSetIntensity(vis, &col1_pixel, &light_pixel);
		ggiSetGCForeground(vis, tmp_pixel);
		ggiDrawBox(vis, 0, 110, 200,100);


		tmp_pixel = gcpSetIntensity(vis, &col2_pixel, &light_pixel);
		ggiSetGCForeground(vis, tmp_pixel);
		ggiDrawBox(vis, 0,210, 200,100);

		tmp_pixel = gcpSetIntensity(vis, &col3_pixel, &light_pixel);
		ggiSetGCForeground(vis, tmp_pixel);
		ggiDrawBox(vis, 0,310, 200,100);

		ggiFlush(vis);

		if (ggiKbhit(vis)) break;


		x += 20;
		if (x > 360) {
			x -= 360;
			y += 10;
			if (y > 360) {
				y -= 360;
			}	/* if */
		}	/* if */

		dx = x - 180;
		dy = y - 180;

		dist = sqrt(MID(-32400.0f, (double)(dx*dx+dy*dy), +32400.0f));

		dir = atan2( (double)dy, (double)dx);

		hsv_light.h = dir;
		hsv_light.s = MID(0.0f, dist/180.0f, 1.0f);
		hsv_light.v = 1.0f;


#if 0
		printf("x,y (%i,%i), dist: %.02f\n", x,y, dist);

		printf("hsv_light.h: %.03f, hsv_light.s: %.03f\n",
				hsv_light.h, hsv_light.s);
#endif

	}	/* for */


}	/* do_demo */



int main(void)
{
	ggi_visual_t vis;

	/* Initialize LibGGI */
	if (ggiInit() != 0) {
		fprintf(stderr, "Unable to initialize LibGGI\n");
		exit(1);
	}
	
	/* Initialize LibGCP extension */
	if (gcpInit() != 0) {
		ggiPanic("Unable to initialize LibGCP extension\n");
	}

	/* Open the default visual */
	if ((vis = ggiOpen(NULL)) == NULL) {
		ggiPanic("Unable to open default visual\n");
	}
	
	/* Turn on asynchronous mode (which should always be used) */
	ggiSetFlags(vis, GGIFLAG_ASYNC);
	
	/* Set the default mode */
	if (ggiSetSimpleMode(vis, GGI_AUTO, GGI_AUTO, GGI_AUTO, GT_AUTO) < 0) {
		ggiPanic("Unable to set default mode\n");
	}
	
	/* Attach the GCP extension to the visual */
	if (gcpAttach(vis) < 0) {
		ggiPanic("Unable to attach EDEMO extension to visual\n");
	}


	do_demo(vis);

	
	/* Detach extension from visual */
	gcpDetach(vis);

	/* Close visual */
	ggiClose(vis);

	/* Deinitialize LibGCP extension */
	gcpExit();

	/* Deinitialize LibGGI */
	ggiExit();

	return 0;
}
