
<!--- This file is automatically generated by make gen-cli-docs; changes should be made in the go CLI command code (under cmd/kops) -->

## kops create secret encryptionconfig

Create an encryption config.

### Synopsis

Create a new encryption config and store it in the state store. Used to configure encryption-at-rest by the kube-apiserver process.

```
kops create secret encryptionconfig [CLUSTER] -f FILENAME [flags]
```

### Examples

```
  # Create a new encryption config.
  kops create secret encryptionconfig -f config.yaml \
  --name k8s-cluster.example.com --state s3://my-state-store
  
  # Create a new encryption config via stdin.
  generate-encryption-config.sh | kops create secret encryptionconfig -f - \
  --name k8s-cluster.example.com --state s3://my-state-store
  
  # Replace an existing encryption config secret.
  kops create secret encryptionconfig -f config.yaml --force \
  --name k8s-cluster.example.com --state s3://my-state-store
```

### Options

```
  -f, --filename string   Path to encryption config YAML file
      --force             Force replace the secret if it already exists
  -h, --help              help for encryptionconfig
```

### Options inherited from parent commands

```
      --config string   yaml config file (default is $HOME/.kops.yaml)
      --name string     Name of cluster. Overrides KOPS_CLUSTER_NAME environment variable
      --state string    Location of state storage (kops 'config' file). Overrides KOPS_STATE_STORE environment variable
  -v, --v Level         number for the log level verbosity
```

### SEE ALSO

* [kops create secret](kops_create_secret.md)	 - Create a secret.

