// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package backupstorage

import (
	"fmt"
	"io"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/aws/signer/v4"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opDeleteObject = "DeleteObject"

// DeleteObjectRequest generates a "aws/request.Request" representing the
// client's request for the DeleteObject operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteObject for more information on using the DeleteObject
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteObjectRequest method.
//	req, resp := client.DeleteObjectRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/backupstorage-2018-04-10/DeleteObject
func (c *BackupStorage) DeleteObjectRequest(input *DeleteObjectInput) (req *request.Request, output *DeleteObjectOutput) {
	op := &request.Operation{
		Name:       opDeleteObject,
		HTTPMethod: "DELETE",
		HTTPPath:   "/backup-jobs/{jobId}/object/{objectName}",
	}

	if input == nil {
		input = &DeleteObjectInput{}
	}

	output = &DeleteObjectOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteObject API operation for AWS Backup Storage.
//
// Delete Object from the incremental base Backup.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Backup Storage's
// API operation DeleteObject for usage and error information.
//
// Returned Error Types:
//
//   - ServiceUnavailableException
//     Retryable exception, indicates internal server error.
//
//   - ServiceInternalException
//     Deprecated. To be removed from the model.
//
//   - RetryableException
//     Retryable exception. In general indicates internal failure that can be fixed
//     by retry.
//
//   - IllegalArgumentException
//     Non-retryable exception, indicates client error (wrong argument passed to
//     API). See exception message for details.
//
//   - ResourceNotFoundException
//     Non-retryable exception. Attempted to make an operation on non-existing or
//     expired resource.
//
//   - ThrottlingException
//     Increased rate over throttling limits. Can be retried with exponential backoff.
//
//   - AccessDeniedException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/backupstorage-2018-04-10/DeleteObject
func (c *BackupStorage) DeleteObject(input *DeleteObjectInput) (*DeleteObjectOutput, error) {
	req, out := c.DeleteObjectRequest(input)
	return out, req.Send()
}

// DeleteObjectWithContext is the same as DeleteObject with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteObject for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BackupStorage) DeleteObjectWithContext(ctx aws.Context, input *DeleteObjectInput, opts ...request.Option) (*DeleteObjectOutput, error) {
	req, out := c.DeleteObjectRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetChunk = "GetChunk"

// GetChunkRequest generates a "aws/request.Request" representing the
// client's request for the GetChunk operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetChunk for more information on using the GetChunk
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetChunkRequest method.
//	req, resp := client.GetChunkRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/backupstorage-2018-04-10/GetChunk
func (c *BackupStorage) GetChunkRequest(input *GetChunkInput) (req *request.Request, output *GetChunkOutput) {
	op := &request.Operation{
		Name:       opGetChunk,
		HTTPMethod: "GET",
		HTTPPath:   "/restore-jobs/{jobId}/chunk/{chunkToken}",
	}

	if input == nil {
		input = &GetChunkInput{}
	}

	output = &GetChunkOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetChunk API operation for AWS Backup Storage.
//
// Gets the specified object's chunk.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Backup Storage's
// API operation GetChunk for usage and error information.
//
// Returned Error Types:
//
//   - IllegalArgumentException
//     Non-retryable exception, indicates client error (wrong argument passed to
//     API). See exception message for details.
//
//   - RetryableException
//     Retryable exception. In general indicates internal failure that can be fixed
//     by retry.
//
//   - ResourceNotFoundException
//     Non-retryable exception. Attempted to make an operation on non-existing or
//     expired resource.
//
//   - ServiceInternalException
//     Deprecated. To be removed from the model.
//
//   - ThrottlingException
//     Increased rate over throttling limits. Can be retried with exponential backoff.
//
//   - KMSInvalidKeyUsageException
//     Non-retryable exception. Indicates the KMS key usage is incorrect. See exception
//     message for details.
//
//   - AccessDeniedException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/backupstorage-2018-04-10/GetChunk
func (c *BackupStorage) GetChunk(input *GetChunkInput) (*GetChunkOutput, error) {
	req, out := c.GetChunkRequest(input)
	return out, req.Send()
}

// GetChunkWithContext is the same as GetChunk with the addition of
// the ability to pass a context and additional request options.
//
// See GetChunk for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BackupStorage) GetChunkWithContext(ctx aws.Context, input *GetChunkInput, opts ...request.Option) (*GetChunkOutput, error) {
	req, out := c.GetChunkRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetObjectMetadata = "GetObjectMetadata"

// GetObjectMetadataRequest generates a "aws/request.Request" representing the
// client's request for the GetObjectMetadata operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetObjectMetadata for more information on using the GetObjectMetadata
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetObjectMetadataRequest method.
//	req, resp := client.GetObjectMetadataRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/backupstorage-2018-04-10/GetObjectMetadata
func (c *BackupStorage) GetObjectMetadataRequest(input *GetObjectMetadataInput) (req *request.Request, output *GetObjectMetadataOutput) {
	op := &request.Operation{
		Name:       opGetObjectMetadata,
		HTTPMethod: "GET",
		HTTPPath:   "/restore-jobs/{jobId}/object/{objectToken}/metadata",
	}

	if input == nil {
		input = &GetObjectMetadataInput{}
	}

	output = &GetObjectMetadataOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetObjectMetadata API operation for AWS Backup Storage.
//
// Get metadata associated with an Object.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Backup Storage's
// API operation GetObjectMetadata for usage and error information.
//
// Returned Error Types:
//
//   - ServiceUnavailableException
//     Retryable exception, indicates internal server error.
//
//   - ServiceInternalException
//     Deprecated. To be removed from the model.
//
//   - ResourceNotFoundException
//     Non-retryable exception. Attempted to make an operation on non-existing or
//     expired resource.
//
//   - RetryableException
//     Retryable exception. In general indicates internal failure that can be fixed
//     by retry.
//
//   - IllegalArgumentException
//     Non-retryable exception, indicates client error (wrong argument passed to
//     API). See exception message for details.
//
//   - ThrottlingException
//     Increased rate over throttling limits. Can be retried with exponential backoff.
//
//   - KMSInvalidKeyUsageException
//     Non-retryable exception. Indicates the KMS key usage is incorrect. See exception
//     message for details.
//
//   - AccessDeniedException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/backupstorage-2018-04-10/GetObjectMetadata
func (c *BackupStorage) GetObjectMetadata(input *GetObjectMetadataInput) (*GetObjectMetadataOutput, error) {
	req, out := c.GetObjectMetadataRequest(input)
	return out, req.Send()
}

// GetObjectMetadataWithContext is the same as GetObjectMetadata with the addition of
// the ability to pass a context and additional request options.
//
// See GetObjectMetadata for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BackupStorage) GetObjectMetadataWithContext(ctx aws.Context, input *GetObjectMetadataInput, opts ...request.Option) (*GetObjectMetadataOutput, error) {
	req, out := c.GetObjectMetadataRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListChunks = "ListChunks"

// ListChunksRequest generates a "aws/request.Request" representing the
// client's request for the ListChunks operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListChunks for more information on using the ListChunks
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListChunksRequest method.
//	req, resp := client.ListChunksRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/backupstorage-2018-04-10/ListChunks
func (c *BackupStorage) ListChunksRequest(input *ListChunksInput) (req *request.Request, output *ListChunksOutput) {
	op := &request.Operation{
		Name:       opListChunks,
		HTTPMethod: "GET",
		HTTPPath:   "/restore-jobs/{jobId}/chunks/{objectToken}/list",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListChunksInput{}
	}

	output = &ListChunksOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListChunks API operation for AWS Backup Storage.
//
// # List chunks in a given Object
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Backup Storage's
// API operation ListChunks for usage and error information.
//
// Returned Error Types:
//
//   - ServiceUnavailableException
//     Retryable exception, indicates internal server error.
//
//   - ResourceNotFoundException
//     Non-retryable exception. Attempted to make an operation on non-existing or
//     expired resource.
//
//   - ServiceInternalException
//     Deprecated. To be removed from the model.
//
//   - RetryableException
//     Retryable exception. In general indicates internal failure that can be fixed
//     by retry.
//
//   - IllegalArgumentException
//     Non-retryable exception, indicates client error (wrong argument passed to
//     API). See exception message for details.
//
//   - AccessDeniedException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/backupstorage-2018-04-10/ListChunks
func (c *BackupStorage) ListChunks(input *ListChunksInput) (*ListChunksOutput, error) {
	req, out := c.ListChunksRequest(input)
	return out, req.Send()
}

// ListChunksWithContext is the same as ListChunks with the addition of
// the ability to pass a context and additional request options.
//
// See ListChunks for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BackupStorage) ListChunksWithContext(ctx aws.Context, input *ListChunksInput, opts ...request.Option) (*ListChunksOutput, error) {
	req, out := c.ListChunksRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListChunksPages iterates over the pages of a ListChunks operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListChunks method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListChunks operation.
//	pageNum := 0
//	err := client.ListChunksPages(params,
//	    func(page *backupstorage.ListChunksOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *BackupStorage) ListChunksPages(input *ListChunksInput, fn func(*ListChunksOutput, bool) bool) error {
	return c.ListChunksPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListChunksPagesWithContext same as ListChunksPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BackupStorage) ListChunksPagesWithContext(ctx aws.Context, input *ListChunksInput, fn func(*ListChunksOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListChunksInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListChunksRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListChunksOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListObjects = "ListObjects"

// ListObjectsRequest generates a "aws/request.Request" representing the
// client's request for the ListObjects operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListObjects for more information on using the ListObjects
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListObjectsRequest method.
//	req, resp := client.ListObjectsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/backupstorage-2018-04-10/ListObjects
func (c *BackupStorage) ListObjectsRequest(input *ListObjectsInput) (req *request.Request, output *ListObjectsOutput) {
	op := &request.Operation{
		Name:       opListObjects,
		HTTPMethod: "GET",
		HTTPPath:   "/restore-jobs/{jobId}/objects/list",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListObjectsInput{}
	}

	output = &ListObjectsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListObjects API operation for AWS Backup Storage.
//
// List all Objects in a given Backup.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Backup Storage's
// API operation ListObjects for usage and error information.
//
// Returned Error Types:
//
//   - ServiceUnavailableException
//     Retryable exception, indicates internal server error.
//
//   - ServiceInternalException
//     Deprecated. To be removed from the model.
//
//   - RetryableException
//     Retryable exception. In general indicates internal failure that can be fixed
//     by retry.
//
//   - IllegalArgumentException
//     Non-retryable exception, indicates client error (wrong argument passed to
//     API). See exception message for details.
//
//   - ThrottlingException
//     Increased rate over throttling limits. Can be retried with exponential backoff.
//
//   - ResourceNotFoundException
//     Non-retryable exception. Attempted to make an operation on non-existing or
//     expired resource.
//
//   - KMSInvalidKeyUsageException
//     Non-retryable exception. Indicates the KMS key usage is incorrect. See exception
//     message for details.
//
//   - AccessDeniedException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/backupstorage-2018-04-10/ListObjects
func (c *BackupStorage) ListObjects(input *ListObjectsInput) (*ListObjectsOutput, error) {
	req, out := c.ListObjectsRequest(input)
	return out, req.Send()
}

// ListObjectsWithContext is the same as ListObjects with the addition of
// the ability to pass a context and additional request options.
//
// See ListObjects for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BackupStorage) ListObjectsWithContext(ctx aws.Context, input *ListObjectsInput, opts ...request.Option) (*ListObjectsOutput, error) {
	req, out := c.ListObjectsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListObjectsPages iterates over the pages of a ListObjects operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListObjects method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListObjects operation.
//	pageNum := 0
//	err := client.ListObjectsPages(params,
//	    func(page *backupstorage.ListObjectsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *BackupStorage) ListObjectsPages(input *ListObjectsInput, fn func(*ListObjectsOutput, bool) bool) error {
	return c.ListObjectsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListObjectsPagesWithContext same as ListObjectsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BackupStorage) ListObjectsPagesWithContext(ctx aws.Context, input *ListObjectsInput, fn func(*ListObjectsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListObjectsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListObjectsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListObjectsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opNotifyObjectComplete = "NotifyObjectComplete"

// NotifyObjectCompleteRequest generates a "aws/request.Request" representing the
// client's request for the NotifyObjectComplete operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See NotifyObjectComplete for more information on using the NotifyObjectComplete
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the NotifyObjectCompleteRequest method.
//	req, resp := client.NotifyObjectCompleteRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/backupstorage-2018-04-10/NotifyObjectComplete
func (c *BackupStorage) NotifyObjectCompleteRequest(input *NotifyObjectCompleteInput) (req *request.Request, output *NotifyObjectCompleteOutput) {
	op := &request.Operation{
		Name:       opNotifyObjectComplete,
		HTTPMethod: "PUT",
		HTTPPath:   "/backup-jobs/{jobId}/object/{uploadId}/complete",
	}

	if input == nil {
		input = &NotifyObjectCompleteInput{}
	}

	output = &NotifyObjectCompleteOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Sign.Remove(v4.SignRequestHandler)
	handler := v4.BuildNamedHandler("v4.CustomSignerHandler", v4.WithUnsignedPayload)
	req.Handlers.Sign.PushFrontNamed(handler)
	return
}

// NotifyObjectComplete API operation for AWS Backup Storage.
//
// # Complete upload
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Backup Storage's
// API operation NotifyObjectComplete for usage and error information.
//
// Returned Error Types:
//
//   - ServiceUnavailableException
//     Retryable exception, indicates internal server error.
//
//   - ServiceInternalException
//     Deprecated. To be removed from the model.
//
//   - NotReadableInputStreamException
//     Retryalble exception. Indicated issues while reading an input stream due
//     to the networking issues or connection drop on the client side.
//
//   - RetryableException
//     Retryable exception. In general indicates internal failure that can be fixed
//     by retry.
//
//   - IllegalArgumentException
//     Non-retryable exception, indicates client error (wrong argument passed to
//     API). See exception message for details.
//
//   - ThrottlingException
//     Increased rate over throttling limits. Can be retried with exponential backoff.
//
//   - KMSInvalidKeyUsageException
//     Non-retryable exception. Indicates the KMS key usage is incorrect. See exception
//     message for details.
//
//   - AccessDeniedException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/backupstorage-2018-04-10/NotifyObjectComplete
func (c *BackupStorage) NotifyObjectComplete(input *NotifyObjectCompleteInput) (*NotifyObjectCompleteOutput, error) {
	req, out := c.NotifyObjectCompleteRequest(input)
	return out, req.Send()
}

// NotifyObjectCompleteWithContext is the same as NotifyObjectComplete with the addition of
// the ability to pass a context and additional request options.
//
// See NotifyObjectComplete for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BackupStorage) NotifyObjectCompleteWithContext(ctx aws.Context, input *NotifyObjectCompleteInput, opts ...request.Option) (*NotifyObjectCompleteOutput, error) {
	req, out := c.NotifyObjectCompleteRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutChunk = "PutChunk"

// PutChunkRequest generates a "aws/request.Request" representing the
// client's request for the PutChunk operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutChunk for more information on using the PutChunk
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PutChunkRequest method.
//	req, resp := client.PutChunkRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/backupstorage-2018-04-10/PutChunk
func (c *BackupStorage) PutChunkRequest(input *PutChunkInput) (req *request.Request, output *PutChunkOutput) {
	op := &request.Operation{
		Name:       opPutChunk,
		HTTPMethod: "PUT",
		HTTPPath:   "/backup-jobs/{jobId}/chunk/{uploadId}/{chunkIndex}",
	}

	if input == nil {
		input = &PutChunkInput{}
	}

	output = &PutChunkOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Sign.Remove(v4.SignRequestHandler)
	handler := v4.BuildNamedHandler("v4.CustomSignerHandler", v4.WithUnsignedPayload)
	req.Handlers.Sign.PushFrontNamed(handler)
	return
}

// PutChunk API operation for AWS Backup Storage.
//
// Upload chunk.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Backup Storage's
// API operation PutChunk for usage and error information.
//
// Returned Error Types:
//
//   - ServiceUnavailableException
//     Retryable exception, indicates internal server error.
//
//   - ServiceInternalException
//     Deprecated. To be removed from the model.
//
//   - NotReadableInputStreamException
//     Retryalble exception. Indicated issues while reading an input stream due
//     to the networking issues or connection drop on the client side.
//
//   - RetryableException
//     Retryable exception. In general indicates internal failure that can be fixed
//     by retry.
//
//   - IllegalArgumentException
//     Non-retryable exception, indicates client error (wrong argument passed to
//     API). See exception message for details.
//
//   - ThrottlingException
//     Increased rate over throttling limits. Can be retried with exponential backoff.
//
//   - KMSInvalidKeyUsageException
//     Non-retryable exception. Indicates the KMS key usage is incorrect. See exception
//     message for details.
//
//   - AccessDeniedException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/backupstorage-2018-04-10/PutChunk
func (c *BackupStorage) PutChunk(input *PutChunkInput) (*PutChunkOutput, error) {
	req, out := c.PutChunkRequest(input)
	return out, req.Send()
}

// PutChunkWithContext is the same as PutChunk with the addition of
// the ability to pass a context and additional request options.
//
// See PutChunk for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BackupStorage) PutChunkWithContext(ctx aws.Context, input *PutChunkInput, opts ...request.Option) (*PutChunkOutput, error) {
	req, out := c.PutChunkRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutObject = "PutObject"

// PutObjectRequest generates a "aws/request.Request" representing the
// client's request for the PutObject operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutObject for more information on using the PutObject
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PutObjectRequest method.
//	req, resp := client.PutObjectRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/backupstorage-2018-04-10/PutObject
func (c *BackupStorage) PutObjectRequest(input *PutObjectInput) (req *request.Request, output *PutObjectOutput) {
	op := &request.Operation{
		Name:       opPutObject,
		HTTPMethod: "PUT",
		HTTPPath:   "/backup-jobs/{jobId}/object/{objectName}/put-object",
	}

	if input == nil {
		input = &PutObjectInput{}
	}

	output = &PutObjectOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Sign.Remove(v4.SignRequestHandler)
	handler := v4.BuildNamedHandler("v4.CustomSignerHandler", v4.WithUnsignedPayload)
	req.Handlers.Sign.PushFrontNamed(handler)
	return
}

// PutObject API operation for AWS Backup Storage.
//
// Upload object that can store object metadata String and data blob in single
// API call using inline chunk field.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Backup Storage's
// API operation PutObject for usage and error information.
//
// Returned Error Types:
//
//   - ServiceUnavailableException
//     Retryable exception, indicates internal server error.
//
//   - ServiceInternalException
//     Deprecated. To be removed from the model.
//
//   - NotReadableInputStreamException
//     Retryalble exception. Indicated issues while reading an input stream due
//     to the networking issues or connection drop on the client side.
//
//   - RetryableException
//     Retryable exception. In general indicates internal failure that can be fixed
//     by retry.
//
//   - IllegalArgumentException
//     Non-retryable exception, indicates client error (wrong argument passed to
//     API). See exception message for details.
//
//   - ThrottlingException
//     Increased rate over throttling limits. Can be retried with exponential backoff.
//
//   - KMSInvalidKeyUsageException
//     Non-retryable exception. Indicates the KMS key usage is incorrect. See exception
//     message for details.
//
//   - AccessDeniedException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/backupstorage-2018-04-10/PutObject
func (c *BackupStorage) PutObject(input *PutObjectInput) (*PutObjectOutput, error) {
	req, out := c.PutObjectRequest(input)
	return out, req.Send()
}

// PutObjectWithContext is the same as PutObject with the addition of
// the ability to pass a context and additional request options.
//
// See PutObject for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BackupStorage) PutObjectWithContext(ctx aws.Context, input *PutObjectInput, opts ...request.Option) (*PutObjectOutput, error) {
	req, out := c.PutObjectRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartObject = "StartObject"

// StartObjectRequest generates a "aws/request.Request" representing the
// client's request for the StartObject operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartObject for more information on using the StartObject
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StartObjectRequest method.
//	req, resp := client.StartObjectRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/backupstorage-2018-04-10/StartObject
func (c *BackupStorage) StartObjectRequest(input *StartObjectInput) (req *request.Request, output *StartObjectOutput) {
	op := &request.Operation{
		Name:       opStartObject,
		HTTPMethod: "PUT",
		HTTPPath:   "/backup-jobs/{jobId}/object/{objectName}",
	}

	if input == nil {
		input = &StartObjectInput{}
	}

	output = &StartObjectOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartObject API operation for AWS Backup Storage.
//
// Start upload containing one or many chunks.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Backup Storage's
// API operation StartObject for usage and error information.
//
// Returned Error Types:
//
//   - ServiceUnavailableException
//     Retryable exception, indicates internal server error.
//
//   - ServiceInternalException
//     Deprecated. To be removed from the model.
//
//   - RetryableException
//     Retryable exception. In general indicates internal failure that can be fixed
//     by retry.
//
//   - IllegalArgumentException
//     Non-retryable exception, indicates client error (wrong argument passed to
//     API). See exception message for details.
//
//   - ResourceNotFoundException
//     Non-retryable exception. Attempted to make an operation on non-existing or
//     expired resource.
//
//   - DataAlreadyExistsException
//     Non-retryable exception. Attempted to create already existing object or chunk.
//     This message contains a checksum of already presented data.
//
//   - ThrottlingException
//     Increased rate over throttling limits. Can be retried with exponential backoff.
//
//   - AccessDeniedException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/backupstorage-2018-04-10/StartObject
func (c *BackupStorage) StartObject(input *StartObjectInput) (*StartObjectOutput, error) {
	req, out := c.StartObjectRequest(input)
	return out, req.Send()
}

// StartObjectWithContext is the same as StartObject with the addition of
// the ability to pass a context and additional request options.
//
// See StartObject for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BackupStorage) StartObjectWithContext(ctx aws.Context, input *StartObjectInput, opts ...request.Option) (*StartObjectOutput, error) {
	req, out := c.StartObjectRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type AccessDeniedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) GoString() string {
	return s.String()
}

func newErrorAccessDeniedException(v protocol.ResponseMetadata) error {
	return &AccessDeniedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AccessDeniedException) Code() string {
	return "AccessDeniedException"
}

// Message returns the exception's message.
func (s *AccessDeniedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AccessDeniedException) OrigErr() error {
	return nil
}

func (s *AccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AccessDeniedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AccessDeniedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Object
type BackupObject struct {
	_ struct{} `type:"structure"`

	// Number of chunks in object
	ChunksCount *int64 `type:"long"`

	// Metadata string associated with the Object
	MetadataString *string `type:"string"`

	// Object name
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// Object checksum
	//
	// ObjectChecksum is a required field
	ObjectChecksum *string `type:"string" required:"true"`

	// Checksum algorithm
	//
	// ObjectChecksumAlgorithm is a required field
	ObjectChecksumAlgorithm *string `type:"string" required:"true" enum:"SummaryChecksumAlgorithm"`

	// Object token
	//
	// ObjectToken is a required field
	ObjectToken *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BackupObject) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BackupObject) GoString() string {
	return s.String()
}

// SetChunksCount sets the ChunksCount field's value.
func (s *BackupObject) SetChunksCount(v int64) *BackupObject {
	s.ChunksCount = &v
	return s
}

// SetMetadataString sets the MetadataString field's value.
func (s *BackupObject) SetMetadataString(v string) *BackupObject {
	s.MetadataString = &v
	return s
}

// SetName sets the Name field's value.
func (s *BackupObject) SetName(v string) *BackupObject {
	s.Name = &v
	return s
}

// SetObjectChecksum sets the ObjectChecksum field's value.
func (s *BackupObject) SetObjectChecksum(v string) *BackupObject {
	s.ObjectChecksum = &v
	return s
}

// SetObjectChecksumAlgorithm sets the ObjectChecksumAlgorithm field's value.
func (s *BackupObject) SetObjectChecksumAlgorithm(v string) *BackupObject {
	s.ObjectChecksumAlgorithm = &v
	return s
}

// SetObjectToken sets the ObjectToken field's value.
func (s *BackupObject) SetObjectToken(v string) *BackupObject {
	s.ObjectToken = &v
	return s
}

// Chunk
type Chunk struct {
	_ struct{} `type:"structure"`

	// Chunk checksum
	//
	// Checksum is a required field
	Checksum *string `type:"string" required:"true"`

	// Checksum algorithm
	//
	// ChecksumAlgorithm is a required field
	ChecksumAlgorithm *string `type:"string" required:"true" enum:"DataChecksumAlgorithm"`

	// Chunk token
	//
	// ChunkToken is a required field
	ChunkToken *string `type:"string" required:"true"`

	// Chunk index
	//
	// Index is a required field
	Index *int64 `type:"long" required:"true"`

	// Chunk length
	//
	// Length is a required field
	Length *int64 `type:"long" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Chunk) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Chunk) GoString() string {
	return s.String()
}

// SetChecksum sets the Checksum field's value.
func (s *Chunk) SetChecksum(v string) *Chunk {
	s.Checksum = &v
	return s
}

// SetChecksumAlgorithm sets the ChecksumAlgorithm field's value.
func (s *Chunk) SetChecksumAlgorithm(v string) *Chunk {
	s.ChecksumAlgorithm = &v
	return s
}

// SetChunkToken sets the ChunkToken field's value.
func (s *Chunk) SetChunkToken(v string) *Chunk {
	s.ChunkToken = &v
	return s
}

// SetIndex sets the Index field's value.
func (s *Chunk) SetIndex(v int64) *Chunk {
	s.Index = &v
	return s
}

// SetLength sets the Length field's value.
func (s *Chunk) SetLength(v int64) *Chunk {
	s.Length = &v
	return s
}

// Non-retryable exception. Attempted to create already existing object or chunk.
// This message contains a checksum of already presented data.
type DataAlreadyExistsException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// Data checksum used
	Checksum *string `type:"string"`

	// Checksum algorithm used
	ChecksumAlgorithm *string `type:"string"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataAlreadyExistsException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataAlreadyExistsException) GoString() string {
	return s.String()
}

func newErrorDataAlreadyExistsException(v protocol.ResponseMetadata) error {
	return &DataAlreadyExistsException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *DataAlreadyExistsException) Code() string {
	return "DataAlreadyExistsException"
}

// Message returns the exception's message.
func (s *DataAlreadyExistsException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *DataAlreadyExistsException) OrigErr() error {
	return nil
}

func (s *DataAlreadyExistsException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *DataAlreadyExistsException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *DataAlreadyExistsException) RequestID() string {
	return s.RespMetadata.RequestID
}

type DeleteObjectInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// Backup job Id for the in-progress backup.
	//
	// BackupJobId is a required field
	BackupJobId *string `location:"uri" locationName:"jobId" type:"string" required:"true"`

	// The name of the Object.
	//
	// ObjectName is a required field
	ObjectName *string `location:"uri" locationName:"objectName" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteObjectInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteObjectInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteObjectInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteObjectInput"}
	if s.BackupJobId == nil {
		invalidParams.Add(request.NewErrParamRequired("BackupJobId"))
	}
	if s.BackupJobId != nil && len(*s.BackupJobId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BackupJobId", 1))
	}
	if s.ObjectName == nil {
		invalidParams.Add(request.NewErrParamRequired("ObjectName"))
	}
	if s.ObjectName != nil && len(*s.ObjectName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ObjectName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBackupJobId sets the BackupJobId field's value.
func (s *DeleteObjectInput) SetBackupJobId(v string) *DeleteObjectInput {
	s.BackupJobId = &v
	return s
}

// SetObjectName sets the ObjectName field's value.
func (s *DeleteObjectInput) SetObjectName(v string) *DeleteObjectInput {
	s.ObjectName = &v
	return s
}

type DeleteObjectOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteObjectOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteObjectOutput) GoString() string {
	return s.String()
}

type GetChunkInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// Chunk token
	//
	// ChunkToken is a required field
	ChunkToken *string `location:"uri" locationName:"chunkToken" type:"string" required:"true"`

	// Storage job id
	//
	// StorageJobId is a required field
	StorageJobId *string `location:"uri" locationName:"jobId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetChunkInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetChunkInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetChunkInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetChunkInput"}
	if s.ChunkToken == nil {
		invalidParams.Add(request.NewErrParamRequired("ChunkToken"))
	}
	if s.ChunkToken != nil && len(*s.ChunkToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ChunkToken", 1))
	}
	if s.StorageJobId == nil {
		invalidParams.Add(request.NewErrParamRequired("StorageJobId"))
	}
	if s.StorageJobId != nil && len(*s.StorageJobId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StorageJobId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChunkToken sets the ChunkToken field's value.
func (s *GetChunkInput) SetChunkToken(v string) *GetChunkInput {
	s.ChunkToken = &v
	return s
}

// SetStorageJobId sets the StorageJobId field's value.
func (s *GetChunkInput) SetStorageJobId(v string) *GetChunkInput {
	s.StorageJobId = &v
	return s
}

type GetChunkOutput struct {
	_ struct{} `type:"structure" payload:"Data"`

	// Data checksum
	//
	// Checksum is a required field
	Checksum *string `location:"header" locationName:"x-amz-checksum" type:"string" required:"true"`

	// Checksum algorithm
	//
	// ChecksumAlgorithm is a required field
	ChecksumAlgorithm *string `location:"header" locationName:"x-amz-checksum-algorithm" type:"string" required:"true" enum:"DataChecksumAlgorithm"`

	// Chunk data
	//
	// Data is a required field
	Data io.ReadCloser `type:"blob" required:"true"`

	// Data length
	//
	// Length is a required field
	Length *int64 `location:"header" locationName:"x-amz-data-length" type:"long" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetChunkOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetChunkOutput) GoString() string {
	return s.String()
}

// SetChecksum sets the Checksum field's value.
func (s *GetChunkOutput) SetChecksum(v string) *GetChunkOutput {
	s.Checksum = &v
	return s
}

// SetChecksumAlgorithm sets the ChecksumAlgorithm field's value.
func (s *GetChunkOutput) SetChecksumAlgorithm(v string) *GetChunkOutput {
	s.ChecksumAlgorithm = &v
	return s
}

// SetData sets the Data field's value.
func (s *GetChunkOutput) SetData(v io.ReadCloser) *GetChunkOutput {
	s.Data = v
	return s
}

// SetLength sets the Length field's value.
func (s *GetChunkOutput) SetLength(v int64) *GetChunkOutput {
	s.Length = &v
	return s
}

type GetObjectMetadataInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// Object token.
	//
	// ObjectToken is a required field
	ObjectToken *string `location:"uri" locationName:"objectToken" type:"string" required:"true"`

	// Backup job id for the in-progress backup.
	//
	// StorageJobId is a required field
	StorageJobId *string `location:"uri" locationName:"jobId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetObjectMetadataInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetObjectMetadataInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetObjectMetadataInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetObjectMetadataInput"}
	if s.ObjectToken == nil {
		invalidParams.Add(request.NewErrParamRequired("ObjectToken"))
	}
	if s.ObjectToken != nil && len(*s.ObjectToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ObjectToken", 1))
	}
	if s.StorageJobId == nil {
		invalidParams.Add(request.NewErrParamRequired("StorageJobId"))
	}
	if s.StorageJobId != nil && len(*s.StorageJobId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StorageJobId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetObjectToken sets the ObjectToken field's value.
func (s *GetObjectMetadataInput) SetObjectToken(v string) *GetObjectMetadataInput {
	s.ObjectToken = &v
	return s
}

// SetStorageJobId sets the StorageJobId field's value.
func (s *GetObjectMetadataInput) SetStorageJobId(v string) *GetObjectMetadataInput {
	s.StorageJobId = &v
	return s
}

type GetObjectMetadataOutput struct {
	_ struct{} `type:"structure" payload:"MetadataBlob"`

	// Metadata blob.
	MetadataBlob io.ReadCloser `type:"blob"`

	// MetadataBlob checksum.
	MetadataBlobChecksum *string `location:"header" locationName:"x-amz-checksum" type:"string"`

	// Checksum algorithm.
	MetadataBlobChecksumAlgorithm *string `location:"header" locationName:"x-amz-checksum-algorithm" type:"string" enum:"DataChecksumAlgorithm"`

	// The size of MetadataBlob.
	MetadataBlobLength *int64 `location:"header" locationName:"x-amz-data-length" type:"long"`

	// Metadata string.
	MetadataString *string `location:"header" locationName:"x-amz-metadata-string" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetObjectMetadataOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetObjectMetadataOutput) GoString() string {
	return s.String()
}

// SetMetadataBlob sets the MetadataBlob field's value.
func (s *GetObjectMetadataOutput) SetMetadataBlob(v io.ReadCloser) *GetObjectMetadataOutput {
	s.MetadataBlob = v
	return s
}

// SetMetadataBlobChecksum sets the MetadataBlobChecksum field's value.
func (s *GetObjectMetadataOutput) SetMetadataBlobChecksum(v string) *GetObjectMetadataOutput {
	s.MetadataBlobChecksum = &v
	return s
}

// SetMetadataBlobChecksumAlgorithm sets the MetadataBlobChecksumAlgorithm field's value.
func (s *GetObjectMetadataOutput) SetMetadataBlobChecksumAlgorithm(v string) *GetObjectMetadataOutput {
	s.MetadataBlobChecksumAlgorithm = &v
	return s
}

// SetMetadataBlobLength sets the MetadataBlobLength field's value.
func (s *GetObjectMetadataOutput) SetMetadataBlobLength(v int64) *GetObjectMetadataOutput {
	s.MetadataBlobLength = &v
	return s
}

// SetMetadataString sets the MetadataString field's value.
func (s *GetObjectMetadataOutput) SetMetadataString(v string) *GetObjectMetadataOutput {
	s.MetadataString = &v
	return s
}

// Non-retryable exception, indicates client error (wrong argument passed to
// API). See exception message for details.
type IllegalArgumentException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IllegalArgumentException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IllegalArgumentException) GoString() string {
	return s.String()
}

func newErrorIllegalArgumentException(v protocol.ResponseMetadata) error {
	return &IllegalArgumentException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *IllegalArgumentException) Code() string {
	return "IllegalArgumentException"
}

// Message returns the exception's message.
func (s *IllegalArgumentException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *IllegalArgumentException) OrigErr() error {
	return nil
}

func (s *IllegalArgumentException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *IllegalArgumentException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *IllegalArgumentException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Non-retryable exception. Indicates the KMS key usage is incorrect. See exception
// message for details.
type KMSInvalidKeyUsageException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KMSInvalidKeyUsageException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KMSInvalidKeyUsageException) GoString() string {
	return s.String()
}

func newErrorKMSInvalidKeyUsageException(v protocol.ResponseMetadata) error {
	return &KMSInvalidKeyUsageException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *KMSInvalidKeyUsageException) Code() string {
	return "KMSInvalidKeyUsageException"
}

// Message returns the exception's message.
func (s *KMSInvalidKeyUsageException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *KMSInvalidKeyUsageException) OrigErr() error {
	return nil
}

func (s *KMSInvalidKeyUsageException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *KMSInvalidKeyUsageException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *KMSInvalidKeyUsageException) RequestID() string {
	return s.RespMetadata.RequestID
}

type ListChunksInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// Maximum number of chunks
	MaxResults *int64 `location:"querystring" locationName:"max-results" min:"1" type:"integer"`

	// Pagination token
	NextToken *string `location:"querystring" locationName:"next-token" type:"string"`

	// Object token
	//
	// ObjectToken is a required field
	ObjectToken *string `location:"uri" locationName:"objectToken" type:"string" required:"true"`

	// Storage job id
	//
	// StorageJobId is a required field
	StorageJobId *string `location:"uri" locationName:"jobId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListChunksInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListChunksInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListChunksInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListChunksInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.ObjectToken == nil {
		invalidParams.Add(request.NewErrParamRequired("ObjectToken"))
	}
	if s.ObjectToken != nil && len(*s.ObjectToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ObjectToken", 1))
	}
	if s.StorageJobId == nil {
		invalidParams.Add(request.NewErrParamRequired("StorageJobId"))
	}
	if s.StorageJobId != nil && len(*s.StorageJobId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StorageJobId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListChunksInput) SetMaxResults(v int64) *ListChunksInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListChunksInput) SetNextToken(v string) *ListChunksInput {
	s.NextToken = &v
	return s
}

// SetObjectToken sets the ObjectToken field's value.
func (s *ListChunksInput) SetObjectToken(v string) *ListChunksInput {
	s.ObjectToken = &v
	return s
}

// SetStorageJobId sets the StorageJobId field's value.
func (s *ListChunksInput) SetStorageJobId(v string) *ListChunksInput {
	s.StorageJobId = &v
	return s
}

type ListChunksOutput struct {
	_ struct{} `type:"structure"`

	// List of chunks
	//
	// ChunkList is a required field
	ChunkList []*Chunk `type:"list" required:"true"`

	// Pagination token
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListChunksOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListChunksOutput) GoString() string {
	return s.String()
}

// SetChunkList sets the ChunkList field's value.
func (s *ListChunksOutput) SetChunkList(v []*Chunk) *ListChunksOutput {
	s.ChunkList = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListChunksOutput) SetNextToken(v string) *ListChunksOutput {
	s.NextToken = &v
	return s
}

type ListObjectsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// (Optional) Created after filter
	CreatedAfter *time.Time `location:"querystring" locationName:"created-after" type:"timestamp"`

	// (Optional) Created before filter
	CreatedBefore *time.Time `location:"querystring" locationName:"created-before" type:"timestamp"`

	// Maximum objects count
	MaxResults *int64 `location:"querystring" locationName:"max-results" min:"1" type:"integer"`

	// Pagination token
	NextToken *string `location:"querystring" locationName:"next-token" type:"string"`

	// Optional, specifies the starting Object name to list from. Ignored if NextToken
	// is not NULL
	StartingObjectName *string `location:"querystring" locationName:"starting-object-name" type:"string"`

	// Optional, specifies the starting Object prefix to list from. Ignored if NextToken
	// is not NULL
	StartingObjectPrefix *string `location:"querystring" locationName:"starting-object-prefix" type:"string"`

	// Storage job id
	//
	// StorageJobId is a required field
	StorageJobId *string `location:"uri" locationName:"jobId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListObjectsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListObjectsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListObjectsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListObjectsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.StorageJobId == nil {
		invalidParams.Add(request.NewErrParamRequired("StorageJobId"))
	}
	if s.StorageJobId != nil && len(*s.StorageJobId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StorageJobId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCreatedAfter sets the CreatedAfter field's value.
func (s *ListObjectsInput) SetCreatedAfter(v time.Time) *ListObjectsInput {
	s.CreatedAfter = &v
	return s
}

// SetCreatedBefore sets the CreatedBefore field's value.
func (s *ListObjectsInput) SetCreatedBefore(v time.Time) *ListObjectsInput {
	s.CreatedBefore = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListObjectsInput) SetMaxResults(v int64) *ListObjectsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListObjectsInput) SetNextToken(v string) *ListObjectsInput {
	s.NextToken = &v
	return s
}

// SetStartingObjectName sets the StartingObjectName field's value.
func (s *ListObjectsInput) SetStartingObjectName(v string) *ListObjectsInput {
	s.StartingObjectName = &v
	return s
}

// SetStartingObjectPrefix sets the StartingObjectPrefix field's value.
func (s *ListObjectsInput) SetStartingObjectPrefix(v string) *ListObjectsInput {
	s.StartingObjectPrefix = &v
	return s
}

// SetStorageJobId sets the StorageJobId field's value.
func (s *ListObjectsInput) SetStorageJobId(v string) *ListObjectsInput {
	s.StorageJobId = &v
	return s
}

type ListObjectsOutput struct {
	_ struct{} `type:"structure"`

	// Pagination token
	NextToken *string `type:"string"`

	// Object list
	//
	// ObjectList is a required field
	ObjectList []*BackupObject `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListObjectsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListObjectsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListObjectsOutput) SetNextToken(v string) *ListObjectsOutput {
	s.NextToken = &v
	return s
}

// SetObjectList sets the ObjectList field's value.
func (s *ListObjectsOutput) SetObjectList(v []*BackupObject) *ListObjectsOutput {
	s.ObjectList = v
	return s
}

// Retryalble exception. Indicated issues while reading an input stream due
// to the networking issues or connection drop on the client side.
type NotReadableInputStreamException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NotReadableInputStreamException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NotReadableInputStreamException) GoString() string {
	return s.String()
}

func newErrorNotReadableInputStreamException(v protocol.ResponseMetadata) error {
	return &NotReadableInputStreamException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *NotReadableInputStreamException) Code() string {
	return "NotReadableInputStreamException"
}

// Message returns the exception's message.
func (s *NotReadableInputStreamException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *NotReadableInputStreamException) OrigErr() error {
	return nil
}

func (s *NotReadableInputStreamException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *NotReadableInputStreamException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *NotReadableInputStreamException) RequestID() string {
	return s.RespMetadata.RequestID
}

type NotifyObjectCompleteInput struct {
	_ struct{} `type:"structure" payload:"MetadataBlob"`

	// Backup job Id for the in-progress backup
	//
	// BackupJobId is a required field
	BackupJobId *string `location:"uri" locationName:"jobId" type:"string" required:"true"`

	// Optional metadata associated with an Object. Maximum length is 4MB.
	//
	// To use an non-seekable io.Reader for this request wrap the io.Reader with
	// "aws.ReadSeekCloser". The SDK will not retry request errors for non-seekable
	// readers. This will allow the SDK to send the reader's payload as chunked
	// transfer encoding.
	MetadataBlob io.ReadSeeker `type:"blob"`

	// Checksum of MetadataBlob.
	MetadataBlobChecksum *string `location:"querystring" locationName:"metadata-checksum" type:"string"`

	// Checksum algorithm.
	MetadataBlobChecksumAlgorithm *string `location:"querystring" locationName:"metadata-checksum-algorithm" type:"string" enum:"DataChecksumAlgorithm"`

	// The size of MetadataBlob.
	MetadataBlobLength *int64 `location:"querystring" locationName:"metadata-blob-length" type:"long"`

	// Optional metadata associated with an Object. Maximum string length is 256
	// bytes.
	MetadataString *string `location:"querystring" locationName:"metadata-string" type:"string"`

	// Object checksum
	//
	// ObjectChecksum is a required field
	ObjectChecksum *string `location:"querystring" locationName:"checksum" type:"string" required:"true"`

	// Checksum algorithm
	//
	// ObjectChecksumAlgorithm is a required field
	ObjectChecksumAlgorithm *string `location:"querystring" locationName:"checksum-algorithm" type:"string" required:"true" enum:"SummaryChecksumAlgorithm"`

	// Upload Id for the in-progress upload
	//
	// UploadId is a required field
	UploadId *string `location:"uri" locationName:"uploadId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NotifyObjectCompleteInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NotifyObjectCompleteInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *NotifyObjectCompleteInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "NotifyObjectCompleteInput"}
	if s.BackupJobId == nil {
		invalidParams.Add(request.NewErrParamRequired("BackupJobId"))
	}
	if s.BackupJobId != nil && len(*s.BackupJobId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BackupJobId", 1))
	}
	if s.ObjectChecksum == nil {
		invalidParams.Add(request.NewErrParamRequired("ObjectChecksum"))
	}
	if s.ObjectChecksumAlgorithm == nil {
		invalidParams.Add(request.NewErrParamRequired("ObjectChecksumAlgorithm"))
	}
	if s.UploadId == nil {
		invalidParams.Add(request.NewErrParamRequired("UploadId"))
	}
	if s.UploadId != nil && len(*s.UploadId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UploadId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBackupJobId sets the BackupJobId field's value.
func (s *NotifyObjectCompleteInput) SetBackupJobId(v string) *NotifyObjectCompleteInput {
	s.BackupJobId = &v
	return s
}

// SetMetadataBlob sets the MetadataBlob field's value.
func (s *NotifyObjectCompleteInput) SetMetadataBlob(v io.ReadSeeker) *NotifyObjectCompleteInput {
	s.MetadataBlob = v
	return s
}

// SetMetadataBlobChecksum sets the MetadataBlobChecksum field's value.
func (s *NotifyObjectCompleteInput) SetMetadataBlobChecksum(v string) *NotifyObjectCompleteInput {
	s.MetadataBlobChecksum = &v
	return s
}

// SetMetadataBlobChecksumAlgorithm sets the MetadataBlobChecksumAlgorithm field's value.
func (s *NotifyObjectCompleteInput) SetMetadataBlobChecksumAlgorithm(v string) *NotifyObjectCompleteInput {
	s.MetadataBlobChecksumAlgorithm = &v
	return s
}

// SetMetadataBlobLength sets the MetadataBlobLength field's value.
func (s *NotifyObjectCompleteInput) SetMetadataBlobLength(v int64) *NotifyObjectCompleteInput {
	s.MetadataBlobLength = &v
	return s
}

// SetMetadataString sets the MetadataString field's value.
func (s *NotifyObjectCompleteInput) SetMetadataString(v string) *NotifyObjectCompleteInput {
	s.MetadataString = &v
	return s
}

// SetObjectChecksum sets the ObjectChecksum field's value.
func (s *NotifyObjectCompleteInput) SetObjectChecksum(v string) *NotifyObjectCompleteInput {
	s.ObjectChecksum = &v
	return s
}

// SetObjectChecksumAlgorithm sets the ObjectChecksumAlgorithm field's value.
func (s *NotifyObjectCompleteInput) SetObjectChecksumAlgorithm(v string) *NotifyObjectCompleteInput {
	s.ObjectChecksumAlgorithm = &v
	return s
}

// SetUploadId sets the UploadId field's value.
func (s *NotifyObjectCompleteInput) SetUploadId(v string) *NotifyObjectCompleteInput {
	s.UploadId = &v
	return s
}

type NotifyObjectCompleteOutput struct {
	_ struct{} `type:"structure"`

	// Object checksum
	//
	// ObjectChecksum is a required field
	ObjectChecksum *string `type:"string" required:"true"`

	// Checksum algorithm
	//
	// ObjectChecksumAlgorithm is a required field
	ObjectChecksumAlgorithm *string `type:"string" required:"true" enum:"SummaryChecksumAlgorithm"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NotifyObjectCompleteOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NotifyObjectCompleteOutput) GoString() string {
	return s.String()
}

// SetObjectChecksum sets the ObjectChecksum field's value.
func (s *NotifyObjectCompleteOutput) SetObjectChecksum(v string) *NotifyObjectCompleteOutput {
	s.ObjectChecksum = &v
	return s
}

// SetObjectChecksumAlgorithm sets the ObjectChecksumAlgorithm field's value.
func (s *NotifyObjectCompleteOutput) SetObjectChecksumAlgorithm(v string) *NotifyObjectCompleteOutput {
	s.ObjectChecksumAlgorithm = &v
	return s
}

type PutChunkInput struct {
	_ struct{} `type:"structure" payload:"Data"`

	// Backup job Id for the in-progress backup.
	//
	// BackupJobId is a required field
	BackupJobId *string `location:"uri" locationName:"jobId" type:"string" required:"true"`

	// Data checksum
	//
	// Checksum is a required field
	Checksum *string `location:"querystring" locationName:"checksum" type:"string" required:"true"`

	// Checksum algorithm
	//
	// ChecksumAlgorithm is a required field
	ChecksumAlgorithm *string `location:"querystring" locationName:"checksum-algorithm" type:"string" required:"true" enum:"DataChecksumAlgorithm"`

	// Describes this chunk's position relative to the other chunks
	//
	// ChunkIndex is a required field
	ChunkIndex *int64 `location:"uri" locationName:"chunkIndex" type:"long" required:"true"`

	// Data to be uploaded
	//
	// To use an non-seekable io.Reader for this request wrap the io.Reader with
	// "aws.ReadSeekCloser". The SDK will not retry request errors for non-seekable
	// readers. This will allow the SDK to send the reader's payload as chunked
	// transfer encoding.
	//
	// Data is a required field
	Data io.ReadSeeker `type:"blob" required:"true"`

	// Data length
	//
	// Length is a required field
	Length *int64 `location:"querystring" locationName:"length" type:"long" required:"true"`

	// Upload Id for the in-progress upload.
	//
	// UploadId is a required field
	UploadId *string `location:"uri" locationName:"uploadId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutChunkInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutChunkInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutChunkInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutChunkInput"}
	if s.BackupJobId == nil {
		invalidParams.Add(request.NewErrParamRequired("BackupJobId"))
	}
	if s.BackupJobId != nil && len(*s.BackupJobId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BackupJobId", 1))
	}
	if s.Checksum == nil {
		invalidParams.Add(request.NewErrParamRequired("Checksum"))
	}
	if s.ChecksumAlgorithm == nil {
		invalidParams.Add(request.NewErrParamRequired("ChecksumAlgorithm"))
	}
	if s.ChunkIndex == nil {
		invalidParams.Add(request.NewErrParamRequired("ChunkIndex"))
	}
	if s.Data == nil {
		invalidParams.Add(request.NewErrParamRequired("Data"))
	}
	if s.Length == nil {
		invalidParams.Add(request.NewErrParamRequired("Length"))
	}
	if s.UploadId == nil {
		invalidParams.Add(request.NewErrParamRequired("UploadId"))
	}
	if s.UploadId != nil && len(*s.UploadId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UploadId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBackupJobId sets the BackupJobId field's value.
func (s *PutChunkInput) SetBackupJobId(v string) *PutChunkInput {
	s.BackupJobId = &v
	return s
}

// SetChecksum sets the Checksum field's value.
func (s *PutChunkInput) SetChecksum(v string) *PutChunkInput {
	s.Checksum = &v
	return s
}

// SetChecksumAlgorithm sets the ChecksumAlgorithm field's value.
func (s *PutChunkInput) SetChecksumAlgorithm(v string) *PutChunkInput {
	s.ChecksumAlgorithm = &v
	return s
}

// SetChunkIndex sets the ChunkIndex field's value.
func (s *PutChunkInput) SetChunkIndex(v int64) *PutChunkInput {
	s.ChunkIndex = &v
	return s
}

// SetData sets the Data field's value.
func (s *PutChunkInput) SetData(v io.ReadSeeker) *PutChunkInput {
	s.Data = v
	return s
}

// SetLength sets the Length field's value.
func (s *PutChunkInput) SetLength(v int64) *PutChunkInput {
	s.Length = &v
	return s
}

// SetUploadId sets the UploadId field's value.
func (s *PutChunkInput) SetUploadId(v string) *PutChunkInput {
	s.UploadId = &v
	return s
}

type PutChunkOutput struct {
	_ struct{} `type:"structure"`

	// Chunk checksum
	//
	// ChunkChecksum is a required field
	ChunkChecksum *string `type:"string" required:"true"`

	// Checksum algorithm
	//
	// ChunkChecksumAlgorithm is a required field
	ChunkChecksumAlgorithm *string `type:"string" required:"true" enum:"DataChecksumAlgorithm"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutChunkOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutChunkOutput) GoString() string {
	return s.String()
}

// SetChunkChecksum sets the ChunkChecksum field's value.
func (s *PutChunkOutput) SetChunkChecksum(v string) *PutChunkOutput {
	s.ChunkChecksum = &v
	return s
}

// SetChunkChecksumAlgorithm sets the ChunkChecksumAlgorithm field's value.
func (s *PutChunkOutput) SetChunkChecksumAlgorithm(v string) *PutChunkOutput {
	s.ChunkChecksumAlgorithm = &v
	return s
}

type PutObjectInput struct {
	_ struct{} `type:"structure" payload:"InlineChunk"`

	// Backup job Id for the in-progress backup.
	//
	// BackupJobId is a required field
	BackupJobId *string `location:"uri" locationName:"jobId" type:"string" required:"true"`

	// Inline chunk data to be uploaded.
	//
	// To use an non-seekable io.Reader for this request wrap the io.Reader with
	// "aws.ReadSeekCloser". The SDK will not retry request errors for non-seekable
	// readers. This will allow the SDK to send the reader's payload as chunked
	// transfer encoding.
	InlineChunk io.ReadSeeker `type:"blob"`

	// Inline chunk checksum
	InlineChunkChecksum *string `location:"querystring" locationName:"checksum" type:"string"`

	// Inline chunk checksum algorithm
	InlineChunkChecksumAlgorithm *string `location:"querystring" locationName:"checksum-algorithm" type:"string"`

	// Length of the inline chunk data.
	InlineChunkLength *int64 `location:"querystring" locationName:"length" type:"long"`

	// Store user defined metadata like backup checksum, disk ids, restore metadata
	// etc.
	MetadataString *string `location:"querystring" locationName:"metadata-string" type:"string"`

	// object checksum
	ObjectChecksum *string `location:"querystring" locationName:"object-checksum" type:"string"`

	// object checksum algorithm
	ObjectChecksumAlgorithm *string `location:"querystring" locationName:"object-checksum-algorithm" type:"string" enum:"SummaryChecksumAlgorithm"`

	// The name of the Object to be uploaded.
	//
	// ObjectName is a required field
	ObjectName *string `location:"uri" locationName:"objectName" type:"string" required:"true"`

	// Throw an exception if Object name is already exist.
	ThrowOnDuplicate *bool `location:"querystring" locationName:"throwOnDuplicate" type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutObjectInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutObjectInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutObjectInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutObjectInput"}
	if s.BackupJobId == nil {
		invalidParams.Add(request.NewErrParamRequired("BackupJobId"))
	}
	if s.BackupJobId != nil && len(*s.BackupJobId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BackupJobId", 1))
	}
	if s.ObjectName == nil {
		invalidParams.Add(request.NewErrParamRequired("ObjectName"))
	}
	if s.ObjectName != nil && len(*s.ObjectName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ObjectName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBackupJobId sets the BackupJobId field's value.
func (s *PutObjectInput) SetBackupJobId(v string) *PutObjectInput {
	s.BackupJobId = &v
	return s
}

// SetInlineChunk sets the InlineChunk field's value.
func (s *PutObjectInput) SetInlineChunk(v io.ReadSeeker) *PutObjectInput {
	s.InlineChunk = v
	return s
}

// SetInlineChunkChecksum sets the InlineChunkChecksum field's value.
func (s *PutObjectInput) SetInlineChunkChecksum(v string) *PutObjectInput {
	s.InlineChunkChecksum = &v
	return s
}

// SetInlineChunkChecksumAlgorithm sets the InlineChunkChecksumAlgorithm field's value.
func (s *PutObjectInput) SetInlineChunkChecksumAlgorithm(v string) *PutObjectInput {
	s.InlineChunkChecksumAlgorithm = &v
	return s
}

// SetInlineChunkLength sets the InlineChunkLength field's value.
func (s *PutObjectInput) SetInlineChunkLength(v int64) *PutObjectInput {
	s.InlineChunkLength = &v
	return s
}

// SetMetadataString sets the MetadataString field's value.
func (s *PutObjectInput) SetMetadataString(v string) *PutObjectInput {
	s.MetadataString = &v
	return s
}

// SetObjectChecksum sets the ObjectChecksum field's value.
func (s *PutObjectInput) SetObjectChecksum(v string) *PutObjectInput {
	s.ObjectChecksum = &v
	return s
}

// SetObjectChecksumAlgorithm sets the ObjectChecksumAlgorithm field's value.
func (s *PutObjectInput) SetObjectChecksumAlgorithm(v string) *PutObjectInput {
	s.ObjectChecksumAlgorithm = &v
	return s
}

// SetObjectName sets the ObjectName field's value.
func (s *PutObjectInput) SetObjectName(v string) *PutObjectInput {
	s.ObjectName = &v
	return s
}

// SetThrowOnDuplicate sets the ThrowOnDuplicate field's value.
func (s *PutObjectInput) SetThrowOnDuplicate(v bool) *PutObjectInput {
	s.ThrowOnDuplicate = &v
	return s
}

type PutObjectOutput struct {
	_ struct{} `type:"structure"`

	// Inline chunk checksum
	//
	// InlineChunkChecksum is a required field
	InlineChunkChecksum *string `type:"string" required:"true"`

	// Inline chunk checksum algorithm
	//
	// InlineChunkChecksumAlgorithm is a required field
	InlineChunkChecksumAlgorithm *string `type:"string" required:"true" enum:"DataChecksumAlgorithm"`

	// object checksum
	//
	// ObjectChecksum is a required field
	ObjectChecksum *string `type:"string" required:"true"`

	// object checksum algorithm
	//
	// ObjectChecksumAlgorithm is a required field
	ObjectChecksumAlgorithm *string `type:"string" required:"true" enum:"SummaryChecksumAlgorithm"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutObjectOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutObjectOutput) GoString() string {
	return s.String()
}

// SetInlineChunkChecksum sets the InlineChunkChecksum field's value.
func (s *PutObjectOutput) SetInlineChunkChecksum(v string) *PutObjectOutput {
	s.InlineChunkChecksum = &v
	return s
}

// SetInlineChunkChecksumAlgorithm sets the InlineChunkChecksumAlgorithm field's value.
func (s *PutObjectOutput) SetInlineChunkChecksumAlgorithm(v string) *PutObjectOutput {
	s.InlineChunkChecksumAlgorithm = &v
	return s
}

// SetObjectChecksum sets the ObjectChecksum field's value.
func (s *PutObjectOutput) SetObjectChecksum(v string) *PutObjectOutput {
	s.ObjectChecksum = &v
	return s
}

// SetObjectChecksumAlgorithm sets the ObjectChecksumAlgorithm field's value.
func (s *PutObjectOutput) SetObjectChecksumAlgorithm(v string) *PutObjectOutput {
	s.ObjectChecksumAlgorithm = &v
	return s
}

// Non-retryable exception. Attempted to make an operation on non-existing or
// expired resource.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Retryable exception. In general indicates internal failure that can be fixed
// by retry.
type RetryableException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RetryableException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RetryableException) GoString() string {
	return s.String()
}

func newErrorRetryableException(v protocol.ResponseMetadata) error {
	return &RetryableException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *RetryableException) Code() string {
	return "RetryableException"
}

// Message returns the exception's message.
func (s *RetryableException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *RetryableException) OrigErr() error {
	return nil
}

func (s *RetryableException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *RetryableException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *RetryableException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Deprecated. To be removed from the model.
type ServiceInternalException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceInternalException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceInternalException) GoString() string {
	return s.String()
}

func newErrorServiceInternalException(v protocol.ResponseMetadata) error {
	return &ServiceInternalException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServiceInternalException) Code() string {
	return "ServiceInternalException"
}

// Message returns the exception's message.
func (s *ServiceInternalException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServiceInternalException) OrigErr() error {
	return nil
}

func (s *ServiceInternalException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServiceInternalException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServiceInternalException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Retryable exception, indicates internal server error.
type ServiceUnavailableException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceUnavailableException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceUnavailableException) GoString() string {
	return s.String()
}

func newErrorServiceUnavailableException(v protocol.ResponseMetadata) error {
	return &ServiceUnavailableException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServiceUnavailableException) Code() string {
	return "ServiceUnavailableException"
}

// Message returns the exception's message.
func (s *ServiceUnavailableException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServiceUnavailableException) OrigErr() error {
	return nil
}

func (s *ServiceUnavailableException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServiceUnavailableException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServiceUnavailableException) RequestID() string {
	return s.RespMetadata.RequestID
}

type StartObjectInput struct {
	_ struct{} `type:"structure"`

	// Backup job Id for the in-progress backup
	//
	// BackupJobId is a required field
	BackupJobId *string `location:"uri" locationName:"jobId" type:"string" required:"true"`

	// Name for the object.
	//
	// ObjectName is a required field
	ObjectName *string `location:"uri" locationName:"objectName" type:"string" required:"true"`

	// Throw an exception if Object name is already exist.
	ThrowOnDuplicate *bool `type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartObjectInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartObjectInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartObjectInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartObjectInput"}
	if s.BackupJobId == nil {
		invalidParams.Add(request.NewErrParamRequired("BackupJobId"))
	}
	if s.BackupJobId != nil && len(*s.BackupJobId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BackupJobId", 1))
	}
	if s.ObjectName == nil {
		invalidParams.Add(request.NewErrParamRequired("ObjectName"))
	}
	if s.ObjectName != nil && len(*s.ObjectName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ObjectName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBackupJobId sets the BackupJobId field's value.
func (s *StartObjectInput) SetBackupJobId(v string) *StartObjectInput {
	s.BackupJobId = &v
	return s
}

// SetObjectName sets the ObjectName field's value.
func (s *StartObjectInput) SetObjectName(v string) *StartObjectInput {
	s.ObjectName = &v
	return s
}

// SetThrowOnDuplicate sets the ThrowOnDuplicate field's value.
func (s *StartObjectInput) SetThrowOnDuplicate(v bool) *StartObjectInput {
	s.ThrowOnDuplicate = &v
	return s
}

type StartObjectOutput struct {
	_ struct{} `type:"structure"`

	// Upload Id for a given upload.
	//
	// UploadId is a required field
	UploadId *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartObjectOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartObjectOutput) GoString() string {
	return s.String()
}

// SetUploadId sets the UploadId field's value.
func (s *StartObjectOutput) SetUploadId(v string) *StartObjectOutput {
	s.UploadId = &v
	return s
}

// Increased rate over throttling limits. Can be retried with exponential backoff.
type ThrottlingException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) GoString() string {
	return s.String()
}

func newErrorThrottlingException(v protocol.ResponseMetadata) error {
	return &ThrottlingException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ThrottlingException) Code() string {
	return "ThrottlingException"
}

// Message returns the exception's message.
func (s *ThrottlingException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ThrottlingException) OrigErr() error {
	return nil
}

func (s *ThrottlingException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ThrottlingException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ThrottlingException) RequestID() string {
	return s.RespMetadata.RequestID
}

const (
	// DataChecksumAlgorithmSha256 is a DataChecksumAlgorithm enum value
	DataChecksumAlgorithmSha256 = "SHA256"
)

// DataChecksumAlgorithm_Values returns all elements of the DataChecksumAlgorithm enum
func DataChecksumAlgorithm_Values() []string {
	return []string{
		DataChecksumAlgorithmSha256,
	}
}

const (
	// SummaryChecksumAlgorithmSummary is a SummaryChecksumAlgorithm enum value
	SummaryChecksumAlgorithmSummary = "SUMMARY"
)

// SummaryChecksumAlgorithm_Values returns all elements of the SummaryChecksumAlgorithm enum
func SummaryChecksumAlgorithm_Values() []string {
	return []string{
		SummaryChecksumAlgorithmSummary,
	}
}
