package scsp

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SearchTicketById invokes the scsp.SearchTicketById API synchronously
func (client *Client) SearchTicketById(request *SearchTicketByIdRequest) (response *SearchTicketByIdResponse, err error) {
	response = CreateSearchTicketByIdResponse()
	err = client.DoAction(request, response)
	return
}

// SearchTicketByIdWithChan invokes the scsp.SearchTicketById API asynchronously
func (client *Client) SearchTicketByIdWithChan(request *SearchTicketByIdRequest) (<-chan *SearchTicketByIdResponse, <-chan error) {
	responseChan := make(chan *SearchTicketByIdResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SearchTicketById(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SearchTicketByIdWithCallback invokes the scsp.SearchTicketById API asynchronously
func (client *Client) SearchTicketByIdWithCallback(request *SearchTicketByIdRequest, callback func(response *SearchTicketByIdResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SearchTicketByIdResponse
		var err error
		defer close(result)
		response, err = client.SearchTicketById(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SearchTicketByIdRequest is the request struct for api SearchTicketById
type SearchTicketByIdRequest struct {
	*requests.RpcRequest
	ClientToken string           `position:"Query"`
	InstanceId  string           `position:"Query"`
	TicketId    requests.Integer `position:"Query"`
	StatusCode  requests.Integer `position:"Query"`
}

// SearchTicketByIdResponse is the response struct for api SearchTicketById
type SearchTicketByIdResponse struct {
	*responses.BaseResponse
	Message        string `json:"Message" xml:"Message"`
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Code           string `json:"Code" xml:"Code"`
	Success        bool   `json:"Success" xml:"Success"`
	HttpStatusCode int64  `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Data           Data   `json:"Data" xml:"Data"`
}

// CreateSearchTicketByIdRequest creates a request to invoke SearchTicketById API
func CreateSearchTicketByIdRequest() (request *SearchTicketByIdRequest) {
	request = &SearchTicketByIdRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("scsp", "2020-07-02", "SearchTicketById", "", "")
	request.Method = requests.GET
	return
}

// CreateSearchTicketByIdResponse creates a response to parse from SearchTicketById response
func CreateSearchTicketByIdResponse() (response *SearchTicketByIdResponse) {
	response = &SearchTicketByIdResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
