package edas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateEnvAppGroup invokes the edas.CreateEnvAppGroup API synchronously
func (client *Client) CreateEnvAppGroup(request *CreateEnvAppGroupRequest) (response *CreateEnvAppGroupResponse, err error) {
	response = CreateCreateEnvAppGroupResponse()
	err = client.DoAction(request, response)
	return
}

// CreateEnvAppGroupWithChan invokes the edas.CreateEnvAppGroup API asynchronously
func (client *Client) CreateEnvAppGroupWithChan(request *CreateEnvAppGroupRequest) (<-chan *CreateEnvAppGroupResponse, <-chan error) {
	responseChan := make(chan *CreateEnvAppGroupResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateEnvAppGroup(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateEnvAppGroupWithCallback invokes the edas.CreateEnvAppGroup API asynchronously
func (client *Client) CreateEnvAppGroupWithCallback(request *CreateEnvAppGroupRequest, callback func(response *CreateEnvAppGroupResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateEnvAppGroupResponse
		var err error
		defer close(result)
		response, err = client.CreateEnvAppGroup(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateEnvAppGroupRequest is the request struct for api CreateEnvAppGroup
type CreateEnvAppGroupRequest struct {
	*requests.RoaRequest
	PointcutName string `position:"Body" name:"PointcutName"`
	Scopes       string `position:"Body" name:"Scopes"`
}

// CreateEnvAppGroupResponse is the response struct for api CreateEnvAppGroup
type CreateEnvAppGroupResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      int    `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
}

// CreateCreateEnvAppGroupRequest creates a request to invoke CreateEnvAppGroup API
func CreateCreateEnvAppGroupRequest() (request *CreateEnvAppGroupRequest) {
	request = &CreateEnvAppGroupRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("Edas", "2017-08-01", "CreateEnvAppGroup", "/pop/v5/gray/env_app_groups", "Edas", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateEnvAppGroupResponse creates a response to parse from CreateEnvAppGroup response
func CreateCreateEnvAppGroupResponse() (response *CreateEnvAppGroupResponse) {
	response = &CreateEnvAppGroupResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
