package dataworks_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateUdfFile invokes the dataworks_public.CreateUdfFile API synchronously
func (client *Client) CreateUdfFile(request *CreateUdfFileRequest) (response *CreateUdfFileResponse, err error) {
	response = CreateCreateUdfFileResponse()
	err = client.DoAction(request, response)
	return
}

// CreateUdfFileWithChan invokes the dataworks_public.CreateUdfFile API asynchronously
func (client *Client) CreateUdfFileWithChan(request *CreateUdfFileRequest) (<-chan *CreateUdfFileResponse, <-chan error) {
	responseChan := make(chan *CreateUdfFileResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateUdfFile(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateUdfFileWithCallback invokes the dataworks_public.CreateUdfFile API asynchronously
func (client *Client) CreateUdfFileWithCallback(request *CreateUdfFileRequest, callback func(response *CreateUdfFileResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateUdfFileResponse
		var err error
		defer close(result)
		response, err = client.CreateUdfFile(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateUdfFileRequest is the request struct for api CreateUdfFile
type CreateUdfFileRequest struct {
	*requests.RpcRequest
	ReturnValue          string           `position:"Body" name:"ReturnValue"`
	Resources            string           `position:"Body" name:"Resources"`
	FunctionType         string           `position:"Body" name:"FunctionType"`
	CmdDescription       string           `position:"Body" name:"CmdDescription"`
	UdfDescription       string           `position:"Body" name:"UdfDescription"`
	ParameterDescription string           `position:"Body" name:"ParameterDescription"`
	ProjectIdentifier    string           `position:"Body" name:"ProjectIdentifier"`
	Example              string           `position:"Body" name:"Example"`
	FileName             string           `position:"Body" name:"FileName"`
	ClassName            string           `position:"Body" name:"ClassName"`
	FileFolderPath       string           `position:"Body" name:"FileFolderPath"`
	ProjectId            requests.Integer `position:"Body" name:"ProjectId"`
}

// CreateUdfFileResponse is the response struct for api CreateUdfFile
type CreateUdfFileResponse struct {
	*responses.BaseResponse
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Success        bool   `json:"Success" xml:"Success"`
	ErrorCode      string `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMessage   string `json:"ErrorMessage" xml:"ErrorMessage"`
	Data           int64  `json:"Data" xml:"Data"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
}

// CreateCreateUdfFileRequest creates a request to invoke CreateUdfFile API
func CreateCreateUdfFileRequest() (request *CreateUdfFileRequest) {
	request = &CreateUdfFileRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dataworks-public", "2020-05-18", "CreateUdfFile", "", "")
	request.Method = requests.POST
	return
}

// CreateCreateUdfFileResponse creates a response to parse from CreateUdfFile response
func CreateCreateUdfFileResponse() (response *CreateUdfFileResponse) {
	response = &CreateUdfFileResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
