package csb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// FindOtherInstanceList invokes the csb.FindOtherInstanceList API synchronously
// api document: https://help.aliyun.com/api/csb/findotherinstancelist.html
func (client *Client) FindOtherInstanceList(request *FindOtherInstanceListRequest) (response *FindOtherInstanceListResponse, err error) {
	response = CreateFindOtherInstanceListResponse()
	err = client.DoAction(request, response)
	return
}

// FindOtherInstanceListWithChan invokes the csb.FindOtherInstanceList API asynchronously
// api document: https://help.aliyun.com/api/csb/findotherinstancelist.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) FindOtherInstanceListWithChan(request *FindOtherInstanceListRequest) (<-chan *FindOtherInstanceListResponse, <-chan error) {
	responseChan := make(chan *FindOtherInstanceListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.FindOtherInstanceList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// FindOtherInstanceListWithCallback invokes the csb.FindOtherInstanceList API asynchronously
// api document: https://help.aliyun.com/api/csb/findotherinstancelist.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) FindOtherInstanceListWithCallback(request *FindOtherInstanceListRequest, callback func(response *FindOtherInstanceListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *FindOtherInstanceListResponse
		var err error
		defer close(result)
		response, err = client.FindOtherInstanceList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// FindOtherInstanceListRequest is the request struct for api FindOtherInstanceList
type FindOtherInstanceListRequest struct {
	*requests.RpcRequest
	PageNum   requests.Integer `position:"Query" name:"PageNum"`
	SearchTxt string           `position:"Query" name:"SearchTxt"`
	PageSize  requests.Integer `position:"Query" name:"PageSize"`
}

// FindOtherInstanceListResponse is the response struct for api FindOtherInstanceList
type FindOtherInstanceListResponse struct {
	*responses.BaseResponse
	Code      int    `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateFindOtherInstanceListRequest creates a request to invoke FindOtherInstanceList API
func CreateFindOtherInstanceListRequest() (request *FindOtherInstanceListRequest) {
	request = &FindOtherInstanceListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CSB", "2017-11-18", "FindOtherInstanceList", "", "")
	request.Method = requests.GET
	return
}

// CreateFindOtherInstanceListResponse creates a response to parse from FindOtherInstanceList response
func CreateFindOtherInstanceListResponse() (response *FindOtherInstanceListResponse) {
	response = &FindOtherInstanceListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
