package address_purification

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ClassifyPOI invokes the address_purification.ClassifyPOI API synchronously
func (client *Client) ClassifyPOI(request *ClassifyPOIRequest) (response *ClassifyPOIResponse, err error) {
	response = CreateClassifyPOIResponse()
	err = client.DoAction(request, response)
	return
}

// ClassifyPOIWithChan invokes the address_purification.ClassifyPOI API asynchronously
func (client *Client) ClassifyPOIWithChan(request *ClassifyPOIRequest) (<-chan *ClassifyPOIResponse, <-chan error) {
	responseChan := make(chan *ClassifyPOIResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ClassifyPOI(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ClassifyPOIWithCallback invokes the address_purification.ClassifyPOI API asynchronously
func (client *Client) ClassifyPOIWithCallback(request *ClassifyPOIRequest, callback func(response *ClassifyPOIResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ClassifyPOIResponse
		var err error
		defer close(result)
		response, err = client.ClassifyPOI(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ClassifyPOIRequest is the request struct for api ClassifyPOI
type ClassifyPOIRequest struct {
	*requests.RpcRequest
	DefaultProvince string `position:"Body" name:"DefaultProvince"`
	ServiceCode     string `position:"Body" name:"ServiceCode"`
	DefaultCity     string `position:"Body" name:"DefaultCity"`
	DefaultDistrict string `position:"Body" name:"DefaultDistrict"`
	AppKey          string `position:"Body" name:"AppKey"`
	Text            string `position:"Body" name:"Text"`
}

// ClassifyPOIResponse is the response struct for api ClassifyPOI
type ClassifyPOIResponse struct {
	*responses.BaseResponse
	Data      string `json:"Data" xml:"Data"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateClassifyPOIRequest creates a request to invoke ClassifyPOI API
func CreateClassifyPOIRequest() (request *ClassifyPOIRequest) {
	request = &ClassifyPOIRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("address-purification", "2019-11-18", "ClassifyPOI", "addrp", "openAPI")
	request.Method = requests.POST
	return
}

// CreateClassifyPOIResponse creates a response to parse from ClassifyPOI response
func CreateClassifyPOIResponse() (response *ClassifyPOIResponse) {
	response = &ClassifyPOIResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
