package devops_rdc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetPipelineInstanceGroupStatus invokes the devops_rdc.GetPipelineInstanceGroupStatus API synchronously
func (client *Client) GetPipelineInstanceGroupStatus(request *GetPipelineInstanceGroupStatusRequest) (response *GetPipelineInstanceGroupStatusResponse, err error) {
	response = CreateGetPipelineInstanceGroupStatusResponse()
	err = client.DoAction(request, response)
	return
}

// GetPipelineInstanceGroupStatusWithChan invokes the devops_rdc.GetPipelineInstanceGroupStatus API asynchronously
func (client *Client) GetPipelineInstanceGroupStatusWithChan(request *GetPipelineInstanceGroupStatusRequest) (<-chan *GetPipelineInstanceGroupStatusResponse, <-chan error) {
	responseChan := make(chan *GetPipelineInstanceGroupStatusResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetPipelineInstanceGroupStatus(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetPipelineInstanceGroupStatusWithCallback invokes the devops_rdc.GetPipelineInstanceGroupStatus API asynchronously
func (client *Client) GetPipelineInstanceGroupStatusWithCallback(request *GetPipelineInstanceGroupStatusRequest, callback func(response *GetPipelineInstanceGroupStatusResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetPipelineInstanceGroupStatusResponse
		var err error
		defer close(result)
		response, err = client.GetPipelineInstanceGroupStatus(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetPipelineInstanceGroupStatusRequest is the request struct for api GetPipelineInstanceGroupStatus
type GetPipelineInstanceGroupStatusRequest struct {
	*requests.RpcRequest
	FlowInstanceId requests.Integer `position:"Body" name:"FlowInstanceId"`
	UserPk         string           `position:"Body" name:"UserPk"`
	OrgId          string           `position:"Query" name:"OrgId"`
	PipelineId     requests.Integer `position:"Query" name:"PipelineId"`
}

// GetPipelineInstanceGroupStatusResponse is the response struct for api GetPipelineInstanceGroupStatus
type GetPipelineInstanceGroupStatusResponse struct {
	*responses.BaseResponse
	Success      bool   `json:"Success" xml:"Success"`
	ErrorCode    string `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	RequestId    string `json:"RequestId" xml:"RequestId"`
	Object       Object `json:"Object" xml:"Object"`
}

// CreateGetPipelineInstanceGroupStatusRequest creates a request to invoke GetPipelineInstanceGroupStatus API
func CreateGetPipelineInstanceGroupStatusRequest() (request *GetPipelineInstanceGroupStatusRequest) {
	request = &GetPipelineInstanceGroupStatusRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("devops-rdc", "2020-03-03", "GetPipelineInstanceGroupStatus", "", "")
	request.Method = requests.POST
	return
}

// CreateGetPipelineInstanceGroupStatusResponse creates a response to parse from GetPipelineInstanceGroupStatus response
func CreateGetPipelineInstanceGroupStatusResponse() (response *GetPipelineInstanceGroupStatusResponse) {
	response = &GetPipelineInstanceGroupStatusResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
