package cr_ee

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateRepoTrigger invokes the cr.CreateRepoTrigger API synchronously
// api document: https://help.aliyun.com/api/cr/createrepotrigger.html
func (client *Client) CreateRepoTrigger(request *CreateRepoTriggerRequest) (response *CreateRepoTriggerResponse, err error) {
	response = CreateCreateRepoTriggerResponse()
	err = client.DoAction(request, response)
	return
}

// CreateRepoTriggerWithChan invokes the cr.CreateRepoTrigger API asynchronously
// api document: https://help.aliyun.com/api/cr/createrepotrigger.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateRepoTriggerWithChan(request *CreateRepoTriggerRequest) (<-chan *CreateRepoTriggerResponse, <-chan error) {
	responseChan := make(chan *CreateRepoTriggerResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateRepoTrigger(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateRepoTriggerWithCallback invokes the cr.CreateRepoTrigger API asynchronously
// api document: https://help.aliyun.com/api/cr/createrepotrigger.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateRepoTriggerWithCallback(request *CreateRepoTriggerRequest, callback func(response *CreateRepoTriggerResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateRepoTriggerResponse
		var err error
		defer close(result)
		response, err = client.CreateRepoTrigger(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateRepoTriggerRequest is the request struct for api CreateRepoTrigger
type CreateRepoTriggerRequest struct {
	*requests.RpcRequest
	RepoId      string `position:"Query" name:"RepoId"`
	TriggerTag  string `position:"Query" name:"TriggerTag"`
	TriggerType string `position:"Query" name:"TriggerType"`
	TriggerUrl  string `position:"Query" name:"TriggerUrl"`
	InstanceId  string `position:"Query" name:"InstanceId"`
	TriggerName string `position:"Query" name:"TriggerName"`
}

// CreateRepoTriggerResponse is the response struct for api CreateRepoTrigger
type CreateRepoTriggerResponse struct {
	*responses.BaseResponse
	CreateRepoTriggerIsSuccess bool   `json:"IsSuccess" xml:"IsSuccess"`
	Code                       string `json:"Code" xml:"Code"`
	RequestId                  string `json:"RequestId" xml:"RequestId"`
	TriggerId                  string `json:"TriggerId" xml:"TriggerId"`
}

// CreateCreateRepoTriggerRequest creates a request to invoke CreateRepoTrigger API
func CreateCreateRepoTriggerRequest() (request *CreateRepoTriggerRequest) {
	request = &CreateRepoTriggerRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cr", "2018-12-01", "CreateRepoTrigger", "acr", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateRepoTriggerResponse creates a response to parse from CreateRepoTrigger response
func CreateCreateRepoTriggerResponse() (response *CreateRepoTriggerResponse) {
	response = &CreateRepoTriggerResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
