package cassandra

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyIpWhitelistGroup invokes the cassandra.ModifyIpWhitelistGroup API synchronously
func (client *Client) ModifyIpWhitelistGroup(request *ModifyIpWhitelistGroupRequest) (response *ModifyIpWhitelistGroupResponse, err error) {
	response = CreateModifyIpWhitelistGroupResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyIpWhitelistGroupWithChan invokes the cassandra.ModifyIpWhitelistGroup API asynchronously
func (client *Client) ModifyIpWhitelistGroupWithChan(request *ModifyIpWhitelistGroupRequest) (<-chan *ModifyIpWhitelistGroupResponse, <-chan error) {
	responseChan := make(chan *ModifyIpWhitelistGroupResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyIpWhitelistGroup(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyIpWhitelistGroupWithCallback invokes the cassandra.ModifyIpWhitelistGroup API asynchronously
func (client *Client) ModifyIpWhitelistGroupWithCallback(request *ModifyIpWhitelistGroupRequest, callback func(response *ModifyIpWhitelistGroupResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyIpWhitelistGroupResponse
		var err error
		defer close(result)
		response, err = client.ModifyIpWhitelistGroup(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyIpWhitelistGroupRequest is the request struct for api ModifyIpWhitelistGroup
type ModifyIpWhitelistGroupRequest struct {
	*requests.RpcRequest
	IpList    string           `position:"Query" name:"IpList"`
	IpVersion requests.Integer `position:"Query" name:"IpVersion"`
	ClusterId string           `position:"Query" name:"ClusterId"`
	GroupName string           `position:"Query" name:"GroupName"`
}

// ModifyIpWhitelistGroupResponse is the response struct for api ModifyIpWhitelistGroup
type ModifyIpWhitelistGroupResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifyIpWhitelistGroupRequest creates a request to invoke ModifyIpWhitelistGroup API
func CreateModifyIpWhitelistGroupRequest() (request *ModifyIpWhitelistGroupRequest) {
	request = &ModifyIpWhitelistGroupRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cassandra", "2019-01-01", "ModifyIpWhitelistGroup", "Cassandra", "openAPI")
	request.Method = requests.POST
	return
}

// CreateModifyIpWhitelistGroupResponse creates a response to parse from ModifyIpWhitelistGroup response
func CreateModifyIpWhitelistGroupResponse() (response *ModifyIpWhitelistGroupResponse) {
	response = &ModifyIpWhitelistGroupResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
