package extendedlocationapi

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/azure-sdk-for-go/services/extendedlocation/mgmt/2021-08-15/extendedlocation"
)

// CustomLocationsClientAPI contains the set of methods on the CustomLocationsClient type.
type CustomLocationsClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, resourceName string, parameters extendedlocation.CustomLocation) (result extendedlocation.CustomLocationsCreateOrUpdateFuture, err error)
	Delete(ctx context.Context, resourceGroupName string, resourceName string) (result extendedlocation.CustomLocationsDeleteFuture, err error)
	Get(ctx context.Context, resourceGroupName string, resourceName string) (result extendedlocation.CustomLocation, err error)
	ListByResourceGroup(ctx context.Context, resourceGroupName string) (result extendedlocation.CustomLocationListResultPage, err error)
	ListByResourceGroupComplete(ctx context.Context, resourceGroupName string) (result extendedlocation.CustomLocationListResultIterator, err error)
	ListBySubscription(ctx context.Context) (result extendedlocation.CustomLocationListResultPage, err error)
	ListBySubscriptionComplete(ctx context.Context) (result extendedlocation.CustomLocationListResultIterator, err error)
	ListEnabledResourceTypes(ctx context.Context, resourceGroupName string, resourceName string) (result extendedlocation.EnabledResourceTypesListResultPage, err error)
	ListEnabledResourceTypesComplete(ctx context.Context, resourceGroupName string, resourceName string) (result extendedlocation.EnabledResourceTypesListResultIterator, err error)
	ListOperations(ctx context.Context) (result extendedlocation.CustomLocationOperationsListPage, err error)
	ListOperationsComplete(ctx context.Context) (result extendedlocation.CustomLocationOperationsListIterator, err error)
	Update(ctx context.Context, resourceGroupName string, resourceName string, parameters extendedlocation.PatchableCustomLocations) (result extendedlocation.CustomLocation, err error)
}

var _ CustomLocationsClientAPI = (*extendedlocation.CustomLocationsClient)(nil)
