#
# Miscellaneous procedures...
#
# $Id: misc.tcl,v 1.11 2011/02/16 22:16:19 rader Exp $
#

###############################################################################

proc DisplayProject { } {
  global display_mode cur_task_cmd win_start win_cur
  set idx [expr $win_start + $win_cur + 3]
  set txt [.t.lb get $idx.0 $idx.end]
  if { ! [regexp {^>(.*?) } $txt crud proj] } {
    bell
    return
  }
  if { $proj == "(none)" } { set proj "" }
  set display_mode "report"
  set cur_task_cmd "ls project:$proj"
  Refresh "new-report"
}

###############################################################################

proc Audit { msg } {
  global pid audit_log
  set t [ clock seconds ]
  catch { set FD [open "$audit_log" "a"] } { return }
  puts $FD "[ clock format $t -format {%b %d %T} ] $pid $msg"
  catch { close $FD }
}

###############################################################################

proc Bell { } {
  global bell
  if { $bell } { bell; } else { puts "bell" }
}

###############################################################################

proc MoveCursor { } {
  global entered_num debug
  global win_start win_cur win_size
  if { $debug } { puts "Goto: $entered_num" }
  if { $entered_num == "" } {
    Refresh "line-last"
  } else {
    if { $entered_num <= $win_size } {
      set win_start 1
      set win_cur $entered_num
    } else {
      set win_start $entered_num
      set win_cur 1
    }
    set entered_num ""
    Refresh "g-jump"
  }
}

###############################################################################

proc ReturnToPrevReport { } {
  global cur_task_cmd default_task_cmd display_mode entered_num
  global prev_display_mode

  set entered_num ""
  if { $cur_task_cmd == $default_task_cmd } { 
    set prev_display_mode "report"
    Bell
    return
  }

  # cancel feedback msg...
  .t.ent configure -state normal
  .t.ent delete 0 end
  .t.ent configure -state disabled

  if { $prev_display_mode != "report" } {
    set display_mode $prev_display_mode
    set cur_task_cmd $prev_display_mode
  } else { 
    set display_mode "report"
    set cur_task_cmd $default_task_cmd
  }
  set prev_display_mode "report"
  Refresh "new-report"
}

###############################################################################

proc PasteIntoEntryWidget { } {
  if { ! [catch {::tk::GetSelection .t.lb PRIMARY} sel] && [.t.ent cget -state] == "normal" } {
    .t.ent insert end $sel 
  }
}

###############################################################################

proc FilteredGets { FD cstr str } {
  upvar 1 $cstr cs
  upvar 1 $str s
  
  catch { gets $FD cs }
  set s [StripControlChars $cs]
  if { [eof $FD] } { return -1 }

  while { [regexp {^Using alternate} $s] || [regexp {^Configuration override} $s] } { 
    catch { gets $FD cs }
    set s [StripControlChars $cs]
    if { [eof $FD] } { return -1 }
  }

  return 1

}


