#
# Display one task...
#
# $Id: info.tcl,v 1.2 2011/01/30 02:21:28 rader Exp $
#

###############################################################################

proc DisplayInfo { } { 
  global task_id cur_task_cmd win_start win_cur
  global pre_info_task_cmd pre_info_win_cur pre_info_win_start
  global display_mode debug

  if { $display_mode == "info" || $display_mode == "help" } { 
    ReturnToPrevMode
    return
  }
  if { $task_id <= 0 } { 
    Bell
    return
  }
  if { $debug } { puts "DisplayInfo: task $task_id" }
  set pre_info_task_cmd $cur_task_cmd
  set pre_info_win_start $win_start
  set pre_info_win_cur $win_cur
  set cur_task_cmd "info $task_id"; 
  Refresh "new-report" 
}

###############################################################################

proc ReturnToPrevMode { } { 
  global cur_task_cmd win_start win_cur display_mode debug
  global pre_info_task_cmd pre_info_win_start pre_info_win_cur 
  global pre_help_task_cmd pre_help_win_cur pre_help_win_start pre_help_display_mode
  global help_filter help_view entered_num

  set entered_num ""

  if { $display_mode == "report" } { 
    set s [.t.ent get]
    if { $s == "" } { 
      # nothing to cancel...
      Bell
    } else { 
      # cancel feedback msg...
      .t.ent configure -state normal
      .t.ent delete 0 end
      .t.ent configure -state disabled
    }
    return
  }
  if { $display_mode == "help" } {
    if { $debug } { puts "ReturnToPrevMode: help -> $pre_help_display_mode" }
    set help_filter ""
    set help_view ""
    set display_mode $pre_help_display_mode
    set cur_task_cmd $pre_help_task_cmd
    set win_start $pre_help_win_start
    set win_cur $pre_help_win_cur
  } else { 
    if { $debug } { puts "ReturnToPrevMode: info -> report" }
    set display_mode "report"
    set cur_task_cmd $pre_info_task_cmd
    set win_start $pre_info_win_start
    set win_cur $pre_info_win_cur
  }
  Refresh "new-report"
}

