/*
* This code is released under the GNU General Public License.  See COPYING for 
* details.  Copyright 2003 John Spray: spray_john@users.sourceforge.net
*/



#ifndef CAMERA_H
#define CAMERA_H

#include <SDL_ttf.h>
#include <string>
using namespace std;

#include "Player.h"
#include "Vector.h"
#include "Arena.h"
#include "Ufo.h"
#include "Obstacle.h"
#include "PowerUp.h"
#include "Mine.h"

//not include the Visual header because that would be a mutual include
class Visual;


enum CameraMoveMode{
        /*
	 * 0 - camera free - orientation changed by bearv/pitchv/rollv, 
	 * 	these and position to be set externally of AnimateCamera
	 * 1 - chasecam - 3rd person view of player
	 * 2 - closeup - closely bound 3rd person view from player, 
	 * 	just outside fuselage, facing forward
	 * 3 - god's eye - view from some 100-200 above the player, 
	 * 	directly down, view rotating with player's bearing
	 * 4 - rearview - view from rear of player
	*/
	CAMERA_MOVEMODE_FREE=0,
	CAMERA_MOVEMODE_CHASE=1,
	CAMERA_MOVEMODE_CLOSE=2,
	CAMERA_MOVEMODE_GOD=3,
	CAMERA_MOVEMODE_REAR=4
};

class Camera{

public:
	Camera();
	~Camera();
	void Animate();
	void Draw();
	void DrawPlayer(Player* player);
	void DrawGrid();
	void DrawArena(Arena* arena);
	void DrawSky();
	void DrawAxisSprite(Vector p1,Vector p2,float radius);
	void DrawSprite(Vector s_sprite,float radius,float spin);
	void DrawMissiles();
	void DrawUfo(Ufo* ufo);
	void DrawMine(Mine* mine);
	void DrawPowerUp(PowerUp* powerup);
	void DrawObstacle(Obstacle* obstacle);
	void SetMessage(string);
	Player* targetplayer;
  void DrawParticles();
	Visual* visual;
  void Draw2D();
	Vector s;
	Vector v;
	Vector a;
	Vector face;
	Vector up;

	float bear; //RADIANS!
	float pitch; //RADIANS!
	float roll; //RADIANS
	float bearv;
	float pitchv;
	float rollv;

	float offset;

	int viewportx;
	int viewporty;
	int viewportwidth;
	int viewportheight;
	float fov;
	float farclip;
	float nearclip;

	int movemode;

	TTF_Font* scorefont;	
	string message;
	float messagetimer;
	float messagetimermax;
};

#endif // CAMERA_H
