/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.apache.bcel.verifier.structurals;

import org.aspectj.apache.bcel.classfile.Constant;
import org.aspectj.apache.bcel.classfile.ConstantDouble;
import org.aspectj.apache.bcel.classfile.ConstantFloat;
import org.aspectj.apache.bcel.classfile.ConstantInteger;
import org.aspectj.apache.bcel.classfile.ConstantLong;
import org.aspectj.apache.bcel.classfile.ConstantPool;
import org.aspectj.apache.bcel.classfile.ConstantString;
import org.aspectj.apache.bcel.generic.ArrayType;
import org.aspectj.apache.bcel.generic.FieldInstruction;
import org.aspectj.apache.bcel.generic.IINC;
import org.aspectj.apache.bcel.generic.INVOKEINTERFACE;
import org.aspectj.apache.bcel.generic.Instruction;
import org.aspectj.apache.bcel.generic.InstructionBranch;
import org.aspectj.apache.bcel.generic.InstructionByte;
import org.aspectj.apache.bcel.generic.InvokeInstruction;
import org.aspectj.apache.bcel.generic.LOOKUPSWITCH;
import org.aspectj.apache.bcel.generic.MULTIANEWARRAY;
import org.aspectj.apache.bcel.generic.ObjectType;
import org.aspectj.apache.bcel.generic.RET;
import org.aspectj.apache.bcel.generic.ReturnaddressType;
import org.aspectj.apache.bcel.generic.TABLESWITCH;
import org.aspectj.apache.bcel.generic.Type;
import org.aspectj.apache.bcel.verifier.EmptyInstVisitor;
import org.aspectj.apache.bcel.verifier.structurals.Frame;
import org.aspectj.apache.bcel.verifier.structurals.LocalVariables;
import org.aspectj.apache.bcel.verifier.structurals.OperandStack;
import org.aspectj.apache.bcel.verifier.structurals.UninitializedObjectType;

public class ExecutionVisitor
extends EmptyInstVisitor {
    private Frame frame = null;
    private ConstantPool cpg = null;

    private OperandStack stack() {
        return this.frame.getStack();
    }

    private LocalVariables locals() {
        return this.frame.getLocals();
    }

    public void setConstantPoolGen(ConstantPool cpg) {
        this.cpg = cpg;
    }

    public void setFrame(Frame f) {
        this.frame = f;
    }

    @Override
    public void visitAALOAD(Instruction o) {
        this.stack().pop();
        Type t = this.stack().pop();
        if (t == Type.NULL) {
            this.stack().push((Type)Type.NULL);
        } else {
            ArrayType at = (ArrayType)t;
            this.stack().push(at.getElementType());
        }
    }

    @Override
    public void visitAASTORE(Instruction o) {
        this.stack().pop();
        this.stack().pop();
        this.stack().pop();
    }

    @Override
    public void visitACONST_NULL(Instruction o) {
        this.stack().push((Type)Type.NULL);
    }

    @Override
    public void visitALOAD(Instruction o) {
        this.stack().push(this.locals().get(o.getIndex()));
    }

    @Override
    public void visitANEWARRAY(Instruction o) {
        this.stack().pop();
        this.stack().push((Type)new ArrayType(o.getType(this.cpg), 1));
    }

    @Override
    public void visitARETURN(Instruction o) {
        this.stack().pop();
    }

    @Override
    public void visitARRAYLENGTH(Instruction o) {
        this.stack().pop();
        this.stack().push((Type)Type.INT);
    }

    @Override
    public void visitASTORE(Instruction o) {
        this.locals().set(o.getIndex(), this.stack().pop());
    }

    @Override
    public void visitATHROW(Instruction o) {
        Type t = this.stack().pop();
        this.stack().clear();
        if (t.equals(Type.NULL)) {
            this.stack().push(Type.getType((String)"Ljava/lang/NullPointerException;"));
        } else {
            this.stack().push(t);
        }
    }

    @Override
    public void visitBALOAD(Instruction o) {
        this.stack().pop();
        this.stack().pop();
        this.stack().push((Type)Type.INT);
    }

    @Override
    public void visitBASTORE(Instruction o) {
        this.stack().pop();
        this.stack().pop();
        this.stack().pop();
    }

    @Override
    public void visitBIPUSH(Instruction o) {
        this.stack().push((Type)Type.INT);
    }

    @Override
    public void visitCALOAD(Instruction o) {
        this.stack().pop();
        this.stack().pop();
        this.stack().push((Type)Type.INT);
    }

    @Override
    public void visitCASTORE(Instruction o) {
        this.stack().pop();
        this.stack().pop();
        this.stack().pop();
    }

    @Override
    public void visitCHECKCAST(Instruction o) {
        this.stack().pop();
        this.stack().push(o.getType(this.cpg));
    }

    @Override
    public void visitD2F(Instruction o) {
        this.stack().pop();
        this.stack().push((Type)Type.FLOAT);
    }

    @Override
    public void visitD2I(Instruction o) {
        this.stack().pop();
        this.stack().push((Type)Type.INT);
    }

    @Override
    public void visitD2L(Instruction o) {
        this.stack().pop();
        this.stack().push((Type)Type.LONG);
    }

    @Override
    public void visitDADD(Instruction o) {
        this.stack().pop();
        this.stack().pop();
        this.stack().push((Type)Type.DOUBLE);
    }

    @Override
    public void visitDALOAD(Instruction o) {
        this.stack().pop();
        this.stack().pop();
        this.stack().push((Type)Type.DOUBLE);
    }

    @Override
    public void visitDASTORE(Instruction o) {
        this.stack().pop();
        this.stack().pop();
        this.stack().pop();
    }

    @Override
    public void visitDCMPG(Instruction o) {
        this.stack().pop();
        this.stack().pop();
        this.stack().push((Type)Type.INT);
    }

    @Override
    public void visitDCMPL(Instruction o) {
        this.stack().pop();
        this.stack().pop();
        this.stack().push((Type)Type.INT);
    }

    @Override
    public void visitDCONST(Instruction o) {
        this.stack().push((Type)Type.DOUBLE);
    }

    @Override
    public void visitDDIV(Instruction o) {
        this.stack().pop();
        this.stack().pop();
        this.stack().push((Type)Type.DOUBLE);
    }

    @Override
    public void visitDLOAD(Instruction o) {
        this.stack().push((Type)Type.DOUBLE);
    }

    @Override
    public void visitDMUL(Instruction o) {
        this.stack().pop();
        this.stack().pop();
        this.stack().push((Type)Type.DOUBLE);
    }

    @Override
    public void visitDNEG(Instruction o) {
        this.stack().pop();
        this.stack().push((Type)Type.DOUBLE);
    }

    @Override
    public void visitDREM(Instruction o) {
        this.stack().pop();
        this.stack().pop();
        this.stack().push((Type)Type.DOUBLE);
    }

    @Override
    public void visitDRETURN(Instruction o) {
        this.stack().pop();
    }

    @Override
    public void visitDSTORE(Instruction o) {
        this.locals().set(o.getIndex(), this.stack().pop());
        this.locals().set(o.getIndex() + 1, Type.UNKNOWN);
    }

    @Override
    public void visitDSUB(Instruction o) {
        this.stack().pop();
        this.stack().pop();
        this.stack().push((Type)Type.DOUBLE);
    }

    @Override
    public void visitDUP(Instruction o) {
        Type t = this.stack().pop();
        this.stack().push(t);
        this.stack().push(t);
    }

    @Override
    public void visitDUP_X1(Instruction o) {
        Type w1 = this.stack().pop();
        Type w2 = this.stack().pop();
        this.stack().push(w1);
        this.stack().push(w2);
        this.stack().push(w1);
    }

    @Override
    public void visitDUP_X2(Instruction o) {
        Type w1 = this.stack().pop();
        Type w2 = this.stack().pop();
        if (w2.getSize() == 2) {
            this.stack().push(w1);
            this.stack().push(w2);
            this.stack().push(w1);
        } else {
            Type w3 = this.stack().pop();
            this.stack().push(w1);
            this.stack().push(w3);
            this.stack().push(w2);
            this.stack().push(w1);
        }
    }

    @Override
    public void visitDUP2(Instruction o) {
        Type t = this.stack().pop();
        if (t.getSize() == 2) {
            this.stack().push(t);
            this.stack().push(t);
        } else {
            Type u = this.stack().pop();
            this.stack().push(u);
            this.stack().push(t);
            this.stack().push(u);
            this.stack().push(t);
        }
    }

    @Override
    public void visitDUP2_X1(Instruction o) {
        Type t = this.stack().pop();
        if (t.getSize() == 2) {
            Type u = this.stack().pop();
            this.stack().push(t);
            this.stack().push(u);
            this.stack().push(t);
        } else {
            Type u = this.stack().pop();
            Type v = this.stack().pop();
            this.stack().push(u);
            this.stack().push(t);
            this.stack().push(v);
            this.stack().push(u);
            this.stack().push(t);
        }
    }

    @Override
    public void visitDUP2_X2(Instruction o) {
        Type t = this.stack().pop();
        if (t.getSize() == 2) {
            Type u = this.stack().pop();
            if (u.getSize() == 2) {
                this.stack().push(t);
                this.stack().push(u);
                this.stack().push(t);
            } else {
                Type v = this.stack().pop();
                this.stack().push(t);
                this.stack().push(v);
                this.stack().push(u);
                this.stack().push(t);
            }
        } else {
            Type u = this.stack().pop();
            Type v = this.stack().pop();
            if (v.getSize() == 2) {
                this.stack().push(u);
                this.stack().push(t);
                this.stack().push(v);
                this.stack().push(u);
                this.stack().push(t);
            } else {
                Type w = this.stack().pop();
                this.stack().push(u);
                this.stack().push(t);
                this.stack().push(w);
                this.stack().push(v);
                this.stack().push(u);
                this.stack().push(t);
            }
        }
    }

    @Override
    public void visitF2D(Instruction o) {
        this.stack().pop();
        this.stack().push((Type)Type.DOUBLE);
    }

    @Override
    public void visitF2I(Instruction o) {
        this.stack().pop();
        this.stack().push((Type)Type.INT);
    }

    @Override
    public void visitF2L(Instruction o) {
        this.stack().pop();
        this.stack().push((Type)Type.LONG);
    }

    @Override
    public void visitFADD(Instruction o) {
        this.stack().pop();
        this.stack().pop();
        this.stack().push((Type)Type.FLOAT);
    }

    @Override
    public void visitFALOAD(Instruction o) {
        this.stack().pop();
        this.stack().pop();
        this.stack().push((Type)Type.FLOAT);
    }

    @Override
    public void visitFASTORE(Instruction o) {
        this.stack().pop();
        this.stack().pop();
        this.stack().pop();
    }

    @Override
    public void visitFCMPG(Instruction o) {
        this.stack().pop();
        this.stack().pop();
        this.stack().push((Type)Type.INT);
    }

    @Override
    public void visitFCMPL(Instruction o) {
        this.stack().pop();
        this.stack().pop();
        this.stack().push((Type)Type.INT);
    }

    @Override
    public void visitFCONST(Instruction o) {
        this.stack().push((Type)Type.FLOAT);
    }

    @Override
    public void visitFDIV(Instruction o) {
        this.stack().pop();
        this.stack().pop();
        this.stack().push((Type)Type.FLOAT);
    }

    @Override
    public void visitFLOAD(Instruction o) {
        this.stack().push((Type)Type.FLOAT);
    }

    @Override
    public void visitFMUL(Instruction o) {
        this.stack().pop();
        this.stack().pop();
        this.stack().push((Type)Type.FLOAT);
    }

    @Override
    public void visitFNEG(Instruction o) {
        this.stack().pop();
        this.stack().push((Type)Type.FLOAT);
    }

    @Override
    public void visitFREM(Instruction o) {
        this.stack().pop();
        this.stack().pop();
        this.stack().push((Type)Type.FLOAT);
    }

    @Override
    public void visitFRETURN(Instruction o) {
        this.stack().pop();
    }

    @Override
    public void visitFSTORE(Instruction o) {
        this.locals().set(o.getIndex(), this.stack().pop());
    }

    @Override
    public void visitFSUB(Instruction o) {
        this.stack().pop();
        this.stack().pop();
        this.stack().push((Type)Type.FLOAT);
    }

    @Override
    public void visitGETFIELD(FieldInstruction o) {
        this.stack().pop();
        Type t = o.getFieldType(this.cpg);
        if (t.equals(Type.BOOLEAN) || t.equals(Type.CHAR) || t.equals(Type.BYTE) || t.equals(Type.SHORT)) {
            t = Type.INT;
        }
        this.stack().push(t);
    }

    @Override
    public void visitGETSTATIC(FieldInstruction o) {
        Type t = o.getFieldType(this.cpg);
        if (t.equals(Type.BOOLEAN) || t.equals(Type.CHAR) || t.equals(Type.BYTE) || t.equals(Type.SHORT)) {
            t = Type.INT;
        }
        this.stack().push(t);
    }

    @Override
    public void visitGOTO(Instruction o) {
    }

    @Override
    public void visitGOTO_W(Instruction o) {
    }

    @Override
    public void visitI2B(Instruction o) {
        this.stack().pop();
        this.stack().push((Type)Type.INT);
    }

    @Override
    public void visitI2C(Instruction o) {
        this.stack().pop();
        this.stack().push((Type)Type.INT);
    }

    @Override
    public void visitI2D(Instruction o) {
        this.stack().pop();
        this.stack().push((Type)Type.DOUBLE);
    }

    @Override
    public void visitI2F(Instruction o) {
        this.stack().pop();
        this.stack().push((Type)Type.FLOAT);
    }

    @Override
    public void visitI2L(Instruction o) {
        this.stack().pop();
        this.stack().push((Type)Type.LONG);
    }

    @Override
    public void visitI2S(Instruction o) {
        this.stack().pop();
        this.stack().push((Type)Type.INT);
    }

    @Override
    public void visitIADD(Instruction o) {
        this.stack().pop();
        this.stack().pop();
        this.stack().push((Type)Type.INT);
    }

    @Override
    public void visitIALOAD(Instruction o) {
        this.stack().pop();
        this.stack().pop();
        this.stack().push((Type)Type.INT);
    }

    @Override
    public void visitIAND(Instruction o) {
        this.stack().pop();
        this.stack().pop();
        this.stack().push((Type)Type.INT);
    }

    @Override
    public void visitIASTORE(Instruction o) {
        this.stack().pop();
        this.stack().pop();
        this.stack().pop();
    }

    @Override
    public void visitICONST(Instruction o) {
        this.stack().push((Type)Type.INT);
    }

    @Override
    public void visitIDIV(Instruction o) {
        this.stack().pop();
        this.stack().pop();
        this.stack().push((Type)Type.INT);
    }

    @Override
    public void visitIF_ACMPEQ(Instruction o) {
        this.stack().pop();
        this.stack().pop();
    }

    @Override
    public void visitIF_ACMPNE(Instruction o) {
        this.stack().pop();
        this.stack().pop();
    }

    @Override
    public void visitIF_ICMPEQ(Instruction o) {
        this.stack().pop();
        this.stack().pop();
    }

    @Override
    public void visitIF_ICMPGE(Instruction o) {
        this.stack().pop();
        this.stack().pop();
    }

    @Override
    public void visitIF_ICMPGT(Instruction o) {
        this.stack().pop();
        this.stack().pop();
    }

    @Override
    public void visitIF_ICMPLE(Instruction o) {
        this.stack().pop();
        this.stack().pop();
    }

    @Override
    public void visitIF_ICMPLT(Instruction o) {
        this.stack().pop();
        this.stack().pop();
    }

    @Override
    public void visitIF_ICMPNE(Instruction o) {
        this.stack().pop();
        this.stack().pop();
    }

    @Override
    public void visitIFEQ(Instruction o) {
        this.stack().pop();
    }

    @Override
    public void visitIFGE(Instruction o) {
        this.stack().pop();
    }

    @Override
    public void visitIFGT(Instruction o) {
        this.stack().pop();
    }

    @Override
    public void visitIFLE(Instruction o) {
        this.stack().pop();
    }

    @Override
    public void visitIFLT(Instruction o) {
        this.stack().pop();
    }

    @Override
    public void visitIFNE(Instruction o) {
        this.stack().pop();
    }

    @Override
    public void visitIFNONNULL(Instruction o) {
        this.stack().pop();
    }

    @Override
    public void visitIFNULL(Instruction o) {
        this.stack().pop();
    }

    @Override
    public void visitIINC(IINC o) {
    }

    @Override
    public void visitILOAD(Instruction o) {
        this.stack().push((Type)Type.INT);
    }

    @Override
    public void visitIMUL(Instruction o) {
        this.stack().pop();
        this.stack().pop();
        this.stack().push((Type)Type.INT);
    }

    @Override
    public void visitINEG(Instruction o) {
        this.stack().pop();
        this.stack().push((Type)Type.INT);
    }

    @Override
    public void visitINSTANCEOF(Instruction o) {
        this.stack().pop();
        this.stack().push((Type)Type.INT);
    }

    @Override
    public void visitINVOKEINTERFACE(INVOKEINTERFACE o) {
        this.stack().pop();
        int i = 0;
        while (i < o.getArgumentTypes(this.cpg).length) {
            this.stack().pop();
            ++i;
        }
        if (o.getReturnType(this.cpg) != Type.VOID) {
            Type t = o.getReturnType(this.cpg);
            if (t.equals(Type.BOOLEAN) || t.equals(Type.CHAR) || t.equals(Type.BYTE) || t.equals(Type.SHORT)) {
                t = Type.INT;
            }
            this.stack().push(t);
        }
    }

    @Override
    public void visitINVOKESPECIAL(InvokeInstruction o) {
        if (o.getMethodName(this.cpg).equals("<init>")) {
            UninitializedObjectType t = (UninitializedObjectType)this.stack().peek(o.getArgumentTypes(this.cpg).length);
            if (t == Frame._this) {
                Frame._this = null;
            }
            this.stack().initializeObject(t);
            this.locals().initializeObject(t);
        }
        this.stack().pop();
        int i = 0;
        while (i < o.getArgumentTypes(this.cpg).length) {
            this.stack().pop();
            ++i;
        }
        if (o.getReturnType(this.cpg) != Type.VOID) {
            Type t = o.getReturnType(this.cpg);
            if (t.equals(Type.BOOLEAN) || t.equals(Type.CHAR) || t.equals(Type.BYTE) || t.equals(Type.SHORT)) {
                t = Type.INT;
            }
            this.stack().push(t);
        }
    }

    @Override
    public void visitINVOKESTATIC(InvokeInstruction o) {
        int i = 0;
        while (i < o.getArgumentTypes(this.cpg).length) {
            this.stack().pop();
            ++i;
        }
        if (o.getReturnType(this.cpg) != Type.VOID) {
            Type t = o.getReturnType(this.cpg);
            if (t.equals(Type.BOOLEAN) || t.equals(Type.CHAR) || t.equals(Type.BYTE) || t.equals(Type.SHORT)) {
                t = Type.INT;
            }
            this.stack().push(t);
        }
    }

    @Override
    public void visitINVOKEVIRTUAL(InvokeInstruction o) {
        this.stack().pop();
        int i = 0;
        while (i < o.getArgumentTypes(this.cpg).length) {
            this.stack().pop();
            ++i;
        }
        if (o.getReturnType(this.cpg) != Type.VOID) {
            Type t = o.getReturnType(this.cpg);
            if (t.equals(Type.BOOLEAN) || t.equals(Type.CHAR) || t.equals(Type.BYTE) || t.equals(Type.SHORT)) {
                t = Type.INT;
            }
            this.stack().push(t);
        }
    }

    @Override
    public void visitIOR(Instruction o) {
        this.stack().pop();
        this.stack().pop();
        this.stack().push((Type)Type.INT);
    }

    @Override
    public void visitIREM(Instruction o) {
        this.stack().pop();
        this.stack().pop();
        this.stack().push((Type)Type.INT);
    }

    @Override
    public void visitIRETURN(Instruction o) {
        this.stack().pop();
    }

    @Override
    public void visitISHL(Instruction o) {
        this.stack().pop();
        this.stack().pop();
        this.stack().push((Type)Type.INT);
    }

    @Override
    public void visitISHR(Instruction o) {
        this.stack().pop();
        this.stack().pop();
        this.stack().push((Type)Type.INT);
    }

    @Override
    public void visitISTORE(Instruction o) {
        this.locals().set(o.getIndex(), this.stack().pop());
    }

    @Override
    public void visitISUB(Instruction o) {
        this.stack().pop();
        this.stack().pop();
        this.stack().push((Type)Type.INT);
    }

    @Override
    public void visitIUSHR(Instruction o) {
        this.stack().pop();
        this.stack().pop();
        this.stack().push((Type)Type.INT);
    }

    @Override
    public void visitIXOR(Instruction o) {
        this.stack().pop();
        this.stack().pop();
        this.stack().push((Type)Type.INT);
    }

    @Override
    public void visitJSR(InstructionBranch o) {
        this.stack().push((Type)new ReturnaddressType(o.physicalSuccessor()));
    }

    @Override
    public void visitJSR_W(InstructionBranch o) {
        this.stack().push((Type)new ReturnaddressType(o.physicalSuccessor()));
    }

    @Override
    public void visitL2D(Instruction o) {
        this.stack().pop();
        this.stack().push((Type)Type.DOUBLE);
    }

    @Override
    public void visitL2F(Instruction o) {
        this.stack().pop();
        this.stack().push((Type)Type.FLOAT);
    }

    @Override
    public void visitL2I(Instruction o) {
        this.stack().pop();
        this.stack().push((Type)Type.INT);
    }

    @Override
    public void visitLADD(Instruction o) {
        this.stack().pop();
        this.stack().pop();
        this.stack().push((Type)Type.LONG);
    }

    @Override
    public void visitLALOAD(Instruction o) {
        this.stack().pop();
        this.stack().pop();
        this.stack().push((Type)Type.LONG);
    }

    @Override
    public void visitLAND(Instruction o) {
        this.stack().pop();
        this.stack().pop();
        this.stack().push((Type)Type.LONG);
    }

    @Override
    public void visitLASTORE(Instruction o) {
        this.stack().pop();
        this.stack().pop();
        this.stack().pop();
    }

    @Override
    public void visitLCMP(Instruction o) {
        this.stack().pop();
        this.stack().pop();
        this.stack().push((Type)Type.INT);
    }

    @Override
    public void visitLCONST(Instruction o) {
        this.stack().push((Type)Type.LONG);
    }

    @Override
    public void visitLDC(Instruction o) {
        Constant c = this.cpg.getConstant(o.getIndex());
        if (c instanceof ConstantInteger) {
            this.stack().push((Type)Type.INT);
        }
        if (c instanceof ConstantFloat) {
            this.stack().push((Type)Type.FLOAT);
        }
        if (c instanceof ConstantString) {
            this.stack().push((Type)Type.STRING);
        }
    }

    public void visitLDC_W(Instruction o) {
        Constant c = this.cpg.getConstant(o.getIndex());
        if (c instanceof ConstantInteger) {
            this.stack().push((Type)Type.INT);
        }
        if (c instanceof ConstantFloat) {
            this.stack().push((Type)Type.FLOAT);
        }
        if (c instanceof ConstantString) {
            this.stack().push((Type)Type.STRING);
        }
    }

    @Override
    public void visitLDC2_W(Instruction o) {
        Constant c = this.cpg.getConstant(o.getIndex());
        if (c instanceof ConstantLong) {
            this.stack().push((Type)Type.LONG);
        }
        if (c instanceof ConstantDouble) {
            this.stack().push((Type)Type.DOUBLE);
        }
    }

    @Override
    public void visitLDIV(Instruction o) {
        this.stack().pop();
        this.stack().pop();
        this.stack().push((Type)Type.LONG);
    }

    @Override
    public void visitLLOAD(Instruction o) {
        this.stack().push(this.locals().get(o.getIndex()));
    }

    @Override
    public void visitLMUL(Instruction o) {
        this.stack().pop();
        this.stack().pop();
        this.stack().push((Type)Type.LONG);
    }

    @Override
    public void visitLNEG(Instruction o) {
        this.stack().pop();
        this.stack().push((Type)Type.LONG);
    }

    @Override
    public void visitLOOKUPSWITCH(LOOKUPSWITCH o) {
        this.stack().pop();
    }

    @Override
    public void visitLOR(Instruction o) {
        this.stack().pop();
        this.stack().pop();
        this.stack().push((Type)Type.LONG);
    }

    @Override
    public void visitLREM(Instruction o) {
        this.stack().pop();
        this.stack().pop();
        this.stack().push((Type)Type.LONG);
    }

    @Override
    public void visitLRETURN(Instruction o) {
        this.stack().pop();
    }

    @Override
    public void visitLSHL(Instruction o) {
        this.stack().pop();
        this.stack().pop();
        this.stack().push((Type)Type.LONG);
    }

    @Override
    public void visitLSHR(Instruction o) {
        this.stack().pop();
        this.stack().pop();
        this.stack().push((Type)Type.LONG);
    }

    @Override
    public void visitLSTORE(Instruction o) {
        this.locals().set(o.getIndex(), this.stack().pop());
        this.locals().set(o.getIndex() + 1, Type.UNKNOWN);
    }

    @Override
    public void visitLSUB(Instruction o) {
        this.stack().pop();
        this.stack().pop();
        this.stack().push((Type)Type.LONG);
    }

    @Override
    public void visitLUSHR(Instruction o) {
        this.stack().pop();
        this.stack().pop();
        this.stack().push((Type)Type.LONG);
    }

    @Override
    public void visitLXOR(Instruction o) {
        this.stack().pop();
        this.stack().pop();
        this.stack().push((Type)Type.LONG);
    }

    @Override
    public void visitMONITORENTER(Instruction o) {
        this.stack().pop();
    }

    @Override
    public void visitMONITOREXIT(Instruction o) {
        this.stack().pop();
    }

    @Override
    public void visitMULTIANEWARRAY(MULTIANEWARRAY o) {
        int i = 0;
        while (i < o.getDimensions()) {
            this.stack().pop();
            ++i;
        }
        this.stack().push(o.getType(this.cpg));
    }

    @Override
    public void visitNEW(Instruction o) {
        this.stack().push((Type)new UninitializedObjectType((ObjectType)o.getType(this.cpg)));
    }

    @Override
    public void visitNEWARRAY(Instruction o) {
        this.stack().pop();
        this.stack().push(((InstructionByte)o).getType());
    }

    @Override
    public void visitNOP(Instruction o) {
    }

    @Override
    public void visitPOP(Instruction o) {
        this.stack().pop();
    }

    @Override
    public void visitPOP2(Instruction o) {
        Type t = this.stack().pop();
        if (t.getSize() == 1) {
            this.stack().pop();
        }
    }

    @Override
    public void visitPUTFIELD(FieldInstruction o) {
        this.stack().pop();
        this.stack().pop();
    }

    @Override
    public void visitPUTSTATIC(FieldInstruction o) {
        this.stack().pop();
    }

    @Override
    public void visitRET(RET o) {
    }

    @Override
    public void visitRETURN(Instruction o) {
    }

    @Override
    public void visitSALOAD(Instruction o) {
        this.stack().pop();
        this.stack().pop();
        this.stack().push((Type)Type.INT);
    }

    @Override
    public void visitSASTORE(Instruction o) {
        this.stack().pop();
        this.stack().pop();
        this.stack().pop();
    }

    @Override
    public void visitSIPUSH(Instruction o) {
        this.stack().push((Type)Type.INT);
    }

    @Override
    public void visitSWAP(Instruction o) {
        Type t = this.stack().pop();
        Type u = this.stack().pop();
        this.stack().push(t);
        this.stack().push(u);
    }

    @Override
    public void visitTABLESWITCH(TABLESWITCH o) {
        this.stack().pop();
    }
}

