/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.plugins;

import java.net.URL;
import org.eclipse.core.internal.model.RegistryLoader;
import org.eclipse.core.internal.plugins.PluginRegistry;
import org.eclipse.core.internal.plugins.Policy;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IPluginRegistry;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.model.Factory;
import org.eclipse.core.runtime.model.PluginRegistryModel;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;

public class InternalPlatform {
    private static IPluginRegistry registry = null;

    public static IPluginRegistry getPluginRegistry() {
        if (registry == null) {
            registry = new PluginRegistry();
        }
        return registry;
    }

    public static IPluginDescriptor getPluginDescriptor(String pluginId) {
        return InternalPlatform.getPluginRegistry().getPluginDescriptor(pluginId);
    }

    public static void installPlugins(URL[] installURLs) throws CoreException {
        String message = Policy.bind("platform.errorInstalling");
        MultiStatus result = new MultiStatus("org.eclipse.core.runtime", 0, message, null);
        BundleContext context = org.eclipse.core.internal.runtime.InternalPlatform.getDefault().getBundleContext();
        int i = 0;
        while (i < installURLs.length) {
            try {
                context.installBundle(installURLs[i].toExternalForm());
            }
            catch (BundleException e) {
                Status status = new Status(4, "org.eclipse.core.runtime", 0, Policy.bind("platform.cannotInstallPlugin", installURLs[i].toExternalForm()), e);
                result.merge(status);
            }
            ++i;
        }
        if (!result.isOK()) {
            throw new CoreException(result);
        }
    }

    public static PluginRegistryModel parsePlugins(URL[] pluginPath, Factory factory) {
        return InternalPlatform.parsePlugins(pluginPath, factory, false);
    }

    public static synchronized PluginRegistryModel parsePlugins(URL[] pluginPath, Factory factory, boolean debug) {
        return RegistryLoader.parseRegistry(pluginPath, factory, debug);
    }
}

