# gopls/v0.17.0

<!-- TODO: update this unstruction once v0.17.0 is released

    Also, tweak the img URLs when publishing to GitHub Releases.
-->

```
go install golang.org/x/tools/gopls@v0.17.0-pre.4
```

# New support policies

With this release, we are narrowing our official support window to align with
the [Go support policy](https://go.dev/doc/devel/release#policy). This will
reduce the considerable costs to us of testing against older Go versions,
allowing us to spend more time fixing bugs and adding features that benefit the
majority of gopls users who run recent versions of Go.

This narrowing is occuring in two dimensions: **build compatibility** refers to
the versions of the Go toolchain that can be used to build gopls, and **go
command compatibility** refers to the versions of the `go` command that can be
used by gopls to list information about packages and modules in your workspace.

## Build compatibility: the most recent major Go version

As described in the [v0.16.0 release
notes](https://github.com/golang/tools/releases/tag/gopls%2Fv0.16.0), building the
latest version of gopls will now require the latest major version of the Go
toolchain. Therefore this release (gopls@v0.17.0) must be built with Go 1.23.0
or later. Thanks to [automatic toolchain
upgrades](https://go.dev/blog/toolchain), if your system Go version is at least
Go 1.21.0 and you have `GOTOOLCHAIN=auto` set (the default), the `go` command
will automatically download the new Go toolchain as needed, similar to
upgrading a module dependency.

## Go command compatibility: the 2 most recent major Go versions

The gopls@v0.17.x releases will be the final versions of gopls to nominally
support integrating with more than the 2 most recent Go releases. In the past,
we implied "best effort" support for up to 4 versions, though in practice we
did not have resources to fix bugs that were present only with older Go
versions. With gopls@v0.17.0, we narrowed this best effort support to 3
versions, primarily because users need at least Go 1.21 to benefit from
automatic toolchain upgrades (see above).

Starting with gopls@v0.18.0, we will officially support integrating with only
the 2 most recent major versions of the `go` command. This is consistent with
the Go support policy. See golang/go#69321 (or [this
comment](https://github.com/golang/go/issues/69321#issuecomment-2344996677)
specifically) for details.

We won't prevent gopls from being used with older Go versions (just as we
don't disallow integration with arbitrary
[`go/packages`](https://pkg.go.dev/golang.org/x/tools/go/packages) drivers),
but we won't run integration tests against older Go versions, and won't fix
bugs that are only present when used with old Go versions.

# Configuration Changes

- The `fieldalignment` analyzer, previously disabled by default, has
  been removed: it is redundant with the hover size/offset information
  displayed by v0.16.0 and its diagnostics were confusing.
- The `undeclaredname` analyzer has been replaced with an ordinary code action.
- The kind (identifiers) of all of gopls' code actions have changed
  to use more specific hierarchical names. For example, "Inline call"
  has changed from `refactor.inline` to `refactor.inline.call`.
  This allows clients to request particular code actions more precisely.
  The user manual now includes the identifier in the documentation for each code action.
- The experimental `allowImplicitNetworkAccess` setting is removed, following
  its deprecation in gopls@v0.16.0. See golang/go#66861 for details.

# New features

## Refactoring

This release contains a number of new features related to refactoring.
Additionally, it fixes [many
bugs](https://github.com/golang/go/issues?q=is%3Aissue+milestone%3Agopls%2Fv0.17.0+label%3ARefactoring+is%3Aclosed)
in existing refactoring operations, primarily related to **extract**, and **inline**.

These improvements move us toward a longer term goal of offering a more robust
and complete set of refactoring tools. We still have [much to
do](https://github.com/golang/go/issues?q=is%3Aissue+label%3Agopls+label%3ARefactoring+is%3Aopen+),
and this effort will continue into 2025.

### Move parameter refactorings

Gopls now offers code actions to move function and method parameters left or
right in the function signature, updating all callers.

Unfortunately, there is no native LSP operation that provides a good user
interface for arbitrary "change signature" refactoring. We plan to build such
an interface within VS Code. In the short term, we have made it possible to
express more complicated parameter transformations by invoking 'rename' on the
'func' keyword. This user interface is a temporary stop-gap until a better
mechanism is available for LSP commands that enable client-side dialogs.

### Extract declarations to new file

Gopls now offers another code action,
"Extract declarations to new file" (`refactor.extract.toNewFile`),
which moves selected code sections to a newly created file within the
same package. The created filename is chosen as the first {function, type,
const, var} name encountered. In addition, import declarations are added or
removed as needed.

The user can invoke this code action by selecting a function name, the keywords
`func`, `const`, `var`, `type`, or by placing the caret on them without selecting,
or by selecting a whole declaration or multiple declarations.

In order to avoid ambiguity and surprise about what to extract, some kinds
of paritial selection of a declaration cannot invoke this code action.

### Extract constant

When the selection is a constant expression, gopls now offers "Extract
constant" instead of "Extract variable", and generates a `const`
declaration instead of a local variable.

Also, extraction of a constant or variable now works at top-level,
outside of any function.

### Generate missing method from function call

When you attempt to call a method on a type that lacks that method, the
compiler will report an error like “type T has no field or method f”. Gopls now
offers a new code action, “Declare missing method of T.f”, where T is the
concrete type and f is the undefined method. The stub method's signature is
inferred from the context of the call.

### Generate a test for a function or method

If the selected chunk of code is part of a function or method declaration F,
gopls will offer the "Add test for F" code action, which adds a new test for the
selected function in the corresponding `_test.go` file. The generated test takes
into account its signature, including input parameters and results.

Since this feature is implemented by the server (gopls), it is compatible with
all LSP-compliant editors. VS Code users may continue to use the client-side
`Go: Generate Unit Tests For file/function/package` command, which runs the
[gotests](https://github.com/cweill/gotests) tool.

## Initial support for pull diagnostics

When initialized with the option `"pullDiagnostics": true`, gopls will advertise support for the
`textDocument.diagnostic`
[client capability](https://microsoft.github.io/language-server-protocol/specifications/lsp/3.17/specification/#textDocument_pullDiagnostics),
which allows editors to request diagnostics directly from gopls using a
`textDocument/diagnostic` request, rather than wait for a
`textDocument/publishDiagnostics` notification. This feature is off by default
until the feature set of pull diagnostics is comparable to push diagnostics.

## Hover improvements

The `textDocument/hover` response has slightly tweaked markdown rendering, and
includes the following additional information:

- Hovering over a standard library symbol now displays information about the
  first Go release containing the symbol. For example, hovering over
  `errors.As` shows "Added in go1.13".
- Hovering over the package name in a package declaration includes additional
  package metadata.

## Semantic token modifiers of top-level constructor of types

The semantic tokens response now includes additional modifiers for the top-level
constructor of the type of each symbol:
`interface`, `struct`, `signature`, `pointer`, `array`, `map`, `slice`, `chan`, `string`, `number`, `bool`, and `invalid`.
Editors may use this for syntax coloring.

## SignatureHelp for ident and values.

Now, function signature help can be used on any identifier with a function
signature, not just within the parentheses of a function being called.

## Jump to assembly definition

A Definition query on a reference to a function jumps to the
function's Go `func` declaration. If the function is implemented in C
or assembly, the function has no body. Executing a second Definition
query (while already at the Go declaration) will navigate you to the
assembly implementation.

## `yield` analyzer

The new `yield` analyzer detects mistakes using the `yield` function
in a Go 1.23 iterator, such as failure to check its boolean result and
break out of a loop.

## `waitgroup` analyzer

The new `waitgroup` analyzer detects calls to the `Add` method of
`sync.WaitGroup` that are (mistakenly) made within the new goroutine,
causing `Add` to race with `Wait`.
(This check is equivalent to
[staticcheck's SA2000](https://staticcheck.dev/docs/checks#SA2000),
but is enabled by default.)
